﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fssystem/fs_DeltaHeader.h>

#include <msclr/marshal.h>

namespace Nintendo { namespace Authoring { namespace FileSystemMetaLibrary {

    using namespace System;
    using namespace System::Collections;
    using namespace System::Runtime::InteropServices;
    using namespace msclr::interop;
    using namespace nn::fssystem;

    public ref class DeltaMeta
    {
    public:
        literal Int32 CommandTypeWrite = static_cast<Int32>(DeltaCommandType::Write);

        static Int32 GetHeaderSize()
        {
            return DeltaHeader::Size;
        }

        static array<Byte>^ CreateHeader(
            System::Int64 sourceSize,
            System::Int64 destinationSize,
            System::Int64 bodySize
            )
        {
            array<unsigned char>^ buf = gcnew array<unsigned char>(GetHeaderSize());
            pin_ptr<unsigned char> ptr = &buf[0];
            auto* header = reinterpret_cast<DeltaHeader*>(ptr);

            std::memset(header, 0, sizeof(GetHeaderSize()));

            header->sizeSource = sourceSize;
            header->sizeDestination = destinationSize;
            header->offsetBody = DeltaHeader::Size;
            header->sizeBody = bodySize;
            header->signature = static_cast<uint32_t>(DeltaHeader::Signature::V0);

            return buf;
        }

        static System::Int32 GetWriteCommandSize(System::Int64 offset, System::Int64 size)
        {
            return DeltaCommandWrite::GetCommandSize(offset, size);
        }

        static array<Byte>^ CreateWriteCommand(System::Int64 offset, System::Int64 size)
        {
            auto bufferLength = GetWriteCommandSize(offset, size);
            array<unsigned char>^ buffer = gcnew array<unsigned char>(bufferLength);
            pin_ptr<unsigned char> pinnedBuffer = &buffer[0];
            DeltaCommandWrite::Create(reinterpret_cast<char*>(pinnedBuffer), buffer->Length, offset, size);
            return buffer;
        }

        static array<Byte>^ CreateSeekCommand(System::Int64 size)
        {
            return CreateWriteCommand(size, 0);
        }

        static bool MemoryCompare(
            ArraySegment<byte>^ source,
            ArraySegment<byte>^ destination,
            int offset,
            int size)
        {
            pin_ptr<unsigned char> pSource = &source->Array[0];
            pin_ptr<unsigned char> pDestination = &destination->Array[0];

            int64_t* pLongSource = reinterpret_cast<int64_t*>(pSource + source->Offset + offset);
            int64_t* pLongDestination = reinterpret_cast<int64_t*>(pDestination + destination->Offset + offset);

            if (size >= 8)
            {
                for (; size >= 8; size -= 8)
                {
                    if (*pLongSource != *pLongDestination)
                    {
                        return false;
                    }
                    ++pLongSource;
                    ++pLongDestination;
                }
            }

            int32_t* pIntSource = reinterpret_cast<int32_t*>(pLongSource);
            int32_t* pIntDestination = reinterpret_cast<int32_t*>(pLongDestination);

            if (size >= 4)
            {
                for (; size >= 4; size -= 4)
                {
                    if (*pIntSource != *pIntDestination)
                    {
                        return false;
                    }
                    ++pIntSource;
                    ++pIntDestination;
                }
            }

            unsigned char* pByteSource = reinterpret_cast<unsigned char*>(pIntSource);
            unsigned char* pByteDestination = reinterpret_cast<unsigned char*>(pIntDestination);
            for (; size > 0; size--)
            {
                if (*pByteSource != *pByteDestination)
                {
                    return false;
                }
                ++pByteSource;
                ++pByteDestination;
            }

            return true;
        }
    };

} } }
