﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace Nintendo { namespace Authoring { namespace FileSystemMetaLibrary {

using namespace System;
using namespace System::IO;

class AesCtrExGenerationTableImpl;

// AesCtrEx の世代テーブル (暗号化時に使用)
public ref class AesCtrExGenerationTable
{
public:
    value class GenerationEntry
    {
    public:
        GenerationEntry(Int32 inSize, UInt32 inGeneration)
            : size(inSize)
            , generation(inGeneration)
        {
        }

    public:
        Int32 size;
        UInt32 generation;
    };

public:
    AesCtrExGenerationTable(array<Byte>^ headerBuffer, array<Byte>^ tableBuffer);
    ~AesCtrExGenerationTable();
    !AesCtrExGenerationTable();

    Collections::Generic::List<GenerationEntry>^ GetGenerations(Int64 offset, Int32 size, UInt32 generationForOutOfTable);

    AesCtrExGenerationTableImpl* m_pImpl;
};

}}}
