﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "IEncryptor.h"

namespace Nintendo { namespace Authoring { namespace CryptoLibrary {

using namespace System;

    public ref class DummyCryptoDriver : IEncryptor, IXtsModeEncryptor, ICtrModeEncryptor, ICbcModeEncryptor, ICcmModeEncryptor
    {
    public:
        property int KeySize
        {
            virtual int get() { return 16; }
        };

        virtual void EncryptBlock(array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ dst, int dstOffset)
        {
            Buffer::BlockCopy(src, srcOffset, dst, dstOffset, srcSize);
            GC::KeepAlive(this);
        }

        virtual void DecryptBlock(array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ dst, int dstOffset)
        {
            Buffer::BlockCopy(src, srcOffset, dst, dstOffset, srcSize);
            GC::KeepAlive(this);
        }

        virtual void EncryptBlock(array<Byte>^ iv, array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ dst, int dstOffset)
        {
            return EncryptBlock(src, srcOffset, srcSize, dst, dstOffset);
        }

        virtual void DecryptBlock(array<Byte>^ iv, array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ dst, int dstOffset)
        {
            return DecryptBlock(src, srcOffset, srcSize, dst, dstOffset);
        }

        virtual void EncryptBlock(array<Byte>^ nonce, array<Byte>^ aad, array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ dstMac, int dstMacOffset, int macSize, array<Byte>^ dst, int dstOffset)
        {
            return EncryptBlock(src, srcOffset, srcSize, dst, dstOffset);
        }

        virtual void DecryptBlock(array<Byte>^ nonce, array<Byte>^ aad, array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ dstMac, int dstMacOffset, int macSize, array<Byte>^ dst, int dstOffset)
        {
            return DecryptBlock(src, srcOffset, srcSize, dst, dstOffset);
        }
    };

}}}
