﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;

namespace Nintendo.Authoring.AuthoringLibrary
{
    public class UnpublishableApiList
    {
        // 使用禁止のDebug APIリスト（マングルされた文字列とマングル前の文字列）
        // 外部ファイルに保存すると利用者が使用禁止のAPIを見れてしまう為プログラム内に保持する
        // by debug_api-list_20180301.xml
        public static readonly Dictionary<string, string> UnpublishableDebugApiTable =
            new Dictionary<string, string>()
            {
                { "_ZN2nn3fgm8DebuggerC2ERKS1_", "nn::fgm::Debugger::Debugger(nn::fgm::Debugger const&)" },
                { "_ZN2nn3fgm8DebuggerC1ERKS1_", "nn::fgm::Debugger::Debugger(nn::fgm::Debugger const&)" },
                { "_ZN2nn3fgm8DebuggeraSERKS1_", "nn::fgm::Debugger::operator=(nn::fgm::Debugger const&)" },
                { "_ZN2nn3fgm8DebuggerC2EOS1_", "nn::fgm::Debugger::Debugger(nn::fgm::Debugger&&)" },
                { "_ZN2nn3fgm8DebuggerC1EOS1_", "nn::fgm::Debugger::Debugger(nn::fgm::Debugger&&)" },
                { "_ZN2nn3fgm8DebuggeraSEOS1_", "nn::fgm::Debugger::operator=(nn::fgm::Debugger&&)" },
                { "_ZN2nn3fgm8Debugger10InitializeEPvmNS_2os14EventClearModeE", "nn::fgm::Debugger::Initialize(void*, unsigned long, nn::os::EventClearMode)" },
                { "_ZN2nn3fgm8Debugger10InitializeEPvm", "nn::fgm::Debugger::Initialize(void*, unsigned long)" },
                { "_ZN2nn3fgm8Debugger4WaitEv", "nn::fgm::Debugger::Wait()" },
                { "_ZN2nn3fgm8Debugger15WaitWithTimeoutENS_8TimeSpanE", "nn::fgm::Debugger::WaitWithTimeout(nn::TimeSpan)" },
                { "_ZN2nn3fgm8Debugger21GetSystemEventPointerEv", "nn::fgm::Debugger::GetSystemEventPointer()" },
                { "_ZN2nn3fgm8Debugger10ClearEventEv", "nn::fgm::Debugger::ClearEvent()" },
                { "_ZN2nn3fgm8Debugger6CancelEv", "nn::fgm::Debugger::Cancel()" },
                { "_ZN2nn3fgm8Debugger4ReadEPNS0_10DebugEntryEjPjS4_S4_", "nn::fgm::Debugger::Read(nn::fgm::DebugEntry*, unsigned int, unsigned int*, unsigned int*, unsigned int*)" },
                { "_ZN2nn3fgm8Debugger8FinalizeEv", "nn::fgm::Debugger::Finalize()" },
                { "_ZN2nn3fgm8DebuggerC2Ev", "nn::fgm::Debugger::Debugger()" },
                { "_ZN2nn3fgm8DebuggerC1Ev", "nn::fgm::Debugger::Debugger()" },
                { "_ZN2nn3fgm8DebuggerD2Ev", "nn::fgm::Debugger::~Debugger()" },
                { "_ZN2nn3fgm8DebuggerD1Ev", "nn::fgm::Debugger::~Debugger()" },
                { "_ZN2nn3fgm8Debugger10InitializeEPvjNS_2os14EventClearModeE", "nn::fgm::Debugger::Initialize(void*, unsigned int, nn::os::EventClearMode)" },
                { "_ZN2nn3fgm8Debugger10InitializeEPvj", "nn::fgm::Debugger::Initialize(void*, unsigned int)" },
                { "_ZN2nn2fs9MountHostEPKcS2_", "nn::fs::MountHost(char const*, char const*)" },
                { "_ZN2nn2fs13MountHostRootEv", "nn::fs::MountHostRoot()" },
                { "_ZN2nn2fs15UnmountHostRootEv", "nn::fs::UnmountHostRoot()" },
                { "_ZN2nn2fs19CanMountRomForDebugEv", "nn::fs::CanMountRomForDebug()" },
                { "_ZN2nn2fs19MountSdCardForDebugEPKc", "nn::fs::MountSdCardForDebug(char const*)" },
                { "_ZN2nn2fs19SetSaveDataRootPathEPKc", "nn::fs::SetSaveDataRootPath(char const*)" },
                { "_ZN2nn2fs21MountSaveDataForDebugEPKc", "nn::fs::MountSaveDataForDebug(char const*)" },
                { "_ZN2nn3pcm10InitializeEv", "nn::pcm::Initialize()" },
                { "_ZN2nn3pcm8FinalizeEv", "nn::pcm::Finalize()" },
                { "_ZN2nn3pcm11IsSupportedENS0_14MeasuringPointE", "nn::pcm::IsSupported(nn::pcm::MeasuringPoint)" },
                { "_ZN2nn3pcm16ReadCurrentPowerENS0_14MeasuringPointE", "nn::pcm::ReadCurrentPower(nn::pcm::MeasuringPoint)" },
                { "_ZN2nn2oe28GetLaunchStorageInfoForDebugEPNS0_25LaunchStorageInfoForDebugE", "nn::oe::GetLaunchStorageInfoForDebug(nn::oe::LaunchStorageInfoForDebug*)" },
                { "_ZN2nn2oe30RequestToSaveRecordingForDebugEv", "nn::oe::RequestToSaveRecordingForDebug()" },
                { "_ZN2nn2oe36RequestFlushGamePlayingMovieForDebugEv", "nn::oe::RequestFlushGamePlayingMovieForDebug()" },
                { "_ZN2nn4htcs10InitializeEPFPvmEPFvS1_mE", "nn::htcs::Initialize(void* (*)(unsigned long), void (*)(void*, unsigned long))" },
                { "_ZN2nn4htcs10InitializeEPvm", "nn::htcs::Initialize(void*, unsigned long)" },
                { "_ZN2nn4htcs8FinalizeEv", "nn::htcs::Finalize()" },
                { "_ZN2nn4htcs13IsInitializedEv", "nn::htcs::IsInitialized()" },
                { "_ZN2nn4htcs20GetWorkingMemorySizeEi", "nn::htcs::GetWorkingMemorySize(int)" },
                { "_ZN2nn4htcs10InitializeEPFPvjEPFvS1_jE", "nn::htcs::Initialize(void* (*)(unsigned int), void (*)(void*, unsigned int))" },
                { "_ZN2nn4htcs10InitializeEPvj", "nn::htcs::Initialize(void*, unsigned int)" },
                { "_ZN2nn4htcs6SocketEv", "nn::htcs::Socket()" },
                { "_ZN2nn4htcs5CloseEi", "nn::htcs::Close(int)" },
                { "_ZN2nn4htcs7ConnectEiPKNS0_12SockAddrHtcsE", "nn::htcs::Connect(int, nn::htcs::SockAddrHtcs const*)" },
                { "_ZN2nn4htcs4BindEiPKNS0_12SockAddrHtcsE", "nn::htcs::Bind(int, nn::htcs::SockAddrHtcs const*)" },
                { "_ZN2nn4htcs6ListenEii", "nn::htcs::Listen(int, int)" },
                { "_ZN2nn4htcs6AcceptEiPNS0_12SockAddrHtcsE", "nn::htcs::Accept(int, nn::htcs::SockAddrHtcs*)" },
                { "_ZN2nn4htcs4RecvEiPvmi", "nn::htcs::Recv(int, void*, unsigned long, int)" },
                { "_ZN2nn4htcs4SendEiPKvmi", "nn::htcs::Send(int, void const*, unsigned long, int)" },
                { "_ZN2nn4htcs8ShutdownEii", "nn::htcs::Shutdown(int, int)" },
                { "_ZN2nn4htcs5FcntlEiii", "nn::htcs::Fcntl(int, int, int)" },
                { "_ZN2nn4htcs12GetLastErrorEv", "nn::htcs::GetLastError()" },
                { "_ZN2nn4htcs14GetPeerNameAnyEv", "nn::htcs::GetPeerNameAny()" },
                { "_ZN2nn4htcs18GetDefaultHostNameEv", "nn::htcs::GetDefaultHostName()" },
                { "_ZN2nn4htcs4RecvEiPvji", "nn::htcs::Recv(int, void*, unsigned int, int)" },
                { "_ZN2nn4htcs4SendEiPKvji", "nn::htcs::Send(int, void const*, unsigned int, int)" },
                { "_ZN2nn3htc10InitializeEv", "nn::htc::Initialize()" },
                { "_ZN2nn3htc8FinalizeEv", "nn::htc::Finalize()" },
                { "_ZN2nn3htc28GetEnvironmentVariableLengthEPmPKc", "nn::htc::GetEnvironmentVariableLength(unsigned long*, char const*)" },
                { "_ZN2nn3htc22GetEnvironmentVariableEPmPcmPKc", "nn::htc::GetEnvironmentVariable(unsigned long*, char*, unsigned long, char const*)" },
                { "_ZN2nn3htc34GetTargetEnvironmentVariableLengthEPmPKc", "nn::htc::GetTargetEnvironmentVariableLength(unsigned long*, char const*)" },
                { "_ZN2nn3htc28GetTargetEnvironmentVariableEPmPcmPKc", "nn::htc::GetTargetEnvironmentVariable(unsigned long*, char*, unsigned long, char const*)" },
                { "_ZN2nn3htc43WaitUntilTargetEnvironmentVariableAvailableENS_8TimeSpanE", "nn::htc::WaitUntilTargetEnvironmentVariableAvailable(nn::TimeSpan)" },
                { "_ZN2nn3htc23BindHostConnectionEventEPNS_2os11SystemEventE", "nn::htc::BindHostConnectionEvent(nn::os::SystemEvent*)" },
                { "_ZN2nn3htc26BindHostDisconnectionEventEPNS_2os11SystemEventE", "nn::htc::BindHostDisconnectionEvent(nn::os::SystemEvent*)" },
                { "_ZN2nn3htc28GetEnvironmentVariableLengthEPjPKc", "nn::htc::GetEnvironmentVariableLength(unsigned int*, char const*)" },
                { "_ZN2nn3htc22GetEnvironmentVariableEPjPcjPKc", "nn::htc::GetEnvironmentVariable(unsigned int*, char*, unsigned int, char const*)" },
                { "_ZN2nn3htc34GetTargetEnvironmentVariableLengthEPjPKc", "nn::htc::GetTargetEnvironmentVariableLength(unsigned int*, char const*)" },
                { "_ZN2nn3htc28GetTargetEnvironmentVariableEPjPcjPKc", "nn::htc::GetTargetEnvironmentVariable(unsigned int*, char*, unsigned int, char const*)" },
                { "_ZN2nn2os14IsMemoryLockedEPvm", "nn::os::IsMemoryLocked(void*, unsigned long)" },
                { "_ZN2nn2os14IsMemoryLockedEmm", "nn::os::IsMemoryLocked(unsigned long, unsigned long)" },
                { "_ZN2nn2os14IsMemoryLockedEPvj", "nn::os::IsMemoryLocked(void*, unsigned int)" },
                { "_ZN2nn2os14IsMemoryLockedEjj", "nn::os::IsMemoryLocked(unsigned int, unsigned int)" },
                { "_ZN2nn5album23DeleteAlbumFileForDebugERKNS0_14AlbumFileEntryE", "nn::album::DeleteAlbumFileForDebug(nn::album::AlbumFileEntry const&)" },
            };

        // 使用禁止のXpad APIリスト（マングルされた文字列とマングル前の文字列）
        // 外部ファイルに保存すると利用者が使用禁止のAPIを見れてしまう為プログラム内に保持する
        public static readonly Dictionary<string, string> UnpublishableXpadApiTable =
            new Dictionary<string, string>()
            {
                { "_ZN2nn3hid10GetXpadIdsEPNS0_9JoyXpadIdEi", "nn::hid::GetXpadIds(nn::hid::JoyXpadId*, int)" },
                { "_ZN2nn3hid19GetXpadPlayerNumberERKNS0_9JoyXpadIdE", "nn::hid::GetXpadPlayerNumber(nn::hid::JoyXpadId const&)" },
                { "_ZN2nn3hid14InitializeXpadERKNS0_9JoyXpadIdE", "nn::hid::InitializeXpad(nn::hid::JoyXpadId const&)" },
                { "_ZN2nn3hid20GetJoyXpadRightStateEPNS0_12JoyXpadStateERKNS0_9JoyXpadIdE", "nn::hid::GetJoyXpadRightState(nn::hid::JoyXpadState*, nn::hid::JoyXpadId const&)" },
                { "_ZN2nn3hid21GetJoyXpadRightStatesEPNS0_12JoyXpadStateEiRKNS0_9JoyXpadIdE", "nn::hid::GetJoyXpadRightStates(nn::hid::JoyXpadState*, int, nn::hid::JoyXpadId const&)" },
                { "_ZN2nn3hid19GetJoyXpadLeftStateEPNS0_12JoyXpadStateERKNS0_9JoyXpadIdE", "nn::hid::GetJoyXpadLeftState(nn::hid::JoyXpadState*, nn::hid::JoyXpadId const&)" },
                { "_ZN2nn3hid20GetJoyXpadLeftStatesEPNS0_12JoyXpadStateEiRKNS0_9JoyXpadIdE", "nn::hid::GetJoyXpadLeftStates(nn::hid::JoyXpadState*, int, nn::hid::JoyXpadId const&)" },
                { "_ZN2nn3hidL14XpadIdCountMaxE", "nn::hid::XpadIdCountMax" },
                { "_ZN2nn3hidL17XpadStateCountMaxE", "nn::hid::XpadStateCountMax" },
                { "_ZN2nn3hid15BindXpadIdEventEPNS_2os15SystemEventTypeENS1_14EventClearModeE", "nn::hid::BindXpadIdEvent(nn::os::SystemEventType*, nn::os::EventClearMode)" },
                { "_ZN2nn3hid17UnbindXpadIdEventEPNS_2os15SystemEventTypeE", "nn::hid::UnbindXpadIdEvent(nn::os::SystemEventType*)" },
                { "_ZN2nn3hid10GetXpadIdsEPNS0_11BasicXpadIdEi", "nn::hid::GetXpadIds(nn::hid::BasicXpadId*, int)" },
                { "_ZN2nn3hid19GetXpadPlayerNumberERKNS0_11BasicXpadIdE", "nn::hid::GetXpadPlayerNumber(nn::hid::BasicXpadId const&)" },
                { "_ZN2nn3hid14InitializeXpadERKNS0_11BasicXpadIdE", "nn::hid::InitializeXpad(nn::hid::BasicXpadId const&)" },
                { "_ZN2nn3hid12GetXpadStateEPNS0_14BasicXpadStateERKNS0_11BasicXpadIdE", "nn::hid::GetXpadState(nn::hid::BasicXpadState*, nn::hid::BasicXpadId const&)" },
                { "_ZN2nn3hid13GetXpadStatesEPNS0_14BasicXpadStateEiRKNS0_11BasicXpadIdE", "nn::hid::GetXpadStates(nn::hid::BasicXpadState*, int, nn::hid::BasicXpadId const&)" },
            };

        // 使用禁止のPrivate APIリスト
        // 外部ファイルに保存すると利用者が使用禁止のAPIを見れてしまう為プログラム内に保持する
        // by NX_Addon_5_x_NX_Addon_4_x_NX_Addon_3_x_NX_Addon_1_x_NX_Addon_0_12_x_api-list_20180301.xml
        public static readonly Dictionary<string, Dictionary<string, Tuple<string, List<string>>>> UnpublishablePrivateApiTable =
            new Dictionary<string, Dictionary<string, Tuple<string, List<string>>>>()
            {
                {
                    "0", // SDKのメジャーバージョン
                    new Dictionary<string, Tuple<string, List<string>>> // <マングル名,<デマングル名,マングル名に対応するtitleタグのリスト>>
                    {
                        { "_ZN2nn2oe21EndBlockingHomeButtonEv", new Tuple<string, List<string>>("nn::oe::EndBlockingHomeButton()", new List<string>() { "0_12_BundleRules_BlockingHomeButton_NX_BlockingHomeButton" }) },
                        { "_ZN2nn2oe23BeginBlockingHomeButtonENS_8TimeSpanE", new Tuple<string, List<string>>("nn::oe::BeginBlockingHomeButton(nn::TimeSpan)", new List<string>() { "0_12_BundleRules_BlockingHomeButton_NX_BlockingHomeButton" }) },
                        { "_ZN2nn2oe23BeginBlockingHomeButtonEv", new Tuple<string, List<string>>("nn::oe::BeginBlockingHomeButton()", new List<string>() { "0_12_BundleRules_BlockingHomeButton_NX_BlockingHomeButton" }) },
                        { "_ZN2nn3lbl10InitializeEv", new Tuple<string, List<string>>("nn::lbl::Initialize()", new List<string>() { "0_12_BundleRules_BrightnessControlPrivate_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl18LoadCurrentSettingEv", new Tuple<string, List<string>>("nn::lbl::LoadCurrentSetting()", new List<string>() { "0_12_BundleRules_BrightnessControlPrivate_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl18SaveCurrentSettingEv", new Tuple<string, List<string>>("nn::lbl::SaveCurrentSetting()", new List<string>() { "0_12_BundleRules_BrightnessControlPrivate_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl26GetAmbientLightSensorValueEv", new Tuple<string, List<string>>("nn::lbl::GetAmbientLightSensorValue()", new List<string>() { "0_12_BundleRules_BrightnessControlPrivate_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl26SetAmbientLightSensorValueEf", new Tuple<string, List<string>>("nn::lbl::SetAmbientLightSensorValue(float)", new List<string>() { "0_12_BundleRules_BrightnessControlPrivate_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl27EnableAutoBrightnessControlEv", new Tuple<string, List<string>>("nn::lbl::EnableAutoBrightnessControl()", new List<string>() { "0_12_BundleRules_BrightnessControlPrivate_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl27GetCurrentBrightnessMappingEPNS0_18MappingCoefficientE", new Tuple<string, List<string>>("nn::lbl::GetCurrentBrightnessMapping(nn::lbl::MappingCoefficient*)", new List<string>() { "0_12_BundleRules_BrightnessControlPrivate_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl27GetCurrentBrightnessSettingEv", new Tuple<string, List<string>>("nn::lbl::GetCurrentBrightnessSetting()", new List<string>() { "0_12_BundleRules_BrightnessControlPrivate_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl27SetCurrentBrightnessMappingERKNS0_18MappingCoefficientE", new Tuple<string, List<string>>("nn::lbl::SetCurrentBrightnessMapping(nn::lbl::MappingCoefficient const&)", new List<string>() { "0_12_BundleRules_BrightnessControlPrivate_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl27SetCurrentBrightnessSettingEf", new Tuple<string, List<string>>("nn::lbl::SetCurrentBrightnessSetting(float)", new List<string>() { "0_12_BundleRules_BrightnessControlPrivate_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl28DisableAutoBrightnessControlEv", new Tuple<string, List<string>>("nn::lbl::DisableAutoBrightnessControl()", new List<string>() { "0_12_BundleRules_BrightnessControlPrivate_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl30IsAutoBrightnessControlEnabledEv", new Tuple<string, List<string>>("nn::lbl::IsAutoBrightnessControlEnabled()", new List<string>() { "0_12_BundleRules_BrightnessControlPrivate_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl33GetBrightnessReflectionDelayLevelENS0_25BrightnessChangeDirectionE", new Tuple<string, List<string>>("nn::lbl::GetBrightnessReflectionDelayLevel(nn::lbl::BrightnessChangeDirection)", new List<string>() { "0_12_BundleRules_BrightnessControlPrivate_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl33SetBrightnessReflectionDelayLevelENS0_25BrightnessChangeDirectionEf", new Tuple<string, List<string>>("nn::lbl::SetBrightnessReflectionDelayLevel(nn::lbl::BrightnessChangeDirection, float)", new List<string>() { "0_12_BundleRules_BrightnessControlPrivate_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl35GetCurrentAmbientLightSensorMappingEPNS0_18MappingCoefficientE", new Tuple<string, List<string>>("nn::lbl::GetCurrentAmbientLightSensorMapping(nn::lbl::MappingCoefficient*)", new List<string>() { "0_12_BundleRules_BrightnessControlPrivate_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl35SetCurrentAmbientLightSensorMappingERKNS0_18MappingCoefficientE", new Tuple<string, List<string>>("nn::lbl::SetCurrentAmbientLightSensorMapping(nn::lbl::MappingCoefficient const&)", new List<string>() { "0_12_BundleRules_BrightnessControlPrivate_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl38GetBrightnessSettingAppliedToBacklightEv", new Tuple<string, List<string>>("nn::lbl::GetBrightnessSettingAppliedToBacklight()", new List<string>() { "0_12_BundleRules_BrightnessControlPrivate_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl40ApplyCurrentBrightnessSettingToBacklightEv", new Tuple<string, List<string>>("nn::lbl::ApplyCurrentBrightnessSettingToBacklight()", new List<string>() { "0_12_BundleRules_BrightnessControlPrivate_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl8FinalizeEv", new Tuple<string, List<string>>("nn::lbl::Finalize()", new List<string>() { "0_12_BundleRules_BrightnessControlPrivate_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3btm6system11EnableRadioEb", new Tuple<string, List<string>>("nn::btm::system::EnableRadio(bool)", new List<string>() { "0_12_BundleRules_BtmSystem_NX_Btm_system" }) },
                        { "_ZN2nn3btm6system14IsRadioEnabledEv", new Tuple<string, List<string>>("nn::btm::system::IsRadioEnabled()", new List<string>() { "0_12_BundleRules_BtmSystem_NX_Btm_system" }) },
                        { "_ZN2nn3btm6system19StartGamepadPairingEv", new Tuple<string, List<string>>("nn::btm::system::StartGamepadPairing()", new List<string>() { "0_12_BundleRules_BtmSystem_NX_Btm_system" }) },
                        { "_ZN2nn3btm6system20CancelGamepadPairingEv", new Tuple<string, List<string>>("nn::btm::system::CancelGamepadPairing()", new List<string>() { "0_12_BundleRules_BtmSystem_NX_Btm_system" }) },
                        { "_ZN2nn3btm6system21GetPairedGamepadCountEv", new Tuple<string, List<string>>("nn::btm::system::GetPairedGamepadCount()", new List<string>() { "0_12_BundleRules_BtmSystem_NX_Btm_system" }) },
                        { "_ZN2nn3btm6system27ClearGamepadPairingDatabaseEv", new Tuple<string, List<string>>("nn::btm::system::ClearGamepadPairingDatabase()", new List<string>() { "0_12_BundleRules_BtmSystem_NX_Btm_system" }) },
                        { "_ZN2nn2fs19MountDeviceSaveDataEPKc", new Tuple<string, List<string>>("nn::fs::MountDeviceSaveData(char const*)", new List<string>() { "0_12_BundleRules_DeviceSaveDataKit_NX_DeviceSaveDataKit" }) },
                        { "_ZN3nnd7lsm6ds310InitializeEv", new Tuple<string, List<string>>("nnd::lsm6ds3::Initialize()", new List<string>() { "0_12_BundleRules_NintendoSDK_NX_Files_consolesixaxissensor" }) },
                        { "_ZN3nnd7lsm6ds311ResetDeviceEv", new Tuple<string, List<string>>("nnd::lsm6ds3::ResetDevice()", new List<string>() { "0_12_BundleRules_NintendoSDK_NX_Files_consolesixaxissensor" }) },
                        { "_ZN3nnd7lsm6ds313StopGyroscopeEv", new Tuple<string, List<string>>("nnd::lsm6ds3::StopGyroscope()", new List<string>() { "0_12_BundleRules_NintendoSDK_NX_Files_consolesixaxissensor" }) },
                        { "_ZN3nnd7lsm6ds314StartGyroscopeEv", new Tuple<string, List<string>>("nnd::lsm6ds3::StartGyroscope()", new List<string>() { "0_12_BundleRules_NintendoSDK_NX_Files_consolesixaxissensor" }) },
                        { "_ZN3nnd7lsm6ds315GetGyroscopeFsrEPNS0_12GyroscopeFsrE", new Tuple<string, List<string>>("nnd::lsm6ds3::GetGyroscopeFsr(nnd::lsm6ds3::GyroscopeFsr*)", new List<string>() { "0_12_BundleRules_NintendoSDK_NX_Files_consolesixaxissensor" }) },
                        { "_ZN3nnd7lsm6ds315GetGyroscopeOdrEPNS0_12GyroscopeOdrE", new Tuple<string, List<string>>("nnd::lsm6ds3::GetGyroscopeOdr(nnd::lsm6ds3::GyroscopeOdr*)", new List<string>() { "0_12_BundleRules_NintendoSDK_NX_Files_consolesixaxissensor" }) },
                        { "_ZN3nnd7lsm6ds315SetGyroscopeFsrENS0_12GyroscopeFsrE", new Tuple<string, List<string>>("nnd::lsm6ds3::SetGyroscopeFsr(nnd::lsm6ds3::GyroscopeFsr)", new List<string>() { "0_12_BundleRules_NintendoSDK_NX_Files_consolesixaxissensor" }) },
                        { "_ZN3nnd7lsm6ds315SetGyroscopeOdrENS0_12GyroscopeOdrE", new Tuple<string, List<string>>("nnd::lsm6ds3::SetGyroscopeOdr(nnd::lsm6ds3::GyroscopeOdr)", new List<string>() { "0_12_BundleRules_NintendoSDK_NX_Files_consolesixaxissensor" }) },
                        { "_ZN3nnd7lsm6ds317StopAccelerometerEv", new Tuple<string, List<string>>("nnd::lsm6ds3::StopAccelerometer()", new List<string>() { "0_12_BundleRules_NintendoSDK_NX_Files_consolesixaxissensor" }) },
                        { "_ZN3nnd7lsm6ds318StartAccelerometerEv", new Tuple<string, List<string>>("nnd::lsm6ds3::StartAccelerometer()", new List<string>() { "0_12_BundleRules_NintendoSDK_NX_Files_consolesixaxissensor" }) },
                        { "_ZN3nnd7lsm6ds319GetAccelerometerFsrEPNS0_16AccelerometerFsrE", new Tuple<string, List<string>>("nnd::lsm6ds3::GetAccelerometerFsr(nnd::lsm6ds3::AccelerometerFsr*)", new List<string>() { "0_12_BundleRules_NintendoSDK_NX_Files_consolesixaxissensor" }) },
                        { "_ZN3nnd7lsm6ds319GetAccelerometerOdrEPNS0_16AccelerometerOdrE", new Tuple<string, List<string>>("nnd::lsm6ds3::GetAccelerometerOdr(nnd::lsm6ds3::AccelerometerOdr*)", new List<string>() { "0_12_BundleRules_NintendoSDK_NX_Files_consolesixaxissensor" }) },
                        { "_ZN3nnd7lsm6ds319SetAccelerometerFsrENS0_16AccelerometerFsrE", new Tuple<string, List<string>>("nnd::lsm6ds3::SetAccelerometerFsr(nnd::lsm6ds3::AccelerometerFsr)", new List<string>() { "0_12_BundleRules_NintendoSDK_NX_Files_consolesixaxissensor" }) },
                        { "_ZN3nnd7lsm6ds319SetAccelerometerOdrENS0_16AccelerometerOdrE", new Tuple<string, List<string>>("nnd::lsm6ds3::SetAccelerometerOdr(nnd::lsm6ds3::AccelerometerOdr)", new List<string>() { "0_12_BundleRules_NintendoSDK_NX_Files_consolesixaxissensor" }) },
                        { "_ZN3nnd7lsm6ds323GetNoiseReductionFilterEPb", new Tuple<string, List<string>>("nnd::lsm6ds3::GetNoiseReductionFilter(bool*)", new List<string>() { "0_12_BundleRules_NintendoSDK_NX_Files_consolesixaxissensor" }) },
                        { "_ZN3nnd7lsm6ds323SetNoiseReductionFilterEb", new Tuple<string, List<string>>("nnd::lsm6ds3::SetNoiseReductionFilter(bool)", new List<string>() { "0_12_BundleRules_NintendoSDK_NX_Files_consolesixaxissensor" }) },
                        { "_ZN3nnd7lsm6ds38FinalizeEv", new Tuple<string, List<string>>("nnd::lsm6ds3::Finalize()", new List<string>() { "0_12_BundleRules_NintendoSDK_NX_Files_consolesixaxissensor" }) },
                        { "_ZN3nnd7lsm6ds38GetStateEPNS0_23SixAxisSensorCountStateE", new Tuple<string, List<string>>("nnd::lsm6ds3::GetState(nnd::lsm6ds3::SixAxisSensorCountState*)", new List<string>() { "0_12_BundleRules_NintendoSDK_NX_Files_consolesixaxissensor" }) },
                        { "_ZN2nn2os18SdkAllocateTlsSlotEPNS0_7TlsSlotEPFvmE", new Tuple<string, List<string>>("nn::os::SdkAllocateTlsSlot(nn::os::TlsSlot*, void (*)(unsigned long))", new List<string>() { "0_12_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn3nsd7ResolveEPNS0_4FqdnERKS1_", new Tuple<string, List<string>>("nn::nsd::Resolve(nn::nsd::Fqdn*, nn::nsd::Fqdn const&)", new List<string>() { "0_12_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC1Ev", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection()", new List<string>() { "0_12_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionD1Ev", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::~NetworkConnection()", new List<string>() { "0_12_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC1ERKNS0_18NetworkProfileDataE", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::NetworkProfileData const&)", new List<string>() { "0_12_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileD1Ev", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::~TemporaryNetworkProfile()", new List<string>() { "0_12_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC1ERKNS0_17RequestParametersE", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::RequestParameters const&)", new List<string>() { "0_12_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestD1Ev", new Tuple<string, List<string>>("nn::nifm::Request::~Request()", new List<string>() { "0_12_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn5audio16IsAudioInEnabledEv", new Tuple<string, List<string>>("nn::audio::IsAudioInEnabled()", new List<string>() { "0_12_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn5audio17SetAudioInEnabledEb", new Tuple<string, List<string>>("nn::audio::SetAudioInEnabled(bool)", new List<string>() { "0_12_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn5codec11OpusEncoderC1Ev", new Tuple<string, List<string>>("nn::codec::OpusEncoder::OpusEncoder()", new List<string>() { "0_12_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn5codec11OpusEncoderD1Ev", new Tuple<string, List<string>>("nn::codec::OpusEncoder::~OpusEncoder()", new List<string>() { "0_12_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn5prepo10InitializeEv", new Tuple<string, List<string>>("nn::prepo::Initialize()", new List<string>() { "0_12_BundleRules_PlayReportKit_Generic_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo10PlayReportC1Ev", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport()", new List<string>() { "0_12_BundleRules_PlayReportKit_Generic_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo21GetTransmissionStatusEPNS0_18TransmissionStatusE", new Tuple<string, List<string>>("nn::prepo::GetTransmissionStatus(nn::prepo::TransmissionStatus*)", new List<string>() { "0_12_BundleRules_PlayReportKit_Generic_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo28RequestImmediateTransmissionEv", new Tuple<string, List<string>>("nn::prepo::RequestImmediateTransmission()", new List<string>() { "0_12_BundleRules_PlayReportKit_Generic_Files_play-report-kit" }) },
                        { "_ZN2nn2os12ResumeThreadEPNS0_10ThreadTypeE", new Tuple<string, List<string>>("nn::os::ResumeThread(nn::os::ThreadType*)", new List<string>() { "0_12_BundleRules_UnityKit_Generic_Files" }) },
                        { "_ZN2nn2os13SuspendThreadEPNS0_10ThreadTypeE", new Tuple<string, List<string>>("nn::os::SuspendThread(nn::os::ThreadType*)", new List<string>() { "0_12_BundleRules_UnityKit_Generic_Files" }) },
                        { "_ZN2nn2os16GetThreadContextEPNS0_24ThreadContextInfoAarch64EPKNS0_10ThreadTypeE", new Tuple<string, List<string>>("nn::os::GetThreadContext(nn::os::ThreadContextInfoAarch64*, nn::os::ThreadType const*)", new List<string>() { "0_12_BundleRules_UnityKit_Generic_Files" }) },
                        { "_ZN2nn2os21GetThreadSuspendCountEPKNS0_10ThreadTypeE", new Tuple<string, List<string>>("nn::os::GetThreadSuspendCount(nn::os::ThreadType const*)", new List<string>() { "0_12_BundleRules_UnityKit_Generic_Files" }) },
                        { "_ZN2nv22SetGraphicsServiceNameEPKc", new Tuple<string, List<string>>("nv::SetGraphicsServiceName(char const*)", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private", "0_12_BundleRules_NvnPrivate_NX_Nvn_Private" }) },
                        { "eglBindAPI", new Tuple<string, List<string>>("eglBindAPI", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglBindTexImage", new Tuple<string, List<string>>("eglBindTexImage", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglChooseConfig", new Tuple<string, List<string>>("eglChooseConfig", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglClientWaitSync", new Tuple<string, List<string>>("eglClientWaitSync", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglCopyBuffers", new Tuple<string, List<string>>("eglCopyBuffers", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglCreateContext", new Tuple<string, List<string>>("eglCreateContext", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglCreateImage", new Tuple<string, List<string>>("eglCreateImage", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglCreatePbufferFromClientBuffer", new Tuple<string, List<string>>("eglCreatePbufferFromClientBuffer", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglCreatePbufferSurface", new Tuple<string, List<string>>("eglCreatePbufferSurface", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglCreatePixmapSurface", new Tuple<string, List<string>>("eglCreatePixmapSurface", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglCreatePlatformPixmapSurface", new Tuple<string, List<string>>("eglCreatePlatformPixmapSurface", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglCreatePlatformWindowSurface", new Tuple<string, List<string>>("eglCreatePlatformWindowSurface", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglCreateSync", new Tuple<string, List<string>>("eglCreateSync", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglCreateWindowSurface", new Tuple<string, List<string>>("eglCreateWindowSurface", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglDestroyContext", new Tuple<string, List<string>>("eglDestroyContext", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglDestroyImage", new Tuple<string, List<string>>("eglDestroyImage", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglDestroySurface", new Tuple<string, List<string>>("eglDestroySurface", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglDestroySync", new Tuple<string, List<string>>("eglDestroySync", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglGetConfigAttrib", new Tuple<string, List<string>>("eglGetConfigAttrib", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglGetConfigs", new Tuple<string, List<string>>("eglGetConfigs", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglGetCurrentContext", new Tuple<string, List<string>>("eglGetCurrentContext", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglGetCurrentDisplay", new Tuple<string, List<string>>("eglGetCurrentDisplay", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglGetCurrentSurface", new Tuple<string, List<string>>("eglGetCurrentSurface", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglGetDisplay", new Tuple<string, List<string>>("eglGetDisplay", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglGetError", new Tuple<string, List<string>>("eglGetError", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglGetPlatformDisplay", new Tuple<string, List<string>>("eglGetPlatformDisplay", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglGetProcAddress", new Tuple<string, List<string>>("eglGetProcAddress", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglGetSyncAttrib", new Tuple<string, List<string>>("eglGetSyncAttrib", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglInitialize", new Tuple<string, List<string>>("eglInitialize", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglMakeCurrent", new Tuple<string, List<string>>("eglMakeCurrent", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglQueryAPI", new Tuple<string, List<string>>("eglQueryAPI", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglQueryContext", new Tuple<string, List<string>>("eglQueryContext", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglQueryString", new Tuple<string, List<string>>("eglQueryString", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglQuerySurface", new Tuple<string, List<string>>("eglQuerySurface", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglReleaseTexImage", new Tuple<string, List<string>>("eglReleaseTexImage", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglReleaseThread", new Tuple<string, List<string>>("eglReleaseThread", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglSurfaceAttrib", new Tuple<string, List<string>>("eglSurfaceAttrib", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglSwapBuffers", new Tuple<string, List<string>>("eglSwapBuffers", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglSwapInterval", new Tuple<string, List<string>>("eglSwapInterval", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglTerminate", new Tuple<string, List<string>>("eglTerminate", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglWaitClient", new Tuple<string, List<string>>("eglWaitClient", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglWaitGL", new Tuple<string, List<string>>("eglWaitGL", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglWaitNative", new Tuple<string, List<string>>("eglWaitNative", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "eglWaitSync", new Tuple<string, List<string>>("eglWaitSync", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glActiveShaderProgram", new Tuple<string, List<string>>("glActiveShaderProgram", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glActiveTexture", new Tuple<string, List<string>>("glActiveTexture", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glAttachShader", new Tuple<string, List<string>>("glAttachShader", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBeginQuery", new Tuple<string, List<string>>("glBeginQuery", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBeginTransformFeedback", new Tuple<string, List<string>>("glBeginTransformFeedback", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBindAttribLocation", new Tuple<string, List<string>>("glBindAttribLocation", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBindBuffer", new Tuple<string, List<string>>("glBindBuffer", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBindBufferBase", new Tuple<string, List<string>>("glBindBufferBase", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBindBufferRange", new Tuple<string, List<string>>("glBindBufferRange", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBindFramebuffer", new Tuple<string, List<string>>("glBindFramebuffer", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBindImageTexture", new Tuple<string, List<string>>("glBindImageTexture", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBindProgramPipeline", new Tuple<string, List<string>>("glBindProgramPipeline", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBindRenderbuffer", new Tuple<string, List<string>>("glBindRenderbuffer", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBindSampler", new Tuple<string, List<string>>("glBindSampler", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBindTexture", new Tuple<string, List<string>>("glBindTexture", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBindTransformFeedback", new Tuple<string, List<string>>("glBindTransformFeedback", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBindVertexArray", new Tuple<string, List<string>>("glBindVertexArray", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBindVertexBuffer", new Tuple<string, List<string>>("glBindVertexBuffer", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBlendBarrier", new Tuple<string, List<string>>("glBlendBarrier", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBlendColor", new Tuple<string, List<string>>("glBlendColor", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBlendEquation", new Tuple<string, List<string>>("glBlendEquation", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBlendEquationi", new Tuple<string, List<string>>("glBlendEquationi", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBlendEquationSeparate", new Tuple<string, List<string>>("glBlendEquationSeparate", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBlendEquationSeparatei", new Tuple<string, List<string>>("glBlendEquationSeparatei", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBlendFunc", new Tuple<string, List<string>>("glBlendFunc", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBlendFunci", new Tuple<string, List<string>>("glBlendFunci", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBlendFuncSeparate", new Tuple<string, List<string>>("glBlendFuncSeparate", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBlendFuncSeparatei", new Tuple<string, List<string>>("glBlendFuncSeparatei", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBlitFramebuffer", new Tuple<string, List<string>>("glBlitFramebuffer", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBufferData", new Tuple<string, List<string>>("glBufferData", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glBufferSubData", new Tuple<string, List<string>>("glBufferSubData", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glCheckFramebufferStatus", new Tuple<string, List<string>>("glCheckFramebufferStatus", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glClear", new Tuple<string, List<string>>("glClear", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glClearBufferfi", new Tuple<string, List<string>>("glClearBufferfi", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glClearBufferfv", new Tuple<string, List<string>>("glClearBufferfv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glClearBufferiv", new Tuple<string, List<string>>("glClearBufferiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glClearBufferuiv", new Tuple<string, List<string>>("glClearBufferuiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glClearColor", new Tuple<string, List<string>>("glClearColor", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glClearDepthf", new Tuple<string, List<string>>("glClearDepthf", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glClearStencil", new Tuple<string, List<string>>("glClearStencil", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glClientWaitSync", new Tuple<string, List<string>>("glClientWaitSync", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glColorMask", new Tuple<string, List<string>>("glColorMask", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glColorMaski", new Tuple<string, List<string>>("glColorMaski", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glCompileShader", new Tuple<string, List<string>>("glCompileShader", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glCompressedTexImage2D", new Tuple<string, List<string>>("glCompressedTexImage2D", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glCompressedTexImage3D", new Tuple<string, List<string>>("glCompressedTexImage3D", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glCompressedTexSubImage2D", new Tuple<string, List<string>>("glCompressedTexSubImage2D", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glCompressedTexSubImage3D", new Tuple<string, List<string>>("glCompressedTexSubImage3D", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glCopyBufferSubData", new Tuple<string, List<string>>("glCopyBufferSubData", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glCopyImageSubData", new Tuple<string, List<string>>("glCopyImageSubData", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glCopyTexImage2D", new Tuple<string, List<string>>("glCopyTexImage2D", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glCopyTexSubImage2D", new Tuple<string, List<string>>("glCopyTexSubImage2D", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glCopyTexSubImage3D", new Tuple<string, List<string>>("glCopyTexSubImage3D", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glCreateProgram", new Tuple<string, List<string>>("glCreateProgram", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glCreateShader", new Tuple<string, List<string>>("glCreateShader", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glCreateShaderProgramv", new Tuple<string, List<string>>("glCreateShaderProgramv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glCullFace", new Tuple<string, List<string>>("glCullFace", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDebugMessageCallback", new Tuple<string, List<string>>("glDebugMessageCallback", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDebugMessageControl", new Tuple<string, List<string>>("glDebugMessageControl", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDebugMessageInsert", new Tuple<string, List<string>>("glDebugMessageInsert", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDeleteBuffers", new Tuple<string, List<string>>("glDeleteBuffers", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDeleteFramebuffers", new Tuple<string, List<string>>("glDeleteFramebuffers", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDeleteProgram", new Tuple<string, List<string>>("glDeleteProgram", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDeleteProgramPipelines", new Tuple<string, List<string>>("glDeleteProgramPipelines", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDeleteQueries", new Tuple<string, List<string>>("glDeleteQueries", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDeleteRenderbuffers", new Tuple<string, List<string>>("glDeleteRenderbuffers", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDeleteSamplers", new Tuple<string, List<string>>("glDeleteSamplers", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDeleteShader", new Tuple<string, List<string>>("glDeleteShader", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDeleteSync", new Tuple<string, List<string>>("glDeleteSync", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDeleteTextures", new Tuple<string, List<string>>("glDeleteTextures", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDeleteTransformFeedbacks", new Tuple<string, List<string>>("glDeleteTransformFeedbacks", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDeleteVertexArrays", new Tuple<string, List<string>>("glDeleteVertexArrays", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDepthFunc", new Tuple<string, List<string>>("glDepthFunc", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDepthMask", new Tuple<string, List<string>>("glDepthMask", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDepthRangef", new Tuple<string, List<string>>("glDepthRangef", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDetachShader", new Tuple<string, List<string>>("glDetachShader", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDisable", new Tuple<string, List<string>>("glDisable", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDisablei", new Tuple<string, List<string>>("glDisablei", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDisableVertexAttribArray", new Tuple<string, List<string>>("glDisableVertexAttribArray", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDispatchCompute", new Tuple<string, List<string>>("glDispatchCompute", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDispatchComputeIndirect", new Tuple<string, List<string>>("glDispatchComputeIndirect", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDrawArrays", new Tuple<string, List<string>>("glDrawArrays", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDrawArraysIndirect", new Tuple<string, List<string>>("glDrawArraysIndirect", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDrawArraysInstanced", new Tuple<string, List<string>>("glDrawArraysInstanced", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDrawBuffers", new Tuple<string, List<string>>("glDrawBuffers", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDrawElements", new Tuple<string, List<string>>("glDrawElements", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDrawElementsBaseVertex", new Tuple<string, List<string>>("glDrawElementsBaseVertex", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDrawElementsIndirect", new Tuple<string, List<string>>("glDrawElementsIndirect", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDrawElementsInstanced", new Tuple<string, List<string>>("glDrawElementsInstanced", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDrawElementsInstancedBaseVertex", new Tuple<string, List<string>>("glDrawElementsInstancedBaseVertex", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDrawRangeElements", new Tuple<string, List<string>>("glDrawRangeElements", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glDrawRangeElementsBaseVertex", new Tuple<string, List<string>>("glDrawRangeElementsBaseVertex", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glEnable", new Tuple<string, List<string>>("glEnable", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glEnablei", new Tuple<string, List<string>>("glEnablei", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glEnableVertexAttribArray", new Tuple<string, List<string>>("glEnableVertexAttribArray", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glEndQuery", new Tuple<string, List<string>>("glEndQuery", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glEndTransformFeedback", new Tuple<string, List<string>>("glEndTransformFeedback", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glFenceSync", new Tuple<string, List<string>>("glFenceSync", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glFinish", new Tuple<string, List<string>>("glFinish", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glFlush", new Tuple<string, List<string>>("glFlush", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glFlushMappedBufferRange", new Tuple<string, List<string>>("glFlushMappedBufferRange", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glFramebufferParameteri", new Tuple<string, List<string>>("glFramebufferParameteri", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glFramebufferRenderbuffer", new Tuple<string, List<string>>("glFramebufferRenderbuffer", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glFramebufferTexture", new Tuple<string, List<string>>("glFramebufferTexture", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glFramebufferTexture2D", new Tuple<string, List<string>>("glFramebufferTexture2D", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glFramebufferTextureLayer", new Tuple<string, List<string>>("glFramebufferTextureLayer", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glFrontFace", new Tuple<string, List<string>>("glFrontFace", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGenBuffers", new Tuple<string, List<string>>("glGenBuffers", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGenerateMipmap", new Tuple<string, List<string>>("glGenerateMipmap", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGenFramebuffers", new Tuple<string, List<string>>("glGenFramebuffers", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGenProgramPipelines", new Tuple<string, List<string>>("glGenProgramPipelines", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGenQueries", new Tuple<string, List<string>>("glGenQueries", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGenRenderbuffers", new Tuple<string, List<string>>("glGenRenderbuffers", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGenSamplers", new Tuple<string, List<string>>("glGenSamplers", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGenTextures", new Tuple<string, List<string>>("glGenTextures", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGenTransformFeedbacks", new Tuple<string, List<string>>("glGenTransformFeedbacks", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGenVertexArrays", new Tuple<string, List<string>>("glGenVertexArrays", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetActiveAttrib", new Tuple<string, List<string>>("glGetActiveAttrib", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetActiveUniform", new Tuple<string, List<string>>("glGetActiveUniform", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetActiveUniformBlockiv", new Tuple<string, List<string>>("glGetActiveUniformBlockiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetActiveUniformBlockName", new Tuple<string, List<string>>("glGetActiveUniformBlockName", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetActiveUniformsiv", new Tuple<string, List<string>>("glGetActiveUniformsiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetAttachedShaders", new Tuple<string, List<string>>("glGetAttachedShaders", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetAttribLocation", new Tuple<string, List<string>>("glGetAttribLocation", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetBooleani_v", new Tuple<string, List<string>>("glGetBooleani_v", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetBooleanv", new Tuple<string, List<string>>("glGetBooleanv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetBufferParameteri64v", new Tuple<string, List<string>>("glGetBufferParameteri64v", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetBufferParameteriv", new Tuple<string, List<string>>("glGetBufferParameteriv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetBufferPointerv", new Tuple<string, List<string>>("glGetBufferPointerv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetDebugMessageLog", new Tuple<string, List<string>>("glGetDebugMessageLog", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetError", new Tuple<string, List<string>>("glGetError", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetFloatv", new Tuple<string, List<string>>("glGetFloatv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetFragDataLocation", new Tuple<string, List<string>>("glGetFragDataLocation", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetFramebufferAttachmentParameteriv", new Tuple<string, List<string>>("glGetFramebufferAttachmentParameteriv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetFramebufferParameteriv", new Tuple<string, List<string>>("glGetFramebufferParameteriv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetGraphicsResetStatus", new Tuple<string, List<string>>("glGetGraphicsResetStatus", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetInteger64i_v", new Tuple<string, List<string>>("glGetInteger64i_v", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetInteger64v", new Tuple<string, List<string>>("glGetInteger64v", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetIntegeri_v", new Tuple<string, List<string>>("glGetIntegeri_v", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetIntegerv", new Tuple<string, List<string>>("glGetIntegerv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetInternalformativ", new Tuple<string, List<string>>("glGetInternalformativ", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetMultisamplefv", new Tuple<string, List<string>>("glGetMultisamplefv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetnUniformfv", new Tuple<string, List<string>>("glGetnUniformfv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetnUniformiv", new Tuple<string, List<string>>("glGetnUniformiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetnUniformuiv", new Tuple<string, List<string>>("glGetnUniformuiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetObjectLabel", new Tuple<string, List<string>>("glGetObjectLabel", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetObjectPtrLabel", new Tuple<string, List<string>>("glGetObjectPtrLabel", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetPointerv", new Tuple<string, List<string>>("glGetPointerv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetProgramBinary", new Tuple<string, List<string>>("glGetProgramBinary", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetProgramInfoLog", new Tuple<string, List<string>>("glGetProgramInfoLog", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetProgramInterfaceiv", new Tuple<string, List<string>>("glGetProgramInterfaceiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetProgramiv", new Tuple<string, List<string>>("glGetProgramiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetProgramPipelineInfoLog", new Tuple<string, List<string>>("glGetProgramPipelineInfoLog", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetProgramPipelineiv", new Tuple<string, List<string>>("glGetProgramPipelineiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetProgramResourceIndex", new Tuple<string, List<string>>("glGetProgramResourceIndex", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetProgramResourceiv", new Tuple<string, List<string>>("glGetProgramResourceiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetProgramResourceLocation", new Tuple<string, List<string>>("glGetProgramResourceLocation", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetProgramResourceName", new Tuple<string, List<string>>("glGetProgramResourceName", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetQueryiv", new Tuple<string, List<string>>("glGetQueryiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetQueryObjectuiv", new Tuple<string, List<string>>("glGetQueryObjectuiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetRenderbufferParameteriv", new Tuple<string, List<string>>("glGetRenderbufferParameteriv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetSamplerParameterfv", new Tuple<string, List<string>>("glGetSamplerParameterfv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetSamplerParameterIiv", new Tuple<string, List<string>>("glGetSamplerParameterIiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetSamplerParameterIuiv", new Tuple<string, List<string>>("glGetSamplerParameterIuiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetSamplerParameteriv", new Tuple<string, List<string>>("glGetSamplerParameteriv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetShaderInfoLog", new Tuple<string, List<string>>("glGetShaderInfoLog", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetShaderiv", new Tuple<string, List<string>>("glGetShaderiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetShaderPrecisionFormat", new Tuple<string, List<string>>("glGetShaderPrecisionFormat", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetShaderSource", new Tuple<string, List<string>>("glGetShaderSource", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetString", new Tuple<string, List<string>>("glGetString", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetStringi", new Tuple<string, List<string>>("glGetStringi", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetSynciv", new Tuple<string, List<string>>("glGetSynciv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetTexLevelParameterfv", new Tuple<string, List<string>>("glGetTexLevelParameterfv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetTexLevelParameteriv", new Tuple<string, List<string>>("glGetTexLevelParameteriv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetTexParameterfv", new Tuple<string, List<string>>("glGetTexParameterfv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetTexParameterIiv", new Tuple<string, List<string>>("glGetTexParameterIiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetTexParameterIuiv", new Tuple<string, List<string>>("glGetTexParameterIuiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetTexParameteriv", new Tuple<string, List<string>>("glGetTexParameteriv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetTransformFeedbackVarying", new Tuple<string, List<string>>("glGetTransformFeedbackVarying", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetUniformBlockIndex", new Tuple<string, List<string>>("glGetUniformBlockIndex", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetUniformfv", new Tuple<string, List<string>>("glGetUniformfv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetUniformIndices", new Tuple<string, List<string>>("glGetUniformIndices", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetUniformiv", new Tuple<string, List<string>>("glGetUniformiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetUniformLocation", new Tuple<string, List<string>>("glGetUniformLocation", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetUniformuiv", new Tuple<string, List<string>>("glGetUniformuiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetVertexAttribfv", new Tuple<string, List<string>>("glGetVertexAttribfv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetVertexAttribIiv", new Tuple<string, List<string>>("glGetVertexAttribIiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetVertexAttribIuiv", new Tuple<string, List<string>>("glGetVertexAttribIuiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetVertexAttribiv", new Tuple<string, List<string>>("glGetVertexAttribiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glGetVertexAttribPointerv", new Tuple<string, List<string>>("glGetVertexAttribPointerv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glHint", new Tuple<string, List<string>>("glHint", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glInvalidateFramebuffer", new Tuple<string, List<string>>("glInvalidateFramebuffer", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glInvalidateSubFramebuffer", new Tuple<string, List<string>>("glInvalidateSubFramebuffer", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glIsBuffer", new Tuple<string, List<string>>("glIsBuffer", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glIsEnabled", new Tuple<string, List<string>>("glIsEnabled", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glIsEnabledi", new Tuple<string, List<string>>("glIsEnabledi", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glIsFramebuffer", new Tuple<string, List<string>>("glIsFramebuffer", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glIsProgram", new Tuple<string, List<string>>("glIsProgram", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glIsProgramPipeline", new Tuple<string, List<string>>("glIsProgramPipeline", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glIsQuery", new Tuple<string, List<string>>("glIsQuery", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glIsRenderbuffer", new Tuple<string, List<string>>("glIsRenderbuffer", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glIsSampler", new Tuple<string, List<string>>("glIsSampler", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glIsShader", new Tuple<string, List<string>>("glIsShader", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glIsSync", new Tuple<string, List<string>>("glIsSync", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glIsTexture", new Tuple<string, List<string>>("glIsTexture", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glIsTransformFeedback", new Tuple<string, List<string>>("glIsTransformFeedback", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glIsVertexArray", new Tuple<string, List<string>>("glIsVertexArray", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glLineWidth", new Tuple<string, List<string>>("glLineWidth", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glLinkProgram", new Tuple<string, List<string>>("glLinkProgram", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glMapBufferRange", new Tuple<string, List<string>>("glMapBufferRange", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glMemoryBarrier", new Tuple<string, List<string>>("glMemoryBarrier", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glMemoryBarrierByRegion", new Tuple<string, List<string>>("glMemoryBarrierByRegion", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glMinSampleShading", new Tuple<string, List<string>>("glMinSampleShading", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glObjectLabel", new Tuple<string, List<string>>("glObjectLabel", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glObjectPtrLabel", new Tuple<string, List<string>>("glObjectPtrLabel", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glPatchParameteri", new Tuple<string, List<string>>("glPatchParameteri", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glPauseTransformFeedback", new Tuple<string, List<string>>("glPauseTransformFeedback", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glPixelStorei", new Tuple<string, List<string>>("glPixelStorei", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glPolygonOffset", new Tuple<string, List<string>>("glPolygonOffset", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glPopDebugGroup", new Tuple<string, List<string>>("glPopDebugGroup", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glPrimitiveBoundingBox", new Tuple<string, List<string>>("glPrimitiveBoundingBox", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramBinary", new Tuple<string, List<string>>("glProgramBinary", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramParameteri", new Tuple<string, List<string>>("glProgramParameteri", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniform1f", new Tuple<string, List<string>>("glProgramUniform1f", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniform1fv", new Tuple<string, List<string>>("glProgramUniform1fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniform1i", new Tuple<string, List<string>>("glProgramUniform1i", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniform1iv", new Tuple<string, List<string>>("glProgramUniform1iv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniform1ui", new Tuple<string, List<string>>("glProgramUniform1ui", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniform1uiv", new Tuple<string, List<string>>("glProgramUniform1uiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniform2f", new Tuple<string, List<string>>("glProgramUniform2f", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniform2fv", new Tuple<string, List<string>>("glProgramUniform2fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniform2i", new Tuple<string, List<string>>("glProgramUniform2i", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniform2iv", new Tuple<string, List<string>>("glProgramUniform2iv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniform2ui", new Tuple<string, List<string>>("glProgramUniform2ui", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniform2uiv", new Tuple<string, List<string>>("glProgramUniform2uiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniform3f", new Tuple<string, List<string>>("glProgramUniform3f", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniform3fv", new Tuple<string, List<string>>("glProgramUniform3fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniform3i", new Tuple<string, List<string>>("glProgramUniform3i", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniform3iv", new Tuple<string, List<string>>("glProgramUniform3iv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniform3ui", new Tuple<string, List<string>>("glProgramUniform3ui", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniform3uiv", new Tuple<string, List<string>>("glProgramUniform3uiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniform4f", new Tuple<string, List<string>>("glProgramUniform4f", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniform4fv", new Tuple<string, List<string>>("glProgramUniform4fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniform4i", new Tuple<string, List<string>>("glProgramUniform4i", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniform4iv", new Tuple<string, List<string>>("glProgramUniform4iv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniform4ui", new Tuple<string, List<string>>("glProgramUniform4ui", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniform4uiv", new Tuple<string, List<string>>("glProgramUniform4uiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniformMatrix2fv", new Tuple<string, List<string>>("glProgramUniformMatrix2fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniformMatrix2x3fv", new Tuple<string, List<string>>("glProgramUniformMatrix2x3fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniformMatrix2x4fv", new Tuple<string, List<string>>("glProgramUniformMatrix2x4fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniformMatrix3fv", new Tuple<string, List<string>>("glProgramUniformMatrix3fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniformMatrix3x2fv", new Tuple<string, List<string>>("glProgramUniformMatrix3x2fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniformMatrix3x4fv", new Tuple<string, List<string>>("glProgramUniformMatrix3x4fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniformMatrix4fv", new Tuple<string, List<string>>("glProgramUniformMatrix4fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniformMatrix4x2fv", new Tuple<string, List<string>>("glProgramUniformMatrix4x2fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glProgramUniformMatrix4x3fv", new Tuple<string, List<string>>("glProgramUniformMatrix4x3fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glPushDebugGroup", new Tuple<string, List<string>>("glPushDebugGroup", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glReadBuffer", new Tuple<string, List<string>>("glReadBuffer", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glReadnPixels", new Tuple<string, List<string>>("glReadnPixels", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glReadPixels", new Tuple<string, List<string>>("glReadPixels", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glReleaseShaderCompiler", new Tuple<string, List<string>>("glReleaseShaderCompiler", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glRenderbufferStorage", new Tuple<string, List<string>>("glRenderbufferStorage", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glRenderbufferStorageMultisample", new Tuple<string, List<string>>("glRenderbufferStorageMultisample", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glResumeTransformFeedback", new Tuple<string, List<string>>("glResumeTransformFeedback", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glSampleCoverage", new Tuple<string, List<string>>("glSampleCoverage", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glSampleMaski", new Tuple<string, List<string>>("glSampleMaski", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glSamplerParameterf", new Tuple<string, List<string>>("glSamplerParameterf", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glSamplerParameterfv", new Tuple<string, List<string>>("glSamplerParameterfv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glSamplerParameteri", new Tuple<string, List<string>>("glSamplerParameteri", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glSamplerParameterIiv", new Tuple<string, List<string>>("glSamplerParameterIiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glSamplerParameterIuiv", new Tuple<string, List<string>>("glSamplerParameterIuiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glSamplerParameteriv", new Tuple<string, List<string>>("glSamplerParameteriv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glScissor", new Tuple<string, List<string>>("glScissor", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glShaderBinary", new Tuple<string, List<string>>("glShaderBinary", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glShaderSource", new Tuple<string, List<string>>("glShaderSource", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glStencilFunc", new Tuple<string, List<string>>("glStencilFunc", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glStencilFuncSeparate", new Tuple<string, List<string>>("glStencilFuncSeparate", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glStencilMask", new Tuple<string, List<string>>("glStencilMask", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glStencilMaskSeparate", new Tuple<string, List<string>>("glStencilMaskSeparate", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glStencilOp", new Tuple<string, List<string>>("glStencilOp", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glStencilOpSeparate", new Tuple<string, List<string>>("glStencilOpSeparate", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glTexBuffer", new Tuple<string, List<string>>("glTexBuffer", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glTexBufferRange", new Tuple<string, List<string>>("glTexBufferRange", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glTexImage2D", new Tuple<string, List<string>>("glTexImage2D", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glTexImage3D", new Tuple<string, List<string>>("glTexImage3D", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glTexParameterf", new Tuple<string, List<string>>("glTexParameterf", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glTexParameterfv", new Tuple<string, List<string>>("glTexParameterfv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glTexParameteri", new Tuple<string, List<string>>("glTexParameteri", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glTexParameterIiv", new Tuple<string, List<string>>("glTexParameterIiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glTexParameterIuiv", new Tuple<string, List<string>>("glTexParameterIuiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glTexParameteriv", new Tuple<string, List<string>>("glTexParameteriv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glTexStorage2D", new Tuple<string, List<string>>("glTexStorage2D", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glTexStorage2DMultisample", new Tuple<string, List<string>>("glTexStorage2DMultisample", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glTexStorage3D", new Tuple<string, List<string>>("glTexStorage3D", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glTexStorage3DMultisample", new Tuple<string, List<string>>("glTexStorage3DMultisample", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glTexSubImage2D", new Tuple<string, List<string>>("glTexSubImage2D", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glTexSubImage3D", new Tuple<string, List<string>>("glTexSubImage3D", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glTransformFeedbackVaryings", new Tuple<string, List<string>>("glTransformFeedbackVaryings", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniform1f", new Tuple<string, List<string>>("glUniform1f", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniform1fv", new Tuple<string, List<string>>("glUniform1fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniform1i", new Tuple<string, List<string>>("glUniform1i", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniform1iv", new Tuple<string, List<string>>("glUniform1iv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniform1ui", new Tuple<string, List<string>>("glUniform1ui", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniform1uiv", new Tuple<string, List<string>>("glUniform1uiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniform2f", new Tuple<string, List<string>>("glUniform2f", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniform2fv", new Tuple<string, List<string>>("glUniform2fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniform2i", new Tuple<string, List<string>>("glUniform2i", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniform2iv", new Tuple<string, List<string>>("glUniform2iv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniform2ui", new Tuple<string, List<string>>("glUniform2ui", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniform2uiv", new Tuple<string, List<string>>("glUniform2uiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniform3f", new Tuple<string, List<string>>("glUniform3f", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniform3fv", new Tuple<string, List<string>>("glUniform3fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniform3i", new Tuple<string, List<string>>("glUniform3i", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniform3iv", new Tuple<string, List<string>>("glUniform3iv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniform3ui", new Tuple<string, List<string>>("glUniform3ui", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniform3uiv", new Tuple<string, List<string>>("glUniform3uiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniform4f", new Tuple<string, List<string>>("glUniform4f", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniform4fv", new Tuple<string, List<string>>("glUniform4fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniform4i", new Tuple<string, List<string>>("glUniform4i", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniform4iv", new Tuple<string, List<string>>("glUniform4iv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniform4ui", new Tuple<string, List<string>>("glUniform4ui", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniform4uiv", new Tuple<string, List<string>>("glUniform4uiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniformBlockBinding", new Tuple<string, List<string>>("glUniformBlockBinding", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniformMatrix2fv", new Tuple<string, List<string>>("glUniformMatrix2fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniformMatrix2x3fv", new Tuple<string, List<string>>("glUniformMatrix2x3fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniformMatrix2x4fv", new Tuple<string, List<string>>("glUniformMatrix2x4fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniformMatrix3fv", new Tuple<string, List<string>>("glUniformMatrix3fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniformMatrix3x2fv", new Tuple<string, List<string>>("glUniformMatrix3x2fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniformMatrix3x4fv", new Tuple<string, List<string>>("glUniformMatrix3x4fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniformMatrix4fv", new Tuple<string, List<string>>("glUniformMatrix4fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniformMatrix4x2fv", new Tuple<string, List<string>>("glUniformMatrix4x2fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUniformMatrix4x3fv", new Tuple<string, List<string>>("glUniformMatrix4x3fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUnmapBuffer", new Tuple<string, List<string>>("glUnmapBuffer", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUseProgram", new Tuple<string, List<string>>("glUseProgram", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glUseProgramStages", new Tuple<string, List<string>>("glUseProgramStages", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glValidateProgram", new Tuple<string, List<string>>("glValidateProgram", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glValidateProgramPipeline", new Tuple<string, List<string>>("glValidateProgramPipeline", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glVertexAttrib1f", new Tuple<string, List<string>>("glVertexAttrib1f", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glVertexAttrib1fv", new Tuple<string, List<string>>("glVertexAttrib1fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glVertexAttrib2f", new Tuple<string, List<string>>("glVertexAttrib2f", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glVertexAttrib2fv", new Tuple<string, List<string>>("glVertexAttrib2fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glVertexAttrib3f", new Tuple<string, List<string>>("glVertexAttrib3f", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glVertexAttrib3fv", new Tuple<string, List<string>>("glVertexAttrib3fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glVertexAttrib4f", new Tuple<string, List<string>>("glVertexAttrib4f", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glVertexAttrib4fv", new Tuple<string, List<string>>("glVertexAttrib4fv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glVertexAttribBinding", new Tuple<string, List<string>>("glVertexAttribBinding", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glVertexAttribDivisor", new Tuple<string, List<string>>("glVertexAttribDivisor", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glVertexAttribFormat", new Tuple<string, List<string>>("glVertexAttribFormat", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glVertexAttribI4i", new Tuple<string, List<string>>("glVertexAttribI4i", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glVertexAttribI4iv", new Tuple<string, List<string>>("glVertexAttribI4iv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glVertexAttribI4ui", new Tuple<string, List<string>>("glVertexAttribI4ui", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glVertexAttribI4uiv", new Tuple<string, List<string>>("glVertexAttribI4uiv", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glVertexAttribIFormat", new Tuple<string, List<string>>("glVertexAttribIFormat", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glVertexAttribIPointer", new Tuple<string, List<string>>("glVertexAttribIPointer", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glVertexAttribPointer", new Tuple<string, List<string>>("glVertexAttribPointer", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glVertexBindingDivisor", new Tuple<string, List<string>>("glVertexBindingDivisor", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glViewport", new Tuple<string, List<string>>("glViewport", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "glWaitSync", new Tuple<string, List<string>>("glWaitSync", new List<string>() { "0_12_BundleRules_GLPrivate_NX_GL_Private" }) },
                        { "_ZN2nn3ldn15FinalizeMonitorEv", new Tuple<string, List<string>>("nn::ldn::FinalizeMonitor()", new List<string>() { "0_12_BundleRules_LdnMonitor_NX_Ldn_Monitor" }) },
                        { "_ZN2nn3ldn17InitializeMonitorEv", new Tuple<string, List<string>>("nn::ldn::InitializeMonitor()", new List<string>() { "0_12_BundleRules_LdnMonitor_NX_Ldn_Monitor" }) },
                        { "_ZN2nn3ldn18GetStateForMonitorEv", new Tuple<string, List<string>>("nn::ldn::GetStateForMonitor()", new List<string>() { "0_12_BundleRules_LdnMonitor_NX_Ldn_Monitor" }) },
                        { "_ZN2nn3ldn24GetIpv4AddressForMonitorEPNS0_11Ipv4AddressEPNS0_10SubnetMaskE", new Tuple<string, List<string>>("nn::ldn::GetIpv4AddressForMonitor(nn::ldn::Ipv4Address*, nn::ldn::SubnetMask*)", new List<string>() { "0_12_BundleRules_LdnMonitor_NX_Ldn_Monitor" }) },
                        { "_ZN2nn3ldn24GetNetworkInfoForMonitorEPNS0_11NetworkInfoE", new Tuple<string, List<string>>("nn::ldn::GetNetworkInfoForMonitor(nn::ldn::NetworkInfo*)", new List<string>() { "0_12_BundleRules_LdnMonitor_NX_Ldn_Monitor" }) },
                        { "_ZN2nn3ldn11ScanPrivateEPNS0_11NetworkInfoEPiiRKNS0_10ScanFilterEi", new Tuple<string, List<string>>("nn::ldn::ScanPrivate(nn::ldn::NetworkInfo*, int*, int, nn::ldn::ScanFilter const&, int)", new List<string>() { "0_12_BundleRules_LdnPrivate_NX_Ldn_Private" }) },
                        { "_ZN2nn3ldn14ConnectPrivateERKNS0_13NetworkConfigERKNS0_14SecurityConfigERKNS0_17SecurityParameterERKNS0_10UserConfigEi", new Tuple<string, List<string>>("nn::ldn::ConnectPrivate(nn::ldn::NetworkConfig const&, nn::ldn::SecurityConfig const&, nn::ldn::SecurityParameter const&, nn::ldn::UserConfig const&, int)", new List<string>() { "0_12_BundleRules_LdnPrivate_NX_Ldn_Private" }) },
                        { "_ZN2nn3ldn14ConnectPrivateERKNS0_13NetworkConfigERKNS0_14SecurityConfigERKNS0_17SecurityParameterERKNS0_10UserConfigEiNS0_13ConnectOptionE", new Tuple<string, List<string>>("nn::ldn::ConnectPrivate(nn::ldn::NetworkConfig const&, nn::ldn::SecurityConfig const&, nn::ldn::SecurityParameter const&, nn::ldn::UserConfig const&, int, nn::ldn::ConnectOption)", new List<string>() { "0_12_BundleRules_LdnPrivate_NX_Ldn_Private" }) },
                        { "_ZN2nn3ldn16GetNetworkConfigEPNS0_13NetworkConfigE", new Tuple<string, List<string>>("nn::ldn::GetNetworkConfig(nn::ldn::NetworkConfig*)", new List<string>() { "0_12_BundleRules_LdnPrivate_NX_Ldn_Private" }) },
                        { "_ZN2nn3ldn20AddAcceptFilterEntryENS0_10MacAddressE", new Tuple<string, List<string>>("nn::ldn::AddAcceptFilterEntry(nn::ldn::MacAddress)", new List<string>() { "0_12_BundleRules_LdnPrivate_NX_Ldn_Private" }) },
                        { "_ZN2nn3ldn20CreateNetworkPrivateERKNS0_13NetworkConfigERKNS0_14SecurityConfigERKNS0_17SecurityParameterERKNS0_10UserConfigEiPKNS0_12AddressEntryE", new Tuple<string, List<string>>("nn::ldn::CreateNetworkPrivate(nn::ldn::NetworkConfig const&, nn::ldn::SecurityConfig const&, nn::ldn::SecurityParameter const&, nn::ldn::UserConfig const&, int, nn::ldn::AddressEntry const*)", new List<string>() { "0_12_BundleRules_LdnPrivate_NX_Ldn_Private" }) },
                        { "_ZN2nn3ldn20GetSecurityParameterEPNS0_17SecurityParameterE", new Tuple<string, List<string>>("nn::ldn::GetSecurityParameter(nn::ldn::SecurityParameter*)", new List<string>() { "0_12_BundleRules_LdnPrivate_NX_Ldn_Private" }) },
                        { "_ZN2nn3ldn14FinalizeSystemEv", new Tuple<string, List<string>>("nn::ldn::FinalizeSystem()", new List<string>() { "0_12_BundleRules_LdnSystem_NX_Ldn_System" }) },
                        { "_ZN2nn3ldn16InitializeSystemEv", new Tuple<string, List<string>>("nn::ldn::InitializeSystem()", new List<string>() { "0_12_BundleRules_LdnSystem_NX_Ldn_System" }) },
                        { "_ZN5movie13BrowserConfigC1Ev", new Tuple<string, List<string>>("movie::BrowserConfig::BrowserConfig()", new List<string>() { "0_12_BundleRules_MultimediaInterfacePrivate_NX_MultimediaInterface_Private" }) },
                        { "_ZN2nn3fgm10InitializeEv", new Tuple<string, List<string>>("nn::fgm::Initialize()", new List<string>() { "0_12_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm12GetClockRateEPjNS0_6ModuleE", new Tuple<string, List<string>>("nn::fgm::GetClockRate(unsigned int*, nn::fgm::Module)", new List<string>() { "0_12_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm13IsInitializedEv", new Tuple<string, List<string>>("nn::fgm::IsInitialized()", new List<string>() { "0_12_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm18SetClockMinMaxRateEPjNS0_6ModuleEjj", new Tuple<string, List<string>>("nn::fgm::SetClockMinMaxRate(unsigned int*, nn::fgm::Module, unsigned int, unsigned int)", new List<string>() { "0_12_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm20UnsetClockMinMaxRateENS0_6ModuleE", new Tuple<string, List<string>>("nn::fgm::UnsetClockMinMaxRate(nn::fgm::Module)", new List<string>() { "0_12_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm26SetClockMinMaxRateOverrideEPjNS0_6ModuleEjj", new Tuple<string, List<string>>("nn::fgm::SetClockMinMaxRateOverride(unsigned int*, nn::fgm::Module, unsigned int, unsigned int)", new List<string>() { "0_12_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm28UnsetClockMinMaxRateOverrideENS0_6ModuleE", new Tuple<string, List<string>>("nn::fgm::UnsetClockMinMaxRateOverride(nn::fgm::Module)", new List<string>() { "0_12_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm7RequestC1Ev", new Tuple<string, List<string>>("nn::fgm::Request::Request()", new List<string>() { "0_12_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm7RequestD1Ev", new Tuple<string, List<string>>("nn::fgm::Request::~Request()", new List<string>() { "0_12_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm8FinalizeEv", new Tuple<string, List<string>>("nn::fgm::Finalize()", new List<string>() { "0_12_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn2oe20GetDefaultThemeColorEv", new Tuple<string, List<string>>("nn::oe::GetDefaultThemeColor()", new List<string>() { "0_12_BundleRules_TurboSKit_NX_Files" }) },
                        { "_ZN2nn2oe21GetExpectedThemeColorEv", new Tuple<string, List<string>>("nn::oe::GetExpectedThemeColor()", new List<string>() { "0_12_BundleRules_TurboSKit_NX_Files" }) },
                        { "_ZN2nn7account25CachedNintendoAccountInfoC1Ev", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::CachedNintendoAccountInfo()", new List<string>() { "0_12_BundleRules_TurboSKit_NX_Files" }) },
                        { "_ZN2nn7account29LoadCachedNintendoAccountInfoEPNS0_25CachedNintendoAccountInfoERKNS0_10UserHandleEPvm", new Tuple<string, List<string>>("nn::account::LoadCachedNintendoAccountInfo(nn::account::CachedNintendoAccountInfo*, nn::account::UserHandle const&, void*, unsigned long)", new List<string>() { "0_12_BundleRules_TurboSKit_NX_Files" }) },
                        { "_ZN2nn3hid41EnableUnintendedHomeButtonInputProtectionERKjb", new Tuple<string, List<string>>("nn::hid::EnableUnintendedHomeButtonInputProtection(unsigned int const&, bool)", new List<string>() { "0_12_BundleRules_UnintendedHomeButtonInputProtection_NX_UnintendedHomeButtonInputProtection" }) },
                        { "_ZN2nn3hid44IsUnintendedHomeButtonInputProtectionEnabledERKj", new Tuple<string, List<string>>("nn::hid::IsUnintendedHomeButtonInputProtectionEnabled(unsigned int const&)", new List<string>() { "0_12_BundleRules_UnintendedHomeButtonInputProtection_NX_UnintendedHomeButtonInputProtection" }) },
                        { "_ZN2nn3hid15PermitVibrationEb", new Tuple<string, List<string>>("nn::hid::PermitVibration(bool)", new List<string>() { "0_12_BundleRules_VibrationPermissionKit_NX_VibrationPermissionKit" }) },
                        { "_ZN2nn3hid20IsVibrationPermittedEv", new Tuple<string, List<string>>("nn::hid::IsVibrationPermitted()", new List<string>() { "0_12_BundleRules_VibrationPermissionKit_NX_VibrationPermissionKit" }) },
                        { "_ZN2nn2vi11CreateLayerEPPNS0_5LayerEPNS0_7DisplayEiiNS0_11PixelFormatENS_4util10BitFlagSetILi32ENS0_10LayerFlagsEEE", new Tuple<string, List<string>>("nn::vi::CreateLayer(nn::vi::Layer**, nn::vi::Display*, int, int, nn::vi::PixelFormat, nn::util::BitFlagSet<32, nn::vi::LayerFlags>)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi11CreateLayerEPPNS0_5LayerEPNS0_7DisplayENS_4util10BitFlagSetILi32ENS0_10LayerFlagsEEE", new Tuple<string, List<string>>("nn::vi::CreateLayer(nn::vi::Layer**, nn::vi::Display*, nn::util::BitFlagSet<32, nn::vi::LayerFlags>)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi12SetLayerSizeEPNS0_5LayerEii", new Tuple<string, List<string>>("nn::vi::SetLayerSize(nn::vi::Layer*, int, int)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi14GetDisplayModeEPNS0_15DisplayModeInfoEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayMode(nn::vi::DisplayModeInfo*, nn::vi::Display const*)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi14SetDisplayModeEPNS0_7DisplayEPKNS0_15DisplayModeInfoE", new Tuple<string, List<string>>("nn::vi::SetDisplayMode(nn::vi::Display*, nn::vi::DisplayModeInfo const*)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi15GetDisplayGammaEPfPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayGamma(float*, nn::vi::Display const*)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi15SetDisplayGammaEPNS0_7DisplayEf", new Tuple<string, List<string>>("nn::vi::SetDisplayGamma(nn::vi::Display*, float)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi16ListDisplayModesEPNS0_15DisplayModeInfoEiPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::ListDisplayModes(nn::vi::DisplayModeInfo*, int, nn::vi::Display const*)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi16SetLayerPositionEPNS0_5LayerEff", new Tuple<string, List<string>>("nn::vi::SetLayerPosition(nn::vi::Layer*, float, float)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi17GetDisplayCmuModeEPNS0_7CmuModeEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayCmuMode(nn::vi::CmuMode*, nn::vi::Display const*)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi17GetZOrderCountMaxEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetZOrderCountMax(nn::vi::Display const*)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi17GetZOrderCountMinEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetZOrderCountMin(nn::vi::Display const*)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi17SetDisplayCmuModeEPNS0_7DisplayENS0_7CmuModeE", new Tuple<string, List<string>>("nn::vi::SetDisplayCmuMode(nn::vi::Display*, nn::vi::CmuMode)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi18GetDisplayRgbRangeEPNS0_8RgbRangeEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayRgbRange(nn::vi::RgbRange*, nn::vi::Display const*)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi18SetDisplayRgbRangeEPNS0_7DisplayENS0_8RgbRangeE", new Tuple<string, List<string>>("nn::vi::SetDisplayRgbRange(nn::vi::Display*, nn::vi::RgbRange)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi19GetDisplayUnderscanEPiPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayUnderscan(int*, nn::vi::Display const*)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi19SetDisplayUnderscanEPNS0_7DisplayEi", new Tuple<string, List<string>>("nn::vi::SetDisplayUnderscan(nn::vi::Display*, int)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi20ListDisplayRgbRangesEPNS0_8RgbRangeEiPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::ListDisplayRgbRanges(nn::vi::RgbRange*, int, nn::vi::Display const*)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi21GetDisplayContentTypeEPNS0_11ContentTypeEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayContentType(nn::vi::ContentType*, nn::vi::Display const*)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi21SetDisplayContentTypeEPNS0_7DisplayENS0_11ContentTypeE", new Tuple<string, List<string>>("nn::vi::SetDisplayContentType(nn::vi::Display*, nn::vi::ContentType)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi23GetDisplayContrastRatioEPfPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayContrastRatio(float*, nn::vi::Display const*)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi23ListDisplayContentTypesEPNS0_11ContentTypeEiPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::ListDisplayContentTypes(nn::vi::ContentType*, int, nn::vi::Display const*)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi23SetDisplayContrastRatioEPNS0_7DisplayEf", new Tuple<string, List<string>>("nn::vi::SetDisplayContrastRatio(nn::vi::Display*, float)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi24InitializeForCompositionEv", new Tuple<string, List<string>>("nn::vi::InitializeForComposition()", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi24SetLayerSettingsDefaultsEPNS_4util10BitFlagSetILi32ENS0_10LayerFlagsEEE", new Tuple<string, List<string>>("nn::vi::SetLayerSettingsDefaults(nn::util::BitFlagSet<32, nn::vi::LayerFlags>*)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi27GetDisplayLogicalResolutionEPiS1_PKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayLogicalResolution(int*, int*, nn::vi::Display const*)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi9GetLayerZEPiPKNS0_5LayerE", new Tuple<string, List<string>>("nn::vi::GetLayerZ(int*, nn::vi::Layer const*)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi9SetLayerZEPNS0_5LayerEi", new Tuple<string, List<string>>("nn::vi::SetLayerZ(nn::vi::Layer*, int)", new List<string>() { "0_12_BundleRules_VideoInterfacePrivate_NX_VideoInterface_Private" }) },
                    }
                },
                {
                    "1", // SDKのメジャーバージョン
                    new Dictionary<string, Tuple<string, List<string>>> // <マングル名,<デマングル名,マングル名に対応するtitleタグのリスト>>
                    {
                        { "_ZN2nn2oe18ReportUserIsActiveEv", new Tuple<string, List<string>>("nn::oe::ReportUserIsActive()", new List<string>() { "1_BundleDefinitions_NX_OeReportUserIsActive" }) },
                        { "_ZN2nn2oe23BeginBlockingHomeButtonEv", new Tuple<string, List<string>>("nn::oe::BeginBlockingHomeButton()", new List<string>() { "1_BundleDefinitions_NX_BlockingHomeButton" }) },
                        { "_ZN2nn2oe21EndBlockingHomeButtonEv", new Tuple<string, List<string>>("nn::oe::EndBlockingHomeButton()", new List<string>() { "1_BundleDefinitions_NX_BlockingHomeButton" }) },
                        { "_ZN2nn5audio17SetAudioInEnabledEb", new Tuple<string, List<string>>("nn::audio::SetAudioInEnabled(bool)", new List<string>() { "1_BundleDefinitions_NX_AudioIn" }) },
                        { "_ZN2nn5audio16IsAudioInEnabledEv", new Tuple<string, List<string>>("nn::audio::IsAudioInEnabled()", new List<string>() { "1_BundleDefinitions_NX_AudioIn" }) },
                        { "_ZN2nn2oeL54PerformanceConfiguration_Cpu1020MhzGpu460MhzEmc1331MhzE", new Tuple<string, List<string>>("nn::oe::PerformanceConfiguration_Cpu1020MhzGpu460MhzEmc1331Mhz", new List<string>() { "1_BundleDefinitions_NX_BatteryDrainingPerformanceKit" }) },
                        { "_ZN2nn4bcat10InitializeEv", new Tuple<string, List<string>>("nn::bcat::Initialize()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat25MountDeliveryCacheStorageEv", new Tuple<string, List<string>>("nn::bcat::MountDeliveryCacheStorage()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat27UnmountDeliveryCacheStorageEv", new Tuple<string, List<string>>("nn::bcat::UnmountDeliveryCacheStorage()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat31EnumerateDeliveryCacheDirectoryEPiPNS0_13DirectoryNameEi", new Tuple<string, List<string>>("nn::bcat::EnumerateDeliveryCacheDirectory(int*, nn::bcat::DirectoryName*, int)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat24RequestSyncDeliveryCacheEv", new Tuple<string, List<string>>("nn::bcat::RequestSyncDeliveryCache()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat22DeliveryCacheDirectoryC2ERKS1_", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheDirectory::DeliveryCacheDirectory(nn::bcat::DeliveryCacheDirectory const&)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat22DeliveryCacheDirectoryC1ERKS1_", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheDirectory::DeliveryCacheDirectory(nn::bcat::DeliveryCacheDirectory const&)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat22DeliveryCacheDirectoryaSERKS1_", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheDirectory::operator=(nn::bcat::DeliveryCacheDirectory const&)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat22DeliveryCacheDirectoryC2EOS1_", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheDirectory::DeliveryCacheDirectory(nn::bcat::DeliveryCacheDirectory&&)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat22DeliveryCacheDirectoryC1EOS1_", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheDirectory::DeliveryCacheDirectory(nn::bcat::DeliveryCacheDirectory&&)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat22DeliveryCacheDirectoryaSEOS1_", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheDirectory::operator=(nn::bcat::DeliveryCacheDirectory&&)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat22DeliveryCacheDirectoryC2Ev", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheDirectory::DeliveryCacheDirectory()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat22DeliveryCacheDirectoryC1Ev", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheDirectory::DeliveryCacheDirectory()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat22DeliveryCacheDirectoryD2Ev", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheDirectory::~DeliveryCacheDirectory()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat22DeliveryCacheDirectoryD1Ev", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheDirectory::~DeliveryCacheDirectory()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat22DeliveryCacheDirectory4OpenEPKc", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheDirectory::Open(char const*)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat22DeliveryCacheDirectory4OpenERKNS0_13DirectoryNameE", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheDirectory::Open(nn::bcat::DirectoryName const&)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat22DeliveryCacheDirectory5CloseEv", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheDirectory::Close()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat22DeliveryCacheDirectory4ReadEPiPNS0_27DeliveryCacheDirectoryEntryEi", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheDirectory::Read(int*, nn::bcat::DeliveryCacheDirectoryEntry*, int)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat22DeliveryCacheDirectory8GetCountEv", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheDirectory::GetCount()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat17DeliveryCacheFileC2ERKS1_", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheFile::DeliveryCacheFile(nn::bcat::DeliveryCacheFile const&)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat17DeliveryCacheFileC1ERKS1_", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheFile::DeliveryCacheFile(nn::bcat::DeliveryCacheFile const&)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat17DeliveryCacheFileaSERKS1_", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheFile::operator=(nn::bcat::DeliveryCacheFile const&)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat17DeliveryCacheFileC2EOS1_", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheFile::DeliveryCacheFile(nn::bcat::DeliveryCacheFile&&)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat17DeliveryCacheFileC1EOS1_", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheFile::DeliveryCacheFile(nn::bcat::DeliveryCacheFile&&)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat17DeliveryCacheFileaSEOS1_", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheFile::operator=(nn::bcat::DeliveryCacheFile&&)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat17DeliveryCacheFileC2Ev", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheFile::DeliveryCacheFile()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat17DeliveryCacheFileC1Ev", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheFile::DeliveryCacheFile()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat17DeliveryCacheFileD2Ev", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheFile::~DeliveryCacheFile()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat17DeliveryCacheFileD1Ev", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheFile::~DeliveryCacheFile()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat17DeliveryCacheFile4OpenEPKc", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheFile::Open(char const*)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat17DeliveryCacheFile4OpenERKNS0_13DirectoryNameERKNS0_8FileNameE", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheFile::Open(nn::bcat::DirectoryName const&, nn::bcat::FileName const&)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat17DeliveryCacheFile5CloseEv", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheFile::Close()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat17DeliveryCacheFile4ReadEPmlPvm", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheFile::Read(unsigned long*, long, void*, unsigned long)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat17DeliveryCacheFile7GetSizeEv", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheFile::GetSize()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat17DeliveryCacheFile9GetDigestEv", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheFile::GetDigest()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat21DeliveryCacheProgressC2ERKS1_", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheProgress::DeliveryCacheProgress(nn::bcat::DeliveryCacheProgress const&)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat21DeliveryCacheProgressC1ERKS1_", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheProgress::DeliveryCacheProgress(nn::bcat::DeliveryCacheProgress const&)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat21DeliveryCacheProgressaSERKS1_", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheProgress::operator=(nn::bcat::DeliveryCacheProgress const&)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat21DeliveryCacheProgressC2EOS1_", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheProgress::DeliveryCacheProgress(nn::bcat::DeliveryCacheProgress&&)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat21DeliveryCacheProgressC1EOS1_", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheProgress::DeliveryCacheProgress(nn::bcat::DeliveryCacheProgress&&)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat21DeliveryCacheProgressaSEOS1_", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheProgress::operator=(nn::bcat::DeliveryCacheProgress&&)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat21DeliveryCacheProgressC2Ev", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheProgress::DeliveryCacheProgress()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat21DeliveryCacheProgressC1Ev", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheProgress::DeliveryCacheProgress()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat21DeliveryCacheProgressD2Ev", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheProgress::~DeliveryCacheProgress()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat21DeliveryCacheProgressD1Ev", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheProgress::~DeliveryCacheProgress()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat21DeliveryCacheProgress10InitializeEv", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheProgress::Initialize()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat21DeliveryCacheProgress8FinalizeEv", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheProgress::Finalize()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcat21DeliveryCacheProgress6UpdateEv", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheProgress::Update()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZNK2nn4bcat21DeliveryCacheProgress9GetStatusEv", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheProgress::GetStatus() const", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZNK2nn4bcat21DeliveryCacheProgress23GetCurrentDirectoryNameEv", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheProgress::GetCurrentDirectoryName() const", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZNK2nn4bcat21DeliveryCacheProgress18GetCurrentFileNameEv", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheProgress::GetCurrentFileName() const", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZNK2nn4bcat21DeliveryCacheProgress20GetCurrentDownloadedEv", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheProgress::GetCurrentDownloaded() const", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZNK2nn4bcat21DeliveryCacheProgress15GetCurrentTotalEv", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheProgress::GetCurrentTotal() const", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZNK2nn4bcat21DeliveryCacheProgress18GetWholeDownloadedEv", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheProgress::GetWholeDownloaded() const", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZNK2nn4bcat21DeliveryCacheProgress13GetWholeTotalEv", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheProgress::GetWholeTotal() const", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZNK2nn4bcat21DeliveryCacheProgress9GetResultEv", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheProgress::GetResult() const", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcatL30DeliveryCacheDirectoryCountMaxE", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheDirectoryCountMax", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4bcatL37DeliveryCacheFileCountMaxPerDirectoryE", new Tuple<string, List<string>>("nn::bcat::DeliveryCacheFileCountMaxPerDirectory", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZNK2nn4bcat8FileNamecvbEv", new Tuple<string, List<string>>("nn::bcat::FileName::operator bool() const", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZNK2nn4bcat13DirectoryNamecvbEv", new Tuple<string, List<string>>("nn::bcat::DirectoryName::operator bool() const", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn5album10InitializeEv", new Tuple<string, List<string>>("nn::album::Initialize()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn5album8FinalizeEv", new Tuple<string, List<string>>("nn::album::Finalize()", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn5album13GetImageWidthENS0_9ImageSizeE", new Tuple<string, List<string>>("nn::album::GetImageWidth(nn::album::ImageSize)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn5album14GetImageHeightENS0_9ImageSizeE", new Tuple<string, List<string>>("nn::album::GetImageHeight(nn::album::ImageSize)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn5album22SaveAndShareScreenshotEPNS0_7ShareIdEPKvmNS0_9ImageSizeENS0_17AlbumReportOptionERKNS_7account3UidE", new Tuple<string, List<string>>("nn::album::SaveAndShareScreenshot(nn::album::ShareId*, void const*, unsigned long, nn::album::ImageSize, nn::album::AlbumReportOption, nn::account::Uid const&)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn5album14SaveScreenshotEPKvmNS0_9ImageSizeENS0_17AlbumReportOptionE", new Tuple<string, List<string>>("nn::album::SaveScreenshot(void const*, unsigned long, nn::album::ImageSize, nn::album::AlbumReportOption)", new List<string>() { "1_BundleRules_BlitzKit_NX_Files" }) },
                        { "_ZN2nn4util28GetCountryFromIso31661Alpha2EPNS0_7CountryEPKcm", new Tuple<string, List<string>>("nn::util::GetCountryFromIso31661Alpha2(nn::util::Country*, char const*, unsigned long)", new List<string>() { "1_BundleRules_CachedNintendoAccountInfo_Generic_Files" }) },
                        { "_ZN2nn7account29LoadCachedNintendoAccountInfoEPNS0_25CachedNintendoAccountInfoERKNS0_10UserHandleEPvm", new Tuple<string, List<string>>("nn::account::LoadCachedNintendoAccountInfo(nn::account::CachedNintendoAccountInfo*, nn::account::UserHandle const&, void*, unsigned long)", new List<string>() { "1_BundleRules_CachedNintendoAccountInfo_Generic_Files" }) },
                        { "_ZN2nn7account25CachedNintendoAccountInfoC2Ev", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::CachedNintendoAccountInfo()", new List<string>() { "1_BundleRules_CachedNintendoAccountInfo_Generic_Files" }) },
                        { "_ZN2nn7account25CachedNintendoAccountInfoC1Ev", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::CachedNintendoAccountInfo()", new List<string>() { "1_BundleRules_CachedNintendoAccountInfo_Generic_Files" }) },
                        { "_ZNK2nn7account25CachedNintendoAccountInfo11GetBirthdayEPm", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::GetBirthday(unsigned long*) const", new List<string>() { "1_BundleRules_CachedNintendoAccountInfo_Generic_Files" }) },
                        { "_ZNK2nn7account25CachedNintendoAccountInfo9GetGenderEPm", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::GetGender(unsigned long*) const", new List<string>() { "1_BundleRules_CachedNintendoAccountInfo_Generic_Files" }) },
                        { "_ZNK2nn7account25CachedNintendoAccountInfo10GetCountryEPm", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::GetCountry(unsigned long*) const", new List<string>() { "1_BundleRules_CachedNintendoAccountInfo_Generic_Files" }) },
                        { "_ZN2nn7accountL46RequiredBufferSizeForCachedNintendoAccountInfoE", new Tuple<string, List<string>>("nn::account::RequiredBufferSizeForCachedNintendoAccountInfo", new List<string>() { "1_BundleRules_CachedNintendoAccountInfo_Generic_Files" }) },
                        { "_ZN2nn3xcdL14DeviceCountMaxE", new Tuple<string, List<string>>("nn::xcd::DeviceCountMax", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcdL13AddressLengthE", new Tuple<string, List<string>>("nn::xcd::AddressLength", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcdL24IdentificationCodeLengthE", new Tuple<string, List<string>>("nn::xcd::IdentificationCodeLength", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd19BindLinkUpdateEventEPNS_2os15SystemEventTypeE", new Tuple<string, List<string>>("nn::xcd::BindLinkUpdateEvent(nn::os::SystemEventType*)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd21UnbindLinkUpdateEventEPNS_2os15SystemEventTypeE", new Tuple<string, List<string>>("nn::xcd::UnbindLinkUpdateEvent(nn::os::SystemEventType*)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd11ListDevicesEPNS0_10DeviceListE", new Tuple<string, List<string>>("nn::xcd::ListDevices(nn::xcd::DeviceList*)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd6DetachEm", new Tuple<string, List<string>>("nn::xcd::Detach(unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd6RebootEmb", new Tuple<string, List<string>>("nn::xcd::Reboot(unsigned long, bool)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd6RebootEmbb", new Tuple<string, List<string>>("nn::xcd::Reboot(unsigned long, bool, bool)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd9McuResumeEmb", new Tuple<string, List<string>>("nn::xcd::McuResume(unsigned long, bool)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd13GetDeviceInfoEPNS0_10DeviceInfoEm", new Tuple<string, List<string>>("nn::xcd::GetDeviceInfo(nn::xcd::DeviceInfo*, unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd16SetSamplingEventEPNS_2os15SystemEventTypeEm", new Tuple<string, List<string>>("nn::xcd::SetSamplingEvent(nn::os::SystemEventType*, unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd21GetIdentificationCodeEPNS0_18IdentificationCodeEm", new Tuple<string, List<string>>("nn::xcd::GetIdentificationCode(nn::xcd::IdentificationCode*, unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd14GetDeviceColorEPNS_4util8Unorm8x4ES3_m", new Tuple<string, List<string>>("nn::xcd::GetDeviceColor(nn::util::Unorm8x4*, nn::util::Unorm8x4*, unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd29EnableWiredDeviceRegistrationEv", new Tuple<string, List<string>>("nn::xcd::EnableWiredDeviceRegistration()", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd30DisableWiredDeviceRegistrationEv", new Tuple<string, List<string>>("nn::xcd::DisableWiredDeviceRegistration()", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcdL27SixAxisSensorSampleCountMaxE", new Tuple<string, List<string>>("nn::xcd::SixAxisSensorSampleCountMax", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd11GetPadStateEPNS0_8PadStateEm", new Tuple<string, List<string>>("nn::xcd::GetPadState(nn::xcd::PadState*, unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd27GetButtonTriggerElapsedTimeEPNS_2os4TickEim", new Tuple<string, List<string>>("nn::xcd::GetButtonTriggerElapsedTime(nn::os::Tick*, int, unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd15GetSensorStatesEPiPNS0_18SixAxisSensorStateEim", new Tuple<string, List<string>>("nn::xcd::GetSensorStates(int*, nn::xcd::SixAxisSensorState*, int, unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd28GetLeftAnalogStickValidRangeEPNS0_21AnalogStickValidRangeEm", new Tuple<string, List<string>>("nn::xcd::GetLeftAnalogStickValidRange(nn::xcd::AnalogStickValidRange*, unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd31UpdateLeftAnalogStickValidRangeERKNS0_21AnalogStickValidRangeEm", new Tuple<string, List<string>>("nn::xcd::UpdateLeftAnalogStickValidRange(nn::xcd::AnalogStickValidRange const&, unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd30ResetLeftAnalogStickValidRangeEm", new Tuple<string, List<string>>("nn::xcd::ResetLeftAnalogStickValidRange(unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd40GetLeftAnalogStickValidRangeUpdateStatusEPNS0_23CalibrationUpdateStatusEm", new Tuple<string, List<string>>("nn::xcd::GetLeftAnalogStickValidRangeUpdateStatus(nn::xcd::CalibrationUpdateStatus*, unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd29GetRightAnalogStickValidRangeEPNS0_21AnalogStickValidRangeEm", new Tuple<string, List<string>>("nn::xcd::GetRightAnalogStickValidRange(nn::xcd::AnalogStickValidRange*, unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd32UpdateRightAnalogStickValidRangeERKNS0_21AnalogStickValidRangeEm", new Tuple<string, List<string>>("nn::xcd::UpdateRightAnalogStickValidRange(nn::xcd::AnalogStickValidRange const&, unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd31ResetRightAnalogStickValidRangeEm", new Tuple<string, List<string>>("nn::xcd::ResetRightAnalogStickValidRange(unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd41GetRightAnalogStickValidRangeUpdateStatusEPNS0_23CalibrationUpdateStatusEm", new Tuple<string, List<string>>("nn::xcd::GetRightAnalogStickValidRangeUpdateStatus(nn::xcd::CalibrationUpdateStatus*, unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd33GetLeftAnalogStickDeviceParameterEPNS0_26AnalogStickDeviceParameterEm", new Tuple<string, List<string>>("nn::xcd::GetLeftAnalogStickDeviceParameter(nn::xcd::AnalogStickDeviceParameter*, unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd34GetRightAnalogStickDeviceParameterEPNS0_26AnalogStickDeviceParameterEm", new Tuple<string, List<string>>("nn::xcd::GetRightAnalogStickDeviceParameter(nn::xcd::AnalogStickDeviceParameter*, unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd25GetSensorCalibrationValueEPNS0_22SensorCalibrationValueEm", new Tuple<string, List<string>>("nn::xcd::GetSensorCalibrationValue(nn::xcd::SensorCalibrationValue*, unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd28UpdateSensorCalibrationValueERKNS0_22SensorCalibrationValueEm", new Tuple<string, List<string>>("nn::xcd::UpdateSensorCalibrationValue(nn::xcd::SensorCalibrationValue const&, unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd27ResetSensorCalibrationValueEm", new Tuple<string, List<string>>("nn::xcd::ResetSensorCalibrationValue(unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd37GetSensorCalibrationValueUpdateStatusEPNS0_23CalibrationUpdateStatusEm", new Tuple<string, List<string>>("nn::xcd::GetSensorCalibrationValueUpdateStatus(nn::xcd::CalibrationUpdateStatus*, unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd25GetSensorHorizontalOffsetEPNS0_11SensorStateEm", new Tuple<string, List<string>>("nn::xcd::GetSensorHorizontalOffset(nn::xcd::SensorState*, unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd12GetSensorFsrEPNS0_16AccelerometerFsrEPNS0_12GyroscopeFsrEm", new Tuple<string, List<string>>("nn::xcd::GetSensorFsr(nn::xcd::AccelerometerFsr*, nn::xcd::GyroscopeFsr*, unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd12SetSensorFsrENS0_16AccelerometerFsrENS0_12GyroscopeFsrEm", new Tuple<string, List<string>>("nn::xcd::SetSensorFsr(nn::xcd::AccelerometerFsr, nn::xcd::GyroscopeFsr, unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd11SleepSensorEbm", new Tuple<string, List<string>>("nn::xcd::SleepSensor(bool, unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn3xcd13IsSensorSleepEPbm", new Tuple<string, List<string>>("nn::xcd::IsSensorSleep(bool*, unsigned long)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN3nnd7lsm6ds310InitializeEv", new Tuple<string, List<string>>("nnd::lsm6ds3::Initialize()", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN3nnd7lsm6ds310InitializeEii", new Tuple<string, List<string>>("nnd::lsm6ds3::Initialize(int, int)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN3nnd7lsm6ds38FinalizeEv", new Tuple<string, List<string>>("nnd::lsm6ds3::Finalize()", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN3nnd7lsm6ds311ResetDeviceEv", new Tuple<string, List<string>>("nnd::lsm6ds3::ResetDevice()", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN3nnd7lsm6ds38GetStateEPNS0_23SixAxisSensorCountStateE", new Tuple<string, List<string>>("nnd::lsm6ds3::GetState(nnd::lsm6ds3::SixAxisSensorCountState*)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN3nnd7lsm6ds323GetNoiseReductionFilterEPb", new Tuple<string, List<string>>("nnd::lsm6ds3::GetNoiseReductionFilter(bool*)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN3nnd7lsm6ds323SetNoiseReductionFilterEb", new Tuple<string, List<string>>("nnd::lsm6ds3::SetNoiseReductionFilter(bool)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN3nnd7lsm6ds318StartAccelerometerEv", new Tuple<string, List<string>>("nnd::lsm6ds3::StartAccelerometer()", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN3nnd7lsm6ds317StopAccelerometerEv", new Tuple<string, List<string>>("nnd::lsm6ds3::StopAccelerometer()", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN3nnd7lsm6ds319GetAccelerometerFsrEPNS0_16AccelerometerFsrE", new Tuple<string, List<string>>("nnd::lsm6ds3::GetAccelerometerFsr(nnd::lsm6ds3::AccelerometerFsr*)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN3nnd7lsm6ds319SetAccelerometerFsrENS0_16AccelerometerFsrE", new Tuple<string, List<string>>("nnd::lsm6ds3::SetAccelerometerFsr(nnd::lsm6ds3::AccelerometerFsr)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN3nnd7lsm6ds319GetAccelerometerOdrEPNS0_16AccelerometerOdrE", new Tuple<string, List<string>>("nnd::lsm6ds3::GetAccelerometerOdr(nnd::lsm6ds3::AccelerometerOdr*)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN3nnd7lsm6ds319SetAccelerometerOdrENS0_16AccelerometerOdrE", new Tuple<string, List<string>>("nnd::lsm6ds3::SetAccelerometerOdr(nnd::lsm6ds3::AccelerometerOdr)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN3nnd7lsm6ds314StartGyroscopeEv", new Tuple<string, List<string>>("nnd::lsm6ds3::StartGyroscope()", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN3nnd7lsm6ds313StopGyroscopeEv", new Tuple<string, List<string>>("nnd::lsm6ds3::StopGyroscope()", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN3nnd7lsm6ds315GetGyroscopeFsrEPNS0_12GyroscopeFsrE", new Tuple<string, List<string>>("nnd::lsm6ds3::GetGyroscopeFsr(nnd::lsm6ds3::GyroscopeFsr*)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN3nnd7lsm6ds315SetGyroscopeFsrENS0_12GyroscopeFsrE", new Tuple<string, List<string>>("nnd::lsm6ds3::SetGyroscopeFsr(nnd::lsm6ds3::GyroscopeFsr)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN3nnd7lsm6ds315GetGyroscopeOdrEPNS0_12GyroscopeOdrE", new Tuple<string, List<string>>("nnd::lsm6ds3::GetGyroscopeOdr(nnd::lsm6ds3::GyroscopeOdr*)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN3nnd7lsm6ds315SetGyroscopeOdrENS0_12GyroscopeOdrE", new Tuple<string, List<string>>("nnd::lsm6ds3::SetGyroscopeOdr(nnd::lsm6ds3::GyroscopeOdr)", new List<string>() { "1_BundleRules_ConsoleSixAxisSensorKit_NX_Files" }) },
                        { "_ZN2nn2fs19MountDeviceSaveDataEPKc", new Tuple<string, List<string>>("nn::fs::MountDeviceSaveData(char const*)", new List<string>() { "1_BundleDefinitions_NX_DeviceSaveDataKit" }) },
                        { "_ZN2nn7friends17SendFriendRequestEPNS0_12AsyncContextERKNS_7account3UidENS3_23NetworkServiceAccountIdERKNS0_15InAppScreenNameESA_", new Tuple<string, List<string>>("nn::friends::SendFriendRequest(nn::friends::AsyncContext*, nn::account::Uid const&, nn::account::NetworkServiceAccountId, nn::friends::InAppScreenName const&, nn::friends::InAppScreenName const&)", new List<string>() { "1_BundleRules_FriendRequestKit_Generic_Files_friend-request-kit", "1_BundleRules_FriendRequestKit_NX_Files_friend-request-kit" }) },
                        { "_ZN2nn7friends36GetFacedFriendRequestRegistrationKeyEPNS0_33FacedFriendRequestRegistrationKeyERKNS_7account3UidE", new Tuple<string, List<string>>("nn::friends::GetFacedFriendRequestRegistrationKey(nn::friends::FacedFriendRequestRegistrationKey*, nn::account::Uid const&)", new List<string>() { "1_BundleRules_FriendRequestKit_Generic_Files_friend-request-kit", "1_BundleRules_FriendRequestKit_NX_Files_friend-request-kit" }) },
                        { "_ZN2nn7friends21AddFacedFriendRequestERKNS_7account3UidERKNS0_33FacedFriendRequestRegistrationKeyERKNS1_8NicknameEPKvmRKNS0_15InAppScreenNameESF_", new Tuple<string, List<string>>("nn::friends::AddFacedFriendRequest(nn::account::Uid const&, nn::friends::FacedFriendRequestRegistrationKey const&, nn::account::Nickname const&, void const*, unsigned long, nn::friends::InAppScreenName const&, nn::friends::InAppScreenName const&)", new List<string>() { "1_BundleRules_FriendRequestKit_Generic_Files_friend-request-kit", "1_BundleRules_FriendRequestKit_NX_Files_friend-request-kit" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardC2ERKS1_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::InlineKeyboard(nn::swkbd::InlineKeyboard const&)", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardC1ERKS1_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::InlineKeyboard(nn::swkbd::InlineKeyboard const&)", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardaSERKS1_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::operator=(nn::swkbd::InlineKeyboard const&)", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardC2Ev", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::InlineKeyboard()", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardC1Ev", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::InlineKeyboard()", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardD2Ev", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::~InlineKeyboard()", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardD1Ev", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::~InlineKeyboard()", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard25GetRequiredWorkBufferSizeEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetRequiredWorkBufferSize()", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard10InitializeEPv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::Initialize(void*)", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard8FinalizeEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::Finalize()", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard6LaunchEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::Launch()", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard9SetVolumeEf", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetVolume(float)", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard6AppearERKNS0_9AppearArgE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::Appear(nn::swkbd::AppearArg const&)", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard9DisappearEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::Disappear()", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard12SetInputTextERKNS0_9InputTextE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetInputText(nn::swkbd::InputText const&)", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard12SetCursorPosEi", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetCursorPos(int)", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard15SetUserWordInfoERKNS0_12UserWordInfoE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetUserWordInfo(nn::swkbd::UserWordInfo const&)", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard17UnsetUserWordInfoEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::UnsetUserWordInfo()", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard11SetUtf8ModeEb", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetUtf8Mode(bool)", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard15SetCustomizeDicEPKvmRKNS0_16CustomizeDicInfoE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetCustomizeDic(void const*, unsigned long, nn::swkbd::CustomizeDicInfo const&)", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard17UnsetCustomizeDicEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::UnsetCustomizeDic()", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard14SetKeytopAlphaEf", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetKeytopAlpha(float)", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard14SetFooterAlphaEf", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetFooterAlpha(float)", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard14SetKeytopScaleEf", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetKeytopScale(float)", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard18SetKeytopTranslateEff", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetKeytopTranslate(float, float)", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard13SetWindowModeENS1_10WindowModeE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetWindowMode(nn::swkbd::InlineKeyboard::WindowMode)", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard15SetTouchEnabledEb", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetTouchEnabled(bool)", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZNK2nn5swkbd14InlineKeyboard18GetTouchRectanglesEPNS0_4RectES3_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetTouchRectangles(nn::swkbd::Rect*, nn::swkbd::Rect*) const", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard4CalcEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::Calc()", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard12GetMaxHeightEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetMaxHeight()", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard26IsUsedTouchPointByKeyboardEii", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::IsUsedTouchPointByKeyboard(int, int)", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard29SetFinishedInitializeCallbackEPFvvE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetFinishedInitializeCallback(void (*)())", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard27SetFinishedKeyboardCallbackEPFvvE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetFinishedKeyboardCallback(void (*)())", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard24SetChangedStringCallbackEPFvPKNS0_16ChangedStringArgEE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetChangedStringCallback(void (*)(nn::swkbd::ChangedStringArg const*))", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard28SetChangedStringCallbackUtf8EPFvPKNS0_20ChangedStringArgUtf8EE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetChangedStringCallbackUtf8(void (*)(nn::swkbd::ChangedStringArgUtf8 const*))", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard22SetMovedCursorCallbackEPFvPKNS0_14MovedCursorArgEE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetMovedCursorCallback(void (*)(nn::swkbd::MovedCursorArg const*))", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard26SetMovedCursorCallbackUtf8EPFvPKNS0_18MovedCursorArgUtf8EE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetMovedCursorCallbackUtf8(void (*)(nn::swkbd::MovedCursorArgUtf8 const*))", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard23SetDecidedEnterCallbackEPFvPKNS0_15DecidedEnterArgEE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetDecidedEnterCallback(void (*)(nn::swkbd::DecidedEnterArg const*))", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard27SetDecidedEnterCallbackUtf8EPFvPKNS0_19DecidedEnterArgUtf8EE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetDecidedEnterCallbackUtf8(void (*)(nn::swkbd::DecidedEnterArgUtf8 const*))", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard24SetDecidedCancelCallbackEPFvvE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetDecidedCancelCallback(void (*)())", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard31SetReleasedUserWordInfoCallbackEPFvvE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetReleasedUserWordInfoCallback(void (*)())", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZNK2nn5swkbd14InlineKeyboard13GetWindowSizeEPiS2_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetWindowSize(int*, int*) const", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard25GetImageMemoryRequirementEPmS2_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetImageMemoryRequirement(unsigned long*, unsigned long*)", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard8GetImageEPvm", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetImage(void*, unsigned long)", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd9AppearArgC2Ev", new Tuple<string, List<string>>("nn::swkbd::AppearArg::AppearArg()", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd9AppearArgC1Ev", new Tuple<string, List<string>>("nn::swkbd::AppearArg::AppearArg()", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd9InputTextC2Ev", new Tuple<string, List<string>>("nn::swkbd::InputText::InputText()", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd9InputTextC1Ev", new Tuple<string, List<string>>("nn::swkbd::InputText::InputText()", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd9InputText3SetEPKDs", new Tuple<string, List<string>>("nn::swkbd::InputText::Set(char16_t const*)", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd9InputText7SetUtf8EPKc", new Tuple<string, List<string>>("nn::swkbd::InputText::SetUtf8(char const*)", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd16CustomizeDicInfoC2Ev", new Tuple<string, List<string>>("nn::swkbd::CustomizeDicInfo::CustomizeDicInfo()", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd16CustomizeDicInfoC1Ev", new Tuple<string, List<string>>("nn::swkbd::CustomizeDicInfo::CustomizeDicInfo()", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd12UserWordInfoC2Ev", new Tuple<string, List<string>>("nn::swkbd::UserWordInfo::UserWordInfo()", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd12UserWordInfoC1Ev", new Tuple<string, List<string>>("nn::swkbd::UserWordInfo::UserWordInfo()", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn5swkbd12UserWordInfo25GetRequiredWorkBufferSizeEi", new Tuple<string, List<string>>("nn::swkbd::UserWordInfo::GetRequiredWorkBufferSize(int)", new List<string>() { "1_BundleRules_InlineSoftwareKeyboard_NX_Files" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC2ERKS1_", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(nn::os::SdkThreadLocalStorage const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC1ERKS1_", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(nn::os::SdkThreadLocalStorage const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageaSERKS1_", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::operator=(nn::os::SdkThreadLocalStorage const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC2EOS1_", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(nn::os::SdkThreadLocalStorage&&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC1EOS1_", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(nn::os::SdkThreadLocalStorage&&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageaSEOS1_", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::operator=(nn::os::SdkThreadLocalStorage&&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC2Ev", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC1Ev", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC2EPFvmE", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(void (*)(unsigned long))", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC1EPFvmE", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(void (*)(unsigned long))", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageD2Ev", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::~SdkThreadLocalStorage()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageD1Ev", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::~SdkThreadLocalStorage()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorage8SetValueEm", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SetValue(unsigned long)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZNK2nn2os21SdkThreadLocalStorage8GetValueEv", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::GetValue() const", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZNK2nn2os21SdkThreadLocalStorage10GetTlsSlotEv", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::GetTlsSlot() const", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn2os18SdkAllocateTlsSlotEPNS0_7TlsSlotEPFvmE", new Tuple<string, List<string>>("nn::os::SdkAllocateTlsSlot(nn::os::TlsSlot*, void (*)(unsigned long))", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC2ERKS1_", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection(nn::nifm::NetworkConnection const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC1ERKS1_", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection(nn::nifm::NetworkConnection const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionaSERKS1_", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::operator=(nn::nifm::NetworkConnection const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC2EOS1_", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection(nn::nifm::NetworkConnection&&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC1EOS1_", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection(nn::nifm::NetworkConnection&&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionaSEOS1_", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::operator=(nn::nifm::NetworkConnection&&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC2Ev", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC1Ev", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC2ENS_2os14EventClearModeE", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection(nn::os::EventClearMode)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC1ENS_2os14EventClearModeE", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection(nn::os::EventClearMode)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionD2Ev", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::~NetworkConnection()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionD1Ev", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::~NetworkConnection()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection13SubmitRequestEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::SubmitRequest()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection20SubmitRequestAndWaitEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::SubmitRequestAndWait()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection13CancelRequestEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::CancelRequest()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection15IsRequestOnHoldEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::IsRequestOnHold()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection11IsAvailableEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::IsAvailable()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection14GetSystemEventEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::GetSystemEvent()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection26HandleNetworkRequestResultEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::HandleNetworkRequestResult()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection16GetRequestHandleEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::GetRequestHandle()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection9GetResultEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::GetResult()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection15GetRequestStateEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::GetRequestState()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC2ERKS1_", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::Request const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC1ERKS1_", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::Request const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestaSERKS1_", new Tuple<string, List<string>>("nn::nifm::Request::operator=(nn::nifm::Request const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC2EOS1_", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::Request&&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC1EOS1_", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::Request&&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestaSEOS1_", new Tuple<string, List<string>>("nn::nifm::Request::operator=(nn::nifm::Request&&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC2ERKNS0_17RequestParametersE", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::RequestParameters const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC1ERKNS0_17RequestParametersE", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::RequestParameters const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC2ERKNS0_17RequestParametersENS_2os14EventClearModeE", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::RequestParameters const&, nn::os::EventClearMode)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC1ERKNS0_17RequestParametersENS_2os14EventClearModeE", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::RequestParameters const&, nn::os::EventClearMode)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestD2Ev", new Tuple<string, List<string>>("nn::nifm::Request::~Request()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestD1Ev", new Tuple<string, List<string>>("nn::nifm::Request::~Request()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request6SubmitEv", new Tuple<string, List<string>>("nn::nifm::Request::Submit()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request13SubmitAndWaitEv", new Tuple<string, List<string>>("nn::nifm::Request::SubmitAndWait()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request6CancelEv", new Tuple<string, List<string>>("nn::nifm::Request::Cancel()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request15GetRequestStateEv", new Tuple<string, List<string>>("nn::nifm::Request::GetRequestState()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request9GetResultEv", new Tuple<string, List<string>>("nn::nifm::Request::GetResult()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request9GetHandleEv", new Tuple<string, List<string>>("nn::nifm::Request::GetHandle()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request14GetSystemEventEv", new Tuple<string, List<string>>("nn::nifm::Request::GetSystemEvent()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC2ERKS1_", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::TemporaryNetworkProfile const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC1ERKS1_", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::TemporaryNetworkProfile const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileaSERKS1_", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::operator=(nn::nifm::TemporaryNetworkProfile const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC2EOS1_", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::TemporaryNetworkProfile&&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC1EOS1_", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::TemporaryNetworkProfile&&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileaSEOS1_", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::operator=(nn::nifm::TemporaryNetworkProfile&&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC2ERKNS0_18NetworkProfileDataE", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::NetworkProfileData const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC1ERKNS0_18NetworkProfileDataE", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::NetworkProfileData const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileD2Ev", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::~TemporaryNetworkProfile()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileD1Ev", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::~TemporaryNetworkProfile()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZNK2nn4nifm23TemporaryNetworkProfile5GetIdEv", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::GetId() const", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfile6UpdateERKNS0_18NetworkProfileDataE", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::Update(nn::nifm::NetworkProfileData const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfile9GetHandleEv", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::GetHandle()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm10MacAddress4SizeE", new Tuple<string, List<string>>("nn::nifm::MacAddress::Size", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_10MacAddressES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::MacAddress const&, nn::nifm::MacAddress const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_10MacAddressES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::MacAddress const&, nn::nifm::MacAddress const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmL24NetworkInterfaceCountMaxE", new Tuple<string, List<string>>("nn::nifm::NetworkInterfaceCountMax", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmL26UserNetworkProfileCountMaxE", new Tuple<string, List<string>>("nn::nifm::UserNetworkProfileCountMax", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmL30SsidListNetworkProfileCountMaxE", new Tuple<string, List<string>>("nn::nifm::SsidListNetworkProfileCountMax", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23NetworkProfileBasicInfo8NameSizeE", new Tuple<string, List<string>>("nn::nifm::NetworkProfileBasicInfo::NameSize", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm15SsidListVersion4SizeE", new Tuple<string, List<string>>("nn::nifm::SsidListVersion::Size", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmL22UserRequestPriorityTopE", new Tuple<string, List<string>>("nn::nifm::UserRequestPriorityTop", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmL25UserRequestPriorityBottomE", new Tuple<string, List<string>>("nn::nifm::UserRequestPriorityBottom", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm4Ssid7HexSizeE", new Tuple<string, List<string>>("nn::nifm::Ssid::HexSize", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm9SharedKey15KeyMaterialSizeE", new Tuple<string, List<string>>("nn::nifm::SharedKey::KeyMaterialSize", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmL26InvalidWirelessSettingDataE", new Tuple<string, List<string>>("nn::nifm::InvalidWirelessSettingData", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn3nsd7ResolveEPNS0_4FqdnERKS1_", new Tuple<string, List<string>>("nn::nsd::Resolve(nn::nsd::Fqdn*, nn::nsd::Fqdn const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn3nsd4Fqdn4SizeE", new Tuple<string, List<string>>("nn::nsd::Fqdn::Size", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn3nsdeqERKNS0_4FqdnES3_", new Tuple<string, List<string>>("nn::nsd::operator==(nn::nsd::Fqdn const&, nn::nsd::Fqdn const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn3nsdneERKNS0_4FqdnES3_", new Tuple<string, List<string>>("nn::nsd::operator!=(nn::nsd::Fqdn const&, nn::nsd::Fqdn const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn3nsd11SettingName4SizeE", new Tuple<string, List<string>>("nn::nsd::SettingName::Size", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn3nsd8PassCode4SizeE", new Tuple<string, List<string>>("nn::nsd::PassCode::Size", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn3nsd21EnvironmentIdentifier4SizeE", new Tuple<string, List<string>>("nn::nsd::EnvironmentIdentifier::Size", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn3nsdeqERKNS0_21EnvironmentIdentifierES3_", new Tuple<string, List<string>>("nn::nsd::operator==(nn::nsd::EnvironmentIdentifier const&, nn::nsd::EnvironmentIdentifier const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn3nsdneERKNS0_21EnvironmentIdentifierES3_", new Tuple<string, List<string>>("nn::nsd::operator!=(nn::nsd::EnvironmentIdentifier const&, nn::nsd::EnvironmentIdentifier const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_Generic_Files_NetworkMiddleware" }) },
                        { "_ZN2nn3web13ShowLobbyPageEPNS0_20LobbyPageReturnValueERKNS0_16ShowLobbyPageArgE", new Tuple<string, List<string>>("nn::web::ShowLobbyPage(nn::web::LobbyPageReturnValue*, nn::web::ShowLobbyPageArg const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_NX_Files_NetworkMiddleware" }) },
                        { "_ZN2nn3web16ShowLobbyPageArg23LobbyParameterMaxLengthE", new Tuple<string, List<string>>("nn::web::ShowLobbyPageArg::LobbyParameterMaxLength", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_NX_Files_NetworkMiddleware" }) },
                        { "_ZN2nn3web16ShowLobbyPageArgC2Ev", new Tuple<string, List<string>>("nn::web::ShowLobbyPageArg::ShowLobbyPageArg()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_NX_Files_NetworkMiddleware" }) },
                        { "_ZN2nn3web16ShowLobbyPageArgC1Ev", new Tuple<string, List<string>>("nn::web::ShowLobbyPageArg::ShowLobbyPageArg()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_NX_Files_NetworkMiddleware" }) },
                        { "_ZN2nn3web16ShowLobbyPageArg6SetUidERKNS_7account3UidE", new Tuple<string, List<string>>("nn::web::ShowLobbyPageArg::SetUid(nn::account::Uid const&)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_NX_Files_NetworkMiddleware" }) },
                        { "_ZN2nn3web16ShowLobbyPageArg17SetLobbyParameterEPKc", new Tuple<string, List<string>>("nn::web::ShowLobbyPageArg::SetLobbyParameter(char const*)", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_NX_Files_NetworkMiddleware" }) },
                        { "_ZN2nn3web16ShowLobbyPageArg8DataSizeE", new Tuple<string, List<string>>("nn::web::ShowLobbyPageArg::DataSize", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_NX_Files_NetworkMiddleware" }) },
                        { "_ZN2nn3web20LobbyPageReturnValue16LastUrlMaxLengthE", new Tuple<string, List<string>>("nn::web::LobbyPageReturnValue::LastUrlMaxLength", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_NX_Files_NetworkMiddleware" }) },
                        { "_ZN2nn3web20LobbyPageReturnValueC2Ev", new Tuple<string, List<string>>("nn::web::LobbyPageReturnValue::LobbyPageReturnValue()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_NX_Files_NetworkMiddleware" }) },
                        { "_ZN2nn3web20LobbyPageReturnValueC1Ev", new Tuple<string, List<string>>("nn::web::LobbyPageReturnValue::LobbyPageReturnValue()", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_NX_Files_NetworkMiddleware" }) },
                        { "_ZNK2nn3web20LobbyPageReturnValue18GetLobbyExitReasonEv", new Tuple<string, List<string>>("nn::web::LobbyPageReturnValue::GetLobbyExitReason() const", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_NX_Files_NetworkMiddleware" }) },
                        { "_ZNK2nn3web20LobbyPageReturnValue10GetLastUrlEv", new Tuple<string, List<string>>("nn::web::LobbyPageReturnValue::GetLastUrl() const", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_NX_Files_NetworkMiddleware" }) },
                        { "_ZNK2nn3web20LobbyPageReturnValue14GetLastUrlSizeEv", new Tuple<string, List<string>>("nn::web::LobbyPageReturnValue::GetLastUrlSize() const", new List<string>() { "1_BundleRules_NetworkMiddlewareKit_NX_Files_NetworkMiddleware" }) },
                        { "_ZN2nn3ldn11ScanPrivateEPNS0_11NetworkInfoEPiiRKNS0_10ScanFilterEi", new Tuple<string, List<string>>("nn::ldn::ScanPrivate(nn::ldn::NetworkInfo*, int*, int, nn::ldn::ScanFilter const&, int)", new List<string>() { "1_BundleDefinitions_NX_Ldn_Private" }) },
                        { "_ZN2nn3ldn20CreateNetworkPrivateERKNS0_13NetworkConfigERKNS0_14SecurityConfigERKNS0_17SecurityParameterERKNS0_10UserConfigEiPKNS0_12AddressEntryE", new Tuple<string, List<string>>("nn::ldn::CreateNetworkPrivate(nn::ldn::NetworkConfig const&, nn::ldn::SecurityConfig const&, nn::ldn::SecurityParameter const&, nn::ldn::UserConfig const&, int, nn::ldn::AddressEntry const*)", new List<string>() { "1_BundleDefinitions_NX_Ldn_Private" }) },
                        { "_ZN2nn3ldn14ConnectPrivateERKNS0_13NetworkConfigERKNS0_14SecurityConfigERKNS0_17SecurityParameterERKNS0_10UserConfigEiNS0_13ConnectOptionE", new Tuple<string, List<string>>("nn::ldn::ConnectPrivate(nn::ldn::NetworkConfig const&, nn::ldn::SecurityConfig const&, nn::ldn::SecurityParameter const&, nn::ldn::UserConfig const&, int, nn::ldn::ConnectOption)", new List<string>() { "1_BundleDefinitions_NX_Ldn_Private" }) },
                        { "_ZN2nn3ldn14ConnectPrivateERKNS0_13NetworkConfigERKNS0_14SecurityConfigERKNS0_17SecurityParameterERKNS0_10UserConfigEi", new Tuple<string, List<string>>("nn::ldn::ConnectPrivate(nn::ldn::NetworkConfig const&, nn::ldn::SecurityConfig const&, nn::ldn::SecurityParameter const&, nn::ldn::UserConfig const&, int)", new List<string>() { "1_BundleDefinitions_NX_Ldn_Private" }) },
                        { "_ZN2nn3ldn20GetSecurityParameterEPNS0_17SecurityParameterE", new Tuple<string, List<string>>("nn::ldn::GetSecurityParameter(nn::ldn::SecurityParameter*)", new List<string>() { "1_BundleDefinitions_NX_Ldn_Private" }) },
                        { "_ZN2nn3ldn16GetNetworkConfigEPNS0_13NetworkConfigE", new Tuple<string, List<string>>("nn::ldn::GetNetworkConfig(nn::ldn::NetworkConfig*)", new List<string>() { "1_BundleDefinitions_NX_Ldn_Private" }) },
                        { "_ZN2nn3ldn20AddAcceptFilterEntryENS0_10MacAddressE", new Tuple<string, List<string>>("nn::ldn::AddAcceptFilterEntry(nn::ldn::MacAddress)", new List<string>() { "1_BundleDefinitions_NX_Ldn_Private" }) },
                        { "_ZN2nn3ldnL11PriorityMinE", new Tuple<string, List<string>>("nn::ldn::PriorityMin", new List<string>() { "1_BundleDefinitions_NX_Ldn_Private" }) },
                        { "_ZN2nn3ldnL11PriorityMaxE", new Tuple<string, List<string>>("nn::ldn::PriorityMax", new List<string>() { "1_BundleDefinitions_NX_Ldn_Private" }) },
                        { "_ZN2nn3ldnL12UserPriorityE", new Tuple<string, List<string>>("nn::ldn::UserPriority", new List<string>() { "1_BundleDefinitions_NX_Ldn_Private" }) },
                        { "_ZN2nn3ldnL21DefaultSystemPriorityE", new Tuple<string, List<string>>("nn::ldn::DefaultSystemPriority", new List<string>() { "1_BundleDefinitions_NX_Ldn_Private" }) },
                        { "_ZN2nn3ldnL20AddressEntryCountMaxE", new Tuple<string, List<string>>("nn::ldn::AddressEntryCountMax", new List<string>() { "1_BundleDefinitions_NX_Ldn_Private" }) },
                        { "_ZN2nn3lbl27EnableAutoBrightnessControlEv", new Tuple<string, List<string>>("nn::lbl::EnableAutoBrightnessControl()", new List<string>() { "1_BundleDefinitions_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl28DisableAutoBrightnessControlEv", new Tuple<string, List<string>>("nn::lbl::DisableAutoBrightnessControl()", new List<string>() { "1_BundleDefinitions_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl30IsAutoBrightnessControlEnabledEv", new Tuple<string, List<string>>("nn::lbl::IsAutoBrightnessControlEnabled()", new List<string>() { "1_BundleDefinitions_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl26SetAmbientLightSensorValueEf", new Tuple<string, List<string>>("nn::lbl::SetAmbientLightSensorValue(float)", new List<string>() { "1_BundleDefinitions_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl26GetAmbientLightSensorValueEv", new Tuple<string, List<string>>("nn::lbl::GetAmbientLightSensorValue()", new List<string>() { "1_BundleDefinitions_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl33SetBrightnessReflectionDelayLevelENS0_25BrightnessChangeDirectionEf", new Tuple<string, List<string>>("nn::lbl::SetBrightnessReflectionDelayLevel(nn::lbl::BrightnessChangeDirection, float)", new List<string>() { "1_BundleDefinitions_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl33GetBrightnessReflectionDelayLevelENS0_25BrightnessChangeDirectionE", new Tuple<string, List<string>>("nn::lbl::GetBrightnessReflectionDelayLevel(nn::lbl::BrightnessChangeDirection)", new List<string>() { "1_BundleDefinitions_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl18SaveCurrentSettingEv", new Tuple<string, List<string>>("nn::lbl::SaveCurrentSetting()", new List<string>() { "1_BundleDefinitions_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl18LoadCurrentSettingEv", new Tuple<string, List<string>>("nn::lbl::LoadCurrentSetting()", new List<string>() { "1_BundleDefinitions_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl27SetCurrentBrightnessSettingEf", new Tuple<string, List<string>>("nn::lbl::SetCurrentBrightnessSetting(float)", new List<string>() { "1_BundleDefinitions_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl27GetCurrentBrightnessSettingEv", new Tuple<string, List<string>>("nn::lbl::GetCurrentBrightnessSetting()", new List<string>() { "1_BundleDefinitions_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl40ApplyCurrentBrightnessSettingToBacklightEv", new Tuple<string, List<string>>("nn::lbl::ApplyCurrentBrightnessSettingToBacklight()", new List<string>() { "1_BundleDefinitions_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl38GetBrightnessSettingAppliedToBacklightEv", new Tuple<string, List<string>>("nn::lbl::GetBrightnessSettingAppliedToBacklight()", new List<string>() { "1_BundleDefinitions_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl10InitializeEv", new Tuple<string, List<string>>("nn::lbl::Initialize()", new List<string>() { "1_BundleDefinitions_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl8FinalizeEv", new Tuple<string, List<string>>("nn::lbl::Finalize()", new List<string>() { "1_BundleDefinitions_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl27SetCurrentBrightnessMappingERKNS0_18MappingCoefficientE", new Tuple<string, List<string>>("nn::lbl::SetCurrentBrightnessMapping(nn::lbl::MappingCoefficient const&)", new List<string>() { "1_BundleDefinitions_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl27GetCurrentBrightnessMappingEPNS0_18MappingCoefficientE", new Tuple<string, List<string>>("nn::lbl::GetCurrentBrightnessMapping(nn::lbl::MappingCoefficient*)", new List<string>() { "1_BundleDefinitions_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl35SetCurrentAmbientLightSensorMappingERKNS0_18MappingCoefficientE", new Tuple<string, List<string>>("nn::lbl::SetCurrentAmbientLightSensorMapping(nn::lbl::MappingCoefficient const&)", new List<string>() { "1_BundleDefinitions_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lbl35GetCurrentAmbientLightSensorMappingEPNS0_18MappingCoefficientE", new Tuple<string, List<string>>("nn::lbl::GetCurrentAmbientLightSensorMapping(nn::lbl::MappingCoefficient*)", new List<string>() { "1_BundleDefinitions_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn3lblL18CoefficentCountMaxE", new Tuple<string, List<string>>("nn::lbl::CoefficentCountMax", new List<string>() { "1_BundleDefinitions_NX_BrightnessControl_Private" }) },
                        { "_ZN2nn2vi17GetZOrderCountMinEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetZOrderCountMin(nn::vi::Display const*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi17GetZOrderCountMaxEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetZOrderCountMax(nn::vi::Display const*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi27GetDisplayLogicalResolutionEPiS1_PKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayLogicalResolution(int*, int*, nn::vi::Display const*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi11CreateLayerEPPNS0_5LayerEPNS0_7DisplayENS_4util10BitFlagSetILi32ENS0_10LayerFlagsEEE", new Tuple<string, List<string>>("nn::vi::CreateLayer(nn::vi::Layer**, nn::vi::Display*, nn::util::BitFlagSet<32, nn::vi::LayerFlags>)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi16SetLayerPositionEPNS0_5LayerEff", new Tuple<string, List<string>>("nn::vi::SetLayerPosition(nn::vi::Layer*, float, float)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi12SetLayerSizeEPNS0_5LayerEii", new Tuple<string, List<string>>("nn::vi::SetLayerSize(nn::vi::Layer*, int, int)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi9SetLayerZEPNS0_5LayerEi", new Tuple<string, List<string>>("nn::vi::SetLayerZ(nn::vi::Layer*, int)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi9GetLayerZEPiPKNS0_5LayerE", new Tuple<string, List<string>>("nn::vi::GetLayerZ(int*, nn::vi::Layer const*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2viL19DisplayModeCountMaxE", new Tuple<string, List<string>>("nn::vi::DisplayModeCountMax", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi16ListDisplayModesEPNS0_15DisplayModeInfoEiPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::ListDisplayModes(nn::vi::DisplayModeInfo*, int, nn::vi::Display const*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi20ListDisplayRgbRangesEPNS0_8RgbRangeEiPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::ListDisplayRgbRanges(nn::vi::RgbRange*, int, nn::vi::Display const*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi23ListDisplayContentTypesEPNS0_11ContentTypeEiPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::ListDisplayContentTypes(nn::vi::ContentType*, int, nn::vi::Display const*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi14GetDisplayModeEPNS0_15DisplayModeInfoEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayMode(nn::vi::DisplayModeInfo*, nn::vi::Display const*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi14SetDisplayModeEPNS0_7DisplayEPKNS0_15DisplayModeInfoE", new Tuple<string, List<string>>("nn::vi::SetDisplayMode(nn::vi::Display*, nn::vi::DisplayModeInfo const*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi19GetDisplayUnderscanEPiPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayUnderscan(int*, nn::vi::Display const*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi19SetDisplayUnderscanEPNS0_7DisplayEi", new Tuple<string, List<string>>("nn::vi::SetDisplayUnderscan(nn::vi::Display*, int)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi21GetDisplayContentTypeEPNS0_11ContentTypeEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayContentType(nn::vi::ContentType*, nn::vi::Display const*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi21SetDisplayContentTypeEPNS0_7DisplayENS0_11ContentTypeE", new Tuple<string, List<string>>("nn::vi::SetDisplayContentType(nn::vi::Display*, nn::vi::ContentType)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi18GetDisplayRgbRangeEPNS0_8RgbRangeEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayRgbRange(nn::vi::RgbRange*, nn::vi::Display const*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi18SetDisplayRgbRangeEPNS0_7DisplayENS0_8RgbRangeE", new Tuple<string, List<string>>("nn::vi::SetDisplayRgbRange(nn::vi::Display*, nn::vi::RgbRange)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi24SetLayerSettingsDefaultsEPNS_4util10BitFlagSetILi32ENS0_10LayerFlagsEEE", new Tuple<string, List<string>>("nn::vi::SetLayerSettingsDefaults(nn::util::BitFlagSet<32, nn::vi::LayerFlags>*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi17GetDisplayCmuModeEPNS0_7CmuModeEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayCmuMode(nn::vi::CmuMode*, nn::vi::Display const*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi17SetDisplayCmuModeEPNS0_7DisplayENS0_7CmuModeE", new Tuple<string, List<string>>("nn::vi::SetDisplayCmuMode(nn::vi::Display*, nn::vi::CmuMode)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi23GetDisplayContrastRatioEPfPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayContrastRatio(float*, nn::vi::Display const*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi23SetDisplayContrastRatioEPNS0_7DisplayEf", new Tuple<string, List<string>>("nn::vi::SetDisplayContrastRatio(nn::vi::Display*, float)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi15GetDisplayGammaEPfPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayGamma(float*, nn::vi::Display const*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi15SetDisplayGammaEPNS0_7DisplayEf", new Tuple<string, List<string>>("nn::vi::SetDisplayGamma(nn::vi::Display*, float)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec10InitializeEPNS_2os15SystemEventTypeE", new Tuple<string, List<string>>("nn::cec::Initialize(nn::os::SystemEventType*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec8FinalizeEPNS_2os15SystemEventTypeE", new Tuple<string, List<string>>("nn::cec::Finalize(nn::os::SystemEventType*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec19PerformOneTouchPlayEv", new Tuple<string, List<string>>("nn::cec::PerformOneTouchPlay()", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec16PerformGoStandbyEb", new Tuple<string, List<string>>("nn::cec::PerformGoStandby(bool)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec21PerformInactiveSourceEv", new Tuple<string, List<string>>("nn::cec::PerformInactiveSource()", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec17SetOnScreenStringEPKc", new Tuple<string, List<string>>("nn::cec::SetOnScreenString(char const*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec13SetPowerStateENS0_10PowerStateE", new Tuple<string, List<string>>("nn::cec::SetPowerState(nn::cec::PowerState)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec14SuspendManagerEv", new Tuple<string, List<string>>("nn::cec::SuspendManager()", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec14RestartManagerEv", new Tuple<string, List<string>>("nn::cec::RestartManager()", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec20CancelCurrentApiCallEPb", new Tuple<string, List<string>>("nn::cec::CancelCurrentApiCall(bool*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec9IsStartedEPb", new Tuple<string, List<string>>("nn::cec::IsStarted(bool*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec13GetPowerStateEPNS0_10PowerStateE", new Tuple<string, List<string>>("nn::cec::GetPowerState(nn::cec::PowerState*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec15GetTvPowerStateEPNS0_10PowerStateE", new Tuple<string, List<string>>("nn::cec::GetTvPowerState(nn::cec::PowerState*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec14IsTvResponsiveEPb", new Tuple<string, List<string>>("nn::cec::IsTvResponsive(bool*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec18GetConnectionStateEPNS0_15ConnectionStateE", new Tuple<string, List<string>>("nn::cec::GetConnectionState(nn::cec::ConnectionState*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec9IsEnabledEPb", new Tuple<string, List<string>>("nn::cec::IsEnabled(bool*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec14IsActiveSourceEPb", new Tuple<string, List<string>>("nn::cec::IsActiveSource(bool*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec15GetBusEventTypeEPNS0_12BusEventTypeE", new Tuple<string, List<string>>("nn::cec::GetBusEventType(nn::cec::BusEventType*)", new List<string>() { "1_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN5movie13BrowserConfigC2Ev", new Tuple<string, List<string>>("movie::BrowserConfig::BrowserConfig()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13BrowserConfigC1Ev", new Tuple<string, List<string>>("movie::BrowserConfig::BrowserConfig()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13BrowserPlayer6CreateEPPS0_PNS_12PlayerConfigE", new Tuple<string, List<string>>("movie::BrowserPlayer::Create(movie::BrowserPlayer**, movie::PlayerConfig*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13BrowserPlayer6CreateEPPS0_PNS_12PlayerConfigEPNS_13BrowserConfigE", new Tuple<string, List<string>>("movie::BrowserPlayer::Create(movie::BrowserPlayer**, movie::PlayerConfig*, movie::BrowserConfig*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13BrowserPlayer7DestroyEPS0_", new Tuple<string, List<string>>("movie::BrowserPlayer::Destroy(movie::BrowserPlayer*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13BrowserPlayer11CanPlayTypeEPKcS2_", new Tuple<string, List<string>>("movie::BrowserPlayer::CanPlayType(char const*, char const*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13BrowserPlayer12SetCacheSizeENS0_9CacheSizeE", new Tuple<string, List<string>>("movie::BrowserPlayer::SetCacheSize(movie::BrowserPlayer::CacheSize)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13BrowserPlayer11IsCacheFullEPb", new Tuple<string, List<string>>("movie::BrowserPlayer::IsCacheFull(bool*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13BrowserPlayer16GetBufferedRangeEPfS1_", new Tuple<string, List<string>>("movie::BrowserPlayer::GetBufferedRange(float*, float*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13BrowserPlayer22GetSupportedTypesCountEv", new Tuple<string, List<string>>("movie::BrowserPlayer::GetSupportedTypesCount()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13BrowserPlayer16GetSupportedTypeEi", new Tuple<string, List<string>>("movie::BrowserPlayer::GetSupportedType(int)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13BrowserPlayer12SetMSESourceEPKNS_9MSESourceE", new Tuple<string, List<string>>("movie::BrowserPlayer::SetMSESource(movie::MSESource const*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13BrowserPlayer12GetMSESourceEPPNS_9MSESourceE", new Tuple<string, List<string>>("movie::BrowserPlayer::GetMSESource(movie::MSESource**)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13BrowserPlayer11SetObserverEPNS_21BrowserPlayerObserverE", new Tuple<string, List<string>>("movie::BrowserPlayer::SetObserver(movie::BrowserPlayerObserver*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13BrowserPlayer11GetObserverEPPNS_21BrowserPlayerObserverE", new Tuple<string, List<string>>("movie::BrowserPlayer::GetObserver(movie::BrowserPlayerObserver**)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13BrowserPlayerC2Ev", new Tuple<string, List<string>>("movie::BrowserPlayer::BrowserPlayer()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13BrowserPlayerD2Ev", new Tuple<string, List<string>>("movie::BrowserPlayer::~BrowserPlayer()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13BrowserPlayerD1Ev", new Tuple<string, List<string>>("movie::BrowserPlayer::~BrowserPlayer()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13BrowserPlayerD0Ev", new Tuple<string, List<string>>("movie::BrowserPlayer::~BrowserPlayer()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie21BrowserPlayerObserver13OnHttpRequestEPvPKc", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::OnHttpRequest(void*, char const*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie21BrowserPlayerObserver13OnMultiConfigEPvPKc", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::OnMultiConfig(void*, char const*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie21BrowserPlayerObserver14OnHttpResponseEPvPKc", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::OnHttpResponse(void*, char const*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie21BrowserPlayerObserverD2Ev", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::~BrowserPlayerObserver()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie21BrowserPlayerObserverD1Ev", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::~BrowserPlayerObserver()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie21BrowserPlayerObserverD0Ev", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::~BrowserPlayerObserver()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Codec6CreateEPPS0_PKcbbb", new Tuple<string, List<string>>("movie::Codec::Create(movie::Codec**, char const*, bool, bool, bool)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Codec7DestroyEPS0_", new Tuple<string, List<string>>("movie::Codec::Destroy(movie::Codec*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Codec9ConfigureEPNS_9MediaDataEPN2nn2vi5LayerEPv", new Tuple<string, List<string>>("movie::Codec::Configure(movie::MediaData*, nn::vi::Layer*, void*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Codec11SetCallbackEPNS_13CodecCallbackE", new Tuple<string, List<string>>("movie::Codec::SetCallback(movie::CodecCallback*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Codec13SetInputLayerEPN2nn2vi5LayerE", new Tuple<string, List<string>>("movie::Codec::SetInputLayer(nn::vi::Layer*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Codec5StartEv", new Tuple<string, List<string>>("movie::Codec::Start()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Codec4StopEv", new Tuple<string, List<string>>("movie::Codec::Stop()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Codec5ResetEv", new Tuple<string, List<string>>("movie::Codec::Reset()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Codec7ReleaseEv", new Tuple<string, List<string>>("movie::Codec::Release()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Codec5FlushEv", new Tuple<string, List<string>>("movie::Codec::Flush()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Codec14GetInputBufferEiPNS_6BufferE", new Tuple<string, List<string>>("movie::Codec::GetInputBuffer(int, movie::Buffer*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Codec16QueueInputBufferEiiilj", new Tuple<string, List<string>>("movie::Codec::QueueInputBuffer(int, int, int, long, unsigned int)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Codec15GetOutputBufferEiPNS_6BufferE", new Tuple<string, List<string>>("movie::Codec::GetOutputBuffer(int, movie::Buffer*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Codec19ReleaseOutputBufferEi", new Tuple<string, List<string>>("movie::Codec::ReleaseOutputBuffer(int)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Codec28RenderOutputBufferAndReleaseEi", new Tuple<string, List<string>>("movie::Codec::RenderOutputBufferAndRelease(int)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Codec28RenderOutputBufferAndReleaseEil", new Tuple<string, List<string>>("movie::Codec::RenderOutputBufferAndRelease(int, long)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Codec22SignalEndOfInputStreamEv", new Tuple<string, List<string>>("movie::Codec::SignalEndOfInputStream()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZNK5movie5Codec15GetOutputFormatEPNS_9MediaDataE", new Tuple<string, List<string>>("movie::Codec::GetOutputFormat(movie::MediaData*) const", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZNK5movie5Codec14GetInputFormatEPNS_9MediaDataE", new Tuple<string, List<string>>("movie::Codec::GetInputFormat(movie::MediaData*) const", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Codec15GetOutputFormatEiPNS_6BufferE", new Tuple<string, List<string>>("movie::Codec::GetOutputFormat(int, movie::Buffer*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZNK5movie5Codec7GetNameEPc", new Tuple<string, List<string>>("movie::Codec::GetName(char*) const", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Codec26CopyOutputBufferAndReleaseEPvi", new Tuple<string, List<string>>("movie::Codec::CopyOutputBufferAndRelease(void*, int)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Codec9GetStrideEPiS1_", new Tuple<string, List<string>>("movie::Codec::GetStride(int*, int*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5CodecC2Ev", new Tuple<string, List<string>>("movie::Codec::Codec()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5CodecD2Ev", new Tuple<string, List<string>>("movie::Codec::~Codec()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5CodecD1Ev", new Tuple<string, List<string>>("movie::Codec::~Codec()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5CodecD0Ev", new Tuple<string, List<string>>("movie::Codec::~Codec()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13CodecCallback7OnErrorEPNS_5CodecENS_6StatusE", new Tuple<string, List<string>>("movie::CodecCallback::OnError(movie::Codec*, movie::Status)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13CodecCallback22OnInputBufferAvailableEPNS_5CodecEi", new Tuple<string, List<string>>("movie::CodecCallback::OnInputBufferAvailable(movie::Codec*, int)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13CodecCallback23OnOutputBufferAvailableEPNS_5CodecEilj", new Tuple<string, List<string>>("movie::CodecCallback::OnOutputBufferAvailable(movie::Codec*, int, long, unsigned int)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13CodecCallback21OnOutputFormatChangedEPNS_5CodecEPNS_9MediaDataE", new Tuple<string, List<string>>("movie::CodecCallback::OnOutputFormatChanged(movie::Codec*, movie::MediaData*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13CodecCallbackD2Ev", new Tuple<string, List<string>>("movie::CodecCallback::~CodecCallback()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13CodecCallbackD1Ev", new Tuple<string, List<string>>("movie::CodecCallback::~CodecCallback()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie13CodecCallbackD0Ev", new Tuple<string, List<string>>("movie::CodecCallback::~CodecCallback()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie10DataSourceC2Ev", new Tuple<string, List<string>>("movie::DataSource::DataSource()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie10DataSourceD2Ev", new Tuple<string, List<string>>("movie::DataSource::~DataSource()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie10DataSourceD1Ev", new Tuple<string, List<string>>("movie::DataSource::~DataSource()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie10DataSourceD0Ev", new Tuple<string, List<string>>("movie::DataSource::~DataSource()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie10DataSource9initCheckEv", new Tuple<string, List<string>>("movie::DataSource::initCheck()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie10DataSource6readAtElPvm", new Tuple<string, List<string>>("movie::DataSource::readAt(long, void*, unsigned long)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie10DataSource7getSizeEv", new Tuple<string, List<string>>("movie::DataSource::getSize()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie9MSESourceC2Ev", new Tuple<string, List<string>>("movie::MSESource::MSESource()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie9MSESourceD2Ev", new Tuple<string, List<string>>("movie::MSESource::~MSESource()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie9MSESourceD1Ev", new Tuple<string, List<string>>("movie::MSESource::~MSESource()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie9MSESourceD0Ev", new Tuple<string, List<string>>("movie::MSESource::~MSESource()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie9MSESource15AddSourceBufferEPNS_10DataSourceE", new Tuple<string, List<string>>("movie::MSESource::AddSourceBuffer(movie::DataSource*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie9MSESource20GetSourceBufferCountEv", new Tuple<string, List<string>>("movie::MSESource::GetSourceBufferCount()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie9MSESource15GetSourceBufferEm", new Tuple<string, List<string>>("movie::MSESource::GetSourceBuffer(unsigned long)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie9MSESource18RemoveSourceBufferEm", new Tuple<string, List<string>>("movie::MSESource::RemoveSourceBuffer(unsigned long)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie15ExtractorConfigC2Ev", new Tuple<string, List<string>>("movie::ExtractorConfig::ExtractorConfig()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie15ExtractorConfigC1Ev", new Tuple<string, List<string>>("movie::ExtractorConfig::ExtractorConfig()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie15PlayerExtractor6CreateEPPS0_", new Tuple<string, List<string>>("movie::PlayerExtractor::Create(movie::PlayerExtractor**)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie15PlayerExtractor6CreateEPPS0_PNS_15ExtractorConfigE", new Tuple<string, List<string>>("movie::PlayerExtractor::Create(movie::PlayerExtractor**, movie::ExtractorConfig*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie15PlayerExtractor7DestroyEPS0_", new Tuple<string, List<string>>("movie::PlayerExtractor::Destroy(movie::PlayerExtractor*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie15PlayerExtractor13SetDataSourceEPKc", new Tuple<string, List<string>>("movie::PlayerExtractor::SetDataSource(char const*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie15PlayerExtractor13SetDataSourceEPKvi", new Tuple<string, List<string>>("movie::PlayerExtractor::SetDataSource(void const*, int)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZNK5movie15PlayerExtractor11CountTracksEPi", new Tuple<string, List<string>>("movie::PlayerExtractor::CountTracks(int*) const", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZNK5movie15PlayerExtractor14GetTrackFormatEiPNS_9MediaDataE", new Tuple<string, List<string>>("movie::PlayerExtractor::GetTrackFormat(int, movie::MediaData*) const", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZNK5movie15PlayerExtractor13GetFileFormatEPNS_9MediaDataE", new Tuple<string, List<string>>("movie::PlayerExtractor::GetFileFormat(movie::MediaData*) const", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie15PlayerExtractor11SelectTrackEi", new Tuple<string, List<string>>("movie::PlayerExtractor::SelectTrack(int)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie15PlayerExtractor13UnselectTrackEi", new Tuple<string, List<string>>("movie::PlayerExtractor::UnselectTrack(int)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie15PlayerExtractor6SeekToEl", new Tuple<string, List<string>>("movie::PlayerExtractor::SeekTo(long)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie15PlayerExtractor7AdvanceEv", new Tuple<string, List<string>>("movie::PlayerExtractor::Advance()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie15PlayerExtractor14ReadSampleDataEPNS_6BufferE", new Tuple<string, List<string>>("movie::PlayerExtractor::ReadSampleData(movie::Buffer*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie15PlayerExtractor19GetSampleTrackIndexEPm", new Tuple<string, List<string>>("movie::PlayerExtractor::GetSampleTrackIndex(unsigned long*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie15PlayerExtractor13GetSampleTimeEPl", new Tuple<string, List<string>>("movie::PlayerExtractor::GetSampleTime(long*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie15PlayerExtractor13GetSampleTimeEmPl", new Tuple<string, List<string>>("movie::PlayerExtractor::GetSampleTime(unsigned long, long*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie15PlayerExtractor13GetSampleMetaEPNS_9MediaDataE", new Tuple<string, List<string>>("movie::PlayerExtractor::GetSampleMeta(movie::MediaData*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZNK5movie15PlayerExtractor17GetCachedDurationEPlPb", new Tuple<string, List<string>>("movie::PlayerExtractor::GetCachedDuration(long*, bool*) const", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie15PlayerExtractor19CancelSetDataSourceEv", new Tuple<string, List<string>>("movie::PlayerExtractor::CancelSetDataSource()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie15PlayerExtractor11IsCacheFullEPb", new Tuple<string, List<string>>("movie::PlayerExtractor::IsCacheFull(bool*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie15PlayerExtractor26TerminateNetworkConnectionEv", new Tuple<string, List<string>>("movie::PlayerExtractor::TerminateNetworkConnection()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie15PlayerExtractorC2Ev", new Tuple<string, List<string>>("movie::PlayerExtractor::PlayerExtractor()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie15PlayerExtractorC2EPNS_15ExtractorConfigE", new Tuple<string, List<string>>("movie::PlayerExtractor::PlayerExtractor(movie::ExtractorConfig*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie15PlayerExtractorD2Ev", new Tuple<string, List<string>>("movie::PlayerExtractor::~PlayerExtractor()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie15PlayerExtractorD1Ev", new Tuple<string, List<string>>("movie::PlayerExtractor::~PlayerExtractor()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie15PlayerExtractorD0Ev", new Tuple<string, List<string>>("movie::PlayerExtractor::~PlayerExtractor()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Muxer6CreateEPPS0_PKcNS_17MuxerOutputFormatE", new Tuple<string, List<string>>("movie::Muxer::Create(movie::Muxer**, char const*, movie::MuxerOutputFormat)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Muxer7DestroyEPS0_", new Tuple<string, List<string>>("movie::Muxer::Destroy(movie::Muxer*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Muxer8AddTrackEPiNS_11TrackFormatE", new Tuple<string, List<string>>("movie::Muxer::AddTrack(int*, movie::TrackFormat)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Muxer5StartEv", new Tuple<string, List<string>>("movie::Muxer::Start()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Muxer11SetLocationEii", new Tuple<string, List<string>>("movie::Muxer::SetLocation(int, int)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Muxer4StopEv", new Tuple<string, List<string>>("movie::Muxer::Stop()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5Muxer15WriteSampleDataERKNS_6BufferEilj", new Tuple<string, List<string>>("movie::Muxer::WriteSampleData(movie::Buffer const&, int, long, unsigned int)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5MuxerC2Ev", new Tuple<string, List<string>>("movie::Muxer::Muxer()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5MuxerD2Ev", new Tuple<string, List<string>>("movie::Muxer::~Muxer()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5MuxerD1Ev", new Tuple<string, List<string>>("movie::Muxer::~Muxer()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie5MuxerD0Ev", new Tuple<string, List<string>>("movie::Muxer::~Muxer()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player6CreateEPPS0_PNS_12PlayerConfigE", new Tuple<string, List<string>>("movie::Player::Create(movie::Player**, movie::PlayerConfig*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player7DestroyEPS0_", new Tuple<string, List<string>>("movie::Player::Destroy(movie::Player*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player11SetObserverEPNS_14PlayerObserverE", new Tuple<string, List<string>>("movie::Player::SetObserver(movie::PlayerObserver*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player11GetObserverEPPNS_14PlayerObserverE", new Tuple<string, List<string>>("movie::Player::GetObserver(movie::PlayerObserver**)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player13SetDataSourceEPKc", new Tuple<string, List<string>>("movie::Player::SetDataSource(char const*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player19CancelSetDataSourceEv", new Tuple<string, List<string>>("movie::Player::CancelSetDataSource()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player9GetVolumeEPf", new Tuple<string, List<string>>("movie::Player::GetVolume(float*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player9SetVolumeEf", new Tuple<string, List<string>>("movie::Player::SetVolume(float)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player7PrepareEv", new Tuple<string, List<string>>("movie::Player::Prepare()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player5StartEv", new Tuple<string, List<string>>("movie::Player::Start()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player4StopEv", new Tuple<string, List<string>>("movie::Player::Stop()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player5PauseEb", new Tuple<string, List<string>>("movie::Player::Pause(bool)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player6SeekToEl", new Tuple<string, List<string>>("movie::Player::SeekTo(long)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player26GetCurrentPlaybackPositionEPl", new Tuple<string, List<string>>("movie::Player::GetCurrentPlaybackPosition(long*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player19GetPlaybackDurationEPl", new Tuple<string, List<string>>("movie::Player::GetPlaybackDuration(long*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player13GetTrackCountEPi", new Tuple<string, List<string>>("movie::Player::GetTrackCount(int*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player11SelectTrackEi", new Tuple<string, List<string>>("movie::Player::SelectTrack(int)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player13DeSelectTrackEi", new Tuple<string, List<string>>("movie::Player::DeSelectTrack(int)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player12GetTrackTypeEiPNS_9TrackTypeE", new Tuple<string, List<string>>("movie::Player::GetTrackType(int, movie::TrackType*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player18GetVideoDimensionsEPiS1_", new Tuple<string, List<string>>("movie::Player::GetVideoDimensions(int*, int*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player5ResetEv", new Tuple<string, List<string>>("movie::Player::Reset()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player10SetLoopingEb", new Tuple<string, List<string>>("movie::Player::SetLooping(bool)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player10GetLoopingEPb", new Tuple<string, List<string>>("movie::Player::GetLooping(bool*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player15GetPlaybackRateEPNS_12PlaybackRateE", new Tuple<string, List<string>>("movie::Player::GetPlaybackRate(movie::PlaybackRate*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player15SetPlaybackRateENS_12PlaybackRateE", new Tuple<string, List<string>>("movie::Player::SetPlaybackRate(movie::PlaybackRate)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player8GetStateEPNS_11PlayerStateE", new Tuple<string, List<string>>("movie::Player::GetState(movie::PlayerState*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player12GetTrackInfoEiPNS_9TrackInfoE", new Tuple<string, List<string>>("movie::Player::GetTrackInfo(int, movie::TrackInfo*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player24AcquireOutputBufferIndexEiPiPlS1_", new Tuple<string, List<string>>("movie::Player::AcquireOutputBufferIndex(int, int*, long*, int*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player19GetOutputBufferSizeEiPi", new Tuple<string, List<string>>("movie::Player::GetOutputBufferSize(int, int*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player16FillOutputBufferEiiPNS_6BufferEPlPj", new Tuple<string, List<string>>("movie::Player::FillOutputBuffer(int, int, movie::Buffer*, long*, unsigned int*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player24ReleaseOutputBufferIndexEii", new Tuple<string, List<string>>("movie::Player::ReleaseOutputBufferIndex(int, int)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player24SetOutputBufferAlignmentEPNS_9MediaDataE", new Tuple<string, List<string>>("movie::Player::SetOutputBufferAlignment(movie::MediaData*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player6SeekToElPl", new Tuple<string, List<string>>("movie::Player::SeekTo(long, long*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player25GetOutputBufferPropertiesEPNS_9MediaDataE", new Tuple<string, List<string>>("movie::Player::GetOutputBufferProperties(movie::MediaData*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6Player26TerminateNetworkConnectionEv", new Tuple<string, List<string>>("movie::Player::TerminateNetworkConnection()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6PlayerC2Ev", new Tuple<string, List<string>>("movie::Player::Player()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6PlayerD2Ev", new Tuple<string, List<string>>("movie::Player::~Player()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6PlayerD1Ev", new Tuple<string, List<string>>("movie::Player::~Player()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie6PlayerD0Ev", new Tuple<string, List<string>>("movie::Player::~Player()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie14PlayerObserver7OnErrorENS_6StatusE", new Tuple<string, List<string>>("movie::PlayerObserver::OnError(movie::Status)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie14PlayerObserver13OnStateChangeENS_11PlayerStateE", new Tuple<string, List<string>>("movie::PlayerObserver::OnStateChange(movie::PlayerState)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie14PlayerObserver17OnBufferingUpdateEff", new Tuple<string, List<string>>("movie::PlayerObserver::OnBufferingUpdate(float, float)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie14PlayerObserver27OnAudioOutputFrameAvailableEPNS_14AudioFrameInfoE", new Tuple<string, List<string>>("movie::PlayerObserver::OnAudioOutputFrameAvailable(movie::AudioFrameInfo*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie14PlayerObserver27OnVideoOutputFrameAvailableEPNS_14VideoFrameInfoE", new Tuple<string, List<string>>("movie::PlayerObserver::OnVideoOutputFrameAvailable(movie::VideoFrameInfo*)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie14PlayerObserver23OnOutputBufferAvailableEiNS_9TrackTypeE", new Tuple<string, List<string>>("movie::PlayerObserver::OnOutputBufferAvailable(int, movie::TrackType)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie14PlayerObserver15OnFormatChangedENS_9TrackTypeE", new Tuple<string, List<string>>("movie::PlayerObserver::OnFormatChanged(movie::TrackType)", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie14PlayerObserverD2Ev", new Tuple<string, List<string>>("movie::PlayerObserver::~PlayerObserver()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie14PlayerObserverD1Ev", new Tuple<string, List<string>>("movie::PlayerObserver::~PlayerObserver()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN5movie14PlayerObserverD0Ev", new Tuple<string, List<string>>("movie::PlayerObserver::~PlayerObserver()", new List<string>() { "1_BundleDefinitions_NX_MultimediaInterface_Private" }) },
                        { "_ZN2nn3ldn17InitializeMonitorEv", new Tuple<string, List<string>>("nn::ldn::InitializeMonitor()", new List<string>() { "1_BundleDefinitions_NX_Ldn_Monitor" }) },
                        { "_ZN2nn3ldn15FinalizeMonitorEv", new Tuple<string, List<string>>("nn::ldn::FinalizeMonitor()", new List<string>() { "1_BundleDefinitions_NX_Ldn_Monitor" }) },
                        { "_ZN2nn3ldn18GetStateForMonitorEv", new Tuple<string, List<string>>("nn::ldn::GetStateForMonitor()", new List<string>() { "1_BundleDefinitions_NX_Ldn_Monitor" }) },
                        { "_ZN2nn3ldn24GetNetworkInfoForMonitorEPNS0_11NetworkInfoE", new Tuple<string, List<string>>("nn::ldn::GetNetworkInfoForMonitor(nn::ldn::NetworkInfo*)", new List<string>() { "1_BundleDefinitions_NX_Ldn_Monitor" }) },
                        { "_ZN2nn3ldn24GetIpv4AddressForMonitorEPNS0_11Ipv4AddressEPNS0_10SubnetMaskE", new Tuple<string, List<string>>("nn::ldn::GetIpv4AddressForMonitor(nn::ldn::Ipv4Address*, nn::ldn::SubnetMask*)", new List<string>() { "1_BundleDefinitions_NX_Ldn_Monitor" }) },
                        { "_ZN2nn3ldn16InitializeSystemEv", new Tuple<string, List<string>>("nn::ldn::InitializeSystem()", new List<string>() { "1_BundleDefinitions_NX_Ldn_System" }) },
                        { "_ZN2nn3ldn14FinalizeSystemEv", new Tuple<string, List<string>>("nn::ldn::FinalizeSystem()", new List<string>() { "1_BundleDefinitions_NX_Ldn_System" }) },
                        { "_ZN2nn3btm6system19StartGamepadPairingEv", new Tuple<string, List<string>>("nn::btm::system::StartGamepadPairing()", new List<string>() { "1_BundleDefinitions_NX_Btm_system" }) },
                        { "_ZN2nn3btm6system20CancelGamepadPairingEv", new Tuple<string, List<string>>("nn::btm::system::CancelGamepadPairing()", new List<string>() { "1_BundleDefinitions_NX_Btm_system" }) },
                        { "_ZN2nn3btm6system27ClearGamepadPairingDatabaseEv", new Tuple<string, List<string>>("nn::btm::system::ClearGamepadPairingDatabase()", new List<string>() { "1_BundleDefinitions_NX_Btm_system" }) },
                        { "_ZN2nn3btm6system21GetPairedGamepadCountEv", new Tuple<string, List<string>>("nn::btm::system::GetPairedGamepadCount()", new List<string>() { "1_BundleDefinitions_NX_Btm_system" }) },
                        { "_ZN2nn3btm6system11EnableRadioEb", new Tuple<string, List<string>>("nn::btm::system::EnableRadio(bool)", new List<string>() { "1_BundleDefinitions_NX_Btm_system" }) },
                        { "_ZN2nn3btm6system14IsRadioEnabledEv", new Tuple<string, List<string>>("nn::btm::system::IsRadioEnabled()", new List<string>() { "1_BundleDefinitions_NX_Btm_system" }) },
                        { "_ZN2nv22SetGraphicsServiceNameEPKc", new Tuple<string, List<string>>("nv::SetGraphicsServiceName(char const*)", new List<string>() { "1_BundleDefinitions_NX_Nvn_Private" }) },
                        { "_ZN2nn4diag13OnResultThrowENS_6ResultERKNS0_10SourceInfoE", new Tuple<string, List<string>>("nn::diag::OnResultThrow(nn::Result, nn::diag::SourceInfo const&)", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn4diag14OnResultHandleENS_6ResultERKNS0_10SourceInfoE", new Tuple<string, List<string>>("nn::diag::OnResultHandle(nn::Result, nn::diag::SourceInfo const&)", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn4diag15OnResultRethrowENS_6ResultERKNS0_10SourceInfoE", new Tuple<string, List<string>>("nn::diag::OnResultRethrow(nn::Result, nn::diag::SourceInfo const&)", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn4diag13OnResultCatchENS_6ResultERKNS0_10SourceInfoE", new Tuple<string, List<string>>("nn::diag::OnResultCatch(nn::Result, nn::diag::SourceInfo const&)", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn4diag12OnResultMissENS_6ResultERKNS0_10SourceInfoE", new Tuple<string, List<string>>("nn::diag::OnResultMiss(nn::Result, nn::diag::SourceInfo const&)", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn6result6detail19ResultAutoConverterC2ENS_6ResultE", new Tuple<string, List<string>>("nn::result::detail::ResultAutoConverter::ResultAutoConverter(nn::Result)", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn6result6detail19ResultAutoConverterC1ENS_6ResultE", new Tuple<string, List<string>>("nn::result::detail::ResultAutoConverter::ResultAutoConverter(nn::Result)", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn6result6detail23MakeResultAutoConverterENS_6ResultE", new Tuple<string, List<string>>("nn::result::detail::MakeResultAutoConverter(nn::Result)", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderC2ERKNS1_17ResultBlockHolderIT_T0_EE", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::ResultBlockHolder", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderC1ERKNS1_17ResultBlockHolderIT_T0_EE", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::ResultBlockHolder", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderC2EOT0_", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::ResultBlockHolder", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderC1EOT0_", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::ResultBlockHolder", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderC2EONS1_17ResultBlockHolderIT_T0_EE", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::ResultBlockHolder", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderC1EONS1_17ResultBlockHolderIT_T0_EE", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::ResultBlockHolder", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderD2Ev", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::~ResultBlockHolder()", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderD1Ev", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::~ResultBlockHolder()", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn6result6detail14AbortForResult6HandleENS_6ResultE", new Tuple<string, List<string>>("nn::result::detail::AbortForResult::Handle(nn::Result)", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn6result6detail15IgnoreForResult6HandleENS_6ResultE", new Tuple<string, List<string>>("nn::result::detail::IgnoreForResult::Handle(nn::Result)", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm7RequestC2ERKS1_", new Tuple<string, List<string>>("nn::fgm::Request::Request(nn::fgm::Request const&)", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm7RequestC1ERKS1_", new Tuple<string, List<string>>("nn::fgm::Request::Request(nn::fgm::Request const&)", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm7RequestaSERKS1_", new Tuple<string, List<string>>("nn::fgm::Request::operator=(nn::fgm::Request const&)", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm7RequestC2EOS1_", new Tuple<string, List<string>>("nn::fgm::Request::Request(nn::fgm::Request&&)", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm7RequestC1EOS1_", new Tuple<string, List<string>>("nn::fgm::Request::Request(nn::fgm::Request&&)", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm7RequestaSEOS1_", new Tuple<string, List<string>>("nn::fgm::Request::operator=(nn::fgm::Request&&)", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm7Request10InitializeENS0_6ModuleEjNS_2os14EventClearModeE", new Tuple<string, List<string>>("nn::fgm::Request::Initialize(nn::fgm::Module, unsigned int, nn::os::EventClearMode)", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm7Request10InitializeENS0_6ModuleEj", new Tuple<string, List<string>>("nn::fgm::Request::Initialize(nn::fgm::Module, unsigned int)", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm7Request3SetEjj", new Tuple<string, List<string>>("nn::fgm::Request::Set(unsigned int, unsigned int)", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm7Request10SetAndWaitEjj", new Tuple<string, List<string>>("nn::fgm::Request::SetAndWait(unsigned int, unsigned int)", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm7Request21SetAndWaitWithTimeoutEjjNS_8TimeSpanE", new Tuple<string, List<string>>("nn::fgm::Request::SetAndWaitWithTimeout(unsigned int, unsigned int, nn::TimeSpan)", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm7Request3GetEPj", new Tuple<string, List<string>>("nn::fgm::Request::Get(unsigned int*)", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm7Request4WaitEv", new Tuple<string, List<string>>("nn::fgm::Request::Wait()", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm7Request15WaitWithTimeoutENS_8TimeSpanE", new Tuple<string, List<string>>("nn::fgm::Request::WaitWithTimeout(nn::TimeSpan)", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm7Request6CancelEv", new Tuple<string, List<string>>("nn::fgm::Request::Cancel()", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm7Request21GetSystemEventPointerEv", new Tuple<string, List<string>>("nn::fgm::Request::GetSystemEventPointer()", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm7Request10ClearEventEv", new Tuple<string, List<string>>("nn::fgm::Request::ClearEvent()", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm7Request8FinalizeEv", new Tuple<string, List<string>>("nn::fgm::Request::Finalize()", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm7RequestC2Ev", new Tuple<string, List<string>>("nn::fgm::Request::Request()", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm7RequestC1Ev", new Tuple<string, List<string>>("nn::fgm::Request::Request()", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm7RequestD2Ev", new Tuple<string, List<string>>("nn::fgm::Request::~Request()", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgm7RequestD1Ev", new Tuple<string, List<string>>("nn::fgm::Request::~Request()", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgmL18NumberOfPrioritiesE", new Tuple<string, List<string>>("nn::fgm::NumberOfPriorities", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgmL15FgmPortPriorityE", new Tuple<string, List<string>>("nn::fgm::FgmPortPriority", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgmL16FgmDebugPortNameE", new Tuple<string, List<string>>("nn::fgm::FgmDebugPortName", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgmL8PortNameE", new Tuple<string, List<string>>("nn::fgm::PortName", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn3fgmL26MaximumRequestsPerPriorityE", new Tuple<string, List<string>>("nn::fgm::MaximumRequestsPerPriority", new List<string>() { "1_BundleRules_PerformanceEvaluationKit_NX_Files" }) },
                        { "_ZN2nn5prepo10InitializeEv", new Tuple<string, List<string>>("nn::prepo::Initialize()", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo28RequestImmediateTransmissionEv", new Tuple<string, List<string>>("nn::prepo::RequestImmediateTransmission()", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo21GetTransmissionStatusEPNS0_18TransmissionStatusE", new Tuple<string, List<string>>("nn::prepo::GetTransmissionStatus(nn::prepo::TransmissionStatus*)", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo10PlayReportC2ERKS1_", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport(nn::prepo::PlayReport const&)", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo10PlayReportC1ERKS1_", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport(nn::prepo::PlayReport const&)", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo10PlayReportaSERKS1_", new Tuple<string, List<string>>("nn::prepo::PlayReport::operator=(nn::prepo::PlayReport const&)", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo10PlayReportC2EOS1_", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport(nn::prepo::PlayReport&&)", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo10PlayReportC1EOS1_", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport(nn::prepo::PlayReport&&)", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo10PlayReportaSEOS1_", new Tuple<string, List<string>>("nn::prepo::PlayReport::operator=(nn::prepo::PlayReport&&)", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo10PlayReport13BufferSizeMinE", new Tuple<string, List<string>>("nn::prepo::PlayReport::BufferSizeMin", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo10PlayReport13BufferSizeMaxE", new Tuple<string, List<string>>("nn::prepo::PlayReport::BufferSizeMax", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo10PlayReportC2Ev", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport()", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo10PlayReportC1Ev", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport()", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo10PlayReportC2EPKc", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport(char const*)", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo10PlayReportC1EPKc", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport(char const*)", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo10PlayReport9SetBufferEPvm", new Tuple<string, List<string>>("nn::prepo::PlayReport::SetBuffer(void*, unsigned long)", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo10PlayReport10SetEventIdEPKc", new Tuple<string, List<string>>("nn::prepo::PlayReport::SetEventId(char const*)", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo10PlayReport5ClearEv", new Tuple<string, List<string>>("nn::prepo::PlayReport::Clear()", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo10PlayReport3AddEPKcl", new Tuple<string, List<string>>("nn::prepo::PlayReport::Add(char const*, long)", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo10PlayReport3AddEPKcRKNS0_10Any64BitIdE", new Tuple<string, List<string>>("nn::prepo::PlayReport::Add(char const*, nn::prepo::Any64BitId const&)", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo10PlayReport3AddEPKcd", new Tuple<string, List<string>>("nn::prepo::PlayReport::Add(char const*, double)", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo10PlayReport3AddEPKcS3_", new Tuple<string, List<string>>("nn::prepo::PlayReport::Add(char const*, char const*)", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo10PlayReport4SaveEv", new Tuple<string, List<string>>("nn::prepo::PlayReport::Save()", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepo10PlayReport4SaveERKNS_7account3UidE", new Tuple<string, List<string>>("nn::prepo::PlayReport::Save(nn::account::Uid const&)", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZNK2nn5prepo10PlayReport8GetCountEv", new Tuple<string, List<string>>("nn::prepo::PlayReport::GetCount() const", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepoL16KeyValueCountMaxE", new Tuple<string, List<string>>("nn::prepo::KeyValueCountMax", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepoL16EventIdLengthMaxE", new Tuple<string, List<string>>("nn::prepo::EventIdLengthMax", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepoL12KeyLengthMaxE", new Tuple<string, List<string>>("nn::prepo::KeyLengthMax", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepoL20StringValueLengthMaxE", new Tuple<string, List<string>>("nn::prepo::StringValueLengthMax", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn5prepoL15KeyValueSizeMaxE", new Tuple<string, List<string>>("nn::prepo::KeyValueSizeMax", new List<string>() { "1_BundleRules_PlayReportKit_Generic_Files_play-report-kit", "1_BundleRules_PlayReportKit_NX_Files_play-report-kit" }) },
                        { "_ZN2nn2ec28RequestPurchaseAuthorizationERKNS_7account10UserHandleEPKc", new Tuple<string, List<string>>("nn::ec::RequestPurchaseAuthorization(nn::account::UserHandle const&, char const*)", new List<string>() { "1_BundleDefinitions_NX_ShopApiPurchaseAuthorization" }) },
                        { "_ZN2nn3hid44IsUnintendedHomeButtonInputProtectionEnabledERKj", new Tuple<string, List<string>>("nn::hid::IsUnintendedHomeButtonInputProtectionEnabled(unsigned int const&)", new List<string>() { "1_BundleDefinitions_NX_UnintendedHomeButtonInputProtection" }) },
                        { "_ZN2nn3hid41EnableUnintendedHomeButtonInputProtectionERKjb", new Tuple<string, List<string>>("nn::hid::EnableUnintendedHomeButtonInputProtection(unsigned int const&, bool)", new List<string>() { "1_BundleDefinitions_NX_UnintendedHomeButtonInputProtection" }) },
                        { "_ZN2nn2oe21GetExpectedThemeColorEv", new Tuple<string, List<string>>("nn::oe::GetExpectedThemeColor()", new List<string>() { "1_BundleRules_TurboSKit_NX_Files" }) },
                        { "_ZN2nn2oe30SetExpectedThemeColorForSystemENS0_14ThemeColorTypeE", new Tuple<string, List<string>>("nn::oe::SetExpectedThemeColorForSystem(nn::oe::ThemeColorType)", new List<string>() { "1_BundleRules_TurboSKit_NX_Files" }) },
                        { "_ZN2nn2oe20GetDefaultThemeColorEv", new Tuple<string, List<string>>("nn::oe::GetDefaultThemeColor()", new List<string>() { "1_BundleRules_TurboSKit_NX_Files" }) },
                        { "_ZN2nn2osL21ThreadSuspendCountMaxE", new Tuple<string, List<string>>("nn::os::ThreadSuspendCountMax", new List<string>() { "1_BundleRules_UnityKit_Generic_Files" }) },
                        { "_ZN2nn2os13SuspendThreadEPNS0_10ThreadTypeE", new Tuple<string, List<string>>("nn::os::SuspendThread(nn::os::ThreadType*)", new List<string>() { "1_BundleRules_UnityKit_Generic_Files" }) },
                        { "_ZN2nn2os12ResumeThreadEPNS0_10ThreadTypeE", new Tuple<string, List<string>>("nn::os::ResumeThread(nn::os::ThreadType*)", new List<string>() { "1_BundleRules_UnityKit_Generic_Files" }) },
                        { "_ZN2nn2os21GetThreadSuspendCountEPKNS0_10ThreadTypeE", new Tuple<string, List<string>>("nn::os::GetThreadSuspendCount(nn::os::ThreadType const*)", new List<string>() { "1_BundleRules_UnityKit_Generic_Files" }) },
                        { "_ZN2nn2os16GetThreadContextEPNS0_24ThreadContextInfoAarch64EPKNS0_10ThreadTypeE", new Tuple<string, List<string>>("nn::os::GetThreadContext(nn::os::ThreadContextInfoAarch64*, nn::os::ThreadType const*)", new List<string>() { "1_BundleRules_UnityKit_Generic_Files" }) },
                        { "_ZN2nn3hid15PermitVibrationEb", new Tuple<string, List<string>>("nn::hid::PermitVibration(bool)", new List<string>() { "1_BundleDefinitions_NX_VibrationPermissionKit" }) },
                        { "_ZN2nn3hid20IsVibrationPermittedEv", new Tuple<string, List<string>>("nn::hid::IsVibrationPermitted()", new List<string>() { "1_BundleDefinitions_NX_VibrationPermissionKit" }) },
                        { "_ZN2nn2oe25BeginMediaPlaybackSectionEv", new Tuple<string, List<string>>("nn::oe::BeginMediaPlaybackSection()", new List<string>() { "1_BundleDefinitions_NX_MediaPlaybackSectionApi" }) },
                        { "_ZN2nn2oe23EndMediaPlaybackSectionEv", new Tuple<string, List<string>>("nn::oe::EndMediaPlaybackSection()", new List<string>() { "1_BundleDefinitions_NX_MediaPlaybackSectionApi" }) },
                    }
                },
                {
                    "3", // SDKのメジャーバージョン
                    new Dictionary<string, Tuple<string, List<string>>> // <マングル名,<デマングル名,マングル名に対応するtitleタグのリスト>>
                    {
                        { "_ZN2nn2oe18ReportUserIsActiveEv", new Tuple<string, List<string>>("nn::oe::ReportUserIsActive()", new List<string>() { "3_BundleDefinitions_NX_OeReportUserIsActive" }) },
                        { "_ZN2nn2oe23BeginBlockingHomeButtonEv", new Tuple<string, List<string>>("nn::oe::BeginBlockingHomeButton()", new List<string>() { "3_BundleRules_NX_Private_BlockingHomeButton_BlockingHomeButton" }) },
                        { "_ZN2nn2oe21EndBlockingHomeButtonEv", new Tuple<string, List<string>>("nn::oe::EndBlockingHomeButton()", new List<string>() { "3_BundleRules_NX_Private_BlockingHomeButton_BlockingHomeButton" }) },
                        { "_ZN2nn5audio17SetAudioInEnabledEb", new Tuple<string, List<string>>("nn::audio::SetAudioInEnabled(bool)", new List<string>() { "3_BundleDefinitions_NX_AudioIn" }) },
                        { "_ZN2nn5audio16IsAudioInEnabledEv", new Tuple<string, List<string>>("nn::audio::IsAudioInEnabled()", new List<string>() { "3_BundleDefinitions_NX_AudioIn" }) },
                        { "_ZN2nn2oeL54PerformanceConfiguration_Cpu1020MhzGpu460MhzEmc1331MhzE", new Tuple<string, List<string>>("nn::oe::PerformanceConfiguration_Cpu1020MhzGpu460MhzEmc1331Mhz", new List<string>() { "3_BundleRules_NX_Private_BatteryDrainingPerformance_BatteryDrainingPerformance" }) },
                        { "_ZN2nn5albumL25SharePostedLastUrlSizeMaxE", new Tuple<string, List<string>>("nn::album::SharePostedLastUrlSizeMax", new List<string>() { "3_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album21GetSharePostedLastUrlEPcmRKNS0_7ShareIdE", new Tuple<string, List<string>>("nn::album::GetSharePostedLastUrl(char*, unsigned long, nn::album::ShareId const&)", new List<string>() { "3_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album21GetSharePostedLastUrlEPcjRKNS0_7ShareIdE", new Tuple<string, List<string>>("nn::album::GetSharePostedLastUrl(char*, unsigned int, nn::album::ShareId const&)", new List<string>() { "3_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5albumL29SharePostedServiceNameSizeMaxE", new Tuple<string, List<string>>("nn::album::SharePostedServiceNameSizeMax", new List<string>() { "3_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5albumL25SharePostedEntryIdSizeMaxE", new Tuple<string, List<string>>("nn::album::SharePostedEntryIdSizeMax", new List<string>() { "3_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album25GetSharePostedServiceNameEPcmRKNS0_7ShareIdE", new Tuple<string, List<string>>("nn::album::GetSharePostedServiceName(char*, unsigned long, nn::album::ShareId const&)", new List<string>() { "3_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album21GetSharePostedEntryIdEPcmRKNS0_7ShareIdE", new Tuple<string, List<string>>("nn::album::GetSharePostedEntryId(char*, unsigned long, nn::album::ShareId const&)", new List<string>() { "3_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album25GetSharePostedServiceNameEPcjRKNS0_7ShareIdE", new Tuple<string, List<string>>("nn::album::GetSharePostedServiceName(char*, unsigned int, nn::album::ShareId const&)", new List<string>() { "3_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album21GetSharePostedEntryIdEPcjRKNS0_7ShareIdE", new Tuple<string, List<string>>("nn::album::GetSharePostedEntryId(char*, unsigned int, nn::album::ShareId const&)", new List<string>() { "3_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album22SaveAndShareScreenshotEPNS0_7ShareIdEPKvmNS0_9ImageSizeENS0_17AlbumReportOptionERKNS_7account3UidE", new Tuple<string, List<string>>("nn::album::SaveAndShareScreenshot(nn::album::ShareId*, void const*, unsigned long, nn::album::ImageSize, nn::album::AlbumReportOption, nn::account::Uid const&)", new List<string>() { "3_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album22SaveAndShareScreenshotEPNS0_7ShareIdEPKvmNS0_9ImageSizeENS0_16ImageOrientationENS0_17AlbumReportOptionERKNS_7account3UidE", new Tuple<string, List<string>>("nn::album::SaveAndShareScreenshot(nn::album::ShareId*, void const*, unsigned long, nn::album::ImageSize, nn::album::ImageOrientation, nn::album::AlbumReportOption, nn::account::Uid const&)", new List<string>() { "3_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album22SaveAndShareScreenshotEPNS0_7ShareIdEPKvjNS0_9ImageSizeENS0_17AlbumReportOptionERKNS_7account3UidE", new Tuple<string, List<string>>("nn::album::SaveAndShareScreenshot(nn::album::ShareId*, void const*, unsigned int, nn::album::ImageSize, nn::album::AlbumReportOption, nn::account::Uid const&)", new List<string>() { "3_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album22SaveAndShareScreenshotEPNS0_7ShareIdEPKvjNS0_9ImageSizeENS0_16ImageOrientationENS0_17AlbumReportOptionERKNS_7account3UidE", new Tuple<string, List<string>>("nn::album::SaveAndShareScreenshot(nn::album::ShareId*, void const*, unsigned int, nn::album::ImageSize, nn::album::ImageOrientation, nn::album::AlbumReportOption, nn::account::Uid const&)", new List<string>() { "3_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn3hid29IsUsbFullKeyControllerEnabledEv", new Tuple<string, List<string>>("nn::hid::IsUsbFullKeyControllerEnabled()", new List<string>() { "3_BundleRules_NX_Private_UsbFullKey_UsbFullKey" }) },
                        { "_ZN2nn3hid26EnableUsbFullKeyControllerEb", new Tuple<string, List<string>>("nn::hid::EnableUsbFullKeyController(bool)", new List<string>() { "3_BundleRules_NX_Private_UsbFullKey_UsbFullKey" }) },
                        { "_ZN2nn3hid31IsUsbFullKeyControllerConnectedERKj", new Tuple<string, List<string>>("nn::hid::IsUsbFullKeyControllerConnected(unsigned int const&)", new List<string>() { "3_BundleRules_NX_Private_UsbFullKey_UsbFullKey" }) },
                        { "_ZN2nn4util28GetCountryFromIso31661Alpha2EPNS0_7CountryEPKcm", new Tuple<string, List<string>>("nn::util::GetCountryFromIso31661Alpha2(nn::util::Country*, char const*, unsigned long)", new List<string>() { "3_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZN2nn4util28GetCountryFromIso31661Alpha2EPNS0_7CountryEPKcj", new Tuple<string, List<string>>("nn::util::GetCountryFromIso31661Alpha2(nn::util::Country*, char const*, unsigned int)", new List<string>() { "3_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZN2nn7account29LoadCachedNintendoAccountInfoEPNS0_25CachedNintendoAccountInfoERKNS0_10UserHandleEPvm", new Tuple<string, List<string>>("nn::account::LoadCachedNintendoAccountInfo(nn::account::CachedNintendoAccountInfo*, nn::account::UserHandle const&, void*, unsigned long)", new List<string>() { "3_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZN2nn7account25CachedNintendoAccountInfoC2Ev", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::CachedNintendoAccountInfo()", new List<string>() { "3_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZN2nn7account25CachedNintendoAccountInfoC1Ev", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::CachedNintendoAccountInfo()", new List<string>() { "3_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZNK2nn7account25CachedNintendoAccountInfo11GetBirthdayEPm", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::GetBirthday(unsigned long*) const", new List<string>() { "3_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZNK2nn7account25CachedNintendoAccountInfo9GetGenderEPm", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::GetGender(unsigned long*) const", new List<string>() { "3_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZNK2nn7account25CachedNintendoAccountInfo10GetCountryEPm", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::GetCountry(unsigned long*) const", new List<string>() { "3_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZN2nn7account29LoadCachedNintendoAccountInfoEPNS0_25CachedNintendoAccountInfoERKNS0_10UserHandleEPvj", new Tuple<string, List<string>>("nn::account::LoadCachedNintendoAccountInfo(nn::account::CachedNintendoAccountInfo*, nn::account::UserHandle const&, void*, unsigned int)", new List<string>() { "3_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZNK2nn7account25CachedNintendoAccountInfo11GetBirthdayEPj", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::GetBirthday(unsigned int*) const", new List<string>() { "3_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZNK2nn7account25CachedNintendoAccountInfo9GetGenderEPj", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::GetGender(unsigned int*) const", new List<string>() { "3_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZNK2nn7account25CachedNintendoAccountInfo10GetCountryEPj", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::GetCountry(unsigned int*) const", new List<string>() { "3_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZN2nn7accountL46RequiredBufferSizeForCachedNintendoAccountInfoE", new Tuple<string, List<string>>("nn::account::RequiredBufferSizeForCachedNintendoAccountInfo", new List<string>() { "3_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZN2nn2fs19MountDeviceSaveDataEPKc", new Tuple<string, List<string>>("nn::fs::MountDeviceSaveData(char const*)", new List<string>() { "3_BundleRules_NX_Private_DeviceSaveData_DeviceSaveData" }) },
                        { "_ZN2nn7friends17SendFriendRequestEPNS0_12AsyncContextERKNS_7account3UidENS3_23NetworkServiceAccountIdERKNS0_15InAppScreenNameESA_", new Tuple<string, List<string>>("nn::friends::SendFriendRequest(nn::friends::AsyncContext*, nn::account::Uid const&, nn::account::NetworkServiceAccountId, nn::friends::InAppScreenName const&, nn::friends::InAppScreenName const&)", new List<string>() { "3_BundleRules_Generic_Private_FriendRequest_friend-request" }) },
                        { "_ZN2nn7friends36GetFacedFriendRequestRegistrationKeyEPNS0_33FacedFriendRequestRegistrationKeyERKNS_7account3UidE", new Tuple<string, List<string>>("nn::friends::GetFacedFriendRequestRegistrationKey(nn::friends::FacedFriendRequestRegistrationKey*, nn::account::Uid const&)", new List<string>() { "3_BundleRules_Generic_Private_FriendRequest_friend-request" }) },
                        { "_ZN2nn7friends21AddFacedFriendRequestERKNS_7account3UidERKNS0_33FacedFriendRequestRegistrationKeyERKNS1_8NicknameEPKvmRKNS0_15InAppScreenNameESF_", new Tuple<string, List<string>>("nn::friends::AddFacedFriendRequest(nn::account::Uid const&, nn::friends::FacedFriendRequestRegistrationKey const&, nn::account::Nickname const&, void const*, unsigned long, nn::friends::InAppScreenName const&, nn::friends::InAppScreenName const&)", new List<string>() { "3_BundleRules_Generic_Private_FriendRequest_friend-request" }) },
                        { "_ZN2nn7friends21AddFacedFriendRequestERKNS_7account3UidERKNS0_33FacedFriendRequestRegistrationKeyERKNS1_8NicknameEPKvjRKNS0_15InAppScreenNameESF_", new Tuple<string, List<string>>("nn::friends::AddFacedFriendRequest(nn::account::Uid const&, nn::friends::FacedFriendRequestRegistrationKey const&, nn::account::Nickname const&, void const*, unsigned int, nn::friends::InAppScreenName const&, nn::friends::InAppScreenName const&)", new List<string>() { "3_BundleRules_Generic_Private_FriendRequest_friend-request" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardC2ERKS1_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::InlineKeyboard(nn::swkbd::InlineKeyboard const&)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardC1ERKS1_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::InlineKeyboard(nn::swkbd::InlineKeyboard const&)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardaSERKS1_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::operator=(nn::swkbd::InlineKeyboard const&)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardC2Ev", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::InlineKeyboard()", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardC1Ev", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::InlineKeyboard()", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardD2Ev", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::~InlineKeyboard()", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardD1Ev", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::~InlineKeyboard()", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard25GetRequiredWorkBufferSizeEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetRequiredWorkBufferSize()", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard10InitializeEPv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::Initialize(void*)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard8FinalizeEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::Finalize()", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard6LaunchEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::Launch()", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard9SetVolumeEf", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetVolume(float)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard6AppearERKNS0_9AppearArgE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::Appear(nn::swkbd::AppearArg const&)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard9DisappearEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::Disappear()", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard12SetInputTextERKNS0_9InputTextE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetInputText(nn::swkbd::InputText const&)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard12SetCursorPosEi", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetCursorPos(int)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard15SetUserWordInfoERKNS0_12UserWordInfoE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetUserWordInfo(nn::swkbd::UserWordInfo const&)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard17UnsetUserWordInfoEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::UnsetUserWordInfo()", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard11SetUtf8ModeEb", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetUtf8Mode(bool)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard15SetCustomizeDicEPKvmRKNS0_16CustomizeDicInfoE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetCustomizeDic(void const*, unsigned long, nn::swkbd::CustomizeDicInfo const&)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard17UnsetCustomizeDicEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::UnsetCustomizeDic()", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard14SetKeytopAlphaEf", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetKeytopAlpha(float)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard14SetFooterAlphaEf", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetFooterAlpha(float)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard14SetKeytopScaleEf", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetKeytopScale(float)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard18SetKeytopTranslateEff", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetKeytopTranslate(float, float)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard13SetWindowModeENS1_10WindowModeE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetWindowMode(nn::swkbd::InlineKeyboard::WindowMode)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard15SetTouchEnabledEb", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetTouchEnabled(bool)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard21SetUsbKeyboardEnabledEb", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetUsbKeyboardEnabled(bool)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZNK2nn5swkbd14InlineKeyboard18GetTouchRectanglesEPNS0_4RectES3_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetTouchRectangles(nn::swkbd::Rect*, nn::swkbd::Rect*) const", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard4CalcEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::Calc()", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard12GetMaxHeightEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetMaxHeight()", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard26IsUsedTouchPointByKeyboardEii", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::IsUsedTouchPointByKeyboard(int, int)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard29SetFinishedInitializeCallbackEPFvvE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetFinishedInitializeCallback(void (*)())", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard27SetFinishedKeyboardCallbackEPFvvE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetFinishedKeyboardCallback(void (*)())", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard24SetChangedStringCallbackEPFvPKNS0_16ChangedStringArgEE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetChangedStringCallback(void (*)(nn::swkbd::ChangedStringArg const*))", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard28SetChangedStringCallbackUtf8EPFvPKNS0_20ChangedStringArgUtf8EE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetChangedStringCallbackUtf8(void (*)(nn::swkbd::ChangedStringArgUtf8 const*))", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard22SetMovedCursorCallbackEPFvPKNS0_14MovedCursorArgEE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetMovedCursorCallback(void (*)(nn::swkbd::MovedCursorArg const*))", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard26SetMovedCursorCallbackUtf8EPFvPKNS0_18MovedCursorArgUtf8EE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetMovedCursorCallbackUtf8(void (*)(nn::swkbd::MovedCursorArgUtf8 const*))", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard23SetDecidedEnterCallbackEPFvPKNS0_15DecidedEnterArgEE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetDecidedEnterCallback(void (*)(nn::swkbd::DecidedEnterArg const*))", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard27SetDecidedEnterCallbackUtf8EPFvPKNS0_19DecidedEnterArgUtf8EE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetDecidedEnterCallbackUtf8(void (*)(nn::swkbd::DecidedEnterArgUtf8 const*))", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard24SetDecidedCancelCallbackEPFvvE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetDecidedCancelCallback(void (*)())", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard31SetReleasedUserWordInfoCallbackEPFvvE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetReleasedUserWordInfoCallback(void (*)())", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZNK2nn5swkbd14InlineKeyboard13GetWindowSizeEPiS2_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetWindowSize(int*, int*) const", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard25GetImageMemoryRequirementEPmS2_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetImageMemoryRequirement(unsigned long*, unsigned long*)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard8GetImageEPvm", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetImage(void*, unsigned long)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard15SetCustomizeDicEPKvjRKNS0_16CustomizeDicInfoE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetCustomizeDic(void const*, unsigned int, nn::swkbd::CustomizeDicInfo const&)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard25GetImageMemoryRequirementEPjS2_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetImageMemoryRequirement(unsigned int*, unsigned int*)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard8GetImageEPvj", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetImage(void*, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd9AppearArgC2Ev", new Tuple<string, List<string>>("nn::swkbd::AppearArg::AppearArg()", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd9AppearArgC1Ev", new Tuple<string, List<string>>("nn::swkbd::AppearArg::AppearArg()", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd9InputTextC2Ev", new Tuple<string, List<string>>("nn::swkbd::InputText::InputText()", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd9InputTextC1Ev", new Tuple<string, List<string>>("nn::swkbd::InputText::InputText()", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd9InputText3SetEPKDs", new Tuple<string, List<string>>("nn::swkbd::InputText::Set(char16_t const*)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd9InputText7SetUtf8EPKc", new Tuple<string, List<string>>("nn::swkbd::InputText::SetUtf8(char const*)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd16CustomizeDicInfoC2Ev", new Tuple<string, List<string>>("nn::swkbd::CustomizeDicInfo::CustomizeDicInfo()", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd16CustomizeDicInfoC1Ev", new Tuple<string, List<string>>("nn::swkbd::CustomizeDicInfo::CustomizeDicInfo()", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd12UserWordInfoC2Ev", new Tuple<string, List<string>>("nn::swkbd::UserWordInfo::UserWordInfo()", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd12UserWordInfoC1Ev", new Tuple<string, List<string>>("nn::swkbd::UserWordInfo::UserWordInfo()", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd12UserWordInfo25GetRequiredWorkBufferSizeEi", new Tuple<string, List<string>>("nn::swkbd::UserWordInfo::GetRequiredWorkBufferSize(int)", new List<string>() { "3_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn2oeL25MessageRequestToEndVrModeE", new Tuple<string, List<string>>("nn::oe::MessageRequestToEndVrMode", new List<string>() { "3_BundleRules_NX_Private_VrMode_vrmode" }) },
                        { "_ZN2nn2pl11BeginVrModeEv", new Tuple<string, List<string>>("nn::pl::BeginVrMode()", new List<string>() { "3_BundleRules_NX_Private_VrMode_vrmode" }) },
                        { "_ZN2nn2pl9EndVrModeEv", new Tuple<string, List<string>>("nn::pl::EndVrMode()", new List<string>() { "3_BundleRules_NX_Private_VrMode_vrmode" }) },
                        { "_ZN2nn2pl8IsVrModeEv", new Tuple<string, List<string>>("nn::pl::IsVrMode()", new List<string>() { "3_BundleRules_NX_Private_VrMode_vrmode" }) },
                        { "_ZN2nn2pl21GetCurrentIlluminanceEv", new Tuple<string, List<string>>("nn::pl::GetCurrentIlluminance()", new List<string>() { "3_BundleRules_NX_Private_Illuminance_illuminance" }) },
                        { "_ZN2nn2pl22IsIlluminanceAvailableEv", new Tuple<string, List<string>>("nn::pl::IsIlluminanceAvailable()", new List<string>() { "3_BundleRules_NX_Private_Illuminance_illuminance" }) },
                        { "_ZN2nn3lbl10InitializeEv", new Tuple<string, List<string>>("nn::lbl::Initialize()", new List<string>() { "3_BundleRules_NX_Private_LblSettingsForVrMode_LblSettingsForVrMode", "3_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl8FinalizeEv", new Tuple<string, List<string>>("nn::lbl::Finalize()", new List<string>() { "3_BundleRules_NX_Private_LblSettingsForVrMode_LblSettingsForVrMode", "3_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl36SetCurrentBrightnessSettingForVrModeEf", new Tuple<string, List<string>>("nn::lbl::SetCurrentBrightnessSettingForVrMode(float)", new List<string>() { "3_BundleRules_NX_Private_LblSettingsForVrMode_LblSettingsForVrMode", "3_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl36GetCurrentBrightnessSettingForVrModeEv", new Tuple<string, List<string>>("nn::lbl::GetCurrentBrightnessSettingForVrMode()", new List<string>() { "3_BundleRules_NX_Private_LblSettingsForVrMode_LblSettingsForVrMode", "3_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl18SaveCurrentSettingEv", new Tuple<string, List<string>>("nn::lbl::SaveCurrentSetting()", new List<string>() { "3_BundleRules_NX_Private_LblSettingsForVrMode_LblSettingsForVrMode", "3_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3hidL33ConsoleSixAxisSensorStateCountMaxE", new Tuple<string, List<string>>("nn::hid::ConsoleSixAxisSensorStateCountMax", new List<string>() { "3_BundleRules_NX_Private_ConsoleSixAxisSensor_consolesixaxissensor" }) },
                        { "_ZN2nn3hid30InitializeConsoleSixAxisSensorEv", new Tuple<string, List<string>>("nn::hid::InitializeConsoleSixAxisSensor()", new List<string>() { "3_BundleRules_NX_Private_ConsoleSixAxisSensor_consolesixaxissensor" }) },
                        { "_ZN2nn3hid22GetSixAxisSensorHandleEPNS0_26ConsoleSixAxisSensorHandleE", new Tuple<string, List<string>>("nn::hid::GetSixAxisSensorHandle(nn::hid::ConsoleSixAxisSensorHandle*)", new List<string>() { "3_BundleRules_NX_Private_ConsoleSixAxisSensor_consolesixaxissensor" }) },
                        { "_ZN2nn3hid18StartSixAxisSensorERKNS0_26ConsoleSixAxisSensorHandleE", new Tuple<string, List<string>>("nn::hid::StartSixAxisSensor(nn::hid::ConsoleSixAxisSensorHandle const&)", new List<string>() { "3_BundleRules_NX_Private_ConsoleSixAxisSensor_consolesixaxissensor" }) },
                        { "_ZN2nn3hid17StopSixAxisSensorERKNS0_26ConsoleSixAxisSensorHandleE", new Tuple<string, List<string>>("nn::hid::StopSixAxisSensor(nn::hid::ConsoleSixAxisSensorHandle const&)", new List<string>() { "3_BundleRules_NX_Private_ConsoleSixAxisSensor_consolesixaxissensor" }) },
                        { "_ZN2nn3hid3tmp34GetConsoleSixAxisSensorCountStatesEPNS1_23SixAxisSensorCountStateEiRKNS0_26ConsoleSixAxisSensorHandleE", new Tuple<string, List<string>>("nn::hid::tmp::GetConsoleSixAxisSensorCountStates(nn::hid::tmp::SixAxisSensorCountState*, int, nn::hid::ConsoleSixAxisSensorHandle const&)", new List<string>() { "3_BundleRules_NX_Private_ConsoleSixAxisSensor_consolesixaxissensor" }) },
                        { "_ZN2nn3hid3tmp40GetConsoleSixAxisSensorCalibrationValuesEPNS1_37ConsoleSixAxisSensorCalibrationValuesERKNS0_26ConsoleSixAxisSensorHandleE", new Tuple<string, List<string>>("nn::hid::tmp::GetConsoleSixAxisSensorCalibrationValues(nn::hid::tmp::ConsoleSixAxisSensorCalibrationValues*, nn::hid::ConsoleSixAxisSensorHandle const&)", new List<string>() { "3_BundleRules_NX_Private_ConsoleSixAxisSensor_consolesixaxissensor" }) },
                        { "_ZN2nn2os20FlushEntireDataCacheEv", new Tuple<string, List<string>>("nn::os::FlushEntireDataCache()", new List<string>() { "3_BundleRules_NX_Private_FlushEntireDataCache_FlushEntireDataCache" }) },
                        { "_ZN2nn5prepo10InitializeEv", new Tuple<string, List<string>>("nn::prepo::Initialize()", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo28RequestImmediateTransmissionEv", new Tuple<string, List<string>>("nn::prepo::RequestImmediateTransmission()", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo21GetTransmissionStatusEPNS0_18TransmissionStatusE", new Tuple<string, List<string>>("nn::prepo::GetTransmissionStatus(nn::prepo::TransmissionStatus*)", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportC2ERKS1_", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport(nn::prepo::PlayReport const&)", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportC1ERKS1_", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport(nn::prepo::PlayReport const&)", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportaSERKS1_", new Tuple<string, List<string>>("nn::prepo::PlayReport::operator=(nn::prepo::PlayReport const&)", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportC2EOS1_", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport(nn::prepo::PlayReport&&)", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportC1EOS1_", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport(nn::prepo::PlayReport&&)", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportaSEOS1_", new Tuple<string, List<string>>("nn::prepo::PlayReport::operator=(nn::prepo::PlayReport&&)", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport13BufferSizeMinE", new Tuple<string, List<string>>("nn::prepo::PlayReport::BufferSizeMin", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport13BufferSizeMaxE", new Tuple<string, List<string>>("nn::prepo::PlayReport::BufferSizeMax", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportC2Ev", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport()", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportC1Ev", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport()", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportC2EPKc", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport(char const*)", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportC1EPKc", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport(char const*)", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport9SetBufferEPvm", new Tuple<string, List<string>>("nn::prepo::PlayReport::SetBuffer(void*, unsigned long)", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport10SetEventIdEPKc", new Tuple<string, List<string>>("nn::prepo::PlayReport::SetEventId(char const*)", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport5ClearEv", new Tuple<string, List<string>>("nn::prepo::PlayReport::Clear()", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport3AddEPKcl", new Tuple<string, List<string>>("nn::prepo::PlayReport::Add(char const*, long)", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport3AddEPKcRKNS0_10Any64BitIdE", new Tuple<string, List<string>>("nn::prepo::PlayReport::Add(char const*, nn::prepo::Any64BitId const&)", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport3AddEPKcd", new Tuple<string, List<string>>("nn::prepo::PlayReport::Add(char const*, double)", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport3AddEPKcS3_", new Tuple<string, List<string>>("nn::prepo::PlayReport::Add(char const*, char const*)", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport4SaveEv", new Tuple<string, List<string>>("nn::prepo::PlayReport::Save()", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport4SaveERKNS_7account3UidE", new Tuple<string, List<string>>("nn::prepo::PlayReport::Save(nn::account::Uid const&)", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZNK2nn5prepo10PlayReport8GetCountEv", new Tuple<string, List<string>>("nn::prepo::PlayReport::GetCount() const", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport9SetBufferEPvj", new Tuple<string, List<string>>("nn::prepo::PlayReport::SetBuffer(void*, unsigned int)", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport3AddEPKcx", new Tuple<string, List<string>>("nn::prepo::PlayReport::Add(char const*, long long)", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepoL16KeyValueCountMaxE", new Tuple<string, List<string>>("nn::prepo::KeyValueCountMax", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepoL16EventIdLengthMaxE", new Tuple<string, List<string>>("nn::prepo::EventIdLengthMax", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepoL12KeyLengthMaxE", new Tuple<string, List<string>>("nn::prepo::KeyLengthMax", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepoL20StringValueLengthMaxE", new Tuple<string, List<string>>("nn::prepo::StringValueLengthMax", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepoL15KeyValueSizeMaxE", new Tuple<string, List<string>>("nn::prepo::KeyValueSizeMax", new List<string>() { "3_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC2ERKS1_", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(nn::os::SdkThreadLocalStorage const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC1ERKS1_", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(nn::os::SdkThreadLocalStorage const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageaSERKS1_", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::operator=(nn::os::SdkThreadLocalStorage const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC2EOS1_", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(nn::os::SdkThreadLocalStorage&&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC1EOS1_", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(nn::os::SdkThreadLocalStorage&&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageaSEOS1_", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::operator=(nn::os::SdkThreadLocalStorage&&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC2Ev", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC1Ev", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC2EPFvmE", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(void (*)(unsigned long))", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC1EPFvmE", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(void (*)(unsigned long))", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageD2Ev", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::~SdkThreadLocalStorage()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageD1Ev", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::~SdkThreadLocalStorage()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorage8SetValueEm", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SetValue(unsigned long)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZNK2nn2os21SdkThreadLocalStorage8GetValueEv", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::GetValue() const", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZNK2nn2os21SdkThreadLocalStorage10GetTlsSlotEv", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::GetTlsSlot() const", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC2EPFvjE", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(void (*)(unsigned int))", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC1EPFvjE", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(void (*)(unsigned int))", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorage8SetValueEj", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SetValue(unsigned int)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os18SdkAllocateTlsSlotEPNS0_7TlsSlotEPFvmE", new Tuple<string, List<string>>("nn::os::SdkAllocateTlsSlot(nn::os::TlsSlot*, void (*)(unsigned long))", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os18SdkAllocateTlsSlotEPNS0_7TlsSlotEPFvjE", new Tuple<string, List<string>>("nn::os::SdkAllocateTlsSlot(nn::os::TlsSlot*, void (*)(unsigned int))", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC2ERKS1_", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection(nn::nifm::NetworkConnection const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC1ERKS1_", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection(nn::nifm::NetworkConnection const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionaSERKS1_", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::operator=(nn::nifm::NetworkConnection const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC2EOS1_", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection(nn::nifm::NetworkConnection&&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC1EOS1_", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection(nn::nifm::NetworkConnection&&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionaSEOS1_", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::operator=(nn::nifm::NetworkConnection&&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC2Ev", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC1Ev", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC2ENS_2os14EventClearModeE", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection(nn::os::EventClearMode)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC1ENS_2os14EventClearModeE", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection(nn::os::EventClearMode)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionD2Ev", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::~NetworkConnection()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionD1Ev", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::~NetworkConnection()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection13SubmitRequestEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::SubmitRequest()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection20SubmitRequestAndWaitEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::SubmitRequestAndWait()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection13CancelRequestEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::CancelRequest()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection15IsRequestOnHoldEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::IsRequestOnHold()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection11IsAvailableEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::IsAvailable()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection14GetSystemEventEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::GetSystemEvent()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection26HandleNetworkRequestResultEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::HandleNetworkRequestResult()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection16GetRequestHandleEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::GetRequestHandle()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection9GetResultEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::GetResult()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection15GetRequestStateEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::GetRequestState()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC2ERKS1_", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::Request const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC1ERKS1_", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::Request const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestaSERKS1_", new Tuple<string, List<string>>("nn::nifm::Request::operator=(nn::nifm::Request const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC2EOS1_", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::Request&&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC1EOS1_", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::Request&&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestaSEOS1_", new Tuple<string, List<string>>("nn::nifm::Request::operator=(nn::nifm::Request&&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC2ERKNS0_17RequestParametersE", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::RequestParameters const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC1ERKNS0_17RequestParametersE", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::RequestParameters const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC2ERKNS0_17RequestParametersENS_2os14EventClearModeE", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::RequestParameters const&, nn::os::EventClearMode)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC1ERKNS0_17RequestParametersENS_2os14EventClearModeE", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::RequestParameters const&, nn::os::EventClearMode)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestD2Ev", new Tuple<string, List<string>>("nn::nifm::Request::~Request()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestD1Ev", new Tuple<string, List<string>>("nn::nifm::Request::~Request()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request6SubmitEv", new Tuple<string, List<string>>("nn::nifm::Request::Submit()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request13SubmitAndWaitEv", new Tuple<string, List<string>>("nn::nifm::Request::SubmitAndWait()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request6CancelEv", new Tuple<string, List<string>>("nn::nifm::Request::Cancel()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request15GetRequestStateEv", new Tuple<string, List<string>>("nn::nifm::Request::GetRequestState()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request9GetResultEv", new Tuple<string, List<string>>("nn::nifm::Request::GetResult()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request9GetHandleEv", new Tuple<string, List<string>>("nn::nifm::Request::GetHandle()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request14GetSystemEventEv", new Tuple<string, List<string>>("nn::nifm::Request::GetSystemEvent()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC2ERKS1_", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::TemporaryNetworkProfile const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC1ERKS1_", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::TemporaryNetworkProfile const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileaSERKS1_", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::operator=(nn::nifm::TemporaryNetworkProfile const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC2EOS1_", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::TemporaryNetworkProfile&&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC1EOS1_", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::TemporaryNetworkProfile&&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileaSEOS1_", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::operator=(nn::nifm::TemporaryNetworkProfile&&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC2ERKNS0_18NetworkProfileDataE", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::NetworkProfileData const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC1ERKNS0_18NetworkProfileDataE", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::NetworkProfileData const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileD2Ev", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::~TemporaryNetworkProfile()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileD1Ev", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::~TemporaryNetworkProfile()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZNK2nn4nifm23TemporaryNetworkProfile5GetIdEv", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::GetId() const", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfile6UpdateERKNS0_18NetworkProfileDataE", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::Update(nn::nifm::NetworkProfileData const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfile9GetHandleEv", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::GetHandle()", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm10MacAddress4SizeE", new Tuple<string, List<string>>("nn::nifm::MacAddress::Size", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_10MacAddressES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::MacAddress const&, nn::nifm::MacAddress const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_10MacAddressES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::MacAddress const&, nn::nifm::MacAddress const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmL24NetworkInterfaceCountMaxE", new Tuple<string, List<string>>("nn::nifm::NetworkInterfaceCountMax", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmL26UserNetworkProfileCountMaxE", new Tuple<string, List<string>>("nn::nifm::UserNetworkProfileCountMax", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmL30SsidListNetworkProfileCountMaxE", new Tuple<string, List<string>>("nn::nifm::SsidListNetworkProfileCountMax", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23NetworkProfileBasicInfo8NameSizeE", new Tuple<string, List<string>>("nn::nifm::NetworkProfileBasicInfo::NameSize", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm15SsidListVersion4SizeE", new Tuple<string, List<string>>("nn::nifm::SsidListVersion::Size", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_18NetworkProfileDataES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::NetworkProfileData const&, nn::nifm::NetworkProfileData const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_18NetworkProfileDataES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::NetworkProfileData const&, nn::nifm::NetworkProfileData const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmL22UserRequestPriorityTopE", new Tuple<string, List<string>>("nn::nifm::UserRequestPriorityTop", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmL25UserRequestPriorityBottomE", new Tuple<string, List<string>>("nn::nifm::UserRequestPriorityBottom", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm4Ssid7HexSizeE", new Tuple<string, List<string>>("nn::nifm::Ssid::HexSize", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm9SharedKey15KeyMaterialSizeE", new Tuple<string, List<string>>("nn::nifm::SharedKey::KeyMaterialSize", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmL26InvalidWirelessSettingDataE", new Tuple<string, List<string>>("nn::nifm::InvalidWirelessSettingData", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_4SsidES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::Ssid const&, nn::nifm::Ssid const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_4SsidES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::Ssid const&, nn::nifm::Ssid const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_14AuthEncryptionES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::AuthEncryption const&, nn::nifm::AuthEncryption const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_14AuthEncryptionES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::AuthEncryption const&, nn::nifm::AuthEncryption const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_9SharedKeyES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::SharedKey const&, nn::nifm::SharedKey const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_9SharedKeyES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::SharedKey const&, nn::nifm::SharedKey const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_10SsidConfigES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::SsidConfig const&, nn::nifm::SsidConfig const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_10SsidConfigES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::SsidConfig const&, nn::nifm::SsidConfig const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_8SecurityES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::Security const&, nn::nifm::Security const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_8SecurityES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::Security const&, nn::nifm::Security const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_19WirelessSettingDataES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::WirelessSettingData const&, nn::nifm::WirelessSettingData const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_19WirelessSettingDataES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::WirelessSettingData const&, nn::nifm::WirelessSettingData const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3nsd7ResolveEPNS0_4FqdnERKS1_", new Tuple<string, List<string>>("nn::nsd::Resolve(nn::nsd::Fqdn*, nn::nsd::Fqdn const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3nsd4Fqdn4SizeE", new Tuple<string, List<string>>("nn::nsd::Fqdn::Size", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3nsdeqERKNS0_4FqdnES3_", new Tuple<string, List<string>>("nn::nsd::operator==(nn::nsd::Fqdn const&, nn::nsd::Fqdn const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3nsdneERKNS0_4FqdnES3_", new Tuple<string, List<string>>("nn::nsd::operator!=(nn::nsd::Fqdn const&, nn::nsd::Fqdn const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3nsd11SettingName4SizeE", new Tuple<string, List<string>>("nn::nsd::SettingName::Size", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3nsd8PassCode4SizeE", new Tuple<string, List<string>>("nn::nsd::PassCode::Size", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3nsd21EnvironmentIdentifier4SizeE", new Tuple<string, List<string>>("nn::nsd::EnvironmentIdentifier::Size", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3nsdeqERKNS0_21EnvironmentIdentifierES3_", new Tuple<string, List<string>>("nn::nsd::operator==(nn::nsd::EnvironmentIdentifier const&, nn::nsd::EnvironmentIdentifier const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3nsdneERKNS0_21EnvironmentIdentifierES3_", new Tuple<string, List<string>>("nn::nsd::operator!=(nn::nsd::EnvironmentIdentifier const&, nn::nsd::EnvironmentIdentifier const&)", new List<string>() { "3_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4diag13OnResultThrowENS_6ResultERKNS0_10SourceInfoE", new Tuple<string, List<string>>("nn::diag::OnResultThrow(nn::Result, nn::diag::SourceInfo const&)", new List<string>() { "3_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn4diag14OnResultHandleENS_6ResultERKNS0_10SourceInfoE", new Tuple<string, List<string>>("nn::diag::OnResultHandle(nn::Result, nn::diag::SourceInfo const&)", new List<string>() { "3_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn4diag15OnResultRethrowENS_6ResultERKNS0_10SourceInfoE", new Tuple<string, List<string>>("nn::diag::OnResultRethrow(nn::Result, nn::diag::SourceInfo const&)", new List<string>() { "3_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn4diag13OnResultCatchENS_6ResultERKNS0_10SourceInfoE", new Tuple<string, List<string>>("nn::diag::OnResultCatch(nn::Result, nn::diag::SourceInfo const&)", new List<string>() { "3_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn4diag12OnResultMissENS_6ResultERKNS0_10SourceInfoE", new Tuple<string, List<string>>("nn::diag::OnResultMiss(nn::Result, nn::diag::SourceInfo const&)", new List<string>() { "3_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail19ResultAutoConverterC2ENS_6ResultE", new Tuple<string, List<string>>("nn::result::detail::ResultAutoConverter::ResultAutoConverter(nn::Result)", new List<string>() { "3_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail19ResultAutoConverterC1ENS_6ResultE", new Tuple<string, List<string>>("nn::result::detail::ResultAutoConverter::ResultAutoConverter(nn::Result)", new List<string>() { "3_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail23MakeResultAutoConverterENS_6ResultE", new Tuple<string, List<string>>("nn::result::detail::MakeResultAutoConverter(nn::Result)", new List<string>() { "3_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderC2ERKNS1_17ResultBlockHolderIT_T0_EE", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::ResultBlockHolder", new List<string>() { "3_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderC1ERKNS1_17ResultBlockHolderIT_T0_EE", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::ResultBlockHolder", new List<string>() { "3_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderC2EOT0_", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::ResultBlockHolder", new List<string>() { "3_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderC1EOT0_", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::ResultBlockHolder", new List<string>() { "3_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderC2EONS1_17ResultBlockHolderIT_T0_EE", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::ResultBlockHolder", new List<string>() { "3_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderC1EONS1_17ResultBlockHolderIT_T0_EE", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::ResultBlockHolder", new List<string>() { "3_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderD2Ev", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::~ResultBlockHolder()", new List<string>() { "3_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderD1Ev", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::~ResultBlockHolder()", new List<string>() { "3_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail14AbortForResult6HandleENS_6ResultE", new Tuple<string, List<string>>("nn::result::detail::AbortForResult::Handle(nn::Result)", new List<string>() { "3_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail15IgnoreForResult6HandleENS_6ResultE", new Tuple<string, List<string>>("nn::result::detail::IgnoreForResult::Handle(nn::Result)", new List<string>() { "3_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn3lbl27EnableAutoBrightnessControlEv", new Tuple<string, List<string>>("nn::lbl::EnableAutoBrightnessControl()", new List<string>() { "3_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl28DisableAutoBrightnessControlEv", new Tuple<string, List<string>>("nn::lbl::DisableAutoBrightnessControl()", new List<string>() { "3_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl30IsAutoBrightnessControlEnabledEv", new Tuple<string, List<string>>("nn::lbl::IsAutoBrightnessControlEnabled()", new List<string>() { "3_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl26SetAmbientLightSensorValueEf", new Tuple<string, List<string>>("nn::lbl::SetAmbientLightSensorValue(float)", new List<string>() { "3_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl26GetAmbientLightSensorValueEv", new Tuple<string, List<string>>("nn::lbl::GetAmbientLightSensorValue()", new List<string>() { "3_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl29IsAmbientLightSensorAvailableEv", new Tuple<string, List<string>>("nn::lbl::IsAmbientLightSensorAvailable()", new List<string>() { "3_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl33SetBrightnessReflectionDelayLevelENS0_25BrightnessChangeDirectionEf", new Tuple<string, List<string>>("nn::lbl::SetBrightnessReflectionDelayLevel(nn::lbl::BrightnessChangeDirection, float)", new List<string>() { "3_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl33GetBrightnessReflectionDelayLevelENS0_25BrightnessChangeDirectionE", new Tuple<string, List<string>>("nn::lbl::GetBrightnessReflectionDelayLevel(nn::lbl::BrightnessChangeDirection)", new List<string>() { "3_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl40ApplyCurrentBrightnessSettingToBacklightEv", new Tuple<string, List<string>>("nn::lbl::ApplyCurrentBrightnessSettingToBacklight()", new List<string>() { "3_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl38GetBrightnessSettingAppliedToBacklightEv", new Tuple<string, List<string>>("nn::lbl::GetBrightnessSettingAppliedToBacklight()", new List<string>() { "3_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl27SetCurrentBrightnessMappingERKNS0_18MappingCoefficientE", new Tuple<string, List<string>>("nn::lbl::SetCurrentBrightnessMapping(nn::lbl::MappingCoefficient const&)", new List<string>() { "3_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl27GetCurrentBrightnessMappingEPNS0_18MappingCoefficientE", new Tuple<string, List<string>>("nn::lbl::GetCurrentBrightnessMapping(nn::lbl::MappingCoefficient*)", new List<string>() { "3_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl35SetCurrentAmbientLightSensorMappingERKNS0_18MappingCoefficientE", new Tuple<string, List<string>>("nn::lbl::SetCurrentAmbientLightSensorMapping(nn::lbl::MappingCoefficient const&)", new List<string>() { "3_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl35GetCurrentAmbientLightSensorMappingEPNS0_18MappingCoefficientE", new Tuple<string, List<string>>("nn::lbl::GetCurrentAmbientLightSensorMapping(nn::lbl::MappingCoefficient*)", new List<string>() { "3_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl27SetCurrentBrightnessSettingEf", new Tuple<string, List<string>>("nn::lbl::SetCurrentBrightnessSetting(float)", new List<string>() { "3_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl27GetCurrentBrightnessSettingEv", new Tuple<string, List<string>>("nn::lbl::GetCurrentBrightnessSetting()", new List<string>() { "3_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl18LoadCurrentSettingEv", new Tuple<string, List<string>>("nn::lbl::LoadCurrentSetting()", new List<string>() { "3_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lblL18CoefficentCountMaxE", new Tuple<string, List<string>>("nn::lbl::CoefficentCountMax", new List<string>() { "3_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3cec10InitializeEPNS_2os15SystemEventTypeE", new Tuple<string, List<string>>("nn::cec::Initialize(nn::os::SystemEventType*)", new List<string>() { "3_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec8FinalizeEPNS_2os15SystemEventTypeE", new Tuple<string, List<string>>("nn::cec::Finalize(nn::os::SystemEventType*)", new List<string>() { "3_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec19PerformOneTouchPlayEv", new Tuple<string, List<string>>("nn::cec::PerformOneTouchPlay()", new List<string>() { "3_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec18PerformImageViewOnEv", new Tuple<string, List<string>>("nn::cec::PerformImageViewOn()", new List<string>() { "3_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec19PerformActiveSourceEv", new Tuple<string, List<string>>("nn::cec::PerformActiveSource()", new List<string>() { "3_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec20SetActiveSourceStateEv", new Tuple<string, List<string>>("nn::cec::SetActiveSourceState()", new List<string>() { "3_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec16PerformGoStandbyEb", new Tuple<string, List<string>>("nn::cec::PerformGoStandby(bool)", new List<string>() { "3_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec21PerformInactiveSourceEv", new Tuple<string, List<string>>("nn::cec::PerformInactiveSource()", new List<string>() { "3_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec17SetOnScreenStringEPKc", new Tuple<string, List<string>>("nn::cec::SetOnScreenString(char const*)", new List<string>() { "3_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec13SetPowerStateENS0_10PowerStateE", new Tuple<string, List<string>>("nn::cec::SetPowerState(nn::cec::PowerState)", new List<string>() { "3_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec14SuspendManagerEv", new Tuple<string, List<string>>("nn::cec::SuspendManager()", new List<string>() { "3_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec14RestartManagerEv", new Tuple<string, List<string>>("nn::cec::RestartManager()", new List<string>() { "3_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec20CancelCurrentApiCallEPb", new Tuple<string, List<string>>("nn::cec::CancelCurrentApiCall(bool*)", new List<string>() { "3_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec9IsStartedEPb", new Tuple<string, List<string>>("nn::cec::IsStarted(bool*)", new List<string>() { "3_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec13GetPowerStateEPNS0_10PowerStateE", new Tuple<string, List<string>>("nn::cec::GetPowerState(nn::cec::PowerState*)", new List<string>() { "3_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec15GetTvPowerStateEPNS0_10PowerStateE", new Tuple<string, List<string>>("nn::cec::GetTvPowerState(nn::cec::PowerState*)", new List<string>() { "3_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec14IsTvResponsiveEPb", new Tuple<string, List<string>>("nn::cec::IsTvResponsive(bool*)", new List<string>() { "3_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec18GetConnectionStateEPNS0_15ConnectionStateE", new Tuple<string, List<string>>("nn::cec::GetConnectionState(nn::cec::ConnectionState*)", new List<string>() { "3_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec11GetHpdStateEPb", new Tuple<string, List<string>>("nn::cec::GetHpdState(bool*)", new List<string>() { "3_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec9IsEnabledEPb", new Tuple<string, List<string>>("nn::cec::IsEnabled(bool*)", new List<string>() { "3_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec14IsActiveSourceEPb", new Tuple<string, List<string>>("nn::cec::IsActiveSource(bool*)", new List<string>() { "3_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec15GetBusEventTypeEPNS0_12BusEventTypeE", new Tuple<string, List<string>>("nn::cec::GetBusEventType(nn::cec::BusEventType*)", new List<string>() { "3_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi17GetDisplayCmuModeEPNS0_7CmuModeEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayCmuMode(nn::vi::CmuMode*, nn::vi::Display const*)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi17SetDisplayCmuModeEPNS0_7DisplayENS0_7CmuModeE", new Tuple<string, List<string>>("nn::vi::SetDisplayCmuMode(nn::vi::Display*, nn::vi::CmuMode)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi23GetDisplayContrastRatioEPfPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayContrastRatio(float*, nn::vi::Display const*)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi23SetDisplayContrastRatioEPNS0_7DisplayEf", new Tuple<string, List<string>>("nn::vi::SetDisplayContrastRatio(nn::vi::Display*, float)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi15GetDisplayGammaEPfPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayGamma(float*, nn::vi::Display const*)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi15SetDisplayGammaEPNS0_7DisplayEf", new Tuple<string, List<string>>("nn::vi::SetDisplayGamma(nn::vi::Display*, float)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi17GetZOrderCountMinEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetZOrderCountMin(nn::vi::Display const*)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi17GetZOrderCountMaxEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetZOrderCountMax(nn::vi::Display const*)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi20GetDisplayResolutionEPiS1_PKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayResolution(int*, int*, nn::vi::Display const*)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi27GetDisplayLogicalResolutionEPiS1_PKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayLogicalResolution(int*, int*, nn::vi::Display const*)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi23SetDisplayMagnificationEPNS0_7DisplayEiiii", new Tuple<string, List<string>>("nn::vi::SetDisplayMagnification(nn::vi::Display*, int, int, int, int)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2viL19DisplayModeCountMaxE", new Tuple<string, List<string>>("nn::vi::DisplayModeCountMax", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi16ListDisplayModesEPNS0_15DisplayModeInfoEiPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::ListDisplayModes(nn::vi::DisplayModeInfo*, int, nn::vi::Display const*)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi20ListDisplayRgbRangesEPNS0_8RgbRangeEiPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::ListDisplayRgbRanges(nn::vi::RgbRange*, int, nn::vi::Display const*)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi23ListDisplayContentTypesEPNS0_11ContentTypeEiPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::ListDisplayContentTypes(nn::vi::ContentType*, int, nn::vi::Display const*)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi14GetDisplayModeEPNS0_15DisplayModeInfoEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayMode(nn::vi::DisplayModeInfo*, nn::vi::Display const*)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi14SetDisplayModeEPNS0_7DisplayEPKNS0_15DisplayModeInfoE", new Tuple<string, List<string>>("nn::vi::SetDisplayMode(nn::vi::Display*, nn::vi::DisplayModeInfo const*)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi19GetDisplayUnderscanEPiPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayUnderscan(int*, nn::vi::Display const*)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi19SetDisplayUnderscanEPNS0_7DisplayEi", new Tuple<string, List<string>>("nn::vi::SetDisplayUnderscan(nn::vi::Display*, int)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi21GetDisplayContentTypeEPNS0_11ContentTypeEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayContentType(nn::vi::ContentType*, nn::vi::Display const*)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi21SetDisplayContentTypeEPNS0_7DisplayENS0_11ContentTypeE", new Tuple<string, List<string>>("nn::vi::SetDisplayContentType(nn::vi::Display*, nn::vi::ContentType)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi18GetDisplayRgbRangeEPNS0_8RgbRangeEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayRgbRange(nn::vi::RgbRange*, nn::vi::Display const*)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi18SetDisplayRgbRangeEPNS0_7DisplayENS0_8RgbRangeE", new Tuple<string, List<string>>("nn::vi::SetDisplayRgbRange(nn::vi::Display*, nn::vi::RgbRange)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi11CreateLayerEPPNS0_5LayerEPNS0_7DisplayENS_4util10BitFlagSetILi32ENS0_10LayerFlagsEEE", new Tuple<string, List<string>>("nn::vi::CreateLayer(nn::vi::Layer**, nn::vi::Display*, nn::util::BitFlagSet<32, nn::vi::LayerFlags>)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi16SetLayerPositionEPNS0_5LayerEff", new Tuple<string, List<string>>("nn::vi::SetLayerPosition(nn::vi::Layer*, float, float)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi12SetLayerSizeEPNS0_5LayerEii", new Tuple<string, List<string>>("nn::vi::SetLayerSize(nn::vi::Layer*, int, int)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi9SetLayerZEPNS0_5LayerEi", new Tuple<string, List<string>>("nn::vi::SetLayerZ(nn::vi::Layer*, int)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi9GetLayerZEPiPKNS0_5LayerE", new Tuple<string, List<string>>("nn::vi::GetLayerZ(int*, nn::vi::Layer const*)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi13SetLayerAlphaEPNS0_5LayerEf", new Tuple<string, List<string>>("nn::vi::SetLayerAlpha(nn::vi::Layer*, float)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi24SetLayerSettingsDefaultsEPNS_4util10BitFlagSetILi32ENS0_10LayerFlagsEEE", new Tuple<string, List<string>>("nn::vi::SetLayerSettingsDefaults(nn::util::BitFlagSet<32, nn::vi::LayerFlags>*)", new List<string>() { "3_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN5movie13BrowserConfigC2Ev", new Tuple<string, List<string>>("movie::BrowserConfig::BrowserConfig()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserConfigC1Ev", new Tuple<string, List<string>>("movie::BrowserConfig::BrowserConfig()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer6CreateEPPS0_PNS_12PlayerConfigE", new Tuple<string, List<string>>("movie::BrowserPlayer::Create(movie::BrowserPlayer**, movie::PlayerConfig*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer6CreateEPPS0_PNS_12PlayerConfigEPNS_13BrowserConfigE", new Tuple<string, List<string>>("movie::BrowserPlayer::Create(movie::BrowserPlayer**, movie::PlayerConfig*, movie::BrowserConfig*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer7DestroyEPS0_", new Tuple<string, List<string>>("movie::BrowserPlayer::Destroy(movie::BrowserPlayer*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer11CanPlayTypeEPKcS2_", new Tuple<string, List<string>>("movie::BrowserPlayer::CanPlayType(char const*, char const*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer12SetCacheSizeENS0_9CacheSizeE", new Tuple<string, List<string>>("movie::BrowserPlayer::SetCacheSize(movie::BrowserPlayer::CacheSize)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer11IsCacheFullEPb", new Tuple<string, List<string>>("movie::BrowserPlayer::IsCacheFull(bool*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer16GetBufferedRangeEPfS1_", new Tuple<string, List<string>>("movie::BrowserPlayer::GetBufferedRange(float*, float*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer22GetSupportedTypesCountEv", new Tuple<string, List<string>>("movie::BrowserPlayer::GetSupportedTypesCount()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer16GetSupportedTypeEi", new Tuple<string, List<string>>("movie::BrowserPlayer::GetSupportedType(int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer12SetMSESourceEPKNS_9MSESourceE", new Tuple<string, List<string>>("movie::BrowserPlayer::SetMSESource(movie::MSESource const*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer12GetMSESourceEPPNS_9MSESourceE", new Tuple<string, List<string>>("movie::BrowserPlayer::GetMSESource(movie::MSESource**)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer11SetObserverEPNS_21BrowserPlayerObserverE", new Tuple<string, List<string>>("movie::BrowserPlayer::SetObserver(movie::BrowserPlayerObserver*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer11GetObserverEPPNS_21BrowserPlayerObserverE", new Tuple<string, List<string>>("movie::BrowserPlayer::GetObserver(movie::BrowserPlayerObserver**)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayerC2Ev", new Tuple<string, List<string>>("movie::BrowserPlayer::BrowserPlayer()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayerD2Ev", new Tuple<string, List<string>>("movie::BrowserPlayer::~BrowserPlayer()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayerD1Ev", new Tuple<string, List<string>>("movie::BrowserPlayer::~BrowserPlayer()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayerD0Ev", new Tuple<string, List<string>>("movie::BrowserPlayer::~BrowserPlayer()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie21BrowserPlayerObserver13OnHttpRequestEPvPKc", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::OnHttpRequest(void*, char const*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie21BrowserPlayerObserver13OnMultiConfigEPvPKc", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::OnMultiConfig(void*, char const*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie21BrowserPlayerObserver14OnHttpResponseEPvPKc", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::OnHttpResponse(void*, char const*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie21BrowserPlayerObserverD2Ev", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::~BrowserPlayerObserver()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie21BrowserPlayerObserverD1Ev", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::~BrowserPlayerObserver()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie21BrowserPlayerObserverD0Ev", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::~BrowserPlayerObserver()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec6CreateEPPS0_PKcbbb", new Tuple<string, List<string>>("movie::Codec::Create(movie::Codec**, char const*, bool, bool, bool)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec7DestroyEPS0_", new Tuple<string, List<string>>("movie::Codec::Destroy(movie::Codec*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec9ConfigureEPNS_9MediaDataEPN2nn2vi5LayerEPv", new Tuple<string, List<string>>("movie::Codec::Configure(movie::MediaData*, nn::vi::Layer*, void*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec11SetCallbackEPNS_13CodecCallbackE", new Tuple<string, List<string>>("movie::Codec::SetCallback(movie::CodecCallback*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec13SetInputLayerEPN2nn2vi5LayerE", new Tuple<string, List<string>>("movie::Codec::SetInputLayer(nn::vi::Layer*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec5StartEv", new Tuple<string, List<string>>("movie::Codec::Start()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec4StopEv", new Tuple<string, List<string>>("movie::Codec::Stop()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec5ResetEv", new Tuple<string, List<string>>("movie::Codec::Reset()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec7ReleaseEv", new Tuple<string, List<string>>("movie::Codec::Release()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec5FlushEv", new Tuple<string, List<string>>("movie::Codec::Flush()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec14GetInputBufferEiPNS_6BufferE", new Tuple<string, List<string>>("movie::Codec::GetInputBuffer(int, movie::Buffer*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec16QueueInputBufferEiiilj", new Tuple<string, List<string>>("movie::Codec::QueueInputBuffer(int, int, int, long, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec15GetOutputBufferEiPNS_6BufferE", new Tuple<string, List<string>>("movie::Codec::GetOutputBuffer(int, movie::Buffer*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec19ReleaseOutputBufferEi", new Tuple<string, List<string>>("movie::Codec::ReleaseOutputBuffer(int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec28RenderOutputBufferAndReleaseEi", new Tuple<string, List<string>>("movie::Codec::RenderOutputBufferAndRelease(int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec28RenderOutputBufferAndReleaseEil", new Tuple<string, List<string>>("movie::Codec::RenderOutputBufferAndRelease(int, long)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec22SignalEndOfInputStreamEv", new Tuple<string, List<string>>("movie::Codec::SignalEndOfInputStream()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZNK5movie5Codec15GetOutputFormatEPNS_9MediaDataE", new Tuple<string, List<string>>("movie::Codec::GetOutputFormat(movie::MediaData*) const", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZNK5movie5Codec14GetInputFormatEPNS_9MediaDataE", new Tuple<string, List<string>>("movie::Codec::GetInputFormat(movie::MediaData*) const", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec15GetOutputFormatEiPNS_9MediaDataE", new Tuple<string, List<string>>("movie::Codec::GetOutputFormat(int, movie::MediaData*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZNK5movie5Codec7GetNameEPcPi", new Tuple<string, List<string>>("movie::Codec::GetName(char*, int*) const", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec26CopyOutputBufferAndReleaseEii", new Tuple<string, List<string>>("movie::Codec::CopyOutputBufferAndRelease(int, int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec9GetStrideEPiS1_S1_", new Tuple<string, List<string>>("movie::Codec::GetStride(int*, int*, int*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec15SetShadowBufferEPvi", new Tuple<string, List<string>>("movie::Codec::SetShadowBuffer(void*, int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec21SetShadowBuffersParamEii", new Tuple<string, List<string>>("movie::Codec::SetShadowBuffersParam(int, int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5CodecC2Ev", new Tuple<string, List<string>>("movie::Codec::Codec()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5CodecD2Ev", new Tuple<string, List<string>>("movie::Codec::~Codec()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5CodecD1Ev", new Tuple<string, List<string>>("movie::Codec::~Codec()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5CodecD0Ev", new Tuple<string, List<string>>("movie::Codec::~Codec()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13CodecCallback7OnErrorEPNS_5CodecENS_6StatusE", new Tuple<string, List<string>>("movie::CodecCallback::OnError(movie::Codec*, movie::Status)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13CodecCallback22OnInputBufferAvailableEPNS_5CodecEi", new Tuple<string, List<string>>("movie::CodecCallback::OnInputBufferAvailable(movie::Codec*, int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13CodecCallback23OnOutputBufferAvailableEPNS_5CodecEilj", new Tuple<string, List<string>>("movie::CodecCallback::OnOutputBufferAvailable(movie::Codec*, int, long, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13CodecCallback21OnOutputFormatChangedEPNS_5CodecEPNS_9MediaDataE", new Tuple<string, List<string>>("movie::CodecCallback::OnOutputFormatChanged(movie::Codec*, movie::MediaData*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13CodecCallbackD2Ev", new Tuple<string, List<string>>("movie::CodecCallback::~CodecCallback()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13CodecCallbackD1Ev", new Tuple<string, List<string>>("movie::CodecCallback::~CodecCallback()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13CodecCallbackD0Ev", new Tuple<string, List<string>>("movie::CodecCallback::~CodecCallback()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec16QueueInputBufferEiiixj", new Tuple<string, List<string>>("movie::Codec::QueueInputBuffer(int, int, int, long long, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec28RenderOutputBufferAndReleaseEix", new Tuple<string, List<string>>("movie::Codec::RenderOutputBufferAndRelease(int, long long)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13CodecCallback23OnOutputBufferAvailableEPNS_5CodecEixj", new Tuple<string, List<string>>("movie::CodecCallback::OnOutputBufferAvailable(movie::Codec*, int, long long, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie10DataSourceC2Ev", new Tuple<string, List<string>>("movie::DataSource::DataSource()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie10DataSourceD2Ev", new Tuple<string, List<string>>("movie::DataSource::~DataSource()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie10DataSourceD1Ev", new Tuple<string, List<string>>("movie::DataSource::~DataSource()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie10DataSourceD0Ev", new Tuple<string, List<string>>("movie::DataSource::~DataSource()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie10DataSource9initCheckEv", new Tuple<string, List<string>>("movie::DataSource::initCheck()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie10DataSource6readAtElPvm", new Tuple<string, List<string>>("movie::DataSource::readAt(long, void*, unsigned long)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie10DataSource7getSizeEv", new Tuple<string, List<string>>("movie::DataSource::getSize()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie10DataSource6readAtExPvj", new Tuple<string, List<string>>("movie::DataSource::readAt(long long, void*, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie9MSESourceC2Ev", new Tuple<string, List<string>>("movie::MSESource::MSESource()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie9MSESourceD2Ev", new Tuple<string, List<string>>("movie::MSESource::~MSESource()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie9MSESourceD1Ev", new Tuple<string, List<string>>("movie::MSESource::~MSESource()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie9MSESourceD0Ev", new Tuple<string, List<string>>("movie::MSESource::~MSESource()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie9MSESource15AddSourceBufferEPNS_10DataSourceE", new Tuple<string, List<string>>("movie::MSESource::AddSourceBuffer(movie::DataSource*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie9MSESource20GetSourceBufferCountEv", new Tuple<string, List<string>>("movie::MSESource::GetSourceBufferCount()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie9MSESource15GetSourceBufferEm", new Tuple<string, List<string>>("movie::MSESource::GetSourceBuffer(unsigned long)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie9MSESource18RemoveSourceBufferEm", new Tuple<string, List<string>>("movie::MSESource::RemoveSourceBuffer(unsigned long)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie9MSESource15GetSourceBufferEj", new Tuple<string, List<string>>("movie::MSESource::GetSourceBuffer(unsigned int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie9MSESource18RemoveSourceBufferEj", new Tuple<string, List<string>>("movie::MSESource::RemoveSourceBuffer(unsigned int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Muxer6CreateEPPS0_PKcNS_17MuxerOutputFormatE", new Tuple<string, List<string>>("movie::Muxer::Create(movie::Muxer**, char const*, movie::MuxerOutputFormat)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Muxer7DestroyEPS0_", new Tuple<string, List<string>>("movie::Muxer::Destroy(movie::Muxer*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Muxer8AddTrackEPiNS_11TrackFormatE", new Tuple<string, List<string>>("movie::Muxer::AddTrack(int*, movie::TrackFormat)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Muxer5StartEv", new Tuple<string, List<string>>("movie::Muxer::Start()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Muxer11SetLocationEii", new Tuple<string, List<string>>("movie::Muxer::SetLocation(int, int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Muxer4StopEv", new Tuple<string, List<string>>("movie::Muxer::Stop()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Muxer15WriteSampleDataERKNS_6BufferEilj", new Tuple<string, List<string>>("movie::Muxer::WriteSampleData(movie::Buffer const&, int, long, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5MuxerC2Ev", new Tuple<string, List<string>>("movie::Muxer::Muxer()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5MuxerD2Ev", new Tuple<string, List<string>>("movie::Muxer::~Muxer()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5MuxerD1Ev", new Tuple<string, List<string>>("movie::Muxer::~Muxer()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5MuxerD0Ev", new Tuple<string, List<string>>("movie::Muxer::~Muxer()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Muxer15WriteSampleDataERKNS_6BufferEixj", new Tuple<string, List<string>>("movie::Muxer::WriteSampleData(movie::Buffer const&, int, long long, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie12PlayerConfigC2Ev", new Tuple<string, List<string>>("movie::PlayerConfig::PlayerConfig()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie12PlayerConfigC1Ev", new Tuple<string, List<string>>("movie::PlayerConfig::PlayerConfig()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player6CreateEPPS0_PNS_12PlayerConfigE", new Tuple<string, List<string>>("movie::Player::Create(movie::Player**, movie::PlayerConfig*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player7DestroyEPS0_", new Tuple<string, List<string>>("movie::Player::Destroy(movie::Player*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player11SetObserverEPNS_14PlayerObserverE", new Tuple<string, List<string>>("movie::Player::SetObserver(movie::PlayerObserver*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player11GetObserverEPPNS_14PlayerObserverE", new Tuple<string, List<string>>("movie::Player::GetObserver(movie::PlayerObserver**)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player13SetDataSourceEPKc", new Tuple<string, List<string>>("movie::Player::SetDataSource(char const*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player19CancelSetDataSourceEv", new Tuple<string, List<string>>("movie::Player::CancelSetDataSource()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player9GetVolumeEPf", new Tuple<string, List<string>>("movie::Player::GetVolume(float*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player9SetVolumeEf", new Tuple<string, List<string>>("movie::Player::SetVolume(float)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player7PrepareEv", new Tuple<string, List<string>>("movie::Player::Prepare()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player5StartEv", new Tuple<string, List<string>>("movie::Player::Start()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player4StopEv", new Tuple<string, List<string>>("movie::Player::Stop()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player5PauseEb", new Tuple<string, List<string>>("movie::Player::Pause(bool)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player6SeekToEl", new Tuple<string, List<string>>("movie::Player::SeekTo(long)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player26GetCurrentPlaybackPositionEPl", new Tuple<string, List<string>>("movie::Player::GetCurrentPlaybackPosition(long*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player19GetPlaybackDurationEPl", new Tuple<string, List<string>>("movie::Player::GetPlaybackDuration(long*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player13GetTrackCountEPi", new Tuple<string, List<string>>("movie::Player::GetTrackCount(int*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player11SelectTrackEi", new Tuple<string, List<string>>("movie::Player::SelectTrack(int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player13DeSelectTrackEi", new Tuple<string, List<string>>("movie::Player::DeSelectTrack(int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player12GetTrackTypeEiPNS_9TrackTypeE", new Tuple<string, List<string>>("movie::Player::GetTrackType(int, movie::TrackType*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player18GetVideoDimensionsEPiS1_", new Tuple<string, List<string>>("movie::Player::GetVideoDimensions(int*, int*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player5ResetEv", new Tuple<string, List<string>>("movie::Player::Reset()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player10SetLoopingEb", new Tuple<string, List<string>>("movie::Player::SetLooping(bool)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player10GetLoopingEPb", new Tuple<string, List<string>>("movie::Player::GetLooping(bool*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player15GetPlaybackRateEPNS_12PlaybackRateE", new Tuple<string, List<string>>("movie::Player::GetPlaybackRate(movie::PlaybackRate*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player15SetPlaybackRateENS_12PlaybackRateE", new Tuple<string, List<string>>("movie::Player::SetPlaybackRate(movie::PlaybackRate)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player8GetStateEPNS_11PlayerStateE", new Tuple<string, List<string>>("movie::Player::GetState(movie::PlayerState*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player12GetTrackInfoEiPNS_9TrackInfoE", new Tuple<string, List<string>>("movie::Player::GetTrackInfo(int, movie::TrackInfo*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player24AcquireOutputBufferIndexEiPiPlS1_", new Tuple<string, List<string>>("movie::Player::AcquireOutputBufferIndex(int, int*, long*, int*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player19GetOutputBufferSizeEiPi", new Tuple<string, List<string>>("movie::Player::GetOutputBufferSize(int, int*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player16FillOutputBufferEiiPNS_6BufferEPlPj", new Tuple<string, List<string>>("movie::Player::FillOutputBuffer(int, int, movie::Buffer*, long*, unsigned int*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player24ReleaseOutputBufferIndexEii", new Tuple<string, List<string>>("movie::Player::ReleaseOutputBufferIndex(int, int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player24SetOutputBufferAlignmentEPNS_9MediaDataE", new Tuple<string, List<string>>("movie::Player::SetOutputBufferAlignment(movie::MediaData*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player6SeekToElPl", new Tuple<string, List<string>>("movie::Player::SeekTo(long, long*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player25GetOutputBufferPropertiesEPNS_9MediaDataE", new Tuple<string, List<string>>("movie::Player::GetOutputBufferProperties(movie::MediaData*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player25GetOutputBufferPropertiesEiPNS_9MediaDataE", new Tuple<string, List<string>>("movie::Player::GetOutputBufferProperties(int, movie::MediaData*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player26TerminateNetworkConnectionEv", new Tuple<string, List<string>>("movie::Player::TerminateNetworkConnection()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player20RegisterOutputBufferEPNS_6BufferEPi", new Tuple<string, List<string>>("movie::Player::RegisterOutputBuffer(movie::Buffer*, int*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6PlayerC2Ev", new Tuple<string, List<string>>("movie::Player::Player()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6PlayerD2Ev", new Tuple<string, List<string>>("movie::Player::~Player()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6PlayerD1Ev", new Tuple<string, List<string>>("movie::Player::~Player()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6PlayerD0Ev", new Tuple<string, List<string>>("movie::Player::~Player()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserver7OnErrorENS_6StatusE", new Tuple<string, List<string>>("movie::PlayerObserver::OnError(movie::Status)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserver13OnStateChangeENS_11PlayerStateE", new Tuple<string, List<string>>("movie::PlayerObserver::OnStateChange(movie::PlayerState)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserver17OnBufferingUpdateEff", new Tuple<string, List<string>>("movie::PlayerObserver::OnBufferingUpdate(float, float)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserver27OnAudioOutputFrameAvailableEPNS_14AudioFrameInfoE", new Tuple<string, List<string>>("movie::PlayerObserver::OnAudioOutputFrameAvailable(movie::AudioFrameInfo*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserver27OnVideoOutputFrameAvailableEPNS_14VideoFrameInfoE", new Tuple<string, List<string>>("movie::PlayerObserver::OnVideoOutputFrameAvailable(movie::VideoFrameInfo*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserver23OnOutputBufferAvailableEiNS_9TrackTypeE", new Tuple<string, List<string>>("movie::PlayerObserver::OnOutputBufferAvailable(int, movie::TrackType)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserver23OnOutputBufferAvailableEiNS_9TrackTypeEli", new Tuple<string, List<string>>("movie::PlayerObserver::OnOutputBufferAvailable(int, movie::TrackType, long, int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserver15OnFormatChangedENS_9TrackTypeE", new Tuple<string, List<string>>("movie::PlayerObserver::OnFormatChanged(movie::TrackType)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserverD2Ev", new Tuple<string, List<string>>("movie::PlayerObserver::~PlayerObserver()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserverD1Ev", new Tuple<string, List<string>>("movie::PlayerObserver::~PlayerObserver()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserverD0Ev", new Tuple<string, List<string>>("movie::PlayerObserver::~PlayerObserver()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player6SeekToEx", new Tuple<string, List<string>>("movie::Player::SeekTo(long long)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player26GetCurrentPlaybackPositionEPx", new Tuple<string, List<string>>("movie::Player::GetCurrentPlaybackPosition(long long*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player19GetPlaybackDurationEPx", new Tuple<string, List<string>>("movie::Player::GetPlaybackDuration(long long*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player24AcquireOutputBufferIndexEiPiPxS1_", new Tuple<string, List<string>>("movie::Player::AcquireOutputBufferIndex(int, int*, long long*, int*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player16FillOutputBufferEiiPNS_6BufferEPxPj", new Tuple<string, List<string>>("movie::Player::FillOutputBuffer(int, int, movie::Buffer*, long long*, unsigned int*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player6SeekToExPx", new Tuple<string, List<string>>("movie::Player::SeekTo(long long, long long*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserver23OnOutputBufferAvailableEiNS_9TrackTypeExi", new Tuple<string, List<string>>("movie::PlayerObserver::OnOutputBufferAvailable(int, movie::TrackType, long long, int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15ExtractorConfigC2Ev", new Tuple<string, List<string>>("movie::ExtractorConfig::ExtractorConfig()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15ExtractorConfigC1Ev", new Tuple<string, List<string>>("movie::ExtractorConfig::ExtractorConfig()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor6CreateEPPS0_", new Tuple<string, List<string>>("movie::PlayerExtractor::Create(movie::PlayerExtractor**)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor6CreateEPPS0_PNS_15ExtractorConfigE", new Tuple<string, List<string>>("movie::PlayerExtractor::Create(movie::PlayerExtractor**, movie::ExtractorConfig*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor7DestroyEPS0_", new Tuple<string, List<string>>("movie::PlayerExtractor::Destroy(movie::PlayerExtractor*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor13SetDataSourceEPKc", new Tuple<string, List<string>>("movie::PlayerExtractor::SetDataSource(char const*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor13SetDataSourceEPKvi", new Tuple<string, List<string>>("movie::PlayerExtractor::SetDataSource(void const*, int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZNK5movie15PlayerExtractor11CountTracksEPi", new Tuple<string, List<string>>("movie::PlayerExtractor::CountTracks(int*) const", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZNK5movie15PlayerExtractor14GetTrackFormatEiPNS_9MediaDataE", new Tuple<string, List<string>>("movie::PlayerExtractor::GetTrackFormat(int, movie::MediaData*) const", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZNK5movie15PlayerExtractor13GetFileFormatEPNS_9MediaDataE", new Tuple<string, List<string>>("movie::PlayerExtractor::GetFileFormat(movie::MediaData*) const", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor11SelectTrackEi", new Tuple<string, List<string>>("movie::PlayerExtractor::SelectTrack(int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor13UnselectTrackEi", new Tuple<string, List<string>>("movie::PlayerExtractor::UnselectTrack(int)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor6SeekToEl", new Tuple<string, List<string>>("movie::PlayerExtractor::SeekTo(long)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor7AdvanceEv", new Tuple<string, List<string>>("movie::PlayerExtractor::Advance()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor14ReadSampleDataEPNS_6BufferE", new Tuple<string, List<string>>("movie::PlayerExtractor::ReadSampleData(movie::Buffer*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor19GetSampleTrackIndexEPm", new Tuple<string, List<string>>("movie::PlayerExtractor::GetSampleTrackIndex(unsigned long*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor13GetSampleTimeEPl", new Tuple<string, List<string>>("movie::PlayerExtractor::GetSampleTime(long*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor13GetSampleTimeEmPl", new Tuple<string, List<string>>("movie::PlayerExtractor::GetSampleTime(unsigned long, long*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor13GetSampleMetaEPNS_9MediaDataE", new Tuple<string, List<string>>("movie::PlayerExtractor::GetSampleMeta(movie::MediaData*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZNK5movie15PlayerExtractor17GetCachedDurationEPlPb", new Tuple<string, List<string>>("movie::PlayerExtractor::GetCachedDuration(long*, bool*) const", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor19CancelSetDataSourceEv", new Tuple<string, List<string>>("movie::PlayerExtractor::CancelSetDataSource()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor11IsCacheFullEPb", new Tuple<string, List<string>>("movie::PlayerExtractor::IsCacheFull(bool*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor26TerminateNetworkConnectionEv", new Tuple<string, List<string>>("movie::PlayerExtractor::TerminateNetworkConnection()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractorC2Ev", new Tuple<string, List<string>>("movie::PlayerExtractor::PlayerExtractor()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractorC2EPNS_15ExtractorConfigE", new Tuple<string, List<string>>("movie::PlayerExtractor::PlayerExtractor(movie::ExtractorConfig*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractorD2Ev", new Tuple<string, List<string>>("movie::PlayerExtractor::~PlayerExtractor()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractorD1Ev", new Tuple<string, List<string>>("movie::PlayerExtractor::~PlayerExtractor()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractorD0Ev", new Tuple<string, List<string>>("movie::PlayerExtractor::~PlayerExtractor()", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor6SeekToEx", new Tuple<string, List<string>>("movie::PlayerExtractor::SeekTo(long long)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor19GetSampleTrackIndexEPj", new Tuple<string, List<string>>("movie::PlayerExtractor::GetSampleTrackIndex(unsigned int*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor13GetSampleTimeEPx", new Tuple<string, List<string>>("movie::PlayerExtractor::GetSampleTime(long long*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor13GetSampleTimeEjPx", new Tuple<string, List<string>>("movie::PlayerExtractor::GetSampleTime(unsigned int, long long*)", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZNK5movie15PlayerExtractor17GetCachedDurationEPxPb", new Tuple<string, List<string>>("movie::PlayerExtractor::GetCachedDuration(long long*, bool*) const", new List<string>() { "3_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN2nn3ldn17InitializeMonitorEv", new Tuple<string, List<string>>("nn::ldn::InitializeMonitor()", new List<string>() { "3_BundleRules_NX_Private_LdnMonitor_LdnMonitor" }) },
                        { "_ZN2nn3ldn15FinalizeMonitorEv", new Tuple<string, List<string>>("nn::ldn::FinalizeMonitor()", new List<string>() { "3_BundleRules_NX_Private_LdnMonitor_LdnMonitor" }) },
                        { "_ZN2nn3ldn18GetStateForMonitorEv", new Tuple<string, List<string>>("nn::ldn::GetStateForMonitor()", new List<string>() { "3_BundleRules_NX_Private_LdnMonitor_LdnMonitor" }) },
                        { "_ZN2nn3ldn24GetNetworkInfoForMonitorEPNS0_11NetworkInfoE", new Tuple<string, List<string>>("nn::ldn::GetNetworkInfoForMonitor(nn::ldn::NetworkInfo*)", new List<string>() { "3_BundleRules_NX_Private_LdnMonitor_LdnMonitor" }) },
                        { "_ZN2nn3ldn24GetIpv4AddressForMonitorEPNS0_11Ipv4AddressEPNS0_10SubnetMaskE", new Tuple<string, List<string>>("nn::ldn::GetIpv4AddressForMonitor(nn::ldn::Ipv4Address*, nn::ldn::SubnetMask*)", new List<string>() { "3_BundleRules_NX_Private_LdnMonitor_LdnMonitor" }) },
                        { "_ZN2nn3ldn16InitializeSystemEv", new Tuple<string, List<string>>("nn::ldn::InitializeSystem()", new List<string>() { "3_BundleRules_NX_Private_LdnSystem_LdnSystem" }) },
                        { "_ZN2nn3ldn14FinalizeSystemEv", new Tuple<string, List<string>>("nn::ldn::FinalizeSystem()", new List<string>() { "3_BundleRules_NX_Private_LdnSystem_LdnSystem" }) },
                        { "_ZN2nn3ldn11ScanPrivateEPNS0_11NetworkInfoEPiiRKNS0_10ScanFilterEi", new Tuple<string, List<string>>("nn::ldn::ScanPrivate(nn::ldn::NetworkInfo*, int*, int, nn::ldn::ScanFilter const&, int)", new List<string>() { "3_BundleRules_NX_Private_LdnPrivate_LdnPrivate" }) },
                        { "_ZN2nn3ldn20CreateNetworkPrivateERKNS0_13NetworkConfigERKNS0_14SecurityConfigERKNS0_17SecurityParameterERKNS0_10UserConfigEiPKNS0_12AddressEntryE", new Tuple<string, List<string>>("nn::ldn::CreateNetworkPrivate(nn::ldn::NetworkConfig const&, nn::ldn::SecurityConfig const&, nn::ldn::SecurityParameter const&, nn::ldn::UserConfig const&, int, nn::ldn::AddressEntry const*)", new List<string>() { "3_BundleRules_NX_Private_LdnPrivate_LdnPrivate" }) },
                        { "_ZN2nn3ldn14ConnectPrivateERKNS0_13NetworkConfigERKNS0_14SecurityConfigERKNS0_17SecurityParameterERKNS0_10UserConfigEiNS0_13ConnectOptionE", new Tuple<string, List<string>>("nn::ldn::ConnectPrivate(nn::ldn::NetworkConfig const&, nn::ldn::SecurityConfig const&, nn::ldn::SecurityParameter const&, nn::ldn::UserConfig const&, int, nn::ldn::ConnectOption)", new List<string>() { "3_BundleRules_NX_Private_LdnPrivate_LdnPrivate" }) },
                        { "_ZN2nn3ldn14ConnectPrivateERKNS0_13NetworkConfigERKNS0_14SecurityConfigERKNS0_17SecurityParameterERKNS0_10UserConfigEi", new Tuple<string, List<string>>("nn::ldn::ConnectPrivate(nn::ldn::NetworkConfig const&, nn::ldn::SecurityConfig const&, nn::ldn::SecurityParameter const&, nn::ldn::UserConfig const&, int)", new List<string>() { "3_BundleRules_NX_Private_LdnPrivate_LdnPrivate" }) },
                        { "_ZN2nn3ldn20GetSecurityParameterEPNS0_17SecurityParameterE", new Tuple<string, List<string>>("nn::ldn::GetSecurityParameter(nn::ldn::SecurityParameter*)", new List<string>() { "3_BundleRules_NX_Private_LdnPrivate_LdnPrivate" }) },
                        { "_ZN2nn3ldn16GetNetworkConfigEPNS0_13NetworkConfigE", new Tuple<string, List<string>>("nn::ldn::GetNetworkConfig(nn::ldn::NetworkConfig*)", new List<string>() { "3_BundleRules_NX_Private_LdnPrivate_LdnPrivate" }) },
                        { "_ZN2nn3ldn20AddAcceptFilterEntryENS0_10MacAddressE", new Tuple<string, List<string>>("nn::ldn::AddAcceptFilterEntry(nn::ldn::MacAddress)", new List<string>() { "3_BundleRules_NX_Private_LdnPrivate_LdnPrivate" }) },
                        { "_ZN2nn3ldnL11PriorityMinE", new Tuple<string, List<string>>("nn::ldn::PriorityMin", new List<string>() { "3_BundleRules_NX_Private_LdnPrivate_LdnPrivate" }) },
                        { "_ZN2nn3ldnL11PriorityMaxE", new Tuple<string, List<string>>("nn::ldn::PriorityMax", new List<string>() { "3_BundleRules_NX_Private_LdnPrivate_LdnPrivate" }) },
                        { "_ZN2nn3ldnL12UserPriorityE", new Tuple<string, List<string>>("nn::ldn::UserPriority", new List<string>() { "3_BundleRules_NX_Private_LdnPrivate_LdnPrivate" }) },
                        { "_ZN2nn3ldnL21DefaultSystemPriorityE", new Tuple<string, List<string>>("nn::ldn::DefaultSystemPriority", new List<string>() { "3_BundleRules_NX_Private_LdnPrivate_LdnPrivate" }) },
                        { "_ZN2nn3ldnL20AddressEntryCountMaxE", new Tuple<string, List<string>>("nn::ldn::AddressEntryCountMax", new List<string>() { "3_BundleRules_NX_Private_LdnPrivate_LdnPrivate" }) },
                        { "_ZN2nn3btm6system26AcquireGamepadPairingEventEPNS_2os15SystemEventTypeE", new Tuple<string, List<string>>("nn::btm::system::AcquireGamepadPairingEvent(nn::os::SystemEventType*)", new List<string>() { "3_BundleRules_NX_Private_BtmSystem_BtmSystem" }) },
                        { "_ZN2nn3btm6system19StartGamepadPairingEv", new Tuple<string, List<string>>("nn::btm::system::StartGamepadPairing()", new List<string>() { "3_BundleRules_NX_Private_BtmSystem_BtmSystem" }) },
                        { "_ZN2nn3btm6system20CancelGamepadPairingEv", new Tuple<string, List<string>>("nn::btm::system::CancelGamepadPairing()", new List<string>() { "3_BundleRules_NX_Private_BtmSystem_BtmSystem" }) },
                        { "_ZN2nn3btm6system23IsGamepadPairingStartedEv", new Tuple<string, List<string>>("nn::btm::system::IsGamepadPairingStarted()", new List<string>() { "3_BundleRules_NX_Private_BtmSystem_BtmSystem" }) },
                        { "_ZN2nn3btm6system21GetPairedGamepadCountEv", new Tuple<string, List<string>>("nn::btm::system::GetPairedGamepadCount()", new List<string>() { "3_BundleRules_NX_Private_BtmSystem_BtmSystem" }) },
                        { "_ZN2nn3btm6system27ClearGamepadPairingDatabaseEv", new Tuple<string, List<string>>("nn::btm::system::ClearGamepadPairingDatabase()", new List<string>() { "3_BundleRules_NX_Private_BtmSystem_BtmSystem" }) },
                        { "_ZN2nn3btm6system17AcquireRadioEventEPNS_2os15SystemEventTypeE", new Tuple<string, List<string>>("nn::btm::system::AcquireRadioEvent(nn::os::SystemEventType*)", new List<string>() { "3_BundleRules_NX_Private_BtmSystem_BtmSystem" }) },
                        { "_ZN2nn3btm6system11EnableRadioEb", new Tuple<string, List<string>>("nn::btm::system::EnableRadio(bool)", new List<string>() { "3_BundleRules_NX_Private_BtmSystem_BtmSystem" }) },
                        { "_ZN2nn3btm6system14IsRadioEnabledEv", new Tuple<string, List<string>>("nn::btm::system::IsRadioEnabled()", new List<string>() { "3_BundleRules_NX_Private_BtmSystem_BtmSystem" }) },
                        { "_ZN2nv22SetGraphicsServiceNameEPKc", new Tuple<string, List<string>>("nv::SetGraphicsServiceName(char const*)", new List<string>() { "3_BundleRules_NX_Private_NvnPrivate_NvnPrivate" }) },
                        { "_ZN2nn3web13ShowLobbyPageEPNS0_20LobbyPageReturnValueERKNS0_16ShowLobbyPageArgE", new Tuple<string, List<string>>("nn::web::ShowLobbyPage(nn::web::LobbyPageReturnValue*, nn::web::ShowLobbyPageArg const&)", new List<string>() { "3_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3web16ShowLobbyPageArg23LobbyParameterMaxLengthE", new Tuple<string, List<string>>("nn::web::ShowLobbyPageArg::LobbyParameterMaxLength", new List<string>() { "3_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3web16ShowLobbyPageArgC2Ev", new Tuple<string, List<string>>("nn::web::ShowLobbyPageArg::ShowLobbyPageArg()", new List<string>() { "3_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3web16ShowLobbyPageArgC1Ev", new Tuple<string, List<string>>("nn::web::ShowLobbyPageArg::ShowLobbyPageArg()", new List<string>() { "3_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3web16ShowLobbyPageArg6SetUidERKNS_7account3UidE", new Tuple<string, List<string>>("nn::web::ShowLobbyPageArg::SetUid(nn::account::Uid const&)", new List<string>() { "3_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3web16ShowLobbyPageArg17SetLobbyParameterEPKc", new Tuple<string, List<string>>("nn::web::ShowLobbyPageArg::SetLobbyParameter(char const*)", new List<string>() { "3_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3web16ShowLobbyPageArg8DataSizeE", new Tuple<string, List<string>>("nn::web::ShowLobbyPageArg::DataSize", new List<string>() { "3_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3web20LobbyPageReturnValue16LastUrlMaxLengthE", new Tuple<string, List<string>>("nn::web::LobbyPageReturnValue::LastUrlMaxLength", new List<string>() { "3_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3web20LobbyPageReturnValueC2Ev", new Tuple<string, List<string>>("nn::web::LobbyPageReturnValue::LobbyPageReturnValue()", new List<string>() { "3_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3web20LobbyPageReturnValueC1Ev", new Tuple<string, List<string>>("nn::web::LobbyPageReturnValue::LobbyPageReturnValue()", new List<string>() { "3_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZNK2nn3web20LobbyPageReturnValue18GetLobbyExitReasonEv", new Tuple<string, List<string>>("nn::web::LobbyPageReturnValue::GetLobbyExitReason() const", new List<string>() { "3_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZNK2nn3web20LobbyPageReturnValue10GetLastUrlEv", new Tuple<string, List<string>>("nn::web::LobbyPageReturnValue::GetLastUrl() const", new List<string>() { "3_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZNK2nn3web20LobbyPageReturnValue14GetLastUrlSizeEv", new Tuple<string, List<string>>("nn::web::LobbyPageReturnValue::GetLastUrlSize() const", new List<string>() { "3_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3hid15PermitVibrationEb", new Tuple<string, List<string>>("nn::hid::PermitVibration(bool)", new List<string>() { "3_BundleRules_NX_Private_VibrationPermission_VibrationPermission" }) },
                        { "_ZN2nn2oe21GetExpectedThemeColorEv", new Tuple<string, List<string>>("nn::oe::GetExpectedThemeColor()", new List<string>() { "3_BundleRules_NX_Private_OperationStateControl_operation-state-control" }) },
                        { "_ZN2nn2oe30SetExpectedThemeColorForSystemENS0_14ThemeColorTypeE", new Tuple<string, List<string>>("nn::oe::SetExpectedThemeColorForSystem(nn::oe::ThemeColorType)", new List<string>() { "3_BundleRules_NX_Private_OperationStateControl_operation-state-control" }) },
                        { "_ZN2nn2oe20GetDefaultThemeColorEv", new Tuple<string, List<string>>("nn::oe::GetDefaultThemeColor()", new List<string>() { "3_BundleRules_NX_Private_OperationStateControl_operation-state-control" }) },
                        { "_ZN2nn3fgm7RequestC2ERKS1_", new Tuple<string, List<string>>("nn::fgm::Request::Request(nn::fgm::Request const&)", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7RequestC1ERKS1_", new Tuple<string, List<string>>("nn::fgm::Request::Request(nn::fgm::Request const&)", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7RequestaSERKS1_", new Tuple<string, List<string>>("nn::fgm::Request::operator=(nn::fgm::Request const&)", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7RequestC2EOS1_", new Tuple<string, List<string>>("nn::fgm::Request::Request(nn::fgm::Request&&)", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7RequestC1EOS1_", new Tuple<string, List<string>>("nn::fgm::Request::Request(nn::fgm::Request&&)", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7RequestaSEOS1_", new Tuple<string, List<string>>("nn::fgm::Request::operator=(nn::fgm::Request&&)", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7Request10InitializeENS0_6ModuleEjNS_2os14EventClearModeE", new Tuple<string, List<string>>("nn::fgm::Request::Initialize(nn::fgm::Module, unsigned int, nn::os::EventClearMode)", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7Request10InitializeENS0_6ModuleEj", new Tuple<string, List<string>>("nn::fgm::Request::Initialize(nn::fgm::Module, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7Request3SetEjj", new Tuple<string, List<string>>("nn::fgm::Request::Set(unsigned int, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7Request10SetAndWaitEjj", new Tuple<string, List<string>>("nn::fgm::Request::SetAndWait(unsigned int, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7Request21SetAndWaitWithTimeoutEjjNS_8TimeSpanE", new Tuple<string, List<string>>("nn::fgm::Request::SetAndWaitWithTimeout(unsigned int, unsigned int, nn::TimeSpan)", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7Request3GetEPj", new Tuple<string, List<string>>("nn::fgm::Request::Get(unsigned int*)", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7Request4WaitEv", new Tuple<string, List<string>>("nn::fgm::Request::Wait()", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7Request15WaitWithTimeoutENS_8TimeSpanE", new Tuple<string, List<string>>("nn::fgm::Request::WaitWithTimeout(nn::TimeSpan)", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7Request6CancelEv", new Tuple<string, List<string>>("nn::fgm::Request::Cancel()", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7Request21GetSystemEventPointerEv", new Tuple<string, List<string>>("nn::fgm::Request::GetSystemEventPointer()", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7Request10ClearEventEv", new Tuple<string, List<string>>("nn::fgm::Request::ClearEvent()", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7Request8FinalizeEv", new Tuple<string, List<string>>("nn::fgm::Request::Finalize()", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7RequestC2Ev", new Tuple<string, List<string>>("nn::fgm::Request::Request()", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7RequestC1Ev", new Tuple<string, List<string>>("nn::fgm::Request::Request()", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7RequestD2Ev", new Tuple<string, List<string>>("nn::fgm::Request::~Request()", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7RequestD1Ev", new Tuple<string, List<string>>("nn::fgm::Request::~Request()", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgmL18NumberOfPrioritiesE", new Tuple<string, List<string>>("nn::fgm::NumberOfPriorities", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgmL15FgmPortPriorityE", new Tuple<string, List<string>>("nn::fgm::FgmPortPriority", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgmL16FgmDebugPortNameE", new Tuple<string, List<string>>("nn::fgm::FgmDebugPortName", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgmL8PortNameE", new Tuple<string, List<string>>("nn::fgm::PortName", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgmL26MaximumRequestsPerPriorityE", new Tuple<string, List<string>>("nn::fgm::MaximumRequestsPerPriority", new List<string>() { "3_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3web36ShowOfflineHtmlPageArgWithPlayReportC2EPKc", new Tuple<string, List<string>>("nn::web::ShowOfflineHtmlPageArgWithPlayReport::ShowOfflineHtmlPageArgWithPlayReport(char const*)", new List<string>() { "3_BundleRules_NX_Private_OfflineWebPlayReport_OfflineWebPlayReport" }) },
                        { "_ZN2nn3web36ShowOfflineHtmlPageArgWithPlayReportC1EPKc", new Tuple<string, List<string>>("nn::web::ShowOfflineHtmlPageArgWithPlayReport::ShowOfflineHtmlPageArgWithPlayReport(char const*)", new List<string>() { "3_BundleRules_NX_Private_OfflineWebPlayReport_OfflineWebPlayReport" }) },
                        { "_ZN2nn3web36ShowOfflineHtmlPageArgWithPlayReportC2ERKNS_13ApplicationIdEPKc", new Tuple<string, List<string>>("nn::web::ShowOfflineHtmlPageArgWithPlayReport::ShowOfflineHtmlPageArgWithPlayReport(nn::ApplicationId const&, char const*)", new List<string>() { "3_BundleRules_NX_Private_OfflineWebPlayReport_OfflineWebPlayReport" }) },
                        { "_ZN2nn3web36ShowOfflineHtmlPageArgWithPlayReportC1ERKNS_13ApplicationIdEPKc", new Tuple<string, List<string>>("nn::web::ShowOfflineHtmlPageArgWithPlayReport::ShowOfflineHtmlPageArgWithPlayReport(nn::ApplicationId const&, char const*)", new List<string>() { "3_BundleRules_NX_Private_OfflineWebPlayReport_OfflineWebPlayReport" }) },
                        { "_ZN2nn3web36ShowOfflineHtmlPageArgWithPlayReport20SetPlayReportEnabledEb", new Tuple<string, List<string>>("nn::web::ShowOfflineHtmlPageArgWithPlayReport::SetPlayReportEnabled(bool)", new List<string>() { "3_BundleRules_NX_Private_OfflineWebPlayReport_OfflineWebPlayReport" }) },
                        { "_ZN2nn5prepo27IsUserAgreementCheckEnabledEPb", new Tuple<string, List<string>>("nn::prepo::IsUserAgreementCheckEnabled(bool*)", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo28SetUserAgreementCheckEnabledEb", new Tuple<string, List<string>>("nn::prepo::SetUserAgreementCheckEnabled(bool)", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReportC2ERKS1_", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::SystemPlayReport(nn::prepo::SystemPlayReport const&)", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReportC1ERKS1_", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::SystemPlayReport(nn::prepo::SystemPlayReport const&)", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReportaSERKS1_", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::operator=(nn::prepo::SystemPlayReport const&)", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReportC2EOS1_", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::SystemPlayReport(nn::prepo::SystemPlayReport&&)", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReportC1EOS1_", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::SystemPlayReport(nn::prepo::SystemPlayReport&&)", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReportaSEOS1_", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::operator=(nn::prepo::SystemPlayReport&&)", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport13BufferSizeMinE", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::BufferSizeMin", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport13BufferSizeMaxE", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::BufferSizeMax", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReportC2Ev", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::SystemPlayReport()", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReportC1Ev", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::SystemPlayReport()", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReportC2EPKc", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::SystemPlayReport(char const*)", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReportC1EPKc", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::SystemPlayReport(char const*)", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport9SetBufferEPvm", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::SetBuffer(void*, unsigned long)", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport10SetEventIdEPKc", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::SetEventId(char const*)", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport16SetApplicationIdERKNS_13ApplicationIdE", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::SetApplicationId(nn::ApplicationId const&)", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport5ClearEv", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::Clear()", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport3AddEPKcl", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::Add(char const*, long)", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport3AddEPKcRKNS0_10Any64BitIdE", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::Add(char const*, nn::prepo::Any64BitId const&)", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport3AddEPKcd", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::Add(char const*, double)", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport3AddEPKcS3_", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::Add(char const*, char const*)", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport4SaveEv", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::Save()", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport4SaveERKNS_7account3UidE", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::Save(nn::account::Uid const&)", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn5prepo16SystemPlayReport8GetCountEv", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::GetCount() const", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport9SetBufferEPvj", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::SetBuffer(void*, unsigned int)", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport3AddEPKcx", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::Add(char const*, long long)", new List<string>() { "3_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fsL31SdCardNintendoRootDirectoryNameE", new Tuple<string, List<string>>("nn::fs::SdCardNintendoRootDirectoryName", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs11MountSdCardEPKc", new Tuple<string, List<string>>("nn::fs::MountSdCard(char const*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fsL13SdCardCidSizeE", new Tuple<string, List<string>>("nn::fs::SdCardCidSize", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs32OpenSdCardDetectionEventNotifierEPNSt3__110unique_ptrINS0_14IEventNotifierENS1_14default_deleteIS3_EEEE", new Tuple<string, List<string>>("nn::fs::OpenSdCardDetectionEventNotifier(std::__1::unique_ptr<nn::fs::IEventNotifier, std::__1::default_delete<nn::fs::IEventNotifier> >*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs16IsSdCardInsertedEv", new Tuple<string, List<string>>("nn::fs::IsSdCardInserted()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs18GetSdCardSpeedModeEPNS0_15SdCardSpeedModeE", new Tuple<string, List<string>>("nn::fs::GetSdCardSpeedMode(nn::fs::SdCardSpeedMode*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs12GetSdCardCidEPvm", new Tuple<string, List<string>>("nn::fs::GetSdCardCid(void*, unsigned long)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs19GetMidFromSdCardCidEPKh", new Tuple<string, List<string>>("nn::fs::GetMidFromSdCardCid(unsigned char const*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fsL16SdCardCidOidSizeE", new Tuple<string, List<string>>("nn::fs::SdCardCidOidSize", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs19GetOidFromSdCardCidEPcmPKh", new Tuple<string, List<string>>("nn::fs::GetOidFromSdCardCid(char*, unsigned long, unsigned char const*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fsL16SdCardCidPnmSizeE", new Tuple<string, List<string>>("nn::fs::SdCardCidPnmSize", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs19GetPnmFromSdCardCidEPcmPKh", new Tuple<string, List<string>>("nn::fs::GetPnmFromSdCardCid(char*, unsigned long, unsigned char const*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs19GetPrvFromSdCardCidEPKh", new Tuple<string, List<string>>("nn::fs::GetPrvFromSdCardCid(unsigned char const*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs19GetPsnFromSdCardCidEPKh", new Tuple<string, List<string>>("nn::fs::GetPsnFromSdCardCid(unsigned char const*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs27GetMdtYearCodeFromSdCardCidEPKh", new Tuple<string, List<string>>("nn::fs::GetMdtYearCodeFromSdCardCid(unsigned char const*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs28GetMdtMonthCodeFromSdCardCidEPKh", new Tuple<string, List<string>>("nn::fs::GetMdtMonthCodeFromSdCardCid(unsigned char const*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs21GetSdCardUserAreaSizeEPl", new Tuple<string, List<string>>("nn::fs::GetSdCardUserAreaSize(long*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs26GetSdCardProtectedAreaSizeEPl", new Tuple<string, List<string>>("nn::fs::GetSdCardProtectedAreaSize(long*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs12FormatSdCardEv", new Tuple<string, List<string>>("nn::fs::FormatSdCard()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs18FormatSdCardDryRunEv", new Tuple<string, List<string>>("nn::fs::FormatSdCardDryRun()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs14EncryptionSeed4SizeE", new Tuple<string, List<string>>("nn::fs::EncryptionSeed::Size", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs23SetSdCardEncryptionSeedERKNS0_14EncryptionSeedE", new Tuple<string, List<string>>("nn::fs::SetSdCardEncryptionSeed(nn::fs::EncryptionSeed const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs12GetSdCardCidEPvj", new Tuple<string, List<string>>("nn::fs::GetSdCardCid(void*, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs19GetOidFromSdCardCidEPcjPKh", new Tuple<string, List<string>>("nn::fs::GetOidFromSdCardCid(char*, unsigned int, unsigned char const*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs19GetPnmFromSdCardCidEPcjPKh", new Tuple<string, List<string>>("nn::fs::GetPnmFromSdCardCid(char*, unsigned int, unsigned char const*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs21GetSdCardUserAreaSizeEPx", new Tuple<string, List<string>>("nn::fs::GetSdCardUserAreaSize(long long*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs26GetSdCardProtectedAreaSizeEPx", new Tuple<string, List<string>>("nn::fs::GetSdCardProtectedAreaSize(long long*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm13ApplicationId12GetInvalidIdEv", new Tuple<string, List<string>>("nn::ncm::ApplicationId::GetInvalidId()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3ncm13ApplicationIdcvNS0_9ProgramIdEEv", new Tuple<string, List<string>>("nn::ncm::ApplicationId::operator nn::ncm::ProgramId() const", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3ncm7PatchIdcvNS0_9ProgramIdEEv", new Tuple<string, List<string>>("nn::ncm::PatchId::operator nn::ncm::ProgramId() const", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3ncm14AddOnContentIdcvNS0_6DataIdEEv", new Tuple<string, List<string>>("nn::ncm::AddOnContentId::operator nn::ncm::DataId() const", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3ncm7DeltaIdcvNS0_9ProgramIdEEv", new Tuple<string, List<string>>("nn::ncm::DeltaId::operator nn::ncm::ProgramId() const", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3ncm14ContentMetaKeyltERKS1_", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::operator<(nn::ncm::ContentMetaKey const&) const", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3ncm14ContentMetaKeyeqERKS1_", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::operator==(nn::ncm::ContentMetaKey const&) const", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3ncm14ContentMetaKeyneERKS1_", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::operator!=(nn::ncm::ContentMetaKey const&) const", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey4MakeENS0_15SystemProgramIdEj", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::Make(nn::ncm::SystemProgramId, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey4MakeENS0_12SystemDataIdEj", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::Make(nn::ncm::SystemDataId, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey4MakeENS0_13ApplicationIdEj", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::Make(nn::ncm::ApplicationId, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey4MakeENS0_7PatchIdEj", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::Make(nn::ncm::PatchId, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey4MakeENS0_7PatchIdEjNS0_18ContentInstallTypeE", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::Make(nn::ncm::PatchId, unsigned int, nn::ncm::ContentInstallType)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey4MakeENS0_7DeltaIdEj", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::Make(nn::ncm::DeltaId, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey4MakeEmjNS0_15ContentMetaTypeE", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::Make(unsigned long, unsigned int, nn::ncm::ContentMetaType)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey4MakeEmjNS0_15ContentMetaTypeENS0_18ContentInstallTypeE", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::Make(unsigned long, unsigned int, nn::ncm::ContentMetaType, nn::ncm::ContentInstallType)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey15MakeUnknownTypeEmj", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::MakeUnknownType(unsigned long, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3ncm21StorageContentMetaKeyeqERKS1_", new Tuple<string, List<string>>("nn::ncm::StorageContentMetaKey::operator==(nn::ncm::StorageContentMetaKey const&) const", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3ncm21StorageContentMetaKeyltERKS1_", new Tuple<string, List<string>>("nn::ncm::StorageContentMetaKey::operator<(nn::ncm::StorageContentMetaKey const&) const", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey4MakeEyjNS0_15ContentMetaTypeE", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::Make(unsigned long long, unsigned int, nn::ncm::ContentMetaType)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey4MakeEyjNS0_15ContentMetaTypeENS0_18ContentInstallTypeE", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::Make(unsigned long long, unsigned int, nn::ncm::ContentMetaType, nn::ncm::ContentInstallType)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey15MakeUnknownTypeEyj", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::MakeUnknownType(unsigned long long, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm24GetContentMetaTypeStringENS0_15ContentMetaTypeE", new Tuple<string, List<string>>("nn::ncm::GetContentMetaTypeString(nn::ncm::ContentMetaType)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncmeqERKNS0_6DataIdES3_", new Tuple<string, List<string>>("nn::ncm::operator==(nn::ncm::DataId const&, nn::ncm::DataId const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncmneERKNS0_6DataIdES3_", new Tuple<string, List<string>>("nn::ncm::operator!=(nn::ncm::DataId const&, nn::ncm::DataId const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm9ProgramId12GetInvalidIdEv", new Tuple<string, List<string>>("nn::ncm::ProgramId::GetInvalidId()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncmeqERKNS0_9ProgramIdES3_", new Tuple<string, List<string>>("nn::ncm::operator==(nn::ncm::ProgramId const&, nn::ncm::ProgramId const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncmneERKNS0_9ProgramIdES3_", new Tuple<string, List<string>>("nn::ncm::operator!=(nn::ncm::ProgramId const&, nn::ncm::ProgramId const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm20IsInstallableStorageENS0_9StorageIdE", new Tuple<string, List<string>>("nn::ncm::IsInstallableStorage(nn::ncm::StorageId)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm15IsUniqueStorageENS0_9StorageIdE", new Tuple<string, List<string>>("nn::ncm::IsUniqueStorage(nn::ncm::StorageId)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm15SystemProgramId12GetInvalidIdEv", new Tuple<string, List<string>>("nn::ncm::SystemProgramId::GetInvalidId()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3ncm15SystemProgramIdcvNS0_9ProgramIdEEv", new Tuple<string, List<string>>("nn::ncm::SystemProgramId::operator nn::ncm::ProgramId() const", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3ncm12SystemDataIdcvNS0_6DataIdEEv", new Tuple<string, List<string>>("nn::ncm::SystemDataId::operator nn::ncm::DataId() const", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet34RequestToLaunchApplicationForQuestENS_3ncm13ApplicationIdENS0_13StorageHandleEPKNS0_28ApplicationAttributeForQuestE", new Tuple<string, List<string>>("nn::applet::RequestToLaunchApplicationForQuest(nn::ncm::ApplicationId, nn::applet::StorageHandle, nn::applet::ApplicationAttributeForQuest const*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet20AppletResourceUserId12GetInvalidIdEv", new Tuple<string, List<string>>("nn::applet::AppletResourceUserId::GetInvalidId()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appleteqERKNS0_20AppletResourceUserIdES3_", new Tuple<string, List<string>>("nn::applet::operator==(nn::applet::AppletResourceUserId const&, nn::applet::AppletResourceUserId const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appletneERKNS0_20AppletResourceUserIdES3_", new Tuple<string, List<string>>("nn::applet::operator!=(nn::applet::AppletResourceUserId const&, nn::applet::AppletResourceUserId const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet25CheckAppletResourceUserIdEmNS0_20AppletResourceUserIdE", new Tuple<string, List<string>>("nn::applet::CheckAppletResourceUserId(unsigned long, nn::applet::AppletResourceUserId)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet25CheckAppletResourceUserIdEyNS0_20AppletResourceUserIdE", new Tuple<string, List<string>>("nn::applet::CheckAppletResourceUserId(unsigned long long, nn::applet::AppletResourceUserId)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet35OverrideAutoSleepTimeAndDimmingTimeEiiii", new Tuple<string, List<string>>("nn::applet::OverrideAutoSleepTimeAndDimmingTime(int, int, int, int)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet21SetMediaPlaybackStateEb", new Tuple<string, List<string>>("nn::applet::SetMediaPlaybackState(bool)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet26SetInputDetectionSourceSetEj", new Tuple<string, List<string>>("nn::applet::SetInputDetectionSourceSet(unsigned int)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appleteqERKNS0_13StorageHandleES3_", new Tuple<string, List<string>>("nn::applet::operator==(nn::applet::StorageHandle const&, nn::applet::StorageHandle const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appletneERKNS0_13StorageHandleES3_", new Tuple<string, List<string>>("nn::applet::operator!=(nn::applet::StorageHandle const&, nn::applet::StorageHandle const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appletL20InvalidStorageHandleE", new Tuple<string, List<string>>("nn::applet::InvalidStorageHandle", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet13CreateStorageEPNS0_13StorageHandleEm", new Tuple<string, List<string>>("nn::applet::CreateStorage(nn::applet::StorageHandle*, unsigned long)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet18CreateLargeStorageEPNS0_13StorageHandleEPvmb", new Tuple<string, List<string>>("nn::applet::CreateLargeStorage(nn::applet::StorageHandle*, void*, unsigned long, bool)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet21CreateTransferStorageEPNS0_13StorageHandleEPvm", new Tuple<string, List<string>>("nn::applet::CreateTransferStorage(nn::applet::StorageHandle*, void*, unsigned long)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet14ReleaseStorageENS0_13StorageHandleE", new Tuple<string, List<string>>("nn::applet::ReleaseStorage(nn::applet::StorageHandle)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet14GetStorageSizeENS0_13StorageHandleE", new Tuple<string, List<string>>("nn::applet::GetStorageSize(nn::applet::StorageHandle)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet14WriteToStorageENS0_13StorageHandleElPKvm", new Tuple<string, List<string>>("nn::applet::WriteToStorage(nn::applet::StorageHandle, long, void const*, unsigned long)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet15ReadFromStorageENS0_13StorageHandleElPvm", new Tuple<string, List<string>>("nn::applet::ReadFromStorage(nn::applet::StorageHandle, long, void*, unsigned long)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet13CreateStorageEPNS0_13StorageHandleEj", new Tuple<string, List<string>>("nn::applet::CreateStorage(nn::applet::StorageHandle*, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet18CreateLargeStorageEPNS0_13StorageHandleEPvjb", new Tuple<string, List<string>>("nn::applet::CreateLargeStorage(nn::applet::StorageHandle*, void*, unsigned int, bool)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet21CreateTransferStorageEPNS0_13StorageHandleEPvj", new Tuple<string, List<string>>("nn::applet::CreateTransferStorage(nn::applet::StorageHandle*, void*, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet14WriteToStorageENS0_13StorageHandleExPKvj", new Tuple<string, List<string>>("nn::applet::WriteToStorage(nn::applet::StorageHandle, long long, void const*, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet15ReadFromStorageENS0_13StorageHandleExPvj", new Tuple<string, List<string>>("nn::applet::ReadFromStorage(nn::applet::StorageHandle, long long, void*, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appletL29LaunchableApplicationCountMaxE", new Tuple<string, List<string>>("nn::applet::LaunchableApplicationCountMax", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appletL30LaunchableSystemAppletCountMaxE", new Tuple<string, List<string>>("nn::applet::LaunchableSystemAppletCountMax", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appletL19StartupParamSizeMaxE", new Tuple<string, List<string>>("nn::applet::StartupParamSizeMax", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appletL18ReturnValueSizeMaxE", new Tuple<string, List<string>>("nn::applet::ReturnValueSizeMax", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appletL21RequestCommandSizeMaxE", new Tuple<string, List<string>>("nn::applet::RequestCommandSizeMax", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appletL19ReplyMessageSizeMaxE", new Tuple<string, List<string>>("nn::applet::ReplyMessageSizeMax", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn6applet18AppletIdentityInfo13IsApplicationEv", new Tuple<string, List<string>>("nn::applet::AppletIdentityInfo::IsApplication() const", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn6applet18AppletIdentityInfo19IsSystemApplicationEv", new Tuple<string, List<string>>("nn::applet::AppletIdentityInfo::IsSystemApplication() const", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet18AppletIdentityInfo4MakeENS0_8AppletIdE", new Tuple<string, List<string>>("nn::applet::AppletIdentityInfo::Make(nn::applet::AppletId)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet18AppletIdentityInfo4MakeENS_3ncm13ApplicationIdE", new Tuple<string, List<string>>("nn::applet::AppletIdentityInfo::Make(nn::ncm::ApplicationId)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet18AppletIdentityInfo4MakeENS_3ncm19SystemApplicationIdE", new Tuple<string, List<string>>("nn::applet::AppletIdentityInfo::Make(nn::ncm::SystemApplicationId)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3bpc22InitializeWakeupConfigEv", new Tuple<string, List<string>>("nn::bpc::InitializeWakeupConfig()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3bpc20FinalizeWakeupConfigEv", new Tuple<string, List<string>>("nn::bpc::FinalizeWakeupConfig()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3bpc17CreateWakeupTimerEPiNS_8TimeSpanENS0_15WakeupTimerTypeE", new Tuple<string, List<string>>("nn::bpc::CreateWakeupTimer(int*, nn::TimeSpan, nn::bpc::WakeupTimerType)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3bpc17CreateWakeupTimerEPiNS_8TimeSpanE", new Tuple<string, List<string>>("nn::bpc::CreateWakeupTimer(int*, nn::TimeSpan)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3bpc17CancelWakeupTimerEi", new Tuple<string, List<string>>("nn::bpc::CancelWakeupTimer(int)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3bpcL26MinWakeupIntervalInSecondsE", new Tuple<string, List<string>>("nn::bpc::MinWakeupIntervalInSeconds", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4diag36InitializeSystemProcessAbortObserverEv", new Tuple<string, List<string>>("nn::diag::InitializeSystemProcessAbortObserver()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npnsL14UsernameLengthE", new Tuple<string, List<string>>("nn::npns::UsernameLength", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npnsL14PasswordLengthE", new Tuple<string, List<string>>("nn::npns::PasswordLength", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npnsL16ApplicationIdRawE", new Tuple<string, List<string>>("nn::npns::ApplicationIdRaw", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns19InitializeForSystemEv", new Tuple<string, List<string>>("nn::npns::InitializeForSystem()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns17FinalizeForSystemEv", new Tuple<string, List<string>>("nn::npns::FinalizeForSystem()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns17ListenUndeliveredEv", new Tuple<string, List<string>>("nn::npns::ListenUndelivered()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns14SubscribeTopicEPKc", new Tuple<string, List<string>>("nn::npns::SubscribeTopic(char const*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns16UnsubscribeTopicEPKc", new Tuple<string, List<string>>("nn::npns::UnsubscribeTopic(char const*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns17QueryIsTopicExistEPbPKc", new Tuple<string, List<string>>("nn::npns::QueryIsTopicExist(bool*, char const*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns11CreateTokenEPNS0_17NotificationTokenERKNS_7account3UidENS_13ApplicationIdE", new Tuple<string, List<string>>("nn::npns::CreateToken(nn::npns::NotificationToken*, nn::account::Uid const&, nn::ApplicationId)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns12DestroyTokenERKNS_7account3UidENS_13ApplicationIdE", new Tuple<string, List<string>>("nn::npns::DestroyToken(nn::account::Uid const&, nn::ApplicationId)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns17UploadTokenToBaaSERKNS_7account3UidE", new Tuple<string, List<string>>("nn::npns::UploadTokenToBaaS(nn::account::Uid const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns19DestroyTokenForBaaSERKNS_7account3UidE", new Tuple<string, List<string>>("nn::npns::DestroyTokenForBaaS(nn::account::Uid const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns6GetJidEPcm", new Tuple<string, List<string>>("nn::npns::GetJid(char*, unsigned long)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns9CreateJidEv", new Tuple<string, List<string>>("nn::npns::CreateJid()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns10DestroyJidEv", new Tuple<string, List<string>>("nn::npns::DestroyJid()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns9AttachJidEPKcS2_", new Tuple<string, List<string>>("nn::npns::AttachJid(char const*, char const*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns9DetachJidEPcmS1_m", new Tuple<string, List<string>>("nn::npns::DetachJid(char*, unsigned long, char*, unsigned long)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns7SuspendEv", new Tuple<string, List<string>>("nn::npns::Suspend()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns6ResumeEv", new Tuple<string, List<string>>("nn::npns::Resume()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns13GetStatisticsEPNS0_20StatisticsCollectionINS0_20StatisticsDefinitionEEE", new Tuple<string, List<string>>("nn::npns::GetStatistics(nn::npns::StatisticsCollection<nn::npns::StatisticsDefinition>*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns26BindPlayReportRequestEventEPNS_2os15SystemEventTypeENS1_14EventClearModeE", new Tuple<string, List<string>>("nn::npns::BindPlayReportRequestEvent(nn::os::SystemEventType*, nn::os::EventClearMode)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns6GetJidEPcj", new Tuple<string, List<string>>("nn::npns::GetJid(char*, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns9DetachJidEPcjS1_j", new Tuple<string, List<string>>("nn::npns::DetachJid(char*, unsigned int, char*, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns20StatisticsDefinition4SizeE", new Tuple<string, List<string>>("nn::npns::StatisticsDefinition::Size", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns20StatisticsDefinition9GetStringENS0_14StatisticsKindE", new Tuple<string, List<string>>("nn::npns::StatisticsDefinition::GetString(nn::npns::StatisticsKind)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns20StatisticsCollectionC2ERKNS0_20StatisticsCollectionIT_EE", new Tuple<string, List<string>>("nn::npns::StatisticsCollection::StatisticsCollection", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns20StatisticsCollectionC1ERKNS0_20StatisticsCollectionIT_EE", new Tuple<string, List<string>>("nn::npns::StatisticsCollection::StatisticsCollection", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns20StatisticsCollectionC2EONS0_20StatisticsCollectionIT_EE", new Tuple<string, List<string>>("nn::npns::StatisticsCollection::StatisticsCollection", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns20StatisticsCollectionC1EONS0_20StatisticsCollectionIT_EE", new Tuple<string, List<string>>("nn::npns::StatisticsCollection::StatisticsCollection", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns20StatisticsCollectionC2Ev", new Tuple<string, List<string>>("nn::npns::StatisticsCollection::StatisticsCollection()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns20StatisticsCollectionC1Ev", new Tuple<string, List<string>>("nn::npns::StatisticsCollection::StatisticsCollection()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npnsL11TokenLengthE", new Tuple<string, List<string>>("nn::npns::TokenLength", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npnsL15TopicNameLengthE", new Tuple<string, List<string>>("nn::npns::TopicNameLength", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npnsL16PayloadMaxLengthE", new Tuple<string, List<string>>("nn::npns::PayloadMaxLength", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npnsL16ReceiverIdLengthE", new Tuple<string, List<string>>("nn::npns::ReceiverIdLength", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npnsL9JidLengthE", new Tuple<string, List<string>>("nn::npns::JidLength", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npnsL7VersionE", new Tuple<string, List<string>>("nn::npns::Version", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns10ReceiverId6CreateERKNS_7account3UidE", new Tuple<string, List<string>>("nn::npns::ReceiverId::Create(nn::account::Uid const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns10ReceiverId13CreateDefaultEv", new Tuple<string, List<string>>("nn::npns::ReceiverId::CreateDefault()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns16NotificationDataC2Ev", new Tuple<string, List<string>>("nn::npns::NotificationData::NotificationData()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns16NotificationDataC1Ev", new Tuple<string, List<string>>("nn::npns::NotificationData::NotificationData()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn4npns16NotificationData16GetApplicationIdEv", new Tuple<string, List<string>>("nn::npns::NotificationData::GetApplicationId() const", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn4npns16NotificationData13GetReceiverIdEv", new Tuple<string, List<string>>("nn::npns::NotificationData::GetReceiverId() const", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn4npns16NotificationData6GetUidEv", new Tuple<string, List<string>>("nn::npns::NotificationData::GetUid() const", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn4npns16NotificationData10GetPayloadEv", new Tuple<string, List<string>>("nn::npns::NotificationData::GetPayload() const", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn4npns16NotificationData14GetPayloadSizeEv", new Tuple<string, List<string>>("nn::npns::NotificationData::GetPayloadSize() const", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2ns10InitializeEv", new Tuple<string, List<string>>("nn::ns::Initialize()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2ns8FinalizeEv", new Tuple<string, List<string>>("nn::ns::Finalize()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2ns32GetApplicationDownloadTaskStatusEPNS0_29ApplicationDownloadTaskStatusENS_3ncm13ApplicationIdE", new Tuple<string, List<string>>("nn::ns::GetApplicationDownloadTaskStatus(nn::ns::ApplicationDownloadTaskStatus*, nn::ncm::ApplicationId)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2ns19DownloadApplicationENS_3ncm13ApplicationIdENS1_9StorageIdE", new Tuple<string, List<string>>("nn::ns::DownloadApplication(nn::ncm::ApplicationId, nn::ncm::StorageId)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2ns26RequestDownloadApplicationEPNS0_11AsyncResultENS_3ncm13ApplicationIdENS3_9StorageIdE", new Tuple<string, List<string>>("nn::ns::RequestDownloadApplication(nn::ns::AsyncResult*, nn::ncm::ApplicationId, nn::ncm::StorageId)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2ns27RequestDownloadAddOnContentEPNS0_11AsyncResultENS_3ncm13ApplicationIdEPNS3_14ContentMetaKeyEi", new Tuple<string, List<string>>("nn::ns::RequestDownloadAddOnContent(nn::ns::AsyncResult*, nn::ncm::ApplicationId, nn::ncm::ContentMetaKey*, int)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2ns30DeleteApplicationContentEntityERKNS_3ncm14ContentMetaKeyE", new Tuple<string, List<string>>("nn::ns::DeleteApplicationContentEntity(nn::ncm::ContentMetaKey const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2ns6detailL35PortNameForRetailInteractiveDisplayE", new Tuple<string, List<string>>("nn::ns::detail::PortNameForRetailInteractiveDisplay", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2ns17CreateUserAccountENS_7account8NicknameEPvm", new Tuple<string, List<string>>("nn::ns::CreateUserAccount(nn::account::Nickname, void*, unsigned long)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2ns17CreateUserAccountENS_7account8NicknameEPvj", new Tuple<string, List<string>>("nn::ns::CreateUserAccount(nn::account::Nickname, void*, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm10InitializeEv", new Tuple<string, List<string>>("nn::psm::Initialize()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm8FinalizeEv", new Tuple<string, List<string>>("nn::psm::Finalize()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm26GetBatteryChargePercentageEv", new Tuple<string, List<string>>("nn::psm::GetBatteryChargePercentage()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm14GetChargerTypeEv", new Tuple<string, List<string>>("nn::psm::GetChargerType()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm25GetChargerTypeChangeEventEPNS_2os15SystemEventTypeE", new Tuple<string, List<string>>("nn::psm::GetChargerTypeChangeEvent(nn::os::SystemEventType*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm28AcquireControllerPowerSupplyEv", new Tuple<string, List<string>>("nn::psm::AcquireControllerPowerSupply()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm28ReleaseControllerPowerSupplyEv", new Tuple<string, List<string>>("nn::psm::ReleaseControllerPowerSupply()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm11OpenSessionEPNS0_7SessionE", new Tuple<string, List<string>>("nn::psm::OpenSession(nn::psm::Session*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm12CloseSessionEPNS0_7SessionE", new Tuple<string, List<string>>("nn::psm::CloseSession(nn::psm::Session*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm20BindStateChangeEventEPNS_2os15SystemEventTypeEPNS0_7SessionE", new Tuple<string, List<string>>("nn::psm::BindStateChangeEvent(nn::os::SystemEventType*, nn::psm::Session*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm22UnbindStateChangeEventEPNS0_7SessionE", new Tuple<string, List<string>>("nn::psm::UnbindStateChangeEvent(nn::psm::Session*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm32SetChargerTypeChangeEventEnabledEPNS0_7SessionEb", new Tuple<string, List<string>>("nn::psm::SetChargerTypeChangeEventEnabled(nn::psm::Session*, bool)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm32SetPowerSupplyChangeEventEnabledEPNS0_7SessionEb", new Tuple<string, List<string>>("nn::psm::SetPowerSupplyChangeEventEnabled(nn::psm::Session*, bool)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm40SetBatteryVoltageStateChangeEventEnabledEPNS0_7SessionEb", new Tuple<string, List<string>>("nn::psm::SetBatteryVoltageStateChangeEventEnabled(nn::psm::Session*, bool)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm32EnableEnoughPowerChargeEmulationEv", new Tuple<string, List<string>>("nn::psm::EnableEnoughPowerChargeEmulation()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm33DisableEnoughPowerChargeEmulationEv", new Tuple<string, List<string>>("nn::psm::DisableEnoughPowerChargeEmulation()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm25EnableFastBatteryChargingEv", new Tuple<string, List<string>>("nn::psm::EnableFastBatteryCharging()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm26DisableFastBatteryChargingEv", new Tuple<string, List<string>>("nn::psm::DisableFastBatteryCharging()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm22GetBatteryVoltageStateEv", new Tuple<string, List<string>>("nn::psm::GetBatteryVoltageState()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm29GetRawBatteryChargePercentageEv", new Tuple<string, List<string>>("nn::psm::GetRawBatteryChargePercentage()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm21IsEnoughPowerSuppliedEv", new Tuple<string, List<string>>("nn::psm::IsEnoughPowerSupplied()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings7factory15GetSerialNumberEPNS1_12SerialNumberE", new Tuple<string, List<string>>("nn::settings::factory::GetSerialNumber(nn::settings::factory::SerialNumber*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system19IsAutoUpdateEnabledEv", new Tuple<string, List<string>>("nn::settings::system::IsAutoUpdateEnabled()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system20SetAutoUpdateEnabledEb", new Tuple<string, List<string>>("nn::settings::system::SetAutoUpdateEnabled(bool)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn8settings6system15FirmwareVersion20GetComparableVersionEv", new Tuple<string, List<string>>("nn::settings::system::FirmwareVersion::GetComparableVersion() const", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6systemeqERKNS1_15FirmwareVersionES4_", new Tuple<string, List<string>>("nn::settings::system::operator==(nn::settings::system::FirmwareVersion const&, nn::settings::system::FirmwareVersion const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6systemneERKNS1_15FirmwareVersionES4_", new Tuple<string, List<string>>("nn::settings::system::operator!=(nn::settings::system::FirmwareVersion const&, nn::settings::system::FirmwareVersion const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6systemltERKNS1_15FirmwareVersionES4_", new Tuple<string, List<string>>("nn::settings::system::operator<(nn::settings::system::FirmwareVersion const&, nn::settings::system::FirmwareVersion const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6systemgtERKNS1_15FirmwareVersionES4_", new Tuple<string, List<string>>("nn::settings::system::operator>(nn::settings::system::FirmwareVersion const&, nn::settings::system::FirmwareVersion const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6systemleERKNS1_15FirmwareVersionES4_", new Tuple<string, List<string>>("nn::settings::system::operator<=(nn::settings::system::FirmwareVersion const&, nn::settings::system::FirmwareVersion const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6systemgeERKNS1_15FirmwareVersionES4_", new Tuple<string, List<string>>("nn::settings::system::operator>=(nn::settings::system::FirmwareVersion const&, nn::settings::system::FirmwareVersion const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system18GetFirmwareVersionEPNS1_15FirmwareVersionE", new Tuple<string, List<string>>("nn::settings::system::GetFirmwareVersion(nn::settings::system::FirmwareVersion*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system13GetRegionCodeEPNS1_10RegionCodeE", new Tuple<string, List<string>>("nn::settings::system::GetRegionCode(nn::settings::system::RegionCode*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system13SetRegionCodeENS1_10RegionCodeE", new Tuple<string, List<string>>("nn::settings::system::SetRegionCode(nn::settings::system::RegionCode)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system16GetSleepSettingsEPNS1_13SleepSettingsE", new Tuple<string, List<string>>("nn::settings::system::GetSleepSettings(nn::settings::system::SleepSettings*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system16SetSleepSettingsERKNS1_13SleepSettingsE", new Tuple<string, List<string>>("nn::settings::system::SetSleepSettings(nn::settings::system::SleepSettings const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system17GetLockScreenFlagEv", new Tuple<string, List<string>>("nn::settings::system::GetLockScreenFlag()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system17SetLockScreenFlagEb", new Tuple<string, List<string>>("nn::settings::system::SetLockScreenFlag(bool)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system13GetColorSetIdEv", new Tuple<string, List<string>>("nn::settings::system::GetColorSetId()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system13SetColorSetIdEi", new Tuple<string, List<string>>("nn::settings::system::SetColorSetId(int)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system24GetBatteryPercentageFlagEv", new Tuple<string, List<string>>("nn::settings::system::GetBatteryPercentageFlag()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system24SetBatteryPercentageFlagEb", new Tuple<string, List<string>>("nn::settings::system::SetBatteryPercentageFlag(bool)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system24GetInitialLaunchSettingsEPNS1_21InitialLaunchSettingsE", new Tuple<string, List<string>>("nn::settings::system::GetInitialLaunchSettings(nn::settings::system::InitialLaunchSettings*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system24SetInitialLaunchSettingsERKNS1_21InitialLaunchSettingsE", new Tuple<string, List<string>>("nn::settings::system::SetInitialLaunchSettings(nn::settings::system::InitialLaunchSettings const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system17GetDeviceNickNameEPNS1_14DeviceNickNameE", new Tuple<string, List<string>>("nn::settings::system::GetDeviceNickName(nn::settings::system::DeviceNickName*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system17SetDeviceNickNameERKNS1_14DeviceNickNameE", new Tuple<string, List<string>>("nn::settings::system::SetDeviceNickName(nn::settings::system::DeviceNickName const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system12GetQuestFlagEv", new Tuple<string, List<string>>("nn::settings::system::GetQuestFlag()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system12SetQuestFlagEb", new Tuple<string, List<string>>("nn::settings::system::SetQuestFlag(bool)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system32GetWirelessCertificationFileSizeEv", new Tuple<string, List<string>>("nn::settings::system::GetWirelessCertificationFileSize()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system28GetWirelessCertificationFileEPvm", new Tuple<string, List<string>>("nn::settings::system::GetWirelessCertificationFile(void*, unsigned long)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system28GetWirelessCertificationFileEPvj", new Tuple<string, List<string>>("nn::settings::system::GetWirelessCertificationFile(void*, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system13GetTvSettingsEPNS1_10TvSettingsE", new Tuple<string, List<string>>("nn::settings::system::GetTvSettings(nn::settings::system::TvSettings*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system13SetTvSettingsERKNS1_10TvSettingsE", new Tuple<string, List<string>>("nn::settings::system::SetTvSettings(nn::settings::system::TvSettings const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system7GetEdidEPNS1_4EdidE", new Tuple<string, List<string>>("nn::settings::system::GetEdid(nn::settings::system::Edid*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system7SetEdidERKNS1_4EdidE", new Tuple<string, List<string>>("nn::settings::system::SetEdid(nn::settings::system::Edid const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time17InitializeForMenuEv", new Tuple<string, List<string>>("nn::time::InitializeForMenu()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time20LoadLocationNameListEPiPNS0_12LocationNameEii", new Tuple<string, List<string>>("nn::time::LoadLocationNameList(int*, nn::time::LocationName*, int, int)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time25GetTotalLocationNameCountEv", new Tuple<string, List<string>>("nn::time::GetTotalLocationNameCount()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time21SetDeviceLocationNameERKNS0_12LocationNameE", new Tuple<string, List<string>>("nn::time::SetDeviceLocationName(nn::time::LocationName const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time22GetTimeZoneRuleVersionEPNS0_19TimeZoneRuleVersionE", new Tuple<string, List<string>>("nn::time::GetTimeZoneRuleVersion(nn::time::TimeZoneRuleVersion*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time38SetStandardLocalSystemClockCurrentTimeERKNS0_9PosixTimeE", new Tuple<string, List<string>>("nn::time::SetStandardLocalSystemClockCurrentTime(nn::time::PosixTime const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time34SetStandardLocalSystemClockContextERKNS0_18SystemClockContextE", new Tuple<string, List<string>>("nn::time::SetStandardLocalSystemClockContext(nn::time::SystemClockContext const&)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time52SetStandardUserSystemClockAutomaticCorrectionEnabledEb", new Tuple<string, List<string>>("nn::time::SetStandardUserSystemClockAutomaticCorrectionEnabled(bool)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time51IsStandardUserSystemClockAutomaticCorrectionEnabledEv", new Tuple<string, List<string>>("nn::time::IsStandardUserSystemClockAutomaticCorrectionEnabled()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time19TimeZoneRuleVersion4SizeE", new Tuple<string, List<string>>("nn::time::TimeZoneRuleVersion::Size", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ridL20InvalidApplicationIdE", new Tuple<string, List<string>>("nn::rid::InvalidApplicationId", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid18ApplicationUpdaterC2Ev", new Tuple<string, List<string>>("nn::rid::ApplicationUpdater::ApplicationUpdater()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid18ApplicationUpdaterC1Ev", new Tuple<string, List<string>>("nn::rid::ApplicationUpdater::ApplicationUpdater()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid18ApplicationUpdaterD2Ev", new Tuple<string, List<string>>("nn::rid::ApplicationUpdater::~ApplicationUpdater()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid18ApplicationUpdaterD1Ev", new Tuple<string, List<string>>("nn::rid::ApplicationUpdater::~ApplicationUpdater()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid18ApplicationUpdater7ExecuteEPiPNS0_14DownloadResultEiPNS0_16ApplicationAssetEib", new Tuple<string, List<string>>("nn::rid::ApplicationUpdater::Execute(int*, nn::rid::DownloadResult*, int, nn::rid::ApplicationAsset*, int, bool)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid18ApplicationUpdater6CancelEv", new Tuple<string, List<string>>("nn::rid::ApplicationUpdater::Cancel()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid18ApplicationUpdater11GetProgressEv", new Tuple<string, List<string>>("nn::rid::ApplicationUpdater::GetProgress()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid18ApplicationUpdater16IsCommitRequiredEv", new Tuple<string, List<string>>("nn::rid::ApplicationUpdater::IsCommitRequired()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid18ApplicationUpdater11ExecuteImplEPiPNS0_14DownloadResultEiPNS0_16ApplicationAssetEib", new Tuple<string, List<string>>("nn::rid::ApplicationUpdater::ExecuteImpl(int*, nn::rid::DownloadResult*, int, nn::rid::ApplicationAsset*, int, bool)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid18ApplicationUpdater14UpdateProgressENS0_25ApplicationUpdateProgress5StateEll", new Tuple<string, List<string>>("nn::rid::ApplicationUpdater::UpdateProgress(nn::rid::ApplicationUpdateProgress::State, long, long)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid18ApplicationUpdater22MaxApplicationAocCountE", new Tuple<string, List<string>>("nn::rid::ApplicationUpdater::MaxApplicationAocCount", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid18ApplicationUpdater14UpdateProgressENS0_25ApplicationUpdateProgress5StateExx", new Tuple<string, List<string>>("nn::rid::ApplicationUpdater::UpdateProgress(nn::rid::ApplicationUpdateProgress::State, long long, long long)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid11CheckSdCardEv", new Tuple<string, List<string>>("nn::rid::CheckSdCard()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid10InitializeENS_3ncm13ApplicationIdE", new Tuple<string, List<string>>("nn::rid::Initialize(nn::ncm::ApplicationId)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid26RequestToLaunchApplicationENS_3ncm13ApplicationIdE", new Tuple<string, List<string>>("nn::rid::RequestToLaunchApplication(nn::ncm::ApplicationId)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid26RequestToLaunchApplicationENS_3ncm13ApplicationIdEPKNS_6applet28ApplicationAttributeForQuestE", new Tuple<string, List<string>>("nn::rid::RequestToLaunchApplication(nn::ncm::ApplicationId, nn::applet::ApplicationAttributeForQuest const*)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid34RequestToLaunchGameCardApplicationEv", new Tuple<string, List<string>>("nn::rid::RequestToLaunchGameCardApplication()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid15ListApplicationEPNS_3ncm13ApplicationIdEi", new Tuple<string, List<string>>("nn::rid::ListApplication(nn::ncm::ApplicationId*, int)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid11MenuUpdaterC2Ev", new Tuple<string, List<string>>("nn::rid::MenuUpdater::MenuUpdater()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid11MenuUpdaterC1Ev", new Tuple<string, List<string>>("nn::rid::MenuUpdater::MenuUpdater()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid11MenuUpdaterD2Ev", new Tuple<string, List<string>>("nn::rid::MenuUpdater::~MenuUpdater()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid11MenuUpdaterD1Ev", new Tuple<string, List<string>>("nn::rid::MenuUpdater::~MenuUpdater()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid11MenuUpdater7ExecuteEv", new Tuple<string, List<string>>("nn::rid::MenuUpdater::Execute()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid11MenuUpdater6CancelEv", new Tuple<string, List<string>>("nn::rid::MenuUpdater::Cancel()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid11MenuUpdater8GetStateEv", new Tuple<string, List<string>>("nn::rid::MenuUpdater::GetState()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid11MenuUpdater11ExecuteImplEv", new Tuple<string, List<string>>("nn::rid::MenuUpdater::ExecuteImpl()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid11MenuUpdater11UpdateStateENS0_15MenuUpdateStateE", new Tuple<string, List<string>>("nn::rid::MenuUpdater::UpdateState(nn::rid::MenuUpdateState)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid22CheckContentsIntegrityEv", new Tuple<string, List<string>>("nn::rid::CheckContentsIntegrity()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid12DeleteAllMiiEv", new Tuple<string, List<string>>("nn::rid::DeleteAllMii()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid15DeleteAllAlbumsEv", new Tuple<string, List<string>>("nn::rid::DeleteAllAlbums()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid6RebootEv", new Tuple<string, List<string>>("nn::rid::Reboot()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid35CheckRetailInteractiveDisplayDeviceEv", new Tuple<string, List<string>>("nn::rid::CheckRetailInteractiveDisplayDevice()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid14MinimumStartUpEv", new Tuple<string, List<string>>("nn::rid::MinimumStartUp()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid7StartUpEv", new Tuple<string, List<string>>("nn::rid::StartUp()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid13SystemUpdaterC2Ev", new Tuple<string, List<string>>("nn::rid::SystemUpdater::SystemUpdater()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid13SystemUpdaterC1Ev", new Tuple<string, List<string>>("nn::rid::SystemUpdater::SystemUpdater()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid13SystemUpdaterD2Ev", new Tuple<string, List<string>>("nn::rid::SystemUpdater::~SystemUpdater()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid13SystemUpdaterD1Ev", new Tuple<string, List<string>>("nn::rid::SystemUpdater::~SystemUpdater()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid13SystemUpdater7ExecuteEv", new Tuple<string, List<string>>("nn::rid::SystemUpdater::Execute()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid13SystemUpdater6CancelEv", new Tuple<string, List<string>>("nn::rid::SystemUpdater::Cancel()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid13SystemUpdater11GetProgressEv", new Tuple<string, List<string>>("nn::rid::SystemUpdater::GetProgress()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid13SystemUpdater11ExecuteImplEv", new Tuple<string, List<string>>("nn::rid::SystemUpdater::ExecuteImpl()", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid13SystemUpdater14UpdateProgressENS0_20SystemUpdateProgress5StateEll", new Tuple<string, List<string>>("nn::rid::SystemUpdater::UpdateProgress(nn::rid::SystemUpdateProgress::State, long, long)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid13SystemUpdater14UpdateProgressENS0_20SystemUpdateProgress5StateExx", new Tuple<string, List<string>>("nn::rid::SystemUpdater::UpdateProgress(nn::rid::SystemUpdateProgress::State, long long, long long)", new List<string>() { "3_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2ec28RequestPurchaseAuthorizationERKNS_7account10UserHandleEPKc", new Tuple<string, List<string>>("nn::ec::RequestPurchaseAuthorization(nn::account::UserHandle const&, char const*)", new List<string>() { "3_BundleDefinitions_NX_ShopApiPurchaseAuthorization" }) },
                        { "_ZN2nn3hid44IsUnintendedHomeButtonInputProtectionEnabledERKj", new Tuple<string, List<string>>("nn::hid::IsUnintendedHomeButtonInputProtectionEnabled(unsigned int const&)", new List<string>() { "3_BundleRules_NX_Private_UnintendedHomeButtonInputProtection_UnintendedHomeButtonInputProtection" }) },
                        { "_ZN2nn3hid41EnableUnintendedHomeButtonInputProtectionERKjb", new Tuple<string, List<string>>("nn::hid::EnableUnintendedHomeButtonInputProtection(unsigned int const&, bool)", new List<string>() { "3_BundleRules_NX_Private_UnintendedHomeButtonInputProtection_UnintendedHomeButtonInputProtection" }) },
                        { "_ZN2nn2osL21ThreadSuspendCountMaxE", new Tuple<string, List<string>>("nn::os::ThreadSuspendCountMax", new List<string>() { "3_BundleRules_Generic_Private_Unity_unity" }) },
                        { "_ZN2nn2os13SuspendThreadEPNS0_10ThreadTypeE", new Tuple<string, List<string>>("nn::os::SuspendThread(nn::os::ThreadType*)", new List<string>() { "3_BundleRules_Generic_Private_Unity_unity" }) },
                        { "_ZN2nn2os12ResumeThreadEPNS0_10ThreadTypeE", new Tuple<string, List<string>>("nn::os::ResumeThread(nn::os::ThreadType*)", new List<string>() { "3_BundleRules_Generic_Private_Unity_unity" }) },
                        { "_ZN2nn2os21GetThreadSuspendCountEPKNS0_10ThreadTypeE", new Tuple<string, List<string>>("nn::os::GetThreadSuspendCount(nn::os::ThreadType const*)", new List<string>() { "3_BundleRules_Generic_Private_Unity_unity" }) },
                        { "_ZN2nn2os16GetThreadContextEPNS0_24ThreadContextInfoAarch64EPKNS0_10ThreadTypeE", new Tuple<string, List<string>>("nn::os::GetThreadContext(nn::os::ThreadContextInfoAarch64*, nn::os::ThreadType const*)", new List<string>() { "3_BundleRules_Generic_Private_Unity_unity" }) },
                        { "_ZN2nn2oe25BeginMediaPlaybackSectionEv", new Tuple<string, List<string>>("nn::oe::BeginMediaPlaybackSection()", new List<string>() { "3_BundleDefinitions_NX_MediaPlaybackSectionApi" }) },
                        { "_ZN2nn2oe23EndMediaPlaybackSectionEv", new Tuple<string, List<string>>("nn::oe::EndMediaPlaybackSection()", new List<string>() { "3_BundleDefinitions_NX_MediaPlaybackSectionApi" }) },
                        { "_ZN2nn4nifm28GetCurrentAccessPointChannelEPt", new Tuple<string, List<string>>("nn::nifm::GetCurrentAccessPointChannel(unsigned short*)", new List<string>() { "3_BundleRules_Generic_Private_WirelessConnectionInfo_WirelessConnectionInfo" }) },
                        { "_ZN2nn2oeL34WorkBufferSizeForGamePlayRecordingE", new Tuple<string, List<string>>("nn::oe::WorkBufferSizeForGamePlayRecording", new List<string>() { "3_BundleRules_NX_Private_GameRecording_GameRecording" }) },
                        { "_ZN2nn2oe23EnableGamePlayRecordingEPvm", new Tuple<string, List<string>>("nn::oe::EnableGamePlayRecording(void*, unsigned long)", new List<string>() { "3_BundleRules_NX_Private_GameRecording_GameRecording" }) },
                        { "_ZN2nn2oe23EnableGamePlayRecordingEPvj", new Tuple<string, List<string>>("nn::oe::EnableGamePlayRecording(void*, unsigned int)", new List<string>() { "3_BundleRules_NX_Private_GameRecording_GameRecording" }) },
                    }
                },
                {
                    "4", // SDKのメジャーバージョン
                    new Dictionary<string, Tuple<string, List<string>>> // <マングル名,<デマングル名,マングル名に対応するtitleタグのリスト>>
                    {
                        { "_ZN2nn2oe18ReportUserIsActiveEv", new Tuple<string, List<string>>("nn::oe::ReportUserIsActive()", new List<string>() { "4_BundleDefinitions_NX_OeReportUserIsActive" }) },
                        { "_ZN2nn2oe23BeginBlockingHomeButtonEv", new Tuple<string, List<string>>("nn::oe::BeginBlockingHomeButton()", new List<string>() { "4_BundleRules_NX_Private_BlockingHomeButton_BlockingHomeButton" }) },
                        { "_ZN2nn2oe21EndBlockingHomeButtonEv", new Tuple<string, List<string>>("nn::oe::EndBlockingHomeButton()", new List<string>() { "4_BundleRules_NX_Private_BlockingHomeButton_BlockingHomeButton" }) },
                        { "_ZN2nn5audio17SetAudioInEnabledEb", new Tuple<string, List<string>>("nn::audio::SetAudioInEnabled(bool)", new List<string>() { "4_BundleDefinitions_NX_AudioIn" }) },
                        { "_ZN2nn5audio16IsAudioInEnabledEv", new Tuple<string, List<string>>("nn::audio::IsAudioInEnabled()", new List<string>() { "4_BundleDefinitions_NX_AudioIn" }) },
                        { "_ZN2nn2oeL54PerformanceConfiguration_Cpu1020MhzGpu460MhzEmc1331MhzE", new Tuple<string, List<string>>("nn::oe::PerformanceConfiguration_Cpu1020MhzGpu460MhzEmc1331Mhz", new List<string>() { "4_BundleRules_NX_Private_BatteryDrainingPerformance_BatteryDrainingPerformance" }) },
                        { "_ZN2nn5albumL25SharePostedLastUrlSizeMaxE", new Tuple<string, List<string>>("nn::album::SharePostedLastUrlSizeMax", new List<string>() { "4_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album21GetSharePostedLastUrlEPcmRKNS0_7ShareIdE", new Tuple<string, List<string>>("nn::album::GetSharePostedLastUrl(char*, unsigned long, nn::album::ShareId const&)", new List<string>() { "4_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album21GetSharePostedLastUrlEPcjRKNS0_7ShareIdE", new Tuple<string, List<string>>("nn::album::GetSharePostedLastUrl(char*, unsigned int, nn::album::ShareId const&)", new List<string>() { "4_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5albumL29SharePostedServiceNameSizeMaxE", new Tuple<string, List<string>>("nn::album::SharePostedServiceNameSizeMax", new List<string>() { "4_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5albumL25SharePostedEntryIdSizeMaxE", new Tuple<string, List<string>>("nn::album::SharePostedEntryIdSizeMax", new List<string>() { "4_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album25GetSharePostedServiceNameEPcmRKNS0_7ShareIdE", new Tuple<string, List<string>>("nn::album::GetSharePostedServiceName(char*, unsigned long, nn::album::ShareId const&)", new List<string>() { "4_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album21GetSharePostedEntryIdEPcmRKNS0_7ShareIdE", new Tuple<string, List<string>>("nn::album::GetSharePostedEntryId(char*, unsigned long, nn::album::ShareId const&)", new List<string>() { "4_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album25GetSharePostedServiceNameEPcjRKNS0_7ShareIdE", new Tuple<string, List<string>>("nn::album::GetSharePostedServiceName(char*, unsigned int, nn::album::ShareId const&)", new List<string>() { "4_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album21GetSharePostedEntryIdEPcjRKNS0_7ShareIdE", new Tuple<string, List<string>>("nn::album::GetSharePostedEntryId(char*, unsigned int, nn::album::ShareId const&)", new List<string>() { "4_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album22SaveAndShareScreenshotEPNS0_7ShareIdEPKvmNS0_9ImageSizeENS0_17AlbumReportOptionERKNS_7account3UidE", new Tuple<string, List<string>>("nn::album::SaveAndShareScreenshot(nn::album::ShareId*, void const*, unsigned long, nn::album::ImageSize, nn::album::AlbumReportOption, nn::account::Uid const&)", new List<string>() { "4_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album22SaveAndShareScreenshotEPNS0_7ShareIdEPKvmNS0_9ImageSizeENS0_16ImageOrientationENS0_17AlbumReportOptionERKNS_7account3UidE", new Tuple<string, List<string>>("nn::album::SaveAndShareScreenshot(nn::album::ShareId*, void const*, unsigned long, nn::album::ImageSize, nn::album::ImageOrientation, nn::album::AlbumReportOption, nn::account::Uid const&)", new List<string>() { "4_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album22SaveAndShareScreenshotEPNS0_7ShareIdEPKvmNS0_9ImageSizeENS0_17AlbumReportOptionERKNS_7account3UidEPKc", new Tuple<string, List<string>>("nn::album::SaveAndShareScreenshot(nn::album::ShareId*, void const*, unsigned long, nn::album::ImageSize, nn::album::AlbumReportOption, nn::account::Uid const&, char const*)", new List<string>() { "4_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album22SaveAndShareScreenshotEPNS0_7ShareIdEPKvmNS0_9ImageSizeENS0_16ImageOrientationENS0_17AlbumReportOptionERKNS_7account3UidEPKc", new Tuple<string, List<string>>("nn::album::SaveAndShareScreenshot(nn::album::ShareId*, void const*, unsigned long, nn::album::ImageSize, nn::album::ImageOrientation, nn::album::AlbumReportOption, nn::account::Uid const&, char const*)", new List<string>() { "4_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album22SaveAndShareScreenshotEPNS0_7ShareIdEPKvjNS0_9ImageSizeENS0_17AlbumReportOptionERKNS_7account3UidE", new Tuple<string, List<string>>("nn::album::SaveAndShareScreenshot(nn::album::ShareId*, void const*, unsigned int, nn::album::ImageSize, nn::album::AlbumReportOption, nn::account::Uid const&)", new List<string>() { "4_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album22SaveAndShareScreenshotEPNS0_7ShareIdEPKvjNS0_9ImageSizeENS0_16ImageOrientationENS0_17AlbumReportOptionERKNS_7account3UidE", new Tuple<string, List<string>>("nn::album::SaveAndShareScreenshot(nn::album::ShareId*, void const*, unsigned int, nn::album::ImageSize, nn::album::ImageOrientation, nn::album::AlbumReportOption, nn::account::Uid const&)", new List<string>() { "4_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album22SaveAndShareScreenshotEPNS0_7ShareIdEPKvjNS0_9ImageSizeENS0_17AlbumReportOptionERKNS_7account3UidEPKc", new Tuple<string, List<string>>("nn::album::SaveAndShareScreenshot(nn::album::ShareId*, void const*, unsigned int, nn::album::ImageSize, nn::album::AlbumReportOption, nn::account::Uid const&, char const*)", new List<string>() { "4_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album22SaveAndShareScreenshotEPNS0_7ShareIdEPKvjNS0_9ImageSizeENS0_16ImageOrientationENS0_17AlbumReportOptionERKNS_7account3UidEPKc", new Tuple<string, List<string>>("nn::album::SaveAndShareScreenshot(nn::album::ShareId*, void const*, unsigned int, nn::album::ImageSize, nn::album::ImageOrientation, nn::album::AlbumReportOption, nn::account::Uid const&, char const*)", new List<string>() { "4_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn3hid29IsUsbFullKeyControllerEnabledEv", new Tuple<string, List<string>>("nn::hid::IsUsbFullKeyControllerEnabled()", new List<string>() { "4_BundleRules_NX_Private_UsbFullKey_UsbFullKey" }) },
                        { "_ZN2nn3hid26EnableUsbFullKeyControllerEb", new Tuple<string, List<string>>("nn::hid::EnableUsbFullKeyController(bool)", new List<string>() { "4_BundleRules_NX_Private_UsbFullKey_UsbFullKey" }) },
                        { "_ZN2nn3hid31IsUsbFullKeyControllerConnectedERKj", new Tuple<string, List<string>>("nn::hid::IsUsbFullKeyControllerConnected(unsigned int const&)", new List<string>() { "4_BundleRules_NX_Private_UsbFullKey_UsbFullKey" }) },
                        { "_ZN2nn4util28GetCountryFromIso31661Alpha2EPNS0_7CountryEPKcm", new Tuple<string, List<string>>("nn::util::GetCountryFromIso31661Alpha2(nn::util::Country*, char const*, unsigned long)", new List<string>() { "4_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZN2nn4util28GetCountryFromIso31661Alpha2EPNS0_7CountryEPKcj", new Tuple<string, List<string>>("nn::util::GetCountryFromIso31661Alpha2(nn::util::Country*, char const*, unsigned int)", new List<string>() { "4_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZN2nn7account29LoadCachedNintendoAccountInfoEPNS0_25CachedNintendoAccountInfoERKNS0_10UserHandleEPvm", new Tuple<string, List<string>>("nn::account::LoadCachedNintendoAccountInfo(nn::account::CachedNintendoAccountInfo*, nn::account::UserHandle const&, void*, unsigned long)", new List<string>() { "4_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZN2nn7account25CachedNintendoAccountInfoC2Ev", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::CachedNintendoAccountInfo()", new List<string>() { "4_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZN2nn7account25CachedNintendoAccountInfoC1Ev", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::CachedNintendoAccountInfo()", new List<string>() { "4_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZNK2nn7account25CachedNintendoAccountInfo11GetBirthdayEPm", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::GetBirthday(unsigned long*) const", new List<string>() { "4_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZNK2nn7account25CachedNintendoAccountInfo9GetGenderEPm", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::GetGender(unsigned long*) const", new List<string>() { "4_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZNK2nn7account25CachedNintendoAccountInfo10GetCountryEPm", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::GetCountry(unsigned long*) const", new List<string>() { "4_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZN2nn7account29LoadCachedNintendoAccountInfoEPNS0_25CachedNintendoAccountInfoERKNS0_10UserHandleEPvj", new Tuple<string, List<string>>("nn::account::LoadCachedNintendoAccountInfo(nn::account::CachedNintendoAccountInfo*, nn::account::UserHandle const&, void*, unsigned int)", new List<string>() { "4_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZNK2nn7account25CachedNintendoAccountInfo11GetBirthdayEPj", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::GetBirthday(unsigned int*) const", new List<string>() { "4_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZNK2nn7account25CachedNintendoAccountInfo9GetGenderEPj", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::GetGender(unsigned int*) const", new List<string>() { "4_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZNK2nn7account25CachedNintendoAccountInfo10GetCountryEPj", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::GetCountry(unsigned int*) const", new List<string>() { "4_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZN2nn7accountL46RequiredBufferSizeForCachedNintendoAccountInfoE", new Tuple<string, List<string>>("nn::account::RequiredBufferSizeForCachedNintendoAccountInfo", new List<string>() { "4_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZN2nn3hid12GetNpadStateEPNS0_11NpadGcStateERKj", new Tuple<string, List<string>>("nn::hid::GetNpadState(nn::hid::NpadGcState*, unsigned int const&)", new List<string>() { "4_BundleRules_NX_Private_GcAdapter_gcadapter" }) },
                        { "_ZN2nn3hid13GetNpadStatesEPNS0_11NpadGcStateEiRKj", new Tuple<string, List<string>>("nn::hid::GetNpadStates(nn::hid::NpadGcState*, int, unsigned int const&)", new List<string>() { "4_BundleRules_NX_Private_GcAdapter_gcadapter" }) },
                        { "_ZN2nn3hidL25VibrationDeviceType_GcErmE", new Tuple<string, List<string>>("nn::hid::VibrationDeviceType_GcErm", new List<string>() { "4_BundleRules_NX_Private_GcAdapter_gcadapter" }) },
                        { "_ZN2nn3hid25SendVibrationGcErmCommandERKNS0_21VibrationDeviceHandleERKNS0_21VibrationGcErmCommandE", new Tuple<string, List<string>>("nn::hid::SendVibrationGcErmCommand(nn::hid::VibrationDeviceHandle const&, nn::hid::VibrationGcErmCommand const&)", new List<string>() { "4_BundleRules_NX_Private_GcAdapter_gcadapter" }) },
                        { "_ZN2nn3hid30GetActualVibrationGcErmCommandEPNS0_21VibrationGcErmCommandERKNS0_21VibrationDeviceHandleE", new Tuple<string, List<string>>("nn::hid::GetActualVibrationGcErmCommand(nn::hid::VibrationGcErmCommand*, nn::hid::VibrationDeviceHandle const&)", new List<string>() { "4_BundleRules_NX_Private_GcAdapter_gcadapter" }) },
                        { "_ZN2nn2fs19MountDeviceSaveDataEPKc", new Tuple<string, List<string>>("nn::fs::MountDeviceSaveData(char const*)", new List<string>() { "4_BundleRules_NX_Private_DeviceSaveData_DeviceSaveData" }) },
                        { "_ZN2nn7friends17SendFriendRequestEPNS0_12AsyncContextERKNS_7account3UidENS3_23NetworkServiceAccountIdERKNS0_15InAppScreenNameESA_", new Tuple<string, List<string>>("nn::friends::SendFriendRequest(nn::friends::AsyncContext*, nn::account::Uid const&, nn::account::NetworkServiceAccountId, nn::friends::InAppScreenName const&, nn::friends::InAppScreenName const&)", new List<string>() { "4_BundleRules_Generic_Private_FriendRequest_friend-request" }) },
                        { "_ZN2nn7friends36GetFacedFriendRequestRegistrationKeyEPNS0_33FacedFriendRequestRegistrationKeyERKNS_7account3UidE", new Tuple<string, List<string>>("nn::friends::GetFacedFriendRequestRegistrationKey(nn::friends::FacedFriendRequestRegistrationKey*, nn::account::Uid const&)", new List<string>() { "4_BundleRules_Generic_Private_FriendRequest_friend-request" }) },
                        { "_ZN2nn7friends21AddFacedFriendRequestERKNS_7account3UidERKNS0_33FacedFriendRequestRegistrationKeyERKNS1_8NicknameEPKvmRKNS0_15InAppScreenNameESF_", new Tuple<string, List<string>>("nn::friends::AddFacedFriendRequest(nn::account::Uid const&, nn::friends::FacedFriendRequestRegistrationKey const&, nn::account::Nickname const&, void const*, unsigned long, nn::friends::InAppScreenName const&, nn::friends::InAppScreenName const&)", new List<string>() { "4_BundleRules_Generic_Private_FriendRequest_friend-request" }) },
                        { "_ZN2nn7friends21AddFacedFriendRequestERKNS_7account3UidERKNS0_33FacedFriendRequestRegistrationKeyERKNS1_8NicknameEPKvjRKNS0_15InAppScreenNameESF_", new Tuple<string, List<string>>("nn::friends::AddFacedFriendRequest(nn::account::Uid const&, nn::friends::FacedFriendRequestRegistrationKey const&, nn::account::Nickname const&, void const*, unsigned int, nn::friends::InAppScreenName const&, nn::friends::InAppScreenName const&)", new List<string>() { "4_BundleRules_Generic_Private_FriendRequest_friend-request" }) },
                        { "_ZN2nn7account36CheckNetworkServiceAvailabilityAsyncEPNS0_12AsyncContextE", new Tuple<string, List<string>>("nn::account::CheckNetworkServiceAvailabilityAsync(nn::account::AsyncContext*)", new List<string>() { "4_BundleRules_Generic_Private_NetworkServiceForUnspecifiedUserAccount_network-service-for-unspecified-user-account" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardC2ERKS1_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::InlineKeyboard(nn::swkbd::InlineKeyboard const&)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardC1ERKS1_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::InlineKeyboard(nn::swkbd::InlineKeyboard const&)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardaSERKS1_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::operator=(nn::swkbd::InlineKeyboard const&)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardC2Ev", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::InlineKeyboard()", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardC1Ev", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::InlineKeyboard()", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardD2Ev", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::~InlineKeyboard()", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardD1Ev", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::~InlineKeyboard()", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard25GetRequiredWorkBufferSizeEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetRequiredWorkBufferSize()", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard10InitializeEPv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::Initialize(void*)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard8FinalizeEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::Finalize()", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard6LaunchEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::Launch()", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard9SetVolumeEf", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetVolume(float)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard6AppearERKNS0_9AppearArgE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::Appear(nn::swkbd::AppearArg const&)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard9DisappearEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::Disappear()", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard12SetInputTextERKNS0_9InputTextE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetInputText(nn::swkbd::InputText const&)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard12SetCursorPosEi", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetCursorPos(int)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard15SetUserWordInfoERKNS0_12UserWordInfoE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetUserWordInfo(nn::swkbd::UserWordInfo const&)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard17UnsetUserWordInfoEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::UnsetUserWordInfo()", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard11SetUtf8ModeEb", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetUtf8Mode(bool)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard15SetCustomizeDicEPKvmRKNS0_16CustomizeDicInfoE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetCustomizeDic(void const*, unsigned long, nn::swkbd::CustomizeDicInfo const&)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard17UnsetCustomizeDicEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::UnsetCustomizeDic()", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard14SetKeytopAlphaEf", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetKeytopAlpha(float)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard14SetFooterAlphaEf", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetFooterAlpha(float)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard14SetKeytopScaleEf", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetKeytopScale(float)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard18SetKeytopTranslateEff", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetKeytopTranslate(float, float)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard13SetWindowModeENS1_10WindowModeE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetWindowMode(nn::swkbd::InlineKeyboard::WindowMode)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard15SetTouchEnabledEb", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetTouchEnabled(bool)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard21SetUsbKeyboardEnabledEb", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetUsbKeyboardEnabled(bool)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZNK2nn5swkbd14InlineKeyboard18GetTouchRectanglesEPNS0_4RectES3_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetTouchRectangles(nn::swkbd::Rect*, nn::swkbd::Rect*) const", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard4CalcEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::Calc()", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard12GetMaxHeightEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetMaxHeight()", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard26IsUsedTouchPointByKeyboardEii", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::IsUsedTouchPointByKeyboard(int, int)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard29SetFinishedInitializeCallbackEPFvvE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetFinishedInitializeCallback(void (*)())", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard27SetFinishedKeyboardCallbackEPFvvE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetFinishedKeyboardCallback(void (*)())", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard24SetChangedStringCallbackEPFvPKNS0_16ChangedStringArgEE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetChangedStringCallback(void (*)(nn::swkbd::ChangedStringArg const*))", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard28SetChangedStringCallbackUtf8EPFvPKNS0_20ChangedStringArgUtf8EE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetChangedStringCallbackUtf8(void (*)(nn::swkbd::ChangedStringArgUtf8 const*))", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard22SetMovedCursorCallbackEPFvPKNS0_14MovedCursorArgEE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetMovedCursorCallback(void (*)(nn::swkbd::MovedCursorArg const*))", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard26SetMovedCursorCallbackUtf8EPFvPKNS0_18MovedCursorArgUtf8EE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetMovedCursorCallbackUtf8(void (*)(nn::swkbd::MovedCursorArgUtf8 const*))", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard23SetDecidedEnterCallbackEPFvPKNS0_15DecidedEnterArgEE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetDecidedEnterCallback(void (*)(nn::swkbd::DecidedEnterArg const*))", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard27SetDecidedEnterCallbackUtf8EPFvPKNS0_19DecidedEnterArgUtf8EE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetDecidedEnterCallbackUtf8(void (*)(nn::swkbd::DecidedEnterArgUtf8 const*))", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard24SetDecidedCancelCallbackEPFvvE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetDecidedCancelCallback(void (*)())", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard31SetReleasedUserWordInfoCallbackEPFvvE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetReleasedUserWordInfoCallback(void (*)())", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZNK2nn5swkbd14InlineKeyboard13GetWindowSizeEPiS2_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetWindowSize(int*, int*) const", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard25GetImageMemoryRequirementEPmS2_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetImageMemoryRequirement(unsigned long*, unsigned long*)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard8GetImageEPvm", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetImage(void*, unsigned long)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard15SetCustomizeDicEPKvjRKNS0_16CustomizeDicInfoE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetCustomizeDic(void const*, unsigned int, nn::swkbd::CustomizeDicInfo const&)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard25GetImageMemoryRequirementEPjS2_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetImageMemoryRequirement(unsigned int*, unsigned int*)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard8GetImageEPvj", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetImage(void*, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd9AppearArgC2Ev", new Tuple<string, List<string>>("nn::swkbd::AppearArg::AppearArg()", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd9AppearArgC1Ev", new Tuple<string, List<string>>("nn::swkbd::AppearArg::AppearArg()", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd9InputTextC2Ev", new Tuple<string, List<string>>("nn::swkbd::InputText::InputText()", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd9InputTextC1Ev", new Tuple<string, List<string>>("nn::swkbd::InputText::InputText()", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd9InputText3SetEPKDs", new Tuple<string, List<string>>("nn::swkbd::InputText::Set(char16_t const*)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd9InputText7SetUtf8EPKc", new Tuple<string, List<string>>("nn::swkbd::InputText::SetUtf8(char const*)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd16CustomizeDicInfoC2Ev", new Tuple<string, List<string>>("nn::swkbd::CustomizeDicInfo::CustomizeDicInfo()", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd16CustomizeDicInfoC1Ev", new Tuple<string, List<string>>("nn::swkbd::CustomizeDicInfo::CustomizeDicInfo()", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd12UserWordInfoC2Ev", new Tuple<string, List<string>>("nn::swkbd::UserWordInfo::UserWordInfo()", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd12UserWordInfoC1Ev", new Tuple<string, List<string>>("nn::swkbd::UserWordInfo::UserWordInfo()", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd12UserWordInfo25GetRequiredWorkBufferSizeEi", new Tuple<string, List<string>>("nn::swkbd::UserWordInfo::GetRequiredWorkBufferSize(int)", new List<string>() { "4_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn2oeL25MessageRequestToEndVrModeE", new Tuple<string, List<string>>("nn::oe::MessageRequestToEndVrMode", new List<string>() { "4_BundleRules_NX_Private_VrMode_vrmode" }) },
                        { "_ZN2nn2pl11BeginVrModeEv", new Tuple<string, List<string>>("nn::pl::BeginVrMode()", new List<string>() { "4_BundleRules_NX_Private_VrMode_vrmode" }) },
                        { "_ZN2nn2pl9EndVrModeEv", new Tuple<string, List<string>>("nn::pl::EndVrMode()", new List<string>() { "4_BundleRules_NX_Private_VrMode_vrmode" }) },
                        { "_ZN2nn2pl8IsVrModeEv", new Tuple<string, List<string>>("nn::pl::IsVrMode()", new List<string>() { "4_BundleRules_NX_Private_VrMode_vrmode" }) },
                        { "_ZN2nn2pl21GetCurrentIlluminanceEv", new Tuple<string, List<string>>("nn::pl::GetCurrentIlluminance()", new List<string>() { "4_BundleRules_NX_Private_Illuminance_illuminance" }) },
                        { "_ZN2nn2pl22IsIlluminanceAvailableEv", new Tuple<string, List<string>>("nn::pl::IsIlluminanceAvailable()", new List<string>() { "4_BundleRules_NX_Private_Illuminance_illuminance" }) },
                        { "_ZN2nn3lbl10InitializeEv", new Tuple<string, List<string>>("nn::lbl::Initialize()", new List<string>() { "4_BundleRules_NX_Private_LblSettingsForVrMode_LblSettingsForVrMode", "4_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl8FinalizeEv", new Tuple<string, List<string>>("nn::lbl::Finalize()", new List<string>() { "4_BundleRules_NX_Private_LblSettingsForVrMode_LblSettingsForVrMode", "4_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl36SetCurrentBrightnessSettingForVrModeEf", new Tuple<string, List<string>>("nn::lbl::SetCurrentBrightnessSettingForVrMode(float)", new List<string>() { "4_BundleRules_NX_Private_LblSettingsForVrMode_LblSettingsForVrMode", "4_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl36GetCurrentBrightnessSettingForVrModeEv", new Tuple<string, List<string>>("nn::lbl::GetCurrentBrightnessSettingForVrMode()", new List<string>() { "4_BundleRules_NX_Private_LblSettingsForVrMode_LblSettingsForVrMode", "4_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl18SaveCurrentSettingEv", new Tuple<string, List<string>>("nn::lbl::SaveCurrentSetting()", new List<string>() { "4_BundleRules_NX_Private_LblSettingsForVrMode_LblSettingsForVrMode", "4_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3hidL33ConsoleSixAxisSensorStateCountMaxE", new Tuple<string, List<string>>("nn::hid::ConsoleSixAxisSensorStateCountMax", new List<string>() { "4_BundleRules_NX_Private_ConsoleSixAxisSensor_consolesixaxissensor" }) },
                        { "_ZN2nn3hid30InitializeConsoleSixAxisSensorEv", new Tuple<string, List<string>>("nn::hid::InitializeConsoleSixAxisSensor()", new List<string>() { "4_BundleRules_NX_Private_ConsoleSixAxisSensor_consolesixaxissensor" }) },
                        { "_ZN2nn3hid22GetSixAxisSensorHandleEPNS0_26ConsoleSixAxisSensorHandleE", new Tuple<string, List<string>>("nn::hid::GetSixAxisSensorHandle(nn::hid::ConsoleSixAxisSensorHandle*)", new List<string>() { "4_BundleRules_NX_Private_ConsoleSixAxisSensor_consolesixaxissensor" }) },
                        { "_ZN2nn3hid18StartSixAxisSensorERKNS0_26ConsoleSixAxisSensorHandleE", new Tuple<string, List<string>>("nn::hid::StartSixAxisSensor(nn::hid::ConsoleSixAxisSensorHandle const&)", new List<string>() { "4_BundleRules_NX_Private_ConsoleSixAxisSensor_consolesixaxissensor" }) },
                        { "_ZN2nn3hid17StopSixAxisSensorERKNS0_26ConsoleSixAxisSensorHandleE", new Tuple<string, List<string>>("nn::hid::StopSixAxisSensor(nn::hid::ConsoleSixAxisSensorHandle const&)", new List<string>() { "4_BundleRules_NX_Private_ConsoleSixAxisSensor_consolesixaxissensor" }) },
                        { "_ZN2nn3hid3tmp34GetConsoleSixAxisSensorCountStatesEPNS1_23SixAxisSensorCountStateEiRKNS0_26ConsoleSixAxisSensorHandleE", new Tuple<string, List<string>>("nn::hid::tmp::GetConsoleSixAxisSensorCountStates(nn::hid::tmp::SixAxisSensorCountState*, int, nn::hid::ConsoleSixAxisSensorHandle const&)", new List<string>() { "4_BundleRules_NX_Private_ConsoleSixAxisSensor_consolesixaxissensor" }) },
                        { "_ZN2nn3hid3tmp40GetConsoleSixAxisSensorCalibrationValuesEPNS1_37ConsoleSixAxisSensorCalibrationValuesERKNS0_26ConsoleSixAxisSensorHandleE", new Tuple<string, List<string>>("nn::hid::tmp::GetConsoleSixAxisSensorCalibrationValues(nn::hid::tmp::ConsoleSixAxisSensorCalibrationValues*, nn::hid::ConsoleSixAxisSensorHandle const&)", new List<string>() { "4_BundleRules_NX_Private_ConsoleSixAxisSensor_consolesixaxissensor" }) },
                        { "_ZN2nn4pctl20IsRestrictionEnabledEv", new Tuple<string, List<string>>("nn::pctl::IsRestrictionEnabled()", new List<string>() { "4_BundleRules_NX_Private_StereoVisionRestrictionSettings_stereovision" }) },
                        { "_ZN2nn4pctl14GetSafetyLevelEv", new Tuple<string, List<string>>("nn::pctl::GetSafetyLevel()", new List<string>() { "4_BundleRules_NX_Private_StereoVisionRestrictionSettings_stereovision" }) },
                        { "_ZN2nn4pctl18GetCurrentSettingsEPNS0_19RestrictionSettingsE", new Tuple<string, List<string>>("nn::pctl::GetCurrentSettings(nn::pctl::RestrictionSettings*)", new List<string>() { "4_BundleRules_NX_Private_StereoVisionRestrictionSettings_stereovision" }) },
                        { "_ZN2nn4pctl29ConfirmStereoVisionPermissionEv", new Tuple<string, List<string>>("nn::pctl::ConfirmStereoVisionPermission()", new List<string>() { "4_BundleRules_NX_Private_StereoVisionRestrictionSettings_stereovision" }) },
                        { "_ZN2nn4pctl42ConfirmStereoVisionRestrictionConfigurableEv", new Tuple<string, List<string>>("nn::pctl::ConfirmStereoVisionRestrictionConfigurable()", new List<string>() { "4_BundleRules_NX_Private_StereoVisionRestrictionSettings_stereovision" }) },
                        { "_ZN2nn4pctl53RequestStereoVisionRestrictionConfigurationPermissionEv", new Tuple<string, List<string>>("nn::pctl::RequestStereoVisionRestrictionConfigurationPermission()", new List<string>() { "4_BundleRules_NX_Private_StereoVisionRestrictionSettings_stereovision" }) },
                        { "_ZN2nn4pctl26GetStereoVisionRestrictionEv", new Tuple<string, List<string>>("nn::pctl::GetStereoVisionRestriction()", new List<string>() { "4_BundleRules_NX_Private_StereoVisionRestrictionSettings_stereovision" }) },
                        { "_ZN2nn4pctl26SetStereoVisionRestrictionEb", new Tuple<string, List<string>>("nn::pctl::SetStereoVisionRestriction(bool)", new List<string>() { "4_BundleRules_NX_Private_StereoVisionRestrictionSettings_stereovision" }) },
                        { "_ZN2nn8irsensor30GetIrLedProcessorDefaultConfigEPNS0_20IrLedProcessorConfigE", new Tuple<string, List<string>>("nn::irsensor::GetIrLedProcessorDefaultConfig(nn::irsensor::IrLedProcessorConfig*)", new List<string>() { "4_BundleRules_NX_Private_IrSensorExtension_irsensorextension" }) },
                        { "_ZN2nn8irsensor17RunIrLedProcessorERKNS0_14IrCameraHandleERKNS0_20IrLedProcessorConfigE", new Tuple<string, List<string>>("nn::irsensor::RunIrLedProcessor(nn::irsensor::IrCameraHandle const&, nn::irsensor::IrLedProcessorConfig const&)", new List<string>() { "4_BundleRules_NX_Private_IrSensorExtension_irsensorextension" }) },
                        { "_ZN2nn8irsensor22GetIrLedProcessorStateERKNS0_14IrCameraHandleE", new Tuple<string, List<string>>("nn::irsensor::GetIrLedProcessorState(nn::irsensor::IrCameraHandle const&)", new List<string>() { "4_BundleRules_NX_Private_IrSensorExtension_irsensorextension" }) },
                        { "_ZN2nn2os20FlushEntireDataCacheEv", new Tuple<string, List<string>>("nn::os::FlushEntireDataCache()", new List<string>() { "4_BundleRules_NX_Private_FlushEntireDataCache_FlushEntireDataCache" }) },
                        { "_ZN2nn3err21IsNetworkServiceErrorENS0_9ErrorCodeE", new Tuple<string, List<string>>("nn::err::IsNetworkServiceError(nn::err::ErrorCode)", new List<string>() { "4_BundleRules_Generic_Private_NetworkServiceError_network-service-error" }) },
                        { "_ZN2nn3err23ShowNetworkServiceErrorENS0_9ErrorCodeERKNS_7account10UserHandleE", new Tuple<string, List<string>>("nn::err::ShowNetworkServiceError(nn::err::ErrorCode, nn::account::UserHandle const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkServiceError_network-service-error" }) },
                        { "_ZN2nn3err23ShowNetworkServiceErrorENS0_9ErrorCodeE", new Tuple<string, List<string>>("nn::err::ShowNetworkServiceError(nn::err::ErrorCode)", new List<string>() { "4_BundleRules_Generic_Private_NetworkServiceError_network-service-error" }) },
                        { "_ZN2nn5prepo10InitializeEv", new Tuple<string, List<string>>("nn::prepo::Initialize()", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo28RequestImmediateTransmissionEv", new Tuple<string, List<string>>("nn::prepo::RequestImmediateTransmission()", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo21GetTransmissionStatusEPNS0_18TransmissionStatusE", new Tuple<string, List<string>>("nn::prepo::GetTransmissionStatus(nn::prepo::TransmissionStatus*)", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportC2ERKS1_", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport(nn::prepo::PlayReport const&)", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportC1ERKS1_", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport(nn::prepo::PlayReport const&)", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportaSERKS1_", new Tuple<string, List<string>>("nn::prepo::PlayReport::operator=(nn::prepo::PlayReport const&)", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportC2EOS1_", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport(nn::prepo::PlayReport&&)", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportC1EOS1_", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport(nn::prepo::PlayReport&&)", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportaSEOS1_", new Tuple<string, List<string>>("nn::prepo::PlayReport::operator=(nn::prepo::PlayReport&&)", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport13BufferSizeMinE", new Tuple<string, List<string>>("nn::prepo::PlayReport::BufferSizeMin", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport13BufferSizeMaxE", new Tuple<string, List<string>>("nn::prepo::PlayReport::BufferSizeMax", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportC2Ev", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport()", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportC1Ev", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport()", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportC2EPKc", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport(char const*)", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportC1EPKc", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport(char const*)", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport9SetBufferEPvm", new Tuple<string, List<string>>("nn::prepo::PlayReport::SetBuffer(void*, unsigned long)", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport10SetEventIdEPKc", new Tuple<string, List<string>>("nn::prepo::PlayReport::SetEventId(char const*)", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport5ClearEv", new Tuple<string, List<string>>("nn::prepo::PlayReport::Clear()", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport3AddEPKcl", new Tuple<string, List<string>>("nn::prepo::PlayReport::Add(char const*, long)", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport3AddEPKcRKNS0_10Any64BitIdE", new Tuple<string, List<string>>("nn::prepo::PlayReport::Add(char const*, nn::prepo::Any64BitId const&)", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport3AddEPKcd", new Tuple<string, List<string>>("nn::prepo::PlayReport::Add(char const*, double)", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport3AddEPKcS3_", new Tuple<string, List<string>>("nn::prepo::PlayReport::Add(char const*, char const*)", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport4SaveEv", new Tuple<string, List<string>>("nn::prepo::PlayReport::Save()", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport4SaveERKNS_7account3UidE", new Tuple<string, List<string>>("nn::prepo::PlayReport::Save(nn::account::Uid const&)", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZNK2nn5prepo10PlayReport8GetCountEv", new Tuple<string, List<string>>("nn::prepo::PlayReport::GetCount() const", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport9SetBufferEPvj", new Tuple<string, List<string>>("nn::prepo::PlayReport::SetBuffer(void*, unsigned int)", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport3AddEPKcx", new Tuple<string, List<string>>("nn::prepo::PlayReport::Add(char const*, long long)", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepoL16KeyValueCountMaxE", new Tuple<string, List<string>>("nn::prepo::KeyValueCountMax", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepoL16EventIdLengthMaxE", new Tuple<string, List<string>>("nn::prepo::EventIdLengthMax", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepoL12KeyLengthMaxE", new Tuple<string, List<string>>("nn::prepo::KeyLengthMax", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepoL20StringValueLengthMaxE", new Tuple<string, List<string>>("nn::prepo::StringValueLengthMax", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepoL15KeyValueSizeMaxE", new Tuple<string, List<string>>("nn::prepo::KeyValueSizeMax", new List<string>() { "4_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC2ERKS1_", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(nn::os::SdkThreadLocalStorage const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC1ERKS1_", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(nn::os::SdkThreadLocalStorage const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageaSERKS1_", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::operator=(nn::os::SdkThreadLocalStorage const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC2EOS1_", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(nn::os::SdkThreadLocalStorage&&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC1EOS1_", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(nn::os::SdkThreadLocalStorage&&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageaSEOS1_", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::operator=(nn::os::SdkThreadLocalStorage&&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC2Ev", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC1Ev", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC2EPFvmE", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(void (*)(unsigned long))", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC1EPFvmE", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(void (*)(unsigned long))", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageD2Ev", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::~SdkThreadLocalStorage()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageD1Ev", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::~SdkThreadLocalStorage()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorage8SetValueEm", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SetValue(unsigned long)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZNK2nn2os21SdkThreadLocalStorage8GetValueEv", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::GetValue() const", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZNK2nn2os21SdkThreadLocalStorage10GetTlsSlotEv", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::GetTlsSlot() const", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC2EPFvjE", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(void (*)(unsigned int))", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC1EPFvjE", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(void (*)(unsigned int))", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorage8SetValueEj", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SetValue(unsigned int)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os18SdkAllocateTlsSlotEPNS0_7TlsSlotEPFvmE", new Tuple<string, List<string>>("nn::os::SdkAllocateTlsSlot(nn::os::TlsSlot*, void (*)(unsigned long))", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn2os18SdkAllocateTlsSlotEPNS0_7TlsSlotEPFvjE", new Tuple<string, List<string>>("nn::os::SdkAllocateTlsSlot(nn::os::TlsSlot*, void (*)(unsigned int))", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC2ERKS1_", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection(nn::nifm::NetworkConnection const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC1ERKS1_", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection(nn::nifm::NetworkConnection const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionaSERKS1_", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::operator=(nn::nifm::NetworkConnection const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC2EOS1_", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection(nn::nifm::NetworkConnection&&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC1EOS1_", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection(nn::nifm::NetworkConnection&&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionaSEOS1_", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::operator=(nn::nifm::NetworkConnection&&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC2Ev", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC1Ev", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC2ENS_2os14EventClearModeE", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection(nn::os::EventClearMode)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC1ENS_2os14EventClearModeE", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection(nn::os::EventClearMode)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionD2Ev", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::~NetworkConnection()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionD1Ev", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::~NetworkConnection()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection13SubmitRequestEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::SubmitRequest()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection20SubmitRequestAndWaitEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::SubmitRequestAndWait()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection13CancelRequestEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::CancelRequest()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection15IsRequestOnHoldEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::IsRequestOnHold()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection11IsAvailableEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::IsAvailable()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection14GetSystemEventEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::GetSystemEvent()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection26HandleNetworkRequestResultEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::HandleNetworkRequestResult()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection16GetRequestHandleEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::GetRequestHandle()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection9GetResultEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::GetResult()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection15GetRequestStateEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::GetRequestState()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC2ERKS1_", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::Request const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC1ERKS1_", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::Request const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestaSERKS1_", new Tuple<string, List<string>>("nn::nifm::Request::operator=(nn::nifm::Request const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC2EOS1_", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::Request&&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC1EOS1_", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::Request&&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestaSEOS1_", new Tuple<string, List<string>>("nn::nifm::Request::operator=(nn::nifm::Request&&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC2ERKNS0_17RequestParametersE", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::RequestParameters const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC1ERKNS0_17RequestParametersE", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::RequestParameters const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC2ERKNS0_17RequestParametersENS_2os14EventClearModeE", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::RequestParameters const&, nn::os::EventClearMode)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC1ERKNS0_17RequestParametersENS_2os14EventClearModeE", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::RequestParameters const&, nn::os::EventClearMode)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestD2Ev", new Tuple<string, List<string>>("nn::nifm::Request::~Request()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestD1Ev", new Tuple<string, List<string>>("nn::nifm::Request::~Request()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request6SubmitEv", new Tuple<string, List<string>>("nn::nifm::Request::Submit()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request13SubmitAndWaitEv", new Tuple<string, List<string>>("nn::nifm::Request::SubmitAndWait()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request6CancelEv", new Tuple<string, List<string>>("nn::nifm::Request::Cancel()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request15GetRequestStateEv", new Tuple<string, List<string>>("nn::nifm::Request::GetRequestState()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request9GetResultEv", new Tuple<string, List<string>>("nn::nifm::Request::GetResult()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request9GetHandleEv", new Tuple<string, List<string>>("nn::nifm::Request::GetHandle()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request14GetSystemEventEv", new Tuple<string, List<string>>("nn::nifm::Request::GetSystemEvent()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC2ERKS1_", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::TemporaryNetworkProfile const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC1ERKS1_", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::TemporaryNetworkProfile const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileaSERKS1_", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::operator=(nn::nifm::TemporaryNetworkProfile const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC2EOS1_", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::TemporaryNetworkProfile&&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC1EOS1_", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::TemporaryNetworkProfile&&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileaSEOS1_", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::operator=(nn::nifm::TemporaryNetworkProfile&&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC2ERKNS0_18NetworkProfileDataE", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::NetworkProfileData const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC1ERKNS0_18NetworkProfileDataE", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::NetworkProfileData const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileD2Ev", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::~TemporaryNetworkProfile()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileD1Ev", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::~TemporaryNetworkProfile()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZNK2nn4nifm23TemporaryNetworkProfile5GetIdEv", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::GetId() const", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfile6UpdateERKNS0_18NetworkProfileDataE", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::Update(nn::nifm::NetworkProfileData const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfile9GetHandleEv", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::GetHandle()", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm10MacAddress4SizeE", new Tuple<string, List<string>>("nn::nifm::MacAddress::Size", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_10MacAddressES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::MacAddress const&, nn::nifm::MacAddress const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_10MacAddressES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::MacAddress const&, nn::nifm::MacAddress const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmL24NetworkInterfaceCountMaxE", new Tuple<string, List<string>>("nn::nifm::NetworkInterfaceCountMax", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmL26UserNetworkProfileCountMaxE", new Tuple<string, List<string>>("nn::nifm::UserNetworkProfileCountMax", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmL30SsidListNetworkProfileCountMaxE", new Tuple<string, List<string>>("nn::nifm::SsidListNetworkProfileCountMax", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm23NetworkProfileBasicInfo8NameSizeE", new Tuple<string, List<string>>("nn::nifm::NetworkProfileBasicInfo::NameSize", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm15SsidListVersion4SizeE", new Tuple<string, List<string>>("nn::nifm::SsidListVersion::Size", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_18NetworkProfileDataES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::NetworkProfileData const&, nn::nifm::NetworkProfileData const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_18NetworkProfileDataES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::NetworkProfileData const&, nn::nifm::NetworkProfileData const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmL22UserRequestPriorityTopE", new Tuple<string, List<string>>("nn::nifm::UserRequestPriorityTop", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmL25UserRequestPriorityBottomE", new Tuple<string, List<string>>("nn::nifm::UserRequestPriorityBottom", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm4Ssid7HexSizeE", new Tuple<string, List<string>>("nn::nifm::Ssid::HexSize", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifm9SharedKey15KeyMaterialSizeE", new Tuple<string, List<string>>("nn::nifm::SharedKey::KeyMaterialSize", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmL26InvalidWirelessSettingDataE", new Tuple<string, List<string>>("nn::nifm::InvalidWirelessSettingData", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_4SsidES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::Ssid const&, nn::nifm::Ssid const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_4SsidES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::Ssid const&, nn::nifm::Ssid const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_14AuthEncryptionES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::AuthEncryption const&, nn::nifm::AuthEncryption const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_14AuthEncryptionES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::AuthEncryption const&, nn::nifm::AuthEncryption const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_9SharedKeyES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::SharedKey const&, nn::nifm::SharedKey const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_9SharedKeyES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::SharedKey const&, nn::nifm::SharedKey const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_10SsidConfigES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::SsidConfig const&, nn::nifm::SsidConfig const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_10SsidConfigES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::SsidConfig const&, nn::nifm::SsidConfig const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_8SecurityES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::Security const&, nn::nifm::Security const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_8SecurityES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::Security const&, nn::nifm::Security const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_19WirelessSettingDataES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::WirelessSettingData const&, nn::nifm::WirelessSettingData const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_19WirelessSettingDataES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::WirelessSettingData const&, nn::nifm::WirelessSettingData const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3nsd7ResolveEPNS0_4FqdnERKS1_", new Tuple<string, List<string>>("nn::nsd::Resolve(nn::nsd::Fqdn*, nn::nsd::Fqdn const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3nsd4Fqdn4SizeE", new Tuple<string, List<string>>("nn::nsd::Fqdn::Size", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3nsdeqERKNS0_4FqdnES3_", new Tuple<string, List<string>>("nn::nsd::operator==(nn::nsd::Fqdn const&, nn::nsd::Fqdn const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3nsdneERKNS0_4FqdnES3_", new Tuple<string, List<string>>("nn::nsd::operator!=(nn::nsd::Fqdn const&, nn::nsd::Fqdn const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3nsd11SettingName4SizeE", new Tuple<string, List<string>>("nn::nsd::SettingName::Size", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3nsd8PassCode4SizeE", new Tuple<string, List<string>>("nn::nsd::PassCode::Size", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3nsd21EnvironmentIdentifier4SizeE", new Tuple<string, List<string>>("nn::nsd::EnvironmentIdentifier::Size", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3nsdeqERKNS0_21EnvironmentIdentifierES3_", new Tuple<string, List<string>>("nn::nsd::operator==(nn::nsd::EnvironmentIdentifier const&, nn::nsd::EnvironmentIdentifier const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3nsdneERKNS0_21EnvironmentIdentifierES3_", new Tuple<string, List<string>>("nn::nsd::operator!=(nn::nsd::EnvironmentIdentifier const&, nn::nsd::EnvironmentIdentifier const&)", new List<string>() { "4_BundleRules_Generic_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn4diag13OnResultThrowENS_6ResultERKNS0_10SourceInfoE", new Tuple<string, List<string>>("nn::diag::OnResultThrow(nn::Result, nn::diag::SourceInfo const&)", new List<string>() { "4_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn4diag14OnResultHandleENS_6ResultERKNS0_10SourceInfoE", new Tuple<string, List<string>>("nn::diag::OnResultHandle(nn::Result, nn::diag::SourceInfo const&)", new List<string>() { "4_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn4diag15OnResultRethrowENS_6ResultERKNS0_10SourceInfoE", new Tuple<string, List<string>>("nn::diag::OnResultRethrow(nn::Result, nn::diag::SourceInfo const&)", new List<string>() { "4_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn4diag13OnResultCatchENS_6ResultERKNS0_10SourceInfoE", new Tuple<string, List<string>>("nn::diag::OnResultCatch(nn::Result, nn::diag::SourceInfo const&)", new List<string>() { "4_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn4diag12OnResultMissENS_6ResultERKNS0_10SourceInfoE", new Tuple<string, List<string>>("nn::diag::OnResultMiss(nn::Result, nn::diag::SourceInfo const&)", new List<string>() { "4_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail18ConvertInvalidImplENS_6ResultE", new Tuple<string, List<string>>("nn::result::detail::ConvertInvalidImpl(nn::Result)", new List<string>() { "4_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail19ResultAutoConverterC2ENS_6ResultE", new Tuple<string, List<string>>("nn::result::detail::ResultAutoConverter::ResultAutoConverter(nn::Result)", new List<string>() { "4_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail19ResultAutoConverterC1ENS_6ResultE", new Tuple<string, List<string>>("nn::result::detail::ResultAutoConverter::ResultAutoConverter(nn::Result)", new List<string>() { "4_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail23MakeResultAutoConverterENS_6ResultE", new Tuple<string, List<string>>("nn::result::detail::MakeResultAutoConverter(nn::Result)", new List<string>() { "4_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderC2ERKNS1_17ResultBlockHolderIT_T0_EE", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::ResultBlockHolder", new List<string>() { "4_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderC1ERKNS1_17ResultBlockHolderIT_T0_EE", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::ResultBlockHolder", new List<string>() { "4_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderC2EOT0_", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::ResultBlockHolder", new List<string>() { "4_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderC1EOT0_", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::ResultBlockHolder", new List<string>() { "4_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderC2EONS1_17ResultBlockHolderIT_T0_EE", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::ResultBlockHolder", new List<string>() { "4_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderC1EONS1_17ResultBlockHolderIT_T0_EE", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::ResultBlockHolder", new List<string>() { "4_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderD2Ev", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::~ResultBlockHolder()", new List<string>() { "4_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderD1Ev", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::~ResultBlockHolder()", new List<string>() { "4_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail14AbortForResult6HandleENS_6ResultE", new Tuple<string, List<string>>("nn::result::detail::AbortForResult::Handle(nn::Result)", new List<string>() { "4_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail15IgnoreForResult6HandleENS_6ResultE", new Tuple<string, List<string>>("nn::result::detail::IgnoreForResult::Handle(nn::Result)", new List<string>() { "4_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn3lbl27EnableAutoBrightnessControlEv", new Tuple<string, List<string>>("nn::lbl::EnableAutoBrightnessControl()", new List<string>() { "4_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl28DisableAutoBrightnessControlEv", new Tuple<string, List<string>>("nn::lbl::DisableAutoBrightnessControl()", new List<string>() { "4_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl30IsAutoBrightnessControlEnabledEv", new Tuple<string, List<string>>("nn::lbl::IsAutoBrightnessControlEnabled()", new List<string>() { "4_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl26SetAmbientLightSensorValueEf", new Tuple<string, List<string>>("nn::lbl::SetAmbientLightSensorValue(float)", new List<string>() { "4_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl26GetAmbientLightSensorValueEv", new Tuple<string, List<string>>("nn::lbl::GetAmbientLightSensorValue()", new List<string>() { "4_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl29IsAmbientLightSensorAvailableEv", new Tuple<string, List<string>>("nn::lbl::IsAmbientLightSensorAvailable()", new List<string>() { "4_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl33SetBrightnessReflectionDelayLevelENS0_25BrightnessChangeDirectionEf", new Tuple<string, List<string>>("nn::lbl::SetBrightnessReflectionDelayLevel(nn::lbl::BrightnessChangeDirection, float)", new List<string>() { "4_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl33GetBrightnessReflectionDelayLevelENS0_25BrightnessChangeDirectionE", new Tuple<string, List<string>>("nn::lbl::GetBrightnessReflectionDelayLevel(nn::lbl::BrightnessChangeDirection)", new List<string>() { "4_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl40ApplyCurrentBrightnessSettingToBacklightEv", new Tuple<string, List<string>>("nn::lbl::ApplyCurrentBrightnessSettingToBacklight()", new List<string>() { "4_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl38GetBrightnessSettingAppliedToBacklightEv", new Tuple<string, List<string>>("nn::lbl::GetBrightnessSettingAppliedToBacklight()", new List<string>() { "4_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl27SetCurrentBrightnessMappingERKNS0_18MappingCoefficientE", new Tuple<string, List<string>>("nn::lbl::SetCurrentBrightnessMapping(nn::lbl::MappingCoefficient const&)", new List<string>() { "4_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl27GetCurrentBrightnessMappingEPNS0_18MappingCoefficientE", new Tuple<string, List<string>>("nn::lbl::GetCurrentBrightnessMapping(nn::lbl::MappingCoefficient*)", new List<string>() { "4_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl35SetCurrentAmbientLightSensorMappingERKNS0_18MappingCoefficientE", new Tuple<string, List<string>>("nn::lbl::SetCurrentAmbientLightSensorMapping(nn::lbl::MappingCoefficient const&)", new List<string>() { "4_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl35GetCurrentAmbientLightSensorMappingEPNS0_18MappingCoefficientE", new Tuple<string, List<string>>("nn::lbl::GetCurrentAmbientLightSensorMapping(nn::lbl::MappingCoefficient*)", new List<string>() { "4_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl27SetCurrentBrightnessSettingEf", new Tuple<string, List<string>>("nn::lbl::SetCurrentBrightnessSetting(float)", new List<string>() { "4_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl27GetCurrentBrightnessSettingEv", new Tuple<string, List<string>>("nn::lbl::GetCurrentBrightnessSetting()", new List<string>() { "4_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl18LoadCurrentSettingEv", new Tuple<string, List<string>>("nn::lbl::LoadCurrentSetting()", new List<string>() { "4_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lblL18CoefficentCountMaxE", new Tuple<string, List<string>>("nn::lbl::CoefficentCountMax", new List<string>() { "4_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3cecL21RemoteControlVolumeUpE", new Tuple<string, List<string>>("nn::cec::RemoteControlVolumeUp", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cecL23RemoteControlVolumeDownE", new Tuple<string, List<string>>("nn::cec::RemoteControlVolumeDown", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cecL23RemoteControlVolumeMuteE", new Tuple<string, List<string>>("nn::cec::RemoteControlVolumeMute", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec10InitializeEPNS_2os15SystemEventTypeE", new Tuple<string, List<string>>("nn::cec::Initialize(nn::os::SystemEventType*)", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec8FinalizeEPNS_2os15SystemEventTypeE", new Tuple<string, List<string>>("nn::cec::Finalize(nn::os::SystemEventType*)", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec19PerformOneTouchPlayEv", new Tuple<string, List<string>>("nn::cec::PerformOneTouchPlay()", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec18PerformImageViewOnEv", new Tuple<string, List<string>>("nn::cec::PerformImageViewOn()", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec19PerformActiveSourceEv", new Tuple<string, List<string>>("nn::cec::PerformActiveSource()", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec20SetActiveSourceStateEv", new Tuple<string, List<string>>("nn::cec::SetActiveSourceState()", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec16PerformGoStandbyEb", new Tuple<string, List<string>>("nn::cec::PerformGoStandby(bool)", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec21PerformInactiveSourceEv", new Tuple<string, List<string>>("nn::cec::PerformInactiveSource()", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec31PerformSendRemoteControlCommandEbh", new Tuple<string, List<string>>("nn::cec::PerformSendRemoteControlCommand(bool, unsigned char)", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec33PerformSendDeviceMenuStateCommandEb", new Tuple<string, List<string>>("nn::cec::PerformSendDeviceMenuStateCommand(bool)", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec17SetOnScreenStringEPKc", new Tuple<string, List<string>>("nn::cec::SetOnScreenString(char const*)", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec13SetPowerStateENS0_10PowerStateE", new Tuple<string, List<string>>("nn::cec::SetPowerState(nn::cec::PowerState)", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec14SuspendManagerEv", new Tuple<string, List<string>>("nn::cec::SuspendManager()", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec14RestartManagerEv", new Tuple<string, List<string>>("nn::cec::RestartManager()", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec20CancelCurrentApiCallEPb", new Tuple<string, List<string>>("nn::cec::CancelCurrentApiCall(bool*)", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec9IsStartedEPb", new Tuple<string, List<string>>("nn::cec::IsStarted(bool*)", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec13GetPowerStateEPNS0_10PowerStateE", new Tuple<string, List<string>>("nn::cec::GetPowerState(nn::cec::PowerState*)", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec15GetTvPowerStateEPNS0_10PowerStateE", new Tuple<string, List<string>>("nn::cec::GetTvPowerState(nn::cec::PowerState*)", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec14IsTvResponsiveEPb", new Tuple<string, List<string>>("nn::cec::IsTvResponsive(bool*)", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec18GetConnectionStateEPNS0_15ConnectionStateE", new Tuple<string, List<string>>("nn::cec::GetConnectionState(nn::cec::ConnectionState*)", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec11GetHpdStateEPb", new Tuple<string, List<string>>("nn::cec::GetHpdState(bool*)", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec9IsEnabledEPb", new Tuple<string, List<string>>("nn::cec::IsEnabled(bool*)", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec14IsActiveSourceEPb", new Tuple<string, List<string>>("nn::cec::IsActiveSource(bool*)", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec15GetBusEventTypeEPNS0_12BusEventTypeE", new Tuple<string, List<string>>("nn::cec::GetBusEventType(nn::cec::BusEventType*)", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec20GetHdcpServiceObjectEPNS_2sf13SharedPointerINS_4hdcp6detail15IHdcpControllerEEE", new Tuple<string, List<string>>("nn::cec::GetHdcpServiceObject(nn::sf::SharedPointer<nn::hdcp::detail::IHdcpController>*)", new List<string>() { "4_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi17GetDisplayCmuModeEPNS0_7CmuModeEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayCmuMode(nn::vi::CmuMode*, nn::vi::Display const*)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi17SetDisplayCmuModeEPNS0_7DisplayENS0_7CmuModeE", new Tuple<string, List<string>>("nn::vi::SetDisplayCmuMode(nn::vi::Display*, nn::vi::CmuMode)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi23GetDisplayContrastRatioEPfPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayContrastRatio(float*, nn::vi::Display const*)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi23SetDisplayContrastRatioEPNS0_7DisplayEf", new Tuple<string, List<string>>("nn::vi::SetDisplayContrastRatio(nn::vi::Display*, float)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi15GetDisplayGammaEPfPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayGamma(float*, nn::vi::Display const*)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi15SetDisplayGammaEPNS0_7DisplayEf", new Tuple<string, List<string>>("nn::vi::SetDisplayGamma(nn::vi::Display*, float)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi17GetZOrderCountMinEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetZOrderCountMin(nn::vi::Display const*)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi17GetZOrderCountMaxEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetZOrderCountMax(nn::vi::Display const*)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi20GetDisplayResolutionEPiS1_PKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayResolution(int*, int*, nn::vi::Display const*)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi27GetDisplayLogicalResolutionEPiS1_PKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayLogicalResolution(int*, int*, nn::vi::Display const*)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi23SetDisplayMagnificationEPNS0_7DisplayEiiii", new Tuple<string, List<string>>("nn::vi::SetDisplayMagnification(nn::vi::Display*, int, int, int, int)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2viL19DisplayModeCountMaxE", new Tuple<string, List<string>>("nn::vi::DisplayModeCountMax", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi16ListDisplayModesEPNS0_15DisplayModeInfoEiPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::ListDisplayModes(nn::vi::DisplayModeInfo*, int, nn::vi::Display const*)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi20ListDisplayRgbRangesEPNS0_8RgbRangeEiPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::ListDisplayRgbRanges(nn::vi::RgbRange*, int, nn::vi::Display const*)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi23ListDisplayContentTypesEPNS0_11ContentTypeEiPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::ListDisplayContentTypes(nn::vi::ContentType*, int, nn::vi::Display const*)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi14GetDisplayModeEPNS0_15DisplayModeInfoEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayMode(nn::vi::DisplayModeInfo*, nn::vi::Display const*)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi14SetDisplayModeEPNS0_7DisplayEPKNS0_15DisplayModeInfoE", new Tuple<string, List<string>>("nn::vi::SetDisplayMode(nn::vi::Display*, nn::vi::DisplayModeInfo const*)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi19GetDisplayUnderscanEPiPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayUnderscan(int*, nn::vi::Display const*)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi19SetDisplayUnderscanEPNS0_7DisplayEi", new Tuple<string, List<string>>("nn::vi::SetDisplayUnderscan(nn::vi::Display*, int)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi21GetDisplayContentTypeEPNS0_11ContentTypeEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayContentType(nn::vi::ContentType*, nn::vi::Display const*)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi21SetDisplayContentTypeEPNS0_7DisplayENS0_11ContentTypeE", new Tuple<string, List<string>>("nn::vi::SetDisplayContentType(nn::vi::Display*, nn::vi::ContentType)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi18GetDisplayRgbRangeEPNS0_8RgbRangeEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayRgbRange(nn::vi::RgbRange*, nn::vi::Display const*)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi18SetDisplayRgbRangeEPNS0_7DisplayENS0_8RgbRangeE", new Tuple<string, List<string>>("nn::vi::SetDisplayRgbRange(nn::vi::Display*, nn::vi::RgbRange)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi11CreateLayerEPPNS0_5LayerEPNS0_7DisplayENS_4util10BitFlagSetILi32ENS0_10LayerFlagsEEE", new Tuple<string, List<string>>("nn::vi::CreateLayer(nn::vi::Layer**, nn::vi::Display*, nn::util::BitFlagSet<32, nn::vi::LayerFlags>)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi16SetLayerPositionEPNS0_5LayerEff", new Tuple<string, List<string>>("nn::vi::SetLayerPosition(nn::vi::Layer*, float, float)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi12SetLayerSizeEPNS0_5LayerEii", new Tuple<string, List<string>>("nn::vi::SetLayerSize(nn::vi::Layer*, int, int)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi9SetLayerZEPNS0_5LayerEi", new Tuple<string, List<string>>("nn::vi::SetLayerZ(nn::vi::Layer*, int)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi9GetLayerZEPiPKNS0_5LayerE", new Tuple<string, List<string>>("nn::vi::GetLayerZ(int*, nn::vi::Layer const*)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi13SetLayerAlphaEPNS0_5LayerEf", new Tuple<string, List<string>>("nn::vi::SetLayerAlpha(nn::vi::Layer*, float)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi24SetLayerSettingsDefaultsEPNS_4util10BitFlagSetILi32ENS0_10LayerFlagsEEE", new Tuple<string, List<string>>("nn::vi::SetLayerSettingsDefaults(nn::util::BitFlagSet<32, nn::vi::LayerFlags>*)", new List<string>() { "4_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN5movie13BrowserConfigC2Ev", new Tuple<string, List<string>>("movie::BrowserConfig::BrowserConfig()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserConfigC1Ev", new Tuple<string, List<string>>("movie::BrowserConfig::BrowserConfig()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer6CreateEPPS0_PNS_12PlayerConfigE", new Tuple<string, List<string>>("movie::BrowserPlayer::Create(movie::BrowserPlayer**, movie::PlayerConfig*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer6CreateEPPS0_PNS_12PlayerConfigEPNS_13BrowserConfigE", new Tuple<string, List<string>>("movie::BrowserPlayer::Create(movie::BrowserPlayer**, movie::PlayerConfig*, movie::BrowserConfig*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer7DestroyEPS0_", new Tuple<string, List<string>>("movie::BrowserPlayer::Destroy(movie::BrowserPlayer*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer11CanPlayTypeEPKcS2_", new Tuple<string, List<string>>("movie::BrowserPlayer::CanPlayType(char const*, char const*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer12SetCacheSizeENS0_9CacheSizeE", new Tuple<string, List<string>>("movie::BrowserPlayer::SetCacheSize(movie::BrowserPlayer::CacheSize)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer11IsCacheFullEPb", new Tuple<string, List<string>>("movie::BrowserPlayer::IsCacheFull(bool*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer16GetBufferedRangeEPfS1_", new Tuple<string, List<string>>("movie::BrowserPlayer::GetBufferedRange(float*, float*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer22GetSupportedTypesCountEv", new Tuple<string, List<string>>("movie::BrowserPlayer::GetSupportedTypesCount()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer16GetSupportedTypeEi", new Tuple<string, List<string>>("movie::BrowserPlayer::GetSupportedType(int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer12SetMSESourceEPKNS_9MSESourceE", new Tuple<string, List<string>>("movie::BrowserPlayer::SetMSESource(movie::MSESource const*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer12GetMSESourceEPPNS_9MSESourceE", new Tuple<string, List<string>>("movie::BrowserPlayer::GetMSESource(movie::MSESource**)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer11SetObserverEPNS_21BrowserPlayerObserverE", new Tuple<string, List<string>>("movie::BrowserPlayer::SetObserver(movie::BrowserPlayerObserver*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer11GetObserverEPPNS_21BrowserPlayerObserverE", new Tuple<string, List<string>>("movie::BrowserPlayer::GetObserver(movie::BrowserPlayerObserver**)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayerC2Ev", new Tuple<string, List<string>>("movie::BrowserPlayer::BrowserPlayer()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayerD2Ev", new Tuple<string, List<string>>("movie::BrowserPlayer::~BrowserPlayer()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayerD1Ev", new Tuple<string, List<string>>("movie::BrowserPlayer::~BrowserPlayer()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayerD0Ev", new Tuple<string, List<string>>("movie::BrowserPlayer::~BrowserPlayer()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie21BrowserPlayerObserver10OnCurlInitEPvPKc", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::OnCurlInit(void*, char const*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie21BrowserPlayerObserver13OnHttpRequestEPvPKc", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::OnHttpRequest(void*, char const*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie21BrowserPlayerObserver13OnMultiConfigEPvPKc", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::OnMultiConfig(void*, char const*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie21BrowserPlayerObserver14OnHttpResponseEPvPKc", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::OnHttpResponse(void*, char const*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie21BrowserPlayerObserverD2Ev", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::~BrowserPlayerObserver()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie21BrowserPlayerObserverD1Ev", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::~BrowserPlayerObserver()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie21BrowserPlayerObserverD0Ev", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::~BrowserPlayerObserver()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec6CreateEPPS0_PKcbbbb", new Tuple<string, List<string>>("movie::Codec::Create(movie::Codec**, char const*, bool, bool, bool, bool)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec7DestroyEPS0_", new Tuple<string, List<string>>("movie::Codec::Destroy(movie::Codec*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec9ConfigureEPNS_9MediaDataEPN2nn2vi5LayerEPv", new Tuple<string, List<string>>("movie::Codec::Configure(movie::MediaData*, nn::vi::Layer*, void*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec11SetCallbackEPNS_13CodecCallbackE", new Tuple<string, List<string>>("movie::Codec::SetCallback(movie::CodecCallback*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec13SetInputLayerEPN2nn2vi5LayerE", new Tuple<string, List<string>>("movie::Codec::SetInputLayer(nn::vi::Layer*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec5StartEv", new Tuple<string, List<string>>("movie::Codec::Start()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec4StopEv", new Tuple<string, List<string>>("movie::Codec::Stop()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec5ResetEv", new Tuple<string, List<string>>("movie::Codec::Reset()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec7ReleaseEv", new Tuple<string, List<string>>("movie::Codec::Release()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec5FlushEv", new Tuple<string, List<string>>("movie::Codec::Flush()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec14GetInputBufferEiPNS_6BufferE", new Tuple<string, List<string>>("movie::Codec::GetInputBuffer(int, movie::Buffer*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec16QueueInputBufferEiiilj", new Tuple<string, List<string>>("movie::Codec::QueueInputBuffer(int, int, int, long, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec15GetOutputBufferEiPNS_6BufferE", new Tuple<string, List<string>>("movie::Codec::GetOutputBuffer(int, movie::Buffer*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec19ReleaseOutputBufferEi", new Tuple<string, List<string>>("movie::Codec::ReleaseOutputBuffer(int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec28RenderOutputBufferAndReleaseEi", new Tuple<string, List<string>>("movie::Codec::RenderOutputBufferAndRelease(int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec28RenderOutputBufferAndReleaseEil", new Tuple<string, List<string>>("movie::Codec::RenderOutputBufferAndRelease(int, long)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec22SignalEndOfInputStreamEv", new Tuple<string, List<string>>("movie::Codec::SignalEndOfInputStream()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZNK5movie5Codec15GetOutputFormatEPNS_9MediaDataE", new Tuple<string, List<string>>("movie::Codec::GetOutputFormat(movie::MediaData*) const", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZNK5movie5Codec14GetInputFormatEPNS_9MediaDataE", new Tuple<string, List<string>>("movie::Codec::GetInputFormat(movie::MediaData*) const", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec15GetOutputFormatEiPNS_9MediaDataE", new Tuple<string, List<string>>("movie::Codec::GetOutputFormat(int, movie::MediaData*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZNK5movie5Codec7GetNameEPcPi", new Tuple<string, List<string>>("movie::Codec::GetName(char*, int*) const", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec26CopyOutputBufferAndReleaseEii", new Tuple<string, List<string>>("movie::Codec::CopyOutputBufferAndRelease(int, int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec9GetStrideEPiS1_S1_", new Tuple<string, List<string>>("movie::Codec::GetStride(int*, int*, int*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec15SetShadowBufferEPvi", new Tuple<string, List<string>>("movie::Codec::SetShadowBuffer(void*, int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec21SetShadowBuffersParamEii", new Tuple<string, List<string>>("movie::Codec::SetShadowBuffersParam(int, int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5CodecC2Ev", new Tuple<string, List<string>>("movie::Codec::Codec()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5CodecD2Ev", new Tuple<string, List<string>>("movie::Codec::~Codec()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5CodecD1Ev", new Tuple<string, List<string>>("movie::Codec::~Codec()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5CodecD0Ev", new Tuple<string, List<string>>("movie::Codec::~Codec()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13CodecCallback7OnErrorEPNS_5CodecENS_6StatusE", new Tuple<string, List<string>>("movie::CodecCallback::OnError(movie::Codec*, movie::Status)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13CodecCallback22OnInputBufferAvailableEPNS_5CodecEi", new Tuple<string, List<string>>("movie::CodecCallback::OnInputBufferAvailable(movie::Codec*, int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13CodecCallback23OnOutputBufferAvailableEPNS_5CodecEilj", new Tuple<string, List<string>>("movie::CodecCallback::OnOutputBufferAvailable(movie::Codec*, int, long, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13CodecCallback21OnOutputFormatChangedEPNS_5CodecEPNS_9MediaDataE", new Tuple<string, List<string>>("movie::CodecCallback::OnOutputFormatChanged(movie::Codec*, movie::MediaData*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13CodecCallbackD2Ev", new Tuple<string, List<string>>("movie::CodecCallback::~CodecCallback()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13CodecCallbackD1Ev", new Tuple<string, List<string>>("movie::CodecCallback::~CodecCallback()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13CodecCallbackD0Ev", new Tuple<string, List<string>>("movie::CodecCallback::~CodecCallback()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec16QueueInputBufferEiiixj", new Tuple<string, List<string>>("movie::Codec::QueueInputBuffer(int, int, int, long long, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec28RenderOutputBufferAndReleaseEix", new Tuple<string, List<string>>("movie::Codec::RenderOutputBufferAndRelease(int, long long)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13CodecCallback23OnOutputBufferAvailableEPNS_5CodecEixj", new Tuple<string, List<string>>("movie::CodecCallback::OnOutputBufferAvailable(movie::Codec*, int, long long, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie10DataSourceC2Ev", new Tuple<string, List<string>>("movie::DataSource::DataSource()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie10DataSourceD2Ev", new Tuple<string, List<string>>("movie::DataSource::~DataSource()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie10DataSourceD1Ev", new Tuple<string, List<string>>("movie::DataSource::~DataSource()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie10DataSourceD0Ev", new Tuple<string, List<string>>("movie::DataSource::~DataSource()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie10DataSource9initCheckEv", new Tuple<string, List<string>>("movie::DataSource::initCheck()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie10DataSource6readAtElPvm", new Tuple<string, List<string>>("movie::DataSource::readAt(long, void*, unsigned long)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie10DataSource7getSizeEv", new Tuple<string, List<string>>("movie::DataSource::getSize()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie10DataSource6readAtExPvj", new Tuple<string, List<string>>("movie::DataSource::readAt(long long, void*, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie9MSESourceC2Ev", new Tuple<string, List<string>>("movie::MSESource::MSESource()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie9MSESourceD2Ev", new Tuple<string, List<string>>("movie::MSESource::~MSESource()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie9MSESourceD1Ev", new Tuple<string, List<string>>("movie::MSESource::~MSESource()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie9MSESourceD0Ev", new Tuple<string, List<string>>("movie::MSESource::~MSESource()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie9MSESource15AddSourceBufferEPNS_10DataSourceE", new Tuple<string, List<string>>("movie::MSESource::AddSourceBuffer(movie::DataSource*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie9MSESource20GetSourceBufferCountEv", new Tuple<string, List<string>>("movie::MSESource::GetSourceBufferCount()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie9MSESource15GetSourceBufferEm", new Tuple<string, List<string>>("movie::MSESource::GetSourceBuffer(unsigned long)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie9MSESource18RemoveSourceBufferEm", new Tuple<string, List<string>>("movie::MSESource::RemoveSourceBuffer(unsigned long)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie9MSESource15GetSourceBufferEj", new Tuple<string, List<string>>("movie::MSESource::GetSourceBuffer(unsigned int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie9MSESource18RemoveSourceBufferEj", new Tuple<string, List<string>>("movie::MSESource::RemoveSourceBuffer(unsigned int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Muxer6CreateEPPS0_PKcNS_17MuxerOutputFormatE", new Tuple<string, List<string>>("movie::Muxer::Create(movie::Muxer**, char const*, movie::MuxerOutputFormat)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Muxer7DestroyEPS0_", new Tuple<string, List<string>>("movie::Muxer::Destroy(movie::Muxer*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Muxer8AddTrackEPiNS_11TrackFormatE", new Tuple<string, List<string>>("movie::Muxer::AddTrack(int*, movie::TrackFormat)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Muxer5StartEv", new Tuple<string, List<string>>("movie::Muxer::Start()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Muxer11SetLocationEii", new Tuple<string, List<string>>("movie::Muxer::SetLocation(int, int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Muxer4StopEv", new Tuple<string, List<string>>("movie::Muxer::Stop()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Muxer15WriteSampleDataERKNS_6BufferEilj", new Tuple<string, List<string>>("movie::Muxer::WriteSampleData(movie::Buffer const&, int, long, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5MuxerC2Ev", new Tuple<string, List<string>>("movie::Muxer::Muxer()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5MuxerD2Ev", new Tuple<string, List<string>>("movie::Muxer::~Muxer()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5MuxerD1Ev", new Tuple<string, List<string>>("movie::Muxer::~Muxer()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5MuxerD0Ev", new Tuple<string, List<string>>("movie::Muxer::~Muxer()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Muxer15WriteSampleDataERKNS_6BufferEixj", new Tuple<string, List<string>>("movie::Muxer::WriteSampleData(movie::Buffer const&, int, long long, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie12PlayerConfigC2Ev", new Tuple<string, List<string>>("movie::PlayerConfig::PlayerConfig()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie12PlayerConfigC1Ev", new Tuple<string, List<string>>("movie::PlayerConfig::PlayerConfig()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player6CreateEPPS0_PNS_12PlayerConfigE", new Tuple<string, List<string>>("movie::Player::Create(movie::Player**, movie::PlayerConfig*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player7DestroyEPS0_", new Tuple<string, List<string>>("movie::Player::Destroy(movie::Player*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player11SetObserverEPNS_14PlayerObserverE", new Tuple<string, List<string>>("movie::Player::SetObserver(movie::PlayerObserver*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player11GetObserverEPPNS_14PlayerObserverE", new Tuple<string, List<string>>("movie::Player::GetObserver(movie::PlayerObserver**)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player13SetDataSourceEPKc", new Tuple<string, List<string>>("movie::Player::SetDataSource(char const*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player19CancelSetDataSourceEv", new Tuple<string, List<string>>("movie::Player::CancelSetDataSource()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player9GetVolumeEPf", new Tuple<string, List<string>>("movie::Player::GetVolume(float*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player9SetVolumeEf", new Tuple<string, List<string>>("movie::Player::SetVolume(float)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player7PrepareEv", new Tuple<string, List<string>>("movie::Player::Prepare()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player5StartEv", new Tuple<string, List<string>>("movie::Player::Start()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player4StopEv", new Tuple<string, List<string>>("movie::Player::Stop()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player5PauseEb", new Tuple<string, List<string>>("movie::Player::Pause(bool)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player6SeekToEl", new Tuple<string, List<string>>("movie::Player::SeekTo(long)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player26GetCurrentPlaybackPositionEPl", new Tuple<string, List<string>>("movie::Player::GetCurrentPlaybackPosition(long*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player19GetPlaybackDurationEPl", new Tuple<string, List<string>>("movie::Player::GetPlaybackDuration(long*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player13GetTrackCountEPi", new Tuple<string, List<string>>("movie::Player::GetTrackCount(int*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player11SelectTrackEi", new Tuple<string, List<string>>("movie::Player::SelectTrack(int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player13DeSelectTrackEi", new Tuple<string, List<string>>("movie::Player::DeSelectTrack(int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player12GetTrackTypeEiPNS_9TrackTypeE", new Tuple<string, List<string>>("movie::Player::GetTrackType(int, movie::TrackType*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player18GetVideoDimensionsEPiS1_", new Tuple<string, List<string>>("movie::Player::GetVideoDimensions(int*, int*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player5ResetEv", new Tuple<string, List<string>>("movie::Player::Reset()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player10SetLoopingEb", new Tuple<string, List<string>>("movie::Player::SetLooping(bool)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player10GetLoopingEPb", new Tuple<string, List<string>>("movie::Player::GetLooping(bool*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player15GetPlaybackRateEv", new Tuple<string, List<string>>("movie::Player::GetPlaybackRate()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player15SetPlaybackRateEf", new Tuple<string, List<string>>("movie::Player::SetPlaybackRate(float)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player8GetStateEPNS_11PlayerStateE", new Tuple<string, List<string>>("movie::Player::GetState(movie::PlayerState*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player12GetTrackInfoEiPNS_9TrackInfoE", new Tuple<string, List<string>>("movie::Player::GetTrackInfo(int, movie::TrackInfo*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player24AcquireOutputBufferIndexEiPiPlS1_", new Tuple<string, List<string>>("movie::Player::AcquireOutputBufferIndex(int, int*, long*, int*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player19GetOutputBufferSizeEiPi", new Tuple<string, List<string>>("movie::Player::GetOutputBufferSize(int, int*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player16FillOutputBufferEiiPNS_6BufferEPlPj", new Tuple<string, List<string>>("movie::Player::FillOutputBuffer(int, int, movie::Buffer*, long*, unsigned int*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player24ReleaseOutputBufferIndexEii", new Tuple<string, List<string>>("movie::Player::ReleaseOutputBufferIndex(int, int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player24SetOutputBufferAlignmentEPNS_9MediaDataE", new Tuple<string, List<string>>("movie::Player::SetOutputBufferAlignment(movie::MediaData*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player6SeekToElPl", new Tuple<string, List<string>>("movie::Player::SeekTo(long, long*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player25GetOutputBufferPropertiesEPNS_9MediaDataE", new Tuple<string, List<string>>("movie::Player::GetOutputBufferProperties(movie::MediaData*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player25GetOutputBufferPropertiesEiPNS_9MediaDataE", new Tuple<string, List<string>>("movie::Player::GetOutputBufferProperties(int, movie::MediaData*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player26TerminateNetworkConnectionEv", new Tuple<string, List<string>>("movie::Player::TerminateNetworkConnection()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player20RegisterOutputBufferEPNS_6BufferEPi", new Tuple<string, List<string>>("movie::Player::RegisterOutputBuffer(movie::Buffer*, int*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6PlayerC2Ev", new Tuple<string, List<string>>("movie::Player::Player()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6PlayerD2Ev", new Tuple<string, List<string>>("movie::Player::~Player()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6PlayerD1Ev", new Tuple<string, List<string>>("movie::Player::~Player()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6PlayerD0Ev", new Tuple<string, List<string>>("movie::Player::~Player()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserver7OnErrorENS_6StatusE", new Tuple<string, List<string>>("movie::PlayerObserver::OnError(movie::Status)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserver13OnStateChangeENS_11PlayerStateE", new Tuple<string, List<string>>("movie::PlayerObserver::OnStateChange(movie::PlayerState)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserver17OnBufferingUpdateEff", new Tuple<string, List<string>>("movie::PlayerObserver::OnBufferingUpdate(float, float)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserver27OnAudioOutputFrameAvailableEPNS_14AudioFrameInfoE", new Tuple<string, List<string>>("movie::PlayerObserver::OnAudioOutputFrameAvailable(movie::AudioFrameInfo*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserver27OnVideoOutputFrameAvailableEPNS_14VideoFrameInfoE", new Tuple<string, List<string>>("movie::PlayerObserver::OnVideoOutputFrameAvailable(movie::VideoFrameInfo*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserver23OnOutputBufferAvailableEiNS_9TrackTypeE", new Tuple<string, List<string>>("movie::PlayerObserver::OnOutputBufferAvailable(int, movie::TrackType)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserver23OnOutputBufferAvailableEiNS_9TrackTypeEli", new Tuple<string, List<string>>("movie::PlayerObserver::OnOutputBufferAvailable(int, movie::TrackType, long, int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserver15OnFormatChangedENS_9TrackTypeE", new Tuple<string, List<string>>("movie::PlayerObserver::OnFormatChanged(movie::TrackType)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserver19OnVideoFrameDroppedEl", new Tuple<string, List<string>>("movie::PlayerObserver::OnVideoFrameDropped(long)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserverD2Ev", new Tuple<string, List<string>>("movie::PlayerObserver::~PlayerObserver()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserverD1Ev", new Tuple<string, List<string>>("movie::PlayerObserver::~PlayerObserver()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserverD0Ev", new Tuple<string, List<string>>("movie::PlayerObserver::~PlayerObserver()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player6SeekToEx", new Tuple<string, List<string>>("movie::Player::SeekTo(long long)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player26GetCurrentPlaybackPositionEPx", new Tuple<string, List<string>>("movie::Player::GetCurrentPlaybackPosition(long long*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player19GetPlaybackDurationEPx", new Tuple<string, List<string>>("movie::Player::GetPlaybackDuration(long long*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player24AcquireOutputBufferIndexEiPiPxS1_", new Tuple<string, List<string>>("movie::Player::AcquireOutputBufferIndex(int, int*, long long*, int*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player16FillOutputBufferEiiPNS_6BufferEPxPj", new Tuple<string, List<string>>("movie::Player::FillOutputBuffer(int, int, movie::Buffer*, long long*, unsigned int*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie6Player6SeekToExPx", new Tuple<string, List<string>>("movie::Player::SeekTo(long long, long long*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserver23OnOutputBufferAvailableEiNS_9TrackTypeExi", new Tuple<string, List<string>>("movie::PlayerObserver::OnOutputBufferAvailable(int, movie::TrackType, long long, int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie14PlayerObserver19OnVideoFrameDroppedEx", new Tuple<string, List<string>>("movie::PlayerObserver::OnVideoFrameDropped(long long)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15ExtractorConfigC2Ev", new Tuple<string, List<string>>("movie::ExtractorConfig::ExtractorConfig()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15ExtractorConfigC1Ev", new Tuple<string, List<string>>("movie::ExtractorConfig::ExtractorConfig()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor6CreateEPPS0_", new Tuple<string, List<string>>("movie::PlayerExtractor::Create(movie::PlayerExtractor**)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor6CreateEPPS0_PNS_15ExtractorConfigE", new Tuple<string, List<string>>("movie::PlayerExtractor::Create(movie::PlayerExtractor**, movie::ExtractorConfig*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor7DestroyEPS0_", new Tuple<string, List<string>>("movie::PlayerExtractor::Destroy(movie::PlayerExtractor*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor13SetDataSourceEPKc", new Tuple<string, List<string>>("movie::PlayerExtractor::SetDataSource(char const*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor13SetDataSourceEPKvi", new Tuple<string, List<string>>("movie::PlayerExtractor::SetDataSource(void const*, int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZNK5movie15PlayerExtractor11CountTracksEPi", new Tuple<string, List<string>>("movie::PlayerExtractor::CountTracks(int*) const", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZNK5movie15PlayerExtractor14GetTrackFormatEiPNS_9MediaDataE", new Tuple<string, List<string>>("movie::PlayerExtractor::GetTrackFormat(int, movie::MediaData*) const", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZNK5movie15PlayerExtractor13GetFileFormatEPNS_9MediaDataE", new Tuple<string, List<string>>("movie::PlayerExtractor::GetFileFormat(movie::MediaData*) const", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor11SelectTrackEi", new Tuple<string, List<string>>("movie::PlayerExtractor::SelectTrack(int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor13UnselectTrackEi", new Tuple<string, List<string>>("movie::PlayerExtractor::UnselectTrack(int)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor6SeekToEl", new Tuple<string, List<string>>("movie::PlayerExtractor::SeekTo(long)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor7AdvanceEv", new Tuple<string, List<string>>("movie::PlayerExtractor::Advance()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor14ReadSampleDataEPNS_6BufferE", new Tuple<string, List<string>>("movie::PlayerExtractor::ReadSampleData(movie::Buffer*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor19GetSampleTrackIndexEPm", new Tuple<string, List<string>>("movie::PlayerExtractor::GetSampleTrackIndex(unsigned long*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor13GetSampleTimeEPl", new Tuple<string, List<string>>("movie::PlayerExtractor::GetSampleTime(long*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor13GetSampleTimeEmPl", new Tuple<string, List<string>>("movie::PlayerExtractor::GetSampleTime(unsigned long, long*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor13GetSampleMetaEPNS_9MediaDataE", new Tuple<string, List<string>>("movie::PlayerExtractor::GetSampleMeta(movie::MediaData*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZNK5movie15PlayerExtractor17GetCachedDurationEPlPb", new Tuple<string, List<string>>("movie::PlayerExtractor::GetCachedDuration(long*, bool*) const", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor19CancelSetDataSourceEv", new Tuple<string, List<string>>("movie::PlayerExtractor::CancelSetDataSource()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor11IsCacheFullEPb", new Tuple<string, List<string>>("movie::PlayerExtractor::IsCacheFull(bool*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor26TerminateNetworkConnectionEv", new Tuple<string, List<string>>("movie::PlayerExtractor::TerminateNetworkConnection()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractorC2Ev", new Tuple<string, List<string>>("movie::PlayerExtractor::PlayerExtractor()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractorC2EPNS_15ExtractorConfigE", new Tuple<string, List<string>>("movie::PlayerExtractor::PlayerExtractor(movie::ExtractorConfig*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractorD2Ev", new Tuple<string, List<string>>("movie::PlayerExtractor::~PlayerExtractor()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractorD1Ev", new Tuple<string, List<string>>("movie::PlayerExtractor::~PlayerExtractor()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractorD0Ev", new Tuple<string, List<string>>("movie::PlayerExtractor::~PlayerExtractor()", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor6SeekToEx", new Tuple<string, List<string>>("movie::PlayerExtractor::SeekTo(long long)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor19GetSampleTrackIndexEPj", new Tuple<string, List<string>>("movie::PlayerExtractor::GetSampleTrackIndex(unsigned int*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor13GetSampleTimeEPx", new Tuple<string, List<string>>("movie::PlayerExtractor::GetSampleTime(long long*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie15PlayerExtractor13GetSampleTimeEjPx", new Tuple<string, List<string>>("movie::PlayerExtractor::GetSampleTime(unsigned int, long long*)", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZNK5movie15PlayerExtractor17GetCachedDurationEPxPb", new Tuple<string, List<string>>("movie::PlayerExtractor::GetCachedDuration(long long*, bool*) const", new List<string>() { "4_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN2nn3ldn17InitializeMonitorEv", new Tuple<string, List<string>>("nn::ldn::InitializeMonitor()", new List<string>() { "4_BundleRules_NX_Private_LdnMonitor_LdnMonitor" }) },
                        { "_ZN2nn3ldn15FinalizeMonitorEv", new Tuple<string, List<string>>("nn::ldn::FinalizeMonitor()", new List<string>() { "4_BundleRules_NX_Private_LdnMonitor_LdnMonitor" }) },
                        { "_ZN2nn3ldn18GetStateForMonitorEv", new Tuple<string, List<string>>("nn::ldn::GetStateForMonitor()", new List<string>() { "4_BundleRules_NX_Private_LdnMonitor_LdnMonitor" }) },
                        { "_ZN2nn3ldn24GetNetworkInfoForMonitorEPNS0_11NetworkInfoE", new Tuple<string, List<string>>("nn::ldn::GetNetworkInfoForMonitor(nn::ldn::NetworkInfo*)", new List<string>() { "4_BundleRules_NX_Private_LdnMonitor_LdnMonitor" }) },
                        { "_ZN2nn3ldn24GetIpv4AddressForMonitorEPNS0_11Ipv4AddressEPNS0_10SubnetMaskE", new Tuple<string, List<string>>("nn::ldn::GetIpv4AddressForMonitor(nn::ldn::Ipv4Address*, nn::ldn::SubnetMask*)", new List<string>() { "4_BundleRules_NX_Private_LdnMonitor_LdnMonitor" }) },
                        { "_ZN2nn3ldn16InitializeSystemEv", new Tuple<string, List<string>>("nn::ldn::InitializeSystem()", new List<string>() { "4_BundleRules_NX_Private_LdnSystem_LdnSystem" }) },
                        { "_ZN2nn3ldn14FinalizeSystemEv", new Tuple<string, List<string>>("nn::ldn::FinalizeSystem()", new List<string>() { "4_BundleRules_NX_Private_LdnSystem_LdnSystem" }) },
                        { "_ZN2nn3ldn11ScanPrivateEPNS0_11NetworkInfoEPiiRKNS0_10ScanFilterEi", new Tuple<string, List<string>>("nn::ldn::ScanPrivate(nn::ldn::NetworkInfo*, int*, int, nn::ldn::ScanFilter const&, int)", new List<string>() { "4_BundleRules_NX_Private_LdnPrivate_LdnPrivate" }) },
                        { "_ZN2nn3ldn20CreateNetworkPrivateERKNS0_13NetworkConfigERKNS0_14SecurityConfigERKNS0_17SecurityParameterERKNS0_10UserConfigEiPKNS0_12AddressEntryE", new Tuple<string, List<string>>("nn::ldn::CreateNetworkPrivate(nn::ldn::NetworkConfig const&, nn::ldn::SecurityConfig const&, nn::ldn::SecurityParameter const&, nn::ldn::UserConfig const&, int, nn::ldn::AddressEntry const*)", new List<string>() { "4_BundleRules_NX_Private_LdnPrivate_LdnPrivate" }) },
                        { "_ZN2nn3ldn14ConnectPrivateERKNS0_13NetworkConfigERKNS0_14SecurityConfigERKNS0_17SecurityParameterERKNS0_10UserConfigEiNS0_13ConnectOptionE", new Tuple<string, List<string>>("nn::ldn::ConnectPrivate(nn::ldn::NetworkConfig const&, nn::ldn::SecurityConfig const&, nn::ldn::SecurityParameter const&, nn::ldn::UserConfig const&, int, nn::ldn::ConnectOption)", new List<string>() { "4_BundleRules_NX_Private_LdnPrivate_LdnPrivate" }) },
                        { "_ZN2nn3ldn14ConnectPrivateERKNS0_13NetworkConfigERKNS0_14SecurityConfigERKNS0_17SecurityParameterERKNS0_10UserConfigEi", new Tuple<string, List<string>>("nn::ldn::ConnectPrivate(nn::ldn::NetworkConfig const&, nn::ldn::SecurityConfig const&, nn::ldn::SecurityParameter const&, nn::ldn::UserConfig const&, int)", new List<string>() { "4_BundleRules_NX_Private_LdnPrivate_LdnPrivate" }) },
                        { "_ZN2nn3ldn20GetSecurityParameterEPNS0_17SecurityParameterE", new Tuple<string, List<string>>("nn::ldn::GetSecurityParameter(nn::ldn::SecurityParameter*)", new List<string>() { "4_BundleRules_NX_Private_LdnPrivate_LdnPrivate" }) },
                        { "_ZN2nn3ldn16GetNetworkConfigEPNS0_13NetworkConfigE", new Tuple<string, List<string>>("nn::ldn::GetNetworkConfig(nn::ldn::NetworkConfig*)", new List<string>() { "4_BundleRules_NX_Private_LdnPrivate_LdnPrivate" }) },
                        { "_ZN2nn3ldn20AddAcceptFilterEntryENS0_10MacAddressE", new Tuple<string, List<string>>("nn::ldn::AddAcceptFilterEntry(nn::ldn::MacAddress)", new List<string>() { "4_BundleRules_NX_Private_LdnPrivate_LdnPrivate" }) },
                        { "_ZN2nn3ldnL11PriorityMinE", new Tuple<string, List<string>>("nn::ldn::PriorityMin", new List<string>() { "4_BundleRules_NX_Private_LdnPrivate_LdnPrivate" }) },
                        { "_ZN2nn3ldnL11PriorityMaxE", new Tuple<string, List<string>>("nn::ldn::PriorityMax", new List<string>() { "4_BundleRules_NX_Private_LdnPrivate_LdnPrivate" }) },
                        { "_ZN2nn3ldnL12UserPriorityE", new Tuple<string, List<string>>("nn::ldn::UserPriority", new List<string>() { "4_BundleRules_NX_Private_LdnPrivate_LdnPrivate" }) },
                        { "_ZN2nn3ldnL21DefaultSystemPriorityE", new Tuple<string, List<string>>("nn::ldn::DefaultSystemPriority", new List<string>() { "4_BundleRules_NX_Private_LdnPrivate_LdnPrivate" }) },
                        { "_ZN2nn3ldnL20AddressEntryCountMaxE", new Tuple<string, List<string>>("nn::ldn::AddressEntryCountMax", new List<string>() { "4_BundleRules_NX_Private_LdnPrivate_LdnPrivate" }) },
                        { "_ZN2nn3btm6system26AcquireGamepadPairingEventEPNS_2os15SystemEventTypeE", new Tuple<string, List<string>>("nn::btm::system::AcquireGamepadPairingEvent(nn::os::SystemEventType*)", new List<string>() { "4_BundleRules_NX_Private_BtmSystem_BtmSystem" }) },
                        { "_ZN2nn3btm6system19StartGamepadPairingEv", new Tuple<string, List<string>>("nn::btm::system::StartGamepadPairing()", new List<string>() { "4_BundleRules_NX_Private_BtmSystem_BtmSystem" }) },
                        { "_ZN2nn3btm6system20CancelGamepadPairingEv", new Tuple<string, List<string>>("nn::btm::system::CancelGamepadPairing()", new List<string>() { "4_BundleRules_NX_Private_BtmSystem_BtmSystem" }) },
                        { "_ZN2nn3btm6system23IsGamepadPairingStartedEv", new Tuple<string, List<string>>("nn::btm::system::IsGamepadPairingStarted()", new List<string>() { "4_BundleRules_NX_Private_BtmSystem_BtmSystem" }) },
                        { "_ZN2nn3btm6system21GetPairedGamepadCountEv", new Tuple<string, List<string>>("nn::btm::system::GetPairedGamepadCount()", new List<string>() { "4_BundleRules_NX_Private_BtmSystem_BtmSystem" }) },
                        { "_ZN2nn3btm6system27ClearGamepadPairingDatabaseEv", new Tuple<string, List<string>>("nn::btm::system::ClearGamepadPairingDatabase()", new List<string>() { "4_BundleRules_NX_Private_BtmSystem_BtmSystem" }) },
                        { "_ZN2nn3btm6system17AcquireRadioEventEPNS_2os15SystemEventTypeE", new Tuple<string, List<string>>("nn::btm::system::AcquireRadioEvent(nn::os::SystemEventType*)", new List<string>() { "4_BundleRules_NX_Private_BtmSystem_BtmSystem" }) },
                        { "_ZN2nn3btm6system11EnableRadioEb", new Tuple<string, List<string>>("nn::btm::system::EnableRadio(bool)", new List<string>() { "4_BundleRules_NX_Private_BtmSystem_BtmSystem" }) },
                        { "_ZN2nn3btm6system14IsRadioEnabledEv", new Tuple<string, List<string>>("nn::btm::system::IsRadioEnabled()", new List<string>() { "4_BundleRules_NX_Private_BtmSystem_BtmSystem" }) },
                        { "_ZN2nv22SetGraphicsServiceNameEPKc", new Tuple<string, List<string>>("nv::SetGraphicsServiceName(char const*)", new List<string>() { "4_BundleRules_NX_Private_NvnPrivate_NvnPrivate" }) },
                        { "_ZN2nn3web13ShowLobbyPageEPNS0_20LobbyPageReturnValueERKNS0_16ShowLobbyPageArgE", new Tuple<string, List<string>>("nn::web::ShowLobbyPage(nn::web::LobbyPageReturnValue*, nn::web::ShowLobbyPageArg const&)", new List<string>() { "4_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3web16ShowLobbyPageArg23LobbyParameterMaxLengthE", new Tuple<string, List<string>>("nn::web::ShowLobbyPageArg::LobbyParameterMaxLength", new List<string>() { "4_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3web16ShowLobbyPageArgC2Ev", new Tuple<string, List<string>>("nn::web::ShowLobbyPageArg::ShowLobbyPageArg()", new List<string>() { "4_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3web16ShowLobbyPageArgC1Ev", new Tuple<string, List<string>>("nn::web::ShowLobbyPageArg::ShowLobbyPageArg()", new List<string>() { "4_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3web16ShowLobbyPageArg6SetUidERKNS_7account3UidE", new Tuple<string, List<string>>("nn::web::ShowLobbyPageArg::SetUid(nn::account::Uid const&)", new List<string>() { "4_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3web16ShowLobbyPageArg17SetLobbyParameterEPKc", new Tuple<string, List<string>>("nn::web::ShowLobbyPageArg::SetLobbyParameter(char const*)", new List<string>() { "4_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3web16ShowLobbyPageArg8DataSizeE", new Tuple<string, List<string>>("nn::web::ShowLobbyPageArg::DataSize", new List<string>() { "4_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3web20LobbyPageReturnValue16LastUrlMaxLengthE", new Tuple<string, List<string>>("nn::web::LobbyPageReturnValue::LastUrlMaxLength", new List<string>() { "4_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3web20LobbyPageReturnValueC2Ev", new Tuple<string, List<string>>("nn::web::LobbyPageReturnValue::LobbyPageReturnValue()", new List<string>() { "4_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3web20LobbyPageReturnValueC1Ev", new Tuple<string, List<string>>("nn::web::LobbyPageReturnValue::LobbyPageReturnValue()", new List<string>() { "4_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZNK2nn3web20LobbyPageReturnValue18GetLobbyExitReasonEv", new Tuple<string, List<string>>("nn::web::LobbyPageReturnValue::GetLobbyExitReason() const", new List<string>() { "4_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZNK2nn3web20LobbyPageReturnValue10GetLastUrlEv", new Tuple<string, List<string>>("nn::web::LobbyPageReturnValue::GetLastUrl() const", new List<string>() { "4_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZNK2nn3web20LobbyPageReturnValue14GetLastUrlSizeEv", new Tuple<string, List<string>>("nn::web::LobbyPageReturnValue::GetLastUrlSize() const", new List<string>() { "4_BundleRules_NX_Private_NetworkMiddleware_NetworkMiddleware" }) },
                        { "_ZN2nn3hid27BeginForcedVibrationSessionEv", new Tuple<string, List<string>>("nn::hid::BeginForcedVibrationSession()", new List<string>() { "4_BundleRules_NX_Private_VibrationPermission_VibrationPermission" }) },
                        { "_ZN2nn3hid25EndForcedVibrationSessionEv", new Tuple<string, List<string>>("nn::hid::EndForcedVibrationSession()", new List<string>() { "4_BundleRules_NX_Private_VibrationPermission_VibrationPermission" }) },
                        { "_ZN2nn3hid15PermitVibrationEb", new Tuple<string, List<string>>("nn::hid::PermitVibration(bool)", new List<string>() { "4_BundleRules_NX_Private_VibrationPermission_VibrationPermission" }) },
                        { "_ZN2nn2oe21GetExpectedThemeColorEv", new Tuple<string, List<string>>("nn::oe::GetExpectedThemeColor()", new List<string>() { "4_BundleRules_NX_Private_OperationStateControl_operation-state-control" }) },
                        { "_ZN2nn2oe30SetExpectedThemeColorForSystemENS0_14ThemeColorTypeE", new Tuple<string, List<string>>("nn::oe::SetExpectedThemeColorForSystem(nn::oe::ThemeColorType)", new List<string>() { "4_BundleRules_NX_Private_OperationStateControl_operation-state-control" }) },
                        { "_ZN2nn2oe20GetDefaultThemeColorEv", new Tuple<string, List<string>>("nn::oe::GetDefaultThemeColor()", new List<string>() { "4_BundleRules_NX_Private_OperationStateControl_operation-state-control" }) },
                        { "_ZN2nn3fgm7RequestC2ERKS1_", new Tuple<string, List<string>>("nn::fgm::Request::Request(nn::fgm::Request const&)", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7RequestC1ERKS1_", new Tuple<string, List<string>>("nn::fgm::Request::Request(nn::fgm::Request const&)", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7RequestaSERKS1_", new Tuple<string, List<string>>("nn::fgm::Request::operator=(nn::fgm::Request const&)", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7RequestC2EOS1_", new Tuple<string, List<string>>("nn::fgm::Request::Request(nn::fgm::Request&&)", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7RequestC1EOS1_", new Tuple<string, List<string>>("nn::fgm::Request::Request(nn::fgm::Request&&)", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7RequestaSEOS1_", new Tuple<string, List<string>>("nn::fgm::Request::operator=(nn::fgm::Request&&)", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7Request10InitializeENS0_6ModuleEjNS_2os14EventClearModeE", new Tuple<string, List<string>>("nn::fgm::Request::Initialize(nn::fgm::Module, unsigned int, nn::os::EventClearMode)", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7Request10InitializeENS0_6ModuleEj", new Tuple<string, List<string>>("nn::fgm::Request::Initialize(nn::fgm::Module, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7Request3SetEjj", new Tuple<string, List<string>>("nn::fgm::Request::Set(unsigned int, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7Request10SetAndWaitEjj", new Tuple<string, List<string>>("nn::fgm::Request::SetAndWait(unsigned int, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7Request21SetAndWaitWithTimeoutEjjNS_8TimeSpanE", new Tuple<string, List<string>>("nn::fgm::Request::SetAndWaitWithTimeout(unsigned int, unsigned int, nn::TimeSpan)", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7Request3GetEPj", new Tuple<string, List<string>>("nn::fgm::Request::Get(unsigned int*)", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7Request4WaitEv", new Tuple<string, List<string>>("nn::fgm::Request::Wait()", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7Request15WaitWithTimeoutENS_8TimeSpanE", new Tuple<string, List<string>>("nn::fgm::Request::WaitWithTimeout(nn::TimeSpan)", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7Request6CancelEv", new Tuple<string, List<string>>("nn::fgm::Request::Cancel()", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7Request21GetSystemEventPointerEv", new Tuple<string, List<string>>("nn::fgm::Request::GetSystemEventPointer()", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7Request10ClearEventEv", new Tuple<string, List<string>>("nn::fgm::Request::ClearEvent()", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7Request8FinalizeEv", new Tuple<string, List<string>>("nn::fgm::Request::Finalize()", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7RequestC2Ev", new Tuple<string, List<string>>("nn::fgm::Request::Request()", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7RequestC1Ev", new Tuple<string, List<string>>("nn::fgm::Request::Request()", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7RequestD2Ev", new Tuple<string, List<string>>("nn::fgm::Request::~Request()", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgm7RequestD1Ev", new Tuple<string, List<string>>("nn::fgm::Request::~Request()", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgmL18NumberOfPrioritiesE", new Tuple<string, List<string>>("nn::fgm::NumberOfPriorities", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgmL15FgmPortPriorityE", new Tuple<string, List<string>>("nn::fgm::FgmPortPriority", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgmL16FgmDebugPortNameE", new Tuple<string, List<string>>("nn::fgm::FgmDebugPortName", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgmL8PortNameE", new Tuple<string, List<string>>("nn::fgm::PortName", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3fgmL26MaximumRequestsPerPriorityE", new Tuple<string, List<string>>("nn::fgm::MaximumRequestsPerPriority", new List<string>() { "4_BundleRules_NX_Private_PerformanceEvaluation_performance-evaluation" }) },
                        { "_ZN2nn3web36ShowOfflineHtmlPageArgWithPlayReportC2EPKc", new Tuple<string, List<string>>("nn::web::ShowOfflineHtmlPageArgWithPlayReport::ShowOfflineHtmlPageArgWithPlayReport(char const*)", new List<string>() { "4_BundleRules_NX_Private_OfflineWebPlayReport_OfflineWebPlayReport" }) },
                        { "_ZN2nn3web36ShowOfflineHtmlPageArgWithPlayReportC1EPKc", new Tuple<string, List<string>>("nn::web::ShowOfflineHtmlPageArgWithPlayReport::ShowOfflineHtmlPageArgWithPlayReport(char const*)", new List<string>() { "4_BundleRules_NX_Private_OfflineWebPlayReport_OfflineWebPlayReport" }) },
                        { "_ZN2nn3web36ShowOfflineHtmlPageArgWithPlayReportC2ERKNS_13ApplicationIdEPKc", new Tuple<string, List<string>>("nn::web::ShowOfflineHtmlPageArgWithPlayReport::ShowOfflineHtmlPageArgWithPlayReport(nn::ApplicationId const&, char const*)", new List<string>() { "4_BundleRules_NX_Private_OfflineWebPlayReport_OfflineWebPlayReport" }) },
                        { "_ZN2nn3web36ShowOfflineHtmlPageArgWithPlayReportC1ERKNS_13ApplicationIdEPKc", new Tuple<string, List<string>>("nn::web::ShowOfflineHtmlPageArgWithPlayReport::ShowOfflineHtmlPageArgWithPlayReport(nn::ApplicationId const&, char const*)", new List<string>() { "4_BundleRules_NX_Private_OfflineWebPlayReport_OfflineWebPlayReport" }) },
                        { "_ZN2nn3web36ShowOfflineHtmlPageArgWithPlayReport20SetPlayReportEnabledEb", new Tuple<string, List<string>>("nn::web::ShowOfflineHtmlPageArgWithPlayReport::SetPlayReportEnabled(bool)", new List<string>() { "4_BundleRules_NX_Private_OfflineWebPlayReport_OfflineWebPlayReport" }) },
                        { "_ZN2nn3web22SetEcClientCertEnabledEPNS0_14ShowWebPageArgE", new Tuple<string, List<string>>("nn::web::SetEcClientCertEnabled(nn::web::ShowWebPageArg*)", new List<string>() { "4_BundleRules_NX_Private_WebEcClientCert_WebEcClientCert" }) },
                        { "_ZN2nn5prepo27IsUserAgreementCheckEnabledEPb", new Tuple<string, List<string>>("nn::prepo::IsUserAgreementCheckEnabled(bool*)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo28SetUserAgreementCheckEnabledEb", new Tuple<string, List<string>>("nn::prepo::SetUserAgreementCheckEnabled(bool)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReportC2ERKS1_", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::SystemPlayReport(nn::prepo::SystemPlayReport const&)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReportC1ERKS1_", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::SystemPlayReport(nn::prepo::SystemPlayReport const&)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReportaSERKS1_", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::operator=(nn::prepo::SystemPlayReport const&)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReportC2EOS1_", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::SystemPlayReport(nn::prepo::SystemPlayReport&&)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReportC1EOS1_", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::SystemPlayReport(nn::prepo::SystemPlayReport&&)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReportaSEOS1_", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::operator=(nn::prepo::SystemPlayReport&&)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport13BufferSizeMinE", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::BufferSizeMin", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport13BufferSizeMaxE", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::BufferSizeMax", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReportC2Ev", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::SystemPlayReport()", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReportC1Ev", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::SystemPlayReport()", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReportC2EPKc", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::SystemPlayReport(char const*)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReportC1EPKc", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::SystemPlayReport(char const*)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport9SetBufferEPvm", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::SetBuffer(void*, unsigned long)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport10SetEventIdEPKc", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::SetEventId(char const*)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport16SetApplicationIdERKNS_13ApplicationIdE", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::SetApplicationId(nn::ApplicationId const&)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport5ClearEv", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::Clear()", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport3AddEPKcl", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::Add(char const*, long)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport3AddEPKcRKNS0_10Any64BitIdE", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::Add(char const*, nn::prepo::Any64BitId const&)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport3AddEPKcd", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::Add(char const*, double)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport3AddEPKcS3_", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::Add(char const*, char const*)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport4SaveEv", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::Save()", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport4SaveERKNS_7account3UidE", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::Save(nn::account::Uid const&)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn5prepo16SystemPlayReport8GetCountEv", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::GetCount() const", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport9SetBufferEPvj", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::SetBuffer(void*, unsigned int)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn5prepo16SystemPlayReport3AddEPKcx", new Tuple<string, List<string>>("nn::prepo::SystemPlayReport::Add(char const*, long long)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3err11ReportErrorENS_13ApplicationIdENS_6ResultE", new Tuple<string, List<string>>("nn::err::ReportError(nn::ApplicationId, nn::Result)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3err11ReportErrorENS_13ApplicationIdENS0_9ErrorCodeE", new Tuple<string, List<string>>("nn::err::ReportError(nn::ApplicationId, nn::err::ErrorCode)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3err11ReportErrorENS_13ApplicationIdENS_6ResultERKNS0_15ResultBacktraceE", new Tuple<string, List<string>>("nn::err::ReportError(nn::ApplicationId, nn::Result, nn::err::ResultBacktrace const&)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3err11ReportErrorENS_13ApplicationIdENS0_9ErrorCodeERKNS0_15ResultBacktraceE", new Tuple<string, List<string>>("nn::err::ReportError(nn::ApplicationId, nn::err::ErrorCode, nn::err::ResultBacktrace const&)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3err11ReportErrorENS_13ApplicationIdENS_6ResultERKNS0_12ErrorContextEPvm", new Tuple<string, List<string>>("nn::err::ReportError(nn::ApplicationId, nn::Result, nn::err::ErrorContext const&, void*, unsigned long)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3err11ReportErrorENS_13ApplicationIdENS0_9ErrorCodeERKNS0_12ErrorContextEPvm", new Tuple<string, List<string>>("nn::err::ReportError(nn::ApplicationId, nn::err::ErrorCode, nn::err::ErrorContext const&, void*, unsigned long)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3err11ReportErrorENS_13ApplicationIdENS_6ResultERKNS0_12ErrorContextEPvj", new Tuple<string, List<string>>("nn::err::ReportError(nn::ApplicationId, nn::Result, nn::err::ErrorContext const&, void*, unsigned int)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3err11ReportErrorENS_13ApplicationIdENS0_9ErrorCodeERKNS0_12ErrorContextEPvj", new Tuple<string, List<string>>("nn::err::ReportError(nn::ApplicationId, nn::err::ErrorCode, nn::err::ErrorContext const&, void*, unsigned int)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3errL30ErrorViewerStartupParamSizeMaxE", new Tuple<string, List<string>>("nn::err::ErrorViewerStartupParamSizeMax", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3errL32RequiredBufferSizeForRecordErrorE", new Tuple<string, List<string>>("nn::err::RequiredBufferSizeForRecordError", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3err15ResultBacktrace8CountMaxE", new Tuple<string, List<string>>("nn::err::ResultBacktrace::CountMax", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3err15ResultBacktrace4MakeEPS1_PKNS_6ResultEi", new Tuple<string, List<string>>("nn::err::ResultBacktrace::Make(nn::err::ResultBacktrace*, nn::Result const*, int)", new List<string>() { "4_BundleDefinitions_NX_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fsL31SdCardNintendoRootDirectoryNameE", new Tuple<string, List<string>>("nn::fs::SdCardNintendoRootDirectoryName", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs11MountSdCardEPKc", new Tuple<string, List<string>>("nn::fs::MountSdCard(char const*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fsL13SdCardCidSizeE", new Tuple<string, List<string>>("nn::fs::SdCardCidSize", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs32OpenSdCardDetectionEventNotifierEPNSt3__110unique_ptrINS0_14IEventNotifierENS1_14default_deleteIS3_EEEE", new Tuple<string, List<string>>("nn::fs::OpenSdCardDetectionEventNotifier(std::__1::unique_ptr<nn::fs::IEventNotifier, std::__1::default_delete<nn::fs::IEventNotifier> >*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs16IsSdCardInsertedEv", new Tuple<string, List<string>>("nn::fs::IsSdCardInserted()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs18GetSdCardSpeedModeEPNS0_15SdCardSpeedModeE", new Tuple<string, List<string>>("nn::fs::GetSdCardSpeedMode(nn::fs::SdCardSpeedMode*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs12GetSdCardCidEPvm", new Tuple<string, List<string>>("nn::fs::GetSdCardCid(void*, unsigned long)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs19GetMidFromSdCardCidEPKh", new Tuple<string, List<string>>("nn::fs::GetMidFromSdCardCid(unsigned char const*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fsL16SdCardCidOidSizeE", new Tuple<string, List<string>>("nn::fs::SdCardCidOidSize", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs19GetOidFromSdCardCidEPcmPKh", new Tuple<string, List<string>>("nn::fs::GetOidFromSdCardCid(char*, unsigned long, unsigned char const*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fsL16SdCardCidPnmSizeE", new Tuple<string, List<string>>("nn::fs::SdCardCidPnmSize", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs19GetPnmFromSdCardCidEPcmPKh", new Tuple<string, List<string>>("nn::fs::GetPnmFromSdCardCid(char*, unsigned long, unsigned char const*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs19GetPrvFromSdCardCidEPKh", new Tuple<string, List<string>>("nn::fs::GetPrvFromSdCardCid(unsigned char const*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs19GetPsnFromSdCardCidEPKh", new Tuple<string, List<string>>("nn::fs::GetPsnFromSdCardCid(unsigned char const*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs27GetMdtYearCodeFromSdCardCidEPKh", new Tuple<string, List<string>>("nn::fs::GetMdtYearCodeFromSdCardCid(unsigned char const*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs28GetMdtMonthCodeFromSdCardCidEPKh", new Tuple<string, List<string>>("nn::fs::GetMdtMonthCodeFromSdCardCid(unsigned char const*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs21GetSdCardUserAreaSizeEPl", new Tuple<string, List<string>>("nn::fs::GetSdCardUserAreaSize(long*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs26GetSdCardProtectedAreaSizeEPl", new Tuple<string, List<string>>("nn::fs::GetSdCardProtectedAreaSize(long*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs12FormatSdCardEv", new Tuple<string, List<string>>("nn::fs::FormatSdCard()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs18FormatSdCardDryRunEv", new Tuple<string, List<string>>("nn::fs::FormatSdCardDryRun()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs14EncryptionSeed4SizeE", new Tuple<string, List<string>>("nn::fs::EncryptionSeed::Size", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs23SetSdCardEncryptionSeedERKNS0_14EncryptionSeedE", new Tuple<string, List<string>>("nn::fs::SetSdCardEncryptionSeed(nn::fs::EncryptionSeed const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs22SetSdCardAccessibilityEb", new Tuple<string, List<string>>("nn::fs::SetSdCardAccessibility(bool)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs18IsSdCardAccessibleEv", new Tuple<string, List<string>>("nn::fs::IsSdCardAccessible()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs12GetSdCardCidEPvj", new Tuple<string, List<string>>("nn::fs::GetSdCardCid(void*, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs19GetOidFromSdCardCidEPcjPKh", new Tuple<string, List<string>>("nn::fs::GetOidFromSdCardCid(char*, unsigned int, unsigned char const*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs19GetPnmFromSdCardCidEPcjPKh", new Tuple<string, List<string>>("nn::fs::GetPnmFromSdCardCid(char*, unsigned int, unsigned char const*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs21GetSdCardUserAreaSizeEPx", new Tuple<string, List<string>>("nn::fs::GetSdCardUserAreaSize(long long*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs26GetSdCardProtectedAreaSizeEPx", new Tuple<string, List<string>>("nn::fs::GetSdCardProtectedAreaSize(long long*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm13ApplicationId12GetInvalidIdEv", new Tuple<string, List<string>>("nn::ncm::ApplicationId::GetInvalidId()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3ncm13ApplicationIdcvNS0_9ProgramIdEEv", new Tuple<string, List<string>>("nn::ncm::ApplicationId::operator nn::ncm::ProgramId() const", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3ncm7PatchIdcvNS0_9ProgramIdEEv", new Tuple<string, List<string>>("nn::ncm::PatchId::operator nn::ncm::ProgramId() const", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3ncm14AddOnContentIdcvNS0_6DataIdEEv", new Tuple<string, List<string>>("nn::ncm::AddOnContentId::operator nn::ncm::DataId() const", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3ncm7DeltaIdcvNS0_9ProgramIdEEv", new Tuple<string, List<string>>("nn::ncm::DeltaId::operator nn::ncm::ProgramId() const", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3ncm14ContentMetaKeyltERKS1_", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::operator<(nn::ncm::ContentMetaKey const&) const", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3ncm14ContentMetaKeyeqERKS1_", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::operator==(nn::ncm::ContentMetaKey const&) const", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3ncm14ContentMetaKeyneERKS1_", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::operator!=(nn::ncm::ContentMetaKey const&) const", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey4MakeENS0_15SystemProgramIdEj", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::Make(nn::ncm::SystemProgramId, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey4MakeENS0_12SystemDataIdEj", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::Make(nn::ncm::SystemDataId, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey4MakeENS0_13ApplicationIdEj", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::Make(nn::ncm::ApplicationId, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey4MakeENS0_7PatchIdEj", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::Make(nn::ncm::PatchId, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey4MakeENS0_7PatchIdEjNS0_18ContentInstallTypeE", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::Make(nn::ncm::PatchId, unsigned int, nn::ncm::ContentInstallType)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey4MakeENS0_7DeltaIdEj", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::Make(nn::ncm::DeltaId, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey4MakeENS0_14SystemUpdateIdEj", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::Make(nn::ncm::SystemUpdateId, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey4MakeEmjNS0_15ContentMetaTypeE", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::Make(unsigned long, unsigned int, nn::ncm::ContentMetaType)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey4MakeEmjNS0_15ContentMetaTypeENS0_18ContentInstallTypeE", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::Make(unsigned long, unsigned int, nn::ncm::ContentMetaType, nn::ncm::ContentInstallType)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey15MakeUnknownTypeEmj", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::MakeUnknownType(unsigned long, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3ncm21StorageContentMetaKeyeqERKS1_", new Tuple<string, List<string>>("nn::ncm::StorageContentMetaKey::operator==(nn::ncm::StorageContentMetaKey const&) const", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3ncm21StorageContentMetaKeyltERKS1_", new Tuple<string, List<string>>("nn::ncm::StorageContentMetaKey::operator<(nn::ncm::StorageContentMetaKey const&) const", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey4MakeEyjNS0_15ContentMetaTypeE", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::Make(unsigned long long, unsigned int, nn::ncm::ContentMetaType)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey4MakeEyjNS0_15ContentMetaTypeENS0_18ContentInstallTypeE", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::Make(unsigned long long, unsigned int, nn::ncm::ContentMetaType, nn::ncm::ContentInstallType)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm14ContentMetaKey15MakeUnknownTypeEyj", new Tuple<string, List<string>>("nn::ncm::ContentMetaKey::MakeUnknownType(unsigned long long, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm24GetContentMetaTypeStringENS0_15ContentMetaTypeE", new Tuple<string, List<string>>("nn::ncm::GetContentMetaTypeString(nn::ncm::ContentMetaType)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncmeqERKNS0_6DataIdES3_", new Tuple<string, List<string>>("nn::ncm::operator==(nn::ncm::DataId const&, nn::ncm::DataId const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncmneERKNS0_6DataIdES3_", new Tuple<string, List<string>>("nn::ncm::operator!=(nn::ncm::DataId const&, nn::ncm::DataId const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm9ProgramId12GetInvalidIdEv", new Tuple<string, List<string>>("nn::ncm::ProgramId::GetInvalidId()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncmeqERKNS0_9ProgramIdES3_", new Tuple<string, List<string>>("nn::ncm::operator==(nn::ncm::ProgramId const&, nn::ncm::ProgramId const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncmneERKNS0_9ProgramIdES3_", new Tuple<string, List<string>>("nn::ncm::operator!=(nn::ncm::ProgramId const&, nn::ncm::ProgramId const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm20IsInstallableStorageENS0_9StorageIdE", new Tuple<string, List<string>>("nn::ncm::IsInstallableStorage(nn::ncm::StorageId)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm15IsUniqueStorageENS0_9StorageIdE", new Tuple<string, List<string>>("nn::ncm::IsUniqueStorage(nn::ncm::StorageId)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ncm15SystemProgramId12GetInvalidIdEv", new Tuple<string, List<string>>("nn::ncm::SystemProgramId::GetInvalidId()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3ncm15SystemProgramIdcvNS0_9ProgramIdEEv", new Tuple<string, List<string>>("nn::ncm::SystemProgramId::operator nn::ncm::ProgramId() const", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3ncm12SystemDataIdcvNS0_6DataIdEEv", new Tuple<string, List<string>>("nn::ncm::SystemDataId::operator nn::ncm::DataId() const", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3ncm14SystemUpdateIdcvNS0_6DataIdEEv", new Tuple<string, List<string>>("nn::ncm::SystemUpdateId::operator nn::ncm::DataId() const", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet23GetAppletResourceUserIdEv", new Tuple<string, List<string>>("nn::applet::GetAppletResourceUserId()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet26PushToSystemGeneralChannelENS0_13StorageHandleE", new Tuple<string, List<string>>("nn::applet::PushToSystemGeneralChannel(nn::applet::StorageHandle)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet19BeginVrModeInternalEv", new Tuple<string, List<string>>("nn::applet::BeginVrModeInternal()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet17EndVrModeInternalEv", new Tuple<string, List<string>>("nn::applet::EndVrModeInternal()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet34RequestToLaunchApplicationForQuestENS_3ncm13ApplicationIdENS0_13StorageHandleEPKNS0_28ApplicationAttributeForQuestE", new Tuple<string, List<string>>("nn::applet::RequestToLaunchApplicationForQuest(nn::ncm::ApplicationId, nn::applet::StorageHandle, nn::applet::ApplicationAttributeForQuest const*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet37TryPopFromApplicationParameterChannelEPNS0_13StorageHandleENS0_19LaunchParameterKindE", new Tuple<string, List<string>>("nn::applet::TryPopFromApplicationParameterChannel(nn::applet::StorageHandle*, nn::applet::LaunchParameterKind)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet28RequestToRelaunchApplicationENS0_13StorageHandleE", new Tuple<string, List<string>>("nn::applet::RequestToRelaunchApplication(nn::applet::StorageHandle)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet26RequestToLaunchApplicationENS_3ncm13ApplicationIdENS0_13StorageHandleE", new Tuple<string, List<string>>("nn::applet::RequestToLaunchApplication(nn::ncm::ApplicationId, nn::applet::StorageHandle)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet20AppletResourceUserId12GetInvalidIdEv", new Tuple<string, List<string>>("nn::applet::AppletResourceUserId::GetInvalidId()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appleteqERKNS0_20AppletResourceUserIdES3_", new Tuple<string, List<string>>("nn::applet::operator==(nn::applet::AppletResourceUserId const&, nn::applet::AppletResourceUserId const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appletneERKNS0_20AppletResourceUserIdES3_", new Tuple<string, List<string>>("nn::applet::operator!=(nn::applet::AppletResourceUserId const&, nn::applet::AppletResourceUserId const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet25CheckAppletResourceUserIdEmNS0_20AppletResourceUserIdE", new Tuple<string, List<string>>("nn::applet::CheckAppletResourceUserId(unsigned long, nn::applet::AppletResourceUserId)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet25CheckAppletResourceUserIdEyNS0_20AppletResourceUserIdE", new Tuple<string, List<string>>("nn::applet::CheckAppletResourceUserId(unsigned long long, nn::applet::AppletResourceUserId)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet35OverrideAutoSleepTimeAndDimmingTimeEiiii", new Tuple<string, List<string>>("nn::applet::OverrideAutoSleepTimeAndDimmingTime(int, int, int, int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet21SetMediaPlaybackStateEb", new Tuple<string, List<string>>("nn::applet::SetMediaPlaybackState(bool)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet26SetInputDetectionSourceSetEj", new Tuple<string, List<string>>("nn::applet::SetInputDetectionSourceSet(unsigned int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appleteqERKNS0_19LibraryAppletHandleES3_", new Tuple<string, List<string>>("nn::applet::operator==(nn::applet::LibraryAppletHandle const&, nn::applet::LibraryAppletHandle const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appletneERKNS0_19LibraryAppletHandleES3_", new Tuple<string, List<string>>("nn::applet::operator!=(nn::applet::LibraryAppletHandle const&, nn::applet::LibraryAppletHandle const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appletL26InvalidLibraryAppletHandleE", new Tuple<string, List<string>>("nn::applet::InvalidLibraryAppletHandle", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet19CreateLibraryAppletEPNS0_19LibraryAppletHandleENS0_8AppletIdENS0_17LibraryAppletModeE", new Tuple<string, List<string>>("nn::applet::CreateLibraryApplet(nn::applet::LibraryAppletHandle*, nn::applet::AppletId, nn::applet::LibraryAppletMode)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet18GetLibraryAppletIdENS0_19LibraryAppletHandleE", new Tuple<string, List<string>>("nn::applet::GetLibraryAppletId(nn::applet::LibraryAppletHandle)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet20GetLibraryAppletModeENS0_19LibraryAppletHandleE", new Tuple<string, List<string>>("nn::applet::GetLibraryAppletMode(nn::applet::LibraryAppletHandle)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet18StartLibraryAppletENS0_19LibraryAppletHandleEPv", new Tuple<string, List<string>>("nn::applet::StartLibraryApplet(nn::applet::LibraryAppletHandle, void*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet29StartLibraryAppletImmediatelyENS0_19LibraryAppletHandleEPv", new Tuple<string, List<string>>("nn::applet::StartLibraryAppletImmediately(nn::applet::LibraryAppletHandle, void*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet17JumpLibraryAppletENS0_19LibraryAppletHandleE", new Tuple<string, List<string>>("nn::applet::JumpLibraryApplet(nn::applet::LibraryAppletHandle)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet25GetLibraryAppletExitEventENS0_19LibraryAppletHandleE", new Tuple<string, List<string>>("nn::applet::GetLibraryAppletExitEvent(nn::applet::LibraryAppletHandle)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet17JoinLibraryAppletENS0_19LibraryAppletHandleE", new Tuple<string, List<string>>("nn::applet::JoinLibraryApplet(nn::applet::LibraryAppletHandle)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet26GetLibraryAppletExitReasonENS0_19LibraryAppletHandleE", new Tuple<string, List<string>>("nn::applet::GetLibraryAppletExitReason(nn::applet::LibraryAppletHandle)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet18CloseLibraryAppletENS0_19LibraryAppletHandleE", new Tuple<string, List<string>>("nn::applet::CloseLibraryApplet(nn::applet::LibraryAppletHandle)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet15PushToInChannelENS0_19LibraryAppletHandleENS0_13StorageHandleE", new Tuple<string, List<string>>("nn::applet::PushToInChannel(nn::applet::LibraryAppletHandle, nn::applet::StorageHandle)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet26PushToInteractiveInChannelENS0_19LibraryAppletHandleENS0_13StorageHandleE", new Tuple<string, List<string>>("nn::applet::PushToInteractiveInChannel(nn::applet::LibraryAppletHandle, nn::applet::StorageHandle)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet20TryPopFromOutChannelEPNS0_13StorageHandleENS0_19LibraryAppletHandleE", new Tuple<string, List<string>>("nn::applet::TryPopFromOutChannel(nn::applet::StorageHandle*, nn::applet::LibraryAppletHandle)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet31TryPopFromInteractiveOutChannelEPNS0_13StorageHandleENS0_19LibraryAppletHandleE", new Tuple<string, List<string>>("nn::applet::TryPopFromInteractiveOutChannel(nn::applet::StorageHandle*, nn::applet::LibraryAppletHandle)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet36GetPopFromInteractiveOutChannelEventENS0_19LibraryAppletHandleE", new Tuple<string, List<string>>("nn::applet::GetPopFromInteractiveOutChannelEvent(nn::applet::LibraryAppletHandle)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet37WaitPopFromInteractiveOutChannelEventENS0_19LibraryAppletHandleE", new Tuple<string, List<string>>("nn::applet::WaitPopFromInteractiveOutChannelEvent(nn::applet::LibraryAppletHandle)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet31RequestExitLibraryAppletAndWaitENS0_19LibraryAppletHandleE", new Tuple<string, List<string>>("nn::applet::RequestExitLibraryAppletAndWait(nn::applet::LibraryAppletHandle)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet42RequestExitLibraryAppletAndWaitOrTerminateENS0_19LibraryAppletHandleENS_8TimeSpanE", new Tuple<string, List<string>>("nn::applet::RequestExitLibraryAppletAndWaitOrTerminate(nn::applet::LibraryAppletHandle, nn::TimeSpan)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet28TakeScreenShotOfCallerAppletEv", new Tuple<string, List<string>>("nn::applet::TakeScreenShotOfCallerApplet()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet49TakeScreenShotOfOwnLayerIntoLastApplicationBufferEb", new Tuple<string, List<string>>("nn::applet::TakeScreenShotOfOwnLayerIntoLastApplicationBuffer(bool)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet48TakeScreenShotOfOwnLayerIntoLastForegroundBufferEb", new Tuple<string, List<string>>("nn::applet::TakeScreenShotOfOwnLayerIntoLastForegroundBuffer(bool)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet46TakeScreenShotOfOwnLayerIntoCallerAppletBufferEb", new Tuple<string, List<string>>("nn::applet::TakeScreenShotOfOwnLayerIntoCallerAppletBuffer(bool)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet21SetOnAddLibraryAppletEPFvNS0_19LibraryAppletHandleEE", new Tuple<string, List<string>>("nn::applet::SetOnAddLibraryApplet(void (*)(nn::applet::LibraryAppletHandle))", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet24SetOnRemoveLibraryAppletEPFvNS0_19LibraryAppletHandleEE", new Tuple<string, List<string>>("nn::applet::SetOnRemoveLibraryApplet(void (*)(nn::applet::LibraryAppletHandle))", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet41SetOutOfFocusApplicationSuspendingEnabledENS0_19LibraryAppletHandleEb", new Tuple<string, List<string>>("nn::applet::SetOutOfFocusApplicationSuspendingEnabled(nn::applet::LibraryAppletHandle, bool)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet30GetIndirectLayerConsumerHandleENS0_19LibraryAppletHandleE", new Tuple<string, List<string>>("nn::applet::GetIndirectLayerConsumerHandle(nn::applet::LibraryAppletHandle)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appleteqERKNS0_13StorageHandleES3_", new Tuple<string, List<string>>("nn::applet::operator==(nn::applet::StorageHandle const&, nn::applet::StorageHandle const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appletneERKNS0_13StorageHandleES3_", new Tuple<string, List<string>>("nn::applet::operator!=(nn::applet::StorageHandle const&, nn::applet::StorageHandle const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appletL20InvalidStorageHandleE", new Tuple<string, List<string>>("nn::applet::InvalidStorageHandle", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet13CreateStorageEPNS0_13StorageHandleEm", new Tuple<string, List<string>>("nn::applet::CreateStorage(nn::applet::StorageHandle*, unsigned long)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet18CreateLargeStorageEPNS0_13StorageHandleEPvmb", new Tuple<string, List<string>>("nn::applet::CreateLargeStorage(nn::applet::StorageHandle*, void*, unsigned long, bool)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet21CreateTransferStorageEPNS0_13StorageHandleEPvm", new Tuple<string, List<string>>("nn::applet::CreateTransferStorage(nn::applet::StorageHandle*, void*, unsigned long)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet14ReleaseStorageENS0_13StorageHandleE", new Tuple<string, List<string>>("nn::applet::ReleaseStorage(nn::applet::StorageHandle)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet14GetStorageSizeENS0_13StorageHandleE", new Tuple<string, List<string>>("nn::applet::GetStorageSize(nn::applet::StorageHandle)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet14WriteToStorageENS0_13StorageHandleElPKvm", new Tuple<string, List<string>>("nn::applet::WriteToStorage(nn::applet::StorageHandle, long, void const*, unsigned long)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet15ReadFromStorageENS0_13StorageHandleElPvm", new Tuple<string, List<string>>("nn::applet::ReadFromStorage(nn::applet::StorageHandle, long, void*, unsigned long)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet13CreateStorageEPNS0_13StorageHandleEj", new Tuple<string, List<string>>("nn::applet::CreateStorage(nn::applet::StorageHandle*, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet18CreateLargeStorageEPNS0_13StorageHandleEPvjb", new Tuple<string, List<string>>("nn::applet::CreateLargeStorage(nn::applet::StorageHandle*, void*, unsigned int, bool)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet21CreateTransferStorageEPNS0_13StorageHandleEPvj", new Tuple<string, List<string>>("nn::applet::CreateTransferStorage(nn::applet::StorageHandle*, void*, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet14WriteToStorageENS0_13StorageHandleExPKvj", new Tuple<string, List<string>>("nn::applet::WriteToStorage(nn::applet::StorageHandle, long long, void const*, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet15ReadFromStorageENS0_13StorageHandleExPvj", new Tuple<string, List<string>>("nn::applet::ReadFromStorage(nn::applet::StorageHandle, long long, void*, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appletL29LaunchableApplicationCountMaxE", new Tuple<string, List<string>>("nn::applet::LaunchableApplicationCountMax", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appletL30LaunchableSystemAppletCountMaxE", new Tuple<string, List<string>>("nn::applet::LaunchableSystemAppletCountMax", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appletL19StartupParamSizeMaxE", new Tuple<string, List<string>>("nn::applet::StartupParamSizeMax", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appletL18ReturnValueSizeMaxE", new Tuple<string, List<string>>("nn::applet::ReturnValueSizeMax", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appletL21RequestCommandSizeMaxE", new Tuple<string, List<string>>("nn::applet::RequestCommandSizeMax", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6appletL19ReplyMessageSizeMaxE", new Tuple<string, List<string>>("nn::applet::ReplyMessageSizeMax", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn6applet18AppletIdentityInfo13IsApplicationEv", new Tuple<string, List<string>>("nn::applet::AppletIdentityInfo::IsApplication() const", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn6applet18AppletIdentityInfo19IsSystemApplicationEv", new Tuple<string, List<string>>("nn::applet::AppletIdentityInfo::IsSystemApplication() const", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet18AppletIdentityInfo4MakeENS0_8AppletIdE", new Tuple<string, List<string>>("nn::applet::AppletIdentityInfo::Make(nn::applet::AppletId)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet18AppletIdentityInfo4MakeENS_3ncm13ApplicationIdE", new Tuple<string, List<string>>("nn::applet::AppletIdentityInfo::Make(nn::ncm::ApplicationId)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn6applet18AppletIdentityInfo4MakeENS_3ncm19SystemApplicationIdE", new Tuple<string, List<string>>("nn::applet::AppletIdentityInfo::Make(nn::ncm::SystemApplicationId)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3bpc22InitializeWakeupConfigEv", new Tuple<string, List<string>>("nn::bpc::InitializeWakeupConfig()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3bpc20FinalizeWakeupConfigEv", new Tuple<string, List<string>>("nn::bpc::FinalizeWakeupConfig()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3bpc17CreateWakeupTimerEPiNS_8TimeSpanENS0_15WakeupTimerTypeE", new Tuple<string, List<string>>("nn::bpc::CreateWakeupTimer(int*, nn::TimeSpan, nn::bpc::WakeupTimerType)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3bpc17CreateWakeupTimerEPiNS_8TimeSpanE", new Tuple<string, List<string>>("nn::bpc::CreateWakeupTimer(int*, nn::TimeSpan)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3bpc17CancelWakeupTimerEi", new Tuple<string, List<string>>("nn::bpc::CancelWakeupTimer(int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3bpcL26MinWakeupIntervalInSecondsE", new Tuple<string, List<string>>("nn::bpc::MinWakeupIntervalInSeconds", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4diag36InitializeSystemProcessAbortObserverEv", new Tuple<string, List<string>>("nn::diag::InitializeSystemProcessAbortObserver()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npnsL14UsernameLengthE", new Tuple<string, List<string>>("nn::npns::UsernameLength", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npnsL14PasswordLengthE", new Tuple<string, List<string>>("nn::npns::PasswordLength", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npnsL16ApplicationIdRawE", new Tuple<string, List<string>>("nn::npns::ApplicationIdRaw", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns19InitializeForSystemEv", new Tuple<string, List<string>>("nn::npns::InitializeForSystem()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns17FinalizeForSystemEv", new Tuple<string, List<string>>("nn::npns::FinalizeForSystem()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns17ListenUndeliveredEv", new Tuple<string, List<string>>("nn::npns::ListenUndelivered()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns14SubscribeTopicEPKc", new Tuple<string, List<string>>("nn::npns::SubscribeTopic(char const*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns16UnsubscribeTopicEPKc", new Tuple<string, List<string>>("nn::npns::UnsubscribeTopic(char const*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns17QueryIsTopicExistEPbPKc", new Tuple<string, List<string>>("nn::npns::QueryIsTopicExist(bool*, char const*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns11CreateTokenEPNS0_17NotificationTokenERKNS_7account3UidENS_13ApplicationIdE", new Tuple<string, List<string>>("nn::npns::CreateToken(nn::npns::NotificationToken*, nn::account::Uid const&, nn::ApplicationId)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns12DestroyTokenERKNS_7account3UidENS_13ApplicationIdE", new Tuple<string, List<string>>("nn::npns::DestroyToken(nn::account::Uid const&, nn::ApplicationId)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns17UploadTokenToBaaSERKNS_7account3UidE", new Tuple<string, List<string>>("nn::npns::UploadTokenToBaaS(nn::account::Uid const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns19DestroyTokenForBaaSERKNS_7account3UidE", new Tuple<string, List<string>>("nn::npns::DestroyTokenForBaaS(nn::account::Uid const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns6GetJidEPcm", new Tuple<string, List<string>>("nn::npns::GetJid(char*, unsigned long)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns9CreateJidEv", new Tuple<string, List<string>>("nn::npns::CreateJid()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns10DestroyJidEv", new Tuple<string, List<string>>("nn::npns::DestroyJid()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns9AttachJidEPKcS2_", new Tuple<string, List<string>>("nn::npns::AttachJid(char const*, char const*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns9DetachJidEPcmS1_m", new Tuple<string, List<string>>("nn::npns::DetachJid(char*, unsigned long, char*, unsigned long)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns7SuspendEv", new Tuple<string, List<string>>("nn::npns::Suspend()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns6ResumeEv", new Tuple<string, List<string>>("nn::npns::Resume()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns13GetStatisticsEPNS0_20StatisticsCollectionINS0_20StatisticsDefinitionEEE", new Tuple<string, List<string>>("nn::npns::GetStatistics(nn::npns::StatisticsCollection<nn::npns::StatisticsDefinition>*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns26BindPlayReportRequestEventEPNS_2os15SystemEventTypeENS1_14EventClearModeE", new Tuple<string, List<string>>("nn::npns::BindPlayReportRequestEvent(nn::os::SystemEventType*, nn::os::EventClearMode)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns6GetJidEPcj", new Tuple<string, List<string>>("nn::npns::GetJid(char*, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns9DetachJidEPcjS1_j", new Tuple<string, List<string>>("nn::npns::DetachJid(char*, unsigned int, char*, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns20StatisticsDefinition4SizeE", new Tuple<string, List<string>>("nn::npns::StatisticsDefinition::Size", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns20StatisticsDefinition9GetStringENS0_14StatisticsKindE", new Tuple<string, List<string>>("nn::npns::StatisticsDefinition::GetString(nn::npns::StatisticsKind)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns20StatisticsCollectionC2ERKNS0_20StatisticsCollectionIT_EE", new Tuple<string, List<string>>("nn::npns::StatisticsCollection::StatisticsCollection", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns20StatisticsCollectionC1ERKNS0_20StatisticsCollectionIT_EE", new Tuple<string, List<string>>("nn::npns::StatisticsCollection::StatisticsCollection", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns20StatisticsCollectionC2EONS0_20StatisticsCollectionIT_EE", new Tuple<string, List<string>>("nn::npns::StatisticsCollection::StatisticsCollection", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns20StatisticsCollectionC1EONS0_20StatisticsCollectionIT_EE", new Tuple<string, List<string>>("nn::npns::StatisticsCollection::StatisticsCollection", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns20StatisticsCollectionC2Ev", new Tuple<string, List<string>>("nn::npns::StatisticsCollection::StatisticsCollection()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns20StatisticsCollectionC1Ev", new Tuple<string, List<string>>("nn::npns::StatisticsCollection::StatisticsCollection()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npnsL11TokenLengthE", new Tuple<string, List<string>>("nn::npns::TokenLength", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npnsL15TopicNameLengthE", new Tuple<string, List<string>>("nn::npns::TopicNameLength", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npnsL16PayloadMaxLengthE", new Tuple<string, List<string>>("nn::npns::PayloadMaxLength", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npnsL16ReceiverIdLengthE", new Tuple<string, List<string>>("nn::npns::ReceiverIdLength", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npnsL9JidLengthE", new Tuple<string, List<string>>("nn::npns::JidLength", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npnsL7VersionE", new Tuple<string, List<string>>("nn::npns::Version", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns10ReceiverId6CreateERKNS_7account3UidE", new Tuple<string, List<string>>("nn::npns::ReceiverId::Create(nn::account::Uid const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns10ReceiverId13CreateDefaultEv", new Tuple<string, List<string>>("nn::npns::ReceiverId::CreateDefault()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns16NotificationDataC2Ev", new Tuple<string, List<string>>("nn::npns::NotificationData::NotificationData()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4npns16NotificationDataC1Ev", new Tuple<string, List<string>>("nn::npns::NotificationData::NotificationData()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn4npns16NotificationData16GetApplicationIdEv", new Tuple<string, List<string>>("nn::npns::NotificationData::GetApplicationId() const", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn4npns16NotificationData13GetReceiverIdEv", new Tuple<string, List<string>>("nn::npns::NotificationData::GetReceiverId() const", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn4npns16NotificationData6GetUidEv", new Tuple<string, List<string>>("nn::npns::NotificationData::GetUid() const", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn4npns16NotificationData10GetPayloadEv", new Tuple<string, List<string>>("nn::npns::NotificationData::GetPayload() const", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn4npns16NotificationData14GetPayloadSizeEv", new Tuple<string, List<string>>("nn::npns::NotificationData::GetPayloadSize() const", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2ns10InitializeEv", new Tuple<string, List<string>>("nn::ns::Initialize()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2ns8FinalizeEv", new Tuple<string, List<string>>("nn::ns::Finalize()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2ns32GetApplicationDownloadTaskStatusEPNS0_29ApplicationDownloadTaskStatusENS_3ncm13ApplicationIdE", new Tuple<string, List<string>>("nn::ns::GetApplicationDownloadTaskStatus(nn::ns::ApplicationDownloadTaskStatus*, nn::ncm::ApplicationId)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2ns19DownloadApplicationENS_3ncm13ApplicationIdENS1_9StorageIdE", new Tuple<string, List<string>>("nn::ns::DownloadApplication(nn::ncm::ApplicationId, nn::ncm::StorageId)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2ns26RequestDownloadApplicationEPNS0_11AsyncResultENS_3ncm13ApplicationIdENS3_9StorageIdE", new Tuple<string, List<string>>("nn::ns::RequestDownloadApplication(nn::ns::AsyncResult*, nn::ncm::ApplicationId, nn::ncm::StorageId)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2ns27RequestDownloadAddOnContentEPNS0_11AsyncResultENS_3ncm13ApplicationIdEPNS3_14ContentMetaKeyEiNS3_9StorageIdE", new Tuple<string, List<string>>("nn::ns::RequestDownloadAddOnContent(nn::ns::AsyncResult*, nn::ncm::ApplicationId, nn::ncm::ContentMetaKey*, int, nn::ncm::StorageId)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2ns30DeleteApplicationContentEntityERKNS_3ncm14ContentMetaKeyE", new Tuple<string, List<string>>("nn::ns::DeleteApplicationContentEntity(nn::ncm::ContentMetaKey const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2ns6detailL35PortNameForRetailInteractiveDisplayE", new Tuple<string, List<string>>("nn::ns::detail::PortNameForRetailInteractiveDisplay", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2ns17CreateUserAccountENS_7account8NicknameEPvm", new Tuple<string, List<string>>("nn::ns::CreateUserAccount(nn::account::Nickname, void*, unsigned long)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2ns17CreateUserAccountENS_7account8NicknameEPvj", new Tuple<string, List<string>>("nn::ns::CreateUserAccount(nn::account::Nickname, void*, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm10InitializeEv", new Tuple<string, List<string>>("nn::psm::Initialize()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm8FinalizeEv", new Tuple<string, List<string>>("nn::psm::Finalize()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm26GetBatteryChargePercentageEv", new Tuple<string, List<string>>("nn::psm::GetBatteryChargePercentage()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm14GetChargerTypeEv", new Tuple<string, List<string>>("nn::psm::GetChargerType()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm25GetChargerTypeChangeEventEPNS_2os15SystemEventTypeE", new Tuple<string, List<string>>("nn::psm::GetChargerTypeChangeEvent(nn::os::SystemEventType*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm28AcquireControllerPowerSupplyEv", new Tuple<string, List<string>>("nn::psm::AcquireControllerPowerSupply()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm28ReleaseControllerPowerSupplyEv", new Tuple<string, List<string>>("nn::psm::ReleaseControllerPowerSupply()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm11OpenSessionEPNS0_7SessionE", new Tuple<string, List<string>>("nn::psm::OpenSession(nn::psm::Session*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm12CloseSessionEPNS0_7SessionE", new Tuple<string, List<string>>("nn::psm::CloseSession(nn::psm::Session*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm20BindStateChangeEventEPNS_2os15SystemEventTypeEPNS0_7SessionE", new Tuple<string, List<string>>("nn::psm::BindStateChangeEvent(nn::os::SystemEventType*, nn::psm::Session*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm22UnbindStateChangeEventEPNS0_7SessionE", new Tuple<string, List<string>>("nn::psm::UnbindStateChangeEvent(nn::psm::Session*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm32SetChargerTypeChangeEventEnabledEPNS0_7SessionEb", new Tuple<string, List<string>>("nn::psm::SetChargerTypeChangeEventEnabled(nn::psm::Session*, bool)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm32SetPowerSupplyChangeEventEnabledEPNS0_7SessionEb", new Tuple<string, List<string>>("nn::psm::SetPowerSupplyChangeEventEnabled(nn::psm::Session*, bool)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm40SetBatteryVoltageStateChangeEventEnabledEPNS0_7SessionEb", new Tuple<string, List<string>>("nn::psm::SetBatteryVoltageStateChangeEventEnabled(nn::psm::Session*, bool)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm32EnableEnoughPowerChargeEmulationEv", new Tuple<string, List<string>>("nn::psm::EnableEnoughPowerChargeEmulation()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm33DisableEnoughPowerChargeEmulationEv", new Tuple<string, List<string>>("nn::psm::DisableEnoughPowerChargeEmulation()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm25EnableFastBatteryChargingEv", new Tuple<string, List<string>>("nn::psm::EnableFastBatteryCharging()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm26DisableFastBatteryChargingEv", new Tuple<string, List<string>>("nn::psm::DisableFastBatteryCharging()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm22GetBatteryVoltageStateEv", new Tuple<string, List<string>>("nn::psm::GetBatteryVoltageState()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm29GetRawBatteryChargePercentageEv", new Tuple<string, List<string>>("nn::psm::GetRawBatteryChargePercentage()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3psm21IsEnoughPowerSuppliedEv", new Tuple<string, List<string>>("nn::psm::IsEnoughPowerSupplied()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings7factory15GetSerialNumberEPNS1_12SerialNumberE", new Tuple<string, List<string>>("nn::settings::factory::GetSerialNumber(nn::settings::factory::SerialNumber*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system19IsAutoUpdateEnabledEv", new Tuple<string, List<string>>("nn::settings::system::IsAutoUpdateEnabled()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system20SetAutoUpdateEnabledEb", new Tuple<string, List<string>>("nn::settings::system::SetAutoUpdateEnabled(bool)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn8settings6system15FirmwareVersion20GetComparableVersionEv", new Tuple<string, List<string>>("nn::settings::system::FirmwareVersion::GetComparableVersion() const", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6systemeqERKNS1_15FirmwareVersionES4_", new Tuple<string, List<string>>("nn::settings::system::operator==(nn::settings::system::FirmwareVersion const&, nn::settings::system::FirmwareVersion const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6systemneERKNS1_15FirmwareVersionES4_", new Tuple<string, List<string>>("nn::settings::system::operator!=(nn::settings::system::FirmwareVersion const&, nn::settings::system::FirmwareVersion const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6systemltERKNS1_15FirmwareVersionES4_", new Tuple<string, List<string>>("nn::settings::system::operator<(nn::settings::system::FirmwareVersion const&, nn::settings::system::FirmwareVersion const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6systemgtERKNS1_15FirmwareVersionES4_", new Tuple<string, List<string>>("nn::settings::system::operator>(nn::settings::system::FirmwareVersion const&, nn::settings::system::FirmwareVersion const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6systemleERKNS1_15FirmwareVersionES4_", new Tuple<string, List<string>>("nn::settings::system::operator<=(nn::settings::system::FirmwareVersion const&, nn::settings::system::FirmwareVersion const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6systemgeERKNS1_15FirmwareVersionES4_", new Tuple<string, List<string>>("nn::settings::system::operator>=(nn::settings::system::FirmwareVersion const&, nn::settings::system::FirmwareVersion const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system18GetFirmwareVersionEPNS1_15FirmwareVersionE", new Tuple<string, List<string>>("nn::settings::system::GetFirmwareVersion(nn::settings::system::FirmwareVersion*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings15GetLanguageCodeEPNS0_12LanguageCodeE", new Tuple<string, List<string>>("nn::settings::GetLanguageCode(nn::settings::LanguageCode*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system15SetLanguageCodeERKNS0_12LanguageCodeE", new Tuple<string, List<string>>("nn::settings::system::SetLanguageCode(nn::settings::LanguageCode const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system13GetRegionCodeEPNS1_10RegionCodeE", new Tuple<string, List<string>>("nn::settings::system::GetRegionCode(nn::settings::system::RegionCode*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system13SetRegionCodeENS1_10RegionCodeE", new Tuple<string, List<string>>("nn::settings::system::SetRegionCode(nn::settings::system::RegionCode)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system16GetSleepSettingsEPNS1_13SleepSettingsE", new Tuple<string, List<string>>("nn::settings::system::GetSleepSettings(nn::settings::system::SleepSettings*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system16SetSleepSettingsERKNS1_13SleepSettingsE", new Tuple<string, List<string>>("nn::settings::system::SetSleepSettings(nn::settings::system::SleepSettings const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system17GetLockScreenFlagEv", new Tuple<string, List<string>>("nn::settings::system::GetLockScreenFlag()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system17SetLockScreenFlagEb", new Tuple<string, List<string>>("nn::settings::system::SetLockScreenFlag(bool)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system13GetColorSetIdEv", new Tuple<string, List<string>>("nn::settings::system::GetColorSetId()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system13SetColorSetIdEi", new Tuple<string, List<string>>("nn::settings::system::SetColorSetId(int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system24GetBatteryPercentageFlagEv", new Tuple<string, List<string>>("nn::settings::system::GetBatteryPercentageFlag()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system24SetBatteryPercentageFlagEb", new Tuple<string, List<string>>("nn::settings::system::SetBatteryPercentageFlag(bool)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system24GetInitialLaunchSettingsEPNS1_21InitialLaunchSettingsE", new Tuple<string, List<string>>("nn::settings::system::GetInitialLaunchSettings(nn::settings::system::InitialLaunchSettings*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system24SetInitialLaunchSettingsERKNS1_21InitialLaunchSettingsE", new Tuple<string, List<string>>("nn::settings::system::SetInitialLaunchSettings(nn::settings::system::InitialLaunchSettings const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system17GetDeviceNickNameEPNS1_14DeviceNickNameE", new Tuple<string, List<string>>("nn::settings::system::GetDeviceNickName(nn::settings::system::DeviceNickName*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system17SetDeviceNickNameERKNS1_14DeviceNickNameE", new Tuple<string, List<string>>("nn::settings::system::SetDeviceNickName(nn::settings::system::DeviceNickName const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system20GetAppletLaunchFlagsEPNS_4util10BitFlagSetILi32ENS1_16AppletLaunchFlagEEE", new Tuple<string, List<string>>("nn::settings::system::GetAppletLaunchFlags(nn::util::BitFlagSet<32, nn::settings::system::AppletLaunchFlag>*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system20SetAppletLaunchFlagsERKNS_4util10BitFlagSetILi32ENS1_16AppletLaunchFlagEEE", new Tuple<string, List<string>>("nn::settings::system::SetAppletLaunchFlags(nn::util::BitFlagSet<32, nn::settings::system::AppletLaunchFlag> const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system12GetQuestFlagEv", new Tuple<string, List<string>>("nn::settings::system::GetQuestFlag()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system12SetQuestFlagEb", new Tuple<string, List<string>>("nn::settings::system::SetQuestFlag(bool)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system32GetWirelessCertificationFileSizeEv", new Tuple<string, List<string>>("nn::settings::system::GetWirelessCertificationFileSize()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system28GetWirelessCertificationFileEPvm", new Tuple<string, List<string>>("nn::settings::system::GetWirelessCertificationFile(void*, unsigned long)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system28GetWirelessCertificationFileEPvj", new Tuple<string, List<string>>("nn::settings::system::GetWirelessCertificationFile(void*, unsigned int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system13GetTvSettingsEPNS1_10TvSettingsE", new Tuple<string, List<string>>("nn::settings::system::GetTvSettings(nn::settings::system::TvSettings*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system13SetTvSettingsERKNS1_10TvSettingsE", new Tuple<string, List<string>>("nn::settings::system::SetTvSettings(nn::settings::system::TvSettings const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system7GetEdidEPNS1_4EdidE", new Tuple<string, List<string>>("nn::settings::system::GetEdid(nn::settings::system::Edid*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn8settings6system7SetEdidERKNS1_4EdidE", new Tuple<string, List<string>>("nn::settings::system::SetEdid(nn::settings::system::Edid const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time30EnsureNetworkClockAvailabilityEv", new Tuple<string, List<string>>("nn::time::EnsureNetworkClockAvailability()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time38CancelEnsuringNetworkClockAvailabilityEv", new Tuple<string, List<string>>("nn::time::CancelEnsuringNetworkClockAvailability()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time39AsyncEnsureNetworkClockAvailabilityTaskC2ERKS1_", new Tuple<string, List<string>>("nn::time::AsyncEnsureNetworkClockAvailabilityTask::AsyncEnsureNetworkClockAvailabilityTask(nn::time::AsyncEnsureNetworkClockAvailabilityTask const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time39AsyncEnsureNetworkClockAvailabilityTaskC1ERKS1_", new Tuple<string, List<string>>("nn::time::AsyncEnsureNetworkClockAvailabilityTask::AsyncEnsureNetworkClockAvailabilityTask(nn::time::AsyncEnsureNetworkClockAvailabilityTask const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time39AsyncEnsureNetworkClockAvailabilityTaskaSERKS1_", new Tuple<string, List<string>>("nn::time::AsyncEnsureNetworkClockAvailabilityTask::operator=(nn::time::AsyncEnsureNetworkClockAvailabilityTask const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time39AsyncEnsureNetworkClockAvailabilityTaskC2EOS1_", new Tuple<string, List<string>>("nn::time::AsyncEnsureNetworkClockAvailabilityTask::AsyncEnsureNetworkClockAvailabilityTask(nn::time::AsyncEnsureNetworkClockAvailabilityTask&&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time39AsyncEnsureNetworkClockAvailabilityTaskC1EOS1_", new Tuple<string, List<string>>("nn::time::AsyncEnsureNetworkClockAvailabilityTask::AsyncEnsureNetworkClockAvailabilityTask(nn::time::AsyncEnsureNetworkClockAvailabilityTask&&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time39AsyncEnsureNetworkClockAvailabilityTaskaSEOS1_", new Tuple<string, List<string>>("nn::time::AsyncEnsureNetworkClockAvailabilityTask::operator=(nn::time::AsyncEnsureNetworkClockAvailabilityTask&&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time39AsyncEnsureNetworkClockAvailabilityTaskC2Ev", new Tuple<string, List<string>>("nn::time::AsyncEnsureNetworkClockAvailabilityTask::AsyncEnsureNetworkClockAvailabilityTask()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time39AsyncEnsureNetworkClockAvailabilityTaskC1Ev", new Tuple<string, List<string>>("nn::time::AsyncEnsureNetworkClockAvailabilityTask::AsyncEnsureNetworkClockAvailabilityTask()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time39AsyncEnsureNetworkClockAvailabilityTaskD2Ev", new Tuple<string, List<string>>("nn::time::AsyncEnsureNetworkClockAvailabilityTask::~AsyncEnsureNetworkClockAvailabilityTask()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time39AsyncEnsureNetworkClockAvailabilityTaskD1Ev", new Tuple<string, List<string>>("nn::time::AsyncEnsureNetworkClockAvailabilityTask::~AsyncEnsureNetworkClockAvailabilityTask()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time39AsyncEnsureNetworkClockAvailabilityTask10InitializeENS_2os14EventClearModeE", new Tuple<string, List<string>>("nn::time::AsyncEnsureNetworkClockAvailabilityTask::Initialize(nn::os::EventClearMode)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time39AsyncEnsureNetworkClockAvailabilityTask9StartTaskEv", new Tuple<string, List<string>>("nn::time::AsyncEnsureNetworkClockAvailabilityTask::StartTask()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time39AsyncEnsureNetworkClockAvailabilityTask9GetResultEv", new Tuple<string, List<string>>("nn::time::AsyncEnsureNetworkClockAvailabilityTask::GetResult()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time39AsyncEnsureNetworkClockAvailabilityTask14GetFinishEventEv", new Tuple<string, List<string>>("nn::time::AsyncEnsureNetworkClockAvailabilityTask::GetFinishEvent()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time39AsyncEnsureNetworkClockAvailabilityTask6CancelEv", new Tuple<string, List<string>>("nn::time::AsyncEnsureNetworkClockAvailabilityTask::Cancel()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time17InitializeForMenuEv", new Tuple<string, List<string>>("nn::time::InitializeForMenu()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time20LoadLocationNameListEPiPNS0_12LocationNameEii", new Tuple<string, List<string>>("nn::time::LoadLocationNameList(int*, nn::time::LocationName*, int, int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time25GetTotalLocationNameCountEv", new Tuple<string, List<string>>("nn::time::GetTotalLocationNameCount()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time21SetDeviceLocationNameERKNS0_12LocationNameE", new Tuple<string, List<string>>("nn::time::SetDeviceLocationName(nn::time::LocationName const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time22GetTimeZoneRuleVersionEPNS0_19TimeZoneRuleVersionE", new Tuple<string, List<string>>("nn::time::GetTimeZoneRuleVersion(nn::time::TimeZoneRuleVersion*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time38SetStandardLocalSystemClockCurrentTimeERKNS0_9PosixTimeE", new Tuple<string, List<string>>("nn::time::SetStandardLocalSystemClockCurrentTime(nn::time::PosixTime const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time34SetStandardLocalSystemClockContextERKNS0_18SystemClockContextE", new Tuple<string, List<string>>("nn::time::SetStandardLocalSystemClockContext(nn::time::SystemClockContext const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time52SetStandardUserSystemClockAutomaticCorrectionEnabledEb", new Tuple<string, List<string>>("nn::time::SetStandardUserSystemClockAutomaticCorrectionEnabled(bool)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time51IsStandardUserSystemClockAutomaticCorrectionEnabledEv", new Tuple<string, List<string>>("nn::time::IsStandardUserSystemClockAutomaticCorrectionEnabled()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn4time19TimeZoneRuleVersion4SizeE", new Tuple<string, List<string>>("nn::time::TimeZoneRuleVersion::Size", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2vi33GetIndirectImageMemoryRequirementEPmS1_ii", new Tuple<string, List<string>>("nn::vi::GetIndirectImageMemoryRequirement(unsigned long*, unsigned long*, int, int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2vi16GetIndirectImageEPmS1_Pvmmii", new Tuple<string, List<string>>("nn::vi::GetIndirectImage(unsigned long*, unsigned long*, void*, unsigned long, unsigned long, int, int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2vi16GetIndirectImageEPmS1_Pvmmiiffff", new Tuple<string, List<string>>("nn::vi::GetIndirectImage(unsigned long*, unsigned long*, void*, unsigned long, unsigned long, int, int, float, float, float, float)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2vi33GetIndirectImageMemoryRequirementEPjS1_ii", new Tuple<string, List<string>>("nn::vi::GetIndirectImageMemoryRequirement(unsigned int*, unsigned int*, int, int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2vi16GetIndirectImageEPjS1_Pvjyii", new Tuple<string, List<string>>("nn::vi::GetIndirectImage(unsigned int*, unsigned int*, void*, unsigned int, unsigned long long, int, int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2vi16GetIndirectImageEPjS1_Pvjyiiffff", new Tuple<string, List<string>>("nn::vi::GetIndirectImage(unsigned int*, unsigned int*, void*, unsigned int, unsigned long long, int, int, float, float, float, float)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3mii23IsIncludedCharacterCodeENS0_10FontRegionEt", new Tuple<string, List<string>>("nn::mii::IsIncludedCharacterCode(nn::mii::FontRegion, unsigned short)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3mii15IsValidNicknameENS0_10FontRegionEPKti", new Tuple<string, List<string>>("nn::mii::IsValidNickname(nn::mii::FontRegion, unsigned short const*, int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3mii32ReplaceWrongNicknameForStoreDataEPNS0_9StoreDataE", new Tuple<string, List<string>>("nn::mii::ReplaceWrongNicknameForStoreData(nn::mii::StoreData*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3ridL20InvalidApplicationIdE", new Tuple<string, List<string>>("nn::rid::InvalidApplicationId", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid18ApplicationUpdaterC2Ev", new Tuple<string, List<string>>("nn::rid::ApplicationUpdater::ApplicationUpdater()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid18ApplicationUpdaterC1Ev", new Tuple<string, List<string>>("nn::rid::ApplicationUpdater::ApplicationUpdater()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid18ApplicationUpdaterD2Ev", new Tuple<string, List<string>>("nn::rid::ApplicationUpdater::~ApplicationUpdater()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid18ApplicationUpdaterD1Ev", new Tuple<string, List<string>>("nn::rid::ApplicationUpdater::~ApplicationUpdater()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid18ApplicationUpdater7ExecuteEPiPNS0_14DownloadResultEiPNS0_16ApplicationAssetEib", new Tuple<string, List<string>>("nn::rid::ApplicationUpdater::Execute(int*, nn::rid::DownloadResult*, int, nn::rid::ApplicationAsset*, int, bool)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid18ApplicationUpdater6CancelEv", new Tuple<string, List<string>>("nn::rid::ApplicationUpdater::Cancel()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid18ApplicationUpdater11GetProgressEv", new Tuple<string, List<string>>("nn::rid::ApplicationUpdater::GetProgress()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid18ApplicationUpdater16IsCommitRequiredEv", new Tuple<string, List<string>>("nn::rid::ApplicationUpdater::IsCommitRequired()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid18ApplicationUpdater11ExecuteImplEPiPNS0_14DownloadResultEiPNS0_16ApplicationAssetEib", new Tuple<string, List<string>>("nn::rid::ApplicationUpdater::ExecuteImpl(int*, nn::rid::DownloadResult*, int, nn::rid::ApplicationAsset*, int, bool)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid18ApplicationUpdater14UpdateProgressENS0_25ApplicationUpdateProgress5StateEll", new Tuple<string, List<string>>("nn::rid::ApplicationUpdater::UpdateProgress(nn::rid::ApplicationUpdateProgress::State, long, long)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid18ApplicationUpdater22MaxApplicationAocCountE", new Tuple<string, List<string>>("nn::rid::ApplicationUpdater::MaxApplicationAocCount", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid18ApplicationUpdater14UpdateProgressENS0_25ApplicationUpdateProgress5StateExx", new Tuple<string, List<string>>("nn::rid::ApplicationUpdater::UpdateProgress(nn::rid::ApplicationUpdateProgress::State, long long, long long)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid11CheckSdCardEv", new Tuple<string, List<string>>("nn::rid::CheckSdCard()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid17ControllerUpdaterC2Ev", new Tuple<string, List<string>>("nn::rid::ControllerUpdater::ControllerUpdater()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid17ControllerUpdaterC1Ev", new Tuple<string, List<string>>("nn::rid::ControllerUpdater::ControllerUpdater()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid17ControllerUpdaterD2Ev", new Tuple<string, List<string>>("nn::rid::ControllerUpdater::~ControllerUpdater()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid17ControllerUpdaterD1Ev", new Tuple<string, List<string>>("nn::rid::ControllerUpdater::~ControllerUpdater()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid17ControllerUpdater7ExecuteEv", new Tuple<string, List<string>>("nn::rid::ControllerUpdater::Execute()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid17ControllerUpdater6CancelEv", new Tuple<string, List<string>>("nn::rid::ControllerUpdater::Cancel()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid17ControllerUpdater11GetProgressEv", new Tuple<string, List<string>>("nn::rid::ControllerUpdater::GetProgress()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid17ControllerUpdater11ExecuteImplEv", new Tuple<string, List<string>>("nn::rid::ControllerUpdater::ExecuteImpl()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid17ControllerUpdater14UpdateProgressENS0_24ControllerUpdateProgress5StateEll", new Tuple<string, List<string>>("nn::rid::ControllerUpdater::UpdateProgress(nn::rid::ControllerUpdateProgress::State, long, long)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid17ControllerUpdater14UpdateProgressENS0_24ControllerUpdateProgress5StateExx", new Tuple<string, List<string>>("nn::rid::ControllerUpdater::UpdateProgress(nn::rid::ControllerUpdateProgress::State, long long, long long)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid10InitializeENS_3ncm13ApplicationIdE", new Tuple<string, List<string>>("nn::rid::Initialize(nn::ncm::ApplicationId)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid26RequestToLaunchApplicationENS_3ncm13ApplicationIdE", new Tuple<string, List<string>>("nn::rid::RequestToLaunchApplication(nn::ncm::ApplicationId)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid26RequestToLaunchApplicationENS_3ncm13ApplicationIdEPKNS_6applet28ApplicationAttributeForQuestE", new Tuple<string, List<string>>("nn::rid::RequestToLaunchApplication(nn::ncm::ApplicationId, nn::applet::ApplicationAttributeForQuest const*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid34RequestToLaunchGameCardApplicationEv", new Tuple<string, List<string>>("nn::rid::RequestToLaunchGameCardApplication()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid15ListApplicationEPNS_3ncm13ApplicationIdEi", new Tuple<string, List<string>>("nn::rid::ListApplication(nn::ncm::ApplicationId*, int)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid11MenuUpdaterC2Ev", new Tuple<string, List<string>>("nn::rid::MenuUpdater::MenuUpdater()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid11MenuUpdaterC1Ev", new Tuple<string, List<string>>("nn::rid::MenuUpdater::MenuUpdater()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid11MenuUpdaterD2Ev", new Tuple<string, List<string>>("nn::rid::MenuUpdater::~MenuUpdater()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid11MenuUpdaterD1Ev", new Tuple<string, List<string>>("nn::rid::MenuUpdater::~MenuUpdater()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid11MenuUpdater7ExecuteEv", new Tuple<string, List<string>>("nn::rid::MenuUpdater::Execute()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid11MenuUpdater6CancelEv", new Tuple<string, List<string>>("nn::rid::MenuUpdater::Cancel()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid11MenuUpdater8GetStateEv", new Tuple<string, List<string>>("nn::rid::MenuUpdater::GetState()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid11MenuUpdater11ExecuteImplEv", new Tuple<string, List<string>>("nn::rid::MenuUpdater::ExecuteImpl()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid11MenuUpdater11UpdateStateENS0_15MenuUpdateStateE", new Tuple<string, List<string>>("nn::rid::MenuUpdater::UpdateState(nn::rid::MenuUpdateState)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid22CheckContentsIntegrityEv", new Tuple<string, List<string>>("nn::rid::CheckContentsIntegrity()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid12DeleteAllMiiEv", new Tuple<string, List<string>>("nn::rid::DeleteAllMii()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid15DeleteAllAlbumsEv", new Tuple<string, List<string>>("nn::rid::DeleteAllAlbums()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid6RebootEv", new Tuple<string, List<string>>("nn::rid::Reboot()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid35CheckRetailInteractiveDisplayDeviceEv", new Tuple<string, List<string>>("nn::rid::CheckRetailInteractiveDisplayDevice()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid14MinimumStartUpEv", new Tuple<string, List<string>>("nn::rid::MinimumStartUp()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid7StartUpEv", new Tuple<string, List<string>>("nn::rid::StartUp()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid13SystemUpdaterC2Ev", new Tuple<string, List<string>>("nn::rid::SystemUpdater::SystemUpdater()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid13SystemUpdaterC1Ev", new Tuple<string, List<string>>("nn::rid::SystemUpdater::SystemUpdater()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid13SystemUpdaterD2Ev", new Tuple<string, List<string>>("nn::rid::SystemUpdater::~SystemUpdater()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid13SystemUpdaterD1Ev", new Tuple<string, List<string>>("nn::rid::SystemUpdater::~SystemUpdater()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid13SystemUpdater7ExecuteEv", new Tuple<string, List<string>>("nn::rid::SystemUpdater::Execute()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid13SystemUpdater6CancelEv", new Tuple<string, List<string>>("nn::rid::SystemUpdater::Cancel()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid13SystemUpdater11GetProgressEv", new Tuple<string, List<string>>("nn::rid::SystemUpdater::GetProgress()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid13SystemUpdater11ExecuteImplEv", new Tuple<string, List<string>>("nn::rid::SystemUpdater::ExecuteImpl()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid13SystemUpdater14UpdateProgressENS0_20SystemUpdateProgress5StateEll", new Tuple<string, List<string>>("nn::rid::SystemUpdater::UpdateProgress(nn::rid::SystemUpdateProgress::State, long, long)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3rid13SystemUpdater14UpdateProgressENS0_20SystemUpdateProgress5StateExx", new Tuple<string, List<string>>("nn::rid::SystemUpdater::UpdateProgress(nn::rid::SystemUpdateProgress::State, long long, long long)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3web35ShowApplicationLegalInformationPageEPNS0_26OfflineHtmlPageReturnValueERKNS0_38ShowApplicationLegalInformationPageArgE", new Tuple<string, List<string>>("nn::web::ShowApplicationLegalInformationPage(nn::web::OfflineHtmlPageReturnValue*, nn::web::ShowApplicationLegalInformationPageArg const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3web18ShowSystemDataPageEPNS0_26OfflineHtmlPageReturnValueERKNS0_21ShowSystemDataPageArgE", new Tuple<string, List<string>>("nn::web::ShowSystemDataPage(nn::web::OfflineHtmlPageReturnValue*, nn::web::ShowSystemDataPageArg const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3web40GetOfflineHtmlPageReturnValueFromStorageEPNS0_26OfflineHtmlPageReturnValueERKNS_6applet13StorageHandleE", new Tuple<string, List<string>>("nn::web::GetOfflineHtmlPageReturnValueFromStorage(nn::web::OfflineHtmlPageReturnValue*, nn::applet::StorageHandle const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3web36GetOfflinePageReturnValueFromStorageEPNS0_26OfflineHtmlPageReturnValueERKNS_6applet13StorageHandleE", new Tuple<string, List<string>>("nn::web::GetOfflinePageReturnValueFromStorage(nn::web::OfflineHtmlPageReturnValue*, nn::applet::StorageHandle const&)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3web38ShowApplicationLegalInformationPageArg21DocumentPathMaxLengthE", new Tuple<string, List<string>>("nn::web::ShowApplicationLegalInformationPageArg::DocumentPathMaxLength", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3web38ShowApplicationLegalInformationPageArgC2ERKNS_13ApplicationIdEPKc", new Tuple<string, List<string>>("nn::web::ShowApplicationLegalInformationPageArg::ShowApplicationLegalInformationPageArg(nn::ApplicationId const&, char const*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3web38ShowApplicationLegalInformationPageArgC1ERKNS_13ApplicationIdEPKc", new Tuple<string, List<string>>("nn::web::ShowApplicationLegalInformationPageArg::ShowApplicationLegalInformationPageArg(nn::ApplicationId const&, char const*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3web38ShowApplicationLegalInformationPageArg15PushToInChannelENS_6applet19LibraryAppletHandleE", new Tuple<string, List<string>>("nn::web::ShowApplicationLegalInformationPageArg::PushToInChannel(nn::applet::LibraryAppletHandle) const", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3web38ShowApplicationLegalInformationPageArg8DataSizeE", new Tuple<string, List<string>>("nn::web::ShowApplicationLegalInformationPageArg::DataSize", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3web38ShowApplicationLegalInformationPageArgC2Ev", new Tuple<string, List<string>>("nn::web::ShowApplicationLegalInformationPageArg::ShowApplicationLegalInformationPageArg()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3web38ShowApplicationLegalInformationPageArgC1Ev", new Tuple<string, List<string>>("nn::web::ShowApplicationLegalInformationPageArg::ShowApplicationLegalInformationPageArg()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3web21ShowSystemDataPageArg21DocumentPathMaxLengthE", new Tuple<string, List<string>>("nn::web::ShowSystemDataPageArg::DocumentPathMaxLength", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3web21ShowSystemDataPageArgC2ERKNS_3ncm12SystemDataIdEPKc", new Tuple<string, List<string>>("nn::web::ShowSystemDataPageArg::ShowSystemDataPageArg(nn::ncm::SystemDataId const&, char const*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3web21ShowSystemDataPageArgC1ERKNS_3ncm12SystemDataIdEPKc", new Tuple<string, List<string>>("nn::web::ShowSystemDataPageArg::ShowSystemDataPageArg(nn::ncm::SystemDataId const&, char const*)", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZNK2nn3web21ShowSystemDataPageArg15PushToInChannelENS_6applet19LibraryAppletHandleE", new Tuple<string, List<string>>("nn::web::ShowSystemDataPageArg::PushToInChannel(nn::applet::LibraryAppletHandle) const", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3web21ShowSystemDataPageArg8DataSizeE", new Tuple<string, List<string>>("nn::web::ShowSystemDataPageArg::DataSize", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3web21ShowSystemDataPageArgC2Ev", new Tuple<string, List<string>>("nn::web::ShowSystemDataPageArg::ShowSystemDataPageArg()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn3web21ShowSystemDataPageArgC1Ev", new Tuple<string, List<string>>("nn::web::ShowSystemDataPageArg::ShowSystemDataPageArg()", new List<string>() { "4_BundleRules_NX_Private_RetailInteractiveDisplay_RetailInteractiveDisplay" }) },
                        { "_ZN2nn2fs13MountSaveDataEPKcNS_13ApplicationIdERKNS_7account3UidE", new Tuple<string, List<string>>("nn::fs::MountSaveData(char const*, nn::ApplicationId, nn::account::Uid const&)", new List<string>() { "4_BundleRules_NX_Private_SaveDataWithApplicationId_SaveDataWithApplicationId" }) },
                        { "_ZN2nn2ec28RequestPurchaseAuthorizationERKNS_7account10UserHandleEPKc", new Tuple<string, List<string>>("nn::ec::RequestPurchaseAuthorization(nn::account::UserHandle const&, char const*)", new List<string>() { "4_BundleDefinitions_NX_ShopApiPurchaseAuthorization" }) },
                        { "_ZN2nn3hid44IsUnintendedHomeButtonInputProtectionEnabledERKj", new Tuple<string, List<string>>("nn::hid::IsUnintendedHomeButtonInputProtectionEnabled(unsigned int const&)", new List<string>() { "4_BundleRules_NX_Private_UnintendedHomeButtonInputProtection_UnintendedHomeButtonInputProtection" }) },
                        { "_ZN2nn3hid41EnableUnintendedHomeButtonInputProtectionERKjb", new Tuple<string, List<string>>("nn::hid::EnableUnintendedHomeButtonInputProtection(unsigned int const&, bool)", new List<string>() { "4_BundleRules_NX_Private_UnintendedHomeButtonInputProtection_UnintendedHomeButtonInputProtection" }) },
                        { "_ZN2nn2osL21ThreadSuspendCountMaxE", new Tuple<string, List<string>>("nn::os::ThreadSuspendCountMax", new List<string>() { "4_BundleRules_Generic_Private_Unity_unity" }) },
                        { "_ZN2nn2os13SuspendThreadEPNS0_10ThreadTypeE", new Tuple<string, List<string>>("nn::os::SuspendThread(nn::os::ThreadType*)", new List<string>() { "4_BundleRules_Generic_Private_Unity_unity" }) },
                        { "_ZN2nn2os12ResumeThreadEPNS0_10ThreadTypeE", new Tuple<string, List<string>>("nn::os::ResumeThread(nn::os::ThreadType*)", new List<string>() { "4_BundleRules_Generic_Private_Unity_unity" }) },
                        { "_ZN2nn2os21GetThreadSuspendCountEPKNS0_10ThreadTypeE", new Tuple<string, List<string>>("nn::os::GetThreadSuspendCount(nn::os::ThreadType const*)", new List<string>() { "4_BundleRules_Generic_Private_Unity_unity" }) },
                        { "_ZN2nn2os16GetThreadContextEPNS0_24ThreadContextInfoAarch64EPKNS0_10ThreadTypeE", new Tuple<string, List<string>>("nn::os::GetThreadContext(nn::os::ThreadContextInfoAarch64*, nn::os::ThreadType const*)", new List<string>() { "4_BundleRules_Generic_Private_Unity_unity" }) },
                        { "_ZN2nn2oe25BeginMediaPlaybackSectionEv", new Tuple<string, List<string>>("nn::oe::BeginMediaPlaybackSection()", new List<string>() { "4_BundleDefinitions_NX_MediaPlaybackSectionApi" }) },
                        { "_ZN2nn2oe23EndMediaPlaybackSectionEv", new Tuple<string, List<string>>("nn::oe::EndMediaPlaybackSection()", new List<string>() { "4_BundleDefinitions_NX_MediaPlaybackSectionApi" }) },
                        { "_ZN2nn2oe26GetHdcpAuthenticationStateEv", new Tuple<string, List<string>>("nn::oe::GetHdcpAuthenticationState()", new List<string>() { "4_BundleRules_NX_Private_Hdcp_Hdcp" }) },
                        { "_ZN2nn2oe37GetHdcpAuthenticationStateChangeEventEPNS_2os11SystemEventE", new Tuple<string, List<string>>("nn::oe::GetHdcpAuthenticationStateChangeEvent(nn::os::SystemEvent*)", new List<string>() { "4_BundleRules_NX_Private_Hdcp_Hdcp" }) },
                        { "_ZN2nn4nifm28GetCurrentAccessPointChannelEPt", new Tuple<string, List<string>>("nn::nifm::GetCurrentAccessPointChannel(unsigned short*)", new List<string>() { "4_BundleRules_Generic_Private_WirelessConnectionInfo_WirelessConnectionInfo" }) },
                    }
                },
                {
                    "5", // SDKのメジャーバージョン
                    new Dictionary<string, Tuple<string, List<string>>> // <マングル名,<デマングル名,マングル名に対応するtitleタグのリスト>>
                    {
                        { "_ZN2nn2oe18ReportUserIsActiveEv", new Tuple<string, List<string>>("nn::oe::ReportUserIsActive()", new List<string>() { "5_BundleDefinitions_NX_OeReportUserIsActive" }) },
                        { "_ZN2nn2oe29BeginAutoSleepDisabledSectionEv", new Tuple<string, List<string>>("nn::oe::BeginAutoSleepDisabledSection()", new List<string>() { "5_BundleDefinitions_NX_OeDisableAutoSleep" }) },
                        { "_ZN2nn2oe27EndAutoSleepDisabledSectionEv", new Tuple<string, List<string>>("nn::oe::EndAutoSleepDisabledSection()", new List<string>() { "5_BundleDefinitions_NX_OeDisableAutoSleep" }) },
                        { "_ZN2nn2oe19IsAutoSleepDisabledEv", new Tuple<string, List<string>>("nn::oe::IsAutoSleepDisabled()", new List<string>() { "5_BundleDefinitions_NX_OeDisableAutoSleep" }) },
                        { "_ZN2nn2oe23BeginBlockingHomeButtonEv", new Tuple<string, List<string>>("nn::oe::BeginBlockingHomeButton()", new List<string>() { "5_BundleRules_NX_Private_BlockingHomeButton_BlockingHomeButton" }) },
                        { "_ZN2nn2oe21EndBlockingHomeButtonEv", new Tuple<string, List<string>>("nn::oe::EndBlockingHomeButton()", new List<string>() { "5_BundleRules_NX_Private_BlockingHomeButton_BlockingHomeButton" }) },
                        { "_ZN2nn5audio17SetAudioInEnabledEb", new Tuple<string, List<string>>("nn::audio::SetAudioInEnabled(bool)", new List<string>() { "5_BundleDefinitions_NX_AudioIn" }) },
                        { "_ZN2nn5audio16IsAudioInEnabledEv", new Tuple<string, List<string>>("nn::audio::IsAudioInEnabled()", new List<string>() { "5_BundleDefinitions_NX_AudioIn" }) },
                        { "_ZN2nn2oeL54PerformanceConfiguration_Cpu1020MhzGpu460MhzEmc1331MhzE", new Tuple<string, List<string>>("nn::oe::PerformanceConfiguration_Cpu1020MhzGpu460MhzEmc1331Mhz", new List<string>() { "5_BundleRules_NX_Private_BatteryDrainingPerformance_BatteryDrainingPerformance" }) },
                        { "_ZN2nn9bluetoothL13AddressLengthE", new Tuple<string, List<string>>("nn::bluetooth::AddressLength", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth7AddresseqERKS1_", new Tuple<string, List<string>>("nn::bluetooth::Address::operator==(nn::bluetooth::Address const&) const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth7AddressneERKS1_", new Tuple<string, List<string>>("nn::bluetooth::Address::operator!=(nn::bluetooth::Address const&) const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetoothL33BleScanParameterId_TestPeripheralE", new Tuple<string, List<string>>("nn::bluetooth::BleScanParameterId_TestPeripheral", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth13GattAttributeC2Ev", new Tuple<string, List<string>>("nn::bluetooth::GattAttribute::GattAttribute()", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth13GattAttributeC1Ev", new Tuple<string, List<string>>("nn::bluetooth::GattAttribute::GattAttribute()", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth13GattAttributeC2ERKNS0_17GattAttributeUuidEtj", new Tuple<string, List<string>>("nn::bluetooth::GattAttribute::GattAttribute(nn::bluetooth::GattAttributeUuid const&, unsigned short, unsigned int)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth13GattAttributeC1ERKNS0_17GattAttributeUuidEtj", new Tuple<string, List<string>>("nn::bluetooth::GattAttribute::GattAttribute(nn::bluetooth::GattAttributeUuid const&, unsigned short, unsigned int)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth13GattAttributeD2Ev", new Tuple<string, List<string>>("nn::bluetooth::GattAttribute::~GattAttribute()", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth13GattAttributeD1Ev", new Tuple<string, List<string>>("nn::bluetooth::GattAttribute::~GattAttribute()", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth13GattAttributeD0Ev", new Tuple<string, List<string>>("nn::bluetooth::GattAttribute::~GattAttribute()", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth13GattAttribute7GetTypeEv", new Tuple<string, List<string>>("nn::bluetooth::GattAttribute::GetType() const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth13GattAttribute7GetUuidEv", new Tuple<string, List<string>>("nn::bluetooth::GattAttribute::GetUuid() const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth13GattAttribute9GetHandleEv", new Tuple<string, List<string>>("nn::bluetooth::GattAttribute::GetHandle() const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth13GattAttribute19GetConnectionHandleEv", new Tuple<string, List<string>>("nn::bluetooth::GattAttribute::GetConnectionHandle() const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth18GattCharacteristicC2Ev", new Tuple<string, List<string>>("nn::bluetooth::GattCharacteristic::GattCharacteristic()", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth18GattCharacteristicC1Ev", new Tuple<string, List<string>>("nn::bluetooth::GattCharacteristic::GattCharacteristic()", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth18GattCharacteristicC2ERKNS0_17GattAttributeUuidEtjth", new Tuple<string, List<string>>("nn::bluetooth::GattCharacteristic::GattCharacteristic(nn::bluetooth::GattAttributeUuid const&, unsigned short, unsigned int, unsigned short, unsigned char)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth18GattCharacteristicC1ERKNS0_17GattAttributeUuidEtjth", new Tuple<string, List<string>>("nn::bluetooth::GattCharacteristic::GattCharacteristic(nn::bluetooth::GattAttributeUuid const&, unsigned short, unsigned int, unsigned short, unsigned char)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth18GattCharacteristicD2Ev", new Tuple<string, List<string>>("nn::bluetooth::GattCharacteristic::~GattCharacteristic()", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth18GattCharacteristicD1Ev", new Tuple<string, List<string>>("nn::bluetooth::GattCharacteristic::~GattCharacteristic()", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth18GattCharacteristicD0Ev", new Tuple<string, List<string>>("nn::bluetooth::GattCharacteristic::~GattCharacteristic()", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth18GattCharacteristic13GetInstanceIdEv", new Tuple<string, List<string>>("nn::bluetooth::GattCharacteristic::GetInstanceId() const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth18GattCharacteristic13GetPropertiesEv", new Tuple<string, List<string>>("nn::bluetooth::GattCharacteristic::GetProperties() const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth18GattCharacteristic10GetServiceEPNS0_11GattServiceE", new Tuple<string, List<string>>("nn::bluetooth::GattCharacteristic::GetService(nn::bluetooth::GattService*) const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth18GattCharacteristic14GetDescriptorsEPNS0_14GattDescriptorEi", new Tuple<string, List<string>>("nn::bluetooth::GattCharacteristic::GetDescriptors(nn::bluetooth::GattDescriptor*, int) const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth18GattCharacteristic13GetDescriptorEPNS0_14GattDescriptorERKNS0_17GattAttributeUuidE", new Tuple<string, List<string>>("nn::bluetooth::GattCharacteristic::GetDescriptor(nn::bluetooth::GattDescriptor*, nn::bluetooth::GattAttributeUuid const&) const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth18GattCharacteristic8SetValueEPKvm", new Tuple<string, List<string>>("nn::bluetooth::GattCharacteristic::SetValue(void const*, unsigned long)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth18GattCharacteristic8GetValueEPvm", new Tuple<string, List<string>>("nn::bluetooth::GattCharacteristic::GetValue(void*, unsigned long) const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth18GattCharacteristic8SetValueEPKvj", new Tuple<string, List<string>>("nn::bluetooth::GattCharacteristic::SetValue(void const*, unsigned int)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth18GattCharacteristic8GetValueEPvj", new Tuple<string, List<string>>("nn::bluetooth::GattCharacteristic::GetValue(void*, unsigned int) const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth14GattDescriptorC2Ev", new Tuple<string, List<string>>("nn::bluetooth::GattDescriptor::GattDescriptor()", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth14GattDescriptorC1Ev", new Tuple<string, List<string>>("nn::bluetooth::GattDescriptor::GattDescriptor()", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth14GattDescriptorC2ERKNS0_17GattAttributeUuidEtj", new Tuple<string, List<string>>("nn::bluetooth::GattDescriptor::GattDescriptor(nn::bluetooth::GattAttributeUuid const&, unsigned short, unsigned int)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth14GattDescriptorC1ERKNS0_17GattAttributeUuidEtj", new Tuple<string, List<string>>("nn::bluetooth::GattDescriptor::GattDescriptor(nn::bluetooth::GattAttributeUuid const&, unsigned short, unsigned int)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth14GattDescriptorD2Ev", new Tuple<string, List<string>>("nn::bluetooth::GattDescriptor::~GattDescriptor()", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth14GattDescriptorD1Ev", new Tuple<string, List<string>>("nn::bluetooth::GattDescriptor::~GattDescriptor()", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth14GattDescriptorD0Ev", new Tuple<string, List<string>>("nn::bluetooth::GattDescriptor::~GattDescriptor()", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth14GattDescriptor10GetServiceEPNS0_11GattServiceE", new Tuple<string, List<string>>("nn::bluetooth::GattDescriptor::GetService(nn::bluetooth::GattService*) const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth14GattDescriptor17GetCharacteristicEPNS0_18GattCharacteristicE", new Tuple<string, List<string>>("nn::bluetooth::GattDescriptor::GetCharacteristic(nn::bluetooth::GattCharacteristic*) const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth14GattDescriptor8SetValueEPKvm", new Tuple<string, List<string>>("nn::bluetooth::GattDescriptor::SetValue(void const*, unsigned long)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth14GattDescriptor8GetValueEPvm", new Tuple<string, List<string>>("nn::bluetooth::GattDescriptor::GetValue(void*, unsigned long) const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth14GattDescriptor8SetValueEPKvj", new Tuple<string, List<string>>("nn::bluetooth::GattDescriptor::SetValue(void const*, unsigned int)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth14GattDescriptor8GetValueEPvj", new Tuple<string, List<string>>("nn::bluetooth::GattDescriptor::GetValue(void*, unsigned int) const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth11GattServiceC2Ev", new Tuple<string, List<string>>("nn::bluetooth::GattService::GattService()", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth11GattServiceC1Ev", new Tuple<string, List<string>>("nn::bluetooth::GattService::GattService()", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth11GattServiceC2ERKNS0_17GattAttributeUuidEtjttb", new Tuple<string, List<string>>("nn::bluetooth::GattService::GattService(nn::bluetooth::GattAttributeUuid const&, unsigned short, unsigned int, unsigned short, unsigned short, bool)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth11GattServiceC1ERKNS0_17GattAttributeUuidEtjttb", new Tuple<string, List<string>>("nn::bluetooth::GattService::GattService(nn::bluetooth::GattAttributeUuid const&, unsigned short, unsigned int, unsigned short, unsigned short, bool)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth11GattServiceD2Ev", new Tuple<string, List<string>>("nn::bluetooth::GattService::~GattService()", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth11GattServiceD1Ev", new Tuple<string, List<string>>("nn::bluetooth::GattService::~GattService()", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth11GattServiceD0Ev", new Tuple<string, List<string>>("nn::bluetooth::GattService::~GattService()", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth11GattService13GetInstanceIdEv", new Tuple<string, List<string>>("nn::bluetooth::GattService::GetInstanceId() const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth11GattService17GetEndGroupHandleEv", new Tuple<string, List<string>>("nn::bluetooth::GattService::GetEndGroupHandle() const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth11GattService16IsPrimaryServiceEv", new Tuple<string, List<string>>("nn::bluetooth::GattService::IsPrimaryService() const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth11GattService19GetIncludedServicesEPS1_i", new Tuple<string, List<string>>("nn::bluetooth::GattService::GetIncludedServices(nn::bluetooth::GattService*, int) const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth11GattService18GetCharacteristicsEPNS0_18GattCharacteristicEi", new Tuple<string, List<string>>("nn::bluetooth::GattService::GetCharacteristics(nn::bluetooth::GattCharacteristic*, int) const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth11GattService17GetCharacteristicEPNS0_18GattCharacteristicERKNS0_17GattAttributeUuidE", new Tuple<string, List<string>>("nn::bluetooth::GattService::GetCharacteristic(nn::bluetooth::GattCharacteristic*, nn::bluetooth::GattAttributeUuid const&) const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth13InitializeBleEv", new Tuple<string, List<string>>("nn::bluetooth::InitializeBle()", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth19AcquireBleScanEventEPNS_2os15SystemEventTypeE", new Tuple<string, List<string>>("nn::bluetooth::AcquireBleScanEvent(nn::os::SystemEventType*)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth19GetBleScanParameterEPNS0_27BleAdvertisePacketParameterEi", new Tuple<string, List<string>>("nn::bluetooth::GetBleScanParameter(nn::bluetooth::BleAdvertisePacketParameter*, int)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth19GetBleScanParameterEPNS0_17GattAttributeUuidEi", new Tuple<string, List<string>>("nn::bluetooth::GetBleScanParameter(nn::bluetooth::GattAttributeUuid*, int)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth19StartBleScanGeneralERKNS0_27BleAdvertisePacketParameterE", new Tuple<string, List<string>>("nn::bluetooth::StartBleScanGeneral(nn::bluetooth::BleAdvertisePacketParameter const&)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth18StopBleScanGeneralEv", new Tuple<string, List<string>>("nn::bluetooth::StopBleScanGeneral()", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth23StartBleScanSmartDeviceERKNS0_17GattAttributeUuidE", new Tuple<string, List<string>>("nn::bluetooth::StartBleScanSmartDevice(nn::bluetooth::GattAttributeUuid const&)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth22StopBleScanSmartDeviceEv", new Tuple<string, List<string>>("nn::bluetooth::StopBleScanSmartDevice()", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth16GetBleScanResultEPNS0_13BleScanResultEi", new Tuple<string, List<string>>("nn::bluetooth::GetBleScanResult(nn::bluetooth::BleScanResult*, int)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth37AcquireBleConnectionStateChangedEventEPNS_2os15SystemEventTypeE", new Tuple<string, List<string>>("nn::bluetooth::AcquireBleConnectionStateChangedEvent(nn::os::SystemEventType*)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth19ConnectToGattServerERKNS0_7AddressE", new Tuple<string, List<string>>("nn::bluetooth::ConnectToGattServer(nn::bluetooth::Address const&)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth24DisconnectFromGattServerEj", new Tuple<string, List<string>>("nn::bluetooth::DisconnectFromGattServer(unsigned int)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth24GetBleConnectionInfoListEPNS0_17BleConnectionInfoEi", new Tuple<string, List<string>>("nn::bluetooth::GetBleConnectionInfoList(nn::bluetooth::BleConnectionInfo*, int)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth31AcquireBleServiceDiscoveryEventEPNS_2os15SystemEventTypeE", new Tuple<string, List<string>>("nn::bluetooth::AcquireBleServiceDiscoveryEvent(nn::os::SystemEventType*)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth15GetGattServicesEPNS0_11GattServiceEij", new Tuple<string, List<string>>("nn::bluetooth::GetGattServices(nn::bluetooth::GattService*, int, unsigned int)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth14GetGattServiceEPNS0_11GattServiceERKNS0_17GattAttributeUuidEj", new Tuple<string, List<string>>("nn::bluetooth::GetGattService(nn::bluetooth::GattService*, nn::bluetooth::GattAttributeUuid const&, unsigned int)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth24AcquireBleMtuConfigEventEPNS_2os15SystemEventTypeE", new Tuple<string, List<string>>("nn::bluetooth::AcquireBleMtuConfigEvent(nn::os::SystemEventType*)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth15ConfigureBleMtuEjt", new Tuple<string, List<string>>("nn::bluetooth::ConfigureBleMtu(unsigned int, unsigned short)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth9GetBleMtuEj", new Tuple<string, List<string>>("nn::bluetooth::GetBleMtu(unsigned int)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth28AcquireBleGattOperationEventEPNS_2os15SystemEventTypeE", new Tuple<string, List<string>>("nn::bluetooth::AcquireBleGattOperationEvent(nn::os::SystemEventType*)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth33RegisterGattOperationNotificationERKNS0_17GattAttributeUuidE", new Tuple<string, List<string>>("nn::bluetooth::RegisterGattOperationNotification(nn::bluetooth::GattAttributeUuid const&)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth35UnregisterGattOperationNotificationERKNS0_17GattAttributeUuidE", new Tuple<string, List<string>>("nn::bluetooth::UnregisterGattOperationNotification(nn::bluetooth::GattAttributeUuid const&)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth22GetGattOperationResultEPNS0_26BleClientGattOperationInfoE", new Tuple<string, List<string>>("nn::bluetooth::GetGattOperationResult(nn::bluetooth::BleClientGattOperationInfo*)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth22ReadGattCharacteristicERKNS0_18GattCharacteristicE", new Tuple<string, List<string>>("nn::bluetooth::ReadGattCharacteristic(nn::bluetooth::GattCharacteristic const&)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth23WriteGattCharacteristicERKNS0_18GattCharacteristicE", new Tuple<string, List<string>>("nn::bluetooth::WriteGattCharacteristic(nn::bluetooth::GattCharacteristic const&)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth36EnableGattCharacteristicNotificationERKNS0_18GattCharacteristicEb", new Tuple<string, List<string>>("nn::bluetooth::EnableGattCharacteristicNotification(nn::bluetooth::GattCharacteristic const&, bool)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth18ReadGattDescriptorERKNS0_14GattDescriptorE", new Tuple<string, List<string>>("nn::bluetooth::ReadGattDescriptor(nn::bluetooth::GattDescriptor const&)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetooth19WriteGattDescriptorERKNS0_14GattDescriptorE", new Tuple<string, List<string>>("nn::bluetooth::WriteGattDescriptor(nn::bluetooth::GattDescriptor const&)", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetoothL25BleAdvertisePacketSizeMaxE", new Tuple<string, List<string>>("nn::bluetooth::BleAdvertisePacketSizeMax", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetoothL28BleAdStructurePayloadSizeMaxE", new Tuple<string, List<string>>("nn::bluetooth::BleAdStructurePayloadSizeMax", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetoothL22BleAdStructureCountMaxE", new Tuple<string, List<string>>("nn::bluetooth::BleAdStructureCountMax", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetoothL21BleScanResultCountMaxE", new Tuple<string, List<string>>("nn::bluetooth::BleScanResultCountMax", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetoothL32BleNnAdvertiseManufacturerIdSizeE", new Tuple<string, List<string>>("nn::bluetooth::BleNnAdvertiseManufacturerIdSize", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetoothL37BleNnAdvertiseManufactureClientIdSizeE", new Tuple<string, List<string>>("nn::bluetooth::BleNnAdvertiseManufactureClientIdSize", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetoothL37BleNnAdvertiseManufactureServerIdSizeE", new Tuple<string, List<string>>("nn::bluetooth::BleNnAdvertiseManufactureServerIdSize", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetoothL26BleInvalidConnectionHandleE", new Tuple<string, List<string>>("nn::bluetooth::BleInvalidConnectionHandle", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetoothL27BleConnectionCountMaxClientE", new Tuple<string, List<string>>("nn::bluetooth::BleConnectionCountMaxClient", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth17GattAttributeUuideqERKS1_", new Tuple<string, List<string>>("nn::bluetooth::GattAttributeUuid::operator==(nn::bluetooth::GattAttributeUuid const&) const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZNK2nn9bluetooth17GattAttributeUuidneERKS1_", new Tuple<string, List<string>>("nn::bluetooth::GattAttributeUuid::operator!=(nn::bluetooth::GattAttributeUuid const&) const", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetoothL27GattAttributeCountMaxClientE", new Tuple<string, List<string>>("nn::bluetooth::GattAttributeCountMaxClient", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetoothL26GattAttributeInvalidHandleE", new Tuple<string, List<string>>("nn::bluetooth::GattAttributeInvalidHandle", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetoothL47ClientCharacteristicConfigurationDescriptorUuidE", new Tuple<string, List<string>>("nn::bluetooth::ClientCharacteristicConfigurationDescriptorUuid", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetoothL13BleMtuDefaultE", new Tuple<string, List<string>>("nn::bluetooth::BleMtuDefault", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetoothL9BleMtuMaxE", new Tuple<string, List<string>>("nn::bluetooth::BleMtuMax", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetoothL25GattAttributeValueSizeMaxE", new Tuple<string, List<string>>("nn::bluetooth::GattAttributeValueSizeMax", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn9bluetoothL18BlePairingCountMaxE", new Tuple<string, List<string>>("nn::bluetooth::BlePairingCountMax", new List<string>() { "5_BundleRules_NX_Private_BluetoothApplication_BluetoothApplication" }) },
                        { "_ZN2nn3hid12GetNpadStateEPNS0_14NpadPalmaStateERKj", new Tuple<string, List<string>>("nn::hid::GetNpadState(nn::hid::NpadPalmaState*, unsigned int const&)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid13GetNpadStatesEPNS0_14NpadPalmaStateEiRKj", new Tuple<string, List<string>>("nn::hid::GetNpadStates(nn::hid::NpadPalmaState*, int, unsigned int const&)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid24GetPalmaConnectionHandleEPNS0_21PalmaConnectionHandleERKj", new Tuple<string, List<string>>("nn::hid::GetPalmaConnectionHandle(nn::hid::PalmaConnectionHandle*, unsigned int const&)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid15InitializePalmaERKNS0_21PalmaConnectionHandleE", new Tuple<string, List<string>>("nn::hid::InitializePalma(nn::hid::PalmaConnectionHandle const&)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid31BindPalmaOperationCompleteEventERKNS0_21PalmaConnectionHandleEPNS_2os15SystemEventTypeENS4_14EventClearModeE", new Tuple<string, List<string>>("nn::hid::BindPalmaOperationCompleteEvent(nn::hid::PalmaConnectionHandle const&, nn::os::SystemEventType*, nn::os::EventClearMode)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid21GetPalmaOperationInfoEPNS0_18PalmaOperationInfoERKNS0_21PalmaConnectionHandleE", new Tuple<string, List<string>>("nn::hid::GetPalmaOperationInfo(nn::hid::PalmaOperationInfo*, nn::hid::PalmaConnectionHandle const&)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid17PlayPalmaActivityERKNS0_21PalmaConnectionHandleERKt", new Tuple<string, List<string>>("nn::hid::PlayPalmaActivity(nn::hid::PalmaConnectionHandle const&, unsigned short const&)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid18SetPalmaFrModeTypeERKNS0_21PalmaConnectionHandleERKNS0_15PalmaFrModeTypeE", new Tuple<string, List<string>>("nn::hid::SetPalmaFrModeType(nn::hid::PalmaConnectionHandle const&, nn::hid::PalmaFrModeType const&)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid13ReadPalmaStepERKNS0_21PalmaConnectionHandleE", new Tuple<string, List<string>>("nn::hid::ReadPalmaStep(nn::hid::PalmaConnectionHandle const&)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid15EnablePalmaStepERKNS0_21PalmaConnectionHandleEb", new Tuple<string, List<string>>("nn::hid::EnablePalmaStep(nn::hid::PalmaConnectionHandle const&, bool)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid14ResetPalmaStepERKNS0_21PalmaConnectionHandleE", new Tuple<string, List<string>>("nn::hid::ResetPalmaStep(nn::hid::PalmaConnectionHandle const&)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid27ReadPalmaApplicationSectionERKNS0_21PalmaConnectionHandleEim", new Tuple<string, List<string>>("nn::hid::ReadPalmaApplicationSection(nn::hid::PalmaConnectionHandle const&, int, unsigned long)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid28WritePalmaApplicationSectionERKNS0_21PalmaConnectionHandleEimRKNS0_35PalmaApplicationSectionAccessBufferE", new Tuple<string, List<string>>("nn::hid::WritePalmaApplicationSection(nn::hid::PalmaConnectionHandle const&, int, unsigned long, nn::hid::PalmaApplicationSectionAccessBuffer const&)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid19ReadPalmaUniqueCodeERKNS0_21PalmaConnectionHandleE", new Tuple<string, List<string>>("nn::hid::ReadPalmaUniqueCode(nn::hid::PalmaConnectionHandle const&)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid25SetPalmaUniqueCodeInvalidERKNS0_21PalmaConnectionHandleE", new Tuple<string, List<string>>("nn::hid::SetPalmaUniqueCodeInvalid(nn::hid::PalmaConnectionHandle const&)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid23WritePalmaActivityEntryERKNS0_21PalmaConnectionHandleERKtPKNS0_18PalmaActivityEntryE", new Tuple<string, List<string>>("nn::hid::WritePalmaActivityEntry(nn::hid::PalmaConnectionHandle const&, unsigned short const&, nn::hid::PalmaActivityEntry const*)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid28WritePalmaRgbLedPatternEntryERKNS0_21PalmaConnectionHandleERKtPKvm", new Tuple<string, List<string>>("nn::hid::WritePalmaRgbLedPatternEntry(nn::hid::PalmaConnectionHandle const&, unsigned short const&, void const*, unsigned long)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid19WritePalmaWaveEntryERKNS0_21PalmaConnectionHandleERKNS0_12PalmaWaveSetERKtPKvmm", new Tuple<string, List<string>>("nn::hid::WritePalmaWaveEntry(nn::hid::PalmaConnectionHandle const&, nn::hid::PalmaWaveSet const&, unsigned short const&, void const*, unsigned long, unsigned long)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid37SetPalmaDataBaseIdentificationVersionERKNS0_21PalmaConnectionHandleEi", new Tuple<string, List<string>>("nn::hid::SetPalmaDataBaseIdentificationVersion(nn::hid::PalmaConnectionHandle const&, int)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid37GetPalmaDataBaseIdentificationVersionERKNS0_21PalmaConnectionHandleE", new Tuple<string, List<string>>("nn::hid::GetPalmaDataBaseIdentificationVersion(nn::hid::PalmaConnectionHandle const&)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid19SuspendPalmaFeatureERKNS0_21PalmaConnectionHandleERKNS_4util10BitFlagSetILi32ENS0_12PalmaFeatureEEE", new Tuple<string, List<string>>("nn::hid::SuspendPalmaFeature(nn::hid::PalmaConnectionHandle const&, nn::util::BitFlagSet<32, nn::hid::PalmaFeature> const&)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid16ReadPalmaPlayLogERKNS0_21PalmaConnectionHandleERKt", new Tuple<string, List<string>>("nn::hid::ReadPalmaPlayLog(nn::hid::PalmaConnectionHandle const&, unsigned short const&)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid17ResetPalmaPlayLogERKNS0_21PalmaConnectionHandleERKt", new Tuple<string, List<string>>("nn::hid::ResetPalmaPlayLog(nn::hid::PalmaConnectionHandle const&, unsigned short const&)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid27EnablePairedPalmaConnectionEv", new Tuple<string, List<string>>("nn::hid::EnablePairedPalmaConnection()", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid28DisablePairedPalmaConnectionEv", new Tuple<string, List<string>>("nn::hid::DisablePairedPalmaConnection()", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid24EnableAnyPalmaConnectionEv", new Tuple<string, List<string>>("nn::hid::EnableAnyPalmaConnection()", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid25DisableAnyPalmaConnectionEv", new Tuple<string, List<string>>("nn::hid::DisableAnyPalmaConnection()", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid9PairPalmaERKNS0_21PalmaConnectionHandleE", new Tuple<string, List<string>>("nn::hid::PairPalma(nn::hid::PalmaConnectionHandle const&)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid17SetPalmaBoostModeEb", new Tuple<string, List<string>>("nn::hid::SetPalmaBoostMode(bool)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid27ReadPalmaApplicationSectionERKNS0_21PalmaConnectionHandleEij", new Tuple<string, List<string>>("nn::hid::ReadPalmaApplicationSection(nn::hid::PalmaConnectionHandle const&, int, unsigned int)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid28WritePalmaApplicationSectionERKNS0_21PalmaConnectionHandleEijRKNS0_35PalmaApplicationSectionAccessBufferE", new Tuple<string, List<string>>("nn::hid::WritePalmaApplicationSection(nn::hid::PalmaConnectionHandle const&, int, unsigned int, nn::hid::PalmaApplicationSectionAccessBuffer const&)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid28WritePalmaRgbLedPatternEntryERKNS0_21PalmaConnectionHandleERKtPKvj", new Tuple<string, List<string>>("nn::hid::WritePalmaRgbLedPatternEntry(nn::hid::PalmaConnectionHandle const&, unsigned short const&, void const*, unsigned int)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hid19WritePalmaWaveEntryERKNS0_21PalmaConnectionHandleERKNS0_12PalmaWaveSetERKtPKvjj", new Tuple<string, List<string>>("nn::hid::WritePalmaWaveEntry(nn::hid::PalmaConnectionHandle const&, nn::hid::PalmaWaveSet const&, unsigned short const&, void const*, unsigned int, unsigned int)", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hidL27PalmaApplicationSectionSizeE", new Tuple<string, List<string>>("nn::hid::PalmaApplicationSectionSize", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hidL40PalmaApplicationSectionAccessUnitSizeMaxE", new Tuple<string, List<string>>("nn::hid::PalmaApplicationSectionAccessUnitSizeMax", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hidL24PalmaWaveSetSmallSizeMaxE", new Tuple<string, List<string>>("nn::hid::PalmaWaveSetSmallSizeMax", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hidL25PalmaWaveSetMediumSizeMaxE", new Tuple<string, List<string>>("nn::hid::PalmaWaveSetMediumSizeMax", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hidL24PalmaWaveSetLargeSizeMaxE", new Tuple<string, List<string>>("nn::hid::PalmaWaveSetLargeSizeMax", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn3hidL36DataBaseIdentificationVersionInvalidE", new Tuple<string, List<string>>("nn::hid::DataBaseIdentificationVersionInvalid", new List<string>() { "5_BundleRules_NX_Private_Palma_Palma" }) },
                        { "_ZN2nn9bluetoothL27BleScanParameterId_HoloholoE", new Tuple<string, List<string>>("nn::bluetooth::BleScanParameterId_Holoholo", new List<string>() { "5_BundleRules_NX_Private_Holoholo_Holoholo" }) },
                        { "_ZN2nn2oe28RequestToRelaunchApplicationEv", new Tuple<string, List<string>>("nn::oe::RequestToRelaunchApplication()", new List<string>() { "5_BundleRules_NX_Private_RelaunchApplication_RelaunchApplication" }) },
                        { "_ZN2nn6hidbusL28JoyPollingModeWorkBufferSizeE", new Tuple<string, List<string>>("nn::hidbus::JoyPollingModeWorkBufferSize", new List<string>() { "5_BundleRules_NX_Private_Hidbus_hidbus" }) },
                        { "_ZN2nn6hidbusL32JoyPollingModeMaxReceiveDataSizeE", new Tuple<string, List<string>>("nn::hidbus::JoyPollingModeMaxReceiveDataSize", new List<string>() { "5_BundleRules_NX_Private_Hidbus_hidbus" }) },
                        { "_ZN2nn6hidbus12GetBusHandleEPNS0_9BusHandleERKjNS0_7BusTypeE", new Tuple<string, List<string>>("nn::hidbus::GetBusHandle(nn::hidbus::BusHandle*, unsigned int const&, nn::hidbus::BusType)", new List<string>() { "5_BundleRules_NX_Private_Hidbus_hidbus" }) },
                        { "_ZN2nn6hidbus10InitializeERKNS0_9BusHandleE", new Tuple<string, List<string>>("nn::hidbus::Initialize(nn::hidbus::BusHandle const&)", new List<string>() { "5_BundleRules_NX_Private_Hidbus_hidbus" }) },
                        { "_ZN2nn6hidbus8FinalizeERKNS0_9BusHandleE", new Tuple<string, List<string>>("nn::hidbus::Finalize(nn::hidbus::BusHandle const&)", new List<string>() { "5_BundleRules_NX_Private_Hidbus_hidbus" }) },
                        { "_ZN2nn6hidbus20EnableExternalDeviceEbjRKNS0_9BusHandleE", new Tuple<string, List<string>>("nn::hidbus::EnableExternalDevice(bool, unsigned int, nn::hidbus::BusHandle const&)", new List<string>() { "5_BundleRules_NX_Private_Hidbus_hidbus" }) },
                        { "_ZN2nn6hidbus14SendAndReceiveEPmPvmRKNS0_9BusHandleEPKvm", new Tuple<string, List<string>>("nn::hidbus::SendAndReceive(unsigned long*, void*, unsigned long, nn::hidbus::BusHandle const&, void const*, unsigned long)", new List<string>() { "5_BundleRules_NX_Private_Hidbus_hidbus" }) },
                        { "_ZN2nn6hidbus27EnableJoyPollingReceiveModeERKNS0_9BusHandleEPKvmPvmNS0_14JoyPollingModeE", new Tuple<string, List<string>>("nn::hidbus::EnableJoyPollingReceiveMode(nn::hidbus::BusHandle const&, void const*, unsigned long, void*, unsigned long, nn::hidbus::JoyPollingMode)", new List<string>() { "5_BundleRules_NX_Private_Hidbus_hidbus" }) },
                        { "_ZN2nn6hidbus28DisableJoyPollingReceiveModeERKNS0_9BusHandleE", new Tuple<string, List<string>>("nn::hidbus::DisableJoyPollingReceiveMode(nn::hidbus::BusHandle const&)", new List<string>() { "5_BundleRules_NX_Private_Hidbus_hidbus" }) },
                        { "_ZN2nn6hidbus25GetJoyPollingReceivedDataEPNS0_22JoyPollingReceivedDataERKNS0_9BusHandleE", new Tuple<string, List<string>>("nn::hidbus::GetJoyPollingReceivedData(nn::hidbus::JoyPollingReceivedData*, nn::hidbus::BusHandle const&)", new List<string>() { "5_BundleRules_NX_Private_Hidbus_hidbus" }) },
                        { "_ZN2nn6hidbus25GetJoyPollingReceivedDataEPNS0_22JoyPollingReceivedDataEiRKNS0_9BusHandleE", new Tuple<string, List<string>>("nn::hidbus::GetJoyPollingReceivedData(nn::hidbus::JoyPollingReceivedData*, int, nn::hidbus::BusHandle const&)", new List<string>() { "5_BundleRules_NX_Private_Hidbus_hidbus" }) },
                        { "_ZN2nn6hidbus14SendAndReceiveEPjPvjRKNS0_9BusHandleEPKvj", new Tuple<string, List<string>>("nn::hidbus::SendAndReceive(unsigned int*, void*, unsigned int, nn::hidbus::BusHandle const&, void const*, unsigned int)", new List<string>() { "5_BundleRules_NX_Private_Hidbus_hidbus" }) },
                        { "_ZN2nn6hidbus27EnableJoyPollingReceiveModeERKNS0_9BusHandleEPKvjPvjNS0_14JoyPollingModeE", new Tuple<string, List<string>>("nn::hidbus::EnableJoyPollingReceiveMode(nn::hidbus::BusHandle const&, void const*, unsigned int, void*, unsigned int, nn::hidbus::JoyPollingMode)", new List<string>() { "5_BundleRules_NX_Private_Hidbus_hidbus" }) },
                        { "_ZN2nn5albumL25SharePostedLastUrlSizeMaxE", new Tuple<string, List<string>>("nn::album::SharePostedLastUrlSizeMax", new List<string>() { "5_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album21GetSharePostedLastUrlEPcmRKNS0_7ShareIdE", new Tuple<string, List<string>>("nn::album::GetSharePostedLastUrl(char*, unsigned long, nn::album::ShareId const&)", new List<string>() { "5_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album21GetSharePostedLastUrlEPcjRKNS0_7ShareIdE", new Tuple<string, List<string>>("nn::album::GetSharePostedLastUrl(char*, unsigned int, nn::album::ShareId const&)", new List<string>() { "5_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5albumL29SharePostedServiceNameSizeMaxE", new Tuple<string, List<string>>("nn::album::SharePostedServiceNameSizeMax", new List<string>() { "5_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5albumL25SharePostedEntryIdSizeMaxE", new Tuple<string, List<string>>("nn::album::SharePostedEntryIdSizeMax", new List<string>() { "5_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album25GetSharePostedServiceNameEPcmRKNS0_7ShareIdE", new Tuple<string, List<string>>("nn::album::GetSharePostedServiceName(char*, unsigned long, nn::album::ShareId const&)", new List<string>() { "5_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album21GetSharePostedEntryIdEPcmRKNS0_7ShareIdE", new Tuple<string, List<string>>("nn::album::GetSharePostedEntryId(char*, unsigned long, nn::album::ShareId const&)", new List<string>() { "5_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album25GetSharePostedServiceNameEPcjRKNS0_7ShareIdE", new Tuple<string, List<string>>("nn::album::GetSharePostedServiceName(char*, unsigned int, nn::album::ShareId const&)", new List<string>() { "5_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album21GetSharePostedEntryIdEPcjRKNS0_7ShareIdE", new Tuple<string, List<string>>("nn::album::GetSharePostedEntryId(char*, unsigned int, nn::album::ShareId const&)", new List<string>() { "5_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album22SaveAndShareScreenshotEPNS0_7ShareIdEPKvmNS0_9ImageSizeENS0_17AlbumReportOptionERKNS_7account3UidE", new Tuple<string, List<string>>("nn::album::SaveAndShareScreenshot(nn::album::ShareId*, void const*, unsigned long, nn::album::ImageSize, nn::album::AlbumReportOption, nn::account::Uid const&)", new List<string>() { "5_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album22SaveAndShareScreenshotEPNS0_7ShareIdEPKvmNS0_9ImageSizeENS0_16ImageOrientationENS0_17AlbumReportOptionERKNS_7account3UidE", new Tuple<string, List<string>>("nn::album::SaveAndShareScreenshot(nn::album::ShareId*, void const*, unsigned long, nn::album::ImageSize, nn::album::ImageOrientation, nn::album::AlbumReportOption, nn::account::Uid const&)", new List<string>() { "5_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album22SaveAndShareScreenshotEPNS0_7ShareIdEPKvmNS0_9ImageSizeENS0_17AlbumReportOptionERKNS_7account3UidEPKc", new Tuple<string, List<string>>("nn::album::SaveAndShareScreenshot(nn::album::ShareId*, void const*, unsigned long, nn::album::ImageSize, nn::album::AlbumReportOption, nn::account::Uid const&, char const*)", new List<string>() { "5_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album22SaveAndShareScreenshotEPNS0_7ShareIdEPKvmNS0_9ImageSizeENS0_16ImageOrientationENS0_17AlbumReportOptionERKNS_7account3UidEPKc", new Tuple<string, List<string>>("nn::album::SaveAndShareScreenshot(nn::album::ShareId*, void const*, unsigned long, nn::album::ImageSize, nn::album::ImageOrientation, nn::album::AlbumReportOption, nn::account::Uid const&, char const*)", new List<string>() { "5_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album22SaveAndShareScreenshotEPNS0_7ShareIdEPKvjNS0_9ImageSizeENS0_17AlbumReportOptionERKNS_7account3UidE", new Tuple<string, List<string>>("nn::album::SaveAndShareScreenshot(nn::album::ShareId*, void const*, unsigned int, nn::album::ImageSize, nn::album::AlbumReportOption, nn::account::Uid const&)", new List<string>() { "5_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album22SaveAndShareScreenshotEPNS0_7ShareIdEPKvjNS0_9ImageSizeENS0_16ImageOrientationENS0_17AlbumReportOptionERKNS_7account3UidE", new Tuple<string, List<string>>("nn::album::SaveAndShareScreenshot(nn::album::ShareId*, void const*, unsigned int, nn::album::ImageSize, nn::album::ImageOrientation, nn::album::AlbumReportOption, nn::account::Uid const&)", new List<string>() { "5_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album22SaveAndShareScreenshotEPNS0_7ShareIdEPKvjNS0_9ImageSizeENS0_17AlbumReportOptionERKNS_7account3UidEPKc", new Tuple<string, List<string>>("nn::album::SaveAndShareScreenshot(nn::album::ShareId*, void const*, unsigned int, nn::album::ImageSize, nn::album::AlbumReportOption, nn::account::Uid const&, char const*)", new List<string>() { "5_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn5album22SaveAndShareScreenshotEPNS0_7ShareIdEPKvjNS0_9ImageSizeENS0_16ImageOrientationENS0_17AlbumReportOptionERKNS_7account3UidEPKc", new Tuple<string, List<string>>("nn::album::SaveAndShareScreenshot(nn::album::ShareId*, void const*, unsigned int, nn::album::ImageSize, nn::album::ImageOrientation, nn::album::AlbumReportOption, nn::account::Uid const&, char const*)", new List<string>() { "5_BundleRules_NX_Private_Album_album" }) },
                        { "_ZN2nn3hid29IsUsbFullKeyControllerEnabledEv", new Tuple<string, List<string>>("nn::hid::IsUsbFullKeyControllerEnabled()", new List<string>() { "5_BundleRules_NX_Private_UsbFullKey_UsbFullKey" }) },
                        { "_ZN2nn3hid26EnableUsbFullKeyControllerEb", new Tuple<string, List<string>>("nn::hid::EnableUsbFullKeyController(bool)", new List<string>() { "5_BundleRules_NX_Private_UsbFullKey_UsbFullKey" }) },
                        { "_ZN2nn3hid31IsUsbFullKeyControllerConnectedERKj", new Tuple<string, List<string>>("nn::hid::IsUsbFullKeyControllerConnected(unsigned int const&)", new List<string>() { "5_BundleRules_NX_Private_UsbFullKey_UsbFullKey" }) },
                        { "_ZN2nn4util28GetCountryFromIso31661Alpha2EPNS0_7CountryEPKcm", new Tuple<string, List<string>>("nn::util::GetCountryFromIso31661Alpha2(nn::util::Country*, char const*, unsigned long)", new List<string>() { "5_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZN2nn4util28GetCountryFromIso31661Alpha2EPNS0_7CountryEPKcj", new Tuple<string, List<string>>("nn::util::GetCountryFromIso31661Alpha2(nn::util::Country*, char const*, unsigned int)", new List<string>() { "5_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZN2nn7account29LoadCachedNintendoAccountInfoEPNS0_25CachedNintendoAccountInfoERKNS0_10UserHandleEPvm", new Tuple<string, List<string>>("nn::account::LoadCachedNintendoAccountInfo(nn::account::CachedNintendoAccountInfo*, nn::account::UserHandle const&, void*, unsigned long)", new List<string>() { "5_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZN2nn7account25CachedNintendoAccountInfoC2Ev", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::CachedNintendoAccountInfo()", new List<string>() { "5_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZN2nn7account25CachedNintendoAccountInfoC1Ev", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::CachedNintendoAccountInfo()", new List<string>() { "5_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZNK2nn7account25CachedNintendoAccountInfo11GetBirthdayEPm", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::GetBirthday(unsigned long*) const", new List<string>() { "5_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZNK2nn7account25CachedNintendoAccountInfo9GetGenderEPm", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::GetGender(unsigned long*) const", new List<string>() { "5_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZNK2nn7account25CachedNintendoAccountInfo10GetCountryEPm", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::GetCountry(unsigned long*) const", new List<string>() { "5_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZN2nn7account29LoadCachedNintendoAccountInfoEPNS0_25CachedNintendoAccountInfoERKNS0_10UserHandleEPvj", new Tuple<string, List<string>>("nn::account::LoadCachedNintendoAccountInfo(nn::account::CachedNintendoAccountInfo*, nn::account::UserHandle const&, void*, unsigned int)", new List<string>() { "5_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZNK2nn7account25CachedNintendoAccountInfo11GetBirthdayEPj", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::GetBirthday(unsigned int*) const", new List<string>() { "5_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZNK2nn7account25CachedNintendoAccountInfo9GetGenderEPj", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::GetGender(unsigned int*) const", new List<string>() { "5_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZNK2nn7account25CachedNintendoAccountInfo10GetCountryEPj", new Tuple<string, List<string>>("nn::account::CachedNintendoAccountInfo::GetCountry(unsigned int*) const", new List<string>() { "5_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZN2nn7accountL46RequiredBufferSizeForCachedNintendoAccountInfoE", new Tuple<string, List<string>>("nn::account::RequiredBufferSizeForCachedNintendoAccountInfo", new List<string>() { "5_BundleRules_Generic_Private_CachedNintendoAccountInfo_cached-nintendo-account-info" }) },
                        { "_ZN2nn5albumL28AlbumScreenShotImageDataSizeE", new Tuple<string, List<string>>("nn::album::AlbumScreenShotImageDataSize", new List<string>() { "5_BundleRules_NX_Private_Album_album-albumAccess" }) },
                        { "_ZN2nn5albumL33RequiredWorkMemorySizeToLoadImageE", new Tuple<string, List<string>>("nn::album::RequiredWorkMemorySizeToLoadImage", new List<string>() { "5_BundleRules_NX_Private_Album_album-albumAccess" }) },
                        { "_ZN2nn5albumL27AlbumThumbnailImageDataSizeE", new Tuple<string, List<string>>("nn::album::AlbumThumbnailImageDataSize", new List<string>() { "5_BundleRules_NX_Private_Album_album-albumAccess" }) },
                        { "_ZN2nn5albumL42RequiredWorkMemorySizeToLoadThumbnailImageE", new Tuple<string, List<string>>("nn::album::RequiredWorkMemorySizeToLoadThumbnailImage", new List<string>() { "5_BundleRules_NX_Private_Album_album-albumAccess" }) },
                        { "_ZN2nn5albumL21MovieFileDataUnitSizeE", new Tuple<string, List<string>>("nn::album::MovieFileDataUnitSize", new List<string>() { "5_BundleRules_NX_Private_Album_album-albumAccess" }) },
                        { "_ZN2nn5albumL20AlbumUserDataSizeMaxE", new Tuple<string, List<string>>("nn::album::AlbumUserDataSizeMax", new List<string>() { "5_BundleRules_NX_Private_Album_album-albumAccess" }) },
                        { "_ZN2nn5album26GetAlbumScreenshotFileListEPiPNS0_14AlbumFileEntryEi", new Tuple<string, List<string>>("nn::album::GetAlbumScreenshotFileList(int*, nn::album::AlbumFileEntry*, int)", new List<string>() { "5_BundleRules_NX_Private_Album_album-albumAccess" }) },
                        { "_ZN2nn5album21GetAlbumMovieFileListEPiPNS0_14AlbumFileEntryEi", new Tuple<string, List<string>>("nn::album::GetAlbumMovieFileList(int*, nn::album::AlbumFileEntry*, int)", new List<string>() { "5_BundleRules_NX_Private_Album_album-albumAccess" }) },
                        { "_ZN2nn5album14LoadAlbumImageEPiS1_PvmS2_mRKNS0_14AlbumFileEntryE", new Tuple<string, List<string>>("nn::album::LoadAlbumImage(int*, int*, void*, unsigned long, void*, unsigned long, nn::album::AlbumFileEntry const&)", new List<string>() { "5_BundleRules_NX_Private_Album_album-albumAccess" }) },
                        { "_ZN2nn5album14LoadAlbumImageEPiS1_PmPvmS3_mS3_mRKNS0_14AlbumFileEntryE", new Tuple<string, List<string>>("nn::album::LoadAlbumImage(int*, int*, unsigned long*, void*, unsigned long, void*, unsigned long, void*, unsigned long, nn::album::AlbumFileEntry const&)", new List<string>() { "5_BundleRules_NX_Private_Album_album-albumAccess" }) },
                        { "_ZN2nn5album23LoadAlbumThumbnailImageEPiS1_PvmS2_mRKNS0_14AlbumFileEntryE", new Tuple<string, List<string>>("nn::album::LoadAlbumThumbnailImage(int*, int*, void*, unsigned long, void*, unsigned long, nn::album::AlbumFileEntry const&)", new List<string>() { "5_BundleRules_NX_Private_Album_album-albumAccess" }) },
                        { "_ZN2nn5album23LoadAlbumThumbnailImageEPiS1_PmPvmS3_mS3_mRKNS0_14AlbumFileEntryE", new Tuple<string, List<string>>("nn::album::LoadAlbumThumbnailImage(int*, int*, unsigned long*, void*, unsigned long, void*, unsigned long, void*, unsigned long, nn::album::AlbumFileEntry const&)", new List<string>() { "5_BundleRules_NX_Private_Album_album-albumAccess" }) },
                        { "_ZN2nn5album20OpenAlbumMovieStreamEPNS0_17MovieStreamHandleERKNS0_14AlbumFileEntryE", new Tuple<string, List<string>>("nn::album::OpenAlbumMovieStream(nn::album::MovieStreamHandle*, nn::album::AlbumFileEntry const&)", new List<string>() { "5_BundleRules_NX_Private_Album_album-albumAccess" }) },
                        { "_ZN2nn5album21CloseAlbumMovieStreamENS0_17MovieStreamHandleE", new Tuple<string, List<string>>("nn::album::CloseAlbumMovieStream(nn::album::MovieStreamHandle)", new List<string>() { "5_BundleRules_NX_Private_Album_album-albumAccess" }) },
                        { "_ZN2nn5album23GetAlbumMovieStreamSizeEPmNS0_17MovieStreamHandleE", new Tuple<string, List<string>>("nn::album::GetAlbumMovieStreamSize(unsigned long*, nn::album::MovieStreamHandle)", new List<string>() { "5_BundleRules_NX_Private_Album_album-albumAccess" }) },
                        { "_ZN2nn5album20ReadAlbumMovieStreamEPmPvmNS0_17MovieStreamHandleEl", new Tuple<string, List<string>>("nn::album::ReadAlbumMovieStream(unsigned long*, void*, unsigned long, nn::album::MovieStreamHandle, long)", new List<string>() { "5_BundleRules_NX_Private_Album_album-albumAccess" }) },
                        { "_ZN2nn5album14LoadAlbumImageEPiS1_PvjS2_jRKNS0_14AlbumFileEntryE", new Tuple<string, List<string>>("nn::album::LoadAlbumImage(int*, int*, void*, unsigned int, void*, unsigned int, nn::album::AlbumFileEntry const&)", new List<string>() { "5_BundleRules_NX_Private_Album_album-albumAccess" }) },
                        { "_ZN2nn5album14LoadAlbumImageEPiS1_PjPvjS3_jS3_jRKNS0_14AlbumFileEntryE", new Tuple<string, List<string>>("nn::album::LoadAlbumImage(int*, int*, unsigned int*, void*, unsigned int, void*, unsigned int, void*, unsigned int, nn::album::AlbumFileEntry const&)", new List<string>() { "5_BundleRules_NX_Private_Album_album-albumAccess" }) },
                        { "_ZN2nn5album23LoadAlbumThumbnailImageEPiS1_PvjS2_jRKNS0_14AlbumFileEntryE", new Tuple<string, List<string>>("nn::album::LoadAlbumThumbnailImage(int*, int*, void*, unsigned int, void*, unsigned int, nn::album::AlbumFileEntry const&)", new List<string>() { "5_BundleRules_NX_Private_Album_album-albumAccess" }) },
                        { "_ZN2nn5album23LoadAlbumThumbnailImageEPiS1_PjPvjS3_jS3_jRKNS0_14AlbumFileEntryE", new Tuple<string, List<string>>("nn::album::LoadAlbumThumbnailImage(int*, int*, unsigned int*, void*, unsigned int, void*, unsigned int, void*, unsigned int, nn::album::AlbumFileEntry const&)", new List<string>() { "5_BundleRules_NX_Private_Album_album-albumAccess" }) },
                        { "_ZN2nn5album23GetAlbumMovieStreamSizeEPyNS0_17MovieStreamHandleE", new Tuple<string, List<string>>("nn::album::GetAlbumMovieStreamSize(unsigned long long*, nn::album::MovieStreamHandle)", new List<string>() { "5_BundleRules_NX_Private_Album_album-albumAccess" }) },
                        { "_ZN2nn5album20ReadAlbumMovieStreamEPjPvjNS0_17MovieStreamHandleEx", new Tuple<string, List<string>>("nn::album::ReadAlbumMovieStream(unsigned int*, void*, unsigned int, nn::album::MovieStreamHandle, long long)", new List<string>() { "5_BundleRules_NX_Private_Album_album-albumAccess" }) },
                        { "_ZN2nn5album23DeleteAlbumFileForDebugERKNS0_14AlbumFileEntryE", new Tuple<string, List<string>>("nn::album::DeleteAlbumFileForDebug(nn::album::AlbumFileEntry const&)", new List<string>() { "5_BundleRules_NX_Private_Album_album-albumAccess" }) },
                        { "_ZN2nn5album23GetAlbumFileCreatedTimeERKNS0_14AlbumFileEntryE", new Tuple<string, List<string>>("nn::album::GetAlbumFileCreatedTime(nn::album::AlbumFileEntry const&)", new List<string>() { "5_BundleRules_NX_Private_Album_album-albumAccess" }) },
                        { "_ZN2nn5album21GetExtraMovieFileListEPiPNS0_14AlbumFileEntryEi", new Tuple<string, List<string>>("nn::album::GetExtraMovieFileList(int*, nn::album::AlbumFileEntry*, int)", new List<string>() { "5_BundleRules_NX_Private_Album_album-extraMovie" }) },
                        { "_ZN2nn5album20DeleteExtraMovieFileERKNS0_14AlbumFileEntryE", new Tuple<string, List<string>>("nn::album::DeleteExtraMovieFile(nn::album::AlbumFileEntry const&)", new List<string>() { "5_BundleRules_NX_Private_Album_album-extraMovie" }) },
                        { "_ZN2nn3hid12GetNpadStateEPNS0_11NpadGcStateERKj", new Tuple<string, List<string>>("nn::hid::GetNpadState(nn::hid::NpadGcState*, unsigned int const&)", new List<string>() { "5_BundleRules_NX_Private_GcAdapter_gcadapter" }) },
                        { "_ZN2nn3hid13GetNpadStatesEPNS0_11NpadGcStateEiRKj", new Tuple<string, List<string>>("nn::hid::GetNpadStates(nn::hid::NpadGcState*, int, unsigned int const&)", new List<string>() { "5_BundleRules_NX_Private_GcAdapter_gcadapter" }) },
                        { "_ZN2nn3hidL10TriggerMaxE", new Tuple<string, List<string>>("nn::hid::TriggerMax", new List<string>() { "5_BundleRules_NX_Private_GcAdapter_gcadapter" }) },
                        { "_ZN2nn3hidL25VibrationDeviceType_GcErmE", new Tuple<string, List<string>>("nn::hid::VibrationDeviceType_GcErm", new List<string>() { "5_BundleRules_NX_Private_GcAdapter_gcadapter" }) },
                        { "_ZN2nn3hid25SendVibrationGcErmCommandERKNS0_21VibrationDeviceHandleERKNS0_21VibrationGcErmCommandE", new Tuple<string, List<string>>("nn::hid::SendVibrationGcErmCommand(nn::hid::VibrationDeviceHandle const&, nn::hid::VibrationGcErmCommand const&)", new List<string>() { "5_BundleRules_NX_Private_GcAdapter_gcadapter" }) },
                        { "_ZN2nn3hid30GetActualVibrationGcErmCommandEPNS0_21VibrationGcErmCommandERKNS0_21VibrationDeviceHandleE", new Tuple<string, List<string>>("nn::hid::GetActualVibrationGcErmCommand(nn::hid::VibrationGcErmCommand*, nn::hid::VibrationDeviceHandle const&)", new List<string>() { "5_BundleRules_NX_Private_GcAdapter_gcadapter" }) },
                        { "_ZN2nn3ldn16SetOperationModeENS0_13OperationModeE", new Tuple<string, List<string>>("nn::ldn::SetOperationMode(nn::ldn::OperationMode)", new List<string>() { "5_BundleRules_NX_Private_LdnSettings_LdnSettings" }) },
                        { "_ZN2nn3ldn32SetWirelessControllerRestrictionENS0_29WirelessControllerRestrictionE", new Tuple<string, List<string>>("nn::ldn::SetWirelessControllerRestriction(nn::ldn::WirelessControllerRestriction)", new List<string>() { "5_BundleRules_NX_Private_LdnSettings_LdnSettings" }) },
                        { "_ZN2nn5album24MovieMakerMovieParameter15GetDefaultValueEv", new Tuple<string, List<string>>("nn::album::MovieMakerMovieParameter::GetDefaultValue()", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album24MovieMakerMovieParameterC2Ev", new Tuple<string, List<string>>("nn::album::MovieMakerMovieParameter::MovieMakerMovieParameter()", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album24MovieMakerMovieParameterC1Ev", new Tuple<string, List<string>>("nn::album::MovieMakerMovieParameter::MovieMakerMovieParameter()", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZNK2nn5album24MovieMakerMovieParameter15GetVideoBitRateEv", new Tuple<string, List<string>>("nn::album::MovieMakerMovieParameter::GetVideoBitRate() const", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album24MovieMakerMovieParameter15SetVideoBitRateEi", new Tuple<string, List<string>>("nn::album::MovieMakerMovieParameter::SetVideoBitRate(int)", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZNK2nn5album24MovieMakerMovieParameter13GetVideoWidthEv", new Tuple<string, List<string>>("nn::album::MovieMakerMovieParameter::GetVideoWidth() const", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album24MovieMakerMovieParameter13SetVideoWidthEi", new Tuple<string, List<string>>("nn::album::MovieMakerMovieParameter::SetVideoWidth(int)", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZNK2nn5album24MovieMakerMovieParameter14GetVideoHeightEv", new Tuple<string, List<string>>("nn::album::MovieMakerMovieParameter::GetVideoHeight() const", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album24MovieMakerMovieParameter14SetVideoHeightEi", new Tuple<string, List<string>>("nn::album::MovieMakerMovieParameter::SetVideoHeight(int)", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZNK2nn5album24MovieMakerMovieParameter17GetVideoFrameRateEv", new Tuple<string, List<string>>("nn::album::MovieMakerMovieParameter::GetVideoFrameRate() const", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album24MovieMakerMovieParameter17SetVideoFrameRateEi", new Tuple<string, List<string>>("nn::album::MovieMakerMovieParameter::SetVideoFrameRate(int)", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZNK2nn5album24MovieMakerMovieParameter24GetVideoKeyFrameIntervalEv", new Tuple<string, List<string>>("nn::album::MovieMakerMovieParameter::GetVideoKeyFrameInterval() const", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album24MovieMakerMovieParameter24SetVideoKeyFrameIntervalEi", new Tuple<string, List<string>>("nn::album::MovieMakerMovieParameter::SetVideoKeyFrameInterval(int)", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZNK2nn5album24MovieMakerMovieParameter15GetAudioBitRateEv", new Tuple<string, List<string>>("nn::album::MovieMakerMovieParameter::GetAudioBitRate() const", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album24MovieMakerMovieParameter15SetAudioBitRateEi", new Tuple<string, List<string>>("nn::album::MovieMakerMovieParameter::SetAudioBitRate(int)", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZNK2nn5album24MovieMakerMovieParameter18GetAudioSampleRateEv", new Tuple<string, List<string>>("nn::album::MovieMakerMovieParameter::GetAudioSampleRate() const", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album24MovieMakerMovieParameter18SetAudioSampleRateEi", new Tuple<string, List<string>>("nn::album::MovieMakerMovieParameter::SetAudioSampleRate(int)", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZNK2nn5album24MovieMakerMovieParameter20GetAudioChannelCountEv", new Tuple<string, List<string>>("nn::album::MovieMakerMovieParameter::GetAudioChannelCount() const", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album24MovieMakerMovieParameter20SetAudioChannelCountEi", new Tuple<string, List<string>>("nn::album::MovieMakerMovieParameter::SetAudioChannelCount(int)", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZNK2nn5album24MovieMakerMovieParameter20GetAudioSampleFormatEv", new Tuple<string, List<string>>("nn::album::MovieMakerMovieParameter::GetAudioSampleFormat() const", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album24MovieMakerMovieParameter20SetAudioSampleFormatENS_5audio12SampleFormatE", new Tuple<string, List<string>>("nn::album::MovieMakerMovieParameter::SetAudioSampleFormat(nn::audio::SampleFormat)", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album35GetMovieMakerRequiredWorkMemorySizeEv", new Tuple<string, List<string>>("nn::album::GetMovieMakerRequiredWorkMemorySize()", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album40GetMovieMakerRequiredWorkMemoryAlignmentEv", new Tuple<string, List<string>>("nn::album::GetMovieMakerRequiredWorkMemoryAlignment()", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album23IsMovieMakerInitializedEv", new Tuple<string, List<string>>("nn::album::IsMovieMakerInitialized()", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album19IsMovieMakerRunningEv", new Tuple<string, List<string>>("nn::album::IsMovieMakerRunning()", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album20InitializeMovieMakerEPvm", new Tuple<string, List<string>>("nn::album::InitializeMovieMaker(void*, unsigned long)", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album18FinalizeMovieMakerEv", new Tuple<string, List<string>>("nn::album::FinalizeMovieMaker()", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album25GetMovieMakerNativeWindowEPPv", new Tuple<string, List<string>>("nn::album::GetMovieMakerNativeWindow(void**)", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album25PrecheckToStartMovieMakerEm", new Tuple<string, List<string>>("nn::album::PrecheckToStartMovieMaker(unsigned long)", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album15StartMovieMakerERKNS0_24MovieMakerMovieParameterE", new Tuple<string, List<string>>("nn::album::StartMovieMaker(nn::album::MovieMakerMovieParameter const&)", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album16FinishMovieMakerEv", new Tuple<string, List<string>>("nn::album::FinishMovieMaker()", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album16FinishMovieMakerEPKvm", new Tuple<string, List<string>>("nn::album::FinishMovieMaker(void const*, unsigned long)", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album16FinishMovieMakerEPKvmS2_mNS0_9ImageSizeE", new Tuple<string, List<string>>("nn::album::FinishMovieMaker(void const*, unsigned long, void const*, unsigned long, nn::album::ImageSize)", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album15AbortMovieMakerEv", new Tuple<string, List<string>>("nn::album::AbortMovieMaker()", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album20CheckMovieMakerErrorEv", new Tuple<string, List<string>>("nn::album::CheckMovieMakerError()", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album27EncodeMovieMakerAudioSampleEPKvm", new Tuple<string, List<string>>("nn::album::EncodeMovieMakerAudioSample(void const*, unsigned long)", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album20InitializeMovieMakerEPvj", new Tuple<string, List<string>>("nn::album::InitializeMovieMaker(void*, unsigned int)", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album25PrecheckToStartMovieMakerEy", new Tuple<string, List<string>>("nn::album::PrecheckToStartMovieMaker(unsigned long long)", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album16FinishMovieMakerEPKvj", new Tuple<string, List<string>>("nn::album::FinishMovieMaker(void const*, unsigned int)", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album16FinishMovieMakerEPKvjS2_jNS0_9ImageSizeE", new Tuple<string, List<string>>("nn::album::FinishMovieMaker(void const*, unsigned int, void const*, unsigned int, nn::album::ImageSize)", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn5album27EncodeMovieMakerAudioSampleEPKvj", new Tuple<string, List<string>>("nn::album::EncodeMovieMakerAudioSample(void const*, unsigned int)", new List<string>() { "5_BundleRules_NX_Private_MovieMaker_moviemaker" }) },
                        { "_ZN2nn2oeL29MessageLcdBacklightSwitchedOnE", new Tuple<string, List<string>>("nn::oe::MessageLcdBacklightSwitchedOn", new List<string>() { "5_BundleRules_NX_Private_Oe_oe-LcdBackLightControl" }) },
                        { "_ZN2nn2oe21SwitchLcdBacklightOffEv", new Tuple<string, List<string>>("nn::oe::SwitchLcdBacklightOff()", new List<string>() { "5_BundleRules_NX_Private_Oe_oe-LcdBackLightControl" }) },
                        { "_ZN2nn2oe20SwitchLcdBacklightOnEv", new Tuple<string, List<string>>("nn::oe::SwitchLcdBacklightOn()", new List<string>() { "5_BundleRules_NX_Private_Oe_oe-LcdBackLightControl" }) },
                        { "_ZN2nn2oe27SetTvPowerStateMatchingModeENS0_24TvPowerStateMatchingModeE", new Tuple<string, List<string>>("nn::oe::SetTvPowerStateMatchingMode(nn::oe::TvPowerStateMatchingMode)", new List<string>() { "5_BundleRules_NX_Private_Oe_oe-TvPowerStateMatchingControl" }) },
                        { "_ZN2nn3hidL31SevenSixAxisSensorStateCountMaxE", new Tuple<string, List<string>>("nn::hid::SevenSixAxisSensorStateCountMax", new List<string>() { "5_BundleRules_NX_Private_SevenSixAxisSensor_sevensixaxissensor" }) },
                        { "_ZN2nn3hidL32SevenSixAxisSensorWorkBufferSizeE", new Tuple<string, List<string>>("nn::hid::SevenSixAxisSensorWorkBufferSize", new List<string>() { "5_BundleRules_NX_Private_SevenSixAxisSensor_sevensixaxissensor" }) },
                        { "_ZN2nn3hid28InitializeSevenSixAxisSensorEPvm", new Tuple<string, List<string>>("nn::hid::InitializeSevenSixAxisSensor(void*, unsigned long)", new List<string>() { "5_BundleRules_NX_Private_SevenSixAxisSensor_sevensixaxissensor" }) },
                        { "_ZN2nn3hid26FinalizeSevenSixAxisSensorEv", new Tuple<string, List<string>>("nn::hid::FinalizeSevenSixAxisSensor()", new List<string>() { "5_BundleRules_NX_Private_SevenSixAxisSensor_sevensixaxissensor" }) },
                        { "_ZN2nn3hid23StartSevenSixAxisSensorEv", new Tuple<string, List<string>>("nn::hid::StartSevenSixAxisSensor()", new List<string>() { "5_BundleRules_NX_Private_SevenSixAxisSensor_sevensixaxissensor" }) },
                        { "_ZN2nn3hid22StopSevenSixAxisSensorEv", new Tuple<string, List<string>>("nn::hid::StopSevenSixAxisSensor()", new List<string>() { "5_BundleRules_NX_Private_SevenSixAxisSensor_sevensixaxissensor" }) },
                        { "_ZN2nn3hid27GetSevenSixAxisSensorStatesEPNS0_23SevenSixAxisSensorStateEi", new Tuple<string, List<string>>("nn::hid::GetSevenSixAxisSensorStates(nn::hid::SevenSixAxisSensorState*, int)", new List<string>() { "5_BundleRules_NX_Private_SevenSixAxisSensor_sevensixaxissensor" }) },
                        { "_ZN2nn3hid26IsSevenSixAxisSensorAtRestEv", new Tuple<string, List<string>>("nn::hid::IsSevenSixAxisSensorAtRest()", new List<string>() { "5_BundleRules_NX_Private_SevenSixAxisSensor_sevensixaxissensor" }) },
                        { "_ZN2nn3hid28InitializeSevenSixAxisSensorEPvj", new Tuple<string, List<string>>("nn::hid::InitializeSevenSixAxisSensor(void*, unsigned int)", new List<string>() { "5_BundleRules_NX_Private_SevenSixAxisSensor_sevensixaxissensor" }) },
                        { "_ZN2nn3hid35SetSevenSixAxisSensorFusionStrengthEf", new Tuple<string, List<string>>("nn::hid::SetSevenSixAxisSensorFusionStrength(float)", new List<string>() { "5_BundleRules_NX_Private_SevenSixAxisSensor_sevensixaxissensor" }) },
                        { "_ZN2nn3hid35GetSevenSixAxisSensorFusionStrengthEPf", new Tuple<string, List<string>>("nn::hid::GetSevenSixAxisSensorFusionStrength(float*)", new List<string>() { "5_BundleRules_NX_Private_SevenSixAxisSensor_sevensixaxissensor" }) },
                        { "_ZN2nn3web16ShowYouTubeVideoEPNS0_18WebPageReturnValueERKNS0_19ShowYouTubeVideoArgE", new Tuple<string, List<string>>("nn::web::ShowYouTubeVideo(nn::web::WebPageReturnValue*, nn::web::ShowYouTubeVideoArg const&)", new List<string>() { "5_BundleRules_NX_Private_WebYouTube_WebYouTube" }) },
                        { "_ZN2nn3web19ShowYouTubeVideoArg19RequestUrlMaxLengthE", new Tuple<string, List<string>>("nn::web::ShowYouTubeVideoArg::RequestUrlMaxLength", new List<string>() { "5_BundleRules_NX_Private_WebYouTube_WebYouTube" }) },
                        { "_ZN2nn3web19ShowYouTubeVideoArgC2EPKc", new Tuple<string, List<string>>("nn::web::ShowYouTubeVideoArg::ShowYouTubeVideoArg(char const*)", new List<string>() { "5_BundleRules_NX_Private_WebYouTube_WebYouTube" }) },
                        { "_ZN2nn3web19ShowYouTubeVideoArgC1EPKc", new Tuple<string, List<string>>("nn::web::ShowYouTubeVideoArg::ShowYouTubeVideoArg(char const*)", new List<string>() { "5_BundleRules_NX_Private_WebYouTube_WebYouTube" }) },
                        { "_ZN2nn3web19ShowYouTubeVideoArg17SetBackgroundKindENS0_17WebBackgroundKindE", new Tuple<string, List<string>>("nn::web::ShowYouTubeVideoArg::SetBackgroundKind(nn::web::WebBackgroundKind)", new List<string>() { "5_BundleRules_NX_Private_WebYouTube_WebYouTube" }) },
                        { "_ZN2nn3web19ShowYouTubeVideoArg18SetBootDisplayKindENS0_18WebBootDisplayKindE", new Tuple<string, List<string>>("nn::web::ShowYouTubeVideoArg::SetBootDisplayKind(nn::web::WebBootDisplayKind)", new List<string>() { "5_BundleRules_NX_Private_WebYouTube_WebYouTube" }) },
                        { "_ZN2nn3web19ShowYouTubeVideoArg30SetMediaPlayerAutoCloseEnabledEb", new Tuple<string, List<string>>("nn::web::ShowYouTubeVideoArg::SetMediaPlayerAutoCloseEnabled(bool)", new List<string>() { "5_BundleRules_NX_Private_WebYouTube_WebYouTube" }) },
                        { "_ZN2nn3web19ShowYouTubeVideoArg16SetBootAsWebPageEb", new Tuple<string, List<string>>("nn::web::ShowYouTubeVideoArg::SetBootAsWebPage(bool)", new List<string>() { "5_BundleRules_NX_Private_WebYouTube_WebYouTube" }) },
                        { "_ZNK2nn3web19ShowYouTubeVideoArg4DataEv", new Tuple<string, List<string>>("nn::web::ShowYouTubeVideoArg::Data() const", new List<string>() { "5_BundleRules_NX_Private_WebYouTube_WebYouTube" }) },
                        { "_ZN2nn3web19ShowYouTubeVideoArg8DataSizeE", new Tuple<string, List<string>>("nn::web::ShowYouTubeVideoArg::DataSize", new List<string>() { "5_BundleRules_NX_Private_WebYouTube_WebYouTube" }) },
                        { "_ZN2nn3web19ShowYouTubeVideoArgC2Ev", new Tuple<string, List<string>>("nn::web::ShowYouTubeVideoArg::ShowYouTubeVideoArg()", new List<string>() { "5_BundleRules_NX_Private_WebYouTube_WebYouTube" }) },
                        { "_ZN2nn3web19ShowYouTubeVideoArgC1Ev", new Tuple<string, List<string>>("nn::web::ShowYouTubeVideoArg::ShowYouTubeVideoArg()", new List<string>() { "5_BundleRules_NX_Private_WebYouTube_WebYouTube" }) },
                        { "_ZN2nn3hid27EnableControlPadRestrictionERKNS_4util10BitFlagSetILi32ENS0_12NpadStyleTagEEEb", new Tuple<string, List<string>>("nn::hid::EnableControlPadRestriction(nn::util::BitFlagSet<32, nn::hid::NpadStyleTag> const&, bool)", new List<string>() { "5_BundleRules_NX_Private_DisableControlPadRestriction_disableControlPadRestriction" }) },
                        { "_ZN2nn2fs19MountDeviceSaveDataEPKc", new Tuple<string, List<string>>("nn::fs::MountDeviceSaveData(char const*)", new List<string>() { "5_BundleRules_NX_Private_DeviceSaveData_DeviceSaveData" }) },
                        { "_ZN2nn7friends17SendFriendRequestEPNS0_12AsyncContextERKNS_7account3UidENS3_23NetworkServiceAccountIdERKNS0_15InAppScreenNameESA_", new Tuple<string, List<string>>("nn::friends::SendFriendRequest(nn::friends::AsyncContext*, nn::account::Uid const&, nn::account::NetworkServiceAccountId, nn::friends::InAppScreenName const&, nn::friends::InAppScreenName const&)", new List<string>() { "5_BundleRules_Generic_Private_FriendRequest_friend-request" }) },
                        { "_ZN2nn7friends36GetFacedFriendRequestRegistrationKeyEPNS0_33FacedFriendRequestRegistrationKeyERKNS_7account3UidE", new Tuple<string, List<string>>("nn::friends::GetFacedFriendRequestRegistrationKey(nn::friends::FacedFriendRequestRegistrationKey*, nn::account::Uid const&)", new List<string>() { "5_BundleRules_Generic_Private_FriendRequest_friend-request" }) },
                        { "_ZN2nn7friends21AddFacedFriendRequestERKNS_7account3UidERKNS0_33FacedFriendRequestRegistrationKeyERKNS1_8NicknameEPKvmRKNS0_15InAppScreenNameESF_", new Tuple<string, List<string>>("nn::friends::AddFacedFriendRequest(nn::account::Uid const&, nn::friends::FacedFriendRequestRegistrationKey const&, nn::account::Nickname const&, void const*, unsigned long, nn::friends::InAppScreenName const&, nn::friends::InAppScreenName const&)", new List<string>() { "5_BundleRules_Generic_Private_FriendRequest_friend-request" }) },
                        { "_ZN2nn7friends21AddFacedFriendRequestERKNS_7account3UidERKNS0_33FacedFriendRequestRegistrationKeyERKNS1_8NicknameEPKvjRKNS0_15InAppScreenNameESF_", new Tuple<string, List<string>>("nn::friends::AddFacedFriendRequest(nn::account::Uid const&, nn::friends::FacedFriendRequestRegistrationKey const&, nn::account::Nickname const&, void const*, unsigned int, nn::friends::InAppScreenName const&, nn::friends::InAppScreenName const&)", new List<string>() { "5_BundleRules_Generic_Private_FriendRequest_friend-request" }) },
                        { "_ZN2nn7account36CheckNetworkServiceAvailabilityAsyncEPNS0_12AsyncContextE", new Tuple<string, List<string>>("nn::account::CheckNetworkServiceAvailabilityAsync(nn::account::AsyncContext*)", new List<string>() { "5_BundleRules_Generic_Private_NetworkServiceForUnspecifiedUserAccount_network-service-for-unspecified-user-account" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardC2ERKS1_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::InlineKeyboard(nn::swkbd::InlineKeyboard const&)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardC1ERKS1_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::InlineKeyboard(nn::swkbd::InlineKeyboard const&)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardaSERKS1_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::operator=(nn::swkbd::InlineKeyboard const&)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardC2Ev", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::InlineKeyboard()", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardC1Ev", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::InlineKeyboard()", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardD2Ev", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::~InlineKeyboard()", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboardD1Ev", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::~InlineKeyboard()", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard25GetRequiredWorkBufferSizeEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetRequiredWorkBufferSize()", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard10InitializeEPv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::Initialize(void*)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard8FinalizeEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::Finalize()", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard6LaunchEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::Launch()", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard9SetVolumeEf", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetVolume(float)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard6AppearERKNS0_9AppearArgE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::Appear(nn::swkbd::AppearArg const&)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard9DisappearEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::Disappear()", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard12SetInputTextERKNS0_9InputTextE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetInputText(nn::swkbd::InputText const&)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard12SetCursorPosEi", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetCursorPos(int)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard15SetUserWordInfoERKNS0_12UserWordInfoE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetUserWordInfo(nn::swkbd::UserWordInfo const&)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard17UnsetUserWordInfoEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::UnsetUserWordInfo()", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard11SetUtf8ModeEb", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetUtf8Mode(bool)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard15SetCustomizeDicEPKvmRKNS0_16CustomizeDicInfoE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetCustomizeDic(void const*, unsigned long, nn::swkbd::CustomizeDicInfo const&)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard17UnsetCustomizeDicEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::UnsetCustomizeDic()", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard14SetKeytopAlphaEf", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetKeytopAlpha(float)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard14SetFooterAlphaEf", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetFooterAlpha(float)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard14SetKeytopScaleEf", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetKeytopScale(float)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard18SetKeytopTranslateEff", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetKeytopTranslate(float, float)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard13SetWindowModeENS1_10WindowModeE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetWindowMode(nn::swkbd::InlineKeyboard::WindowMode)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard15SetTouchEnabledEb", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetTouchEnabled(bool)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard21SetUsbKeyboardEnabledEb", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetUsbKeyboardEnabled(bool)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZNK2nn5swkbd14InlineKeyboard18GetTouchRectanglesEPNS0_4RectES3_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetTouchRectangles(nn::swkbd::Rect*, nn::swkbd::Rect*) const", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard4CalcEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::Calc()", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard12GetMaxHeightEv", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetMaxHeight()", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard26IsUsedTouchPointByKeyboardEii", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::IsUsedTouchPointByKeyboard(int, int)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard29SetFinishedInitializeCallbackEPFvvE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetFinishedInitializeCallback(void (*)())", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard27SetFinishedKeyboardCallbackEPFvvE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetFinishedKeyboardCallback(void (*)())", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard24SetChangedStringCallbackEPFvPKNS0_16ChangedStringArgEE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetChangedStringCallback(void (*)(nn::swkbd::ChangedStringArg const*))", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard28SetChangedStringCallbackUtf8EPFvPKNS0_20ChangedStringArgUtf8EE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetChangedStringCallbackUtf8(void (*)(nn::swkbd::ChangedStringArgUtf8 const*))", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard22SetMovedCursorCallbackEPFvPKNS0_14MovedCursorArgEE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetMovedCursorCallback(void (*)(nn::swkbd::MovedCursorArg const*))", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard26SetMovedCursorCallbackUtf8EPFvPKNS0_18MovedCursorArgUtf8EE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetMovedCursorCallbackUtf8(void (*)(nn::swkbd::MovedCursorArgUtf8 const*))", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard23SetDecidedEnterCallbackEPFvPKNS0_15DecidedEnterArgEE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetDecidedEnterCallback(void (*)(nn::swkbd::DecidedEnterArg const*))", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard27SetDecidedEnterCallbackUtf8EPFvPKNS0_19DecidedEnterArgUtf8EE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetDecidedEnterCallbackUtf8(void (*)(nn::swkbd::DecidedEnterArgUtf8 const*))", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard24SetDecidedCancelCallbackEPFvvE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetDecidedCancelCallback(void (*)())", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard31SetReleasedUserWordInfoCallbackEPFvvE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetReleasedUserWordInfoCallback(void (*)())", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZNK2nn5swkbd14InlineKeyboard13GetWindowSizeEPiS2_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetWindowSize(int*, int*) const", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard25GetImageMemoryRequirementEPmS2_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetImageMemoryRequirement(unsigned long*, unsigned long*)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard8GetImageEPvm", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetImage(void*, unsigned long)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard15SetCustomizeDicEPKvjRKNS0_16CustomizeDicInfoE", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::SetCustomizeDic(void const*, unsigned int, nn::swkbd::CustomizeDicInfo const&)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard25GetImageMemoryRequirementEPjS2_", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetImageMemoryRequirement(unsigned int*, unsigned int*)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd14InlineKeyboard8GetImageEPvj", new Tuple<string, List<string>>("nn::swkbd::InlineKeyboard::GetImage(void*, unsigned int)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd9AppearArgC2Ev", new Tuple<string, List<string>>("nn::swkbd::AppearArg::AppearArg()", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd9AppearArgC1Ev", new Tuple<string, List<string>>("nn::swkbd::AppearArg::AppearArg()", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd9InputTextC2Ev", new Tuple<string, List<string>>("nn::swkbd::InputText::InputText()", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd9InputTextC1Ev", new Tuple<string, List<string>>("nn::swkbd::InputText::InputText()", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd9InputText3SetEPKDs", new Tuple<string, List<string>>("nn::swkbd::InputText::Set(char16_t const*)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd9InputText7SetUtf8EPKc", new Tuple<string, List<string>>("nn::swkbd::InputText::SetUtf8(char const*)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd16CustomizeDicInfoC2Ev", new Tuple<string, List<string>>("nn::swkbd::CustomizeDicInfo::CustomizeDicInfo()", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd16CustomizeDicInfoC1Ev", new Tuple<string, List<string>>("nn::swkbd::CustomizeDicInfo::CustomizeDicInfo()", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd12UserWordInfoC2Ev", new Tuple<string, List<string>>("nn::swkbd::UserWordInfo::UserWordInfo()", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd12UserWordInfoC1Ev", new Tuple<string, List<string>>("nn::swkbd::UserWordInfo::UserWordInfo()", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn5swkbd12UserWordInfo25GetRequiredWorkBufferSizeEi", new Tuple<string, List<string>>("nn::swkbd::UserWordInfo::GetRequiredWorkBufferSize(int)", new List<string>() { "5_BundleRules_NX_Private_InlineSoftwareKeyboard_InlineSoftwareKeyboard" }) },
                        { "_ZN2nn2oeL25MessageRequestToEndVrModeE", new Tuple<string, List<string>>("nn::oe::MessageRequestToEndVrMode", new List<string>() { "5_BundleRules_NX_Private_VrMode_vrmode" }) },
                        { "_ZN2nn2pl11BeginVrModeEv", new Tuple<string, List<string>>("nn::pl::BeginVrMode()", new List<string>() { "5_BundleRules_NX_Private_VrMode_vrmode" }) },
                        { "_ZN2nn2pl9EndVrModeEv", new Tuple<string, List<string>>("nn::pl::EndVrMode()", new List<string>() { "5_BundleRules_NX_Private_VrMode_vrmode" }) },
                        { "_ZN2nn2pl8IsVrModeEv", new Tuple<string, List<string>>("nn::pl::IsVrMode()", new List<string>() { "5_BundleRules_NX_Private_VrMode_vrmode" }) },
                        { "_ZN2nn2pl21GetCurrentIlluminanceEv", new Tuple<string, List<string>>("nn::pl::GetCurrentIlluminance()", new List<string>() { "5_BundleRules_NX_Private_Illuminance_illuminance" }) },
                        { "_ZN2nn2pl21GetCurrentIlluminanceEPb", new Tuple<string, List<string>>("nn::pl::GetCurrentIlluminance(bool*)", new List<string>() { "5_BundleRules_NX_Private_Illuminance_illuminance" }) },
                        { "_ZN2nn2pl22IsIlluminanceAvailableEv", new Tuple<string, List<string>>("nn::pl::IsIlluminanceAvailable()", new List<string>() { "5_BundleRules_NX_Private_Illuminance_illuminance" }) },
                        { "_ZN2nn3lbl10InitializeEv", new Tuple<string, List<string>>("nn::lbl::Initialize()", new List<string>() { "5_BundleRules_NX_Private_LblSettingsForVrMode_LblSettingsForVrMode", "5_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl8FinalizeEv", new Tuple<string, List<string>>("nn::lbl::Finalize()", new List<string>() { "5_BundleRules_NX_Private_LblSettingsForVrMode_LblSettingsForVrMode", "5_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl36SetCurrentBrightnessSettingForVrModeEf", new Tuple<string, List<string>>("nn::lbl::SetCurrentBrightnessSettingForVrMode(float)", new List<string>() { "5_BundleRules_NX_Private_LblSettingsForVrMode_LblSettingsForVrMode", "5_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl36GetCurrentBrightnessSettingForVrModeEv", new Tuple<string, List<string>>("nn::lbl::GetCurrentBrightnessSettingForVrMode()", new List<string>() { "5_BundleRules_NX_Private_LblSettingsForVrMode_LblSettingsForVrMode", "5_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl18SaveCurrentSettingEv", new Tuple<string, List<string>>("nn::lbl::SaveCurrentSetting()", new List<string>() { "5_BundleRules_NX_Private_LblSettingsForVrMode_LblSettingsForVrMode", "5_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn4pctl20IsRestrictionEnabledEv", new Tuple<string, List<string>>("nn::pctl::IsRestrictionEnabled()", new List<string>() { "5_BundleRules_NX_Private_StereoVisionRestrictionSettings_stereovision" }) },
                        { "_ZN2nn4pctl14GetSafetyLevelEv", new Tuple<string, List<string>>("nn::pctl::GetSafetyLevel()", new List<string>() { "5_BundleRules_NX_Private_StereoVisionRestrictionSettings_stereovision" }) },
                        { "_ZN2nn4pctl18GetCurrentSettingsEPNS0_19RestrictionSettingsE", new Tuple<string, List<string>>("nn::pctl::GetCurrentSettings(nn::pctl::RestrictionSettings*)", new List<string>() { "5_BundleRules_NX_Private_StereoVisionRestrictionSettings_stereovision" }) },
                        { "_ZN2nn4pctl29ConfirmStereoVisionPermissionEv", new Tuple<string, List<string>>("nn::pctl::ConfirmStereoVisionPermission()", new List<string>() { "5_BundleRules_NX_Private_StereoVisionRestrictionSettings_stereovision" }) },
                        { "_ZN2nn4pctl36ResetConfirmedStereoVisionPermissionEv", new Tuple<string, List<string>>("nn::pctl::ResetConfirmedStereoVisionPermission()", new List<string>() { "5_BundleRules_NX_Private_StereoVisionRestrictionSettings_stereovision" }) },
                        { "_ZN2nn4pctl23IsStereoVisionPermittedEv", new Tuple<string, List<string>>("nn::pctl::IsStereoVisionPermitted()", new List<string>() { "5_BundleRules_NX_Private_StereoVisionRestrictionSettings_stereovision" }) },
                        { "_ZN2nn4pctl42ConfirmStereoVisionRestrictionConfigurableEv", new Tuple<string, List<string>>("nn::pctl::ConfirmStereoVisionRestrictionConfigurable()", new List<string>() { "5_BundleRules_NX_Private_StereoVisionRestrictionSettings_stereovision" }) },
                        { "_ZN2nn4pctl53RequestStereoVisionRestrictionConfigurationPermissionEv", new Tuple<string, List<string>>("nn::pctl::RequestStereoVisionRestrictionConfigurationPermission()", new List<string>() { "5_BundleRules_NX_Private_StereoVisionRestrictionSettings_stereovision" }) },
                        { "_ZN2nn4pctl26GetStereoVisionRestrictionEv", new Tuple<string, List<string>>("nn::pctl::GetStereoVisionRestriction()", new List<string>() { "5_BundleRules_NX_Private_StereoVisionRestrictionSettings_stereovision" }) },
                        { "_ZN2nn4pctl26SetStereoVisionRestrictionEb", new Tuple<string, List<string>>("nn::pctl::SetStereoVisionRestriction(bool)", new List<string>() { "5_BundleRules_NX_Private_StereoVisionRestrictionSettings_stereovision" }) },
                        { "_ZN2nn8irsensor30RunAdaptiveClusteringProcessorERKNS0_14IrCameraHandleERKNS0_33AdaptiveClusteringProcessorConfigE", new Tuple<string, List<string>>("nn::irsensor::RunAdaptiveClusteringProcessor(nn::irsensor::IrCameraHandle const&, nn::irsensor::AdaptiveClusteringProcessorConfig const&)", new List<string>() { "5_BundleRules_NX_Private_IrSensorExtension_irsensorextension" }) },
                        { "_ZN2nn8irsensor36GetAdaptiveClusteringProcessorStatesEPNS0_32AdaptiveClusteringProcessorStateEPiilRKNS0_14IrCameraHandleE", new Tuple<string, List<string>>("nn::irsensor::GetAdaptiveClusteringProcessorStates(nn::irsensor::AdaptiveClusteringProcessorState*, int*, int, long, nn::irsensor::IrCameraHandle const&)", new List<string>() { "5_BundleRules_NX_Private_IrSensorExtension_irsensorextension" }) },
                        { "_ZN2nn8irsensor36GetAdaptiveClusteringProcessorStatesEPNS0_32AdaptiveClusteringProcessorStateEPiixRKNS0_14IrCameraHandleE", new Tuple<string, List<string>>("nn::irsensor::GetAdaptiveClusteringProcessorStates(nn::irsensor::AdaptiveClusteringProcessorState*, int*, int, long long, nn::irsensor::IrCameraHandle const&)", new List<string>() { "5_BundleRules_NX_Private_IrSensorExtension_irsensorextension" }) },
                        { "_ZN2nn8irsensorL41AdaptiveClusteringProcessorObjectCountMaxE", new Tuple<string, List<string>>("nn::irsensor::AdaptiveClusteringProcessorObjectCountMax", new List<string>() { "5_BundleRules_NX_Private_IrSensorExtension_irsensorextension" }) },
                        { "_ZN2nn8irsensorL40AdaptiveClusteringProcessorStateCountMaxE", new Tuple<string, List<string>>("nn::irsensor::AdaptiveClusteringProcessorStateCountMax", new List<string>() { "5_BundleRules_NX_Private_IrSensorExtension_irsensorextension" }) },
                        { "_ZN2nn8irsensor30GetIrLedProcessorDefaultConfigEPNS0_20IrLedProcessorConfigE", new Tuple<string, List<string>>("nn::irsensor::GetIrLedProcessorDefaultConfig(nn::irsensor::IrLedProcessorConfig*)", new List<string>() { "5_BundleRules_NX_Private_IrSensorExtension_irsensorextension" }) },
                        { "_ZN2nn8irsensor17RunIrLedProcessorERKNS0_14IrCameraHandleERKNS0_20IrLedProcessorConfigE", new Tuple<string, List<string>>("nn::irsensor::RunIrLedProcessor(nn::irsensor::IrCameraHandle const&, nn::irsensor::IrLedProcessorConfig const&)", new List<string>() { "5_BundleRules_NX_Private_IrSensorExtension_irsensorextension" }) },
                        { "_ZN2nn8irsensor22GetIrLedProcessorStateERKNS0_14IrCameraHandleE", new Tuple<string, List<string>>("nn::irsensor::GetIrLedProcessorState(nn::irsensor::IrCameraHandle const&)", new List<string>() { "5_BundleRules_NX_Private_IrSensorExtension_irsensorextension" }) },
                        { "_ZN2nn3hidL33ConsoleSixAxisSensorStateCountMaxE", new Tuple<string, List<string>>("nn::hid::ConsoleSixAxisSensorStateCountMax", new List<string>() { "5_BundleRules_NX_Private_ConsoleSixAxisSensor_consolesixaxissensor" }) },
                        { "_ZN2nn3hid30InitializeConsoleSixAxisSensorEv", new Tuple<string, List<string>>("nn::hid::InitializeConsoleSixAxisSensor()", new List<string>() { "5_BundleRules_NX_Private_ConsoleSixAxisSensor_consolesixaxissensor" }) },
                        { "_ZN2nn3hid22GetSixAxisSensorHandleEPNS0_26ConsoleSixAxisSensorHandleE", new Tuple<string, List<string>>("nn::hid::GetSixAxisSensorHandle(nn::hid::ConsoleSixAxisSensorHandle*)", new List<string>() { "5_BundleRules_NX_Private_ConsoleSixAxisSensor_consolesixaxissensor" }) },
                        { "_ZN2nn3hid18StartSixAxisSensorERKNS0_26ConsoleSixAxisSensorHandleE", new Tuple<string, List<string>>("nn::hid::StartSixAxisSensor(nn::hid::ConsoleSixAxisSensorHandle const&)", new List<string>() { "5_BundleRules_NX_Private_ConsoleSixAxisSensor_consolesixaxissensor" }) },
                        { "_ZN2nn3hid17StopSixAxisSensorERKNS0_26ConsoleSixAxisSensorHandleE", new Tuple<string, List<string>>("nn::hid::StopSixAxisSensor(nn::hid::ConsoleSixAxisSensorHandle const&)", new List<string>() { "5_BundleRules_NX_Private_ConsoleSixAxisSensor_consolesixaxissensor" }) },
                        { "_ZN2nn3hid3tmp34GetConsoleSixAxisSensorCountStatesEPNS1_23SixAxisSensorCountStateEiRKNS0_26ConsoleSixAxisSensorHandleE", new Tuple<string, List<string>>("nn::hid::tmp::GetConsoleSixAxisSensorCountStates(nn::hid::tmp::SixAxisSensorCountState*, int, nn::hid::ConsoleSixAxisSensorHandle const&)", new List<string>() { "5_BundleRules_NX_Private_ConsoleSixAxisSensor_consolesixaxissensor" }) },
                        { "_ZN2nn3hid3tmp40GetConsoleSixAxisSensorCalibrationValuesEPNS1_37ConsoleSixAxisSensorCalibrationValuesERKNS0_26ConsoleSixAxisSensorHandleE", new Tuple<string, List<string>>("nn::hid::tmp::GetConsoleSixAxisSensorCalibrationValues(nn::hid::tmp::ConsoleSixAxisSensorCalibrationValues*, nn::hid::ConsoleSixAxisSensorHandle const&)", new List<string>() { "5_BundleRules_NX_Private_ConsoleSixAxisSensor_consolesixaxissensor" }) },
                        { "_ZN2nn2oe29SaveGamePlayRecordingForDebugENS_8TimeSpanE", new Tuple<string, List<string>>("nn::oe::SaveGamePlayRecordingForDebug(nn::TimeSpan)", new List<string>() { "5_BundleRules_NX_Private_Oe_oe-GamePlayRecordingForDebug" }) },
                        { "_ZN2nn2os20FlushEntireDataCacheEv", new Tuple<string, List<string>>("nn::os::FlushEntireDataCache()", new List<string>() { "5_BundleRules_NX_Private_FlushEntireDataCache_FlushEntireDataCache" }) },
                        { "_ZN2nn3err21IsNetworkServiceErrorENS0_9ErrorCodeE", new Tuple<string, List<string>>("nn::err::IsNetworkServiceError(nn::err::ErrorCode)", new List<string>() { "5_BundleRules_Generic_Private_NetworkServiceError_network-service-error" }) },
                        { "_ZN2nn3err23ShowNetworkServiceErrorENS0_9ErrorCodeERKNS_7account10UserHandleE", new Tuple<string, List<string>>("nn::err::ShowNetworkServiceError(nn::err::ErrorCode, nn::account::UserHandle const&)", new List<string>() { "5_BundleRules_Generic_Private_NetworkServiceError_network-service-error" }) },
                        { "_ZN2nn3err23ShowNetworkServiceErrorENS0_9ErrorCodeE", new Tuple<string, List<string>>("nn::err::ShowNetworkServiceError(nn::err::ErrorCode)", new List<string>() { "5_BundleRules_Generic_Private_NetworkServiceError_network-service-error" }) },
                        { "_ZN2nn3err21IsNetworkServiceErrorENS_6ResultE", new Tuple<string, List<string>>("nn::err::IsNetworkServiceError(nn::Result)", new List<string>() { "5_BundleRules_Generic_Private_NetworkServiceError_network-service-error" }) },
                        { "_ZN2nn3err23ShowNetworkServiceErrorENS_6ResultERKNS_7account10UserHandleE", new Tuple<string, List<string>>("nn::err::ShowNetworkServiceError(nn::Result, nn::account::UserHandle const&)", new List<string>() { "5_BundleRules_Generic_Private_NetworkServiceError_network-service-error" }) },
                        { "_ZN2nn3err23ShowNetworkServiceErrorENS_6ResultE", new Tuple<string, List<string>>("nn::err::ShowNetworkServiceError(nn::Result)", new List<string>() { "5_BundleRules_Generic_Private_NetworkServiceError_network-service-error" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC2ERKS1_", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection(nn::nifm::NetworkConnection const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC1ERKS1_", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection(nn::nifm::NetworkConnection const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionaSERKS1_", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::operator=(nn::nifm::NetworkConnection const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC2EOS1_", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection(nn::nifm::NetworkConnection&&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC1EOS1_", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection(nn::nifm::NetworkConnection&&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionaSEOS1_", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::operator=(nn::nifm::NetworkConnection&&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC2Ev", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC1Ev", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC2ENS_2os14EventClearModeE", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection(nn::os::EventClearMode)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionC1ENS_2os14EventClearModeE", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::NetworkConnection(nn::os::EventClearMode)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionD2Ev", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::~NetworkConnection()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnectionD1Ev", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::~NetworkConnection()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection13SubmitRequestEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::SubmitRequest()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection20SubmitRequestAndWaitEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::SubmitRequestAndWait()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection13CancelRequestEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::CancelRequest()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection15IsRequestOnHoldEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::IsRequestOnHold()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection11IsAvailableEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::IsAvailable()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection14GetSystemEventEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::GetSystemEvent()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection26HandleNetworkRequestResultEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::HandleNetworkRequestResult()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection16GetRequestHandleEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::GetRequestHandle()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection9GetResultEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::GetResult()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm17NetworkConnection15GetRequestStateEv", new Tuple<string, List<string>>("nn::nifm::NetworkConnection::GetRequestState()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC2ERKS1_", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::Request const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC1ERKS1_", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::Request const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestaSERKS1_", new Tuple<string, List<string>>("nn::nifm::Request::operator=(nn::nifm::Request const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC2EOS1_", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::Request&&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC1EOS1_", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::Request&&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestaSEOS1_", new Tuple<string, List<string>>("nn::nifm::Request::operator=(nn::nifm::Request&&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC2ERKNS0_17RequestParametersE", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::RequestParameters const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC1ERKNS0_17RequestParametersE", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::RequestParameters const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC2ERKNS0_17RequestParametersENS_2os14EventClearModeE", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::RequestParameters const&, nn::os::EventClearMode)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestC1ERKNS0_17RequestParametersENS_2os14EventClearModeE", new Tuple<string, List<string>>("nn::nifm::Request::Request(nn::nifm::RequestParameters const&, nn::os::EventClearMode)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestD2Ev", new Tuple<string, List<string>>("nn::nifm::Request::~Request()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm7RequestD1Ev", new Tuple<string, List<string>>("nn::nifm::Request::~Request()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request6SubmitEv", new Tuple<string, List<string>>("nn::nifm::Request::Submit()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request13SubmitAndWaitEv", new Tuple<string, List<string>>("nn::nifm::Request::SubmitAndWait()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request6CancelEv", new Tuple<string, List<string>>("nn::nifm::Request::Cancel()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request15GetRequestStateEv", new Tuple<string, List<string>>("nn::nifm::Request::GetRequestState()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request9GetResultEv", new Tuple<string, List<string>>("nn::nifm::Request::GetResult()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request9GetHandleEv", new Tuple<string, List<string>>("nn::nifm::Request::GetHandle()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm7Request14GetSystemEventEv", new Tuple<string, List<string>>("nn::nifm::Request::GetSystemEvent()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC2ERKS1_", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::TemporaryNetworkProfile const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC1ERKS1_", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::TemporaryNetworkProfile const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileaSERKS1_", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::operator=(nn::nifm::TemporaryNetworkProfile const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC2EOS1_", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::TemporaryNetworkProfile&&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC1EOS1_", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::TemporaryNetworkProfile&&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileaSEOS1_", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::operator=(nn::nifm::TemporaryNetworkProfile&&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC2ERKNS0_18NetworkProfileDataE", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::NetworkProfileData const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileC1ERKNS0_18NetworkProfileDataE", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::TemporaryNetworkProfile(nn::nifm::NetworkProfileData const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileD2Ev", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::~TemporaryNetworkProfile()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfileD1Ev", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::~TemporaryNetworkProfile()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZNK2nn4nifm23TemporaryNetworkProfile5GetIdEv", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::GetId() const", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfile6UpdateERKNS0_18NetworkProfileDataE", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::Update(nn::nifm::NetworkProfileData const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm23TemporaryNetworkProfile9GetHandleEv", new Tuple<string, List<string>>("nn::nifm::TemporaryNetworkProfile::GetHandle()", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm10MacAddress4SizeE", new Tuple<string, List<string>>("nn::nifm::MacAddress::Size", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_10MacAddressES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::MacAddress const&, nn::nifm::MacAddress const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_10MacAddressES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::MacAddress const&, nn::nifm::MacAddress const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifmL24NetworkInterfaceCountMaxE", new Tuple<string, List<string>>("nn::nifm::NetworkInterfaceCountMax", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifmL26UserNetworkProfileCountMaxE", new Tuple<string, List<string>>("nn::nifm::UserNetworkProfileCountMax", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifmL30SsidListNetworkProfileCountMaxE", new Tuple<string, List<string>>("nn::nifm::SsidListNetworkProfileCountMax", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm23NetworkProfileBasicInfo8NameSizeE", new Tuple<string, List<string>>("nn::nifm::NetworkProfileBasicInfo::NameSize", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm15SsidListVersion4SizeE", new Tuple<string, List<string>>("nn::nifm::SsidListVersion::Size", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_18NetworkProfileDataES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::NetworkProfileData const&, nn::nifm::NetworkProfileData const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_18NetworkProfileDataES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::NetworkProfileData const&, nn::nifm::NetworkProfileData const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifmL22UserRequestPriorityTopE", new Tuple<string, List<string>>("nn::nifm::UserRequestPriorityTop", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifmL25UserRequestPriorityBottomE", new Tuple<string, List<string>>("nn::nifm::UserRequestPriorityBottom", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm4Ssid7HexSizeE", new Tuple<string, List<string>>("nn::nifm::Ssid::HexSize", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifm9SharedKey15KeyMaterialSizeE", new Tuple<string, List<string>>("nn::nifm::SharedKey::KeyMaterialSize", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifmL26InvalidWirelessSettingDataE", new Tuple<string, List<string>>("nn::nifm::InvalidWirelessSettingData", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_4SsidES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::Ssid const&, nn::nifm::Ssid const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_4SsidES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::Ssid const&, nn::nifm::Ssid const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_14AuthEncryptionES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::AuthEncryption const&, nn::nifm::AuthEncryption const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_14AuthEncryptionES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::AuthEncryption const&, nn::nifm::AuthEncryption const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_9SharedKeyES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::SharedKey const&, nn::nifm::SharedKey const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_9SharedKeyES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::SharedKey const&, nn::nifm::SharedKey const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_10SsidConfigES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::SsidConfig const&, nn::nifm::SsidConfig const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_10SsidConfigES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::SsidConfig const&, nn::nifm::SsidConfig const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_8SecurityES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::Security const&, nn::nifm::Security const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_8SecurityES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::Security const&, nn::nifm::Security const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifmeqERKNS0_19WirelessSettingDataES3_", new Tuple<string, List<string>>("nn::nifm::operator==(nn::nifm::WirelessSettingData const&, nn::nifm::WirelessSettingData const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn4nifmneERKNS0_19WirelessSettingDataES3_", new Tuple<string, List<string>>("nn::nifm::operator!=(nn::nifm::WirelessSettingData const&, nn::nifm::WirelessSettingData const&)", new List<string>() { "5_BundleRules_Generic_Private_NifmForNetworkMiddleware_NifmForNetworkMiddleware" }) },
                        { "_ZN2nn3nsd7ResolveEPNS0_4FqdnERKS1_", new Tuple<string, List<string>>("nn::nsd::Resolve(nn::nsd::Fqdn*, nn::nsd::Fqdn const&)", new List<string>() { "5_BundleRules_Generic_Private_NsdPrivate_NsdPrivate" }) },
                        { "_ZN2nn3nsd4Fqdn4SizeE", new Tuple<string, List<string>>("nn::nsd::Fqdn::Size", new List<string>() { "5_BundleRules_Generic_Private_NsdPrivate_NsdPrivate" }) },
                        { "_ZN2nn3nsdeqERKNS0_4FqdnES3_", new Tuple<string, List<string>>("nn::nsd::operator==(nn::nsd::Fqdn const&, nn::nsd::Fqdn const&)", new List<string>() { "5_BundleRules_Generic_Private_NsdPrivate_NsdPrivate" }) },
                        { "_ZN2nn3nsdneERKNS0_4FqdnES3_", new Tuple<string, List<string>>("nn::nsd::operator!=(nn::nsd::Fqdn const&, nn::nsd::Fqdn const&)", new List<string>() { "5_BundleRules_Generic_Private_NsdPrivate_NsdPrivate" }) },
                        { "_ZN2nn3nsd11SettingName4SizeE", new Tuple<string, List<string>>("nn::nsd::SettingName::Size", new List<string>() { "5_BundleRules_Generic_Private_NsdPrivate_NsdPrivate" }) },
                        { "_ZN2nn3nsd8PassCode4SizeE", new Tuple<string, List<string>>("nn::nsd::PassCode::Size", new List<string>() { "5_BundleRules_Generic_Private_NsdPrivate_NsdPrivate" }) },
                        { "_ZN2nn3nsd21EnvironmentIdentifier4SizeE", new Tuple<string, List<string>>("nn::nsd::EnvironmentIdentifier::Size", new List<string>() { "5_BundleRules_Generic_Private_NsdPrivate_NsdPrivate" }) },
                        { "_ZN2nn3nsdeqERKNS0_21EnvironmentIdentifierES3_", new Tuple<string, List<string>>("nn::nsd::operator==(nn::nsd::EnvironmentIdentifier const&, nn::nsd::EnvironmentIdentifier const&)", new List<string>() { "5_BundleRules_Generic_Private_NsdPrivate_NsdPrivate" }) },
                        { "_ZN2nn3nsdneERKNS0_21EnvironmentIdentifierES3_", new Tuple<string, List<string>>("nn::nsd::operator!=(nn::nsd::EnvironmentIdentifier const&, nn::nsd::EnvironmentIdentifier const&)", new List<string>() { "5_BundleRules_Generic_Private_NsdPrivate_NsdPrivate" }) },
                        { "_ZN2nn3web13ShowLobbyPageEPNS0_20LobbyPageReturnValueERKNS0_16ShowLobbyPageArgE", new Tuple<string, List<string>>("nn::web::ShowLobbyPage(nn::web::LobbyPageReturnValue*, nn::web::ShowLobbyPageArg const&)", new List<string>() { "5_BundleRules_NX_Private_WebLobby_WebLobby" }) },
                        { "_ZN2nn3web16ShowLobbyPageArg23LobbyParameterMaxLengthE", new Tuple<string, List<string>>("nn::web::ShowLobbyPageArg::LobbyParameterMaxLength", new List<string>() { "5_BundleRules_NX_Private_WebLobby_WebLobby" }) },
                        { "_ZN2nn3web16ShowLobbyPageArgC2Ev", new Tuple<string, List<string>>("nn::web::ShowLobbyPageArg::ShowLobbyPageArg()", new List<string>() { "5_BundleRules_NX_Private_WebLobby_WebLobby" }) },
                        { "_ZN2nn3web16ShowLobbyPageArgC1Ev", new Tuple<string, List<string>>("nn::web::ShowLobbyPageArg::ShowLobbyPageArg()", new List<string>() { "5_BundleRules_NX_Private_WebLobby_WebLobby" }) },
                        { "_ZN2nn3web16ShowLobbyPageArg6SetUidERKNS_7account3UidE", new Tuple<string, List<string>>("nn::web::ShowLobbyPageArg::SetUid(nn::account::Uid const&)", new List<string>() { "5_BundleRules_NX_Private_WebLobby_WebLobby" }) },
                        { "_ZN2nn3web16ShowLobbyPageArg17SetLobbyParameterEPKc", new Tuple<string, List<string>>("nn::web::ShowLobbyPageArg::SetLobbyParameter(char const*)", new List<string>() { "5_BundleRules_NX_Private_WebLobby_WebLobby" }) },
                        { "_ZN2nn3web16ShowLobbyPageArg8DataSizeE", new Tuple<string, List<string>>("nn::web::ShowLobbyPageArg::DataSize", new List<string>() { "5_BundleRules_NX_Private_WebLobby_WebLobby" }) },
                        { "_ZN2nn3web20LobbyPageReturnValue16LastUrlMaxLengthE", new Tuple<string, List<string>>("nn::web::LobbyPageReturnValue::LastUrlMaxLength", new List<string>() { "5_BundleRules_NX_Private_WebLobby_WebLobby" }) },
                        { "_ZN2nn3web20LobbyPageReturnValueC2Ev", new Tuple<string, List<string>>("nn::web::LobbyPageReturnValue::LobbyPageReturnValue()", new List<string>() { "5_BundleRules_NX_Private_WebLobby_WebLobby" }) },
                        { "_ZN2nn3web20LobbyPageReturnValueC1Ev", new Tuple<string, List<string>>("nn::web::LobbyPageReturnValue::LobbyPageReturnValue()", new List<string>() { "5_BundleRules_NX_Private_WebLobby_WebLobby" }) },
                        { "_ZNK2nn3web20LobbyPageReturnValue18GetLobbyExitReasonEv", new Tuple<string, List<string>>("nn::web::LobbyPageReturnValue::GetLobbyExitReason() const", new List<string>() { "5_BundleRules_NX_Private_WebLobby_WebLobby" }) },
                        { "_ZNK2nn3web20LobbyPageReturnValue10GetLastUrlEv", new Tuple<string, List<string>>("nn::web::LobbyPageReturnValue::GetLastUrl() const", new List<string>() { "5_BundleRules_NX_Private_WebLobby_WebLobby" }) },
                        { "_ZNK2nn3web20LobbyPageReturnValue14GetLastUrlSizeEv", new Tuple<string, List<string>>("nn::web::LobbyPageReturnValue::GetLastUrlSize() const", new List<string>() { "5_BundleRules_NX_Private_WebLobby_WebLobby" }) },
                        { "_ZN2nn5prepo10InitializeEv", new Tuple<string, List<string>>("nn::prepo::Initialize()", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo28RequestImmediateTransmissionEv", new Tuple<string, List<string>>("nn::prepo::RequestImmediateTransmission()", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo21GetTransmissionStatusEPNS0_18TransmissionStatusE", new Tuple<string, List<string>>("nn::prepo::GetTransmissionStatus(nn::prepo::TransmissionStatus*)", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportC2ERKS1_", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport(nn::prepo::PlayReport const&)", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportC1ERKS1_", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport(nn::prepo::PlayReport const&)", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportaSERKS1_", new Tuple<string, List<string>>("nn::prepo::PlayReport::operator=(nn::prepo::PlayReport const&)", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportC2EOS1_", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport(nn::prepo::PlayReport&&)", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportC1EOS1_", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport(nn::prepo::PlayReport&&)", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportaSEOS1_", new Tuple<string, List<string>>("nn::prepo::PlayReport::operator=(nn::prepo::PlayReport&&)", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport13BufferSizeMinE", new Tuple<string, List<string>>("nn::prepo::PlayReport::BufferSizeMin", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport13BufferSizeMaxE", new Tuple<string, List<string>>("nn::prepo::PlayReport::BufferSizeMax", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportC2Ev", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport()", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportC1Ev", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport()", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportC2EPKc", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport(char const*)", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReportC1EPKc", new Tuple<string, List<string>>("nn::prepo::PlayReport::PlayReport(char const*)", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport9SetBufferEPvm", new Tuple<string, List<string>>("nn::prepo::PlayReport::SetBuffer(void*, unsigned long)", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport10SetEventIdEPKc", new Tuple<string, List<string>>("nn::prepo::PlayReport::SetEventId(char const*)", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport5ClearEv", new Tuple<string, List<string>>("nn::prepo::PlayReport::Clear()", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport3AddEPKcl", new Tuple<string, List<string>>("nn::prepo::PlayReport::Add(char const*, long)", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport3AddEPKcRKNS0_10Any64BitIdE", new Tuple<string, List<string>>("nn::prepo::PlayReport::Add(char const*, nn::prepo::Any64BitId const&)", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport3AddEPKcd", new Tuple<string, List<string>>("nn::prepo::PlayReport::Add(char const*, double)", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport3AddEPKcS3_", new Tuple<string, List<string>>("nn::prepo::PlayReport::Add(char const*, char const*)", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport4SaveEv", new Tuple<string, List<string>>("nn::prepo::PlayReport::Save()", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport4SaveERKNS_7account3UidE", new Tuple<string, List<string>>("nn::prepo::PlayReport::Save(nn::account::Uid const&)", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZNK2nn5prepo10PlayReport8GetCountEv", new Tuple<string, List<string>>("nn::prepo::PlayReport::GetCount() const", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport9SetBufferEPvj", new Tuple<string, List<string>>("nn::prepo::PlayReport::SetBuffer(void*, unsigned int)", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepo10PlayReport3AddEPKcx", new Tuple<string, List<string>>("nn::prepo::PlayReport::Add(char const*, long long)", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepoL16KeyValueCountMaxE", new Tuple<string, List<string>>("nn::prepo::KeyValueCountMax", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepoL16EventIdLengthMaxE", new Tuple<string, List<string>>("nn::prepo::EventIdLengthMax", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepoL12KeyLengthMaxE", new Tuple<string, List<string>>("nn::prepo::KeyLengthMax", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepoL20StringValueLengthMaxE", new Tuple<string, List<string>>("nn::prepo::StringValueLengthMax", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn5prepoL15KeyValueSizeMaxE", new Tuple<string, List<string>>("nn::prepo::KeyValueSizeMax", new List<string>() { "5_BundleRules_Generic_Private_PlayReport_play-report" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC2ERKS1_", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(nn::os::SdkThreadLocalStorage const&)", new List<string>() { "5_BundleRules_Generic_Private_OsSdkThreadLocalStorage_OsSdkThreadLocalStorage" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC1ERKS1_", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(nn::os::SdkThreadLocalStorage const&)", new List<string>() { "5_BundleRules_Generic_Private_OsSdkThreadLocalStorage_OsSdkThreadLocalStorage" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageaSERKS1_", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::operator=(nn::os::SdkThreadLocalStorage const&)", new List<string>() { "5_BundleRules_Generic_Private_OsSdkThreadLocalStorage_OsSdkThreadLocalStorage" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC2EOS1_", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(nn::os::SdkThreadLocalStorage&&)", new List<string>() { "5_BundleRules_Generic_Private_OsSdkThreadLocalStorage_OsSdkThreadLocalStorage" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC1EOS1_", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(nn::os::SdkThreadLocalStorage&&)", new List<string>() { "5_BundleRules_Generic_Private_OsSdkThreadLocalStorage_OsSdkThreadLocalStorage" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageaSEOS1_", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::operator=(nn::os::SdkThreadLocalStorage&&)", new List<string>() { "5_BundleRules_Generic_Private_OsSdkThreadLocalStorage_OsSdkThreadLocalStorage" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC2Ev", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage()", new List<string>() { "5_BundleRules_Generic_Private_OsSdkThreadLocalStorage_OsSdkThreadLocalStorage" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC1Ev", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage()", new List<string>() { "5_BundleRules_Generic_Private_OsSdkThreadLocalStorage_OsSdkThreadLocalStorage" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC2EPFvmE", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(void (*)(unsigned long))", new List<string>() { "5_BundleRules_Generic_Private_OsSdkThreadLocalStorage_OsSdkThreadLocalStorage" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC1EPFvmE", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(void (*)(unsigned long))", new List<string>() { "5_BundleRules_Generic_Private_OsSdkThreadLocalStorage_OsSdkThreadLocalStorage" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageD2Ev", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::~SdkThreadLocalStorage()", new List<string>() { "5_BundleRules_Generic_Private_OsSdkThreadLocalStorage_OsSdkThreadLocalStorage" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageD1Ev", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::~SdkThreadLocalStorage()", new List<string>() { "5_BundleRules_Generic_Private_OsSdkThreadLocalStorage_OsSdkThreadLocalStorage" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorage8SetValueEm", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SetValue(unsigned long)", new List<string>() { "5_BundleRules_Generic_Private_OsSdkThreadLocalStorage_OsSdkThreadLocalStorage" }) },
                        { "_ZNK2nn2os21SdkThreadLocalStorage8GetValueEv", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::GetValue() const", new List<string>() { "5_BundleRules_Generic_Private_OsSdkThreadLocalStorage_OsSdkThreadLocalStorage" }) },
                        { "_ZNK2nn2os21SdkThreadLocalStorage10GetTlsSlotEv", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::GetTlsSlot() const", new List<string>() { "5_BundleRules_Generic_Private_OsSdkThreadLocalStorage_OsSdkThreadLocalStorage" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC2EPFvjE", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(void (*)(unsigned int))", new List<string>() { "5_BundleRules_Generic_Private_OsSdkThreadLocalStorage_OsSdkThreadLocalStorage" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorageC1EPFvjE", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SdkThreadLocalStorage(void (*)(unsigned int))", new List<string>() { "5_BundleRules_Generic_Private_OsSdkThreadLocalStorage_OsSdkThreadLocalStorage" }) },
                        { "_ZN2nn2os21SdkThreadLocalStorage8SetValueEj", new Tuple<string, List<string>>("nn::os::SdkThreadLocalStorage::SetValue(unsigned int)", new List<string>() { "5_BundleRules_Generic_Private_OsSdkThreadLocalStorage_OsSdkThreadLocalStorage" }) },
                        { "_ZN2nn2os18SdkAllocateTlsSlotEPNS0_7TlsSlotEPFvmE", new Tuple<string, List<string>>("nn::os::SdkAllocateTlsSlot(nn::os::TlsSlot*, void (*)(unsigned long))", new List<string>() { "5_BundleRules_Generic_Private_OsSdkThreadLocalStorage_OsSdkThreadLocalStorage" }) },
                        { "_ZN2nn2os18SdkAllocateTlsSlotEPNS0_7TlsSlotEPFvjE", new Tuple<string, List<string>>("nn::os::SdkAllocateTlsSlot(nn::os::TlsSlot*, void (*)(unsigned int))", new List<string>() { "5_BundleRules_Generic_Private_OsSdkThreadLocalStorage_OsSdkThreadLocalStorage" }) },
                        { "_ZN2nn4diag13OnResultThrowENS_6ResultERKNS0_10SourceInfoE", new Tuple<string, List<string>>("nn::diag::OnResultThrow(nn::Result, nn::diag::SourceInfo const&)", new List<string>() { "5_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn4diag14OnResultHandleENS_6ResultERKNS0_10SourceInfoE", new Tuple<string, List<string>>("nn::diag::OnResultHandle(nn::Result, nn::diag::SourceInfo const&)", new List<string>() { "5_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn4diag15OnResultRethrowENS_6ResultERKNS0_10SourceInfoE", new Tuple<string, List<string>>("nn::diag::OnResultRethrow(nn::Result, nn::diag::SourceInfo const&)", new List<string>() { "5_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn4diag13OnResultCatchENS_6ResultERKNS0_10SourceInfoE", new Tuple<string, List<string>>("nn::diag::OnResultCatch(nn::Result, nn::diag::SourceInfo const&)", new List<string>() { "5_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn4diag12OnResultMissENS_6ResultERKNS0_10SourceInfoE", new Tuple<string, List<string>>("nn::diag::OnResultMiss(nn::Result, nn::diag::SourceInfo const&)", new List<string>() { "5_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail18ConvertInvalidImplENS_6ResultE", new Tuple<string, List<string>>("nn::result::detail::ConvertInvalidImpl(nn::Result)", new List<string>() { "5_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail19ResultAutoConverterC2ENS_6ResultE", new Tuple<string, List<string>>("nn::result::detail::ResultAutoConverter::ResultAutoConverter(nn::Result)", new List<string>() { "5_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail19ResultAutoConverterC1ENS_6ResultE", new Tuple<string, List<string>>("nn::result::detail::ResultAutoConverter::ResultAutoConverter(nn::Result)", new List<string>() { "5_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail23MakeResultAutoConverterENS_6ResultE", new Tuple<string, List<string>>("nn::result::detail::MakeResultAutoConverter(nn::Result)", new List<string>() { "5_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderC2ERKNS1_17ResultBlockHolderIT_T0_EE", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::ResultBlockHolder", new List<string>() { "5_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderC1ERKNS1_17ResultBlockHolderIT_T0_EE", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::ResultBlockHolder", new List<string>() { "5_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderC2EOT0_", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::ResultBlockHolder", new List<string>() { "5_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderC1EOT0_", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::ResultBlockHolder", new List<string>() { "5_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderC2EONS1_17ResultBlockHolderIT_T0_EE", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::ResultBlockHolder", new List<string>() { "5_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderC1EONS1_17ResultBlockHolderIT_T0_EE", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::ResultBlockHolder", new List<string>() { "5_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderD2Ev", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::~ResultBlockHolder()", new List<string>() { "5_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail17ResultBlockHolderD1Ev", new Tuple<string, List<string>>("nn::result::detail::ResultBlockHolder::~ResultBlockHolder()", new List<string>() { "5_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail14AbortForResult6HandleENS_6ResultE", new Tuple<string, List<string>>("nn::result::detail::AbortForResult::Handle(nn::Result)", new List<string>() { "5_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn6result6detail15IgnoreForResult6HandleENS_6ResultE", new Tuple<string, List<string>>("nn::result::detail::IgnoreForResult::Handle(nn::Result)", new List<string>() { "5_BundleRules_Generic_Private_ResultHandlingUtility_ResultHandlingUtility" }) },
                        { "_ZN2nn3lbl27EnableAutoBrightnessControlEv", new Tuple<string, List<string>>("nn::lbl::EnableAutoBrightnessControl()", new List<string>() { "5_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl28DisableAutoBrightnessControlEv", new Tuple<string, List<string>>("nn::lbl::DisableAutoBrightnessControl()", new List<string>() { "5_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl30IsAutoBrightnessControlEnabledEv", new Tuple<string, List<string>>("nn::lbl::IsAutoBrightnessControlEnabled()", new List<string>() { "5_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl26SetAmbientLightSensorValueEf", new Tuple<string, List<string>>("nn::lbl::SetAmbientLightSensorValue(float)", new List<string>() { "5_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl26GetAmbientLightSensorValueEPb", new Tuple<string, List<string>>("nn::lbl::GetAmbientLightSensorValue(bool*)", new List<string>() { "5_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl29IsAmbientLightSensorAvailableEv", new Tuple<string, List<string>>("nn::lbl::IsAmbientLightSensorAvailable()", new List<string>() { "5_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl33SetBrightnessReflectionDelayLevelENS0_25BrightnessChangeDirectionEf", new Tuple<string, List<string>>("nn::lbl::SetBrightnessReflectionDelayLevel(nn::lbl::BrightnessChangeDirection, float)", new List<string>() { "5_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl33GetBrightnessReflectionDelayLevelENS0_25BrightnessChangeDirectionE", new Tuple<string, List<string>>("nn::lbl::GetBrightnessReflectionDelayLevel(nn::lbl::BrightnessChangeDirection)", new List<string>() { "5_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl40ApplyCurrentBrightnessSettingToBacklightEv", new Tuple<string, List<string>>("nn::lbl::ApplyCurrentBrightnessSettingToBacklight()", new List<string>() { "5_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl38GetBrightnessSettingAppliedToBacklightEv", new Tuple<string, List<string>>("nn::lbl::GetBrightnessSettingAppliedToBacklight()", new List<string>() { "5_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl27SetCurrentBrightnessMappingERKNS0_18MappingCoefficientE", new Tuple<string, List<string>>("nn::lbl::SetCurrentBrightnessMapping(nn::lbl::MappingCoefficient const&)", new List<string>() { "5_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl27GetCurrentBrightnessMappingEPNS0_18MappingCoefficientE", new Tuple<string, List<string>>("nn::lbl::GetCurrentBrightnessMapping(nn::lbl::MappingCoefficient*)", new List<string>() { "5_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl35SetCurrentAmbientLightSensorMappingERKNS0_18MappingCoefficientE", new Tuple<string, List<string>>("nn::lbl::SetCurrentAmbientLightSensorMapping(nn::lbl::MappingCoefficient const&)", new List<string>() { "5_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl35GetCurrentAmbientLightSensorMappingEPNS0_18MappingCoefficientE", new Tuple<string, List<string>>("nn::lbl::GetCurrentAmbientLightSensorMapping(nn::lbl::MappingCoefficient*)", new List<string>() { "5_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl27SetCurrentBrightnessSettingEf", new Tuple<string, List<string>>("nn::lbl::SetCurrentBrightnessSetting(float)", new List<string>() { "5_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl27GetCurrentBrightnessSettingEv", new Tuple<string, List<string>>("nn::lbl::GetCurrentBrightnessSetting()", new List<string>() { "5_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lbl18LoadCurrentSettingEv", new Tuple<string, List<string>>("nn::lbl::LoadCurrentSetting()", new List<string>() { "5_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3lblL18CoefficentCountMaxE", new Tuple<string, List<string>>("nn::lbl::CoefficentCountMax", new List<string>() { "5_BundleRules_NX_Private_BrightnessControlPrivate_BrightnessControlPrivate" }) },
                        { "_ZN2nn3cecL21RemoteControlVolumeUpE", new Tuple<string, List<string>>("nn::cec::RemoteControlVolumeUp", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cecL23RemoteControlVolumeDownE", new Tuple<string, List<string>>("nn::cec::RemoteControlVolumeDown", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cecL23RemoteControlVolumeMuteE", new Tuple<string, List<string>>("nn::cec::RemoteControlVolumeMute", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec10InitializeEPNS_2os15SystemEventTypeE", new Tuple<string, List<string>>("nn::cec::Initialize(nn::os::SystemEventType*)", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec8FinalizeEPNS_2os15SystemEventTypeE", new Tuple<string, List<string>>("nn::cec::Finalize(nn::os::SystemEventType*)", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec19PerformOneTouchPlayEv", new Tuple<string, List<string>>("nn::cec::PerformOneTouchPlay()", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec18PerformImageViewOnEv", new Tuple<string, List<string>>("nn::cec::PerformImageViewOn()", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec19PerformActiveSourceEv", new Tuple<string, List<string>>("nn::cec::PerformActiveSource()", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec20SetActiveSourceStateEv", new Tuple<string, List<string>>("nn::cec::SetActiveSourceState()", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec16PerformGoStandbyEb", new Tuple<string, List<string>>("nn::cec::PerformGoStandby(bool)", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec21PerformInactiveSourceEv", new Tuple<string, List<string>>("nn::cec::PerformInactiveSource()", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec31PerformSendRemoteControlCommandEbh", new Tuple<string, List<string>>("nn::cec::PerformSendRemoteControlCommand(bool, unsigned char)", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec33PerformSendDeviceMenuStateCommandEb", new Tuple<string, List<string>>("nn::cec::PerformSendDeviceMenuStateCommand(bool)", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec17SetOnScreenStringEPKc", new Tuple<string, List<string>>("nn::cec::SetOnScreenString(char const*)", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec13SetPowerStateENS0_10PowerStateE", new Tuple<string, List<string>>("nn::cec::SetPowerState(nn::cec::PowerState)", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec14SuspendManagerEv", new Tuple<string, List<string>>("nn::cec::SuspendManager()", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec14RestartManagerEv", new Tuple<string, List<string>>("nn::cec::RestartManager()", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec20CancelCurrentApiCallEPb", new Tuple<string, List<string>>("nn::cec::CancelCurrentApiCall(bool*)", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec9IsStartedEPb", new Tuple<string, List<string>>("nn::cec::IsStarted(bool*)", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec13GetPowerStateEPNS0_10PowerStateE", new Tuple<string, List<string>>("nn::cec::GetPowerState(nn::cec::PowerState*)", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec15GetTvPowerStateEPNS0_10PowerStateE", new Tuple<string, List<string>>("nn::cec::GetTvPowerState(nn::cec::PowerState*)", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec14IsTvResponsiveEPb", new Tuple<string, List<string>>("nn::cec::IsTvResponsive(bool*)", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec18GetConnectionStateEPNS0_15ConnectionStateE", new Tuple<string, List<string>>("nn::cec::GetConnectionState(nn::cec::ConnectionState*)", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec11GetHpdStateEPb", new Tuple<string, List<string>>("nn::cec::GetHpdState(bool*)", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec9IsEnabledEPb", new Tuple<string, List<string>>("nn::cec::IsEnabled(bool*)", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec14IsActiveSourceEPb", new Tuple<string, List<string>>("nn::cec::IsActiveSource(bool*)", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec15GetBusEventTypeEPNS0_12BusEventTypeE", new Tuple<string, List<string>>("nn::cec::GetBusEventType(nn::cec::BusEventType*)", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn3cec20GetHdcpServiceObjectEPNS_2sf13SharedPointerINS_4hdcp6detail15IHdcpControllerEEE", new Tuple<string, List<string>>("nn::cec::GetHdcpServiceObject(nn::sf::SharedPointer<nn::hdcp::detail::IHdcpController>*)", new List<string>() { "5_BundleDefinitions_NX_VideoInterface_Private" }) },
                        { "_ZN2nn2vi17GetDisplayCmuModeEPNS0_7CmuModeEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayCmuMode(nn::vi::CmuMode*, nn::vi::Display const*)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi17SetDisplayCmuModeEPNS0_7DisplayENS0_7CmuModeE", new Tuple<string, List<string>>("nn::vi::SetDisplayCmuMode(nn::vi::Display*, nn::vi::CmuMode)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi23GetDisplayContrastRatioEPfPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayContrastRatio(float*, nn::vi::Display const*)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi23SetDisplayContrastRatioEPNS0_7DisplayEf", new Tuple<string, List<string>>("nn::vi::SetDisplayContrastRatio(nn::vi::Display*, float)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi15GetDisplayGammaEPfPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayGamma(float*, nn::vi::Display const*)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi15SetDisplayGammaEPNS0_7DisplayEf", new Tuple<string, List<string>>("nn::vi::SetDisplayGamma(nn::vi::Display*, float)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi17GetZOrderCountMinEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetZOrderCountMin(nn::vi::Display const*)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi17GetZOrderCountMaxEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetZOrderCountMax(nn::vi::Display const*)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi20GetDisplayResolutionEPiS1_PKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayResolution(int*, int*, nn::vi::Display const*)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi27GetDisplayLogicalResolutionEPiS1_PKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayLogicalResolution(int*, int*, nn::vi::Display const*)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi23SetDisplayMagnificationEPNS0_7DisplayEiiii", new Tuple<string, List<string>>("nn::vi::SetDisplayMagnification(nn::vi::Display*, int, int, int, int)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2viL19DisplayModeCountMaxE", new Tuple<string, List<string>>("nn::vi::DisplayModeCountMax", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi16ListDisplayModesEPNS0_15DisplayModeInfoEiPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::ListDisplayModes(nn::vi::DisplayModeInfo*, int, nn::vi::Display const*)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi20ListDisplayRgbRangesEPNS0_8RgbRangeEiPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::ListDisplayRgbRanges(nn::vi::RgbRange*, int, nn::vi::Display const*)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi23ListDisplayContentTypesEPNS0_11ContentTypeEiPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::ListDisplayContentTypes(nn::vi::ContentType*, int, nn::vi::Display const*)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi14GetDisplayModeEPNS0_15DisplayModeInfoEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayMode(nn::vi::DisplayModeInfo*, nn::vi::Display const*)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi14SetDisplayModeEPNS0_7DisplayEPKNS0_15DisplayModeInfoE", new Tuple<string, List<string>>("nn::vi::SetDisplayMode(nn::vi::Display*, nn::vi::DisplayModeInfo const*)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi19GetDisplayUnderscanEPiPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayUnderscan(int*, nn::vi::Display const*)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi19SetDisplayUnderscanEPNS0_7DisplayEi", new Tuple<string, List<string>>("nn::vi::SetDisplayUnderscan(nn::vi::Display*, int)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi21GetDisplayContentTypeEPNS0_11ContentTypeEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayContentType(nn::vi::ContentType*, nn::vi::Display const*)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi21SetDisplayContentTypeEPNS0_7DisplayENS0_11ContentTypeE", new Tuple<string, List<string>>("nn::vi::SetDisplayContentType(nn::vi::Display*, nn::vi::ContentType)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi18GetDisplayRgbRangeEPNS0_8RgbRangeEPKNS0_7DisplayE", new Tuple<string, List<string>>("nn::vi::GetDisplayRgbRange(nn::vi::RgbRange*, nn::vi::Display const*)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi18SetDisplayRgbRangeEPNS0_7DisplayENS0_8RgbRangeE", new Tuple<string, List<string>>("nn::vi::SetDisplayRgbRange(nn::vi::Display*, nn::vi::RgbRange)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi11CreateLayerEPPNS0_5LayerEPNS0_7DisplayENS_4util10BitFlagSetILi32ENS0_10LayerFlagsEEE", new Tuple<string, List<string>>("nn::vi::CreateLayer(nn::vi::Layer**, nn::vi::Display*, nn::util::BitFlagSet<32, nn::vi::LayerFlags>)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi16SetLayerPositionEPNS0_5LayerEff", new Tuple<string, List<string>>("nn::vi::SetLayerPosition(nn::vi::Layer*, float, float)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi12SetLayerSizeEPNS0_5LayerEii", new Tuple<string, List<string>>("nn::vi::SetLayerSize(nn::vi::Layer*, int, int)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi9SetLayerZEPNS0_5LayerEi", new Tuple<string, List<string>>("nn::vi::SetLayerZ(nn::vi::Layer*, int)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi9GetLayerZEPiPKNS0_5LayerE", new Tuple<string, List<string>>("nn::vi::GetLayerZ(int*, nn::vi::Layer const*)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi13SetLayerAlphaEPNS0_5LayerEf", new Tuple<string, List<string>>("nn::vi::SetLayerAlpha(nn::vi::Layer*, float)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN2nn2vi24SetLayerSettingsDefaultsEPNS_4util10BitFlagSetILi32ENS0_10LayerFlagsEEE", new Tuple<string, List<string>>("nn::vi::SetLayerSettingsDefaults(nn::util::BitFlagSet<32, nn::vi::LayerFlags>*)", new List<string>() { "5_BundleRules_NX_Private_VideoInterfacePrivate_VideoInterfacePrivate" }) },
                        { "_ZN5movie13BrowserConfigC2Ev", new Tuple<string, List<string>>("movie::BrowserConfig::BrowserConfig()", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserConfigC1Ev", new Tuple<string, List<string>>("movie::BrowserConfig::BrowserConfig()", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer6CreateEPPS0_PNS_12PlayerConfigE", new Tuple<string, List<string>>("movie::BrowserPlayer::Create(movie::BrowserPlayer**, movie::PlayerConfig*)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer6CreateEPPS0_PNS_12PlayerConfigEPNS_13BrowserConfigE", new Tuple<string, List<string>>("movie::BrowserPlayer::Create(movie::BrowserPlayer**, movie::PlayerConfig*, movie::BrowserConfig*)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer7DestroyEPS0_", new Tuple<string, List<string>>("movie::BrowserPlayer::Destroy(movie::BrowserPlayer*)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer11CanPlayTypeEPKcS2_", new Tuple<string, List<string>>("movie::BrowserPlayer::CanPlayType(char const*, char const*)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer12SetCacheSizeENS0_9CacheSizeE", new Tuple<string, List<string>>("movie::BrowserPlayer::SetCacheSize(movie::BrowserPlayer::CacheSize)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer11IsCacheFullEPb", new Tuple<string, List<string>>("movie::BrowserPlayer::IsCacheFull(bool*)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer16GetBufferedRangeEPfS1_", new Tuple<string, List<string>>("movie::BrowserPlayer::GetBufferedRange(float*, float*)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer22GetSupportedTypesCountEv", new Tuple<string, List<string>>("movie::BrowserPlayer::GetSupportedTypesCount()", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer16GetSupportedTypeEi", new Tuple<string, List<string>>("movie::BrowserPlayer::GetSupportedType(int)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer12SetMSESourceEPKNS_9MSESourceE", new Tuple<string, List<string>>("movie::BrowserPlayer::SetMSESource(movie::MSESource const*)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer12GetMSESourceEPPNS_9MSESourceE", new Tuple<string, List<string>>("movie::BrowserPlayer::GetMSESource(movie::MSESource**)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer11SetObserverEPNS_21BrowserPlayerObserverE", new Tuple<string, List<string>>("movie::BrowserPlayer::SetObserver(movie::BrowserPlayerObserver*)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayer11GetObserverEPPNS_21BrowserPlayerObserverE", new Tuple<string, List<string>>("movie::BrowserPlayer::GetObserver(movie::BrowserPlayerObserver**)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayerC2Ev", new Tuple<string, List<string>>("movie::BrowserPlayer::BrowserPlayer()", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayerD2Ev", new Tuple<string, List<string>>("movie::BrowserPlayer::~BrowserPlayer()", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayerD1Ev", new Tuple<string, List<string>>("movie::BrowserPlayer::~BrowserPlayer()", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie13BrowserPlayerD0Ev", new Tuple<string, List<string>>("movie::BrowserPlayer::~BrowserPlayer()", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie21BrowserPlayerObserver10OnCurlInitEPvPKc", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::OnCurlInit(void*, char const*)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie21BrowserPlayerObserver13OnHttpRequestEPvPKc", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::OnHttpRequest(void*, char const*)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie21BrowserPlayerObserver13OnMultiConfigEPvPKc", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::OnMultiConfig(void*, char const*)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie21BrowserPlayerObserver14OnHttpResponseEPvPKc", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::OnHttpResponse(void*, char const*)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie21BrowserPlayerObserverD2Ev", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::~BrowserPlayerObserver()", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie21BrowserPlayerObserverD1Ev", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::~BrowserPlayerObserver()", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie21BrowserPlayerObserverD0Ev", new Tuple<string, List<string>>("movie::BrowserPlayerObserver::~BrowserPlayerObserver()", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec6CreateEPPS0_PKcbbbb", new Tuple<string, List<string>>("movie::Codec::Create(movie::Codec**, char const*, bool, bool, bool, bool)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec7DestroyEPS0_", new Tuple<string, List<string>>("movie::Codec::Destroy(movie::Codec*)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec9ConfigureEPNS_9MediaDataEPN2nn2vi5LayerEPv", new Tuple<string, List<string>>("movie::Codec::Configure(movie::MediaData*, nn::vi::Layer*, void*)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec11SetCallbackEPNS_13CodecCallbackE", new Tuple<string, List<string>>("movie::Codec::SetCallback(movie::CodecCallback*)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec13SetInputLayerEPN2nn2vi5LayerE", new Tuple<string, List<string>>("movie::Codec::SetInputLayer(nn::vi::Layer*)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec5StartEv", new Tuple<string, List<string>>("movie::Codec::Start()", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec4StopEv", new Tuple<string, List<string>>("movie::Codec::Stop()", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec5ResetEv", new Tuple<string, List<string>>("movie::Codec::Reset()", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec7ReleaseEv", new Tuple<string, List<string>>("movie::Codec::Release()", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec5FlushEv", new Tuple<string, List<string>>("movie::Codec::Flush()", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec14GetInputBufferEiPNS_6BufferE", new Tuple<string, List<string>>("movie::Codec::GetInputBuffer(int, movie::Buffer*)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec16QueueInputBufferEiiilj", new Tuple<string, List<string>>("movie::Codec::QueueInputBuffer(int, int, int, long, unsigned int)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec15GetOutputBufferEiPNS_6BufferE", new Tuple<string, List<string>>("movie::Codec::GetOutputBuffer(int, movie::Buffer*)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec19ReleaseOutputBufferEi", new Tuple<string, List<string>>("movie::Codec::ReleaseOutputBuffer(int)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) },
                        { "_ZN5movie5Codec28RenderOutputBufferAndReleaseEi", new Tuple<string, List<string>>("movie::Codec::RenderOutputBufferAndRelease(int)", new List<string>() { "5_BundleRules_NX_Private_MultimediaInterfacePrivate_MultimediaInterfacePrivate" }) }