﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace Nintendo.Authoring.AuthoringLibrary
{
    public class Log
    {
        // TODO: yml 等のパース用途向けの形式でも出力できるようにする

        static private bool g_isInfoEnabled;
        static private bool g_isProgressEnabled;

        static public void EnableInfo()
        {
            g_isInfoEnabled = true;
        }

        static public void EnableProgress()
        {
            g_isProgressEnabled = true;
        }

        static public void Warning(string str)
        {
            Console.WriteLine("[Warning] " + str);
        }

        static public void Progress(string str)
        {
            if (g_isProgressEnabled)
            {
                Console.WriteLine("[Progress] " + str);
            }
        }

        static public void Info(string str)
        {
            if (g_isInfoEnabled)
            {
                Console.WriteLine("[Info] " + str);
            }
        }
    }
}
