﻿using System;
using System.Collections.Generic;

namespace Nintendo.ApplicationControlProperty
{
    public static class UnsupportedCharacterChecker
    {
        internal static readonly char[] SupportedCharacters =
        {
            '\u0020', '\u0021', '\u0022', '\u0023', '\u0024', '\u0025', '\u0026', '\u0027', '\u0028', '\u0029', '\u002A', '\u002B', '\u002C', '\u002D', '\u002E', '\u002F', '\u0030', '\u0031', '\u0032', '\u0033', '\u0034', '\u0035', '\u0036', '\u0037', '\u0038', '\u0039', '\u003A', '\u003B', '\u003C', '\u003D', '\u003E', '\u003F',
            '\u0040', '\u0041', '\u0042', '\u0043', '\u0044', '\u0045', '\u0046', '\u0047', '\u0048', '\u0049', '\u004A', '\u004B', '\u004C', '\u004D', '\u004E', '\u004F', '\u0050', '\u0051', '\u0052', '\u0053', '\u0054', '\u0055', '\u0056', '\u0057', '\u0058', '\u0059', '\u005A', '\u005B', '\u005C', '\u005D', '\u005E', '\u005F',
            '\u0060', '\u0061', '\u0062', '\u0063', '\u0064', '\u0065', '\u0066', '\u0067', '\u0068', '\u0069', '\u006A', '\u006B', '\u006C', '\u006D', '\u006E', '\u006F', '\u0070', '\u0071', '\u0072', '\u0073', '\u0074', '\u0075', '\u0076', '\u0077', '\u0078', '\u0079', '\u007A', '\u007B', '\u007C', '\u007D', '\u007E', '\u007F',
            '\u00A0', '\u00A1', '\u00A2', '\u00A3', '\u00A4', '\u00A5', '\u00A6', '\u00A7', '\u00A8', '\u00A9', '\u00AA', '\u00AB', '\u00AC', '\u00AD', '\u00AE', '\u00AF', '\u00B0', '\u00B1', '\u00B2', '\u00B3', '\u00B4', '\u00B5', '\u00B6', '\u00B7', '\u00B8', '\u00B9', '\u00BA', '\u00BB', '\u00BC', '\u00BD', '\u00BE', '\u00BF',
            '\u00C0', '\u00C1', '\u00C2', '\u00C3', '\u00C4', '\u00C5', '\u00C6', '\u00C7', '\u00C8', '\u00C9', '\u00CA', '\u00CB', '\u00CC', '\u00CD', '\u00CE', '\u00CF', '\u00D0', '\u00D1', '\u00D2', '\u00D3', '\u00D4', '\u00D5', '\u00D6', '\u00D7', '\u00D8', '\u00D9', '\u00DA', '\u00DB', '\u00DC', '\u00DD', '\u00DE', '\u00DF',
            '\u00E0', '\u00E1', '\u00E2', '\u00E3', '\u00E4', '\u00E5', '\u00E6', '\u00E7', '\u00E8', '\u00E9', '\u00EA', '\u00EB', '\u00EC', '\u00ED', '\u00EE', '\u00EF', '\u00F0', '\u00F1', '\u00F2', '\u00F3', '\u00F4', '\u00F5', '\u00F6', '\u00F7', '\u00F8', '\u00F9', '\u00FA', '\u00FB', '\u00FC', '\u00FD', '\u00FE', '\u00FF',
            '\u0100', '\u0101', '\u0102', '\u0103', '\u0104', '\u0105', '\u0106', '\u0107', '\u0108', '\u0109', '\u010A', '\u010B', '\u010C', '\u010D', '\u010E', '\u010F', '\u0110', '\u0111', '\u0112', '\u0113', '\u0114', '\u0115', '\u0116', '\u0117', '\u0118', '\u0119', '\u011A', '\u011B', '\u011C', '\u011D', '\u011E', '\u011F',
            '\u0120', '\u0121', '\u0122', '\u0123', '\u0124', '\u0125', '\u0126', '\u0127', '\u0128', '\u0129', '\u012A', '\u012B', '\u012C', '\u012D', '\u012E', '\u012F', '\u0130', '\u0131', '\u0132', '\u0133', '\u0134', '\u0135', '\u0136', '\u0137', '\u0138', '\u0139', '\u013A', '\u013B', '\u013C', '\u013D', '\u013E', '\u013F',
            '\u0140', '\u0141', '\u0142', '\u0143', '\u0144', '\u0145', '\u0146', '\u0147', '\u0148', '\u0149', '\u014A', '\u014B', '\u014C', '\u014D', '\u014E', '\u014F', '\u0150', '\u0151', '\u0152', '\u0153', '\u0154', '\u0155', '\u0156', '\u0157', '\u0158', '\u0159', '\u015A', '\u015B', '\u015C', '\u015D', '\u015E', '\u015F',
            '\u0160', '\u0161', '\u0162', '\u0163', '\u0164', '\u0165', '\u0166', '\u0167', '\u0168', '\u0169', '\u016A', '\u016B', '\u016C', '\u016D', '\u016E', '\u016F', '\u0170', '\u0171', '\u0172', '\u0173', '\u0174', '\u0175', '\u0176', '\u0177', '\u0178', '\u0179', '\u017A', '\u017B', '\u017C', '\u017D', '\u017E', '\u017F',
            '\u0192', '\u01C0', '\u01C5', '\u01C6', '\u01CE', '\u01D0', '\u01D2', '\u01D4', '\u01D6', '\u01D8', '\u01DA', '\u01DC', '\u01F2', '\u01F3', '\u01F9', '\u01FA', '\u01FB', '\u01FC', '\u01FD', '\u01FE', '\u01FF', '\u0218', '\u0219', '\u021A', '\u021B', '\u0251', '\u0261', '\u02BC', '\u02BD', '\u02C6', '\u02C7', '\u02C9',
            '\u02CA', '\u02CB', '\u02CD', '\u02D8', '\u02D9', '\u02DA', '\u02DB', '\u02DC', '\u02DD', '\u0300', '\u0301', '\u0302', '\u0303', '\u0304', '\u0305', '\u0306', '\u0307', '\u0308', '\u030A', '\u030B', '\u030C', '\u0326', '\u0327', '\u0328', '\u0332', '\u0335', '\u0336', '\u0337', '\u0361', '\u0363', '\u0364', '\u0366',
            '\u036C', '\u037A', '\u037E', '\u0384', '\u0385', '\u0386', '\u0387', '\u0388', '\u0389', '\u038A', '\u038C', '\u038E', '\u038F', '\u0390', '\u0391', '\u0392', '\u0393', '\u0394', '\u0395', '\u0396', '\u0397', '\u0398', '\u0399', '\u039A', '\u039B', '\u039C', '\u039D', '\u039E', '\u039F', '\u03A0', '\u03A1', '\u03A3',
            '\u03A4', '\u03A5', '\u03A6', '\u03A7', '\u03A8', '\u03A9', '\u03AA', '\u03AB', '\u03AC', '\u03AD', '\u03AE', '\u03AF', '\u03B0', '\u03B1', '\u03B2', '\u03B3', '\u03B4', '\u03B5', '\u03B6', '\u03B7', '\u03B8', '\u03B9', '\u03BA', '\u03BB', '\u03BC', '\u03BD', '\u03BE', '\u03BF', '\u03C0', '\u03C1', '\u03C2', '\u03C3',
            '\u03C4', '\u03C5', '\u03C6', '\u03C7', '\u03C8', '\u03C9', '\u03CA', '\u03CB', '\u03CC', '\u03CD', '\u03CE', '\u0400', '\u0401', '\u0402', '\u0403', '\u0404', '\u0405', '\u0406', '\u0407', '\u0408', '\u0409', '\u040A', '\u040B', '\u040C', '\u040D', '\u040E', '\u040F', '\u0410', '\u0411', '\u0412', '\u0413', '\u0414',
            '\u0415', '\u0416', '\u0417', '\u0418', '\u0419', '\u041A', '\u041B', '\u041C', '\u041D', '\u041E', '\u041F', '\u0420', '\u0421', '\u0422', '\u0423', '\u0424', '\u0425', '\u0426', '\u0427', '\u0428', '\u0429', '\u042A', '\u042B', '\u042C', '\u042D', '\u042E', '\u042F', '\u0430', '\u0431', '\u0432', '\u0433', '\u0434',
            '\u0435', '\u0436', '\u0437', '\u0438', '\u0439', '\u043A', '\u043B', '\u043C', '\u043D', '\u043E', '\u043F', '\u0440', '\u0441', '\u0442', '\u0443', '\u0444', '\u0445', '\u0446', '\u0447', '\u0448', '\u0449', '\u044A', '\u044B', '\u044C', '\u044D', '\u044E', '\u044F', '\u0450', '\u0451', '\u0452', '\u0453', '\u0454',
            '\u0455', '\u0456', '\u0457', '\u0458', '\u0459', '\u045A', '\u045B', '\u045C', '\u045D', '\u045E', '\u045F', '\u0490', '\u0491', '\u1E02', '\u1E03', '\u1E0A', '\u1E0B', '\u1E1E', '\u1E1F', '\u1E3F', '\u1E40', '\u1E41', '\u1E56', '\u1E57', '\u1E60', '\u1E61', '\u1E6A', '\u1E6B', '\u1E80', '\u1E81', '\u1E82', '\u1E83',
            '\u1E84', '\u1E85', '\u1EF2', '\u1EF3', '\u2002', '\u2003', '\u2010', '\u2012', '\u2013', '\u2014', '\u2015', '\u2016', '\u2017', '\u2018', '\u2019', '\u201A', '\u201B', '\u201C', '\u201D', '\u201E', '\u2020', '\u2021', '\u2022', '\u2024', '\u2025', '\u2026', '\u2027', '\u2030', '\u2032', '\u2033', '\u2039', '\u203A',
            '\u203B', '\u203C', '\u203E', '\u2044', '\u2074', '\u207F', '\u2081', '\u2082', '\u2083', '\u2084', '\u20A3', '\u20A4', '\u20A7', '\u20A9', '\u20AC', '\u20AF', '\u20BD', '\u20DD', '\u2103', '\u2105', '\u2109', '\u210A', '\u2113', '\u2116', '\u2121', '\u2122', '\u2126', '\u212B', '\u212E', '\u215B', '\u215C', '\u215D',
            '\u215E', '\u2160', '\u2161', '\u2162', '\u2163', '\u2164', '\u2165', '\u2166', '\u2167', '\u2168', '\u2169', '\u216A', '\u216B', '\u2170', '\u2171', '\u2172', '\u2173', '\u2174', '\u2175', '\u2176', '\u2177', '\u2178', '\u2179', '\u217A', '\u217B', '\u217F', '\u2190', '\u2191', '\u2192', '\u2193', '\u2194', '\u2195',
            '\u21A8', '\u21C4', '\u21C5', '\u21C6', '\u21D2', '\u21D4', '\u2200', '\u2202', '\u2203', '\u2206', '\u2207', '\u2208', '\u220B', '\u220F', '\u2211', '\u2212', '\u2215', '\u2219', '\u221A', '\u221D', '\u221E', '\u221F', '\u2220', '\u2225', '\u2227', '\u2228', '\u2229', '\u222A', '\u222B', '\u222C', '\u222E', '\u2234',
            '\u2235', '\u223D', '\u2248', '\u2252', '\u2260', '\u2261', '\u2264', '\u2265', '\u2266', '\u2267', '\u226A', '\u226B', '\u2282', '\u2283', '\u2286', '\u2287', '\u22A5', '\u22BF', '\u22EE', '\u22EF', '\u2302', '\u2310', '\u2312', '\u2320', '\u2321', '\u2460', '\u2461', '\u2462', '\u2463', '\u2464', '\u2465', '\u2466',
            '\u2467', '\u2468', '\u2469', '\u246A', '\u246B', '\u246C', '\u246D', '\u246E', '\u246F', '\u2470', '\u2471', '\u2472', '\u2473', '\u2474', '\u2475', '\u2476', '\u2477', '\u2478', '\u2479', '\u247A', '\u247B', '\u247C', '\u247D', '\u247E', '\u247F', '\u2480', '\u2481', '\u2482', '\u2483', '\u2484', '\u2485', '\u2486',
            '\u2487', '\u249C', '\u249D', '\u249E', '\u249F', '\u24A0', '\u24A1', '\u24A2', '\u24A3', '\u24A4', '\u24A5', '\u24A6', '\u24A7', '\u24A8', '\u24A9', '\u24AA', '\u24AB', '\u24AC', '\u24AD', '\u24AE', '\u24AF', '\u24B0', '\u24B1', '\u24B2', '\u24B3', '\u24B4', '\u24B5', '\u24EA', '\u24EB', '\u24EC', '\u24ED', '\u24EE',
            '\u24EF', '\u24F0', '\u24F1', '\u24F2', '\u24F3', '\u24F4', '\u2500', '\u2501', '\u2502', '\u2503', '\u250C', '\u250F', '\u2510', '\u2513', '\u2514', '\u2517', '\u2518', '\u251B', '\u251C', '\u251D', '\u2520', '\u2523', '\u2524', '\u2525', '\u2528', '\u252B', '\u252C', '\u252F', '\u2530', '\u2533', '\u2534', '\u2537',
            '\u2538', '\u253B', '\u253C', '\u253F', '\u2542', '\u254B', '\u2550', '\u2551', '\u2552', '\u2553', '\u2554', '\u2555', '\u2556', '\u2557', '\u2558', '\u2559', '\u255A', '\u255B', '\u255C', '\u255D', '\u255E', '\u255F', '\u2560', '\u2561', '\u2562', '\u2563', '\u2564', '\u2565', '\u2566', '\u2567', '\u2568', '\u2569',
            '\u256A', '\u256B', '\u256C', '\u2573', '\u2580', '\u2584', '\u2588', '\u258C', '\u2590', '\u2591', '\u2592', '\u2593', '\u25A0', '\u25A1', '\u25AA', '\u25AB', '\u25AC', '\u25B2', '\u25B3', '\u25B6', '\u25B7', '\u25BA', '\u25BC', '\u25BD', '\u25C0', '\u25C1', '\u25C4', '\u25C6', '\u25C7', '\u25CA', '\u25CB', '\u25CE',
            '\u25CF', '\u25D8', '\u25D9', '\u25E6', '\u25EF', '\u2600', '\u2601', '\u2602', '\u2603', '\u2605', '\u2606', '\u260E', '\u261C', '\u261D', '\u261E', '\u261F', '\u263A', '\u263B', '\u263C', '\u2640', '\u2642', '\u2660', '\u2661', '\u2662', '\u2663', '\u2664', '\u2665', '\u2666', '\u2667', '\u266A', '\u266B', '\u266D',
            '\u266F', '\u2776', '\u2777', '\u2778', '\u2779', '\u277A', '\u277B', '\u277C', '\u277D', '\u277E', '\u277F', '\u3000', '\u3001', '\u3002', '\u3003', '\u3004', '\u3005', '\u3006', '\u3007', '\u3008', '\u3009', '\u300A', '\u300B', '\u300C', '\u300D', '\u300E', '\u300F', '\u3010', '\u3011', '\u3012', '\u3013', '\u3014',
            '\u3015', '\u301C', '\u301D', '\u301F', '\u3041', '\u3042', '\u3043', '\u3044', '\u3045', '\u3046', '\u3047', '\u3048', '\u3049', '\u304A', '\u304B', '\u304C', '\u304D', '\u304E', '\u304F', '\u3050', '\u3051', '\u3052', '\u3053', '\u3054', '\u3055', '\u3056', '\u3057', '\u3058', '\u3059', '\u305A', '\u305B', '\u305C',
            '\u305D', '\u305E', '\u305F', '\u3060', '\u3061', '\u3062', '\u3063', '\u3064', '\u3065', '\u3066', '\u3067', '\u3068', '\u3069', '\u306A', '\u306B', '\u306C', '\u306D', '\u306E', '\u306F', '\u3070', '\u3071', '\u3072', '\u3073', '\u3074', '\u3075', '\u3076', '\u3077', '\u3078', '\u3079', '\u307A', '\u307B', '\u307C',
            '\u307D', '\u307E', '\u307F', '\u3080', '\u3081', '\u3082', '\u3083', '\u3084', '\u3085', '\u3086', '\u3087', '\u3088', '\u3089', '\u308A', '\u308B', '\u308C', '\u308D', '\u308E', '\u308F', '\u3090', '\u3091', '\u3092', '\u3093', '\u3094', '\u309B', '\u309C', '\u309D', '\u309E', '\u30A1', '\u30A2', '\u30A3', '\u30A4',
            '\u30A5', '\u30A6', '\u30A7', '\u30A8', '\u30A9', '\u30AA', '\u30AB', '\u30AC', '\u30AD', '\u30AE', '\u30AF', '\u30B0', '\u30B1', '\u30B2', '\u30B3', '\u30B4', '\u30B5', '\u30B6', '\u30B7', '\u30B8', '\u30B9', '\u30BA', '\u30BB', '\u30BC', '\u30BD', '\u30BE', '\u30BF', '\u30C0', '\u30C1', '\u30C2', '\u30C3', '\u30C4',
            '\u30C5', '\u30C6', '\u30C7', '\u30C8', '\u30C9', '\u30CA', '\u30CB', '\u30CC', '\u30CD', '\u30CE', '\u30CF', '\u30D0', '\u30D1', '\u30D2', '\u30D3', '\u30D4', '\u30D5', '\u30D6', '\u30D7', '\u30D8', '\u30D9', '\u30DA', '\u30DB', '\u30DC', '\u30DD', '\u30DE', '\u30DF', '\u30E0', '\u30E1', '\u30E2', '\u30E3', '\u30E4',
            '\u30E5', '\u30E6', '\u30E7', '\u30E8', '\u30E9', '\u30EA', '\u30EB', '\u30EC', '\u30ED', '\u30EE', '\u30EF', '\u30F0', '\u30F1', '\u30F2', '\u30F3', '\u30F4', '\u30F5', '\u30F6', '\u30FB', '\u30FC', '\u30FD', '\u30FE', '\u322A', '\u322B', '\u322C', '\u322D', '\u322E', '\u322F', '\u3230', '\u3231', '\u3232', '\u3233',
            '\u3234', '\u3235', '\u3236', '\u3237', '\u3238', '\u3239', '\u323A', '\u323B', '\u323C', '\u323D', '\u323E', '\u323F', '\u3240', '\u3241', '\u3242', '\u3243', '\u32A4', '\u32A5', '\u32A6', '\u32A7', '\u32A8', '\u3303', '\u330D', '\u3314', '\u3318', '\u3322', '\u3323', '\u3326', '\u3327', '\u332B', '\u3336', '\u333B',
            '\u3349', '\u334A', '\u334D', '\u3351', '\u3357', '\u337B', '\u337C', '\u337D', '\u337E', '\u337F', '\u3385', '\u3386', '\u3387', '\u3388', '\u3389', '\u338E', '\u338F', '\u3390', '\u3396', '\u3397', '\u3398', '\u339C', '\u339D', '\u339E', '\u339F', '\u33A0', '\u33A1', '\u33A2', '\u33A3', '\u33A4', '\u33A5', '\u33A6',
            '\u33B0', '\u33B1', '\u33B2', '\u33B3', '\u33C4', '\u33C8', '\u33CB', '\u33CC', '\u33CD', '\u33D4', '\u4E00', '\u4E01', '\u4E03', '\u4E07', '\u4E08', '\u4E09', '\u4E0A', '\u4E0B', '\u4E0D', '\u4E0E', '\u4E10', '\u4E11', '\u4E14', '\u4E15', '\u4E16', '\u4E17', '\u4E18', '\u4E19', '\u4E1E', '\u4E21', '\u4E26', '\u4E2A',
            '\u4E2D', '\u4E31', '\u4E32', '\u4E36', '\u4E38', '\u4E39', '\u4E3B', '\u4E3C', '\u4E3F', '\u4E42', '\u4E43', '\u4E45', '\u4E4B', '\u4E4D', '\u4E4E', '\u4E4F', '\u4E55', '\u4E56', '\u4E57', '\u4E58', '\u4E59', '\u4E5D', '\u4E5E', '\u4E5F', '\u4E62', '\u4E71', '\u4E73', '\u4E7E', '\u4E80', '\u4E82', '\u4E85', '\u4E86',
            '\u4E88', '\u4E89', '\u4E8A', '\u4E8B', '\u4E8C', '\u4E8E', '\u4E91', '\u4E92', '\u4E94', '\u4E95', '\u4E98', '\u4E99', '\u4E9B', '\u4E9C', '\u4E9E', '\u4E9F', '\u4EA0', '\u4EA1', '\u4EA2', '\u4EA4', '\u4EA5', '\u4EA6', '\u4EA8', '\u4EAB', '\u4EAC', '\u4EAD', '\u4EAE', '\u4EB0', '\u4EB3', '\u4EB6', '\u4EBA', '\u4EC0',
            '\u4EC1', '\u4EC2', '\u4EC4', '\u4EC6', '\u4EC7', '\u4ECA', '\u4ECB', '\u4ECD', '\u4ECE', '\u4ECF', '\u4ED4', '\u4ED5', '\u4ED6', '\u4ED7', '\u4ED8', '\u4ED9', '\u4EDD', '\u4EDE', '\u4EDF', '\u4EE3', '\u4EE4', '\u4EE5', '\u4EED', '\u4EEE', '\u4EF0', '\u4EF2', '\u4EF6', '\u4EF7', '\u4EFB', '\u4F01', '\u4F09', '\u4F0A',
            '\u4F0D', '\u4F0E', '\u4F0F', '\u4F10', '\u4F11', '\u4F1A', '\u4F1C', '\u4F1D', '\u4F2F', '\u4F30', '\u4F34', '\u4F36', '\u4F38', '\u4F3A', '\u4F3C', '\u4F3D', '\u4F43', '\u4F46', '\u4F47', '\u4F4D', '\u4F4E', '\u4F4F', '\u4F50', '\u4F51', '\u4F53', '\u4F55', '\u4F57', '\u4F59', '\u4F5A', '\u4F5B', '\u4F5C', '\u4F5D',
            '\u4F5E', '\u4F69', '\u4F6F', '\u4F70', '\u4F73', '\u4F75', '\u4F76', '\u4F7B', '\u4F7C', '\u4F7F', '\u4F83', '\u4F86', '\u4F88', '\u4F8B', '\u4F8D', '\u4F8F', '\u4F91', '\u4F96', '\u4F98', '\u4F9B', '\u4F9D', '\u4FA0', '\u4FA1', '\u4FAB', '\u4FAD', '\u4FAE', '\u4FAF', '\u4FB5', '\u4FB6', '\u4FBF', '\u4FC2', '\u4FC3',
            '\u4FC4', '\u4FCA', '\u4FCE', '\u4FD0', '\u4FD1', '\u4FD4', '\u4FD7', '\u4FD8', '\u4FDA', '\u4FDB', '\u4FDD', '\u4FDF', '\u4FE1', '\u4FE3', '\u4FE4', '\u4FE5', '\u4FEE', '\u4FEF', '\u4FF3', '\u4FF5', '\u4FF6', '\u4FF8', '\u4FFA', '\u4FFE', '\u5005', '\u5006', '\u5009', '\u500B', '\u500D', '\u500F', '\u5011', '\u5012',
            '\u5014', '\u5016', '\u5019', '\u501A', '\u501F', '\u5021', '\u5023', '\u5024', '\u5025', '\u5026', '\u5028', '\u5029', '\u502A', '\u502B', '\u502C', '\u502D', '\u5036', '\u5039', '\u5043', '\u5047', '\u5048', '\u5049', '\u504F', '\u5050', '\u5055', '\u5056', '\u505A', '\u505C', '\u5065', '\u506C', '\u5072', '\u5074',
            '\u5075', '\u5076', '\u5078', '\u507D', '\u5080', '\u5085', '\u508D', '\u5091', '\u5098', '\u5099', '\u509A', '\u50AC', '\u50AD', '\u50B2', '\u50B3', '\u50B4', '\u50B5', '\u50B7', '\u50BE', '\u50C2', '\u50C5', '\u50C9', '\u50CA', '\u50CD', '\u50CF', '\u50D1', '\u50D5', '\u50D6', '\u50DA', '\u50DE', '\u50E3', '\u50E5',
            '\u50E7', '\u50ED', '\u50EE', '\u50F5', '\u50F9', '\u50FB', '\u5100', '\u5101', '\u5102', '\u5104', '\u5109', '\u5112', '\u5114', '\u5115', '\u5116', '\u5118', '\u511A', '\u511F', '\u5121', '\u512A', '\u5132', '\u5137', '\u513A', '\u513B', '\u513C', '\u513F', '\u5140', '\u5141', '\u5143', '\u5144', '\u5145', '\u5146',
            '\u5147', '\u5148', '\u5149', '\u514B', '\u514C', '\u514D', '\u514E', '\u5150', '\u5152', '\u5154', '\u515A', '\u515C', '\u5162', '\u5165', '\u5168', '\u5169', '\u516A', '\u516B', '\u516C', '\u516D', '\u516E', '\u5171', '\u5175', '\u5176', '\u5177', '\u5178', '\u517C', '\u5180', '\u5182', '\u5185', '\u5186', '\u5189',
            '\u518A', '\u518C', '\u518D', '\u518F', '\u5190', '\u5191', '\u5192', '\u5193', '\u5195', '\u5196', '\u5197', '\u5199', '\u51A0', '\u51A2', '\u51A4', '\u51A5', '\u51A6', '\u51A8', '\u51A9', '\u51AA', '\u51AB', '\u51AC', '\u51B0', '\u51B1', '\u51B2', '\u51B3', '\u51B4', '\u51B5', '\u51B6', '\u51B7', '\u51BD', '\u51C4',
            '\u51C5', '\u51C6', '\u51C9', '\u51CB', '\u51CC', '\u51CD', '\u51D6', '\u51DB', '\u51DC', '\u51DD', '\u51E0', '\u51E1', '\u51E6', '\u51E7', '\u51E9', '\u51EA', '\u51ED', '\u51F0', '\u51F1', '\u51F5', '\u51F6', '\u51F8', '\u51F9', '\u51FA', '\u51FD', '\u51FE', '\u5200', '\u5203', '\u5204', '\u5206', '\u5207', '\u5208',
            '\u520A', '\u520B', '\u520E', '\u5211', '\u5214', '\u5217', '\u521D', '\u5224', '\u5225', '\u5227', '\u5229', '\u522A', '\u522E', '\u5230', '\u5233', '\u5236', '\u5237', '\u5238', '\u5239', '\u523A', '\u523B', '\u5243', '\u5244', '\u5247', '\u524A', '\u524B', '\u524C', '\u524D', '\u524F', '\u5254', '\u5256', '\u525B',
            '\u525E', '\u5263', '\u5264', '\u5265', '\u5269', '\u526A', '\u526F', '\u5270', '\u5271', '\u5272', '\u5273', '\u5274', '\u5275', '\u527D', '\u527F', '\u5283', '\u5287', '\u5288', '\u5289', '\u528D', '\u5291', '\u5292', '\u5294', '\u529B', '\u529F', '\u52A0', '\u52A3', '\u52A9', '\u52AA', '\u52AB', '\u52AC', '\u52AD',
            '\u52B1', '\u52B4', '\u52B5', '\u52B9', '\u52BC', '\u52BE', '\u52C1', '\u52C3', '\u52C5', '\u52C7', '\u52C9', '\u52CD', '\u52D2', '\u52D5', '\u52D7', '\u52D8', '\u52D9', '\u52DD', '\u52DE', '\u52DF', '\u52E0', '\u52E2', '\u52E3', '\u52E4', '\u52E6', '\u52E7', '\u52F2', '\u52F3', '\u52F5', '\u52F8', '\u52F9', '\u52FA',
            '\u52FE', '\u52FF', '\u5301', '\u5302', '\u5305', '\u5306', '\u5308', '\u530D', '\u530F', '\u5310', '\u5315', '\u5316', '\u5317', '\u5319', '\u531A', '\u531D', '\u5320', '\u5321', '\u5323', '\u532A', '\u532F', '\u5331', '\u5333', '\u5338', '\u5339', '\u533A', '\u533B', '\u533F', '\u5340', '\u5341', '\u5343', '\u5345',
            '\u5346', '\u5347', '\u5348', '\u5349', '\u534A', '\u534D', '\u5351', '\u5352', '\u5353', '\u5354', '\u5357', '\u5358', '\u535A', '\u535C', '\u535E', '\u5360', '\u5366', '\u5369', '\u536E', '\u536F', '\u5370', '\u5371', '\u5373', '\u5374', '\u5375', '\u5377', '\u5378', '\u537B', '\u537F', '\u5382', '\u5384', '\u5396',
            '\u5398', '\u539A', '\u539F', '\u53A0', '\u53A5', '\u53A6', '\u53A8', '\u53A9', '\u53AD', '\u53AE', '\u53B0', '\u53B3', '\u53B6', '\u53BB', '\u53C2', '\u53C3', '\u53C8', '\u53C9', '\u53CA', '\u53CB', '\u53CC', '\u53CD', '\u53CE', '\u53D4', '\u53D6', '\u53D7', '\u53D9', '\u53DB', '\u53DF', '\u53E1', '\u53E2', '\u53E3',
            '\u53E4', '\u53E5', '\u53E8', '\u53E9', '\u53EA', '\u53EB', '\u53EC', '\u53ED', '\u53EE', '\u53EF', '\u53F0', '\u53F1', '\u53F2', '\u53F3', '\u53F6', '\u53F7', '\u53F8', '\u53FA', '\u5401', '\u5403', '\u5404', '\u5408', '\u5409', '\u540A', '\u540B', '\u540C', '\u540D', '\u540E', '\u540F', '\u5410', '\u5411', '\u541B',
            '\u541D', '\u541F', '\u5420', '\u5426', '\u5429', '\u542B', '\u542C', '\u542D', '\u542E', '\u5436', '\u5438', '\u5439', '\u543B', '\u543C', '\u543D', '\u543E', '\u5440', '\u5442', '\u5446', '\u5448', '\u5449', '\u544A', '\u544E', '\u5451', '\u545F', '\u5468', '\u546A', '\u5470', '\u5471', '\u5473', '\u5475', '\u5476',
            '\u5477', '\u547B', '\u547C', '\u547D', '\u5480', '\u5484', '\u5486', '\u548B', '\u548C', '\u548E', '\u548F', '\u5490', '\u5492', '\u54A2', '\u54A4', '\u54A5', '\u54A8', '\u54AB', '\u54AC', '\u54AF', '\u54B2', '\u54B3', '\u54B8', '\u54BC', '\u54BD', '\u54BE', '\u54C0', '\u54C1', '\u54C2', '\u54C4', '\u54C7', '\u54C8',
            '\u54C9', '\u54D8', '\u54E1', '\u54E2', '\u54E5', '\u54E6', '\u54E8', '\u54E9', '\u54ED', '\u54EE', '\u54F2', '\u54FA', '\u54FD', '\u5504', '\u5506', '\u5507', '\u550F', '\u5510', '\u5514', '\u5516', '\u552E', '\u552F', '\u5531', '\u5533', '\u5538', '\u5539', '\u553E', '\u5540', '\u5544', '\u5545', '\u5546', '\u554C',
            '\u554F', '\u5553', '\u5556', '\u5557', '\u555C', '\u555D', '\u5563', '\u557B', '\u557C', '\u557E', '\u5580', '\u5583', '\u5584', '\u5587', '\u5589', '\u558A', '\u558B', '\u5598', '\u5599', '\u559A', '\u559C', '\u559D', '\u559E', '\u559F', '\u55A7', '\u55A8', '\u55A9', '\u55AA', '\u55AB', '\u55AC', '\u55AE', '\u55B0',
            '\u55B6', '\u55C4', '\u55C5', '\u55C7', '\u55D4', '\u55DA', '\u55DC', '\u55DF', '\u55E3', '\u55E4', '\u55F7', '\u55F9', '\u55FD', '\u55FE', '\u5606', '\u5609', '\u5614', '\u5616', '\u5617', '\u5618', '\u561B', '\u5629', '\u562F', '\u5631', '\u5632', '\u5634', '\u5636', '\u5638', '\u5642', '\u564C', '\u564E', '\u5650',
            '\u565B', '\u5664', '\u5668', '\u566A', '\u566B', '\u566C', '\u5674', '\u5678', '\u567A', '\u5680', '\u5686', '\u5687', '\u568A', '\u568F', '\u5694', '\u56A0', '\u56A2', '\u56A5', '\u56AE', '\u56B4', '\u56B6', '\u56BC', '\u56C0', '\u56C1', '\u56C2', '\u56C3', '\u56C8', '\u56CE', '\u56D1', '\u56D3', '\u56D7', '\u56D8',
            '\u56DA', '\u56DB', '\u56DE', '\u56E0', '\u56E3', '\u56EE', '\u56F0', '\u56F2', '\u56F3', '\u56F9', '\u56FA', '\u56FD', '\u56FF', '\u5700', '\u5703', '\u5704', '\u5708', '\u5709', '\u570B', '\u570D', '\u570F', '\u5712', '\u5713', '\u5716', '\u5718', '\u571C', '\u571F', '\u5726', '\u5727', '\u5728', '\u572D', '\u5730',
            '\u5737', '\u5738', '\u573B', '\u5740', '\u5742', '\u5747', '\u574A', '\u574E', '\u574F', '\u5750', '\u5751', '\u5761', '\u5764', '\u5766', '\u5769', '\u576A', '\u577F', '\u5782', '\u5788', '\u5789', '\u578B', '\u5793', '\u57A0', '\u57A2', '\u57A3', '\u57A4', '\u57AA', '\u57B0', '\u57B3', '\u57C0', '\u57C3', '\u57C6',
            '\u57CB', '\u57CE', '\u57D2', '\u57D3', '\u57D4', '\u57D6', '\u57DC', '\u57DF', '\u57E0', '\u57E3', '\u57F4', '\u57F7', '\u57F9', '\u57FA', '\u57FC', '\u5800', '\u5802', '\u5805', '\u5806', '\u580A', '\u580B', '\u5815', '\u5819', '\u581D', '\u5821', '\u5824', '\u582A', '\u582F', '\u5830', '\u5831', '\u5834', '\u5835',
            '\u583A', '\u583D', '\u5840', '\u5841', '\u584A', '\u584B', '\u5851', '\u5852', '\u5854', '\u5857', '\u5858', '\u5859', '\u585A', '\u585E', '\u5862', '\u5869', '\u586B', '\u5870', '\u5872', '\u5875', '\u5879', '\u587E', '\u5883', '\u5885', '\u5893', '\u5897', '\u589C', '\u589F', '\u58A8', '\u58AB', '\u58AE', '\u58B3',
            '\u58B8', '\u58B9', '\u58BA', '\u58BB', '\u58BE', '\u58C1', '\u58C5', '\u58C7', '\u58CA', '\u58CC', '\u58D1', '\u58D3', '\u58D5', '\u58D7', '\u58D8', '\u58D9', '\u58DC', '\u58DE', '\u58DF', '\u58E4', '\u58E5', '\u58EB', '\u58EC', '\u58EE', '\u58EF', '\u58F0', '\u58F1', '\u58F2', '\u58F7', '\u58F9', '\u58FA', '\u58FB',
            '\u58FC', '\u58FD', '\u5902', '\u5909', '\u590A', '\u590F', '\u5910', '\u5915', '\u5916', '\u5918', '\u5919', '\u591A', '\u591B', '\u591C', '\u5922', '\u5925', '\u5927', '\u5929', '\u592A', '\u592B', '\u592C', '\u592D', '\u592E', '\u5931', '\u5932', '\u5937', '\u5938', '\u593E', '\u5944', '\u5947', '\u5948', '\u5949',
            '\u594E', '\u594F', '\u5950', '\u5951', '\u5954', '\u5955', '\u5957', '\u5958', '\u595A', '\u5960', '\u5962', '\u5965', '\u5967', '\u5968', '\u5969', '\u596A', '\u596C', '\u596E', '\u5973', '\u5974', '\u5978', '\u597D', '\u5981', '\u5982', '\u5983', '\u5984', '\u598A', '\u598D', '\u5993', '\u5996', '\u5999', '\u599B',
            '\u599D', '\u59A3', '\u59A5', '\u59A8', '\u59AC', '\u59B2', '\u59B9', '\u59BB', '\u59BE', '\u59C6', '\u59C9', '\u59CB', '\u59D0', '\u59D1', '\u59D3', '\u59D4', '\u59D9', '\u59DA', '\u59DC', '\u59E5', '\u59E6', '\u59E8', '\u59EA', '\u59EB', '\u59F6', '\u59FB', '\u59FF', '\u5A01', '\u5A03', '\u5A09', '\u5A11', '\u5A18',
            '\u5A1A', '\u5A1C', '\u5A1F', '\u5A20', '\u5A25', '\u5A29', '\u5A2F', '\u5A35', '\u5A36', '\u5A3C', '\u5A40', '\u5A41', '\u5A46', '\u5A49', '\u5A5A', '\u5A62', '\u5A66', '\u5A6A', '\u5A6C', '\u5A7F', '\u5A92', '\u5A9A', '\u5A9B', '\u5ABC', '\u5ABD', '\u5ABE', '\u5AC1', '\u5AC2', '\u5AC9', '\u5ACB', '\u5ACC', '\u5AD0',
            '\u5AD6', '\u5AD7', '\u5AE1', '\u5AE3', '\u5AE6', '\u5AE9', '\u5AFA', '\u5AFB', '\u5B09', '\u5B0B', '\u5B0C', '\u5B16', '\u5B22', '\u5B2A', '\u5B2C', '\u5B30', '\u5B32', '\u5B36', '\u5B3E', '\u5B40', '\u5B43', '\u5B45', '\u5B50', '\u5B51', '\u5B54', '\u5B55', '\u5B57', '\u5B58', '\u5B5A', '\u5B5B', '\u5B5C', '\u5B5D',
            '\u5B5F', '\u5B63', '\u5B64', '\u5B65', '\u5B66', '\u5B69', '\u5B6B', '\u5B70', '\u5B71', '\u5B73', '\u5B75', '\u5B78', '\u5B7A', '\u5B80', '\u5B83', '\u5B85', '\u5B87', '\u5B88', '\u5B89', '\u5B8B', '\u5B8C', '\u5B8D', '\u5B8F', '\u5B95', '\u5B97', '\u5B98', '\u5B99', '\u5B9A', '\u5B9B', '\u5B9C', '\u5B9D', '\u5B9F',
            '\u5BA2', '\u5BA3', '\u5BA4', '\u5BA5', '\u5BA6', '\u5BAE', '\u5BB0', '\u5BB3', '\u5BB4', '\u5BB5', '\u5BB6', '\u5BB8', '\u5BB9', '\u5BBF', '\u5BC2', '\u5BC3', '\u5BC4', '\u5BC5', '\u5BC6', '\u5BC7', '\u5BC9', '\u5BCC', '\u5BD0', '\u5BD2', '\u5BD3', '\u5BD4', '\u5BDB', '\u5BDD', '\u5BDE', '\u5BDF', '\u5BE1', '\u5BE2',
            '\u5BE4', '\u5BE5', '\u5BE6', '\u5BE7', '\u5BE8', '\u5BE9', '\u5BEB', '\u5BEE', '\u5BF0', '\u5BF3', '\u5BF5', '\u5BF6', '\u5BF8', '\u5BFA', '\u5BFE', '\u5BFF', '\u5C01', '\u5C02', '\u5C04', '\u5C05', '\u5C06', '\u5C07', '\u5C08', '\u5C09', '\u5C0A', '\u5C0B', '\u5C0D', '\u5C0E', '\u5C0F', '\u5C11', '\u5C13', '\u5C16',
            '\u5C1A', '\u5C20', '\u5C22', '\u5C24', '\u5C28', '\u5C2D', '\u5C31', '\u5C38', '\u5C39', '\u5C3A', '\u5C3B', '\u5C3C', '\u5C3D', '\u5C3E', '\u5C3F', '\u5C40', '\u5C41', '\u5C45', '\u5C46', '\u5C48', '\u5C4A', '\u5C4B', '\u5C4D', '\u5C4E', '\u5C4F', '\u5C50', '\u5C51', '\u5C53', '\u5C55', '\u5C5E', '\u5C60', '\u5C61',
            '\u5C64', '\u5C65', '\u5C6C', '\u5C6E', '\u5C6F', '\u5C71', '\u5C76', '\u5C79', '\u5C8C', '\u5C90', '\u5C91', '\u5C94', '\u5CA1', '\u5CA8', '\u5CA9', '\u5CAB', '\u5CAC', '\u5CB1', '\u5CB3', '\u5CB6', '\u5CB7', '\u5CB8', '\u5CBB', '\u5CBC', '\u5CBE', '\u5CC5', '\u5CC7', '\u5CD9', '\u5CE0', '\u5CE1', '\u5CE8', '\u5CE9',
            '\u5CEA', '\u5CED', '\u5CEF', '\u5CF0', '\u5CF6', '\u5CFA', '\u5CFB', '\u5CFD', '\u5D07', '\u5D0B', '\u5D0E', '\u5D11', '\u5D14', '\u5D15', '\u5D16', '\u5D17', '\u5D18', '\u5D19', '\u5D1A', '\u5D1B', '\u5D1F', '\u5D22', '\u5D29', '\u5D4B', '\u5D4C', '\u5D4E', '\u5D50', '\u5D52', '\u5D5C', '\u5D69', '\u5D6C', '\u5D6F',
            '\u5D73', '\u5D76', '\u5D82', '\u5D84', '\u5D87', '\u5D8B', '\u5D8C', '\u5D90', '\u5D9D', '\u5DA2', '\u5DAC', '\u5DAE', '\u5DB7', '\u5DBA', '\u5DBC', '\u5DBD', '\u5DC9', '\u5DCC', '\u5DCD', '\u5DD2', '\u5DD3', '\u5DD6', '\u5DDB', '\u5DDD', '\u5DDE', '\u5DE1', '\u5DE3', '\u5DE5', '\u5DE6', '\u5DE7', '\u5DE8', '\u5DEB',
            '\u5DEE', '\u5DF1', '\u5DF2', '\u5DF3', '\u5DF4', '\u5DF5', '\u5DF7', '\u5DFB', '\u5DFD', '\u5DFE', '\u5E02', '\u5E03', '\u5E06', '\u5E0B', '\u5E0C', '\u5E11', '\u5E16', '\u5E19', '\u5E1A', '\u5E1B', '\u5E1D', '\u5E25', '\u5E2B', '\u5E2D', '\u5E2F', '\u5E30', '\u5E33', '\u5E36', '\u5E37', '\u5E38', '\u5E3D', '\u5E40',
            '\u5E43', '\u5E44', '\u5E45', '\u5E47', '\u5E4C', '\u5E4E', '\u5E54', '\u5E55', '\u5E57', '\u5E5F', '\u5E61', '\u5E62', '\u5E63', '\u5E64', '\u5E72', '\u5E73', '\u5E74', '\u5E75', '\u5E76', '\u5E78', '\u5E79', '\u5E7A', '\u5E7B', '\u5E7C', '\u5E7D', '\u5E7E', '\u5E7F', '\u5E81', '\u5E83', '\u5E84', '\u5E87', '\u5E8A',
            '\u5E8F', '\u5E95', '\u5E96', '\u5E97', '\u5E9A', '\u5E9C', '\u5EA0', '\u5EA6', '\u5EA7', '\u5EAB', '\u5EAD', '\u5EB5', '\u5EB6', '\u5EB7', '\u5EB8', '\u5EC1', '\u5EC2', '\u5EC3', '\u5EC8', '\u5EC9', '\u5ECA', '\u5ECF', '\u5ED0', '\u5ED3', '\u5ED6', '\u5EDA', '\u5EDB', '\u5EDD', '\u5EDF', '\u5EE0', '\u5EE1', '\u5EE2',
            '\u5EE3', '\u5EE8', '\u5EE9', '\u5EEC', '\u5EF0', '\u5EF1', '\u5EF3', '\u5EF4', '\u5EF6', '\u5EF7', '\u5EF8', '\u5EFA', '\u5EFB', '\u5EFC', '\u5EFE', '\u5EFF', '\u5F01', '\u5F03', '\u5F04', '\u5F09', '\u5F0A', '\u5F0B', '\u5F0C', '\u5F0D', '\u5F0F', '\u5F10', '\u5F11', '\u5F13', '\u5F14', '\u5F15', '\u5F16', '\u5F17',
            '\u5F18', '\u5F1B', '\u5F1F', '\u5F25', '\u5F26', '\u5F27', '\u5F29', '\u5F2D', '\u5F2F', '\u5F31', '\u5F35', '\u5F37', '\u5F38', '\u5F3C', '\u5F3E', '\u5F41', '\u5F48', '\u5F4A', '\u5F4C', '\u5F4E', '\u5F51', '\u5F53', '\u5F56', '\u5F57', '\u5F59', '\u5F5C', '\u5F5D', '\u5F61', '\u5F62', '\u5F66', '\u5F69', '\u5F6A',
            '\u5F6B', '\u5F6C', '\u5F6D', '\u5F70', '\u5F71', '\u5F73', '\u5F77', '\u5F79', '\u5F7C', '\u5F7F', '\u5F80', '\u5F81', '\u5F82', '\u5F83', '\u5F84', '\u5F85', '\u5F87', '\u5F88', '\u5F8A', '\u5F8B', '\u5F8C', '\u5F90', '\u5F91', '\u5F92', '\u5F93', '\u5F97', '\u5F98', '\u5F99', '\u5F9E', '\u5FA0', '\u5FA1', '\u5FA8',
            '\u5FA9', '\u5FAA', '\u5FAD', '\u5FAE', '\u5FB3', '\u5FB4', '\u5FB9', '\u5FBC', '\u5FBD', '\u5FC3', '\u5FC5', '\u5FCC', '\u5FCD', '\u5FD6', '\u5FD7', '\u5FD8', '\u5FD9', '\u5FDC', '\u5FDD', '\u5FE0', '\u5FE4', '\u5FEB', '\u5FF0', '\u5FF1', '\u5FF5', '\u5FF8', '\u5FFB', '\u5FFD', '\u5FFF', '\u600E', '\u600F', '\u6010',
            '\u6012', '\u6015', '\u6016', '\u6019', '\u601B', '\u601C', '\u601D', '\u6020', '\u6021', '\u6025', '\u6026', '\u6027', '\u6028', '\u6029', '\u602A', '\u602B', '\u602F', '\u6031', '\u603A', '\u6041', '\u6042', '\u6043', '\u6046', '\u604A', '\u604B', '\u604D', '\u6050', '\u6052', '\u6055', '\u6059', '\u605A', '\u605F',
            '\u6060', '\u6062', '\u6063', '\u6064', '\u6065', '\u6068', '\u6069', '\u606A', '\u606B', '\u606C', '\u606D', '\u606F', '\u6070', '\u6075', '\u6077', '\u6081', '\u6083', '\u6084', '\u6089', '\u608B', '\u608C', '\u608D', '\u6092', '\u6094', '\u6096', '\u6097', '\u609A', '\u609B', '\u609F', '\u60A0', '\u60A3', '\u60A6',
            '\u60A7', '\u60A9', '\u60AA', '\u60B2', '\u60B3', '\u60B4', '\u60B5', '\u60B6', '\u60B8', '\u60BC', '\u60BD', '\u60C5', '\u60C6', '\u60C7', '\u60D1', '\u60D3', '\u60D8', '\u60DA', '\u60DC', '\u60DF', '\u60E0', '\u60E1', '\u60E3', '\u60E7', '\u60E8', '\u60F0', '\u60F1', '\u60F3', '\u60F4', '\u60F6', '\u60F7', '\u60F9',
            '\u60FA', '\u60FB', '\u6100', '\u6101', '\u6103', '\u6106', '\u6108', '\u6109', '\u610D', '\u610E', '\u610F', '\u6115', '\u611A', '\u611B', '\u611F', '\u6121', '\u6127', '\u6128', '\u612C', '\u6134', '\u613C', '\u613D', '\u613E', '\u613F', '\u6142', '\u6144', '\u6147', '\u6148', '\u614A', '\u614B', '\u614C', '\u614D',
            '\u614E', '\u6153', '\u6155', '\u6158', '\u6159', '\u615A', '\u615D', '\u615F', '\u6162', '\u6163', '\u6165', '\u6167', '\u6168', '\u616B', '\u616E', '\u616F', '\u6170', '\u6171', '\u6173', '\u6174', '\u6175', '\u6176', '\u6177', '\u617E', '\u6182', '\u6187', '\u618A', '\u618E', '\u6190', '\u6191', '\u6194', '\u6196',
            '\u6199', '\u619A', '\u61A4', '\u61A7', '\u61A9', '\u61AB', '\u61AC', '\u61AE', '\u61B2', '\u61B6', '\u61BA', '\u61BE', '\u61C3', '\u61C6', '\u61C7', '\u61C8', '\u61C9', '\u61CA', '\u61CB', '\u61CC', '\u61CD', '\u61D0', '\u61E3', '\u61E6', '\u61F2', '\u61F4', '\u61F6', '\u61F7', '\u61F8', '\u61FA', '\u61FC', '\u61FD',
            '\u61FE', '\u61FF', '\u6200', '\u6208', '\u6209', '\u620A', '\u620C', '\u620D', '\u620E', '\u6210', '\u6211', '\u6212', '\u6214', '\u6216', '\u621A', '\u621B', '\u621D', '\u621E', '\u621F', '\u6221', '\u6226', '\u622A', '\u622E', '\u622F', '\u6230', '\u6232', '\u6233', '\u6234', '\u6238', '\u623B', '\u623F', '\u6240',
            '\u6241', '\u6247', '\u6248', '\u6249', '\u624B', '\u624D', '\u624E', '\u6253', '\u6255', '\u6258', '\u625B', '\u625E', '\u6260', '\u6263', '\u6268', '\u626E', '\u6271', '\u6276', '\u6279', '\u627C', '\u627E', '\u627F', '\u6280', '\u6282', '\u6283', '\u6284', '\u6289', '\u628A', '\u6291', '\u6292', '\u6293', '\u6294',
            '\u6295', '\u6296', '\u6297', '\u6298', '\u629B', '\u629C', '\u629E', '\u62AB', '\u62AC', '\u62B1', '\u62B5', '\u62B9', '\u62BB', '\u62BC', '\u62BD', '\u62C2', '\u62C5', '\u62C6', '\u62C7', '\u62C8', '\u62C9', '\u62CA', '\u62CC', '\u62CD', '\u62CF', '\u62D0', '\u62D1', '\u62D2', '\u62D3', '\u62D4', '\u62D7', '\u62D8',
            '\u62D9', '\u62DB', '\u62DC', '\u62DD', '\u62E0', '\u62E1', '\u62EC', '\u62ED', '\u62EE', '\u62EF', '\u62F1', '\u62F3', '\u62F5', '\u62F6', '\u62F7', '\u62FE', '\u62FF', '\u6301', '\u6302', '\u6307', '\u6308', '\u6309', '\u630C', '\u6311', '\u6319', '\u631F', '\u6327', '\u6328', '\u632B', '\u632F', '\u633A', '\u633D',
            '\u633E', '\u633F', '\u6349', '\u634C', '\u634D', '\u634F', '\u6350', '\u6355', '\u6357', '\u635C', '\u6367', '\u6368', '\u6369', '\u636B', '\u636E', '\u6372', '\u6376', '\u6377', '\u637A', '\u637B', '\u6380', '\u6383', '\u6388', '\u6389', '\u638C', '\u638E', '\u638F', '\u6392', '\u6396', '\u6398', '\u639B', '\u639F',
            '\u63A0', '\u63A1', '\u63A2', '\u63A3', '\u63A5', '\u63A7', '\u63A8', '\u63A9', '\u63AA', '\u63AB', '\u63AC', '\u63B2', '\u63B4', '\u63B5', '\u63BB', '\u63BE', '\u63C0', '\u63C3', '\u63C4', '\u63C6', '\u63C9', '\u63CF', '\u63D0', '\u63D2', '\u63D6', '\u63DA', '\u63DB', '\u63E1', '\u63E3', '\u63E9', '\u63EE', '\u63F4',
            '\u63F6', '\u63FA', '\u6406', '\u640D', '\u640F', '\u6413', '\u6416', '\u6417', '\u641C', '\u6426', '\u6428', '\u642C', '\u642D', '\u6434', '\u6436', '\u643A', '\u643E', '\u6442', '\u644E', '\u6458', '\u6467', '\u6469', '\u646F', '\u6476', '\u6478', '\u647A', '\u6483', '\u6488', '\u6492', '\u6493', '\u6495', '\u649A',
            '\u649E', '\u64A4', '\u64A5', '\u64A9', '\u64AB', '\u64AD', '\u64AE', '\u64B0', '\u64B2', '\u64B9', '\u64BB', '\u64BC', '\u64C1', '\u64C2', '\u64C5', '\u64C7', '\u64CD', '\u64D2', '\u64D4', '\u64D8', '\u64DA', '\u64E0', '\u64E1', '\u64E2', '\u64E3', '\u64E6', '\u64E7', '\u64EC', '\u64EF', '\u64F1', '\u64F2', '\u64F4',
            '\u64F6', '\u64FA', '\u64FD', '\u64FE', '\u6500', '\u6505', '\u6518', '\u651C', '\u651D', '\u6523', '\u6524', '\u652A', '\u652B', '\u652C', '\u652F', '\u6534', '\u6535', '\u6536', '\u6537', '\u6538', '\u6539', '\u653B', '\u653E', '\u653F', '\u6545', '\u6548', '\u654D', '\u654F', '\u6551', '\u6555', '\u6556', '\u6557',
            '\u6558', '\u6559', '\u655D', '\u655E', '\u6562', '\u6563', '\u6566', '\u656C', '\u6570', '\u6572', '\u6574', '\u6575', '\u6577', '\u6578', '\u6582', '\u6583', '\u6587', '\u6588', '\u6589', '\u658C', '\u658E', '\u6590', '\u6591', '\u6597', '\u6599', '\u659B', '\u659C', '\u659F', '\u65A1', '\u65A4', '\u65A5', '\u65A7',
            '\u65AB', '\u65AC', '\u65AD', '\u65AF', '\u65B0', '\u65B7', '\u65B9', '\u65BC', '\u65BD', '\u65C1', '\u65C3', '\u65C4', '\u65C5', '\u65C6', '\u65CB', '\u65CC', '\u65CF', '\u65D2', '\u65D7', '\u65D9', '\u65DB', '\u65E0', '\u65E1', '\u65E2', '\u65E5', '\u65E6', '\u65E7', '\u65E8', '\u65E9', '\u65EC', '\u65ED', '\u65F1',
            '\u65FA', '\u65FB', '\u6602', '\u6603', '\u6606', '\u6607', '\u660A', '\u660C', '\u660E', '\u660F', '\u6613', '\u6614', '\u661C', '\u661F', '\u6620', '\u6625', '\u6627', '\u6628', '\u662D', '\u662F', '\u6634', '\u6635', '\u6636', '\u663C', '\u663F', '\u6641', '\u6642', '\u6643', '\u6644', '\u6649', '\u664B', '\u664F',
            '\u6652', '\u665D', '\u665E', '\u665F', '\u6662', '\u6664', '\u6666', '\u6667', '\u6668', '\u6669', '\u666E', '\u666F', '\u6670', '\u6674', '\u6676', '\u667A', '\u6681', '\u6683', '\u6684', '\u6687', '\u6688', '\u6689', '\u668E', '\u6691', '\u6696', '\u6697', '\u6698', '\u669D', '\u66A2', '\u66A6', '\u66AB', '\u66AE',
            '\u66B4', '\u66B8', '\u66B9', '\u66BC', '\u66BE', '\u66C1', '\u66C4', '\u66C7', '\u66C9', '\u66D6', '\u66D9', '\u66DA', '\u66DC', '\u66DD', '\u66E0', '\u66E6', '\u66E9', '\u66F0', '\u66F2', '\u66F3', '\u66F4', '\u66F5', '\u66F7', '\u66F8', '\u66F9', '\u66FC', '\u66FD', '\u66FE', '\u66FF', '\u6700', '\u6703', '\u6708',
            '\u6709', '\u670B', '\u670D', '\u670F', '\u6714', '\u6715', '\u6716', '\u6717', '\u671B', '\u671D', '\u671E', '\u671F', '\u6726', '\u6727', '\u6728', '\u672A', '\u672B', '\u672C', '\u672D', '\u672E', '\u6731', '\u6734', '\u6736', '\u6737', '\u6738', '\u673A', '\u673D', '\u673F', '\u6741', '\u6746', '\u6749', '\u674E',
            '\u674F', '\u6750', '\u6751', '\u6753', '\u6756', '\u6759', '\u675C', '\u675E', '\u675F', '\u6760', '\u6761', '\u6762', '\u6763', '\u6764', '\u6765', '\u676A', '\u676D', '\u676F', '\u6770', '\u6771', '\u6772', '\u6773', '\u6775', '\u6777', '\u677C', '\u677E', '\u677F', '\u6785', '\u6787', '\u6789', '\u678B', '\u678C',
            '\u6790', '\u6795', '\u6797', '\u679A', '\u679C', '\u679D', '\u67A0', '\u67A1', '\u67A2', '\u67A6', '\u67A9', '\u67AF', '\u67B3', '\u67B4', '\u67B6', '\u67B7', '\u67B8', '\u67B9', '\u67C1', '\u67C4', '\u67C6', '\u67CA', '\u67CE', '\u67CF', '\u67D0', '\u67D1', '\u67D3', '\u67D4', '\u67D8', '\u67DA', '\u67DD', '\u67DE',
            '\u67E2', '\u67E4', '\u67E7', '\u67E9', '\u67EC', '\u67EE', '\u67EF', '\u67F1', '\u67F3', '\u67F4', '\u67F5', '\u67FB', '\u67FE', '\u67FF', '\u6802', '\u6803', '\u6804', '\u6813', '\u6816', '\u6817', '\u681E', '\u6821', '\u6822', '\u6829', '\u682A', '\u682B', '\u6832', '\u6834', '\u6838', '\u6839', '\u683C', '\u683D',
            '\u6840', '\u6841', '\u6842', '\u6843', '\u6846', '\u6848', '\u684D', '\u684E', '\u6850', '\u6851', '\u6853', '\u6854', '\u6859', '\u685C', '\u685D', '\u685F', '\u6863', '\u6867', '\u6874', '\u6876', '\u6877', '\u687E', '\u687F', '\u6881', '\u6883', '\u6885', '\u688D', '\u688F', '\u6893', '\u6894', '\u6897', '\u689B',
            '\u689D', '\u689F', '\u68A0', '\u68A2', '\u68A6', '\u68A7', '\u68A8', '\u68AD', '\u68AF', '\u68B0', '\u68B1', '\u68B3', '\u68B5', '\u68B6', '\u68B9', '\u68BA', '\u68BC', '\u68C4', '\u68C6', '\u68C9', '\u68CA', '\u68CB', '\u68CD', '\u68D2', '\u68D4', '\u68D5', '\u68D7', '\u68D8', '\u68DA', '\u68DF', '\u68E0', '\u68E1',
            '\u68E3', '\u68E7', '\u68EE', '\u68EF', '\u68F2', '\u68F9', '\u68FA', '\u6900', '\u6901', '\u6904', '\u6905', '\u6908', '\u690B', '\u690C', '\u690D', '\u690E', '\u690F', '\u6912', '\u6919', '\u691A', '\u691B', '\u691C', '\u6921', '\u6922', '\u6923', '\u6925', '\u6926', '\u6928', '\u692A', '\u6930', '\u6934', '\u6936',
            '\u6939', '\u693D', '\u693F', '\u694A', '\u6953', '\u6954', '\u6955', '\u6959', '\u695A', '\u695C', '\u695D', '\u695E', '\u6960', '\u6961', '\u6962', '\u696A', '\u696B', '\u696D', '\u696E', '\u696F', '\u6973', '\u6974', '\u6975', '\u6977', '\u6978', '\u6979', '\u697C', '\u697D', '\u697E', '\u6981', '\u6982', '\u698A',
            '\u698E', '\u6991', '\u6994', '\u6995', '\u699B', '\u699C', '\u69A0', '\u69A7', '\u69AE', '\u69B1', '\u69B2', '\u69B4', '\u69BB', '\u69BE', '\u69BF', '\u69C1', '\u69C3', '\u69C7', '\u69CA', '\u69CB', '\u69CC', '\u69CD', '\u69CE', '\u69D0', '\u69D3', '\u69D8', '\u69D9', '\u69DD', '\u69DE', '\u69E7', '\u69E8', '\u69EB',
            '\u69ED', '\u69F2', '\u69F9', '\u69FB', '\u69FD', '\u69FF', '\u6A02', '\u6A05', '\u6A0A', '\u6A0B', '\u6A0C', '\u6A12', '\u6A13', '\u6A14', '\u6A17', '\u6A19', '\u6A1B', '\u6A1E', '\u6A1F', '\u6A21', '\u6A22', '\u6A23', '\u6A29', '\u6A2A', '\u6A2B', '\u6A2E', '\u6A35', '\u6A36', '\u6A38', '\u6A39', '\u6A3A', '\u6A3D',
            '\u6A44', '\u6A47', '\u6A48', '\u6A4B', '\u6A58', '\u6A59', '\u6A5F', '\u6A61', '\u6A62', '\u6A66', '\u6A72', '\u6A78', '\u6A7F', '\u6A80', '\u6A84', '\u6A8D', '\u6A8E', '\u6A90', '\u6A97', '\u6A9C', '\u6AA0', '\u6AA2', '\u6AA3', '\u6AAA', '\u6AAC', '\u6AAE', '\u6AB3', '\u6AB8', '\u6ABB', '\u6AC1', '\u6AC2', '\u6AC3',
            '\u6AD1', '\u6AD3', '\u6ADA', '\u6ADB', '\u6ADE', '\u6ADF', '\u6AE8', '\u6AEA', '\u6AFA', '\u6AFB', '\u6B04', '\u6B05', '\u6B0A', '\u6B12', '\u6B16', '\u6B1D', '\u6B1F', '\u6B20', '\u6B21', '\u6B23', '\u6B27', '\u6B32', '\u6B37', '\u6B38', '\u6B39', '\u6B3A', '\u6B3D', '\u6B3E', '\u6B43', '\u6B47', '\u6B49', '\u6B4C',
            '\u6B4E', '\u6B50', '\u6B53', '\u6B54', '\u6B59', '\u6B5B', '\u6B5F', '\u6B61', '\u6B62', '\u6B63', '\u6B64', '\u6B66', '\u6B69', '\u6B6A', '\u6B6F', '\u6B73', '\u6B74', '\u6B78', '\u6B79', '\u6B7B', '\u6B7F', '\u6B80', '\u6B83', '\u6B84', '\u6B86', '\u6B89', '\u6B8A', '\u6B8B', '\u6B8D', '\u6B95', '\u6B96', '\u6B98',
            '\u6B9E', '\u6BA4', '\u6BAA', '\u6BAB', '\u6BAF', '\u6BB1', '\u6BB2', '\u6BB3', '\u6BB4', '\u6BB5', '\u6BB7', '\u6BBA', '\u6BBB', '\u6BBC', '\u6BBF', '\u6BC0', '\u6BC5', '\u6BC6', '\u6BCB', '\u6BCD', '\u6BCE', '\u6BD2', '\u6BD3', '\u6BD4', '\u6BD8', '\u6BDB', '\u6BDF', '\u6BEB', '\u6BEC', '\u6BEF', '\u6BF3', '\u6C08',
            '\u6C0F', '\u6C11', '\u6C13', '\u6C14', '\u6C17', '\u6C1B', '\u6C23', '\u6C24', '\u6C34', '\u6C37', '\u6C38', '\u6C3E', '\u6C40', '\u6C41', '\u6C42', '\u6C4E', '\u6C50', '\u6C55', '\u6C57', '\u6C5A', '\u6C5D', '\u6C5E', '\u6C5F', '\u6C60', '\u6C62', '\u6C68', '\u6C6A', '\u6C70', '\u6C72', '\u6C73', '\u6C7A', '\u6C7D',
            '\u6C7E', '\u6C81', '\u6C82', '\u6C83', '\u6C88', '\u6C8C', '\u6C8D', '\u6C90', '\u6C92', '\u6C93', '\u6C96', '\u6C99', '\u6C9A', '\u6C9B', '\u6CA1', '\u6CA2', '\u6CAB', '\u6CAE', '\u6CB1', '\u6CB3', '\u6CB8', '\u6CB9', '\u6CBA', '\u6CBB', '\u6CBC', '\u6CBD', '\u6CBE', '\u6CBF', '\u6CC1', '\u6CC4', '\u6CC5', '\u6CC9',
            '\u6CCA', '\u6CCC', '\u6CD3', '\u6CD5', '\u6CD7', '\u6CD9', '\u6CDB', '\u6CDD', '\u6CE1', '\u6CE2', '\u6CE3', '\u6CE5', '\u6CE8', '\u6CEA', '\u6CEF', '\u6CF0', '\u6CF1', '\u6CF3', '\u6D0B', '\u6D0C', '\u6D12', '\u6D17', '\u6D19', '\u6D1B', '\u6D1E', '\u6D1F', '\u6D25', '\u6D29', '\u6D2A', '\u6D2B', '\u6D32', '\u6D33',
            '\u6D35', '\u6D36', '\u6D38', '\u6D3B', '\u6D3D', '\u6D3E', '\u6D41', '\u6D44', '\u6D45', '\u6D59', '\u6D5A', '\u6D5C', '\u6D63', '\u6D64', '\u6D66', '\u6D69', '\u6D6A', '\u6D6C', '\u6D6E', '\u6D74', '\u6D77', '\u6D78', '\u6D79', '\u6D85', '\u6D88', '\u6D8C', '\u6D8E', '\u6D93', '\u6D95', '\u6D99', '\u6D9B', '\u6D9C',
            '\u6DAF', '\u6DB2', '\u6DB5', '\u6DB8', '\u6DBC', '\u6DC0', '\u6DC5', '\u6DC6', '\u6DC7', '\u6DCB', '\u6DCC', '\u6DD1', '\u6DD2', '\u6DD5', '\u6DD8', '\u6DD9', '\u6DDE', '\u6DE1', '\u6DE4', '\u6DE6', '\u6DE8', '\u6DEA', '\u6DEB', '\u6DEC', '\u6DEE', '\u6DF1', '\u6DF3', '\u6DF5', '\u6DF7', '\u6DF9', '\u6DFA', '\u6DFB',
            '\u6E05', '\u6E07', '\u6E08', '\u6E09', '\u6E0A', '\u6E0B', '\u6E13', '\u6E15', '\u6E19', '\u6E1A', '\u6E1B', '\u6E1D', '\u6E1F', '\u6E20', '\u6E21', '\u6E23', '\u6E24', '\u6E25', '\u6E26', '\u6E29', '\u6E2B', '\u6E2C', '\u6E2D', '\u6E2E', '\u6E2F', '\u6E38', '\u6E3A', '\u6E3E', '\u6E43', '\u6E4A', '\u6E4D', '\u6E4E',
            '\u6E56', '\u6E58', '\u6E5B', '\u6E5F', '\u6E67', '\u6E6B', '\u6E6E', '\u6E6F', '\u6E72', '\u6E76', '\u6E7E', '\u6E7F', '\u6E80', '\u6E82', '\u6E8C', '\u6E8F', '\u6E90', '\u6E96', '\u6E98', '\u6E9C', '\u6E9D', '\u6E9F', '\u6EA2', '\u6EA5', '\u6EAA', '\u6EAF', '\u6EB2', '\u6EB6', '\u6EB7', '\u6EBA', '\u6EBD', '\u6EC2',
            '\u6EC4', '\u6EC5', '\u6EC9', '\u6ECB', '\u6ECC', '\u6ED1', '\u6ED3', '\u6ED4', '\u6ED5', '\u6EDD', '\u6EDE', '\u6EEC', '\u6EEF', '\u6EF2', '\u6EF4', '\u6EF7', '\u6EF8', '\u6EFE', '\u6EFF', '\u6F01', '\u6F02', '\u6F06', '\u6F09', '\u6F0F', '\u6F11', '\u6F13', '\u6F14', '\u6F15', '\u6F20', '\u6F22', '\u6F23', '\u6F2B',
            '\u6F2C', '\u6F31', '\u6F32', '\u6F38', '\u6F3E', '\u6F3F', '\u6F41', '\u6F45', '\u6F54', '\u6F58', '\u6F5B', '\u6F5C', '\u6F5F', '\u6F64', '\u6F66', '\u6F6D', '\u6F6E', '\u6F6F', '\u6F70', '\u6F74', '\u6F78', '\u6F7A', '\u6F7C', '\u6F80', '\u6F81', '\u6F82', '\u6F84', '\u6F86', '\u6F8E', '\u6F91', '\u6F97', '\u6FA1',
            '\u6FA3', '\u6FA4', '\u6FAA', '\u6FB1', '\u6FB3', '\u6FB9', '\u6FC0', '\u6FC1', '\u6FC2', '\u6FC3', '\u6FC6', '\u6FD4', '\u6FD5', '\u6FD8', '\u6FDB', '\u6FDF', '\u6FE0', '\u6FE1', '\u6FE4', '\u6FEB', '\u6FEC', '\u6FEE', '\u6FEF', '\u6FF1', '\u6FF3', '\u6FF6', '\u6FFA', '\u6FFE', '\u7001', '\u7009', '\u700B', '\u700F',
            '\u7011', '\u7015', '\u7018', '\u701A', '\u701B', '\u701D', '\u701E', '\u701F', '\u7026', '\u7027', '\u702C', '\u7030', '\u7032', '\u703E', '\u704C', '\u7051', '\u7058', '\u7063', '\u706B', '\u706F', '\u7070', '\u7078', '\u707C', '\u707D', '\u7089', '\u708A', '\u708E', '\u7092', '\u7099', '\u70AC', '\u70AD', '\u70AE',
            '\u70AF', '\u70B3', '\u70B8', '\u70B9', '\u70BA', '\u70C8', '\u70CB', '\u70CF', '\u70D9', '\u70DD', '\u70DF', '\u70F1', '\u70F9', '\u70FD', '\u7109', '\u7114', '\u7119', '\u711A', '\u711C', '\u7121', '\u7126', '\u7136', '\u713C', '\u7149', '\u714C', '\u714E', '\u7155', '\u7156', '\u7159', '\u7162', '\u7164', '\u7165',
            '\u7166', '\u7167', '\u7169', '\u716C', '\u716E', '\u717D', '\u7184', '\u7188', '\u718A', '\u718F', '\u7194', '\u7195', '\u7199', '\u719F', '\u71A8', '\u71AC', '\u71B1', '\u71B9', '\u71BE', '\u71C3', '\u71C8', '\u71C9', '\u71CE', '\u71D0', '\u71D2', '\u71D4', '\u71D5', '\u71D7', '\u71DF', '\u71E0', '\u71E5', '\u71E6',
            '\u71E7', '\u71EC', '\u71ED', '\u71EE', '\u71F5', '\u71F9', '\u71FB', '\u71FC', '\u71FF', '\u7206', '\u720D', '\u7210', '\u721B', '\u7228', '\u722A', '\u722C', '\u722D', '\u7230', '\u7232', '\u7235', '\u7236', '\u723A', '\u723B', '\u723C', '\u723D', '\u723E', '\u723F', '\u7240', '\u7246', '\u7247', '\u7248', '\u724B',
            '\u724C', '\u7252', '\u7258', '\u7259', '\u725B', '\u725D', '\u725F', '\u7261', '\u7262', '\u7267', '\u7269', '\u7272', '\u7274', '\u7279', '\u727D', '\u727E', '\u7280', '\u7281', '\u7282', '\u7287', '\u7292', '\u7296', '\u72A0', '\u72A2', '\u72A7', '\u72AC', '\u72AF', '\u72B2', '\u72B6', '\u72B9', '\u72C2', '\u72C3',
            '\u72C4', '\u72C6', '\u72CE', '\u72D0', '\u72D2', '\u72D7', '\u72D9', '\u72DB', '\u72E0', '\u72E1', '\u72E2', '\u72E9', '\u72EC', '\u72ED', '\u72F7', '\u72F8', '\u72F9', '\u72FC', '\u72FD', '\u730A', '\u7316', '\u7317', '\u731B', '\u731C', '\u731D', '\u731F', '\u7325', '\u7329', '\u732A', '\u732B', '\u732E', '\u732F',
            '\u7334', '\u7336', '\u7337', '\u733E', '\u733F', '\u7344', '\u7345', '\u734E', '\u734F', '\u7357', '\u7363', '\u7368', '\u736A', '\u7370', '\u7372', '\u7375', '\u7378', '\u737A', '\u737B', '\u7384', '\u7387', '\u7389', '\u738B', '\u7396', '\u73A9', '\u73B2', '\u73B3', '\u73BB', '\u73C0', '\u73C2', '\u73C8', '\u73CA',
            '\u73CD', '\u73CE', '\u73DE', '\u73E0', '\u73E5', '\u73EA', '\u73ED', '\u73EE', '\u73F1', '\u73F8', '\u73FE', '\u7403', '\u7405', '\u7406', '\u7409', '\u7422', '\u7425', '\u7432', '\u7433', '\u7434', '\u7435', '\u7436', '\u743A', '\u743F', '\u7441', '\u7455', '\u7459', '\u745A', '\u745B', '\u745C', '\u745E', '\u745F',
            '\u7460', '\u7463', '\u7464', '\u7469', '\u746A', '\u746F', '\u7470', '\u7473', '\u7476', '\u747E', '\u7483', '\u748B', '\u749E', '\u74A2', '\u74A7', '\u74B0', '\u74BD', '\u74CA', '\u74CF', '\u74D4', '\u74DC', '\u74E0', '\u74E2', '\u74E3', '\u74E6', '\u74E7', '\u74E9', '\u74EE', '\u74F0', '\u74F1', '\u74F2', '\u74F6',
            '\u74F7', '\u74F8', '\u7503', '\u7504', '\u7505', '\u750C', '\u750D', '\u750E', '\u7511', '\u7513', '\u7515', '\u7518', '\u751A', '\u751C', '\u751E', '\u751F', '\u7523', '\u7525', '\u7526', '\u7528', '\u752B', '\u752C', '\u7530', '\u7531', '\u7532', '\u7533', '\u7537', '\u7538', '\u753A', '\u753B', '\u753C', '\u7544',
            '\u7546', '\u7549', '\u754A', '\u754B', '\u754C', '\u754D', '\u754F', '\u7551', '\u7554', '\u7559', '\u755A', '\u755B', '\u755C', '\u755D', '\u7560', '\u7562', '\u7564', '\u7565', '\u7566', '\u7567', '\u7569', '\u756A', '\u756B', '\u756D', '\u7570', '\u7573', '\u7574', '\u7576', '\u7577', '\u7578', '\u757F', '\u7582',
            '\u7586', '\u7587', '\u7589', '\u758A', '\u758B', '\u758E', '\u758F', '\u7591', '\u7594', '\u759A', '\u759D', '\u75A3', '\u75A5', '\u75AB', '\u75B1', '\u75B2', '\u75B3', '\u75B5', '\u75B8', '\u75B9', '\u75BC', '\u75BD', '\u75BE', '\u75C2', '\u75C3', '\u75C5', '\u75C7', '\u75CA', '\u75CD', '\u75D2', '\u75D4', '\u75D5',
            '\u75D8', '\u75D9', '\u75DB', '\u75DE', '\u75E2', '\u75E3', '\u75E9', '\u75F0', '\u75F2', '\u75F3', '\u75F4', '\u75FA', '\u75FC', '\u75FE', '\u75FF', '\u7601', '\u7609', '\u760B', '\u760D', '\u761F', '\u7620', '\u7621', '\u7622', '\u7624', '\u7627', '\u7630', '\u7634', '\u763B', '\u7642', '\u7646', '\u7647', '\u7648',
            '\u764C', '\u7652', '\u7656', '\u7658', '\u765C', '\u7661', '\u7662', '\u7667', '\u7668', '\u7669', '\u766A', '\u766C', '\u7670', '\u7672', '\u7676', '\u7678', '\u767A', '\u767B', '\u767C', '\u767D', '\u767E', '\u7680', '\u7683', '\u7684', '\u7686', '\u7687', '\u7688', '\u768B', '\u768E', '\u7690', '\u7693', '\u7696',
            '\u7699', '\u769A', '\u76AE', '\u76B0', '\u76B4', '\u76B7', '\u76B8', '\u76B9', '\u76BA', '\u76BF', '\u76C2', '\u76C3', '\u76C6', '\u76C8', '\u76CA', '\u76CD', '\u76D2', '\u76D6', '\u76D7', '\u76DB', '\u76DC', '\u76DE', '\u76DF', '\u76E1', '\u76E3', '\u76E4', '\u76E5', '\u76E7', '\u76EA', '\u76EE', '\u76F2', '\u76F4',
            '\u76F8', '\u76FB', '\u76FE', '\u7701', '\u7704', '\u7707', '\u7708', '\u7709', '\u770B', '\u770C', '\u771B', '\u771E', '\u771F', '\u7720', '\u7724', '\u7725', '\u7726', '\u7729', '\u7737', '\u7738', '\u773A', '\u773C', '\u7740', '\u7747', '\u775A', '\u775B', '\u7761', '\u7763', '\u7765', '\u7766', '\u7768', '\u776B',
            '\u7779', '\u777E', '\u777F', '\u778B', '\u778E', '\u7791', '\u779E', '\u77A0', '\u77A5', '\u77AC', '\u77AD', '\u77B0', '\u77B3', '\u77B6', '\u77B9', '\u77BB', '\u77BC', '\u77BD', '\u77BF', '\u77C7', '\u77CD', '\u77D7', '\u77DA', '\u77DB', '\u77DC', '\u77E2', '\u77E3', '\u77E5', '\u77E7', '\u77E9', '\u77ED', '\u77EE',
            '\u77EF', '\u77F3', '\u77FC', '\u7802', '\u780C', '\u7812', '\u7814', '\u7815', '\u7820', '\u7825', '\u7826', '\u7827', '\u7832', '\u7834', '\u783A', '\u783F', '\u7845', '\u785D', '\u786B', '\u786C', '\u786F', '\u7872', '\u7874', '\u787C', '\u7881', '\u7886', '\u7887', '\u788C', '\u788D', '\u788E', '\u7891', '\u7893',
            '\u7895', '\u7897', '\u789A', '\u78A3', '\u78A7', '\u78A9', '\u78AA', '\u78AF', '\u78B5', '\u78BA', '\u78BC', '\u78BE', '\u78C1', '\u78C5', '\u78C6', '\u78CA', '\u78CB', '\u78D0', '\u78D1', '\u78D4', '\u78DA', '\u78E7', '\u78E8', '\u78EC', '\u78EF', '\u78F4', '\u78FD', '\u7901', '\u7907', '\u790E', '\u7911', '\u7912',
            '\u7919', '\u7926', '\u792A', '\u792B', '\u792C', '\u793A', '\u793C', '\u793E', '\u7940', '\u7941', '\u7947', '\u7948', '\u7949', '\u7950', '\u7953', '\u7955', '\u7956', '\u7957', '\u795A', '\u795D', '\u795E', '\u795F', '\u7960', '\u7962', '\u7965', '\u7968', '\u796D', '\u7977', '\u797A', '\u797F', '\u7980', '\u7981',
            '\u7984', '\u7985', '\u798A', '\u798D', '\u798E', '\u798F', '\u799D', '\u79A6', '\u79A7', '\u79AA', '\u79AE', '\u79B0', '\u79B3', '\u79B9', '\u79BA', '\u79BD', '\u79BE', '\u79BF', '\u79C0', '\u79C1', '\u79C9', '\u79CB', '\u79D1', '\u79D2', '\u79D5', '\u79D8', '\u79DF', '\u79E1', '\u79E3', '\u79E4', '\u79E6', '\u79E7',
            '\u79E9', '\u79EC', '\u79F0', '\u79FB', '\u7A00', '\u7A08', '\u7A0B', '\u7A0D', '\u7A0E', '\u7A14', '\u7A17', '\u7A18', '\u7A19', '\u7A1A', '\u7A1C', '\u7A1F', '\u7A20', '\u7A2E', '\u7A31', '\u7A32', '\u7A37', '\u7A3B', '\u7A3C', '\u7A3D', '\u7A3E', '\u7A3F', '\u7A40', '\u7A42', '\u7A43', '\u7A46', '\u7A49', '\u7A4D',
            '\u7A4E', '\u7A4F', '\u7A50', '\u7A57', '\u7A61', '\u7A62', '\u7A63', '\u7A69', '\u7A6B', '\u7A70', '\u7A74', '\u7A76', '\u7A79', '\u7A7A', '\u7A7D', '\u7A7F', '\u7A81', '\u7A83', '\u7A84', '\u7A88', '\u7A92', '\u7A93', '\u7A95', '\u7A96', '\u7A97', '\u7A98', '\u7A9F', '\u7AA9', '\u7AAA', '\u7AAE', '\u7AAF', '\u7AB0',
            '\u7AB6', '\u7ABA', '\u7ABF', '\u7AC3', '\u7AC4', '\u7AC5', '\u7AC7', '\u7AC8', '\u7ACA', '\u7ACB', '\u7ACD', '\u7ACF', '\u7AD2', '\u7AD3', '\u7AD5', '\u7AD9', '\u7ADA', '\u7ADC', '\u7ADD', '\u7ADF', '\u7AE0', '\u7AE1', '\u7AE2', '\u7AE3', '\u7AE5', '\u7AE6', '\u7AEA', '\u7AED', '\u7AEF', '\u7AF0', '\u7AF6', '\u7AF8',
            '\u7AF9', '\u7AFA', '\u7AFF', '\u7B02', '\u7B04', '\u7B06', '\u7B08', '\u7B0A', '\u7B0B', '\u7B0F', '\u7B11', '\u7B18', '\u7B19', '\u7B1B', '\u7B1E', '\u7B20', '\u7B25', '\u7B26', '\u7B28', '\u7B2C', '\u7B33', '\u7B35', '\u7B36', '\u7B39', '\u7B45', '\u7B46', '\u7B48', '\u7B49', '\u7B4B', '\u7B4C', '\u7B4D', '\u7B4F',
            '\u7B50', '\u7B51', '\u7B52', '\u7B54', '\u7B56', '\u7B5D', '\u7B65', '\u7B67', '\u7B6C', '\u7B6E', '\u7B70', '\u7B71', '\u7B74', '\u7B75', '\u7B7A', '\u7B86', '\u7B87', '\u7B8B', '\u7B8D', '\u7B8F', '\u7B92', '\u7B94', '\u7B95', '\u7B97', '\u7B98', '\u7B99', '\u7B9A', '\u7B9C', '\u7B9D', '\u7B9F', '\u7BA1', '\u7BAA',
            '\u7BAD', '\u7BB1', '\u7BB4', '\u7BB8', '\u7BC0', '\u7BC1', '\u7BC4', '\u7BC6', '\u7BC7', '\u7BC9', '\u7BCB', '\u7BCC', '\u7BCF', '\u7BDD', '\u7BE0', '\u7BE4', '\u7BE5', '\u7BE6', '\u7BE9', '\u7BED', '\u7BF3', '\u7BF6', '\u7BF7', '\u7C00', '\u7C07', '\u7C0D', '\u7C11', '\u7C12', '\u7C13', '\u7C14', '\u7C17', '\u7C1F',
            '\u7C21', '\u7C23', '\u7C27', '\u7C2A', '\u7C2B', '\u7C37', '\u7C38', '\u7C3D', '\u7C3E', '\u7C3F', '\u7C40', '\u7C43', '\u7C4C', '\u7C4D', '\u7C4F', '\u7C50', '\u7C54', '\u7C56', '\u7C58', '\u7C5F', '\u7C60', '\u7C64', '\u7C65', '\u7C6C', '\u7C73', '\u7C75', '\u7C7E', '\u7C81', '\u7C82', '\u7C83', '\u7C89', '\u7C8B',
            '\u7C8D', '\u7C90', '\u7C92', '\u7C95', '\u7C97', '\u7C98', '\u7C9B', '\u7C9F', '\u7CA1', '\u7CA2', '\u7CA4', '\u7CA5', '\u7CA7', '\u7CA8', '\u7CAB', '\u7CAD', '\u7CAE', '\u7CB1', '\u7CB2', '\u7CB3', '\u7CB9', '\u7CBD', '\u7CBE', '\u7CC0', '\u7CC2', '\u7CC5', '\u7CCA', '\u7CCE', '\u7CD2', '\u7CD6', '\u7CD8', '\u7CDC',
            '\u7CDE', '\u7CDF', '\u7CE0', '\u7CE2', '\u7CE7', '\u7CEF', '\u7CF2', '\u7CF4', '\u7CF6', '\u7CF8', '\u7CFA', '\u7CFB', '\u7CFE', '\u7D00', '\u7D02', '\u7D04', '\u7D05', '\u7D06', '\u7D0A', '\u7D0B', '\u7D0D', '\u7D10', '\u7D14', '\u7D15', '\u7D17', '\u7D18', '\u7D19', '\u7D1A', '\u7D1B', '\u7D1C', '\u7D20', '\u7D21',
            '\u7D22', '\u7D2B', '\u7D2C', '\u7D2E', '\u7D2F', '\u7D30', '\u7D32', '\u7D33', '\u7D35', '\u7D39', '\u7D3A', '\u7D3F', '\u7D42', '\u7D43', '\u7D44', '\u7D45', '\u7D46', '\u7D4B', '\u7D4C', '\u7D4E', '\u7D4F', '\u7D50', '\u7D56', '\u7D5B', '\u7D5E', '\u7D61', '\u7D62', '\u7D63', '\u7D66', '\u7D68', '\u7D6E', '\u7D71',
            '\u7D72', '\u7D73', '\u7D75', '\u7D76', '\u7D79', '\u7D7D', '\u7D89', '\u7D8F', '\u7D93', '\u7D99', '\u7D9A', '\u7D9B', '\u7D9C', '\u7D9F', '\u7DA2', '\u7DA3', '\u7DAB', '\u7DAC', '\u7DAD', '\u7DAE', '\u7DAF', '\u7DB0', '\u7DB1', '\u7DB2', '\u7DB4', '\u7DB5', '\u7DB8', '\u7DBA', '\u7DBB', '\u7DBD', '\u7DBE', '\u7DBF',
            '\u7DC7', '\u7DCA', '\u7DCB', '\u7DCF', '\u7DD1', '\u7DD2', '\u7DD5', '\u7DD8', '\u7DDA', '\u7DDC', '\u7DDD', '\u7DDE', '\u7DE0', '\u7DE1', '\u7DE4', '\u7DE8', '\u7DE9', '\u7DEC', '\u7DEF', '\u7DF2', '\u7DF4', '\u7DFB', '\u7E01', '\u7E04', '\u7E05', '\u7E09', '\u7E0A', '\u7E0B', '\u7E12', '\u7E1B', '\u7E1E', '\u7E1F',
            '\u7E21', '\u7E22', '\u7E23', '\u7E26', '\u7E2B', '\u7E2E', '\u7E31', '\u7E32', '\u7E35', '\u7E37', '\u7E39', '\u7E3A', '\u7E3B', '\u7E3D', '\u7E3E', '\u7E41', '\u7E43', '\u7E46', '\u7E4A', '\u7E4B', '\u7E4D', '\u7E54', '\u7E55', '\u7E56', '\u7E59', '\u7E5A', '\u7E5D', '\u7E5E', '\u7E66', '\u7E67', '\u7E69', '\u7E6A',
            '\u7E6D', '\u7E70', '\u7E79', '\u7E7B', '\u7E7C', '\u7E7D', '\u7E7F', '\u7E82', '\u7E83', '\u7E88', '\u7E89', '\u7E8C', '\u7E8E', '\u7E8F', '\u7E90', '\u7E92', '\u7E93', '\u7E94', '\u7E96', '\u7E9B', '\u7E9C', '\u7F36', '\u7F38', '\u7F3A', '\u7F45', '\u7F4C', '\u7F4D', '\u7F4E', '\u7F50', '\u7F51', '\u7F54', '\u7F55',
            '\u7F58', '\u7F5F', '\u7F60', '\u7F67', '\u7F68', '\u7F69', '\u7F6A', '\u7F6B', '\u7F6E', '\u7F70', '\u7F72', '\u7F75', '\u7F77', '\u7F78', '\u7F79', '\u7F82', '\u7F83', '\u7F85', '\u7F86', '\u7F87', '\u7F88', '\u7F8A', '\u7F8C', '\u7F8E', '\u7F94', '\u7F9A', '\u7F9D', '\u7F9E', '\u7FA3', '\u7FA4', '\u7FA8', '\u7FA9',
            '\u7FAE', '\u7FAF', '\u7FB2', '\u7FB6', '\u7FB8', '\u7FB9', '\u7FBD', '\u7FC1', '\u7FC5', '\u7FC6', '\u7FCA', '\u7FCC', '\u7FD2', '\u7FD4', '\u7FD5', '\u7FE0', '\u7FE1', '\u7FE6', '\u7FE9', '\u7FEB', '\u7FF0', '\u7FF3', '\u7FF9', '\u7FFB', '\u7FFC', '\u8000', '\u8001', '\u8003', '\u8004', '\u8005', '\u8006', '\u800B',
            '\u800C', '\u8010', '\u8012', '\u8015', '\u8017', '\u8018', '\u8019', '\u801C', '\u8021', '\u8028', '\u8033', '\u8036', '\u803B', '\u803D', '\u803F', '\u8046', '\u804A', '\u8052', '\u8056', '\u8058', '\u805A', '\u805E', '\u805F', '\u8061', '\u8062', '\u8068', '\u806F', '\u8070', '\u8072', '\u8073', '\u8074', '\u8076',
            '\u8077', '\u8079', '\u807D', '\u807E', '\u807F', '\u8084', '\u8085', '\u8086', '\u8087', '\u8089', '\u808B', '\u808C', '\u8093', '\u8096', '\u8098', '\u809A', '\u809B', '\u809D', '\u80A1', '\u80A2', '\u80A5', '\u80A9', '\u80AA', '\u80AC', '\u80AD', '\u80AF', '\u80B1', '\u80B2', '\u80B4', '\u80BA', '\u80C3', '\u80C4',
            '\u80C6', '\u80CC', '\u80CE', '\u80D6', '\u80D9', '\u80DA', '\u80DB', '\u80DD', '\u80DE', '\u80E1', '\u80E4', '\u80E5', '\u80EF', '\u80F1', '\u80F4', '\u80F8', '\u80FC', '\u80FD', '\u8102', '\u8105', '\u8106', '\u8107', '\u8108', '\u8109', '\u810A', '\u811A', '\u811B', '\u8123', '\u8129', '\u812F', '\u8131', '\u8133',
            '\u8139', '\u813E', '\u8146', '\u814B', '\u814E', '\u8150', '\u8151', '\u8153', '\u8154', '\u8155', '\u815F', '\u8165', '\u8166', '\u816B', '\u816E', '\u8170', '\u8171', '\u8174', '\u8178', '\u8179', '\u817A', '\u817F', '\u8180', '\u8182', '\u8183', '\u8188', '\u818A', '\u818F', '\u8193', '\u8195', '\u819A', '\u819C',
            '\u819D', '\u81A0', '\u81A3', '\u81A4', '\u81A8', '\u81A9', '\u81B0', '\u81B3', '\u81B5', '\u81B8', '\u81BA', '\u81BD', '\u81BE', '\u81BF', '\u81C0', '\u81C2', '\u81C6', '\u81C8', '\u81C9', '\u81CD', '\u81D1', '\u81D3', '\u81D8', '\u81D9', '\u81DA', '\u81DF', '\u81E0', '\u81E3', '\u81E5', '\u81E7', '\u81E8', '\u81EA',
            '\u81ED', '\u81F3', '\u81F4', '\u81FA', '\u81FB', '\u81FC', '\u81FE', '\u8201', '\u8202', '\u8205', '\u8207', '\u8208', '\u8209', '\u820A', '\u820C', '\u820D', '\u820E', '\u8210', '\u8212', '\u8216', '\u8217', '\u8218', '\u821B', '\u821C', '\u821E', '\u821F', '\u8229', '\u822A', '\u822B', '\u822C', '\u822E', '\u8233',
            '\u8235', '\u8236', '\u8237', '\u8238', '\u8239', '\u8240', '\u8247', '\u8258', '\u8259', '\u825A', '\u825D', '\u825F', '\u8262', '\u8264', '\u8266', '\u8268', '\u826A', '\u826B', '\u826E', '\u826F', '\u8271', '\u8272', '\u8276', '\u8277', '\u8278', '\u827E', '\u828B', '\u828D', '\u8292', '\u8299', '\u829D', '\u829F',
            '\u82A5', '\u82A6', '\u82AB', '\u82AC', '\u82AD', '\u82AF', '\u82B1', '\u82B3', '\u82B8', '\u82B9', '\u82BB', '\u82BD', '\u82C5', '\u82D1', '\u82D2', '\u82D3', '\u82D4', '\u82D7', '\u82D9', '\u82DB', '\u82DC', '\u82DE', '\u82DF', '\u82E1', '\u82E3', '\u82E5', '\u82E6', '\u82E7', '\u82EB', '\u82F1', '\u82F3', '\u82F4',
            '\u82F9', '\u82FA', '\u82FB', '\u8302', '\u8303', '\u8304', '\u8305', '\u8306', '\u8309', '\u830E', '\u8316', '\u8317', '\u8318', '\u831C', '\u8323', '\u8328', '\u832B', '\u832F', '\u8331', '\u8332', '\u8334', '\u8335', '\u8336', '\u8338', '\u8339', '\u8340', '\u8345', '\u8349', '\u834A', '\u834F', '\u8350', '\u8352',
            '\u8358', '\u8373', '\u8375', '\u8377', '\u837B', '\u837C', '\u8385', '\u8387', '\u8389', '\u838A', '\u838E', '\u8393', '\u8396', '\u839A', '\u839E', '\u839F', '\u83A0', '\u83A2', '\u83A8', '\u83AA', '\u83AB', '\u83B1', '\u83B5', '\u83BD', '\u83C1', '\u83C5', '\u83CA', '\u83CC', '\u83CE', '\u83D3', '\u83D6', '\u83D8',
            '\u83DC', '\u83DF', '\u83E0', '\u83E9', '\u83EB', '\u83EF', '\u83F0', '\u83F1', '\u83F2', '\u83F4', '\u83F7', '\u83FB', '\u83FD', '\u8403', '\u8404', '\u8407', '\u840B', '\u840C', '\u840D', '\u840E', '\u8413', '\u8420', '\u8422', '\u8429', '\u842A', '\u842C', '\u8431', '\u8435', '\u8438', '\u843C', '\u843D', '\u8446',
            '\u8449', '\u844E', '\u8457', '\u845B', '\u8461', '\u8462', '\u8463', '\u8466', '\u8469', '\u846B', '\u846C', '\u846D', '\u846E', '\u846F', '\u8471', '\u8475', '\u8477', '\u8479', '\u847A', '\u8482', '\u8484', '\u848B', '\u8490', '\u8494', '\u8499', '\u849C', '\u849F', '\u84A1', '\u84AD', '\u84B2', '\u84B8', '\u84B9',
            '\u84BB', '\u84BC', '\u84BF', '\u84C1', '\u84C4', '\u84C6', '\u84C9', '\u84CA', '\u84CB', '\u84CD', '\u84D0', '\u84D1', '\u84D6', '\u84D9', '\u84DA', '\u84EC', '\u84EE', '\u84F4', '\u84FC', '\u84FF', '\u8500', '\u8506', '\u8511', '\u8513', '\u8514', '\u8515', '\u8517', '\u8518', '\u851A', '\u851F', '\u8521', '\u8526',
            '\u852C', '\u852D', '\u8535', '\u853D', '\u8540', '\u8541', '\u8543', '\u8548', '\u8549', '\u854A', '\u854B', '\u854E', '\u8555', '\u8557', '\u8558', '\u855A', '\u8563', '\u8568', '\u8569', '\u856A', '\u856D', '\u8577', '\u857E', '\u8580', '\u8584', '\u8587', '\u8588', '\u858A', '\u8590', '\u8591', '\u8594', '\u8597',
            '\u8599', '\u859B', '\u859C', '\u85A4', '\u85A6', '\u85A8', '\u85A9', '\u85AA', '\u85AB', '\u85AC', '\u85AE', '\u85AF', '\u85B9', '\u85BA', '\u85C1', '\u85C9', '\u85CD', '\u85CF', '\u85D0', '\u85D5', '\u85DC', '\u85DD', '\u85E4', '\u85E5', '\u85E9', '\u85EA', '\u85F7', '\u85F9', '\u85FA', '\u85FB', '\u85FE', '\u8602',
            '\u8606', '\u8607', '\u860A', '\u860B', '\u8613', '\u8616', '\u8617', '\u861A', '\u8622', '\u862D', '\u862F', '\u8630', '\u863F', '\u864D', '\u864E', '\u8650', '\u8654', '\u8655', '\u865A', '\u865C', '\u865E', '\u865F', '\u8667', '\u866B', '\u8671', '\u8679', '\u867B', '\u868A', '\u868B', '\u868C', '\u8693', '\u8695',
            '\u86A3', '\u86A4', '\u86A9', '\u86AA', '\u86AB', '\u86AF', '\u86B0', '\u86B6', '\u86C4', '\u86C6', '\u86C7', '\u86C9', '\u86CB', '\u86CD', '\u86CE', '\u86D4', '\u86D9', '\u86DB', '\u86DE', '\u86DF', '\u86E4', '\u86E9', '\u86EC', '\u86ED', '\u86EE', '\u86EF', '\u86F8', '\u86F9', '\u86FB', '\u86FE', '\u8700', '\u8702',
            '\u8703', '\u8706', '\u8708', '\u8709', '\u870A', '\u870D', '\u8711', '\u8712', '\u8718', '\u871A', '\u871C', '\u8725', '\u8729', '\u8734', '\u8737', '\u873B', '\u873F', '\u8749', '\u874B', '\u874C', '\u874E', '\u8753', '\u8755', '\u8757', '\u8759', '\u875F', '\u8760', '\u8763', '\u8766', '\u8768', '\u876A', '\u876E',
            '\u8774', '\u8776', '\u8778', '\u877F', '\u8782', '\u878D', '\u879F', '\u87A2', '\u87AB', '\u87AF', '\u87B3', '\u87BA', '\u87BB', '\u87BD', '\u87C0', '\u87C4', '\u87C6', '\u87C7', '\u87CB', '\u87D0', '\u87D2', '\u87E0', '\u87EF', '\u87F2', '\u87F6', '\u87F7', '\u87F9', '\u87FB', '\u87FE', '\u8805', '\u880D', '\u880E',
            '\u880F', '\u8811', '\u8815', '\u8816', '\u8821', '\u8822', '\u8823', '\u8827', '\u8831', '\u8836', '\u8839', '\u883B', '\u8840', '\u8842', '\u8844', '\u8846', '\u884C', '\u884D', '\u8852', '\u8853', '\u8857', '\u8859', '\u885B', '\u885D', '\u885E', '\u8861', '\u8862', '\u8863', '\u8868', '\u886B', '\u8870', '\u8872',
            '\u8875', '\u8877', '\u887D', '\u887E', '\u887F', '\u8881', '\u8882', '\u8888', '\u888B', '\u888D', '\u8892', '\u8896', '\u8897', '\u8899', '\u889E', '\u88A2', '\u88A4', '\u88AB', '\u88AE', '\u88B0', '\u88B1', '\u88B4', '\u88B5', '\u88B7', '\u88BF', '\u88C1', '\u88C2', '\u88C3', '\u88C4', '\u88C5', '\u88CF', '\u88D4',
            '\u88D5', '\u88D8', '\u88D9', '\u88DC', '\u88DD', '\u88DF', '\u88E1', '\u88E8', '\u88F2', '\u88F3', '\u88F4', '\u88F8', '\u88F9', '\u88FC', '\u88FD', '\u88FE', '\u8902', '\u8904', '\u8907', '\u890A', '\u890C', '\u8910', '\u8912', '\u8913', '\u891D', '\u891E', '\u8925', '\u892A', '\u892B', '\u8936', '\u8938', '\u893B',
            '\u8941', '\u8943', '\u8944', '\u894C', '\u894D', '\u8956', '\u895E', '\u895F', '\u8960', '\u8964', '\u8966', '\u896A', '\u896D', '\u896F', '\u8972', '\u8974', '\u8977', '\u897E', '\u897F', '\u8981', '\u8983', '\u8986', '\u8987', '\u8988', '\u898A', '\u898B', '\u898F', '\u8993', '\u8996', '\u8997', '\u8998', '\u899A',
            '\u89A1', '\u89A6', '\u89A7', '\u89A9', '\u89AA', '\u89AC', '\u89AF', '\u89B2', '\u89B3', '\u89BA', '\u89BD', '\u89BF', '\u89C0', '\u89D2', '\u89DA', '\u89DC', '\u89DD', '\u89E3', '\u89E6', '\u89E7', '\u89F4', '\u89F8', '\u8A00', '\u8A02', '\u8A03', '\u8A08', '\u8A0A', '\u8A0C', '\u8A0E', '\u8A10', '\u8A13', '\u8A16',
            '\u8A17', '\u8A18', '\u8A1B', '\u8A1D', '\u8A1F', '\u8A23', '\u8A25', '\u8A2A', '\u8A2D', '\u8A31', '\u8A33', '\u8A34', '\u8A36', '\u8A3A', '\u8A3B', '\u8A3C', '\u8A41', '\u8A46', '\u8A48', '\u8A50', '\u8A51', '\u8A52', '\u8A54', '\u8A55', '\u8A5B', '\u8A5E', '\u8A60', '\u8A62', '\u8A63', '\u8A66', '\u8A69', '\u8A6B',
            '\u8A6C', '\u8A6D', '\u8A6E', '\u8A70', '\u8A71', '\u8A72', '\u8A73', '\u8A7C', '\u8A82', '\u8A84', '\u8A85', '\u8A87', '\u8A89', '\u8A8C', '\u8A8D', '\u8A91', '\u8A93', '\u8A95', '\u8A98', '\u8A9A', '\u8A9E', '\u8AA0', '\u8AA1', '\u8AA3', '\u8AA4', '\u8AA5', '\u8AA6', '\u8AA8', '\u8AAC', '\u8AAD', '\u8AB0', '\u8AB2',
            '\u8AB9', '\u8ABC', '\u8ABF', '\u8AC2', '\u8AC4', '\u8AC7', '\u8ACB', '\u8ACC', '\u8ACD', '\u8ACF', '\u8AD2', '\u8AD6', '\u8ADA', '\u8ADB', '\u8ADC', '\u8ADE', '\u8AE0', '\u8AE1', '\u8AE2', '\u8AE4', '\u8AE6', '\u8AE7', '\u8AEB', '\u8AED', '\u8AEE', '\u8AF1', '\u8AF3', '\u8AF7', '\u8AF8', '\u8AFA', '\u8AFE', '\u8B00',
            '\u8B01', '\u8B02', '\u8B04', '\u8B07', '\u8B0C', '\u8B0E', '\u8B10', '\u8B14', '\u8B16', '\u8B17', '\u8B19', '\u8B1A', '\u8B1B', '\u8B1D', '\u8B20', '\u8B21', '\u8B26', '\u8B28', '\u8B2B', '\u8B2C', '\u8B33', '\u8B39', '\u8B3E', '\u8B41', '\u8B49', '\u8B4C', '\u8B4E', '\u8B4F', '\u8B56', '\u8B58', '\u8B5A', '\u8B5B',
            '\u8B5C', '\u8B5F', '\u8B66', '\u8B6B', '\u8B6C', '\u8B6F', '\u8B70', '\u8B71', '\u8B72', '\u8B74', '\u8B77', '\u8B7D', '\u8B80', '\u8B83', '\u8B8A', '\u8B8C', '\u8B8E', '\u8B90', '\u8B92', '\u8B93', '\u8B96', '\u8B99', '\u8B9A', '\u8C37', '\u8C3A', '\u8C3F', '\u8C41', '\u8C46', '\u8C48', '\u8C4A', '\u8C4C', '\u8C4E',
            '\u8C50', '\u8C55', '\u8C5A', '\u8C61', '\u8C62', '\u8C6A', '\u8C6B', '\u8C6C', '\u8C78', '\u8C79', '\u8C7A', '\u8C7C', '\u8C82', '\u8C85', '\u8C89', '\u8C8A', '\u8C8C', '\u8C8D', '\u8C8E', '\u8C94', '\u8C98', '\u8C9D', '\u8C9E', '\u8CA0', '\u8CA1', '\u8CA2', '\u8CA7', '\u8CA8', '\u8CA9', '\u8CAA', '\u8CAB', '\u8CAC',
            '\u8CAD', '\u8CAE', '\u8CAF', '\u8CB0', '\u8CB2', '\u8CB3', '\u8CB4', '\u8CB6', '\u8CB7', '\u8CB8', '\u8CBB', '\u8CBC', '\u8CBD', '\u8CBF', '\u8CC0', '\u8CC1', '\u8CC2', '\u8CC3', '\u8CC4', '\u8CC7', '\u8CC8', '\u8CCA', '\u8CCD', '\u8CCE', '\u8CD1', '\u8CD3', '\u8CDA', '\u8CDB', '\u8CDC', '\u8CDE', '\u8CE0', '\u8CE2',
            '\u8CE3', '\u8CE4', '\u8CE6', '\u8CEA', '\u8CED', '\u8CFA', '\u8CFB', '\u8CFC', '\u8CFD', '\u8D04', '\u8D05', '\u8D07', '\u8D08', '\u8D0A', '\u8D0B', '\u8D0D', '\u8D0F', '\u8D10', '\u8D13', '\u8D14', '\u8D16', '\u8D64', '\u8D66', '\u8D67', '\u8D6B', '\u8D6D', '\u8D70', '\u8D71', '\u8D73', '\u8D74', '\u8D77', '\u8D81',
            '\u8D85', '\u8D8A', '\u8D99', '\u8DA3', '\u8DA8', '\u8DB3', '\u8DBA', '\u8DBE', '\u8DC2', '\u8DCB', '\u8DCC', '\u8DCF', '\u8DD6', '\u8DDA', '\u8DDB', '\u8DDD', '\u8DDF', '\u8DE1', '\u8DE3', '\u8DE8', '\u8DEA', '\u8DEB', '\u8DEF', '\u8DF3', '\u8DF5', '\u8DFC', '\u8DFF', '\u8E08', '\u8E09', '\u8E0A', '\u8E0F', '\u8E10',
            '\u8E1D', '\u8E1E', '\u8E1F', '\u8E2A', '\u8E30', '\u8E34', '\u8E35', '\u8E42', '\u8E44', '\u8E47', '\u8E48', '\u8E49', '\u8E4A', '\u8E4C', '\u8E50', '\u8E55', '\u8E59', '\u8E5F', '\u8E60', '\u8E63', '\u8E64', '\u8E72', '\u8E74', '\u8E76', '\u8E7C', '\u8E81', '\u8E84', '\u8E85', '\u8E87', '\u8E8A', '\u8E8B', '\u8E8D',
            '\u8E91', '\u8E93', '\u8E94', '\u8E99', '\u8EA1', '\u8EAA', '\u8EAB', '\u8EAC', '\u8EAF', '\u8EB0', '\u8EB1', '\u8EBE', '\u8EC5', '\u8EC6', '\u8EC8', '\u8ECA', '\u8ECB', '\u8ECC', '\u8ECD', '\u8ED2', '\u8EDB', '\u8EDF', '\u8EE2', '\u8EE3', '\u8EEB', '\u8EF8', '\u8EFB', '\u8EFC', '\u8EFD', '\u8EFE', '\u8F03', '\u8F05',
            '\u8F09', '\u8F0A', '\u8F0C', '\u8F12', '\u8F13', '\u8F14', '\u8F15', '\u8F19', '\u8F1B', '\u8F1C', '\u8F1D', '\u8F1F', '\u8F26', '\u8F29', '\u8F2A', '\u8F2F', '\u8F33', '\u8F38', '\u8F39', '\u8F3B', '\u8F3E', '\u8F3F', '\u8F42', '\u8F44', '\u8F45', '\u8F46', '\u8F49', '\u8F4C', '\u8F4D', '\u8F4E', '\u8F57', '\u8F5C',
            '\u8F5F', '\u8F61', '\u8F62', '\u8F63', '\u8F64', '\u8F9B', '\u8F9C', '\u8F9E', '\u8F9F', '\u8FA3', '\u8FA7', '\u8FA8', '\u8FAD', '\u8FAE', '\u8FAF', '\u8FB0', '\u8FB1', '\u8FB2', '\u8FB7', '\u8FBA', '\u8FBB', '\u8FBC', '\u8FBF', '\u8FC2', '\u8FC4', '\u8FC5', '\u8FCE', '\u8FD1', '\u8FD4', '\u8FDA', '\u8FE2', '\u8FE5',
            '\u8FE6', '\u8FE9', '\u8FEA', '\u8FEB', '\u8FED', '\u8FEF', '\u8FF0', '\u8FF4', '\u8FF7', '\u8FF8', '\u8FF9', '\u8FFA', '\u8FFD', '\u9000', '\u9001', '\u9003', '\u9005', '\u9006', '\u900B', '\u900D', '\u900E', '\u900F', '\u9010', '\u9011', '\u9013', '\u9014', '\u9015', '\u9016', '\u9017', '\u9019', '\u901A', '\u901D',
            '\u901E', '\u901F', '\u9020', '\u9021', '\u9022', '\u9023', '\u9027', '\u902E', '\u9031', '\u9032', '\u9035', '\u9036', '\u9038', '\u9039', '\u903C', '\u903E', '\u9041', '\u9042', '\u9045', '\u9047', '\u9049', '\u904A', '\u904B', '\u904D', '\u904E', '\u904F', '\u9050', '\u9051', '\u9052', '\u9053', '\u9054', '\u9055',
            '\u9056', '\u9058', '\u9059', '\u905C', '\u905E', '\u9060', '\u9061', '\u9063', '\u9065', '\u9068', '\u9069', '\u906D', '\u906E', '\u906F', '\u9072', '\u9075', '\u9076', '\u9077', '\u9078', '\u907A', '\u907C', '\u907D', '\u907F', '\u9080', '\u9081', '\u9082', '\u9083', '\u9084', '\u9087', '\u9089', '\u908A', '\u908F',
            '\u9091', '\u90A3', '\u90A6', '\u90A8', '\u90AA', '\u90AF', '\u90B1', '\u90B5', '\u90B8', '\u90C1', '\u90CA', '\u90CE', '\u90DB', '\u90E1', '\u90E2', '\u90E4', '\u90E8', '\u90ED', '\u90F5', '\u90F7', '\u90FD', '\u9102', '\u9112', '\u9119', '\u912D', '\u9130', '\u9132', '\u9149', '\u914A', '\u914B', '\u914C', '\u914D',
            '\u914E', '\u9152', '\u9154', '\u9156', '\u9158', '\u9162', '\u9163', '\u9165', '\u9169', '\u916A', '\u916C', '\u9172', '\u9173', '\u9175', '\u9177', '\u9178', '\u9182', '\u9187', '\u9189', '\u918B', '\u918D', '\u9190', '\u9192', '\u9197', '\u919C', '\u91A2', '\u91A4', '\u91AA', '\u91AB', '\u91AF', '\u91B4', '\u91B5',
            '\u91B8', '\u91BA', '\u91C0', '\u91C1', '\u91C6', '\u91C7', '\u91C8', '\u91C9', '\u91CB', '\u91CC', '\u91CD', '\u91CE', '\u91CF', '\u91D0', '\u91D1', '\u91D6', '\u91D8', '\u91DB', '\u91DC', '\u91DD', '\u91DF', '\u91E1', '\u91E3', '\u91E6', '\u91E7', '\u91F5', '\u91F6', '\u91FC', '\u91FF', '\u920D', '\u920E', '\u9211',
            '\u9214', '\u9215', '\u921E', '\u9229', '\u922C', '\u9234', '\u9237', '\u923F', '\u9244', '\u9245', '\u9248', '\u9249', '\u924B', '\u9250', '\u9257', '\u925A', '\u925B', '\u925E', '\u9262', '\u9264', '\u9266', '\u9271', '\u927E', '\u9280', '\u9283', '\u9285', '\u9291', '\u9293', '\u9295', '\u9296', '\u9298', '\u929A',
            '\u929B', '\u929C', '\u92AD', '\u92B7', '\u92B9', '\u92CF', '\u92D2', '\u92E4', '\u92E9', '\u92EA', '\u92ED', '\u92F2', '\u92F3', '\u92F8', '\u92FA', '\u92FC', '\u9306', '\u930F', '\u9310', '\u9318', '\u9319', '\u931A', '\u9320', '\u9322', '\u9323', '\u9326', '\u9328', '\u932B', '\u932C', '\u932E', '\u932F', '\u9332',
            '\u9335', '\u933A', '\u933B', '\u9344', '\u934B', '\u934D', '\u9354', '\u9356', '\u935B', '\u935C', '\u9360', '\u936C', '\u936E', '\u9375', '\u937C', '\u937E', '\u938C', '\u9394', '\u9396', '\u9397', '\u939A', '\u93A7', '\u93AC', '\u93AD', '\u93AE', '\u93B0', '\u93B9', '\u93C3', '\u93C8', '\u93D0', '\u93D1', '\u93D6',
            '\u93D7', '\u93D8', '\u93DD', '\u93E1', '\u93E4', '\u93E5', '\u93E8', '\u9403', '\u9407', '\u9410', '\u9413', '\u9414', '\u9418', '\u9419', '\u941A', '\u9421', '\u942B', '\u9435', '\u9436', '\u9438', '\u943A', '\u9441', '\u9444', '\u9451', '\u9452', '\u9453', '\u945A', '\u945B', '\u945E', '\u9460', '\u9462', '\u946A',
            '\u9470', '\u9475', '\u9477', '\u947C', '\u947D', '\u947E', '\u947F', '\u9481', '\u9577', '\u9580', '\u9582', '\u9583', '\u9587', '\u9589', '\u958A', '\u958B', '\u958F', '\u9591', '\u9593', '\u9594', '\u9596', '\u9598', '\u9599', '\u95A0', '\u95A2', '\u95A3', '\u95A4', '\u95A5', '\u95A7', '\u95A8', '\u95AD', '\u95B2',
            '\u95B9', '\u95BB', '\u95BC', '\u95BE', '\u95C3', '\u95C7', '\u95CA', '\u95CC', '\u95CD', '\u95D4', '\u95D5', '\u95D6', '\u95D8', '\u95DC', '\u95E1', '\u95E2', '\u95E5', '\u961C', '\u9621', '\u9628', '\u962A', '\u962E', '\u962F', '\u9632', '\u963B', '\u963F', '\u9640', '\u9642', '\u9644', '\u964B', '\u964C', '\u964D',
            '\u964F', '\u9650', '\u965B', '\u965C', '\u965D', '\u965E', '\u965F', '\u9662', '\u9663', '\u9664', '\u9665', '\u9666', '\u966A', '\u966C', '\u9670', '\u9672', '\u9673', '\u9675', '\u9676', '\u9677', '\u9678', '\u967A', '\u967D', '\u9685', '\u9686', '\u9688', '\u968A', '\u968B', '\u968D', '\u968E', '\u968F', '\u9694',
            '\u9695', '\u9697', '\u9698', '\u9699', '\u969B', '\u969C', '\u96A0', '\u96A3', '\u96A7', '\u96A8', '\u96AA', '\u96B0', '\u96B1', '\u96B2', '\u96B4', '\u96B6', '\u96B7', '\u96B8', '\u96B9', '\u96BB', '\u96BC', '\u96C0', '\u96C1', '\u96C4', '\u96C5', '\u96C6', '\u96C7', '\u96C9', '\u96CB', '\u96CC', '\u96CD', '\u96CE',
            '\u96D1', '\u96D5', '\u96D6', '\u96D9', '\u96DB', '\u96DC', '\u96E2', '\u96E3', '\u96E8', '\u96EA', '\u96EB', '\u96F0', '\u96F2', '\u96F6', '\u96F7', '\u96F9', '\u96FB', '\u9700', '\u9704', '\u9706', '\u9707', '\u9708', '\u970A', '\u970D', '\u970E', '\u970F', '\u9711', '\u9713', '\u9716', '\u9719', '\u971C', '\u971E',
            '\u9724', '\u9727', '\u972A', '\u9730', '\u9732', '\u9738', '\u9739', '\u973D', '\u973E', '\u9742', '\u9744', '\u9746', '\u9748', '\u9749', '\u9752', '\u9756', '\u9759', '\u975C', '\u975E', '\u9760', '\u9761', '\u9762', '\u9764', '\u9766', '\u9768', '\u9769', '\u976B', '\u976D', '\u9771', '\u9774', '\u9779', '\u977A',
            '\u977C', '\u9781', '\u9784', '\u9785', '\u9786', '\u978B', '\u978D', '\u978F', '\u9790', '\u9798', '\u979C', '\u97A0', '\u97A3', '\u97A6', '\u97A8', '\u97AB', '\u97AD', '\u97B3', '\u97B4', '\u97C3', '\u97C6', '\u97C8', '\u97CB', '\u97D3', '\u97DC', '\u97ED', '\u97EE', '\u97F2', '\u97F3', '\u97F5', '\u97F6', '\u97FB',
            '\u97FF', '\u9801', '\u9802', '\u9803', '\u9805', '\u9806', '\u9808', '\u980C', '\u980F', '\u9810', '\u9811', '\u9812', '\u9813', '\u9817', '\u9818', '\u981A', '\u9821', '\u9824', '\u982C', '\u982D', '\u9834', '\u9837', '\u9838', '\u983B', '\u983C', '\u983D', '\u9846', '\u984B', '\u984C', '\u984D', '\u984E', '\u984F',
            '\u9854', '\u9855', '\u9858', '\u985B', '\u985E', '\u9867', '\u986B', '\u986F', '\u9870', '\u9871', '\u9873', '\u9874', '\u98A8', '\u98AA', '\u98AF', '\u98B1', '\u98B6', '\u98C3', '\u98C4', '\u98C6', '\u98DB', '\u98DC', '\u98DF', '\u98E2', '\u98E9', '\u98EB', '\u98ED', '\u98EE', '\u98EF', '\u98F2', '\u98F4', '\u98FC',
            '\u98FD', '\u98FE', '\u9903', '\u9905', '\u9909', '\u990A', '\u990C', '\u9910', '\u9912', '\u9913', '\u9914', '\u9918', '\u991D', '\u991E', '\u9920', '\u9921', '\u9924', '\u9928', '\u992C', '\u992E', '\u993D', '\u993E', '\u9942', '\u9945', '\u9949', '\u994B', '\u994C', '\u9950', '\u9951', '\u9952', '\u9955', '\u9957',
            '\u9996', '\u9997', '\u9998', '\u9999', '\u99A5', '\u99A8', '\u99AC', '\u99AD', '\u99AE', '\u99B3', '\u99B4', '\u99BC', '\u99C1', '\u99C4', '\u99C5', '\u99C6', '\u99C8', '\u99D0', '\u99D1', '\u99D2', '\u99D5', '\u99D8', '\u99DB', '\u99DD', '\u99DF', '\u99E2', '\u99ED', '\u99EE', '\u99F1', '\u99F2', '\u99F8', '\u99FB',
            '\u99FF', '\u9A01', '\u9A05', '\u9A0E', '\u9A0F', '\u9A12', '\u9A13', '\u9A19', '\u9A28', '\u9A2B', '\u9A30', '\u9A37', '\u9A3E', '\u9A40', '\u9A42', '\u9A43', '\u9A45', '\u9A4D', '\u9A55', '\u9A57', '\u9A5A', '\u9A5B', '\u9A5F', '\u9A62', '\u9A64', '\u9A65', '\u9A69', '\u9A6A', '\u9A6B', '\u9AA8', '\u9AAD', '\u9AB0',
            '\u9AB8', '\u9ABC', '\u9AC0', '\u9AC4', '\u9ACF', '\u9AD1', '\u9AD3', '\u9AD4', '\u9AD8', '\u9ADE', '\u9ADF', '\u9AE2', '\u9AE3', '\u9AE6', '\u9AEA', '\u9AEB', '\u9AED', '\u9AEE', '\u9AEF', '\u9AF1', '\u9AF4', '\u9AF7', '\u9AFB', '\u9B06', '\u9B18', '\u9B1A', '\u9B1F', '\u9B22', '\u9B23', '\u9B25', '\u9B27', '\u9B28',
            '\u9B29', '\u9B2A', '\u9B2E', '\u9B2F', '\u9B31', '\u9B32', '\u9B3B', '\u9B3C', '\u9B41', '\u9B42', '\u9B43', '\u9B44', '\u9B45', '\u9B4D', '\u9B4E', '\u9B4F', '\u9B51', '\u9B54', '\u9B58', '\u9B5A', '\u9B6F', '\u9B74', '\u9B83', '\u9B8E', '\u9B91', '\u9B92', '\u9B93', '\u9B96', '\u9B97', '\u9B9F', '\u9BA0', '\u9BA8',
            '\u9BAA', '\u9BAB', '\u9BAD', '\u9BAE', '\u9BB4', '\u9BB9', '\u9BC0', '\u9BC6', '\u9BC9', '\u9BCA', '\u9BCF', '\u9BD1', '\u9BD2', '\u9BD4', '\u9BD6', '\u9BDB', '\u9BE1', '\u9BE2', '\u9BE3', '\u9BE4', '\u9BE8', '\u9BF0', '\u9BF1', '\u9BF2', '\u9BF5', '\u9C04', '\u9C06', '\u9C08', '\u9C09', '\u9C0A', '\u9C0C', '\u9C0D',
            '\u9C10', '\u9C12', '\u9C13', '\u9C14', '\u9C15', '\u9C1B', '\u9C21', '\u9C24', '\u9C25', '\u9C2D', '\u9C2E', '\u9C2F', '\u9C30', '\u9C32', '\u9C39', '\u9C3A', '\u9C3B', '\u9C3E', '\u9C46', '\u9C47', '\u9C48', '\u9C52', '\u9C57', '\u9C5A', '\u9C60', '\u9C67', '\u9C76', '\u9C78', '\u9CE5', '\u9CE7', '\u9CE9', '\u9CEB',
            '\u9CEC', '\u9CF0', '\u9CF3', '\u9CF4', '\u9CF6', '\u9D03', '\u9D06', '\u9D07', '\u9D08', '\u9D09', '\u9D0E', '\u9D12', '\u9D15', '\u9D1B', '\u9D1F', '\u9D23', '\u9D26', '\u9D28', '\u9D2A', '\u9D2B', '\u9D2C', '\u9D3B', '\u9D3E', '\u9D3F', '\u9D41', '\u9D44', '\u9D46', '\u9D48', '\u9D50', '\u9D51', '\u9D59', '\u9D5C',
            '\u9D5D', '\u9D5E', '\u9D60', '\u9D61', '\u9D64', '\u9D6C', '\u9D6F', '\u9D72', '\u9D7A', '\u9D87', '\u9D89', '\u9D8F', '\u9D9A', '\u9DA4', '\u9DA9', '\u9DAB', '\u9DAF', '\u9DB2', '\u9DB4', '\u9DB8', '\u9DBA', '\u9DBB', '\u9DC1', '\u9DC2', '\u9DC4', '\u9DC6', '\u9DCF', '\u9DD3', '\u9DD9', '\u9DE6', '\u9DED', '\u9DEF',
            '\u9DF2', '\u9DF8', '\u9DF9', '\u9DFA', '\u9DFD', '\u9E1A', '\u9E1B', '\u9E1E', '\u9E75', '\u9E78', '\u9E79', '\u9E7D', '\u9E7F', '\u9E81', '\u9E88', '\u9E8B', '\u9E8C', '\u9E91', '\u9E92', '\u9E93', '\u9E95', '\u9E97', '\u9E9D', '\u9E9F', '\u9EA5', '\u9EA6', '\u9EA9', '\u9EAA', '\u9EAD', '\u9EB8', '\u9EB9', '\u9EBA',
            '\u9EBB', '\u9EBC', '\u9EBE', '\u9EBF', '\u9EC4', '\u9ECC', '\u9ECD', '\u9ECE', '\u9ECF', '\u9ED0', '\u9ED2', '\u9ED4', '\u9ED8', '\u9ED9', '\u9EDB', '\u9EDC', '\u9EDD', '\u9EDE', '\u9EE0', '\u9EE5', '\u9EE8', '\u9EEF', '\u9EF4', '\u9EF6', '\u9EF7', '\u9EF9', '\u9EFB', '\u9EFC', '\u9EFD', '\u9F07', '\u9F08', '\u9F0E',
            '\u9F13', '\u9F15', '\u9F20', '\u9F21', '\u9F2C', '\u9F3B', '\u9F3E', '\u9F4A', '\u9F4B', '\u9F4E', '\u9F4F', '\u9F52', '\u9F54', '\u9F5F', '\u9F60', '\u9F61', '\u9F62', '\u9F63', '\u9F66', '\u9F67', '\u9F6A', '\u9F6C', '\u9F72', '\u9F76', '\u9F77', '\u9F8D', '\u9F95', '\u9F9C', '\u9F9D', '\u9FA0', '\uF001', '\uF002',
            '\uFB01', '\uFB02', '\uFE30', '\uFE31', '\uFE32', '\uFE33', '\uFE35', '\uFE36', '\uFE37', '\uFE38', '\uFE39', '\uFE3A', '\uFE3B', '\uFE3C', '\uFE3D', '\uFE3E', '\uFE3F', '\uFE40', '\uFE41', '\uFE42', '\uFE43', '\uFE44', '\uFF01', '\uFF02', '\uFF03', '\uFF04', '\uFF05', '\uFF06', '\uFF07', '\uFF08', '\uFF09', '\uFF0A',
            '\uFF0B', '\uFF0C', '\uFF0D', '\uFF0E', '\uFF0F', '\uFF10', '\uFF11', '\uFF12', '\uFF13', '\uFF14', '\uFF15', '\uFF16', '\uFF17', '\uFF18', '\uFF19', '\uFF1A', '\uFF1B', '\uFF1C', '\uFF1D', '\uFF1E', '\uFF1F', '\uFF20', '\uFF21', '\uFF22', '\uFF23', '\uFF24', '\uFF25', '\uFF26', '\uFF27', '\uFF28', '\uFF29', '\uFF2A',
            '\uFF2B', '\uFF2C', '\uFF2D', '\uFF2E', '\uFF2F', '\uFF30', '\uFF31', '\uFF32', '\uFF33', '\uFF34', '\uFF35', '\uFF36', '\uFF37', '\uFF38', '\uFF39', '\uFF3A', '\uFF3B', '\uFF3C', '\uFF3D', '\uFF3E', '\uFF3F', '\uFF40', '\uFF41', '\uFF42', '\uFF43', '\uFF44', '\uFF45', '\uFF46', '\uFF47', '\uFF48', '\uFF49', '\uFF4A',
            '\uFF4B', '\uFF4C', '\uFF4D', '\uFF4E', '\uFF4F', '\uFF50', '\uFF51', '\uFF52', '\uFF53', '\uFF54', '\uFF55', '\uFF56', '\uFF57', '\uFF58', '\uFF59', '\uFF5A', '\uFF5B', '\uFF5C', '\uFF5D', '\uFF5E', '\uFF61', '\uFF62', '\uFF63', '\uFF64', '\uFF65', '\uFF66', '\uFF67', '\uFF68', '\uFF69', '\uFF6A', '\uFF6B', '\uFF6C',
            '\uFF6D', '\uFF6E', '\uFF6F', '\uFF70', '\uFF71', '\uFF72', '\uFF73', '\uFF74', '\uFF75', '\uFF76', '\uFF77', '\uFF78', '\uFF79', '\uFF7A', '\uFF7B', '\uFF7C', '\uFF7D', '\uFF7E', '\uFF7F', '\uFF80', '\uFF81', '\uFF82', '\uFF83', '\uFF84', '\uFF85', '\uFF86', '\uFF87', '\uFF88', '\uFF89', '\uFF8A', '\uFF8B', '\uFF8C',
            '\uFF8D', '\uFF8E', '\uFF8F', '\uFF90', '\uFF91', '\uFF92', '\uFF93', '\uFF94', '\uFF95', '\uFF96', '\uFF97', '\uFF98', '\uFF99', '\uFF9A', '\uFF9B', '\uFF9C', '\uFF9D', '\uFF9E', '\uFF9F', '\uFFE0', '\uFFE1', '\uFFE2', '\uFFE3', '\uFFE4', '\uFFE5', '\uFFE6'
        };

        public static bool IncludesUnsupportedCharacter(this string line)
        {
            if (line == null)
            {
                return false;
            }
            foreach (var c in line.ToCharArray())
            {
                if (Array.FindIndex(SupportedCharacters, x => x == c) < 0)
                {
                    return true;
                }
            }
            return false;
        }
    }
}
