﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "systemInitializer_WrapPublicKey.h"
#include "systemInitializer_CmacFile.h"

// Encrypted Key
const Key128 EncryptedKeyProd = {
{
    0x7C, 0x43, 0x03, 0xCA, 0x49, 0x65, 0xFB, 0x2B, 0x84, 0x4E, 0x1B, 0x0C, 0x87, 0xAF, 0x0B, 0x8F
}
};

const Key128 IvProd = {
{
    0x7B, 0xEF, 0x02, 0x44, 0xF0, 0x58, 0xE4, 0xEB, 0x87, 0xD4, 0x6E, 0x3E, 0xEF, 0x9A, 0xA9, 0xB5
}
};

// RSA2048 Public key for Prod
const Key2048 EncryptedWrapPublicKeyModulusProd = {
{
    0x7E, 0xFA, 0xF5, 0x8A, 0x39, 0xF7, 0x44, 0xBC, 0xD9, 0xF5, 0xD8, 0x40, 0x42, 0xFB, 0x52, 0x40,
    0x2B, 0xF0, 0xC2, 0x8D, 0x7D, 0x92, 0xA2, 0x68, 0x8C, 0xCB, 0xBE, 0xEB, 0x7B, 0x70, 0x37, 0x2F,
    0x86, 0x82, 0x9F, 0x45, 0xB7, 0x3C, 0x17, 0x6C, 0x14, 0x79, 0xB3, 0x51, 0xAC, 0x3A, 0xB0, 0xC9,
    0xCD, 0x0A, 0x6D, 0x45, 0x89, 0x6D, 0xFF, 0xDA, 0x06, 0xFE, 0x28, 0x02, 0x78, 0xEC, 0xEE, 0xDF,
    0x91, 0x6A, 0x32, 0x04, 0x7B, 0xD7, 0xBF, 0xFB, 0x5C, 0xAB, 0x5E, 0xB5, 0xB7, 0x84, 0xFD, 0x48,
    0xF0, 0xCB, 0xAE, 0xBD, 0x71, 0xE9, 0x5A, 0x72, 0xB3, 0x9F, 0x0F, 0x6E, 0x17, 0xE7, 0x92, 0xCC,
    0x07, 0xE7, 0xC1, 0x42, 0x6B, 0xBE, 0xFE, 0x41, 0xA8, 0x57, 0x41, 0x3D, 0xBC, 0x00, 0xF7, 0x3D,
    0xF6, 0x7C, 0xFF, 0x84, 0x95, 0xB0, 0xBA, 0xF5, 0xA9, 0xC9, 0x0C, 0xA0, 0xF9, 0x89, 0x73, 0xA5,
    0x24, 0xAF, 0x89, 0xC0, 0xCC, 0x90, 0x7A, 0x5B, 0xB3, 0x97, 0x9A, 0x62, 0x09, 0x7E, 0xE1, 0x77,
    0x0B, 0x19, 0x9D, 0x71, 0xA5, 0xFF, 0xE9, 0x85, 0x8F, 0x0A, 0xEB, 0xC1, 0x6F, 0x09, 0xB8, 0x94,
    0x4A, 0xDB, 0xA3, 0x86, 0x95, 0x19, 0x8D, 0x82, 0x6F, 0x2D, 0x6C, 0x27, 0x2B, 0x68, 0x98, 0x04,
    0x41, 0x17, 0x54, 0x1D, 0x7B, 0x28, 0x60, 0xD2, 0xCD, 0xE0, 0xD2, 0xFF, 0x7F, 0xE1, 0x77, 0x07,
    0x17, 0x52, 0xF4, 0x1A, 0x37, 0x88, 0xCF, 0xBC, 0x7C, 0x5D, 0x9E, 0x1F, 0x28, 0x4F, 0x7C, 0x85,
    0x3C, 0xC8, 0x45, 0x23, 0xBC, 0xBD, 0xD5, 0xD5, 0x8C, 0x17, 0x08, 0x53, 0xAF, 0x25, 0x4F, 0xCC,
    0x46, 0x99, 0x33, 0x93, 0x25, 0x56, 0x3F, 0x76, 0xB6, 0xE3, 0x94, 0xDA, 0xA1, 0x6F, 0xC1, 0xF3,
    0xD6, 0xA7, 0x77, 0x23, 0xB5, 0x10, 0xB1, 0x92, 0xF4, 0x52, 0x0C, 0xF6, 0x48, 0x62, 0x06, 0x3C,
}
};

const uint32_t WrapPublicKeyExponentProd = 0x01000100;

