﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/i2c/driver/i2c.h>

class PmicDriver
{
public:
    PmicDriver() NN_NOEXCEPT
    {
        nn::i2c::driver::Initialize();
        nn::i2c::driver::OpenSession(&m_I2cSession, nn::i2c::I2cDevice_Max77620Pmic);
    }

    ~PmicDriver() NN_NOEXCEPT
    {
        nn::i2c::driver::CloseSession(m_I2cSession);
        nn::i2c::driver::Finalize();
    }

    NN_NORETURN void ShutdownSystem() NN_NOEXCEPT;
    NN_NORETURN void RebootSystem() NN_NOEXCEPT;

private:
    NN_NORETURN void ShutdownSystem(bool isReset) NN_NOEXCEPT;

private:
    nn::i2c::driver::I2cSession m_I2cSession;
};
