﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "systemInitializer_Crc32.h"

Crc32::Crc32()
{
    InitializeTable(CRC32_STANDARD_POLY);
}

uint32_t Crc32::Calculate(const void* input, size_t length, uint32_t context)
{
    Crc32 c;
    c.InitializeContext(context);
    c.Update(input, length);
    return c.GetHash();
}

void Crc32::InitializeContext(uint32_t context)
{
    m_Context = context;
}

void Crc32::InitializeTable(uint32_t poly)
{
    uint32_t     r;
    uint32_t     i, j;
    uint32_t*    t = m_Table.table;

    for (i = 0; i < CRC_TABLE_SIZE; i++)
    {
        r = i;
        for (j = 0; j < 8; j++)
        {
            if (r & 1)
            {
                r = (r >> 1) ^ poly;
            }
            else
            {
                r >>= 1;
            }
        }
        t[i] = r;
    }
}

void Crc32::Update(const void* input, size_t length)
{
    uint32_t     r;
    uint32_t     i;
    const uint32_t* t = m_Table.table;
    uint8_t*     data = reinterpret_cast<uint8_t*>(const_cast<void*>(input));

    r = static_cast<uint32_t>(m_Context);
    for (i = 0; i < length; i++)
    {
        r = (r >> 8) ^ t[(r ^ *data) & 0xff];
        data++;
    }
    m_Context = static_cast<Context>(r);
}

uint32_t Crc32::GetHash()
{
    return ~static_cast<uint32_t>(m_Context);
}
