﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Abort.h>
#include <nn/os/os_Types.h>
#include <nn/ncm/ncm_ProgramLocation.h>

#include "pm_Start1st.h"
#include "pm_ProcessManager.h"

namespace nn { namespace pm {

    namespace
    {
        const ncm::ProgramId FirstProgramId = { 0x0100000000000008ull };
    }

    void Start1st()
    {
        os::ProcessId processId;

        auto location = ncm::MakeProgramLocation(ncm::StorageId::BuildInSystem, FirstProgramId);

        Result result = ProcessManager::GetInstance()->LaunchProgram(&processId, location, 0);
        NN_UNUSED(result);

        if( result.IsFailure() )
        {
            NN_SDK_LOG("[pm] 1st program (%08llx) launch failed. (%08x)\n",
                FirstProgramId.value,
                result.GetInnerValueForDebug());
        }
    }

}}  // namespace nn::pm

