﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Base.h>
#include <nn/os/os_Thread.h>
#include <nn/dt/detail/dt_Log.h>

#include "dt_StartServer.h"

extern "C" void nninitStartup()
{
}

extern "C" void nninitInitializeSdkModule()
{
}

extern "C" void nninitFinalizeSdkModule()
{
}

extern "C" void nnMain() NN_NOEXCEPT
{
#if defined(NN_BUILD_CONFIG_HARDWARE_NX)
    NN_DETAIL_DT_WARN("dt (DeviceTree) process on NX is FOR EVALUATION PURPOSES ONLY.\n");
    NN_DETAIL_DT_WARN("If you see this message on production firmware, please immediately contact Kohei Ozeki <ozeki_kohei@nintendo.co.jp>\n");
#endif

    nn::dt::InitializeServer();
    nn::dt::StartServer();

    while (true)
    {
        nn::os::SleepThread(nn::TimeSpan::FromSeconds(1000));
    }
}
