﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/tsc/tsc_Types.h>
#include <nn/tsc/tsc_ConfigContexts.h>
#include <nn/tsc/tsc_ActiveConfigContext.h>

#include "tsc_TcpipStackConfigBase.h"

#if defined(NN_SDK_BUILD_DEBUG) || defined(NN_SDK_BUILD_DEVELOP)
#define NN_TSC_DEBUG_ABORT(...) NN_ABORT(__VA_ARGS__)
#else
#define NN_TSC_DEBUG_ABORT(...) static_cast<void>(0)
#endif

#define NN_TSC_ASSERT_AND_RETURN_ERROR(CONDITION, RESULT, ...) \
    do \
    { \
        if (!(CONDITION)) \
        { \
            NN_TSC_DEBUG_ABORT(__VA_ARGS__); \
            return RESULT; \
        } \
    } while (NN_STATIC_CONDITION(0))

namespace nn { namespace tsc { namespace detail {

class TcpIpStackConfigBsd : public TcpIpStackConfigBase
{

public:
    TcpIpStackConfigBsd()
    {
    }
    virtual ~TcpIpStackConfigBsd()
    {
    }

    Result Initialize() override;
    Result Finalize() override;

    Result ApplyIpConfig(Ipv4ConfigContext* pInContext, int modeMask) override;
    Result CleanupConfigContext(const Ipv4ConfigContext* pInContext) override;
    Result CancelApplyIpConfig() override;
    Result CheckDuplicateIp(int msecTimeout) override;
    Result NotifyInterfaceDown(const char* pInInterfaceName) override;
    Result GetInterfaceStatistics(const char* pInInterfaceName, ActiveConfigContext::InterfaceStatistics* pOutStats) override;

    Result GetActiveInterfaceAddress(const char* pInInterfaceName, Ipv4AddrStorage* pOutAddress) override;
    Result GetActiveSubnetMask(const char* pInInterfaceName, Ipv4AddrStorage* pOutAddress) override;
    Result GetActiveDefaultGateway(const char* pInInterfaceName, Ipv4AddrStorage* pOutAddress) override;
    Result GetActivePreferredDns(const char* pInInterfaceName, Ipv4AddrStorage* pOutAddress) override;
    Result GetActiveAlternativeDns(const char* pInInterfaceName, Ipv4AddrStorage* pOutAddress) override;
    Result GetActiveMtu(const char* pInInterfaceName, uint32_t* pOutMtuValue) override;
};

nn::Result ConvertErrorFromBsdcfgToTsc(nn::Result bsdCfgResult);

}}}
