﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// このファイルはユーザ定義

#include <nn/tma/detail/hio_ServiceName.h>

#include <mutex>
#include <nn/os/os_Mutex.h>
#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include "tma_FileManagerByHipc.h"

namespace nn { namespace tma {

namespace {

// 拡張ヒープを使用したアロケータを、HIPC プロキシ用に準備
struct CreateFileManagerByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreateFileManagerByHipcTag> MyAllocator;

// MyAllocator を静的コンストラクタで初期化するためのヘルパー
class MyAllocatorInitializer
{
public:

    MyAllocatorInitializer() NN_NOEXCEPT
    {
        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }

} g_MyAllocatorInitializer;

nn::tma::IFileManager* g_FileManager;
nn::os::Mutex g_FileManagerMutex(false);

nn::sf::HipcSimpleClientSessionManager& GetClientManager() NN_NOEXCEPT
{
    NN_FUNCTION_LOCAL_STATIC(nn::sf::HipcSimpleClientSessionManager, s_ClientManager);
    return s_ClientManager;
}

}

nn::sf::SharedPointer<IFileManager> CreateFileManagerByHipc() NN_NOEXCEPT
{
    std::lock_guard<nn::os::Mutex> scopedLock(g_FileManagerMutex);
    if (!g_FileManager)
    {
        nn::sf::SharedPointer<IFileManager> fileManager;
        auto result = GetClientManager().InitializeByName<IFileManager, MyAllocator::Policy>(&fileManager, detail::FileIoServiceName);
        NN_ABORT_UNLESS(result.IsSuccess());
        const int SessionCount = 3;
        GetClientManager().SetSessionCount(SessionCount);
        g_FileManager = fileManager.Detach();
    }
    return nn::sf::SharedPointer<IFileManager>(g_FileManager, false);
}

void DeleteFileManagerByHipc() NN_NOEXCEPT
{
    std::lock_guard<nn::os::Mutex> scopedLock(g_FileManagerMutex);
    g_FileManager = nullptr;
    GetClientManager().Finalize();
}

}}
