﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;

namespace nn.tma
{
    [CppRefPath(@"<nn/tma/tma_ITmaManager.h>")]
    public struct ChannelName
    {
        [FixedArray(16)]
        public char_t[]     channelName;
    }

    [CppRefPath(@"<nn/tma/tma_ITmaManager.h>")]
    public interface ITmaManager : IServiceObject
    {
        [MethodId(0)]
        Result CreateChannel        ( Out<ITmaChannel>       handle,
                                      ChannelName            channelName,
                                      std.int32_t            priority );
    }

    [CppRefPath(@"<nn/tma/tma_ITmaManager.h>")]
    public interface ITmaChannel : IServiceObject
    {
        [MethodId(0)]
        Result WaitForConnection    ( std.int32_t            timeout );

        [MethodId(1)]
        Result Send                 ( nn.sf.InBuffer         pData );

        [MethodId(2)]
        Result Receive              ( nn.sf.OutBuffer        pBuffer );

        [MethodId(3)]
        Result SetPriority          ( std.int32_t            priority );

        [MethodId(4)]
        Result GetPriority          ( nn.sf.Out<std.int32_t> outPriority );

    }
}
