﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  ホストターゲット間通信 API
*/

#include <nn/os.h>
#include <nn/socket/socket_Api.h>
#include <nn/nn_Assert.h>
#include <nn/tics/tics_Api.h>
#include <nn/tics/tics_Config.h>

#include "HotBridgeAPI.h"

//--------------------------------------------------------------------------
//  C++ 向けの宣言
//--------------------------------------------------------------------------
namespace nn { namespace tics {

    uintptr_t g_MemoryPoolAddress = 0;

    void Initialize(uintptr_t heapAddr, size_t heapSize)
    {
#ifdef NN_HTC_USE_SOCKET0
        Result result = nn::os::AllocateMemoryBlock(&g_MemoryPoolAddress, nn::socket::DefaultSocketMemoryPoolSize);
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);

        nn::socket::Initialize(
            reinterpret_cast<void*>(g_MemoryPoolAddress),
            nn::socket::DefaultSocketMemoryPoolSize,
            nn::socket::DefaultSocketAllocatorSize,
            nn::socket::DefaultConcurrencyLimit);
#endif
#if defined(NN_NINTENDO_SDK)
        ::tics::Initialize(heapAddr, heapSize);
#endif
    }

    void Finalize()
    {
        // TODO: tics::Finalize() を実装して呼び出す。

#ifdef NN_HTC_USE_SOCKET0
        nn::socket::Finalize();

        if (g_MemoryPoolAddress != 0)
        {
            nn::os::FreeMemoryBlock(g_MemoryPoolAddress, nn::socket::DefaultSocketMemoryPoolSize);
            g_MemoryPoolAddress = 0;
        }
#endif
    }
}}
