﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * このファイルを編集しないでください。
 * このファイルは自動生成されます。
 */

#include <nn/svc/svc_BaseId.autogen.h>


//-------------------------------------------------
// Result SetHeapSize(uintptr_t* pOut, size_t size)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0  ref  4 pOut     
//     Register 1       4 size     Register 1       4 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch328profiler11SetHeapSizeEPjj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler11SetHeapSizeEPjj
    .hidden  _ZN2nn3svc7aarch328profiler11SetHeapSizeEPjj
    .type    _ZN2nn3svc7aarch328profiler11SetHeapSizeEPjj, %function
_ZN2nn3svc7aarch328profiler11SetHeapSizeEPjj:

    push     {r0}

    svc      #NN_SVC_ID_SET_HEAP_SIZE

    ldr      r2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch328profiler11SetHeapSizeEPjj, [.-_ZN2nn3svc7aarch328profiler11SetHeapSizeEPjj]


//-------------------------------------------------
// Result SetMemoryPermission(uintptr_t addr, size_t size, nn::svc::MemoryPermission permission)
//
//     AArch32 s=4 r=4 p=4             Invariant s=4 r=8 p=4
// in  abi                             svc
//     Register 0       4 addr         Register 0       4 addr
//     Register 1       4 size         Register 1       4 size
//     Register 2       4 permission   Register 2       4 permission
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler19SetMemoryPermissionEjjNS0_16MemoryPermissionE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler19SetMemoryPermissionEjjNS0_16MemoryPermissionE
    .hidden  _ZN2nn3svc7aarch328profiler19SetMemoryPermissionEjjNS0_16MemoryPermissionE
    .type    _ZN2nn3svc7aarch328profiler19SetMemoryPermissionEjjNS0_16MemoryPermissionE, %function
_ZN2nn3svc7aarch328profiler19SetMemoryPermissionEjjNS0_16MemoryPermissionE:

    svc      #NN_SVC_ID_SET_MEMORY_PERMISSION
    bx       lr

    .size _ZN2nn3svc7aarch328profiler19SetMemoryPermissionEjjNS0_16MemoryPermissionE, [.-_ZN2nn3svc7aarch328profiler19SetMemoryPermissionEjjNS0_16MemoryPermissionE]


//-------------------------------------------------
// Result SetMemoryAttribute(uintptr_t addr, size_t size, nn::Bit32 mask, nn::Bit32 attribute)
//
//     AArch32 s=4 r=4 p=4            Invariant s=4 r=8 p=4
// in  abi                            svc
//     Register 0       4 addr        Register 0       4 addr
//     Register 1       4 size        Register 1       4 size
//     Register 2       4 mask        Register 2       4 mask
//     Register 3       4 attribute   Register 3       4 attribute
//
// out abi                            svc
//     Register 0       4 return      Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler18SetMemoryAttributeEjjjj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler18SetMemoryAttributeEjjjj
    .hidden  _ZN2nn3svc7aarch328profiler18SetMemoryAttributeEjjjj
    .type    _ZN2nn3svc7aarch328profiler18SetMemoryAttributeEjjjj, %function
_ZN2nn3svc7aarch328profiler18SetMemoryAttributeEjjjj:

    svc      #NN_SVC_ID_SET_MEMORY_ATTRIBUTE
    bx       lr

    .size _ZN2nn3svc7aarch328profiler18SetMemoryAttributeEjjjj, [.-_ZN2nn3svc7aarch328profiler18SetMemoryAttributeEjjjj]


//-------------------------------------------------
// Result MapMemory(uintptr_t toAddr, uintptr_t fromAddr, size_t size)
//
//     AArch32 s=4 r=4 p=4           Invariant s=4 r=8 p=4
// in  abi                           svc
//     Register 0       4 toAddr     Register 0       4 toAddr
//     Register 1       4 fromAddr   Register 1       4 fromAddr
//     Register 2       4 size       Register 2       4 size
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler9MapMemoryEjjj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler9MapMemoryEjjj
    .hidden  _ZN2nn3svc7aarch328profiler9MapMemoryEjjj
    .type    _ZN2nn3svc7aarch328profiler9MapMemoryEjjj, %function
_ZN2nn3svc7aarch328profiler9MapMemoryEjjj:

    svc      #NN_SVC_ID_MAP_MEMORY
    bx       lr

    .size _ZN2nn3svc7aarch328profiler9MapMemoryEjjj, [.-_ZN2nn3svc7aarch328profiler9MapMemoryEjjj]


//-------------------------------------------------
// Result UnmapMemory(uintptr_t toAddr, uintptr_t fromAddr, size_t size)
//
//     AArch32 s=4 r=4 p=4           Invariant s=4 r=8 p=4
// in  abi                           svc
//     Register 0       4 toAddr     Register 0       4 toAddr
//     Register 1       4 fromAddr   Register 1       4 fromAddr
//     Register 2       4 size       Register 2       4 size
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler11UnmapMemoryEjjj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler11UnmapMemoryEjjj
    .hidden  _ZN2nn3svc7aarch328profiler11UnmapMemoryEjjj
    .type    _ZN2nn3svc7aarch328profiler11UnmapMemoryEjjj, %function
_ZN2nn3svc7aarch328profiler11UnmapMemoryEjjj:

    svc      #NN_SVC_ID_UNMAP_MEMORY
    bx       lr

    .size _ZN2nn3svc7aarch328profiler11UnmapMemoryEjjj, [.-_ZN2nn3svc7aarch328profiler11UnmapMemoryEjjj]


//-------------------------------------------------
// Result QueryMemory(nn::svc::ilp32::MemoryInfo* pBlockInfo, nn::svc::PageInfo* pPageInfo, uintptr_t addr)
//
//     AArch32 s=4 r=4 p=4             Invariant s=4 r=8 p=4
// in  abi                             svc
//     Register 0  ref 40 pBlockInfo   Register 0  ref 40 pBlockInfo
//     Register 1  ref  4 pPageInfo    
//     Register 2       4 addr         Register 2       4 addr
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//                                     Register 1       4 pPageInfo
//
// conversion
//   Scatter         pPageInfo

    .section .text._ZN2nn3svc7aarch328profiler11QueryMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoEj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler11QueryMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoEj
    .hidden  _ZN2nn3svc7aarch328profiler11QueryMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoEj
    .type    _ZN2nn3svc7aarch328profiler11QueryMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoEj, %function
_ZN2nn3svc7aarch328profiler11QueryMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoEj:

    push     {r1}

    svc      #NN_SVC_ID_QUERY_MEMORY

    ldr      r2, [sp, #0]              // pPageInfoのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pPageInfo の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch328profiler11QueryMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoEj, [.-_ZN2nn3svc7aarch328profiler11QueryMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoEj]


//-------------------------------------------------
// void ExitProcess()
//
//     AArch32 s=4 r=4 p=4   Invariant s=4 r=8 p=4
// in  abi   svc
//
// out abi   svc
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler11ExitProcessEv, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler11ExitProcessEv
    .hidden  _ZN2nn3svc7aarch328profiler11ExitProcessEv
    .type    _ZN2nn3svc7aarch328profiler11ExitProcessEv, %function
_ZN2nn3svc7aarch328profiler11ExitProcessEv:

    svc      #NN_SVC_ID_EXIT_PROCESS
    bx       lr

    .size _ZN2nn3svc7aarch328profiler11ExitProcessEv, [.-_ZN2nn3svc7aarch328profiler11ExitProcessEv]


//-------------------------------------------------
// Result CreateThread(nn::svc::Handle* pOut, nn::svc::ilp32::ThreadFunc f, uintptr_t param, uintptr_t stackBottom, int32_t priority, int32_t idealCore)
//
//     AArch32 s=4 r=4 p=4              Invariant s=4 r=8 p=4
// in  abi                              svc
//     Register 0  ref  4 pOut          Register 0       4 priority
//     Register 1       4 f             Register 1       4 f
//     Register 2       4 param         Register 2       4 param
//     Register 3       4 stackBottom   Register 3       4 stackBottom
//                                      Register 4       4 idealCore
//     Stack    0       4 priority      
//     Stack    1       4 idealCore     
//
// out abi                              svc
//     Register 0       4 return        Register 0       4 return
//                                      Register 1       4 pOut
//
// conversion
//   Load            priority
//   Load            idealCore
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch328profiler12CreateThreadEPNS0_6HandleEjjjii, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler12CreateThreadEPNS0_6HandleEjjjii
    .hidden  _ZN2nn3svc7aarch328profiler12CreateThreadEPNS0_6HandleEjjjii
    .type    _ZN2nn3svc7aarch328profiler12CreateThreadEPNS0_6HandleEjjjii, %function
_ZN2nn3svc7aarch328profiler12CreateThreadEPNS0_6HandleEjjjii:

    push     {r0,r4}

    ldr      r0, [sp, #8]              // priority の値 をスタックからレジスタへ
    ldr      r4, [sp, #12]             // idealCore の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_CREATE_THREAD

    ldr      r2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    pop      {r4}
    bx       lr

    .size _ZN2nn3svc7aarch328profiler12CreateThreadEPNS0_6HandleEjjjii, [.-_ZN2nn3svc7aarch328profiler12CreateThreadEPNS0_6HandleEjjjii]


//-------------------------------------------------
// Result StartThread(nn::svc::Handle thread)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0       4 thread   Register 0       4 thread
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler11StartThreadENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler11StartThreadENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch328profiler11StartThreadENS0_6HandleE
    .type    _ZN2nn3svc7aarch328profiler11StartThreadENS0_6HandleE, %function
_ZN2nn3svc7aarch328profiler11StartThreadENS0_6HandleE:

    svc      #NN_SVC_ID_START_THREAD
    bx       lr

    .size _ZN2nn3svc7aarch328profiler11StartThreadENS0_6HandleE, [.-_ZN2nn3svc7aarch328profiler11StartThreadENS0_6HandleE]


//-------------------------------------------------
// void ExitThread()
//
//     AArch32 s=4 r=4 p=4   Invariant s=4 r=8 p=4
// in  abi   svc
//
// out abi   svc
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler10ExitThreadEv, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler10ExitThreadEv
    .hidden  _ZN2nn3svc7aarch328profiler10ExitThreadEv
    .type    _ZN2nn3svc7aarch328profiler10ExitThreadEv, %function
_ZN2nn3svc7aarch328profiler10ExitThreadEv:

    svc      #NN_SVC_ID_EXIT_THREAD
    bx       lr

    .size _ZN2nn3svc7aarch328profiler10ExitThreadEv, [.-_ZN2nn3svc7aarch328profiler10ExitThreadEv]


//-------------------------------------------------
// void SleepThread(int64_t ns)
//
//     AArch32 s=4 r=4 p=4     Invariant s=4 r=8 p=4
// in  abi                     svc
//     Register 0       8 ns   Register 0       8 ns
//     Register 1       8 ns   Register 1       8 ns
//
// out abi                     svc
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler11SleepThreadEx, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler11SleepThreadEx
    .hidden  _ZN2nn3svc7aarch328profiler11SleepThreadEx
    .type    _ZN2nn3svc7aarch328profiler11SleepThreadEx, %function
_ZN2nn3svc7aarch328profiler11SleepThreadEx:

    svc      #NN_SVC_ID_SLEEP_THREAD
    bx       lr

    .size _ZN2nn3svc7aarch328profiler11SleepThreadEx, [.-_ZN2nn3svc7aarch328profiler11SleepThreadEx]


//-------------------------------------------------
// Result GetThreadPriority(int32_t* pOut, nn::svc::Handle thread)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0  ref  4 pOut     
//     Register 1       4 thread   Register 1       4 thread
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch328profiler17GetThreadPriorityEPiNS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler17GetThreadPriorityEPiNS0_6HandleE
    .hidden  _ZN2nn3svc7aarch328profiler17GetThreadPriorityEPiNS0_6HandleE
    .type    _ZN2nn3svc7aarch328profiler17GetThreadPriorityEPiNS0_6HandleE, %function
_ZN2nn3svc7aarch328profiler17GetThreadPriorityEPiNS0_6HandleE:

    push     {r0}

    svc      #NN_SVC_ID_GET_THREAD_PRIORITY

    ldr      r2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch328profiler17GetThreadPriorityEPiNS0_6HandleE, [.-_ZN2nn3svc7aarch328profiler17GetThreadPriorityEPiNS0_6HandleE]


//-------------------------------------------------
// Result SetThreadPriority(nn::svc::Handle thread, int32_t priority)
//
//     AArch32 s=4 r=4 p=4           Invariant s=4 r=8 p=4
// in  abi                           svc
//     Register 0       4 thread     Register 0       4 thread
//     Register 1       4 priority   Register 1       4 priority
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler17SetThreadPriorityENS0_6HandleEi, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler17SetThreadPriorityENS0_6HandleEi
    .hidden  _ZN2nn3svc7aarch328profiler17SetThreadPriorityENS0_6HandleEi
    .type    _ZN2nn3svc7aarch328profiler17SetThreadPriorityENS0_6HandleEi, %function
_ZN2nn3svc7aarch328profiler17SetThreadPriorityENS0_6HandleEi:

    svc      #NN_SVC_ID_SET_THREAD_PRIORITY
    bx       lr

    .size _ZN2nn3svc7aarch328profiler17SetThreadPriorityENS0_6HandleEi, [.-_ZN2nn3svc7aarch328profiler17SetThreadPriorityENS0_6HandleEi]


//-------------------------------------------------
// Result GetThreadCoreMask(int32_t* pIdealCore, nn::Bit64* pAffinityMask, nn::svc::Handle thread)
//
//     AArch32 s=4 r=4 p=4                Invariant s=4 r=8 p=4
// in  abi                                svc
//     Register 0  ref  4 pIdealCore      
//     Register 1  ref  8 pAffinityMask   
//     Register 2       4 thread          Register 2       4 thread
//
// out abi                                svc
//     Register 0       4 return          Register 0       4 return
//                                        Register 1       4 pIdealCore
//                                        Register 2       8 pAffinityMask
//                                        Register 3       8 pAffinityMask
//
// conversion
//   Scatter         pIdealCore
//   Scatter         pAffinityMask

    .section .text._ZN2nn3svc7aarch328profiler17GetThreadCoreMaskEPiPyNS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler17GetThreadCoreMaskEPiPyNS0_6HandleE
    .hidden  _ZN2nn3svc7aarch328profiler17GetThreadCoreMaskEPiPyNS0_6HandleE
    .type    _ZN2nn3svc7aarch328profiler17GetThreadCoreMaskEPiPyNS0_6HandleE, %function
_ZN2nn3svc7aarch328profiler17GetThreadCoreMaskEPiPyNS0_6HandleE:

    push     {r0,r1,r4}

    svc      #NN_SVC_ID_GET_THREAD_CORE_MASK

    ldr      r4, [sp, #0]              // pIdealCoreのアドレス をスタックからレジスタへ
    str      r1, [r4, #0]              // pIdealCore の第 1 ワードをレジスタからメモリへ
    ldr      r4, [sp, #4]              // pAffinityMaskのアドレス をスタックからレジスタへ
    str      r2, [r4, #0]              // pAffinityMask の第 1 ワードをレジスタからメモリへ
    str      r3, [r4, #4]              // pAffinityMask の第 2 ワードをレジスタからメモリへ

    add      sp, sp, #8
    pop      {r4}
    bx       lr

    .size _ZN2nn3svc7aarch328profiler17GetThreadCoreMaskEPiPyNS0_6HandleE, [.-_ZN2nn3svc7aarch328profiler17GetThreadCoreMaskEPiPyNS0_6HandleE]


//-------------------------------------------------
// Result SetThreadCoreMask(nn::svc::Handle thread, int32_t idealCore, nn::Bit64 affinityMask)
//
//     AArch32 s=4 r=4 p=4               Invariant s=4 r=8 p=4
// in  abi                               svc
//     Register 0       4 thread         Register 0       4 thread
//     Register 1       4 idealCore      Register 1       4 idealCore
//     Register 2       8 affinityMask   Register 2       8 affinityMask
//     Register 3       8 affinityMask   Register 3       8 affinityMask
//
// out abi                               svc
//     Register 0       4 return         Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler17SetThreadCoreMaskENS0_6HandleEiy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler17SetThreadCoreMaskENS0_6HandleEiy
    .hidden  _ZN2nn3svc7aarch328profiler17SetThreadCoreMaskENS0_6HandleEiy
    .type    _ZN2nn3svc7aarch328profiler17SetThreadCoreMaskENS0_6HandleEiy, %function
_ZN2nn3svc7aarch328profiler17SetThreadCoreMaskENS0_6HandleEiy:

    svc      #NN_SVC_ID_SET_THREAD_CORE_MASK
    bx       lr

    .size _ZN2nn3svc7aarch328profiler17SetThreadCoreMaskENS0_6HandleEiy, [.-_ZN2nn3svc7aarch328profiler17SetThreadCoreMaskENS0_6HandleEiy]


//-------------------------------------------------
// int32_t GetCurrentProcessorNumber()
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler25GetCurrentProcessorNumberEv, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler25GetCurrentProcessorNumberEv
    .hidden  _ZN2nn3svc7aarch328profiler25GetCurrentProcessorNumberEv
    .type    _ZN2nn3svc7aarch328profiler25GetCurrentProcessorNumberEv, %function
_ZN2nn3svc7aarch328profiler25GetCurrentProcessorNumberEv:

    svc      #NN_SVC_ID_GET_CURRENT_PROCESSOR_NUMBER
    bx       lr

    .size _ZN2nn3svc7aarch328profiler25GetCurrentProcessorNumberEv, [.-_ZN2nn3svc7aarch328profiler25GetCurrentProcessorNumberEv]


//-------------------------------------------------
// Result SignalEvent(nn::svc::Handle event)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0       4 event    Register 0       4 event
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler11SignalEventENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler11SignalEventENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch328profiler11SignalEventENS0_6HandleE
    .type    _ZN2nn3svc7aarch328profiler11SignalEventENS0_6HandleE, %function
_ZN2nn3svc7aarch328profiler11SignalEventENS0_6HandleE:

    svc      #NN_SVC_ID_SIGNAL_EVENT
    bx       lr

    .size _ZN2nn3svc7aarch328profiler11SignalEventENS0_6HandleE, [.-_ZN2nn3svc7aarch328profiler11SignalEventENS0_6HandleE]


//-------------------------------------------------
// Result ClearEvent(nn::svc::Handle event)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0       4 event    Register 0       4 event
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler10ClearEventENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler10ClearEventENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch328profiler10ClearEventENS0_6HandleE
    .type    _ZN2nn3svc7aarch328profiler10ClearEventENS0_6HandleE, %function
_ZN2nn3svc7aarch328profiler10ClearEventENS0_6HandleE:

    svc      #NN_SVC_ID_CLEAR_EVENT
    bx       lr

    .size _ZN2nn3svc7aarch328profiler10ClearEventENS0_6HandleE, [.-_ZN2nn3svc7aarch328profiler10ClearEventENS0_6HandleE]


//-------------------------------------------------
// Result MapSharedMemory(nn::svc::Handle handle, uintptr_t addr, size_t size, nn::svc::MemoryPermission myPermission)
//
//     AArch32 s=4 r=4 p=4               Invariant s=4 r=8 p=4
// in  abi                               svc
//     Register 0       4 handle         Register 0       4 handle
//     Register 1       4 addr           Register 1       4 addr
//     Register 2       4 size           Register 2       4 size
//     Register 3       4 myPermission   Register 3       4 myPermission
//
// out abi                               svc
//     Register 0       4 return         Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler15MapSharedMemoryENS0_6HandleEjjNS0_16MemoryPermissionE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler15MapSharedMemoryENS0_6HandleEjjNS0_16MemoryPermissionE
    .hidden  _ZN2nn3svc7aarch328profiler15MapSharedMemoryENS0_6HandleEjjNS0_16MemoryPermissionE
    .type    _ZN2nn3svc7aarch328profiler15MapSharedMemoryENS0_6HandleEjjNS0_16MemoryPermissionE, %function
_ZN2nn3svc7aarch328profiler15MapSharedMemoryENS0_6HandleEjjNS0_16MemoryPermissionE:

    svc      #NN_SVC_ID_MAP_SHARED_MEMORY
    bx       lr

    .size _ZN2nn3svc7aarch328profiler15MapSharedMemoryENS0_6HandleEjjNS0_16MemoryPermissionE, [.-_ZN2nn3svc7aarch328profiler15MapSharedMemoryENS0_6HandleEjjNS0_16MemoryPermissionE]


//-------------------------------------------------
// Result UnmapSharedMemory(nn::svc::Handle handle, uintptr_t addr, size_t size)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0       4 handle   Register 0       4 handle
//     Register 1       4 addr     Register 1       4 addr
//     Register 2       4 size     Register 2       4 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler17UnmapSharedMemoryENS0_6HandleEjj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler17UnmapSharedMemoryENS0_6HandleEjj
    .hidden  _ZN2nn3svc7aarch328profiler17UnmapSharedMemoryENS0_6HandleEjj
    .type    _ZN2nn3svc7aarch328profiler17UnmapSharedMemoryENS0_6HandleEjj, %function
_ZN2nn3svc7aarch328profiler17UnmapSharedMemoryENS0_6HandleEjj:

    svc      #NN_SVC_ID_UNMAP_SHARED_MEMORY
    bx       lr

    .size _ZN2nn3svc7aarch328profiler17UnmapSharedMemoryENS0_6HandleEjj, [.-_ZN2nn3svc7aarch328profiler17UnmapSharedMemoryENS0_6HandleEjj]


//-------------------------------------------------
// Result CreateTransferMemory(nn::svc::Handle* pOut, uintptr_t addr, size_t size, nn::svc::MemoryPermission myPermission)
//
//     AArch32 s=4 r=4 p=4               Invariant s=4 r=8 p=4
// in  abi                               svc
//     Register 0  ref  4 pOut           
//     Register 1       4 addr           Register 1       4 addr
//     Register 2       4 size           Register 2       4 size
//     Register 3       4 myPermission   Register 3       4 myPermission
//
// out abi                               svc
//     Register 0       4 return         Register 0       4 return
//                                       Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch328profiler20CreateTransferMemoryEPNS0_6HandleEjjNS0_16MemoryPermissionE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler20CreateTransferMemoryEPNS0_6HandleEjjNS0_16MemoryPermissionE
    .hidden  _ZN2nn3svc7aarch328profiler20CreateTransferMemoryEPNS0_6HandleEjjNS0_16MemoryPermissionE
    .type    _ZN2nn3svc7aarch328profiler20CreateTransferMemoryEPNS0_6HandleEjjNS0_16MemoryPermissionE, %function
_ZN2nn3svc7aarch328profiler20CreateTransferMemoryEPNS0_6HandleEjjNS0_16MemoryPermissionE:

    push     {r0}

    svc      #NN_SVC_ID_CREATE_TRANSFER_MEMORY

    ldr      r2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch328profiler20CreateTransferMemoryEPNS0_6HandleEjjNS0_16MemoryPermissionE, [.-_ZN2nn3svc7aarch328profiler20CreateTransferMemoryEPNS0_6HandleEjjNS0_16MemoryPermissionE]


//-------------------------------------------------
// Result CloseHandle(nn::svc::Handle handle)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0       4 handle   Register 0       4 handle
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler11CloseHandleENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler11CloseHandleENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch328profiler11CloseHandleENS0_6HandleE
    .type    _ZN2nn3svc7aarch328profiler11CloseHandleENS0_6HandleE, %function
_ZN2nn3svc7aarch328profiler11CloseHandleENS0_6HandleE:

    svc      #NN_SVC_ID_CLOSE_HANDLE
    bx       lr

    .size _ZN2nn3svc7aarch328profiler11CloseHandleENS0_6HandleE, [.-_ZN2nn3svc7aarch328profiler11CloseHandleENS0_6HandleE]


//-------------------------------------------------
// Result ResetSignal(nn::svc::Handle handle)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0       4 handle   Register 0       4 handle
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler11ResetSignalENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler11ResetSignalENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch328profiler11ResetSignalENS0_6HandleE
    .type    _ZN2nn3svc7aarch328profiler11ResetSignalENS0_6HandleE, %function
_ZN2nn3svc7aarch328profiler11ResetSignalENS0_6HandleE:

    svc      #NN_SVC_ID_RESET_SIGNAL
    bx       lr

    .size _ZN2nn3svc7aarch328profiler11ResetSignalENS0_6HandleE, [.-_ZN2nn3svc7aarch328profiler11ResetSignalENS0_6HandleE]


//-------------------------------------------------
// Result WaitSynchronization(int32_t* pOut, const nn::svc::Handle handles[], int32_t numHandles, int64_t ns)
//
//     AArch32 s=4 r=4 p=4             Invariant s=4 r=8 p=4
// in  abi                             svc
//     Register 0  ref  4 pOut         Register 0       8 ns
//     Register 1  ref -- handles      Register 1  ref -- handles
//     Register 2       4 numHandles   Register 2       4 numHandles
//                                     Register 3       8 ns
//     Stack    0       8 ns           
//     Stack    1       8 ns           
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//                                     Register 1       4 pOut
//
// conversion
//   Load            ns
//   Load            ns
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch328profiler19WaitSynchronizationEPiPKNS0_6HandleEix, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler19WaitSynchronizationEPiPKNS0_6HandleEix
    .hidden  _ZN2nn3svc7aarch328profiler19WaitSynchronizationEPiPKNS0_6HandleEix
    .type    _ZN2nn3svc7aarch328profiler19WaitSynchronizationEPiPKNS0_6HandleEix, %function
_ZN2nn3svc7aarch328profiler19WaitSynchronizationEPiPKNS0_6HandleEix:

    push     {r0}

    ldr      r0, [sp, #4]              // ns の値 をスタックからレジスタへ
    ldr      r3, [sp, #8]              // ns の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_WAIT_SYNCHRONIZATION

    ldr      r2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch328profiler19WaitSynchronizationEPiPKNS0_6HandleEix, [.-_ZN2nn3svc7aarch328profiler19WaitSynchronizationEPiPKNS0_6HandleEix]


//-------------------------------------------------
// Result CancelSynchronization(nn::svc::Handle handle)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0       4 handle   Register 0       4 handle
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler21CancelSynchronizationENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler21CancelSynchronizationENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch328profiler21CancelSynchronizationENS0_6HandleE
    .type    _ZN2nn3svc7aarch328profiler21CancelSynchronizationENS0_6HandleE, %function
_ZN2nn3svc7aarch328profiler21CancelSynchronizationENS0_6HandleE:

    svc      #NN_SVC_ID_CANCEL_SYNCHRONIZATION
    bx       lr

    .size _ZN2nn3svc7aarch328profiler21CancelSynchronizationENS0_6HandleE, [.-_ZN2nn3svc7aarch328profiler21CancelSynchronizationENS0_6HandleE]


//-------------------------------------------------
// Result ArbitrateLock(nn::svc::Handle handle, uintptr_t addr, nn::Bit32 ownValue)
//
//     AArch32 s=4 r=4 p=4           Invariant s=4 r=8 p=4
// in  abi                           svc
//     Register 0       4 handle     Register 0       4 handle
//     Register 1       4 addr       Register 1       4 addr
//     Register 2       4 ownValue   Register 2       4 ownValue
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler13ArbitrateLockENS0_6HandleEjj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler13ArbitrateLockENS0_6HandleEjj
    .hidden  _ZN2nn3svc7aarch328profiler13ArbitrateLockENS0_6HandleEjj
    .type    _ZN2nn3svc7aarch328profiler13ArbitrateLockENS0_6HandleEjj, %function
_ZN2nn3svc7aarch328profiler13ArbitrateLockENS0_6HandleEjj:

    svc      #NN_SVC_ID_ARBITRATE_LOCK
    bx       lr

    .size _ZN2nn3svc7aarch328profiler13ArbitrateLockENS0_6HandleEjj, [.-_ZN2nn3svc7aarch328profiler13ArbitrateLockENS0_6HandleEjj]


//-------------------------------------------------
// Result ArbitrateUnlock(uintptr_t addr)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0       4 addr     Register 0       4 addr
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler15ArbitrateUnlockEj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler15ArbitrateUnlockEj
    .hidden  _ZN2nn3svc7aarch328profiler15ArbitrateUnlockEj
    .type    _ZN2nn3svc7aarch328profiler15ArbitrateUnlockEj, %function
_ZN2nn3svc7aarch328profiler15ArbitrateUnlockEj:

    svc      #NN_SVC_ID_ARBITRATE_UNLOCK
    bx       lr

    .size _ZN2nn3svc7aarch328profiler15ArbitrateUnlockEj, [.-_ZN2nn3svc7aarch328profiler15ArbitrateUnlockEj]


//-------------------------------------------------
// Result WaitProcessWideKeyAtomic(uintptr_t addr, uintptr_t cvKey, nn::Bit32 ownValue, int64_t ns)
//
//     AArch32 s=4 r=4 p=4           Invariant s=4 r=8 p=4
// in  abi                           svc
//     Register 0       4 addr       Register 0       4 addr
//     Register 1       4 cvKey      Register 1       4 cvKey
//     Register 2       4 ownValue   Register 2       4 ownValue
//                                   Register 3       8 ns
//                                   Register 4       8 ns
//     Stack    0       8 ns         
//     Stack    1       8 ns         
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion
//   Load            ns
//   Load            ns

    .section .text._ZN2nn3svc7aarch328profiler24WaitProcessWideKeyAtomicEjjjx, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler24WaitProcessWideKeyAtomicEjjjx
    .hidden  _ZN2nn3svc7aarch328profiler24WaitProcessWideKeyAtomicEjjjx
    .type    _ZN2nn3svc7aarch328profiler24WaitProcessWideKeyAtomicEjjjx, %function
_ZN2nn3svc7aarch328profiler24WaitProcessWideKeyAtomicEjjjx:

    push     {r4}

    ldr      r3, [sp, #4]              // ns の値 をスタックからレジスタへ
    ldr      r4, [sp, #8]              // ns の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_WAIT_PROCESS_WIDE_KEY_ATOMIC

    pop      {r4}
    bx       lr

    .size _ZN2nn3svc7aarch328profiler24WaitProcessWideKeyAtomicEjjjx, [.-_ZN2nn3svc7aarch328profiler24WaitProcessWideKeyAtomicEjjjx]


//-------------------------------------------------
// void SignalProcessWideKey(uintptr_t cvKey, int32_t num)
//
//     AArch32 s=4 r=4 p=4        Invariant s=4 r=8 p=4
// in  abi                        svc
//     Register 0       4 cvKey   Register 0       4 cvKey
//     Register 1       4 num     Register 1       4 num
//
// out abi                        svc
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler20SignalProcessWideKeyEji, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler20SignalProcessWideKeyEji
    .hidden  _ZN2nn3svc7aarch328profiler20SignalProcessWideKeyEji
    .type    _ZN2nn3svc7aarch328profiler20SignalProcessWideKeyEji, %function
_ZN2nn3svc7aarch328profiler20SignalProcessWideKeyEji:

    svc      #NN_SVC_ID_SIGNAL_PROCESS_WIDE_KEY
    bx       lr

    .size _ZN2nn3svc7aarch328profiler20SignalProcessWideKeyEji, [.-_ZN2nn3svc7aarch328profiler20SignalProcessWideKeyEji]


//-------------------------------------------------
// int64_t GetSystemTick()
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//
// out abi                         svc
//     Register 0       8 return   Register 0       8 return
//     Register 1       8 return   Register 1       8 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler13GetSystemTickEv, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler13GetSystemTickEv
    .hidden  _ZN2nn3svc7aarch328profiler13GetSystemTickEv
    .type    _ZN2nn3svc7aarch328profiler13GetSystemTickEv, %function
_ZN2nn3svc7aarch328profiler13GetSystemTickEv:

    svc      #NN_SVC_ID_GET_SYSTEM_TICK
    bx       lr

    .size _ZN2nn3svc7aarch328profiler13GetSystemTickEv, [.-_ZN2nn3svc7aarch328profiler13GetSystemTickEv]


//-------------------------------------------------
// Result ConnectToNamedPort(nn::svc::Handle* pOut, const char name[])
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0  ref  4 pOut     
//     Register 1  ref -- name     Register 1  ref -- name
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch328profiler18ConnectToNamedPortEPNS0_6HandleEPKc, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler18ConnectToNamedPortEPNS0_6HandleEPKc
    .hidden  _ZN2nn3svc7aarch328profiler18ConnectToNamedPortEPNS0_6HandleEPKc
    .type    _ZN2nn3svc7aarch328profiler18ConnectToNamedPortEPNS0_6HandleEPKc, %function
_ZN2nn3svc7aarch328profiler18ConnectToNamedPortEPNS0_6HandleEPKc:

    push     {r0}

    svc      #NN_SVC_ID_CONNECT_TO_NAMED_PORT

    ldr      r2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch328profiler18ConnectToNamedPortEPNS0_6HandleEPKc, [.-_ZN2nn3svc7aarch328profiler18ConnectToNamedPortEPNS0_6HandleEPKc]


//-------------------------------------------------
// Result SendSyncRequestLight(nn::svc::Handle session)
//
//     AArch32 s=4 r=4 p=4          Invariant s=4 r=8 p=4
// in  abi                          svc
//     Register 0       4 session   Register 0       4 session
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler20SendSyncRequestLightENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler20SendSyncRequestLightENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch328profiler20SendSyncRequestLightENS0_6HandleE
    .type    _ZN2nn3svc7aarch328profiler20SendSyncRequestLightENS0_6HandleE, %function
_ZN2nn3svc7aarch328profiler20SendSyncRequestLightENS0_6HandleE:

    svc      #NN_SVC_ID_SEND_SYNC_REQUEST_LIGHT
    bx       lr

    .size _ZN2nn3svc7aarch328profiler20SendSyncRequestLightENS0_6HandleE, [.-_ZN2nn3svc7aarch328profiler20SendSyncRequestLightENS0_6HandleE]


//-------------------------------------------------
// Result SendSyncRequest(nn::svc::Handle session)
//
//     AArch32 s=4 r=4 p=4          Invariant s=4 r=8 p=4
// in  abi                          svc
//     Register 0       4 session   Register 0       4 session
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler15SendSyncRequestENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler15SendSyncRequestENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch328profiler15SendSyncRequestENS0_6HandleE
    .type    _ZN2nn3svc7aarch328profiler15SendSyncRequestENS0_6HandleE, %function
_ZN2nn3svc7aarch328profiler15SendSyncRequestENS0_6HandleE:

    svc      #NN_SVC_ID_SEND_SYNC_REQUEST
    bx       lr

    .size _ZN2nn3svc7aarch328profiler15SendSyncRequestENS0_6HandleE, [.-_ZN2nn3svc7aarch328profiler15SendSyncRequestENS0_6HandleE]


//-------------------------------------------------
// Result SendSyncRequestWithUserBuffer(uintptr_t pMessage, size_t bufferSize, nn::svc::Handle session)
//
//     AArch32 s=4 r=4 p=4             Invariant s=4 r=8 p=4
// in  abi                             svc
//     Register 0       4 pMessage     Register 0       4 pMessage
//     Register 1       4 bufferSize   Register 1       4 bufferSize
//     Register 2       4 session      Register 2       4 session
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler29SendSyncRequestWithUserBufferEjjNS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler29SendSyncRequestWithUserBufferEjjNS0_6HandleE
    .hidden  _ZN2nn3svc7aarch328profiler29SendSyncRequestWithUserBufferEjjNS0_6HandleE
    .type    _ZN2nn3svc7aarch328profiler29SendSyncRequestWithUserBufferEjjNS0_6HandleE, %function
_ZN2nn3svc7aarch328profiler29SendSyncRequestWithUserBufferEjjNS0_6HandleE:

    svc      #NN_SVC_ID_SEND_SYNC_REQUEST_WITH_USER_BUFFER
    bx       lr

    .size _ZN2nn3svc7aarch328profiler29SendSyncRequestWithUserBufferEjjNS0_6HandleE, [.-_ZN2nn3svc7aarch328profiler29SendSyncRequestWithUserBufferEjjNS0_6HandleE]


//-------------------------------------------------
// Result SendAsyncRequestWithUserBuffer(nn::svc::Handle* pEvent, uintptr_t pMessage, size_t bufferSize, nn::svc::Handle session)
//
//     AArch32 s=4 r=4 p=4             Invariant s=4 r=8 p=4
// in  abi                             svc
//     Register 0  ref  4 pEvent       
//     Register 1       4 pMessage     Register 1       4 pMessage
//     Register 2       4 bufferSize   Register 2       4 bufferSize
//     Register 3       4 session      Register 3       4 session
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//                                     Register 1       4 pEvent
//
// conversion
//   Scatter         pEvent

    .section .text._ZN2nn3svc7aarch328profiler30SendAsyncRequestWithUserBufferEPNS0_6HandleEjjS3_, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler30SendAsyncRequestWithUserBufferEPNS0_6HandleEjjS3_
    .hidden  _ZN2nn3svc7aarch328profiler30SendAsyncRequestWithUserBufferEPNS0_6HandleEjjS3_
    .type    _ZN2nn3svc7aarch328profiler30SendAsyncRequestWithUserBufferEPNS0_6HandleEjjS3_, %function
_ZN2nn3svc7aarch328profiler30SendAsyncRequestWithUserBufferEPNS0_6HandleEjjS3_:

    push     {r0}

    svc      #NN_SVC_ID_SEND_ASYNC_REQUEST_WITH_USER_BUFFER

    ldr      r2, [sp, #0]              // pEventのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pEvent の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch328profiler30SendAsyncRequestWithUserBufferEPNS0_6HandleEjjS3_, [.-_ZN2nn3svc7aarch328profiler30SendAsyncRequestWithUserBufferEPNS0_6HandleEjjS3_]


//-------------------------------------------------
// Result GetProcessId(nn::Bit64* pOut, nn::svc::Handle process)
//
//     AArch32 s=4 r=4 p=4          Invariant s=4 r=8 p=4
// in  abi                          svc
//     Register 0  ref  8 pOut      
//     Register 1       4 process   Register 1       4 process
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//                                  Register 1       8 pOut
//                                  Register 2       8 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch328profiler12GetProcessIdEPyNS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler12GetProcessIdEPyNS0_6HandleE
    .hidden  _ZN2nn3svc7aarch328profiler12GetProcessIdEPyNS0_6HandleE
    .type    _ZN2nn3svc7aarch328profiler12GetProcessIdEPyNS0_6HandleE, %function
_ZN2nn3svc7aarch328profiler12GetProcessIdEPyNS0_6HandleE:

    push     {r0}

    svc      #NN_SVC_ID_GET_PROCESS_ID

    ldr      r3, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      r1, [r3, #0]              // pOut の第 1 ワードをレジスタからメモリへ
    str      r2, [r3, #4]              // pOut の第 2 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch328profiler12GetProcessIdEPyNS0_6HandleE, [.-_ZN2nn3svc7aarch328profiler12GetProcessIdEPyNS0_6HandleE]


//-------------------------------------------------
// Result GetThreadId(nn::Bit64* pOut, nn::svc::Handle thread)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0  ref  8 pOut     
//     Register 1       4 thread   Register 1       4 thread
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       8 pOut
//                                 Register 2       8 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch328profiler11GetThreadIdEPyNS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler11GetThreadIdEPyNS0_6HandleE
    .hidden  _ZN2nn3svc7aarch328profiler11GetThreadIdEPyNS0_6HandleE
    .type    _ZN2nn3svc7aarch328profiler11GetThreadIdEPyNS0_6HandleE, %function
_ZN2nn3svc7aarch328profiler11GetThreadIdEPyNS0_6HandleE:

    push     {r0}

    svc      #NN_SVC_ID_GET_THREAD_ID

    ldr      r3, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      r1, [r3, #0]              // pOut の第 1 ワードをレジスタからメモリへ
    str      r2, [r3, #4]              // pOut の第 2 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch328profiler11GetThreadIdEPyNS0_6HandleE, [.-_ZN2nn3svc7aarch328profiler11GetThreadIdEPyNS0_6HandleE]


//-------------------------------------------------
// void Break(nn::svc::BreakReason reason, uintptr_t data, size_t length)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0       4 reason   Register 0       4 reason
//     Register 1       4 data     Register 1       4 data
//     Register 2       4 length   Register 2       4 length
//
// out abi                         svc
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler5BreakENS0_11BreakReasonEjj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler5BreakENS0_11BreakReasonEjj
    .hidden  _ZN2nn3svc7aarch328profiler5BreakENS0_11BreakReasonEjj
    .type    _ZN2nn3svc7aarch328profiler5BreakENS0_11BreakReasonEjj, %function
_ZN2nn3svc7aarch328profiler5BreakENS0_11BreakReasonEjj:

    svc      #NN_SVC_ID_BREAK
    bx       lr

    .size _ZN2nn3svc7aarch328profiler5BreakENS0_11BreakReasonEjj, [.-_ZN2nn3svc7aarch328profiler5BreakENS0_11BreakReasonEjj]


//-------------------------------------------------
// Result OutputDebugString(const char text[], size_t length)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0  ref -- text     Register 0  ref -- text
//     Register 1       4 length   Register 1       4 length
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler17OutputDebugStringEPKcj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler17OutputDebugStringEPKcj
    .hidden  _ZN2nn3svc7aarch328profiler17OutputDebugStringEPKcj
    .type    _ZN2nn3svc7aarch328profiler17OutputDebugStringEPKcj, %function
_ZN2nn3svc7aarch328profiler17OutputDebugStringEPKcj:

    svc      #NN_SVC_ID_OUTPUT_DEBUG_STRING
    bx       lr

    .size _ZN2nn3svc7aarch328profiler17OutputDebugStringEPKcj, [.-_ZN2nn3svc7aarch328profiler17OutputDebugStringEPKcj]


//-------------------------------------------------
// void ReturnFromException(nn::Result result)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0       4 result   Register 0       4 result
//
// out abi                         svc
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler19ReturnFromExceptionENS_6ResultE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler19ReturnFromExceptionENS_6ResultE
    .hidden  _ZN2nn3svc7aarch328profiler19ReturnFromExceptionENS_6ResultE
    .type    _ZN2nn3svc7aarch328profiler19ReturnFromExceptionENS_6ResultE, %function
_ZN2nn3svc7aarch328profiler19ReturnFromExceptionENS_6ResultE:

    svc      #NN_SVC_ID_RETURN_FROM_EXCEPTION
    bx       lr

    .size _ZN2nn3svc7aarch328profiler19ReturnFromExceptionENS_6ResultE, [.-_ZN2nn3svc7aarch328profiler19ReturnFromExceptionENS_6ResultE]


//-------------------------------------------------
// Result GetInfo(nn::Bit64* pOut, nn::svc::InfoType type, nn::svc::Handle handle, nn::Bit64 param)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0  ref  8 pOut     Register 0       8 param
//     Register 1       4 type     Register 1       4 type
//     Register 2       4 handle   Register 2       4 handle
//                                 Register 3       8 param
//     Stack    0       8 param    
//     Stack    1       8 param    
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       8 pOut
//                                 Register 2       8 pOut
//
// conversion
//   Load            param
//   Load            param
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch328profiler7GetInfoEPyNS0_8InfoTypeENS0_6HandleEy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler7GetInfoEPyNS0_8InfoTypeENS0_6HandleEy
    .hidden  _ZN2nn3svc7aarch328profiler7GetInfoEPyNS0_8InfoTypeENS0_6HandleEy
    .type    _ZN2nn3svc7aarch328profiler7GetInfoEPyNS0_8InfoTypeENS0_6HandleEy, %function
_ZN2nn3svc7aarch328profiler7GetInfoEPyNS0_8InfoTypeENS0_6HandleEy:

    push     {r0}

    ldr      r0, [sp, #4]              // param の値 をスタックからレジスタへ
    ldr      r3, [sp, #8]              // param の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_GET_INFO

    ldr      r3, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      r1, [r3, #0]              // pOut の第 1 ワードをレジスタからメモリへ
    str      r2, [r3, #4]              // pOut の第 2 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch328profiler7GetInfoEPyNS0_8InfoTypeENS0_6HandleEy, [.-_ZN2nn3svc7aarch328profiler7GetInfoEPyNS0_8InfoTypeENS0_6HandleEy]


//-------------------------------------------------
// void FlushEntireDataCache()
//
//     AArch32 s=4 r=4 p=4   Invariant s=4 r=8 p=4
// in  abi   svc
//
// out abi   svc
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler20FlushEntireDataCacheEv, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler20FlushEntireDataCacheEv
    .hidden  _ZN2nn3svc7aarch328profiler20FlushEntireDataCacheEv
    .type    _ZN2nn3svc7aarch328profiler20FlushEntireDataCacheEv, %function
_ZN2nn3svc7aarch328profiler20FlushEntireDataCacheEv:

    svc      #NN_SVC_ID_FLUSH_ENTIRE_DATA_CACHE
    bx       lr

    .size _ZN2nn3svc7aarch328profiler20FlushEntireDataCacheEv, [.-_ZN2nn3svc7aarch328profiler20FlushEntireDataCacheEv]


//-------------------------------------------------
// Result FlushDataCache(uintptr_t addr, size_t size)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0       4 addr     Register 0       4 addr
//     Register 1       4 size     Register 1       4 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler14FlushDataCacheEjj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler14FlushDataCacheEjj
    .hidden  _ZN2nn3svc7aarch328profiler14FlushDataCacheEjj
    .type    _ZN2nn3svc7aarch328profiler14FlushDataCacheEjj, %function
_ZN2nn3svc7aarch328profiler14FlushDataCacheEjj:

    svc      #NN_SVC_ID_FLUSH_DATA_CACHE
    bx       lr

    .size _ZN2nn3svc7aarch328profiler14FlushDataCacheEjj, [.-_ZN2nn3svc7aarch328profiler14FlushDataCacheEjj]


//-------------------------------------------------
// Result MapPhysicalMemory(uintptr_t addr, size_t size)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0       4 addr     Register 0       4 addr
//     Register 1       4 size     Register 1       4 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler17MapPhysicalMemoryEjj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler17MapPhysicalMemoryEjj
    .hidden  _ZN2nn3svc7aarch328profiler17MapPhysicalMemoryEjj
    .type    _ZN2nn3svc7aarch328profiler17MapPhysicalMemoryEjj, %function
_ZN2nn3svc7aarch328profiler17MapPhysicalMemoryEjj:

    svc      #NN_SVC_ID_MAP_PHYSICAL_MEMORY
    bx       lr

    .size _ZN2nn3svc7aarch328profiler17MapPhysicalMemoryEjj, [.-_ZN2nn3svc7aarch328profiler17MapPhysicalMemoryEjj]


//-------------------------------------------------
// Result UnmapPhysicalMemory(uintptr_t addr, size_t size)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0       4 addr     Register 0       4 addr
//     Register 1       4 size     Register 1       4 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler19UnmapPhysicalMemoryEjj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler19UnmapPhysicalMemoryEjj
    .hidden  _ZN2nn3svc7aarch328profiler19UnmapPhysicalMemoryEjj
    .type    _ZN2nn3svc7aarch328profiler19UnmapPhysicalMemoryEjj, %function
_ZN2nn3svc7aarch328profiler19UnmapPhysicalMemoryEjj:

    svc      #NN_SVC_ID_UNMAP_PHYSICAL_MEMORY
    bx       lr

    .size _ZN2nn3svc7aarch328profiler19UnmapPhysicalMemoryEjj, [.-_ZN2nn3svc7aarch328profiler19UnmapPhysicalMemoryEjj]


//-------------------------------------------------
// Result GetLastThreadInfo(nn::svc::ilp32::LastThreadContext* pContext, uintptr_t* pTlsAddr, nn::Bit32* pFlag)
//
//     AArch32 s=4 r=4 p=4           Invariant s=4 r=8 p=4
// in  abi                           svc
//     Register 0  ref 16 pContext   
//     Register 1  ref  4 pTlsAddr   
//     Register 2  ref  4 pFlag      
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//                                   Register 1      16 pContext
//                                   Register 2      16 pContext
//                                   Register 3      16 pContext
//                                   Register 4      16 pContext
//                                   Register 5       4 pTlsAddr
//                                   Register 6       4 pFlag
//
// conversion
//   Scatter         pContext
//   Scatter         pTlsAddr
//   Scatter         pFlag

    .section .text._ZN2nn3svc7aarch328profiler17GetLastThreadInfoEPNS0_5ilp3217LastThreadContextEPjS6_, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler17GetLastThreadInfoEPNS0_5ilp3217LastThreadContextEPjS6_
    .hidden  _ZN2nn3svc7aarch328profiler17GetLastThreadInfoEPNS0_5ilp3217LastThreadContextEPjS6_
    .type    _ZN2nn3svc7aarch328profiler17GetLastThreadInfoEPNS0_5ilp3217LastThreadContextEPjS6_, %function
_ZN2nn3svc7aarch328profiler17GetLastThreadInfoEPNS0_5ilp3217LastThreadContextEPjS6_:

    push     {r0,r1,r2,r4,r5,r6,r7}

    svc      #NN_SVC_ID_GET_LAST_THREAD_INFO

    ldr      r7, [sp, #0]              // pContextのアドレス をスタックからレジスタへ
    str      r1, [r7, #0]              // pContext の第 1 ワードをレジスタからメモリへ
    str      r2, [r7, #4]              // pContext の第 2 ワードをレジスタからメモリへ
    str      r3, [r7, #8]              // pContext の第 3 ワードをレジスタからメモリへ
    str      r4, [r7, #12]             // pContext の第 4 ワードをレジスタからメモリへ
    ldr      r7, [sp, #4]              // pTlsAddrのアドレス をスタックからレジスタへ
    str      r5, [r7, #0]              // pTlsAddr の第 1 ワードをレジスタからメモリへ
    ldr      r7, [sp, #8]              // pFlagのアドレス をスタックからレジスタへ
    str      r6, [r7, #0]              // pFlag の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #12
    pop      {r4,r5,r6,r7}
    bx       lr

    .size _ZN2nn3svc7aarch328profiler17GetLastThreadInfoEPNS0_5ilp3217LastThreadContextEPjS6_, [.-_ZN2nn3svc7aarch328profiler17GetLastThreadInfoEPNS0_5ilp3217LastThreadContextEPjS6_]


//-------------------------------------------------
// Result GetResourceLimitLimitValue(int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource)
//
//     AArch32 s=4 r=4 p=4                Invariant s=4 r=8 p=4
// in  abi                                svc
//     Register 0  ref  8 value           
//     Register 1       4 resourceLimit   Register 1       4 resourceLimit
//     Register 2       4 resource        Register 2       4 resource
//
// out abi                                svc
//     Register 0       4 return          Register 0       4 return
//                                        Register 1       8 value
//                                        Register 2       8 value
//
// conversion
//   Scatter         value

    .section .text._ZN2nn3svc7aarch328profiler26GetResourceLimitLimitValueEPxNS0_6HandleENS0_17LimitableResourceE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler26GetResourceLimitLimitValueEPxNS0_6HandleENS0_17LimitableResourceE
    .hidden  _ZN2nn3svc7aarch328profiler26GetResourceLimitLimitValueEPxNS0_6HandleENS0_17LimitableResourceE
    .type    _ZN2nn3svc7aarch328profiler26GetResourceLimitLimitValueEPxNS0_6HandleENS0_17LimitableResourceE, %function
_ZN2nn3svc7aarch328profiler26GetResourceLimitLimitValueEPxNS0_6HandleENS0_17LimitableResourceE:

    push     {r0}

    svc      #NN_SVC_ID_GET_RESOURCE_LIMIT_LIMIT_VALUE

    ldr      r3, [sp, #0]              // valueのアドレス をスタックからレジスタへ
    str      r1, [r3, #0]              // value の第 1 ワードをレジスタからメモリへ
    str      r2, [r3, #4]              // value の第 2 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch328profiler26GetResourceLimitLimitValueEPxNS0_6HandleENS0_17LimitableResourceE, [.-_ZN2nn3svc7aarch328profiler26GetResourceLimitLimitValueEPxNS0_6HandleENS0_17LimitableResourceE]


//-------------------------------------------------
// Result GetResourceLimitCurrentValue(int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource)
//
//     AArch32 s=4 r=4 p=4                Invariant s=4 r=8 p=4
// in  abi                                svc
//     Register 0  ref  8 value           
//     Register 1       4 resourceLimit   Register 1       4 resourceLimit
//     Register 2       4 resource        Register 2       4 resource
//
// out abi                                svc
//     Register 0       4 return          Register 0       4 return
//                                        Register 1       8 value
//                                        Register 2       8 value
//
// conversion
//   Scatter         value

    .section .text._ZN2nn3svc7aarch328profiler28GetResourceLimitCurrentValueEPxNS0_6HandleENS0_17LimitableResourceE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler28GetResourceLimitCurrentValueEPxNS0_6HandleENS0_17LimitableResourceE
    .hidden  _ZN2nn3svc7aarch328profiler28GetResourceLimitCurrentValueEPxNS0_6HandleENS0_17LimitableResourceE
    .type    _ZN2nn3svc7aarch328profiler28GetResourceLimitCurrentValueEPxNS0_6HandleENS0_17LimitableResourceE, %function
_ZN2nn3svc7aarch328profiler28GetResourceLimitCurrentValueEPxNS0_6HandleENS0_17LimitableResourceE:

    push     {r0}

    svc      #NN_SVC_ID_GET_RESOURCE_LIMIT_CURRENT_VALUE

    ldr      r3, [sp, #0]              // valueのアドレス をスタックからレジスタへ
    str      r1, [r3, #0]              // value の第 1 ワードをレジスタからメモリへ
    str      r2, [r3, #4]              // value の第 2 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch328profiler28GetResourceLimitCurrentValueEPxNS0_6HandleENS0_17LimitableResourceE, [.-_ZN2nn3svc7aarch328profiler28GetResourceLimitCurrentValueEPxNS0_6HandleENS0_17LimitableResourceE]


//-------------------------------------------------
// Result SetThreadActivity(nn::svc::Handle handle, nn::svc::ThreadActivity activity)
//
//     AArch32 s=4 r=4 p=4           Invariant s=4 r=8 p=4
// in  abi                           svc
//     Register 0       4 handle     Register 0       4 handle
//     Register 1       4 activity   Register 1       4 activity
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler17SetThreadActivityENS0_6HandleENS0_14ThreadActivityE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler17SetThreadActivityENS0_6HandleENS0_14ThreadActivityE
    .hidden  _ZN2nn3svc7aarch328profiler17SetThreadActivityENS0_6HandleENS0_14ThreadActivityE
    .type    _ZN2nn3svc7aarch328profiler17SetThreadActivityENS0_6HandleENS0_14ThreadActivityE, %function
_ZN2nn3svc7aarch328profiler17SetThreadActivityENS0_6HandleENS0_14ThreadActivityE:

    svc      #NN_SVC_ID_SET_THREAD_ACTIVITY
    bx       lr

    .size _ZN2nn3svc7aarch328profiler17SetThreadActivityENS0_6HandleENS0_14ThreadActivityE, [.-_ZN2nn3svc7aarch328profiler17SetThreadActivityENS0_6HandleENS0_14ThreadActivityE]


//-------------------------------------------------
// Result GetThreadContext3(nn::svc::ThreadContext* pContext, nn::svc::Handle handle)
//
//     AArch32 s=4 r=4 p=4            Invariant s=4 r=8 p=4
// in  abi                            svc
//     Register 0  ref 332 pContext   Register 0  ref 332 pContext
//     Register 1       4 handle      Register 1       4 handle
//
// out abi                            svc
//     Register 0       4 return      Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler17GetThreadContext3EPNS0_13ThreadContextENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler17GetThreadContext3EPNS0_13ThreadContextENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch328profiler17GetThreadContext3EPNS0_13ThreadContextENS0_6HandleE
    .type    _ZN2nn3svc7aarch328profiler17GetThreadContext3EPNS0_13ThreadContextENS0_6HandleE, %function
_ZN2nn3svc7aarch328profiler17GetThreadContext3EPNS0_13ThreadContextENS0_6HandleE:

    svc      #NN_SVC_ID_GET_THREAD_CONTEXT3
    bx       lr

    .size _ZN2nn3svc7aarch328profiler17GetThreadContext3EPNS0_13ThreadContextENS0_6HandleE, [.-_ZN2nn3svc7aarch328profiler17GetThreadContext3EPNS0_13ThreadContextENS0_6HandleE]


//-------------------------------------------------
// Result WaitForAddress(uintptr_t addr, nn::svc::ArbitrationType type, int32_t value, int64_t ns)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0       4 addr     Register 0       4 addr
//     Register 1       4 type     Register 1       4 type
//     Register 2       4 value    Register 2       4 value
//                                 Register 3       8 ns
//                                 Register 4       8 ns
//     Stack    0       8 ns       
//     Stack    1       8 ns       
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion
//   Load            ns
//   Load            ns

    .section .text._ZN2nn3svc7aarch328profiler14WaitForAddressEjNS0_15ArbitrationTypeEix, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler14WaitForAddressEjNS0_15ArbitrationTypeEix
    .hidden  _ZN2nn3svc7aarch328profiler14WaitForAddressEjNS0_15ArbitrationTypeEix
    .type    _ZN2nn3svc7aarch328profiler14WaitForAddressEjNS0_15ArbitrationTypeEix, %function
_ZN2nn3svc7aarch328profiler14WaitForAddressEjNS0_15ArbitrationTypeEix:

    push     {r4}

    ldr      r3, [sp, #4]              // ns の値 をスタックからレジスタへ
    ldr      r4, [sp, #8]              // ns の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_WAIT_FOR_ADDRESS

    pop      {r4}
    bx       lr

    .size _ZN2nn3svc7aarch328profiler14WaitForAddressEjNS0_15ArbitrationTypeEix, [.-_ZN2nn3svc7aarch328profiler14WaitForAddressEjNS0_15ArbitrationTypeEix]


//-------------------------------------------------
// Result SignalToAddress(uintptr_t addr, nn::svc::SignalType type, int32_t value, int32_t num)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0       4 addr     Register 0       4 addr
//     Register 1       4 type     Register 1       4 type
//     Register 2       4 value    Register 2       4 value
//     Register 3       4 num      Register 3       4 num
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler15SignalToAddressEjNS0_10SignalTypeEii, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler15SignalToAddressEjNS0_10SignalTypeEii
    .hidden  _ZN2nn3svc7aarch328profiler15SignalToAddressEjNS0_10SignalTypeEii
    .type    _ZN2nn3svc7aarch328profiler15SignalToAddressEjNS0_10SignalTypeEii, %function
_ZN2nn3svc7aarch328profiler15SignalToAddressEjNS0_10SignalTypeEii:

    svc      #NN_SVC_ID_SIGNAL_TO_ADDRESS
    bx       lr

    .size _ZN2nn3svc7aarch328profiler15SignalToAddressEjNS0_10SignalTypeEii, [.-_ZN2nn3svc7aarch328profiler15SignalToAddressEjNS0_10SignalTypeEii]


//-------------------------------------------------
// void KernelDebug(nn::svc::KernelDebugType type, nn::Bit64 param0, nn::Bit64 param1, nn::Bit64 param2)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0       4 type     Register 0       4 type
//                                 Register 1       8 param1
//     Register 2       8 param0   Register 2       8 param0
//     Register 3       8 param0   Register 3       8 param0
//                                 Register 4       8 param1
//                                 Register 5       8 param2
//                                 Register 6       8 param2
//     Stack    0       8 param1   
//     Stack    1       8 param1   
//     Stack    2       8 param2   
//     Stack    3       8 param2   
//
// out abi                         svc
//
// conversion
//   Load            param1
//   Load            param1
//   Load            param2
//   Load            param2

    .section .text._ZN2nn3svc7aarch328profiler11KernelDebugENS0_15KernelDebugTypeEyyy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler11KernelDebugENS0_15KernelDebugTypeEyyy
    .hidden  _ZN2nn3svc7aarch328profiler11KernelDebugENS0_15KernelDebugTypeEyyy
    .type    _ZN2nn3svc7aarch328profiler11KernelDebugENS0_15KernelDebugTypeEyyy, %function
_ZN2nn3svc7aarch328profiler11KernelDebugENS0_15KernelDebugTypeEyyy:

    push     {r4,r5,r6}

    ldr      r1, [sp, #12]             // param1 の値 をスタックからレジスタへ
    ldr      r4, [sp, #16]             // param1 の値 をスタックからレジスタへ
    ldr      r5, [sp, #20]             // param2 の値 をスタックからレジスタへ
    ldr      r6, [sp, #24]             // param2 の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_KERNEL_DEBUG

    pop      {r4,r5,r6}
    bx       lr

    .size _ZN2nn3svc7aarch328profiler11KernelDebugENS0_15KernelDebugTypeEyyy, [.-_ZN2nn3svc7aarch328profiler11KernelDebugENS0_15KernelDebugTypeEyyy]


//-------------------------------------------------
// void ChangeKernelTraceState(nn::svc::KernelTraceState state)
//
//     AArch32 s=4 r=4 p=4        Invariant s=4 r=8 p=4
// in  abi                        svc
//     Register 0       4 state   Register 0       4 state
//
// out abi                        svc
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler22ChangeKernelTraceStateENS0_16KernelTraceStateE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler22ChangeKernelTraceStateENS0_16KernelTraceStateE
    .hidden  _ZN2nn3svc7aarch328profiler22ChangeKernelTraceStateENS0_16KernelTraceStateE
    .type    _ZN2nn3svc7aarch328profiler22ChangeKernelTraceStateENS0_16KernelTraceStateE, %function
_ZN2nn3svc7aarch328profiler22ChangeKernelTraceStateENS0_16KernelTraceStateE:

    svc      #NN_SVC_ID_CHANGE_KERNEL_TRACE_STATE
    bx       lr

    .size _ZN2nn3svc7aarch328profiler22ChangeKernelTraceStateENS0_16KernelTraceStateE, [.-_ZN2nn3svc7aarch328profiler22ChangeKernelTraceStateENS0_16KernelTraceStateE]


//-------------------------------------------------
// Result CreateCodeMemory(nn::svc::Handle* pOut, uintptr_t addr, size_t size)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0  ref  4 pOut     
//     Register 1       4 addr     Register 1       4 addr
//     Register 2       4 size     Register 2       4 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch328profiler16CreateCodeMemoryEPNS0_6HandleEjj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler16CreateCodeMemoryEPNS0_6HandleEjj
    .hidden  _ZN2nn3svc7aarch328profiler16CreateCodeMemoryEPNS0_6HandleEjj
    .type    _ZN2nn3svc7aarch328profiler16CreateCodeMemoryEPNS0_6HandleEjj, %function
_ZN2nn3svc7aarch328profiler16CreateCodeMemoryEPNS0_6HandleEjj:

    push     {r0}

    svc      #NN_SVC_ID_CREATE_CODE_MEMORY

    ldr      r2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch328profiler16CreateCodeMemoryEPNS0_6HandleEjj, [.-_ZN2nn3svc7aarch328profiler16CreateCodeMemoryEPNS0_6HandleEjj]


//-------------------------------------------------
// Result ControlCodeMemory(nn::svc::Handle handle, nn::svc::CodeMemoryOperation operation, uint64_t address, uint64_t size, nn::svc::MemoryPermission permission)
//
//     AArch32 s=4 r=4 p=4             Invariant s=4 r=8 p=4
// in  abi                             svc
//     Register 0       4 handle       Register 0       4 handle
//     Register 1       4 operation    Register 1       4 operation
//     Register 2       8 address      Register 2       8 address
//     Register 3       8 address      Register 3       8 address
//                                     Register 4       8 size
//                                     Register 5       8 size
//                                     Register 6       4 permission
//     Stack    0       8 size         
//     Stack    1       8 size         
//     Stack    2       4 permission   
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//
// conversion
//   Load            size
//   Load            size
//   Load            permission

    .section .text._ZN2nn3svc7aarch328profiler17ControlCodeMemoryENS0_6HandleENS0_19CodeMemoryOperationEyyNS0_16MemoryPermissionE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler17ControlCodeMemoryENS0_6HandleENS0_19CodeMemoryOperationEyyNS0_16MemoryPermissionE
    .hidden  _ZN2nn3svc7aarch328profiler17ControlCodeMemoryENS0_6HandleENS0_19CodeMemoryOperationEyyNS0_16MemoryPermissionE
    .type    _ZN2nn3svc7aarch328profiler17ControlCodeMemoryENS0_6HandleENS0_19CodeMemoryOperationEyyNS0_16MemoryPermissionE, %function
_ZN2nn3svc7aarch328profiler17ControlCodeMemoryENS0_6HandleENS0_19CodeMemoryOperationEyyNS0_16MemoryPermissionE:

    push     {r4,r5,r6}

    ldr      r4, [sp, #12]             // size の値 をスタックからレジスタへ
    ldr      r5, [sp, #16]             // size の値 をスタックからレジスタへ
    ldr      r6, [sp, #20]             // permission の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_CONTROL_CODE_MEMORY

    pop      {r4,r5,r6}
    bx       lr

    .size _ZN2nn3svc7aarch328profiler17ControlCodeMemoryENS0_6HandleENS0_19CodeMemoryOperationEyyNS0_16MemoryPermissionE, [.-_ZN2nn3svc7aarch328profiler17ControlCodeMemoryENS0_6HandleENS0_19CodeMemoryOperationEyyNS0_16MemoryPermissionE]


//-------------------------------------------------
// Result ReadWriteRegister(nn::Bit32* pOut, nn::svc::PhysicalAddress address, nn::Bit32 mask, nn::Bit32 value)
//
//     AArch32 s=4 r=4 p=4          Invariant s=4 r=8 p=4
// in  abi                          svc
//     Register 0  ref  4 pOut      Register 0       4 mask
//                                  Register 1       4 value
//     Register 2       8 address   Register 2       8 address
//     Register 3       8 address   Register 3       8 address
//     Stack    0       4 mask      
//     Stack    1       4 value     
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//                                  Register 1       4 pOut
//
// conversion
//   Load            mask
//   Load            value
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch328profiler17ReadWriteRegisterEPjyjj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler17ReadWriteRegisterEPjyjj
    .hidden  _ZN2nn3svc7aarch328profiler17ReadWriteRegisterEPjyjj
    .type    _ZN2nn3svc7aarch328profiler17ReadWriteRegisterEPjyjj, %function
_ZN2nn3svc7aarch328profiler17ReadWriteRegisterEPjyjj:

    push     {r0}

    ldr      r0, [sp, #4]              // mask の値 をスタックからレジスタへ
    ldr      r1, [sp, #8]              // value の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_READ_WRITE_REGISTER

    ldr      r2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch328profiler17ReadWriteRegisterEPjyjj, [.-_ZN2nn3svc7aarch328profiler17ReadWriteRegisterEPjyjj]


//-------------------------------------------------
// Result SetProcessActivity(nn::svc::Handle handle, nn::svc::ProcessActivity activity)
//
//     AArch32 s=4 r=4 p=4           Invariant s=4 r=8 p=4
// in  abi                           svc
//     Register 0       4 handle     Register 0       4 handle
//     Register 1       4 activity   Register 1       4 activity
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler18SetProcessActivityENS0_6HandleENS0_15ProcessActivityE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler18SetProcessActivityENS0_6HandleENS0_15ProcessActivityE
    .hidden  _ZN2nn3svc7aarch328profiler18SetProcessActivityENS0_6HandleENS0_15ProcessActivityE
    .type    _ZN2nn3svc7aarch328profiler18SetProcessActivityENS0_6HandleENS0_15ProcessActivityE, %function
_ZN2nn3svc7aarch328profiler18SetProcessActivityENS0_6HandleENS0_15ProcessActivityE:

    svc      #NN_SVC_ID_SET_PROCESS_ACTIVITY
    bx       lr

    .size _ZN2nn3svc7aarch328profiler18SetProcessActivityENS0_6HandleENS0_15ProcessActivityE, [.-_ZN2nn3svc7aarch328profiler18SetProcessActivityENS0_6HandleENS0_15ProcessActivityE]


    .end

