﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * このファイルを編集しないでください。
 * このファイルは自動生成されます。
 */

#include <nn/svc/svc_TcbId.autogen.h>


//-------------------------------------------------
// Result SetUnsafeLimit(size_t limitSize)
//
//     AArch32 s=4 r=4 p=4            Invariant s=4 r=8 p=4
// in  abi                            svc
//     Register 0       4 limitSize   Register 0       4 limitSize
//
// out abi                            svc
//     Register 0       4 return      Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch3214SetUnsafeLimitEj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3214SetUnsafeLimitEj
    .hidden  _ZN2nn3svc7aarch3214SetUnsafeLimitEj
    .type    _ZN2nn3svc7aarch3214SetUnsafeLimitEj, %function
_ZN2nn3svc7aarch3214SetUnsafeLimitEj:

    svc      #NN_SVC_ID_SET_UNSAFE_LIMIT
    bx       lr

    .size _ZN2nn3svc7aarch3214SetUnsafeLimitEj, [.-_ZN2nn3svc7aarch3214SetUnsafeLimitEj]


//-------------------------------------------------
// void SleepSystem()
//
//     AArch32 s=4 r=4 p=4   Invariant s=4 r=8 p=4
// in  abi   svc
//
// out abi   svc
//
// conversion

    .section .text._ZN2nn3svc7aarch3211SleepSystemEv, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3211SleepSystemEv
    .hidden  _ZN2nn3svc7aarch3211SleepSystemEv
    .type    _ZN2nn3svc7aarch3211SleepSystemEv, %function
_ZN2nn3svc7aarch3211SleepSystemEv:

    svc      #NN_SVC_ID_SLEEP_SYSTEM
    bx       lr

    .size _ZN2nn3svc7aarch3211SleepSystemEv, [.-_ZN2nn3svc7aarch3211SleepSystemEv]


//-------------------------------------------------
// Result GetSystemInfo(nn::Bit64* pOut, nn::svc::SystemInfoType type, nn::svc::Handle handle, nn::Bit64 param)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0  ref  8 pOut     Register 0       8 param
//     Register 1       4 type     Register 1       4 type
//     Register 2       4 handle   Register 2       4 handle
//                                 Register 3       8 param
//     Stack    0       8 param    
//     Stack    1       8 param    
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       8 pOut
//                                 Register 2       8 pOut
//
// conversion
//   Load            param
//   Load            param
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch3213GetSystemInfoEPyNS0_14SystemInfoTypeENS0_6HandleEy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3213GetSystemInfoEPyNS0_14SystemInfoTypeENS0_6HandleEy
    .hidden  _ZN2nn3svc7aarch3213GetSystemInfoEPyNS0_14SystemInfoTypeENS0_6HandleEy
    .type    _ZN2nn3svc7aarch3213GetSystemInfoEPyNS0_14SystemInfoTypeENS0_6HandleEy, %function
_ZN2nn3svc7aarch3213GetSystemInfoEPyNS0_14SystemInfoTypeENS0_6HandleEy:

    push     {r0}

    ldr      r0, [sp, #4]              // param の値 をスタックからレジスタへ
    ldr      r3, [sp, #8]              // param の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_GET_SYSTEM_INFO

    ldr      r3, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      r1, [r3, #0]              // pOut の第 1 ワードをレジスタからメモリへ
    str      r2, [r3, #4]              // pOut の第 2 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch3213GetSystemInfoEPyNS0_14SystemInfoTypeENS0_6HandleEy, [.-_ZN2nn3svc7aarch3213GetSystemInfoEPyNS0_14SystemInfoTypeENS0_6HandleEy]


//-------------------------------------------------
// Result CreatePort(nn::svc::Handle* pOutServer, nn::svc::Handle* pOutClient, int32_t maxSessions, bool isLight, uintptr_t name)
//
//     AArch32 s=4 r=4 p=4              Invariant s=4 r=8 p=4
// in  abi                              svc
//     Register 0  ref  4 pOutServer    Register 0       4 name
//     Register 1  ref  4 pOutClient    
//     Register 2       4 maxSessions   Register 2       4 maxSessions
//     Register 3       1 isLight       Register 3       1 isLight
//     Stack    0       4 name          
//
// out abi                              svc
//     Register 0       4 return        Register 0       4 return
//                                      Register 1       4 pOutServer
//                                      Register 2       4 pOutClient
//
// conversion
//   Load            name
//   Scatter         pOutServer
//   Scatter         pOutClient

    .section .text._ZN2nn3svc7aarch3210CreatePortEPNS0_6HandleES3_ibj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3210CreatePortEPNS0_6HandleES3_ibj
    .hidden  _ZN2nn3svc7aarch3210CreatePortEPNS0_6HandleES3_ibj
    .type    _ZN2nn3svc7aarch3210CreatePortEPNS0_6HandleES3_ibj, %function
_ZN2nn3svc7aarch3210CreatePortEPNS0_6HandleES3_ibj:

    push     {r0,r1}

    ldr      r0, [sp, #8]              // name の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_CREATE_PORT

    ldr      r3, [sp, #0]              // pOutServerのアドレス をスタックからレジスタへ
    str      r1, [r3, #0]              // pOutServer の第 1 ワードをレジスタからメモリへ
    ldr      r3, [sp, #4]              // pOutClientのアドレス をスタックからレジスタへ
    str      r2, [r3, #0]              // pOutClient の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #8
    bx       lr

    .size _ZN2nn3svc7aarch3210CreatePortEPNS0_6HandleES3_ibj, [.-_ZN2nn3svc7aarch3210CreatePortEPNS0_6HandleES3_ibj]


//-------------------------------------------------
// Result ManageNamedPort(nn::svc::Handle* pOutServer, const char name[], int32_t maxSessions)
//
//     AArch32 s=4 r=4 p=4              Invariant s=4 r=8 p=4
// in  abi                              svc
//     Register 0  ref  4 pOutServer    
//     Register 1  ref -- name          Register 1  ref -- name
//     Register 2       4 maxSessions   Register 2       4 maxSessions
//
// out abi                              svc
//     Register 0       4 return        Register 0       4 return
//                                      Register 1       4 pOutServer
//
// conversion
//   Scatter         pOutServer

    .section .text._ZN2nn3svc7aarch3215ManageNamedPortEPNS0_6HandleEPKci, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3215ManageNamedPortEPNS0_6HandleEPKci
    .hidden  _ZN2nn3svc7aarch3215ManageNamedPortEPNS0_6HandleEPKci
    .type    _ZN2nn3svc7aarch3215ManageNamedPortEPNS0_6HandleEPKci, %function
_ZN2nn3svc7aarch3215ManageNamedPortEPNS0_6HandleEPKci:

    push     {r0}

    svc      #NN_SVC_ID_MANAGE_NAMED_PORT

    ldr      r2, [sp, #0]              // pOutServerのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pOutServer の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch3215ManageNamedPortEPNS0_6HandleEPKci, [.-_ZN2nn3svc7aarch3215ManageNamedPortEPNS0_6HandleEPKci]


//-------------------------------------------------
// Result ConnectToPort(nn::svc::Handle* pOut, nn::svc::Handle port)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0  ref  4 pOut     
//     Register 1       4 port     Register 1       4 port
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch3213ConnectToPortEPNS0_6HandleES2_, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3213ConnectToPortEPNS0_6HandleES2_
    .hidden  _ZN2nn3svc7aarch3213ConnectToPortEPNS0_6HandleES2_
    .type    _ZN2nn3svc7aarch3213ConnectToPortEPNS0_6HandleES2_, %function
_ZN2nn3svc7aarch3213ConnectToPortEPNS0_6HandleES2_:

    push     {r0}

    svc      #NN_SVC_ID_CONNECT_TO_PORT

    ldr      r2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch3213ConnectToPortEPNS0_6HandleES2_, [.-_ZN2nn3svc7aarch3213ConnectToPortEPNS0_6HandleES2_]


//-------------------------------------------------
// Result SetProcessMemoryPermission(nn::svc::Handle process, uint64_t addr, uint64_t size, nn::svc::MemoryPermission permission)
//
//     AArch32 s=4 r=4 p=4             Invariant s=4 r=8 p=4
// in  abi                             svc
//     Register 0       4 process      Register 0       4 process
//                                     Register 1       8 size
//     Register 2       8 addr         Register 2       8 addr
//     Register 3       8 addr         Register 3       8 addr
//                                     Register 4       8 size
//                                     Register 5       4 permission
//     Stack    0       8 size         
//     Stack    1       8 size         
//     Stack    2       4 permission   
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//
// conversion
//   Load            size
//   Load            size
//   Load            permission

    .section .text._ZN2nn3svc7aarch3226SetProcessMemoryPermissionENS0_6HandleEyyNS0_16MemoryPermissionE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3226SetProcessMemoryPermissionENS0_6HandleEyyNS0_16MemoryPermissionE
    .hidden  _ZN2nn3svc7aarch3226SetProcessMemoryPermissionENS0_6HandleEyyNS0_16MemoryPermissionE
    .type    _ZN2nn3svc7aarch3226SetProcessMemoryPermissionENS0_6HandleEyyNS0_16MemoryPermissionE, %function
_ZN2nn3svc7aarch3226SetProcessMemoryPermissionENS0_6HandleEyyNS0_16MemoryPermissionE:

    push     {r4,r5}

    ldr      r1, [sp, #8]              // size の値 をスタックからレジスタへ
    ldr      r4, [sp, #12]             // size の値 をスタックからレジスタへ
    ldr      r5, [sp, #16]             // permission の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_SET_PROCESS_MEMORY_PERMISSION

    pop      {r4,r5}
    bx       lr

    .size _ZN2nn3svc7aarch3226SetProcessMemoryPermissionENS0_6HandleEyyNS0_16MemoryPermissionE, [.-_ZN2nn3svc7aarch3226SetProcessMemoryPermissionENS0_6HandleEyyNS0_16MemoryPermissionE]


//-------------------------------------------------
// Result MapProcessMemory(uintptr_t toAddr, nn::svc::Handle process, uint64_t fromAddr, size_t size)
//
//     AArch32 s=4 r=4 p=4           Invariant s=4 r=8 p=4
// in  abi                           svc
//     Register 0       4 toAddr     Register 0       4 toAddr
//     Register 1       4 process    Register 1       4 process
//     Register 2       8 fromAddr   Register 2       8 fromAddr
//     Register 3       8 fromAddr   Register 3       8 fromAddr
//                                   Register 4       4 size
//     Stack    0       4 size       
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion
//   Load            size

    .section .text._ZN2nn3svc7aarch3216MapProcessMemoryEjNS0_6HandleEyj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3216MapProcessMemoryEjNS0_6HandleEyj
    .hidden  _ZN2nn3svc7aarch3216MapProcessMemoryEjNS0_6HandleEyj
    .type    _ZN2nn3svc7aarch3216MapProcessMemoryEjNS0_6HandleEyj, %function
_ZN2nn3svc7aarch3216MapProcessMemoryEjNS0_6HandleEyj:

    push     {r4}

    ldr      r4, [sp, #4]              // size の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_MAP_PROCESS_MEMORY

    pop      {r4}
    bx       lr

    .size _ZN2nn3svc7aarch3216MapProcessMemoryEjNS0_6HandleEyj, [.-_ZN2nn3svc7aarch3216MapProcessMemoryEjNS0_6HandleEyj]


//-------------------------------------------------
// Result UnmapProcessMemory(uintptr_t toAddr, nn::svc::Handle process, uint64_t fromAddr, size_t size)
//
//     AArch32 s=4 r=4 p=4           Invariant s=4 r=8 p=4
// in  abi                           svc
//     Register 0       4 toAddr     Register 0       4 toAddr
//     Register 1       4 process    Register 1       4 process
//     Register 2       8 fromAddr   Register 2       8 fromAddr
//     Register 3       8 fromAddr   Register 3       8 fromAddr
//                                   Register 4       4 size
//     Stack    0       4 size       
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion
//   Load            size

    .section .text._ZN2nn3svc7aarch3218UnmapProcessMemoryEjNS0_6HandleEyj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3218UnmapProcessMemoryEjNS0_6HandleEyj
    .hidden  _ZN2nn3svc7aarch3218UnmapProcessMemoryEjNS0_6HandleEyj
    .type    _ZN2nn3svc7aarch3218UnmapProcessMemoryEjNS0_6HandleEyj, %function
_ZN2nn3svc7aarch3218UnmapProcessMemoryEjNS0_6HandleEyj:

    push     {r4}

    ldr      r4, [sp, #4]              // size の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_UNMAP_PROCESS_MEMORY

    pop      {r4}
    bx       lr

    .size _ZN2nn3svc7aarch3218UnmapProcessMemoryEjNS0_6HandleEyj, [.-_ZN2nn3svc7aarch3218UnmapProcessMemoryEjNS0_6HandleEyj]


//-------------------------------------------------
// Result QueryProcessMemory(nn::svc::ilp32::MemoryInfo* pBlockInfo, nn::svc::PageInfo* pPageInfo, nn::svc::Handle process, uint64_t addr)
//
//     AArch32 s=4 r=4 p=4             Invariant s=4 r=8 p=4
// in  abi                             svc
//     Register 0  ref 40 pBlockInfo   Register 0  ref 40 pBlockInfo
//     Register 1  ref  4 pPageInfo    Register 1       8 addr
//     Register 2       4 process      Register 2       4 process
//                                     Register 3       8 addr
//     Stack    0       8 addr         
//     Stack    1       8 addr         
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//                                     Register 1       4 pPageInfo
//
// conversion
//   Load            addr
//   Load            addr
//   Scatter         pPageInfo

    .section .text._ZN2nn3svc7aarch3218QueryProcessMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoENS0_6HandleEy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3218QueryProcessMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoENS0_6HandleEy
    .hidden  _ZN2nn3svc7aarch3218QueryProcessMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoENS0_6HandleEy
    .type    _ZN2nn3svc7aarch3218QueryProcessMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoENS0_6HandleEy, %function
_ZN2nn3svc7aarch3218QueryProcessMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoENS0_6HandleEy:

    push     {r1}

    ldr      r1, [sp, #4]              // addr の値 をスタックからレジスタへ
    ldr      r3, [sp, #8]              // addr の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_QUERY_PROCESS_MEMORY

    ldr      r2, [sp, #0]              // pPageInfoのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pPageInfo の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch3218QueryProcessMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoENS0_6HandleEy, [.-_ZN2nn3svc7aarch3218QueryProcessMemoryEPNS0_5ilp3210MemoryInfoEPNS0_8PageInfoENS0_6HandleEy]


//-------------------------------------------------
// Result MapProcessCodeMemory(nn::svc::Handle process, uint64_t toAddr, uint64_t fromAddr, uint64_t size)
//
//     AArch32 s=4 r=4 p=4           Invariant s=4 r=8 p=4
// in  abi                           svc
//     Register 0       4 process    Register 0       4 process
//                                   Register 1       8 fromAddr
//     Register 2       8 toAddr     Register 2       8 toAddr
//     Register 3       8 toAddr     Register 3       8 toAddr
//                                   Register 4       8 fromAddr
//                                   Register 5       8 size
//                                   Register 6       8 size
//     Stack    0       8 fromAddr   
//     Stack    1       8 fromAddr   
//     Stack    2       8 size       
//     Stack    3       8 size       
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion
//   Load            fromAddr
//   Load            fromAddr
//   Load            size
//   Load            size

    .section .text._ZN2nn3svc7aarch3220MapProcessCodeMemoryENS0_6HandleEyyy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3220MapProcessCodeMemoryENS0_6HandleEyyy
    .hidden  _ZN2nn3svc7aarch3220MapProcessCodeMemoryENS0_6HandleEyyy
    .type    _ZN2nn3svc7aarch3220MapProcessCodeMemoryENS0_6HandleEyyy, %function
_ZN2nn3svc7aarch3220MapProcessCodeMemoryENS0_6HandleEyyy:

    push     {r4,r5,r6}

    ldr      r1, [sp, #12]             // fromAddr の値 をスタックからレジスタへ
    ldr      r4, [sp, #16]             // fromAddr の値 をスタックからレジスタへ
    ldr      r5, [sp, #20]             // size の値 をスタックからレジスタへ
    ldr      r6, [sp, #24]             // size の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_MAP_PROCESS_CODE_MEMORY

    pop      {r4,r5,r6}
    bx       lr

    .size _ZN2nn3svc7aarch3220MapProcessCodeMemoryENS0_6HandleEyyy, [.-_ZN2nn3svc7aarch3220MapProcessCodeMemoryENS0_6HandleEyyy]


//-------------------------------------------------
// Result UnmapProcessCodeMemory(nn::svc::Handle process, uint64_t toAddr, uint64_t fromAddr, uint64_t size)
//
//     AArch32 s=4 r=4 p=4           Invariant s=4 r=8 p=4
// in  abi                           svc
//     Register 0       4 process    Register 0       4 process
//                                   Register 1       8 fromAddr
//     Register 2       8 toAddr     Register 2       8 toAddr
//     Register 3       8 toAddr     Register 3       8 toAddr
//                                   Register 4       8 fromAddr
//                                   Register 5       8 size
//                                   Register 6       8 size
//     Stack    0       8 fromAddr   
//     Stack    1       8 fromAddr   
//     Stack    2       8 size       
//     Stack    3       8 size       
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion
//   Load            fromAddr
//   Load            fromAddr
//   Load            size
//   Load            size

    .section .text._ZN2nn3svc7aarch3222UnmapProcessCodeMemoryENS0_6HandleEyyy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3222UnmapProcessCodeMemoryENS0_6HandleEyyy
    .hidden  _ZN2nn3svc7aarch3222UnmapProcessCodeMemoryENS0_6HandleEyyy
    .type    _ZN2nn3svc7aarch3222UnmapProcessCodeMemoryENS0_6HandleEyyy, %function
_ZN2nn3svc7aarch3222UnmapProcessCodeMemoryENS0_6HandleEyyy:

    push     {r4,r5,r6}

    ldr      r1, [sp, #12]             // fromAddr の値 をスタックからレジスタへ
    ldr      r4, [sp, #16]             // fromAddr の値 をスタックからレジスタへ
    ldr      r5, [sp, #20]             // size の値 をスタックからレジスタへ
    ldr      r6, [sp, #24]             // size の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_UNMAP_PROCESS_CODE_MEMORY

    pop      {r4,r5,r6}
    bx       lr

    .size _ZN2nn3svc7aarch3222UnmapProcessCodeMemoryENS0_6HandleEyyy, [.-_ZN2nn3svc7aarch3222UnmapProcessCodeMemoryENS0_6HandleEyyy]


//-------------------------------------------------
// Result CreateProcess(nn::svc::Handle* pOut, const nn::svc::ilp32::CreateProcessParameter& params, const nn::Bit32 flags[], int32_t flagsNum)
//
//     AArch32 s=4 r=4 p=4           Invariant s=4 r=8 p=4
// in  abi                           svc
//     Register 0  ref  4 pOut       
//     Register 1  ref 48 params     Register 1  ref 48 params
//     Register 2  ref -- flags      Register 2  ref -- flags
//     Register 3       4 flagsNum   Register 3       4 flagsNum
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//                                   Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch3213CreateProcessEPNS0_6HandleERKNS0_5ilp3222CreateProcessParameterEPKji, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3213CreateProcessEPNS0_6HandleERKNS0_5ilp3222CreateProcessParameterEPKji
    .hidden  _ZN2nn3svc7aarch3213CreateProcessEPNS0_6HandleERKNS0_5ilp3222CreateProcessParameterEPKji
    .type    _ZN2nn3svc7aarch3213CreateProcessEPNS0_6HandleERKNS0_5ilp3222CreateProcessParameterEPKji, %function
_ZN2nn3svc7aarch3213CreateProcessEPNS0_6HandleERKNS0_5ilp3222CreateProcessParameterEPKji:

    push     {r0}

    svc      #NN_SVC_ID_CREATE_PROCESS

    ldr      r2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch3213CreateProcessEPNS0_6HandleERKNS0_5ilp3222CreateProcessParameterEPKji, [.-_ZN2nn3svc7aarch3213CreateProcessEPNS0_6HandleERKNS0_5ilp3222CreateProcessParameterEPKji]


//-------------------------------------------------
// Result StartProcess(nn::svc::Handle runner, int32_t priority, int32_t coreNo, uint64_t stackSize)
//
//     AArch32 s=4 r=4 p=4            Invariant s=4 r=8 p=4
// in  abi                            svc
//     Register 0       4 runner      Register 0       4 runner
//     Register 1       4 priority    Register 1       4 priority
//     Register 2       4 coreNo      Register 2       4 coreNo
//                                    Register 3       8 stackSize
//                                    Register 4       8 stackSize
//     Stack    0       8 stackSize   
//     Stack    1       8 stackSize   
//
// out abi                            svc
//     Register 0       4 return      Register 0       4 return
//
// conversion
//   Load            stackSize
//   Load            stackSize

    .section .text._ZN2nn3svc7aarch3212StartProcessENS0_6HandleEiiy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3212StartProcessENS0_6HandleEiiy
    .hidden  _ZN2nn3svc7aarch3212StartProcessENS0_6HandleEiiy
    .type    _ZN2nn3svc7aarch3212StartProcessENS0_6HandleEiiy, %function
_ZN2nn3svc7aarch3212StartProcessENS0_6HandleEiiy:

    push     {r4}

    ldr      r3, [sp, #4]              // stackSize の値 をスタックからレジスタへ
    ldr      r4, [sp, #8]              // stackSize の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_START_PROCESS

    pop      {r4}
    bx       lr

    .size _ZN2nn3svc7aarch3212StartProcessENS0_6HandleEiiy, [.-_ZN2nn3svc7aarch3212StartProcessENS0_6HandleEiiy]


//-------------------------------------------------
// Result TerminateProcess(nn::svc::Handle process)
//
//     AArch32 s=4 r=4 p=4          Invariant s=4 r=8 p=4
// in  abi                          svc
//     Register 0       4 process   Register 0       4 process
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch3216TerminateProcessENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3216TerminateProcessENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch3216TerminateProcessENS0_6HandleE
    .type    _ZN2nn3svc7aarch3216TerminateProcessENS0_6HandleE, %function
_ZN2nn3svc7aarch3216TerminateProcessENS0_6HandleE:

    svc      #NN_SVC_ID_TERMINATE_PROCESS
    bx       lr

    .size _ZN2nn3svc7aarch3216TerminateProcessENS0_6HandleE, [.-_ZN2nn3svc7aarch3216TerminateProcessENS0_6HandleE]


//-------------------------------------------------
// Result GetProcessInfo(int64_t* pOut, nn::svc::Handle handle, nn::svc::ProcessInfoType type)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0  ref  8 pOut     
//     Register 1       4 handle   Register 1       4 handle
//     Register 2       4 type     Register 2       4 type
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       8 pOut
//                                 Register 2       8 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch3214GetProcessInfoEPxNS0_6HandleENS0_15ProcessInfoTypeE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3214GetProcessInfoEPxNS0_6HandleENS0_15ProcessInfoTypeE
    .hidden  _ZN2nn3svc7aarch3214GetProcessInfoEPxNS0_6HandleENS0_15ProcessInfoTypeE
    .type    _ZN2nn3svc7aarch3214GetProcessInfoEPxNS0_6HandleENS0_15ProcessInfoTypeE, %function
_ZN2nn3svc7aarch3214GetProcessInfoEPxNS0_6HandleENS0_15ProcessInfoTypeE:

    push     {r0}

    svc      #NN_SVC_ID_GET_PROCESS_INFO

    ldr      r3, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      r1, [r3, #0]              // pOut の第 1 ワードをレジスタからメモリへ
    str      r2, [r3, #4]              // pOut の第 2 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch3214GetProcessInfoEPxNS0_6HandleENS0_15ProcessInfoTypeE, [.-_ZN2nn3svc7aarch3214GetProcessInfoEPxNS0_6HandleENS0_15ProcessInfoTypeE]


//-------------------------------------------------
// Result CreateResourceLimit(nn::svc::Handle* pOut)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0  ref  4 pOut     
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch3219CreateResourceLimitEPNS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3219CreateResourceLimitEPNS0_6HandleE
    .hidden  _ZN2nn3svc7aarch3219CreateResourceLimitEPNS0_6HandleE
    .type    _ZN2nn3svc7aarch3219CreateResourceLimitEPNS0_6HandleE, %function
_ZN2nn3svc7aarch3219CreateResourceLimitEPNS0_6HandleE:

    push     {r0}

    svc      #NN_SVC_ID_CREATE_RESOURCE_LIMIT

    ldr      r2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch3219CreateResourceLimitEPNS0_6HandleE, [.-_ZN2nn3svc7aarch3219CreateResourceLimitEPNS0_6HandleE]


//-------------------------------------------------
// Result SetResourceLimitLimitValue(nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource, int64_t value)
//
//     AArch32 s=4 r=4 p=4                Invariant s=4 r=8 p=4
// in  abi                                svc
//     Register 0       4 resourceLimit   Register 0       4 resourceLimit
//     Register 1       4 resource        Register 1       4 resource
//     Register 2       8 value           Register 2       8 value
//     Register 3       8 value           Register 3       8 value
//
// out abi                                svc
//     Register 0       4 return          Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch3226SetResourceLimitLimitValueENS0_6HandleENS0_17LimitableResourceEx, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3226SetResourceLimitLimitValueENS0_6HandleENS0_17LimitableResourceEx
    .hidden  _ZN2nn3svc7aarch3226SetResourceLimitLimitValueENS0_6HandleENS0_17LimitableResourceEx
    .type    _ZN2nn3svc7aarch3226SetResourceLimitLimitValueENS0_6HandleENS0_17LimitableResourceEx, %function
_ZN2nn3svc7aarch3226SetResourceLimitLimitValueENS0_6HandleENS0_17LimitableResourceEx:

    svc      #NN_SVC_ID_SET_RESOURCE_LIMIT_LIMIT_VALUE
    bx       lr

    .size _ZN2nn3svc7aarch3226SetResourceLimitLimitValueENS0_6HandleENS0_17LimitableResourceEx, [.-_ZN2nn3svc7aarch3226SetResourceLimitLimitValueENS0_6HandleENS0_17LimitableResourceEx]


//-------------------------------------------------
// void CallSecureMonitor()
//
//     AArch32 s=4 r=4 p=4   Invariant s=4 r=8 p=4
// in  abi   svc
//
// out abi   svc
//
// conversion

    .section .text._ZN2nn3svc7aarch3217CallSecureMonitorEv, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch3217CallSecureMonitorEv
    .hidden  _ZN2nn3svc7aarch3217CallSecureMonitorEv
    .type    _ZN2nn3svc7aarch3217CallSecureMonitorEv, %function
_ZN2nn3svc7aarch3217CallSecureMonitorEv:

    svc      #NN_SVC_ID_CALL_SECURE_MONITOR
    bx       lr

    .size _ZN2nn3svc7aarch3217CallSecureMonitorEv, [.-_ZN2nn3svc7aarch3217CallSecureMonitorEv]


    .end

