﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * このファイルを編集しないでください。
 * このファイルは自動生成されます。
 */

#include <nn/svc/svc_BaseId.autogen.h>


//-------------------------------------------------
// Result SetHeapSize(uintptr_t* pOut, size_t size)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0  ref  4 pOut     
//     Register 1       4 size     Register 1       8 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       8 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp3211SetHeapSizeEPmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3211SetHeapSizeEPmm
    .hidden  _ZN2nn3svc7aarch645ilp3211SetHeapSizeEPmm
    .type    _ZN2nn3svc7aarch645ilp3211SetHeapSizeEPmm, %function
_ZN2nn3svc7aarch645ilp3211SetHeapSizeEPmm:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_SET_HEAP_SIZE

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3211SetHeapSizeEPmm, [.-_ZN2nn3svc7aarch645ilp3211SetHeapSizeEPmm]


//-------------------------------------------------
// Result SetMemoryPermission(uintptr_t addr, size_t size, nn::svc::MemoryPermission permission)
//
//     AArch64 s=8 r=8 p=4             Invariant s=8 r=8 p=8
// in  abi                             svc
//     Register 0       4 addr         Register 0       8 addr
//     Register 1       4 size         Register 1       8 size
//     Register 2       4 permission   Register 2       4 permission
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3219SetMemoryPermissionEmmNS0_16MemoryPermissionE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3219SetMemoryPermissionEmmNS0_16MemoryPermissionE
    .hidden  _ZN2nn3svc7aarch645ilp3219SetMemoryPermissionEmmNS0_16MemoryPermissionE
    .type    _ZN2nn3svc7aarch645ilp3219SetMemoryPermissionEmmNS0_16MemoryPermissionE, %function
_ZN2nn3svc7aarch645ilp3219SetMemoryPermissionEmmNS0_16MemoryPermissionE:

    svc      #NN_SVC_ID_SET_MEMORY_PERMISSION
    ret

    .size _ZN2nn3svc7aarch645ilp3219SetMemoryPermissionEmmNS0_16MemoryPermissionE, [.-_ZN2nn3svc7aarch645ilp3219SetMemoryPermissionEmmNS0_16MemoryPermissionE]


//-------------------------------------------------
// Result SetMemoryAttribute(uintptr_t addr, size_t size, nn::Bit32 mask, nn::Bit32 attribute)
//
//     AArch64 s=8 r=8 p=4            Invariant s=8 r=8 p=8
// in  abi                            svc
//     Register 0       4 addr        Register 0       8 addr
//     Register 1       4 size        Register 1       8 size
//     Register 2       4 mask        Register 2       4 mask
//     Register 3       4 attribute   Register 3       4 attribute
//
// out abi                            svc
//     Register 0       4 return      Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3218SetMemoryAttributeEmmjj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3218SetMemoryAttributeEmmjj
    .hidden  _ZN2nn3svc7aarch645ilp3218SetMemoryAttributeEmmjj
    .type    _ZN2nn3svc7aarch645ilp3218SetMemoryAttributeEmmjj, %function
_ZN2nn3svc7aarch645ilp3218SetMemoryAttributeEmmjj:

    svc      #NN_SVC_ID_SET_MEMORY_ATTRIBUTE
    ret

    .size _ZN2nn3svc7aarch645ilp3218SetMemoryAttributeEmmjj, [.-_ZN2nn3svc7aarch645ilp3218SetMemoryAttributeEmmjj]


//-------------------------------------------------
// Result MapMemory(uintptr_t toAddr, uintptr_t fromAddr, size_t size)
//
//     AArch64 s=8 r=8 p=4           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0       4 toAddr     Register 0       8 toAddr
//     Register 1       4 fromAddr   Register 1       8 fromAddr
//     Register 2       4 size       Register 2       8 size
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp329MapMemoryEmmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp329MapMemoryEmmm
    .hidden  _ZN2nn3svc7aarch645ilp329MapMemoryEmmm
    .type    _ZN2nn3svc7aarch645ilp329MapMemoryEmmm, %function
_ZN2nn3svc7aarch645ilp329MapMemoryEmmm:

    svc      #NN_SVC_ID_MAP_MEMORY
    ret

    .size _ZN2nn3svc7aarch645ilp329MapMemoryEmmm, [.-_ZN2nn3svc7aarch645ilp329MapMemoryEmmm]


//-------------------------------------------------
// Result UnmapMemory(uintptr_t toAddr, uintptr_t fromAddr, size_t size)
//
//     AArch64 s=8 r=8 p=4           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0       4 toAddr     Register 0       8 toAddr
//     Register 1       4 fromAddr   Register 1       8 fromAddr
//     Register 2       4 size       Register 2       8 size
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3211UnmapMemoryEmmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3211UnmapMemoryEmmm
    .hidden  _ZN2nn3svc7aarch645ilp3211UnmapMemoryEmmm
    .type    _ZN2nn3svc7aarch645ilp3211UnmapMemoryEmmm, %function
_ZN2nn3svc7aarch645ilp3211UnmapMemoryEmmm:

    svc      #NN_SVC_ID_UNMAP_MEMORY
    ret

    .size _ZN2nn3svc7aarch645ilp3211UnmapMemoryEmmm, [.-_ZN2nn3svc7aarch645ilp3211UnmapMemoryEmmm]


//-------------------------------------------------
// Result QueryMemory(nn::svc::lp64::MemoryInfo* pBlockInfo, nn::svc::PageInfo* pPageInfo, uintptr_t addr)
//
//     AArch64 s=8 r=8 p=4             Invariant s=8 r=8 p=8
// in  abi                             svc
//     Register 0  ref 40 pBlockInfo   Register 0  ref 40 pBlockInfo
//     Register 1  ref  4 pPageInfo    
//     Register 2       4 addr         Register 2       8 addr
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//                                     Register 1       4 pPageInfo
//
// conversion
//   Scatter         pPageInfo

    .section .text._ZN2nn3svc7aarch645ilp3211QueryMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoEm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3211QueryMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoEm
    .hidden  _ZN2nn3svc7aarch645ilp3211QueryMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoEm
    .type    _ZN2nn3svc7aarch645ilp3211QueryMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoEm, %function
_ZN2nn3svc7aarch645ilp3211QueryMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoEm:

    str      x1, [sp, #-16]!

    svc      #NN_SVC_ID_QUERY_MEMORY

    ldr      x2, [sp, #0]              // pPageInfoのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pPageInfo の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3211QueryMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoEm, [.-_ZN2nn3svc7aarch645ilp3211QueryMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoEm]


//-------------------------------------------------
// void ExitProcess()
//
//     AArch64 s=8 r=8 p=4   Invariant s=8 r=8 p=8
// in  abi   svc
//
// out abi   svc
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3211ExitProcessEv, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3211ExitProcessEv
    .hidden  _ZN2nn3svc7aarch645ilp3211ExitProcessEv
    .type    _ZN2nn3svc7aarch645ilp3211ExitProcessEv, %function
_ZN2nn3svc7aarch645ilp3211ExitProcessEv:

    svc      #NN_SVC_ID_EXIT_PROCESS
    ret

    .size _ZN2nn3svc7aarch645ilp3211ExitProcessEv, [.-_ZN2nn3svc7aarch645ilp3211ExitProcessEv]


//-------------------------------------------------
// Result CreateThread(nn::svc::Handle* pOut, nn::svc::lp64::ThreadFunc f, uintptr_t param, uintptr_t stackBottom, int32_t priority, int32_t idealCore)
//
//     AArch64 s=8 r=8 p=4              Invariant s=8 r=8 p=8
// in  abi                              svc
//     Register 0  ref  4 pOut          
//     Register 1       8 f             Register 1       8 f
//     Register 2       4 param         Register 2       8 param
//     Register 3       4 stackBottom   Register 3       8 stackBottom
//     Register 4       4 priority      Register 4       4 priority
//     Register 5       4 idealCore     Register 5       4 idealCore
//
// out abi                              svc
//     Register 0       4 return        Register 0       4 return
//                                      Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp3212CreateThreadEPNS0_6HandleEmmmii, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3212CreateThreadEPNS0_6HandleEmmmii
    .hidden  _ZN2nn3svc7aarch645ilp3212CreateThreadEPNS0_6HandleEmmmii
    .type    _ZN2nn3svc7aarch645ilp3212CreateThreadEPNS0_6HandleEmmmii, %function
_ZN2nn3svc7aarch645ilp3212CreateThreadEPNS0_6HandleEmmmii:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_CREATE_THREAD

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3212CreateThreadEPNS0_6HandleEmmmii, [.-_ZN2nn3svc7aarch645ilp3212CreateThreadEPNS0_6HandleEmmmii]


//-------------------------------------------------
// Result StartThread(nn::svc::Handle thread)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 thread   Register 0       4 thread
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3211StartThreadENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3211StartThreadENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp3211StartThreadENS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp3211StartThreadENS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp3211StartThreadENS0_6HandleE:

    svc      #NN_SVC_ID_START_THREAD
    ret

    .size _ZN2nn3svc7aarch645ilp3211StartThreadENS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp3211StartThreadENS0_6HandleE]


//-------------------------------------------------
// void ExitThread()
//
//     AArch64 s=8 r=8 p=4   Invariant s=8 r=8 p=8
// in  abi   svc
//
// out abi   svc
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3210ExitThreadEv, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3210ExitThreadEv
    .hidden  _ZN2nn3svc7aarch645ilp3210ExitThreadEv
    .type    _ZN2nn3svc7aarch645ilp3210ExitThreadEv, %function
_ZN2nn3svc7aarch645ilp3210ExitThreadEv:

    svc      #NN_SVC_ID_EXIT_THREAD
    ret

    .size _ZN2nn3svc7aarch645ilp3210ExitThreadEv, [.-_ZN2nn3svc7aarch645ilp3210ExitThreadEv]


//-------------------------------------------------
// void SleepThread(int64_t ns)
//
//     AArch64 s=8 r=8 p=4     Invariant s=8 r=8 p=8
// in  abi                     svc
//     Register 0       8 ns   Register 0       8 ns
//
// out abi                     svc
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3211SleepThreadEx, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3211SleepThreadEx
    .hidden  _ZN2nn3svc7aarch645ilp3211SleepThreadEx
    .type    _ZN2nn3svc7aarch645ilp3211SleepThreadEx, %function
_ZN2nn3svc7aarch645ilp3211SleepThreadEx:

    svc      #NN_SVC_ID_SLEEP_THREAD
    ret

    .size _ZN2nn3svc7aarch645ilp3211SleepThreadEx, [.-_ZN2nn3svc7aarch645ilp3211SleepThreadEx]


//-------------------------------------------------
// Result GetThreadPriority(int32_t* pOut, nn::svc::Handle thread)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0  ref  4 pOut     
//     Register 1       4 thread   Register 1       4 thread
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp3217GetThreadPriorityEPiNS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3217GetThreadPriorityEPiNS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp3217GetThreadPriorityEPiNS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp3217GetThreadPriorityEPiNS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp3217GetThreadPriorityEPiNS0_6HandleE:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_GET_THREAD_PRIORITY

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3217GetThreadPriorityEPiNS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp3217GetThreadPriorityEPiNS0_6HandleE]


//-------------------------------------------------
// Result SetThreadPriority(nn::svc::Handle thread, int32_t priority)
//
//     AArch64 s=8 r=8 p=4           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0       4 thread     Register 0       4 thread
//     Register 1       4 priority   Register 1       4 priority
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3217SetThreadPriorityENS0_6HandleEi, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3217SetThreadPriorityENS0_6HandleEi
    .hidden  _ZN2nn3svc7aarch645ilp3217SetThreadPriorityENS0_6HandleEi
    .type    _ZN2nn3svc7aarch645ilp3217SetThreadPriorityENS0_6HandleEi, %function
_ZN2nn3svc7aarch645ilp3217SetThreadPriorityENS0_6HandleEi:

    svc      #NN_SVC_ID_SET_THREAD_PRIORITY
    ret

    .size _ZN2nn3svc7aarch645ilp3217SetThreadPriorityENS0_6HandleEi, [.-_ZN2nn3svc7aarch645ilp3217SetThreadPriorityENS0_6HandleEi]


//-------------------------------------------------
// Result GetThreadCoreMask(int32_t* pIdealCore, nn::Bit64* pAffinityMask, nn::svc::Handle thread)
//
//     AArch64 s=8 r=8 p=4                Invariant s=8 r=8 p=8
// in  abi                                svc
//     Register 0  ref  4 pIdealCore      
//     Register 1  ref  8 pAffinityMask   
//     Register 2       4 thread          Register 2       4 thread
//
// out abi                                svc
//     Register 0       4 return          Register 0       4 return
//                                        Register 1       4 pIdealCore
//                                        Register 2       8 pAffinityMask
//
// conversion
//   Scatter         pIdealCore
//   Scatter         pAffinityMask

    .section .text._ZN2nn3svc7aarch645ilp3217GetThreadCoreMaskEPiPyNS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3217GetThreadCoreMaskEPiPyNS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp3217GetThreadCoreMaskEPiPyNS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp3217GetThreadCoreMaskEPiPyNS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp3217GetThreadCoreMaskEPiPyNS0_6HandleE:

    stp      x0, x1, [sp, #-16]!

    svc      #NN_SVC_ID_GET_THREAD_CORE_MASK

    ldr      x3, [sp, #0]              // pIdealCoreのアドレス をスタックからレジスタへ
    str      w1, [x3, #0]              // pIdealCore の第 1 ワードをレジスタからメモリへ
    ldr      x3, [sp, #8]              // pAffinityMaskのアドレス をスタックからレジスタへ
    str      x2, [x3, #0]              // pAffinityMask の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3217GetThreadCoreMaskEPiPyNS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp3217GetThreadCoreMaskEPiPyNS0_6HandleE]


//-------------------------------------------------
// Result SetThreadCoreMask(nn::svc::Handle thread, int32_t idealCore, nn::Bit64 affinityMask)
//
//     AArch64 s=8 r=8 p=4               Invariant s=8 r=8 p=8
// in  abi                               svc
//     Register 0       4 thread         Register 0       4 thread
//     Register 1       4 idealCore      Register 1       4 idealCore
//     Register 2       8 affinityMask   Register 2       8 affinityMask
//
// out abi                               svc
//     Register 0       4 return         Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3217SetThreadCoreMaskENS0_6HandleEiy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3217SetThreadCoreMaskENS0_6HandleEiy
    .hidden  _ZN2nn3svc7aarch645ilp3217SetThreadCoreMaskENS0_6HandleEiy
    .type    _ZN2nn3svc7aarch645ilp3217SetThreadCoreMaskENS0_6HandleEiy, %function
_ZN2nn3svc7aarch645ilp3217SetThreadCoreMaskENS0_6HandleEiy:

    svc      #NN_SVC_ID_SET_THREAD_CORE_MASK
    ret

    .size _ZN2nn3svc7aarch645ilp3217SetThreadCoreMaskENS0_6HandleEiy, [.-_ZN2nn3svc7aarch645ilp3217SetThreadCoreMaskENS0_6HandleEiy]


//-------------------------------------------------
// int32_t GetCurrentProcessorNumber()
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3225GetCurrentProcessorNumberEv, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3225GetCurrentProcessorNumberEv
    .hidden  _ZN2nn3svc7aarch645ilp3225GetCurrentProcessorNumberEv
    .type    _ZN2nn3svc7aarch645ilp3225GetCurrentProcessorNumberEv, %function
_ZN2nn3svc7aarch645ilp3225GetCurrentProcessorNumberEv:

    svc      #NN_SVC_ID_GET_CURRENT_PROCESSOR_NUMBER
    ret

    .size _ZN2nn3svc7aarch645ilp3225GetCurrentProcessorNumberEv, [.-_ZN2nn3svc7aarch645ilp3225GetCurrentProcessorNumberEv]


//-------------------------------------------------
// Result SignalEvent(nn::svc::Handle event)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 event    Register 0       4 event
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3211SignalEventENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3211SignalEventENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp3211SignalEventENS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp3211SignalEventENS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp3211SignalEventENS0_6HandleE:

    svc      #NN_SVC_ID_SIGNAL_EVENT
    ret

    .size _ZN2nn3svc7aarch645ilp3211SignalEventENS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp3211SignalEventENS0_6HandleE]


//-------------------------------------------------
// Result ClearEvent(nn::svc::Handle event)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 event    Register 0       4 event
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3210ClearEventENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3210ClearEventENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp3210ClearEventENS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp3210ClearEventENS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp3210ClearEventENS0_6HandleE:

    svc      #NN_SVC_ID_CLEAR_EVENT
    ret

    .size _ZN2nn3svc7aarch645ilp3210ClearEventENS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp3210ClearEventENS0_6HandleE]


//-------------------------------------------------
// Result MapSharedMemory(nn::svc::Handle handle, uintptr_t addr, size_t size, nn::svc::MemoryPermission myPermission)
//
//     AArch64 s=8 r=8 p=4               Invariant s=8 r=8 p=8
// in  abi                               svc
//     Register 0       4 handle         Register 0       4 handle
//     Register 1       4 addr           Register 1       8 addr
//     Register 2       4 size           Register 2       8 size
//     Register 3       4 myPermission   Register 3       4 myPermission
//
// out abi                               svc
//     Register 0       4 return         Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3215MapSharedMemoryENS0_6HandleEmmNS0_16MemoryPermissionE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3215MapSharedMemoryENS0_6HandleEmmNS0_16MemoryPermissionE
    .hidden  _ZN2nn3svc7aarch645ilp3215MapSharedMemoryENS0_6HandleEmmNS0_16MemoryPermissionE
    .type    _ZN2nn3svc7aarch645ilp3215MapSharedMemoryENS0_6HandleEmmNS0_16MemoryPermissionE, %function
_ZN2nn3svc7aarch645ilp3215MapSharedMemoryENS0_6HandleEmmNS0_16MemoryPermissionE:

    svc      #NN_SVC_ID_MAP_SHARED_MEMORY
    ret

    .size _ZN2nn3svc7aarch645ilp3215MapSharedMemoryENS0_6HandleEmmNS0_16MemoryPermissionE, [.-_ZN2nn3svc7aarch645ilp3215MapSharedMemoryENS0_6HandleEmmNS0_16MemoryPermissionE]


//-------------------------------------------------
// Result UnmapSharedMemory(nn::svc::Handle handle, uintptr_t addr, size_t size)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 handle   Register 0       4 handle
//     Register 1       4 addr     Register 1       8 addr
//     Register 2       4 size     Register 2       8 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3217UnmapSharedMemoryENS0_6HandleEmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3217UnmapSharedMemoryENS0_6HandleEmm
    .hidden  _ZN2nn3svc7aarch645ilp3217UnmapSharedMemoryENS0_6HandleEmm
    .type    _ZN2nn3svc7aarch645ilp3217UnmapSharedMemoryENS0_6HandleEmm, %function
_ZN2nn3svc7aarch645ilp3217UnmapSharedMemoryENS0_6HandleEmm:

    svc      #NN_SVC_ID_UNMAP_SHARED_MEMORY
    ret

    .size _ZN2nn3svc7aarch645ilp3217UnmapSharedMemoryENS0_6HandleEmm, [.-_ZN2nn3svc7aarch645ilp3217UnmapSharedMemoryENS0_6HandleEmm]


//-------------------------------------------------
// Result CreateTransferMemory(nn::svc::Handle* pOut, uintptr_t addr, size_t size, nn::svc::MemoryPermission myPermission)
//
//     AArch64 s=8 r=8 p=4               Invariant s=8 r=8 p=8
// in  abi                               svc
//     Register 0  ref  4 pOut           
//     Register 1       4 addr           Register 1       8 addr
//     Register 2       4 size           Register 2       8 size
//     Register 3       4 myPermission   Register 3       4 myPermission
//
// out abi                               svc
//     Register 0       4 return         Register 0       4 return
//                                       Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp3220CreateTransferMemoryEPNS0_6HandleEmmNS0_16MemoryPermissionE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3220CreateTransferMemoryEPNS0_6HandleEmmNS0_16MemoryPermissionE
    .hidden  _ZN2nn3svc7aarch645ilp3220CreateTransferMemoryEPNS0_6HandleEmmNS0_16MemoryPermissionE
    .type    _ZN2nn3svc7aarch645ilp3220CreateTransferMemoryEPNS0_6HandleEmmNS0_16MemoryPermissionE, %function
_ZN2nn3svc7aarch645ilp3220CreateTransferMemoryEPNS0_6HandleEmmNS0_16MemoryPermissionE:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_CREATE_TRANSFER_MEMORY

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3220CreateTransferMemoryEPNS0_6HandleEmmNS0_16MemoryPermissionE, [.-_ZN2nn3svc7aarch645ilp3220CreateTransferMemoryEPNS0_6HandleEmmNS0_16MemoryPermissionE]


//-------------------------------------------------
// Result CloseHandle(nn::svc::Handle handle)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 handle   Register 0       4 handle
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3211CloseHandleENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3211CloseHandleENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp3211CloseHandleENS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp3211CloseHandleENS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp3211CloseHandleENS0_6HandleE:

    svc      #NN_SVC_ID_CLOSE_HANDLE
    ret

    .size _ZN2nn3svc7aarch645ilp3211CloseHandleENS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp3211CloseHandleENS0_6HandleE]


//-------------------------------------------------
// Result ResetSignal(nn::svc::Handle handle)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 handle   Register 0       4 handle
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3211ResetSignalENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3211ResetSignalENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp3211ResetSignalENS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp3211ResetSignalENS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp3211ResetSignalENS0_6HandleE:

    svc      #NN_SVC_ID_RESET_SIGNAL
    ret

    .size _ZN2nn3svc7aarch645ilp3211ResetSignalENS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp3211ResetSignalENS0_6HandleE]


//-------------------------------------------------
// Result WaitSynchronization(int32_t* pOut, const nn::svc::Handle handles[], int32_t numHandles, int64_t ns)
//
//     AArch64 s=8 r=8 p=4             Invariant s=8 r=8 p=8
// in  abi                             svc
//     Register 0  ref  4 pOut         
//     Register 1  ref -- handles      Register 1  ref -- handles
//     Register 2       4 numHandles   Register 2       4 numHandles
//     Register 3       8 ns           Register 3       8 ns
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//                                     Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp3219WaitSynchronizationEPiPKNS0_6HandleEix, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3219WaitSynchronizationEPiPKNS0_6HandleEix
    .hidden  _ZN2nn3svc7aarch645ilp3219WaitSynchronizationEPiPKNS0_6HandleEix
    .type    _ZN2nn3svc7aarch645ilp3219WaitSynchronizationEPiPKNS0_6HandleEix, %function
_ZN2nn3svc7aarch645ilp3219WaitSynchronizationEPiPKNS0_6HandleEix:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_WAIT_SYNCHRONIZATION

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3219WaitSynchronizationEPiPKNS0_6HandleEix, [.-_ZN2nn3svc7aarch645ilp3219WaitSynchronizationEPiPKNS0_6HandleEix]


//-------------------------------------------------
// Result CancelSynchronization(nn::svc::Handle handle)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 handle   Register 0       4 handle
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3221CancelSynchronizationENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3221CancelSynchronizationENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp3221CancelSynchronizationENS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp3221CancelSynchronizationENS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp3221CancelSynchronizationENS0_6HandleE:

    svc      #NN_SVC_ID_CANCEL_SYNCHRONIZATION
    ret

    .size _ZN2nn3svc7aarch645ilp3221CancelSynchronizationENS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp3221CancelSynchronizationENS0_6HandleE]


//-------------------------------------------------
// Result ArbitrateLock(nn::svc::Handle handle, uintptr_t addr, nn::Bit32 ownValue)
//
//     AArch64 s=8 r=8 p=4           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0       4 handle     Register 0       4 handle
//     Register 1       4 addr       Register 1       8 addr
//     Register 2       4 ownValue   Register 2       4 ownValue
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3213ArbitrateLockENS0_6HandleEmj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3213ArbitrateLockENS0_6HandleEmj
    .hidden  _ZN2nn3svc7aarch645ilp3213ArbitrateLockENS0_6HandleEmj
    .type    _ZN2nn3svc7aarch645ilp3213ArbitrateLockENS0_6HandleEmj, %function
_ZN2nn3svc7aarch645ilp3213ArbitrateLockENS0_6HandleEmj:

    svc      #NN_SVC_ID_ARBITRATE_LOCK
    ret

    .size _ZN2nn3svc7aarch645ilp3213ArbitrateLockENS0_6HandleEmj, [.-_ZN2nn3svc7aarch645ilp3213ArbitrateLockENS0_6HandleEmj]


//-------------------------------------------------
// Result ArbitrateUnlock(uintptr_t addr)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 addr     Register 0       8 addr
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3215ArbitrateUnlockEm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3215ArbitrateUnlockEm
    .hidden  _ZN2nn3svc7aarch645ilp3215ArbitrateUnlockEm
    .type    _ZN2nn3svc7aarch645ilp3215ArbitrateUnlockEm, %function
_ZN2nn3svc7aarch645ilp3215ArbitrateUnlockEm:

    svc      #NN_SVC_ID_ARBITRATE_UNLOCK
    ret

    .size _ZN2nn3svc7aarch645ilp3215ArbitrateUnlockEm, [.-_ZN2nn3svc7aarch645ilp3215ArbitrateUnlockEm]


//-------------------------------------------------
// Result WaitProcessWideKeyAtomic(uintptr_t addr, uintptr_t cvKey, nn::Bit32 ownValue, int64_t ns)
//
//     AArch64 s=8 r=8 p=4           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0       4 addr       Register 0       8 addr
//     Register 1       4 cvKey      Register 1       8 cvKey
//     Register 2       4 ownValue   Register 2       4 ownValue
//     Register 3       8 ns         Register 3       8 ns
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3224WaitProcessWideKeyAtomicEmmjx, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3224WaitProcessWideKeyAtomicEmmjx
    .hidden  _ZN2nn3svc7aarch645ilp3224WaitProcessWideKeyAtomicEmmjx
    .type    _ZN2nn3svc7aarch645ilp3224WaitProcessWideKeyAtomicEmmjx, %function
_ZN2nn3svc7aarch645ilp3224WaitProcessWideKeyAtomicEmmjx:

    svc      #NN_SVC_ID_WAIT_PROCESS_WIDE_KEY_ATOMIC
    ret

    .size _ZN2nn3svc7aarch645ilp3224WaitProcessWideKeyAtomicEmmjx, [.-_ZN2nn3svc7aarch645ilp3224WaitProcessWideKeyAtomicEmmjx]


//-------------------------------------------------
// void SignalProcessWideKey(uintptr_t cvKey, int32_t num)
//
//     AArch64 s=8 r=8 p=4        Invariant s=8 r=8 p=8
// in  abi                        svc
//     Register 0       4 cvKey   Register 0       8 cvKey
//     Register 1       4 num     Register 1       4 num
//
// out abi                        svc
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3220SignalProcessWideKeyEmi, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3220SignalProcessWideKeyEmi
    .hidden  _ZN2nn3svc7aarch645ilp3220SignalProcessWideKeyEmi
    .type    _ZN2nn3svc7aarch645ilp3220SignalProcessWideKeyEmi, %function
_ZN2nn3svc7aarch645ilp3220SignalProcessWideKeyEmi:

    svc      #NN_SVC_ID_SIGNAL_PROCESS_WIDE_KEY
    ret

    .size _ZN2nn3svc7aarch645ilp3220SignalProcessWideKeyEmi, [.-_ZN2nn3svc7aarch645ilp3220SignalProcessWideKeyEmi]


//-------------------------------------------------
// int64_t GetSystemTick()
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//
// out abi                         svc
//     Register 0       8 return   Register 0       8 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3213GetSystemTickEv, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3213GetSystemTickEv
    .hidden  _ZN2nn3svc7aarch645ilp3213GetSystemTickEv
    .type    _ZN2nn3svc7aarch645ilp3213GetSystemTickEv, %function
_ZN2nn3svc7aarch645ilp3213GetSystemTickEv:

    svc      #NN_SVC_ID_GET_SYSTEM_TICK
    ret

    .size _ZN2nn3svc7aarch645ilp3213GetSystemTickEv, [.-_ZN2nn3svc7aarch645ilp3213GetSystemTickEv]


//-------------------------------------------------
// Result ConnectToNamedPort(nn::svc::Handle* pOut, const char name[])
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0  ref  4 pOut     
//     Register 1  ref -- name     Register 1  ref -- name
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp3218ConnectToNamedPortEPNS0_6HandleEPKc, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3218ConnectToNamedPortEPNS0_6HandleEPKc
    .hidden  _ZN2nn3svc7aarch645ilp3218ConnectToNamedPortEPNS0_6HandleEPKc
    .type    _ZN2nn3svc7aarch645ilp3218ConnectToNamedPortEPNS0_6HandleEPKc, %function
_ZN2nn3svc7aarch645ilp3218ConnectToNamedPortEPNS0_6HandleEPKc:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_CONNECT_TO_NAMED_PORT

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3218ConnectToNamedPortEPNS0_6HandleEPKc, [.-_ZN2nn3svc7aarch645ilp3218ConnectToNamedPortEPNS0_6HandleEPKc]


//-------------------------------------------------
// Result SendSyncRequestLight(nn::svc::Handle session)
//
//     AArch64 s=8 r=8 p=4          Invariant s=8 r=8 p=8
// in  abi                          svc
//     Register 0       4 session   Register 0       4 session
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3220SendSyncRequestLightENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3220SendSyncRequestLightENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp3220SendSyncRequestLightENS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp3220SendSyncRequestLightENS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp3220SendSyncRequestLightENS0_6HandleE:

    svc      #NN_SVC_ID_SEND_SYNC_REQUEST_LIGHT
    ret

    .size _ZN2nn3svc7aarch645ilp3220SendSyncRequestLightENS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp3220SendSyncRequestLightENS0_6HandleE]


//-------------------------------------------------
// Result SendSyncRequest(nn::svc::Handle session)
//
//     AArch64 s=8 r=8 p=4          Invariant s=8 r=8 p=8
// in  abi                          svc
//     Register 0       4 session   Register 0       4 session
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3215SendSyncRequestENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3215SendSyncRequestENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp3215SendSyncRequestENS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp3215SendSyncRequestENS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp3215SendSyncRequestENS0_6HandleE:

    svc      #NN_SVC_ID_SEND_SYNC_REQUEST
    ret

    .size _ZN2nn3svc7aarch645ilp3215SendSyncRequestENS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp3215SendSyncRequestENS0_6HandleE]


//-------------------------------------------------
// Result SendSyncRequestWithUserBuffer(uintptr_t pMessage, size_t bufferSize, nn::svc::Handle session)
//
//     AArch64 s=8 r=8 p=4             Invariant s=8 r=8 p=8
// in  abi                             svc
//     Register 0       4 pMessage     Register 0       8 pMessage
//     Register 1       4 bufferSize   Register 1       8 bufferSize
//     Register 2       4 session      Register 2       4 session
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3229SendSyncRequestWithUserBufferEmmNS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3229SendSyncRequestWithUserBufferEmmNS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp3229SendSyncRequestWithUserBufferEmmNS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp3229SendSyncRequestWithUserBufferEmmNS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp3229SendSyncRequestWithUserBufferEmmNS0_6HandleE:

    svc      #NN_SVC_ID_SEND_SYNC_REQUEST_WITH_USER_BUFFER
    ret

    .size _ZN2nn3svc7aarch645ilp3229SendSyncRequestWithUserBufferEmmNS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp3229SendSyncRequestWithUserBufferEmmNS0_6HandleE]


//-------------------------------------------------
// Result SendAsyncRequestWithUserBuffer(nn::svc::Handle* pEvent, uintptr_t pMessage, size_t bufferSize, nn::svc::Handle session)
//
//     AArch64 s=8 r=8 p=4             Invariant s=8 r=8 p=8
// in  abi                             svc
//     Register 0  ref  4 pEvent       
//     Register 1       4 pMessage     Register 1       8 pMessage
//     Register 2       4 bufferSize   Register 2       8 bufferSize
//     Register 3       4 session      Register 3       4 session
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//                                     Register 1       4 pEvent
//
// conversion
//   Scatter         pEvent

    .section .text._ZN2nn3svc7aarch645ilp3230SendAsyncRequestWithUserBufferEPNS0_6HandleEmmS3_, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3230SendAsyncRequestWithUserBufferEPNS0_6HandleEmmS3_
    .hidden  _ZN2nn3svc7aarch645ilp3230SendAsyncRequestWithUserBufferEPNS0_6HandleEmmS3_
    .type    _ZN2nn3svc7aarch645ilp3230SendAsyncRequestWithUserBufferEPNS0_6HandleEmmS3_, %function
_ZN2nn3svc7aarch645ilp3230SendAsyncRequestWithUserBufferEPNS0_6HandleEmmS3_:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_SEND_ASYNC_REQUEST_WITH_USER_BUFFER

    ldr      x2, [sp, #0]              // pEventのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pEvent の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3230SendAsyncRequestWithUserBufferEPNS0_6HandleEmmS3_, [.-_ZN2nn3svc7aarch645ilp3230SendAsyncRequestWithUserBufferEPNS0_6HandleEmmS3_]


//-------------------------------------------------
// Result GetProcessId(nn::Bit64* pOut, nn::svc::Handle process)
//
//     AArch64 s=8 r=8 p=4          Invariant s=8 r=8 p=8
// in  abi                          svc
//     Register 0  ref  8 pOut      
//     Register 1       4 process   Register 1       4 process
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//                                  Register 1       8 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp3212GetProcessIdEPyNS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3212GetProcessIdEPyNS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp3212GetProcessIdEPyNS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp3212GetProcessIdEPyNS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp3212GetProcessIdEPyNS0_6HandleE:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_GET_PROCESS_ID

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      x1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3212GetProcessIdEPyNS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp3212GetProcessIdEPyNS0_6HandleE]


//-------------------------------------------------
// Result GetThreadId(nn::Bit64* pOut, nn::svc::Handle thread)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0  ref  8 pOut     
//     Register 1       4 thread   Register 1       4 thread
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       8 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp3211GetThreadIdEPyNS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3211GetThreadIdEPyNS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp3211GetThreadIdEPyNS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp3211GetThreadIdEPyNS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp3211GetThreadIdEPyNS0_6HandleE:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_GET_THREAD_ID

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      x1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3211GetThreadIdEPyNS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp3211GetThreadIdEPyNS0_6HandleE]


//-------------------------------------------------
// void Break(nn::svc::BreakReason reason, uintptr_t data, size_t length)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 reason   Register 0       4 reason
//     Register 1       4 data     Register 1       8 data
//     Register 2       4 length   Register 2       8 length
//
// out abi                         svc
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp325BreakENS0_11BreakReasonEmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp325BreakENS0_11BreakReasonEmm
    .hidden  _ZN2nn3svc7aarch645ilp325BreakENS0_11BreakReasonEmm
    .type    _ZN2nn3svc7aarch645ilp325BreakENS0_11BreakReasonEmm, %function
_ZN2nn3svc7aarch645ilp325BreakENS0_11BreakReasonEmm:

    svc      #NN_SVC_ID_BREAK
    ret

    .size _ZN2nn3svc7aarch645ilp325BreakENS0_11BreakReasonEmm, [.-_ZN2nn3svc7aarch645ilp325BreakENS0_11BreakReasonEmm]


//-------------------------------------------------
// Result OutputDebugString(const char text[], size_t length)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0  ref -- text     Register 0  ref -- text
//     Register 1       4 length   Register 1       8 length
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3217OutputDebugStringEPKcm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3217OutputDebugStringEPKcm
    .hidden  _ZN2nn3svc7aarch645ilp3217OutputDebugStringEPKcm
    .type    _ZN2nn3svc7aarch645ilp3217OutputDebugStringEPKcm, %function
_ZN2nn3svc7aarch645ilp3217OutputDebugStringEPKcm:

    svc      #NN_SVC_ID_OUTPUT_DEBUG_STRING
    ret

    .size _ZN2nn3svc7aarch645ilp3217OutputDebugStringEPKcm, [.-_ZN2nn3svc7aarch645ilp3217OutputDebugStringEPKcm]


//-------------------------------------------------
// void ReturnFromException(nn::Result result)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 result   Register 0       4 result
//
// out abi                         svc
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3219ReturnFromExceptionENS_6ResultE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3219ReturnFromExceptionENS_6ResultE
    .hidden  _ZN2nn3svc7aarch645ilp3219ReturnFromExceptionENS_6ResultE
    .type    _ZN2nn3svc7aarch645ilp3219ReturnFromExceptionENS_6ResultE, %function
_ZN2nn3svc7aarch645ilp3219ReturnFromExceptionENS_6ResultE:

    svc      #NN_SVC_ID_RETURN_FROM_EXCEPTION
    ret

    .size _ZN2nn3svc7aarch645ilp3219ReturnFromExceptionENS_6ResultE, [.-_ZN2nn3svc7aarch645ilp3219ReturnFromExceptionENS_6ResultE]


//-------------------------------------------------
// Result GetInfo(nn::Bit64* pOut, nn::svc::InfoType type, nn::svc::Handle handle, nn::Bit64 param)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0  ref  8 pOut     
//     Register 1       4 type     Register 1       4 type
//     Register 2       4 handle   Register 2       4 handle
//     Register 3       8 param    Register 3       8 param
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       8 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp327GetInfoEPyNS0_8InfoTypeENS0_6HandleEy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp327GetInfoEPyNS0_8InfoTypeENS0_6HandleEy
    .hidden  _ZN2nn3svc7aarch645ilp327GetInfoEPyNS0_8InfoTypeENS0_6HandleEy
    .type    _ZN2nn3svc7aarch645ilp327GetInfoEPyNS0_8InfoTypeENS0_6HandleEy, %function
_ZN2nn3svc7aarch645ilp327GetInfoEPyNS0_8InfoTypeENS0_6HandleEy:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_GET_INFO

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      x1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp327GetInfoEPyNS0_8InfoTypeENS0_6HandleEy, [.-_ZN2nn3svc7aarch645ilp327GetInfoEPyNS0_8InfoTypeENS0_6HandleEy]


//-------------------------------------------------
// void FlushEntireDataCache()
//
//     AArch64 s=8 r=8 p=4   Invariant s=8 r=8 p=8
// in  abi   svc
//
// out abi   svc
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3220FlushEntireDataCacheEv, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3220FlushEntireDataCacheEv
    .hidden  _ZN2nn3svc7aarch645ilp3220FlushEntireDataCacheEv
    .type    _ZN2nn3svc7aarch645ilp3220FlushEntireDataCacheEv, %function
_ZN2nn3svc7aarch645ilp3220FlushEntireDataCacheEv:

    svc      #NN_SVC_ID_FLUSH_ENTIRE_DATA_CACHE
    ret

    .size _ZN2nn3svc7aarch645ilp3220FlushEntireDataCacheEv, [.-_ZN2nn3svc7aarch645ilp3220FlushEntireDataCacheEv]


//-------------------------------------------------
// Result FlushDataCache(uintptr_t addr, size_t size)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 addr     Register 0       8 addr
//     Register 1       4 size     Register 1       8 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3214FlushDataCacheEmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3214FlushDataCacheEmm
    .hidden  _ZN2nn3svc7aarch645ilp3214FlushDataCacheEmm
    .type    _ZN2nn3svc7aarch645ilp3214FlushDataCacheEmm, %function
_ZN2nn3svc7aarch645ilp3214FlushDataCacheEmm:

    svc      #NN_SVC_ID_FLUSH_DATA_CACHE
    ret

    .size _ZN2nn3svc7aarch645ilp3214FlushDataCacheEmm, [.-_ZN2nn3svc7aarch645ilp3214FlushDataCacheEmm]


//-------------------------------------------------
// Result MapPhysicalMemory(uintptr_t addr, size_t size)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 addr     Register 0       8 addr
//     Register 1       4 size     Register 1       8 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3217MapPhysicalMemoryEmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3217MapPhysicalMemoryEmm
    .hidden  _ZN2nn3svc7aarch645ilp3217MapPhysicalMemoryEmm
    .type    _ZN2nn3svc7aarch645ilp3217MapPhysicalMemoryEmm, %function
_ZN2nn3svc7aarch645ilp3217MapPhysicalMemoryEmm:

    svc      #NN_SVC_ID_MAP_PHYSICAL_MEMORY
    ret

    .size _ZN2nn3svc7aarch645ilp3217MapPhysicalMemoryEmm, [.-_ZN2nn3svc7aarch645ilp3217MapPhysicalMemoryEmm]


//-------------------------------------------------
// Result UnmapPhysicalMemory(uintptr_t addr, size_t size)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 addr     Register 0       8 addr
//     Register 1       4 size     Register 1       8 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3219UnmapPhysicalMemoryEmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3219UnmapPhysicalMemoryEmm
    .hidden  _ZN2nn3svc7aarch645ilp3219UnmapPhysicalMemoryEmm
    .type    _ZN2nn3svc7aarch645ilp3219UnmapPhysicalMemoryEmm, %function
_ZN2nn3svc7aarch645ilp3219UnmapPhysicalMemoryEmm:

    svc      #NN_SVC_ID_UNMAP_PHYSICAL_MEMORY
    ret

    .size _ZN2nn3svc7aarch645ilp3219UnmapPhysicalMemoryEmm, [.-_ZN2nn3svc7aarch645ilp3219UnmapPhysicalMemoryEmm]


//-------------------------------------------------
// Result GetLastThreadInfo(nn::svc::lp64::LastThreadContext* pContext, uintptr_t* pTlsAddr, nn::Bit32* pFlag)
//
//     AArch64 s=8 r=8 p=4           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0  ref 32 pContext   
//     Register 1  ref  4 pTlsAddr   
//     Register 2  ref  4 pFlag      
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//                                   Register 1      32 pContext
//                                   Register 2      32 pContext
//                                   Register 3      32 pContext
//                                   Register 4      32 pContext
//                                   Register 5       8 pTlsAddr
//                                   Register 6       4 pFlag
//
// conversion
//   Scatter         pContext
//   Scatter         pTlsAddr
//   Scatter         pFlag

    .section .text._ZN2nn3svc7aarch645ilp3217GetLastThreadInfoEPNS0_4lp6417LastThreadContextEPmPj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3217GetLastThreadInfoEPNS0_4lp6417LastThreadContextEPmPj
    .hidden  _ZN2nn3svc7aarch645ilp3217GetLastThreadInfoEPNS0_4lp6417LastThreadContextEPmPj
    .type    _ZN2nn3svc7aarch645ilp3217GetLastThreadInfoEPNS0_4lp6417LastThreadContextEPmPj, %function
_ZN2nn3svc7aarch645ilp3217GetLastThreadInfoEPNS0_4lp6417LastThreadContextEPmPj:

    str      x2, [sp, #-16]!
    stp      x0, x1, [sp, #-16]!

    svc      #NN_SVC_ID_GET_LAST_THREAD_INFO

    ldr      x7, [sp, #0]              // pContextのアドレス をスタックからレジスタへ
    str      x1, [x7, #0]              // pContext の第 1 ワードをレジスタからメモリへ
    str      x2, [x7, #8]              // pContext の第 2 ワードをレジスタからメモリへ
    str      x3, [x7, #16]             // pContext の第 3 ワードをレジスタからメモリへ
    str      x4, [x7, #24]             // pContext の第 4 ワードをレジスタからメモリへ
    ldr      x7, [sp, #8]              // pTlsAddrのアドレス をスタックからレジスタへ
    str      w5, [x7, #0]              // pTlsAddr の第 1 ワードをレジスタからメモリへ
    ldr      x7, [sp, #16]             // pFlagのアドレス をスタックからレジスタへ
    str      w6, [x7, #0]              // pFlag の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #32
    ret

    .size _ZN2nn3svc7aarch645ilp3217GetLastThreadInfoEPNS0_4lp6417LastThreadContextEPmPj, [.-_ZN2nn3svc7aarch645ilp3217GetLastThreadInfoEPNS0_4lp6417LastThreadContextEPmPj]


//-------------------------------------------------
// Result GetResourceLimitLimitValue(int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource)
//
//     AArch64 s=8 r=8 p=4                Invariant s=8 r=8 p=8
// in  abi                                svc
//     Register 0  ref  8 value           
//     Register 1       4 resourceLimit   Register 1       4 resourceLimit
//     Register 2       4 resource        Register 2       4 resource
//
// out abi                                svc
//     Register 0       4 return          Register 0       4 return
//                                        Register 1       8 value
//
// conversion
//   Scatter         value

    .section .text._ZN2nn3svc7aarch645ilp3226GetResourceLimitLimitValueEPxNS0_6HandleENS0_17LimitableResourceE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3226GetResourceLimitLimitValueEPxNS0_6HandleENS0_17LimitableResourceE
    .hidden  _ZN2nn3svc7aarch645ilp3226GetResourceLimitLimitValueEPxNS0_6HandleENS0_17LimitableResourceE
    .type    _ZN2nn3svc7aarch645ilp3226GetResourceLimitLimitValueEPxNS0_6HandleENS0_17LimitableResourceE, %function
_ZN2nn3svc7aarch645ilp3226GetResourceLimitLimitValueEPxNS0_6HandleENS0_17LimitableResourceE:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_GET_RESOURCE_LIMIT_LIMIT_VALUE

    ldr      x2, [sp, #0]              // valueのアドレス をスタックからレジスタへ
    str      x1, [x2, #0]              // value の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3226GetResourceLimitLimitValueEPxNS0_6HandleENS0_17LimitableResourceE, [.-_ZN2nn3svc7aarch645ilp3226GetResourceLimitLimitValueEPxNS0_6HandleENS0_17LimitableResourceE]


//-------------------------------------------------
// Result GetResourceLimitCurrentValue(int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource)
//
//     AArch64 s=8 r=8 p=4                Invariant s=8 r=8 p=8
// in  abi                                svc
//     Register 0  ref  8 value           
//     Register 1       4 resourceLimit   Register 1       4 resourceLimit
//     Register 2       4 resource        Register 2       4 resource
//
// out abi                                svc
//     Register 0       4 return          Register 0       4 return
//                                        Register 1       8 value
//
// conversion
//   Scatter         value

    .section .text._ZN2nn3svc7aarch645ilp3228GetResourceLimitCurrentValueEPxNS0_6HandleENS0_17LimitableResourceE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3228GetResourceLimitCurrentValueEPxNS0_6HandleENS0_17LimitableResourceE
    .hidden  _ZN2nn3svc7aarch645ilp3228GetResourceLimitCurrentValueEPxNS0_6HandleENS0_17LimitableResourceE
    .type    _ZN2nn3svc7aarch645ilp3228GetResourceLimitCurrentValueEPxNS0_6HandleENS0_17LimitableResourceE, %function
_ZN2nn3svc7aarch645ilp3228GetResourceLimitCurrentValueEPxNS0_6HandleENS0_17LimitableResourceE:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_GET_RESOURCE_LIMIT_CURRENT_VALUE

    ldr      x2, [sp, #0]              // valueのアドレス をスタックからレジスタへ
    str      x1, [x2, #0]              // value の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3228GetResourceLimitCurrentValueEPxNS0_6HandleENS0_17LimitableResourceE, [.-_ZN2nn3svc7aarch645ilp3228GetResourceLimitCurrentValueEPxNS0_6HandleENS0_17LimitableResourceE]


//-------------------------------------------------
// Result SetThreadActivity(nn::svc::Handle handle, nn::svc::ThreadActivity activity)
//
//     AArch64 s=8 r=8 p=4           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0       4 handle     Register 0       4 handle
//     Register 1       4 activity   Register 1       4 activity
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3217SetThreadActivityENS0_6HandleENS0_14ThreadActivityE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3217SetThreadActivityENS0_6HandleENS0_14ThreadActivityE
    .hidden  _ZN2nn3svc7aarch645ilp3217SetThreadActivityENS0_6HandleENS0_14ThreadActivityE
    .type    _ZN2nn3svc7aarch645ilp3217SetThreadActivityENS0_6HandleENS0_14ThreadActivityE, %function
_ZN2nn3svc7aarch645ilp3217SetThreadActivityENS0_6HandleENS0_14ThreadActivityE:

    svc      #NN_SVC_ID_SET_THREAD_ACTIVITY
    ret

    .size _ZN2nn3svc7aarch645ilp3217SetThreadActivityENS0_6HandleENS0_14ThreadActivityE, [.-_ZN2nn3svc7aarch645ilp3217SetThreadActivityENS0_6HandleENS0_14ThreadActivityE]


//-------------------------------------------------
// Result GetThreadContext3(nn::svc::ThreadContext* pContext, nn::svc::Handle handle)
//
//     AArch64 s=8 r=8 p=4            Invariant s=8 r=8 p=8
// in  abi                            svc
//     Register 0  ref 332 pContext   Register 0  ref 332 pContext
//     Register 1       4 handle      Register 1       4 handle
//
// out abi                            svc
//     Register 0       4 return      Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3217GetThreadContext3EPNS0_13ThreadContextENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3217GetThreadContext3EPNS0_13ThreadContextENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp3217GetThreadContext3EPNS0_13ThreadContextENS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp3217GetThreadContext3EPNS0_13ThreadContextENS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp3217GetThreadContext3EPNS0_13ThreadContextENS0_6HandleE:

    svc      #NN_SVC_ID_GET_THREAD_CONTEXT3
    ret

    .size _ZN2nn3svc7aarch645ilp3217GetThreadContext3EPNS0_13ThreadContextENS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp3217GetThreadContext3EPNS0_13ThreadContextENS0_6HandleE]


//-------------------------------------------------
// Result WaitForAddress(uintptr_t addr, nn::svc::ArbitrationType type, int32_t value, int64_t ns)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 addr     Register 0       8 addr
//     Register 1       4 type     Register 1       4 type
//     Register 2       4 value    Register 2       4 value
//     Register 3       8 ns       Register 3       8 ns
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3214WaitForAddressEmNS0_15ArbitrationTypeEix, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3214WaitForAddressEmNS0_15ArbitrationTypeEix
    .hidden  _ZN2nn3svc7aarch645ilp3214WaitForAddressEmNS0_15ArbitrationTypeEix
    .type    _ZN2nn3svc7aarch645ilp3214WaitForAddressEmNS0_15ArbitrationTypeEix, %function
_ZN2nn3svc7aarch645ilp3214WaitForAddressEmNS0_15ArbitrationTypeEix:

    svc      #NN_SVC_ID_WAIT_FOR_ADDRESS
    ret

    .size _ZN2nn3svc7aarch645ilp3214WaitForAddressEmNS0_15ArbitrationTypeEix, [.-_ZN2nn3svc7aarch645ilp3214WaitForAddressEmNS0_15ArbitrationTypeEix]


//-------------------------------------------------
// Result SignalToAddress(uintptr_t addr, nn::svc::SignalType type, int32_t value, int32_t num)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 addr     Register 0       8 addr
//     Register 1       4 type     Register 1       4 type
//     Register 2       4 value    Register 2       4 value
//     Register 3       4 num      Register 3       4 num
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3215SignalToAddressEmNS0_10SignalTypeEii, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3215SignalToAddressEmNS0_10SignalTypeEii
    .hidden  _ZN2nn3svc7aarch645ilp3215SignalToAddressEmNS0_10SignalTypeEii
    .type    _ZN2nn3svc7aarch645ilp3215SignalToAddressEmNS0_10SignalTypeEii, %function
_ZN2nn3svc7aarch645ilp3215SignalToAddressEmNS0_10SignalTypeEii:

    svc      #NN_SVC_ID_SIGNAL_TO_ADDRESS
    ret

    .size _ZN2nn3svc7aarch645ilp3215SignalToAddressEmNS0_10SignalTypeEii, [.-_ZN2nn3svc7aarch645ilp3215SignalToAddressEmNS0_10SignalTypeEii]


//-------------------------------------------------
// void KernelDebug(nn::svc::KernelDebugType type, nn::Bit64 param0, nn::Bit64 param1, nn::Bit64 param2)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 type     Register 0       4 type
//     Register 1       8 param0   Register 1       8 param0
//     Register 2       8 param1   Register 2       8 param1
//     Register 3       8 param2   Register 3       8 param2
//
// out abi                         svc
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3211KernelDebugENS0_15KernelDebugTypeEyyy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3211KernelDebugENS0_15KernelDebugTypeEyyy
    .hidden  _ZN2nn3svc7aarch645ilp3211KernelDebugENS0_15KernelDebugTypeEyyy
    .type    _ZN2nn3svc7aarch645ilp3211KernelDebugENS0_15KernelDebugTypeEyyy, %function
_ZN2nn3svc7aarch645ilp3211KernelDebugENS0_15KernelDebugTypeEyyy:

    svc      #NN_SVC_ID_KERNEL_DEBUG
    ret

    .size _ZN2nn3svc7aarch645ilp3211KernelDebugENS0_15KernelDebugTypeEyyy, [.-_ZN2nn3svc7aarch645ilp3211KernelDebugENS0_15KernelDebugTypeEyyy]


//-------------------------------------------------
// void ChangeKernelTraceState(nn::svc::KernelTraceState state)
//
//     AArch64 s=8 r=8 p=4        Invariant s=8 r=8 p=8
// in  abi                        svc
//     Register 0       4 state   Register 0       4 state
//
// out abi                        svc
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3222ChangeKernelTraceStateENS0_16KernelTraceStateE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3222ChangeKernelTraceStateENS0_16KernelTraceStateE
    .hidden  _ZN2nn3svc7aarch645ilp3222ChangeKernelTraceStateENS0_16KernelTraceStateE
    .type    _ZN2nn3svc7aarch645ilp3222ChangeKernelTraceStateENS0_16KernelTraceStateE, %function
_ZN2nn3svc7aarch645ilp3222ChangeKernelTraceStateENS0_16KernelTraceStateE:

    svc      #NN_SVC_ID_CHANGE_KERNEL_TRACE_STATE
    ret

    .size _ZN2nn3svc7aarch645ilp3222ChangeKernelTraceStateENS0_16KernelTraceStateE, [.-_ZN2nn3svc7aarch645ilp3222ChangeKernelTraceStateENS0_16KernelTraceStateE]


//-------------------------------------------------
// Result CreateCodeMemory(nn::svc::Handle* pOut, uintptr_t addr, size_t size)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0  ref  4 pOut     
//     Register 1       4 addr     Register 1       8 addr
//     Register 2       4 size     Register 2       8 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp3216CreateCodeMemoryEPNS0_6HandleEmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3216CreateCodeMemoryEPNS0_6HandleEmm
    .hidden  _ZN2nn3svc7aarch645ilp3216CreateCodeMemoryEPNS0_6HandleEmm
    .type    _ZN2nn3svc7aarch645ilp3216CreateCodeMemoryEPNS0_6HandleEmm, %function
_ZN2nn3svc7aarch645ilp3216CreateCodeMemoryEPNS0_6HandleEmm:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_CREATE_CODE_MEMORY

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3216CreateCodeMemoryEPNS0_6HandleEmm, [.-_ZN2nn3svc7aarch645ilp3216CreateCodeMemoryEPNS0_6HandleEmm]


//-------------------------------------------------
// Result ControlCodeMemory(nn::svc::Handle handle, nn::svc::CodeMemoryOperation operation, uint64_t address, uint64_t size, nn::svc::MemoryPermission permission)
//
//     AArch64 s=8 r=8 p=4             Invariant s=8 r=8 p=8
// in  abi                             svc
//     Register 0       4 handle       Register 0       4 handle
//     Register 1       4 operation    Register 1       4 operation
//     Register 2       8 address      Register 2       8 address
//     Register 3       8 size         Register 3       8 size
//     Register 4       4 permission   Register 4       4 permission
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3217ControlCodeMemoryENS0_6HandleENS0_19CodeMemoryOperationEyyNS0_16MemoryPermissionE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3217ControlCodeMemoryENS0_6HandleENS0_19CodeMemoryOperationEyyNS0_16MemoryPermissionE
    .hidden  _ZN2nn3svc7aarch645ilp3217ControlCodeMemoryENS0_6HandleENS0_19CodeMemoryOperationEyyNS0_16MemoryPermissionE
    .type    _ZN2nn3svc7aarch645ilp3217ControlCodeMemoryENS0_6HandleENS0_19CodeMemoryOperationEyyNS0_16MemoryPermissionE, %function
_ZN2nn3svc7aarch645ilp3217ControlCodeMemoryENS0_6HandleENS0_19CodeMemoryOperationEyyNS0_16MemoryPermissionE:

    svc      #NN_SVC_ID_CONTROL_CODE_MEMORY
    ret

    .size _ZN2nn3svc7aarch645ilp3217ControlCodeMemoryENS0_6HandleENS0_19CodeMemoryOperationEyyNS0_16MemoryPermissionE, [.-_ZN2nn3svc7aarch645ilp3217ControlCodeMemoryENS0_6HandleENS0_19CodeMemoryOperationEyyNS0_16MemoryPermissionE]


//-------------------------------------------------
// Result ReadWriteRegister(nn::Bit32* pOut, nn::svc::PhysicalAddress address, nn::Bit32 mask, nn::Bit32 value)
//
//     AArch64 s=8 r=8 p=4          Invariant s=8 r=8 p=8
// in  abi                          svc
//     Register 0  ref  4 pOut      
//     Register 1       8 address   Register 1       8 address
//     Register 2       4 mask      Register 2       4 mask
//     Register 3       4 value     Register 3       4 value
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//                                  Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp3217ReadWriteRegisterEPjyjj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3217ReadWriteRegisterEPjyjj
    .hidden  _ZN2nn3svc7aarch645ilp3217ReadWriteRegisterEPjyjj
    .type    _ZN2nn3svc7aarch645ilp3217ReadWriteRegisterEPjyjj, %function
_ZN2nn3svc7aarch645ilp3217ReadWriteRegisterEPjyjj:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_READ_WRITE_REGISTER

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp3217ReadWriteRegisterEPjyjj, [.-_ZN2nn3svc7aarch645ilp3217ReadWriteRegisterEPjyjj]


//-------------------------------------------------
// Result SetProcessActivity(nn::svc::Handle handle, nn::svc::ProcessActivity activity)
//
//     AArch64 s=8 r=8 p=4           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0       4 handle     Register 0       4 handle
//     Register 1       4 activity   Register 1       4 activity
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp3218SetProcessActivityENS0_6HandleENS0_15ProcessActivityE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp3218SetProcessActivityENS0_6HandleENS0_15ProcessActivityE
    .hidden  _ZN2nn3svc7aarch645ilp3218SetProcessActivityENS0_6HandleENS0_15ProcessActivityE
    .type    _ZN2nn3svc7aarch645ilp3218SetProcessActivityENS0_6HandleENS0_15ProcessActivityE, %function
_ZN2nn3svc7aarch645ilp3218SetProcessActivityENS0_6HandleENS0_15ProcessActivityE:

    svc      #NN_SVC_ID_SET_PROCESS_ACTIVITY
    ret

    .size _ZN2nn3svc7aarch645ilp3218SetProcessActivityENS0_6HandleENS0_15ProcessActivityE, [.-_ZN2nn3svc7aarch645ilp3218SetProcessActivityENS0_6HandleENS0_15ProcessActivityE]


    .end

