﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/dd.h>

namespace nn { namespace spl { namespace impl {

    class DeviceAddressMapper
    {
    public:
        DeviceAddressMapper(
            dd::DeviceAddressSpaceType*  pDas,
            uint64_t                    processAddress,
            size_t                      size,
            dd::DeviceVirtualAddress    deviceAddress,
            dd::MemoryPermission        permission
        )
            : m_pDas(pDas),
              m_ProcessAddress(processAddress),
              m_Size(size),
              m_DeviceAddress(deviceAddress)
        {
            dd::MapDeviceAddressSpaceAligned(
                m_pDas,
                dd::GetCurrentProcessHandle(),
                m_ProcessAddress,
                m_Size,
                m_DeviceAddress,
                permission );
        }
        ~DeviceAddressMapper()
        {
            dd::UnmapDeviceAddressSpace(
                m_pDas,
                dd::GetCurrentProcessHandle(),
                m_ProcessAddress,
                m_Size,
                m_DeviceAddress );
        }

    private:
        dd::DeviceAddressSpaceType* m_pDas;
        uint64_t                    m_ProcessAddress;
        size_t                      m_Size;
        dd::DeviceVirtualAddress    m_DeviceAddress;
    };

}}}  // namespace nn::spl::impl

