﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "resolver_ThreadLocalStorage.h"
#include <nn/os/os_Thread.h>
#include <nn/os/os_ThreadLocalStorage.h>
#include <nn/os/os_MutexApi.h>
#include <nn/os.h>
#include <nn/socket/resolver/private/resolver_PrivateApi.h>
#include <cstring> // for free
#include "serializer.h"
#include "serializer/serializer_Specializations.h" // for FreeHostentContents
extern "C"
{
#include <siglo/BionicPrivateApi.h>
}
#include <nn/os/os_Result.public.h>

#define LOG_MODULE_NAME "tls server" // NOLINT(preprocessor/const)
#include <nn/socket/resolver/private/resolver_DebugLog.h>

namespace nn { namespace socket { namespace resolver { namespace tls { namespace Server {

/**
 * @brief the server thread local storage destructor, currently a no-op
 */
void ServerThreadLocalStorage_dtor(void* pVoid)
{
    // currently a no-op
    return;
}

Result Initialize()
{
    Result result = ResultInternalError();

    if ((result = nn::socket::resolver::tls::Initialize() ).IsFailure())
    {
        LogDebug("Unable to initialize resolver server TLS\n");
        goto bail;
    };

    result = ResultSuccess();

bail:
    return result;
}

Result Finalize()
{
    Result result = ResultInternalError();
    if ((result = nn::socket::resolver::tls::SetServerTLS(NULL, NULL)).IsFailure())
    {
        LogDebug("Unable to finalize resolver server TLS\n");
        goto bail;
    };

    result = ResultSuccess();

bail:
    return result;
}

}}}}} //nn::socket::resolver::tls::Server
