﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

namespace nn { namespace socket { namespace resolver {

/**
 * @brief This function initializes the reference count helper.
 */
void RefCountHelperInitialize() NN_NOEXCEPT;

/**
 * @brief This function finalizes the reference count helper.
 */
void RefCountHelperFinalize() NN_NOEXCEPT;

/**
 * @brief This function increases the reference count if necessary.
 */
bool IncrementSocketIfNeeded() NN_NOEXCEPT;

/**
 * @brief This function decrements the reference count if necessary.
 */
void DecrementSocketAndSignalIfNeeded() NN_NOEXCEPT;

/**
 * @brief This function waits on an event for all calls to complete.
 */
void WaitForAllResolverCallsToComplete() NN_NOEXCEPT;

/**
 * @brief This function enables resolver calls.
 */
void EnableResolverCalls() NN_NOEXCEPT;

/**
 * @brief This function disables resolver calls.
 */
void DisableResolverCalls() NN_NOEXCEPT;

/**
 * @brief This function returns true if resolver calls are enabled
 * @return true or false value
 */
bool AreResolverCallsEnabled() NN_NOEXCEPT;

}}}; // nn::socket::resolver
