﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sf/sf_Types.h>
#include <nn/socket/resolver/sfdl/resolver.sfdl.h>

namespace nn { namespace socket { namespace resolver {

/**
 * @brief create resolver client by Horizon IPC mechanism
 * @param resolverClientOut an out parameter that contains the the resolver client on succses
 * @note you should set resolverClientOut to nullptr when you are finished
 * @return a result code indicating pass or failure
 */
Result CreateResolverByHipc(nn::sf::SharedPointer<IResolver> & resolverClientOut) NN_NOEXCEPT;

}}}  // nn::socket::resolver
