﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn      {
namespace socket  {
namespace detail  {

void* Alloc(size_t size) NN_NOEXCEPT;
void* AllocAligned(size_t size, size_t alignment) NN_NOEXCEPT;
void* Realloc(void* address, size_t size) NN_NOEXCEPT;
void* Calloc(size_t numberfOfElements, size_t size) NN_NOEXCEPT;
void  Free(void* address) NN_NOEXCEPT;
bool  HeapIsAvailable(int heapGeneration) NN_NOEXCEPT;
int GetHeapGeneration() NN_NOEXCEPT;

// Needed to give us a few bits of TLS for tracking.
const int MinimumHeapAlignment = 16;

}}} /* nn::socket::detail */
