﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.os
{
    [CppRefPath(@"<nn/os/os_Types.h>")]
    [ExternalStruct(8, 8)]
    public struct ProcessId
    {
    }
}

namespace nn.sm
{
    [CppRefPath(@"<nn/ldr/ldr_Types.h>")]
    public struct ServiceName
    {
        [FixedArray(12)]
        public char_t[] value;
    }

    namespace detail
    {
        public interface IManagerInterface : IServiceObject
        {
            [MethodId(0)]
            Result
                RegisterProcess(
                    os.ProcessId        id,
                    InBuffer            accessRightsLimit,
                    InBuffer            accessRights
                );

            [MethodId(1)]
            Result
                UnregisterProcess(
                    os.ProcessId        id
                );
        }
    }
}
