﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/sf/sf_Types.h>
#include <nn/sfsmpl/sfsmpl_ICalculator.sfdl.h>

namespace nn { namespace sfsmpl {

// 実装オブジェクトに直接アクセスする場合に、オブジェクトへの参照を取得する関数
nn::sf::SharedPointer<ICalculator> GetCalculatorByDfc() NN_NOEXCEPT;

// 実装オブジェクトに HIPC を介してアクセスする場合に、オブジェクトへの参照を取得する関数
//
// 別途 StartCalculatorServer が先に呼ばれてサーバが立ち上がっている必要がある。
nn::sf::SharedPointer<ICalculator> GetCalculatorByHipc() NN_NOEXCEPT;

}}
