﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_ObjectImplFactory.h>

#include <nn/sf/impl/sf_AllocationPolicies.h>

#include <memory>

namespace nn { namespace sf { namespace hipc {

class HipcEmulatedObjectBase
    : public nn::sf::ISharedObject
{
private:

    struct StaticAllocator
    {
        static void* Allocate(size_t size) NN_NOEXCEPT;
        static void Deallocate(void* p, size_t size) NN_NOEXCEPT;
    };

protected:

    template <typename Base>
    class Factory
        : public ObjectImplFactory<Base, StatelessAllocationPolicy<StaticAllocator>>
    {
    };

};

}}}
