﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/nn_Windows.h>


namespace nn { namespace sf { namespace hipc { namespace detail {

class HipcWindowsThreadpoolWork
    : public sf::ISharedObject
{
private:
    PTP_WORK m_pThreadpoolWork;

private:
    static void CALLBACK WorkCallback(PTP_CALLBACK_INSTANCE pInstance, PVOID pContext, PTP_WORK pThreadpoolWork) NN_NOEXCEPT;
    void WorkCallbackImpl(PTP_CALLBACK_INSTANCE pInstance, PTP_WORK pThreadpoolWork) NN_NOEXCEPT;

protected:
    HipcWindowsThreadpoolWork() NN_NOEXCEPT;
    ~HipcWindowsThreadpoolWork() NN_NOEXCEPT;

    void SubmitThreadpoolWork() NN_NOEXCEPT;
    void WaitForThreadpoolWork(bool cancelPendingCallbacks) NN_NOEXCEPT;

    virtual void RunThreadpoolWork(PTP_CALLBACK_INSTANCE pInstance) = 0;
};

}}}}
