﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.sf.cmif
{
    [CppRefPath("<nn/sf/cmif/sf_CmifDomainCommon.h>")]
    [ExternalStruct(4, 4)]
    public struct CmifDomainObjectId
    {
    }

    [CppRefPath("<nn/sf/cmif/sf_ICmifDomain.h>")]
    public interface ICmifDomain : IServiceObject
    {
    }
}

namespace nn.sf.hipc.detail
{
    // HIPC MessageType_InvokeManagerMethod 用インターフェイス
    [CppRefPath("<nn/sf/hipc/detail/sf_IHipcManager.sfdl.h>")]
    public interface IHipcManager : IServiceObject
    {
        // セッションに結びつくオブジェクト x に対し、以下を行う。
        // - ドメイン d を新規作成
        // - x を d に登録しそのドメイン内 ID を pOut に返す
        // - d をセッションに結びつくオブジェクトとする
        [MethodId(0)]
        Result ConvertCurrentObjectToDomain(Out<nn.sf.cmif.CmifDomainObjectId> pOut);

        // セッションに結びつくドメイン d に対し以下を行う。
        // - d 内の id で表されるオブジェクト x を取得する
        // - x に結びつくセッション s を作成し pOut に返す
        // - s を待機ループに追加する
        [MethodId(1)]
        Result CopyFromCurrentDomain([MoveHandle] Out<NativeHandle> pOut, nn.sf.cmif.CmifDomainObjectId id);

        // セッションに結びつくオブジェクト x に対し、以下を行う。
        // - x に結びつくセッション s を作成し pOut に返す
        // - s を待機ループに追加する
        [MethodId(2)]
        Result CloneCurrentObject([MoveHandle] Out<NativeHandle> pOut);

        // セッションに結び付けられているポインタバッファのサイズを取得する。
        [MethodId(3)]
        Result QueryPointerBufferSize(Out<uint16_t> pOut);

        // セッションに結びつくオブジェクト x に対し、以下を行う。
        // - x に結びつくセッション s を作成し pOut に返す
        // - s を tag に応じた待機ループに追加する
        [MethodId(4)]
        Result CloneCurrentObjectEx([MoveHandle] Out<NativeHandle> pOut, uint32_t tag);
    }
}
