﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sdmmc/sdmmc_SdCard.h>
#include <nn/TargetConfigs/build_Base.h>
#include "detail/sdmmc_SdCardDeviceAccessor.h"
#if (defined(NN_DETAIL_SDMMC_PORT_SD_CARD_0_ENABLE) && (!defined(NN_DETAIL_SDMMC_ATTACH_MMC_TO_PORT_SD_CARD_0_FOR_DEBUG)))
    #include "detail/sdmmc_PortSdCard0.h"
#endif
#include <nn/nn_Abort.h>

namespace nn { namespace sdmmc {

namespace
{
    detail::SdCardDeviceAccessor* GetSdCardDeviceAccessor(Port port) NN_NOEXCEPT
    {
        detail::SdCardDeviceAccessor* pSdCardDeviceAccessor = nullptr;
        switch (port)
        {
        #if (defined(NN_DETAIL_SDMMC_PORT_SD_CARD_0_ENABLE) && (!defined(NN_DETAIL_SDMMC_ATTACH_MMC_TO_PORT_SD_CARD_0_FOR_DEBUG)))
            case Port_SdCard0:
                pSdCardDeviceAccessor = detail::GetSdCardDeviceAccessorOfPortSdCard0();
                break;
        #endif
        default:
            NN_UNEXPECTED_DEFAULT;
        }
        NN_ABORT_UNLESS_NOT_NULL(pSdCardDeviceAccessor);
        return pSdCardDeviceAccessor;
    }
}

void SetSdCardWorkBuffer(Port port, void* pSdCardWorkBuffer, size_t sdCardWorkBufferSize) NN_NOEXCEPT
{
    detail::SdCardDeviceAccessor* pSdCardDeviceAccessor = GetSdCardDeviceAccessor(port);
    pSdCardDeviceAccessor->SetSdCardWorkBuffer(pSdCardWorkBuffer, sdCardWorkBufferSize);
}

void PutSdCardToSleep(Port port) NN_NOEXCEPT
{
    detail::SdCardDeviceAccessor* pSdCardDeviceAccessor = GetSdCardDeviceAccessor(port);
    pSdCardDeviceAccessor->PutSdCardToSleep();
}

void AwakenSdCard(Port port) NN_NOEXCEPT
{
    detail::SdCardDeviceAccessor* pSdCardDeviceAccessor = GetSdCardDeviceAccessor(port);
    pSdCardDeviceAccessor->AwakenSdCard();
}

Result GetSdCardProtectedAreaCapacity(uint32_t* pOutNumSectors, Port port) NN_NOEXCEPT
{
    detail::SdCardDeviceAccessor* pSdCardDeviceAccessor = GetSdCardDeviceAccessor(port);
    return pSdCardDeviceAccessor->GetSdCardProtectedAreaCapacity(pOutNumSectors);
}

Result GetSdCardScr(void* pOutScrBuffer, size_t scrBufferSize, Port port) NN_NOEXCEPT
{
    detail::SdCardDeviceAccessor* pSdCardDeviceAccessor = GetSdCardDeviceAccessor(port);
    return pSdCardDeviceAccessor->GetSdCardScr(pOutScrBuffer, scrBufferSize);
}

Result GetSdCardSwitchFunctionStatus(void* pOutSwitchFunctionStatusBuffer, size_t switchFunctionStatusBufferSize,
    Port port, SdCardSwitchFunction sdCardSwitchFunction) NN_NOEXCEPT
{
    detail::SdCardDeviceAccessor* pSdCardDeviceAccessor = GetSdCardDeviceAccessor(port);
    return pSdCardDeviceAccessor->GetSdCardSwitchFunctionStatus(pOutSwitchFunctionStatusBuffer, switchFunctionStatusBufferSize, sdCardSwitchFunction);
}

Result GetSdCardCurrentConsumption(uint16_t* pOutCurrentConsumption, Port port, SpeedMode speedMode) NN_NOEXCEPT
{
    detail::SdCardDeviceAccessor* pSdCardDeviceAccessor = GetSdCardDeviceAccessor(port);
    return pSdCardDeviceAccessor->GetSdCardCurrentConsumption(pOutCurrentConsumption, speedMode);
}

Result GetSdCardSdStatus(void* pOutSdStatusBuffer, size_t sdStatusBufferSize, Port port) NN_NOEXCEPT
{
    detail::SdCardDeviceAccessor* pSdCardDeviceAccessor = GetSdCardDeviceAccessor(port);
    return pSdCardDeviceAccessor->GetSdCardSdStatus(pOutSdStatusBuffer, sdStatusBufferSize);
}

bool IsSdCardInserted(Port port) NN_NOEXCEPT
{
    detail::SdCardDeviceAccessor* pSdCardDeviceAccessor = GetSdCardDeviceAccessor(port);
    return pSdCardDeviceAccessor->IsSdCardInserted();
}

void RegisterSdCardDetectionEventCallback(Port port, DeviceDetectionEventCallback callback, void* pParameter) NN_NOEXCEPT
{
    detail::SdCardDeviceAccessor* pSdCardDeviceAccessor = GetSdCardDeviceAccessor(port);
    pSdCardDeviceAccessor->RegisterSdCardDetectionEventCallback(callback, pParameter);
}

void UnregisterSdCardDetectionEventCallback(Port port) NN_NOEXCEPT
{
    detail::SdCardDeviceAccessor* pSdCardDeviceAccessor = GetSdCardDeviceAccessor(port);
    pSdCardDeviceAccessor->UnregisterSdCardDetectionEventCallback();
}

bool IsSdCardRemoved(Port port) NN_NOEXCEPT
{
    detail::SdCardDeviceAccessor* pSdCardDeviceAccessor = GetSdCardDeviceAccessor(port);
    return pSdCardDeviceAccessor->IsSdCardRemoved();
}

}} // namespace nn { namespace sdmmc {
