﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_ReaderWriterLock.h>

namespace nn { namespace ro {
namespace detail {
struct StaticReaderWriterLock
{
    os::ReaderWriterLockType    m_ReaderWriterLock;
    void lock() NN_NOEXCEPT
    {
        nn::os::AcquireWriteLock( &m_ReaderWriterLock );
    }
    void unlock() NN_NOEXCEPT
    {
        nn::os::ReleaseWriteLock( &m_ReaderWriterLock );
    }
    void lock_shared() NN_NOEXCEPT
    {
        nn::os::AcquireReadLock(&m_ReaderWriterLock);
    }
    void unlock_shared() NN_NOEXCEPT
    {
        nn::os::ReleaseReadLock(&m_ReaderWriterLock);
    }
};

extern StaticReaderWriterLock g_RoLock;

}
}}
