﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/nn_Abort.h>

namespace nn { namespace result {

namespace detail {

NN_NORETURN void OnUnhandledResult(Result unhandleResult) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(unhandleResult);
    while (NN_STATIC_CONDITION(1)) {}
}

void ConvertInvalidImpl(Result result) NN_NOEXCEPT
{
    OnUnhandledResult(result);
}

}

}}
