﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nne/pinmux/pinmux.h>

#include <nn/pinmux/pinmux_Type.h>

#include "pinmux_GpioRegAccessor-soc.tegra.h"
#include "pinmux_CombinationList-soc.tegra.h"
#include "pinmux_DdUtil.h"
#include "pinmux_SetSdmmc1Mode-soc.tegra-x1.h"

namespace {

const nn::Bit32 GpioPm0To5BitEnable  = 0x3f;
const nn::Bit32 GpioPm0To5BitDisable = 0x00;
const nn::Bit32 GpioPm0To5BitMask    = 0x3f;

// GpioPadPort_PM のレジスタアドレスの計算用定義
const int GpioPm0To5BitNumber = NN_GPIO_GET_PAD_NUM(nn::pinmux::driver::detail::GpioPadPort_PM, 0);

}

namespace nn {
namespace pinmux {
namespace driver {
namespace detail {

void SetSdmmc1Mode(PinAssignment assignment, uintptr_t gpioAddress)  NN_NOEXCEPT
{
    nne::pinmux::tegra::PinmuxPadConfig pinmuxConfig;

    switch(assignment)
    {
    case PinAssignment_Sdmmc1OutputHigh:
        {
            // Remove CLK pull-down
            pinmuxConfig.index      = nne::pinmux::tegra::tx1::PinmuxPadIndex_Sdmmc1Clk;
            pinmuxConfig.option     = nne::pinmux::tegra::PinmuxOpt_NoPupd;
            pinmuxConfig.optionMask = nne::pinmux::tegra::PinmuxOptBitMask_Pupd;
            nne::pinmux::tegra::UpdateSinglePinmuxPad(pinmuxConfig);

            // Set GPIO_CNF PM0-5(CLK, CMD, DAT0-3) to GPIO mode
            nn::Bit32* accessAddressCnf = nn::pinmux::driver::detail::GetGpioRegAccessAddress(GpioRegisterType_GPIO_CNF, GpioPm0To5BitNumber, gpioAddress);
            WriteTegraMaskedWrite32(GpioPm0To5BitEnable, GpioPm0To5BitMask, accessAddressCnf);

            // Set GPIO_OUT PM0-5(CLK, CMD, DAT0-3) to HIGH
            nn::Bit32* accessAddressOut = nn::pinmux::driver::detail::GetGpioRegAccessAddress(GpioRegisterType_GPIO_OUT, GpioPm0To5BitNumber, gpioAddress);
            WriteTegraMaskedWrite32(GpioPm0To5BitEnable, GpioPm0To5BitMask, accessAddressOut);


            // Set GPIO_OE PM0-5(CLK, CMD, DAT0-3) to Output
            nn::Bit32* accessAddressOe = nn::pinmux::driver::detail::GetGpioRegAccessAddress(GpioRegisterType_GPIO_OE, GpioPm0To5BitNumber, gpioAddress);
            WriteTegraMaskedWrite32(GpioPm0To5BitEnable, GpioPm0To5BitMask, accessAddressOe);

            // Ensure Register Write
            DummyRead(accessAddressOe);

            break;
        }

    case PinAssignment_Sdmmc1ResetState:
        {
            // Set GPIO_CNF PM0-5(CLK, CMD, DAT0-3) to Sfio mode
            nn::Bit32* accessAddressCnf = nn::pinmux::driver::detail::GetGpioRegAccessAddress(GpioRegisterType_GPIO_CNF, GpioPm0To5BitNumber, gpioAddress);
            WriteTegraMaskedWrite32(GpioPm0To5BitDisable, GpioPm0To5BitMask, accessAddressCnf);


            // Set GPIO_OE PM0-5(CLK, CMD, DAT0-3) to Input
            nn::Bit32* accessAddressOut = nn::pinmux::driver::detail::GetGpioRegAccessAddress(GpioRegisterType_GPIO_OUT, GpioPm0To5BitNumber, gpioAddress);
            WriteTegraMaskedWrite32(GpioPm0To5BitDisable, GpioPm0To5BitMask, accessAddressOut);

            // Set GPIO_OUT PM0-5(CLK, CMD, DAT0-3) to LOW
            nn::Bit32* accessAddressOe = nn::pinmux::driver::detail::GetGpioRegAccessAddress(GpioRegisterType_GPIO_OE, GpioPm0To5BitNumber, gpioAddress);
            WriteTegraMaskedWrite32(GpioPm0To5BitDisable, GpioPm0To5BitMask, accessAddressOe);

            // Ensure Register Write
            DummyRead(accessAddressOe);

            // Set CLK to pull-down
            pinmuxConfig.index      = nne::pinmux::tegra::tx1::PinmuxPadIndex_Sdmmc1Clk;
            pinmuxConfig.option     = nne::pinmux::tegra::PinmuxOpt_PullDown;
            pinmuxConfig.optionMask = nne::pinmux::tegra::PinmuxOptBitMask_Pupd;
            nne::pinmux::tegra::UpdateSinglePinmuxPad(pinmuxConfig);
            break;
        }

    default: NN_UNEXPECTED_DEFAULT;
    }
}

} // detail
} // driver
} // pinmux
} // nn
