﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include <nne/pinmux/pinmux.h>

namespace nn {
namespace pinmux {
namespace driver {
namespace detail {

void SetExtConUartMode(nne::pinmux::tegra::tx1::PinmuxPadIndex index, bool isUart)  NN_NOEXCEPT
{
    nne::pinmux::tegra::PinmuxPadConfig pinmuxConfig;

    pinmuxConfig.index = index;

    if(isUart)
    {
        switch(index)
        {
        case nne::pinmux::tegra::tx1::PinmuxPadIndex_Uart2Tx:
            pinmuxConfig.option = nne::pinmux::tegra::tx1::Uart2Tx::Pm_Uartb |
                                  nne::pinmux::tegra::PinmuxOpt_Output |
                                  nne::pinmux::tegra::PinmuxOpt_NoPupd;
            break;

        case nne::pinmux::tegra::tx1::PinmuxPadIndex_Uart2Cts:
            pinmuxConfig.option = nne::pinmux::tegra::tx1::Uart2Cts::Pm_Uartb |
                                  nne::pinmux::tegra::PinmuxOpt_Input |
                                  nne::pinmux::tegra::PinmuxOpt_NoPupd;
            break;

        case nne::pinmux::tegra::tx1::PinmuxPadIndex_Uart3Tx:
            pinmuxConfig.option = nne::pinmux::tegra::tx1::Uart3Tx::Pm_Uartc |
                                  nne::pinmux::tegra::PinmuxOpt_Output |
                                  nne::pinmux::tegra::PinmuxOpt_NoPupd;
            break;

        case nne::pinmux::tegra::tx1::PinmuxPadIndex_Uart3Cts:
            pinmuxConfig.option = nne::pinmux::tegra::tx1::Uart3Cts::Pm_Uartc |
                                  nne::pinmux::tegra::PinmuxOpt_Input |
                                  nne::pinmux::tegra::PinmuxOpt_NoPupd;
            break;

        default : NN_UNEXPECTED_DEFAULT;
        }
    }
    else
    {
        pinmuxConfig.option = nne::pinmux::tegra::PinmuxOpt_Gpio |
                              nne::pinmux::tegra::PinmuxOpt_Input |
                              nne::pinmux::tegra::PinmuxOpt_NoPupd;
    }

    pinmuxConfig.optionMask = nne::pinmux::tegra::PinmuxOptBitMask_Pm |
                              nne::pinmux::tegra::PinmuxOptBitMask_Dir |
                              nne::pinmux::tegra::PinmuxOptBitMask_Pupd;
    nne::pinmux::tegra::UpdateSinglePinmuxPad(pinmuxConfig);
}

} // detail
} // driver
} // pinmux
} // nn
