﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_Abort.h>
#include <nn/osdbg/osdbg_ThreadTypes.h>
#include <nn/svc/svc_Types.common.h>

#include "osdbg_Types.h"

namespace nn { namespace osdbg {
namespace detail {

//--------------------------------------------------------------------------

class ThreadInfoImplByHorizon
{
public:
    static nn::Result FillWithCurrentInfo(ThreadInfo* info) NN_NOEXCEPT;

};

typedef ThreadInfoImplByHorizon ThreadInfoImpl;

//--------------------------------------------------------------------------

inline bool IsLp64(ThreadInfo* info) NN_NOEXCEPT
{
    auto addressSpace = info->_debugInfoCreateProcess.flag & svc::CreateProcessParameterFlag_AddressSpaceMask;
    bool isLp64 = (addressSpace == svc::CreateProcessParameterFlag_AddressSpace64Bit) || (addressSpace == svc::CreateProcessParameterFlag_AddressSpace64BitOld);
#if defined(NN_BUILD_CONFIG_CPU_ARM_V8A)
    return isLp64;
#elif defined(NN_BUILD_CONFIG_CPU_ARM_V7A)
    NN_ABORT_UNLESS(!isLp64, "*** LP64-ABI is not supported in ARMv7A environment.");
    return false;
#else
    #error "*** Non-supported build condition."
#endif
}

inline bool Is64BitArch(ThreadInfo* info) NN_NOEXCEPT
{
    bool is64Bit = info->_debugInfoCreateProcess.flag & svc::CreateProcessParameterFlag_64Bit;
#if defined(NN_BUILD_CONFIG_CPU_ARM_V8A)
    return is64Bit;
#elif defined(NN_BUILD_CONFIG_CPU_ARM_V7A)
    NN_ABORT_UNLESS(!is64Bit, "*** AArch64 process is not supported in ARMv7A environment.");
    return false;
#else
    #error "*** Non-supported build condition."
#endif
}

//--------------------------------------------------------------------------

}   // namespace detail
}}  // namespace nn::osdbg

