﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/os/os_Macro.h>
#include <nn/os/os_ThreadLocalStorageCommon.h>
#include <nn/os/os_ThreadLocalStorageApi.h>
#include <nn/os/os_SdkThreadLocalStorageApi.h>
#include <nn/os/detail/os_MacroImpl.h>

#include <nnc/result/result_CConverter.h>
#include <nnc/os/os_Macro.h>
#include <nnc/os/os_ThreadLocalStorageCommon.h>
#include <nnc/os/os_ThreadLocalStorageApi.h>

#include "detail/os_Diag.h"
#include "detail/os_Common.h"
#include "detail/os_TlsManager.h"

//---------------------------------------------------------------------------
//  C++ 用の型とサイズやアライメント、定数値等が一致しているのかをチェック
//---------------------------------------------------------------------------

static_assert(sizeof(nnosTlsSlot) == sizeof(nn::os::TlsSlot), "");
static_assert(NN_ALIGNOF(nnosTlsSlot) == NN_ALIGNOF(nn::os::TlsSlot), "");

static_assert(NN_OS_TLS_SLOT_COUNT_MAX == nn::os::TlsSlotCountMax, "");


//---------------------------------------------------------------------------
//  C 関数の定義
//---------------------------------------------------------------------------

NN_OS_EXTERN_C nnResult  nnosAllocateTlsSlot(nnosTlsSlot* outTlsSlot, nnosTlsDestructor function)
{
    // C 言語用の AllocateTlsSlot() では SDK 用の TLS スロットを確保する
    nn::Result result = nn::os::SdkAllocateTlsSlot(reinterpret_cast<nn::os::TlsSlot*>(outTlsSlot), reinterpret_cast<nn::os::TlsDestructor>(function));
    return nn::result::ConvertToC(result);
}

NN_OS_EXTERN_C void    nnosFreeTlsSlot(nnosTlsSlot tlsSlot)
{
    nn::os::FreeTlsSlot(*reinterpret_cast<nn::os::TlsSlot*>(&tlsSlot));
}

NN_OS_EXTERN_C uintptr_t   nnosGetTlsValue(nnosTlsSlot tlsSlot)
{
    return nn::os::GetTlsValue(*reinterpret_cast<nn::os::TlsSlot*>(&tlsSlot));
}

NN_OS_EXTERN_C void    nnosSetTlsValue(nnosTlsSlot tlsSlot, uintptr_t value)
{
    nn::os::SetTlsValue(*reinterpret_cast<nn::os::TlsSlot*>(&tlsSlot), value);
}

NN_OS_EXTERN_C int     nnosGetUsedTlsSlotCount()
{
    return nn::os::GetUsedTlsSlotCount();
}
