﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/os/os_Random.h>
#include <nn/os/os_Mutex.h>
#include "detail/os_RandomImpl.h"

//---------------------------------------------------------------------------
//  C++ 関数の定義
//---------------------------------------------------------------------------

namespace nn { namespace os {

namespace {
    bool          g_RandomInitialized = false;
    MutexType     g_MutexPublicRandom = NN_OS_MUTEX_INITIALIZER(false);
    util::TinyMt  g_PublicRandom;
}

void GenerateRandomBytes(void* pOutBuffer, size_t size) NN_NOEXCEPT
{
    NN_SDK_ASSERT(pOutBuffer);

    LockMutex(&g_MutexPublicRandom);

    if (g_RandomInitialized == false)
    {
        // 初めて使う場合にはシードを初期化する
        detail::InitializeRandomImpl(&g_PublicRandom);

        g_RandomInitialized = true;
    }

    // ランダムなバイト列を生成
    g_PublicRandom.GenerateRandomBytes(pOutBuffer, size);

    UnlockMutex(&g_MutexPublicRandom);
}

}} // namespace nn::os
