﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/os/os_NativeHandleTypes.h>

#include "detail/os_Common.h"
#include "detail/os_NativeHandleImpl.h"


namespace nn { namespace os {

//-----------------------------------------------------------------------------
//  NativeHandle のクローズ
//
void CloseNativeHandle(NativeHandle handle) NN_NOEXCEPT
{
    if (handle == nn::os::InvalidNativeHandle)
    {
        return;
    }

    detail::NativeHandleImpl::Close( handle );
}

//-----------------------------------------------------------------------------

}} // namespace nn::os

