﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/diag/text/diag_SdkTextOs.h>
#include <nn/os/os_MemoryPermission.h>

#include "detail/os_Diag.h"
#include "detail/os_Common.h"
#include "detail/os_MemoryPermissionImpl.h"
#include "detail/os_MemoryHeapManager.h"


//--------------------------------------------------------------------------

namespace nn { namespace os {

//--------------------------------------------------------------------------
//  メモリアクセス権を変更
void SetMemoryPermission(uintptr_t address, size_t size, MemoryPermission permission) NN_NOEXCEPT
{
    // 事前条件
    NN_SDK_REQUIRES( detail::IsAligned( address, MemoryPageSize ), NN_TEXT_OS("nn::os::SetMemoryPermission(): address が MemoryPageSize の整数倍ではありません（address=0x%p）"), address );

    NN_SDK_REQUIRES( detail::IsAligned( size, MemoryPageSize ), NN_TEXT_OS("nn::os::SetMemoryPermission(): size が MemoryPageSize の整数倍ではありません（size=0x%zx）"), size );

    // メモリアクセス権を変更
    detail::SetMemoryPermissionImpl( address, size, permission );
}


}} // namespace nn::os


