﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>

#include <nn/os/os_Macro.h>
#include <nn/os/os_InterruptEventCommon.h>
#include <nn/os/os_InterruptEventTypes.h>
#include <nn/os/os_InterruptEventApi.h>

#include <nnc/os/os_Macro.h>
#include <nnc/os/os_InterruptEventCommon.h>
#include <nnc/os/os_InterruptEventTypes.h>
#include <nnc/os/os_InterruptEventApi.h>

//---------------------------------------------------------------------------
//  C++ 用の型とサイズやアライメントが一致しているのかをチェック
//---------------------------------------------------------------------------

static_assert(sizeof(nnosInterruptEventType) == sizeof(nn::os::InterruptEventType), "");
static_assert(NN_ALIGNOF(nnosInterruptEventType) == NN_ALIGNOF(nn::os::InterruptEventType), "");

static_assert(static_cast<int>(nnosEventClearMode_ManualClear) == static_cast<int>(nn::os::EventClearMode_ManualClear), "");
static_assert(static_cast<int>(nnosEventClearMode_AutoClear)   == static_cast<int>(nn::os::EventClearMode_AutoClear), "");


//---------------------------------------------------------------------------
//  C 関数の定義
//---------------------------------------------------------------------------

NN_OS_EXTERN_C void nnosInitializeInterruptEvent(nnosInterruptEventType* event, nnosInterruptName interruptName, nnosEventClearMode clearMode)
{
    nn::os::InitializeInterruptEvent(
                        reinterpret_cast<nn::os::InterruptEventType*>(event),
                        static_cast<nn::os::InterruptName>(interruptName),
                        static_cast<nn::os::EventClearMode>(clearMode) );
}

NN_OS_EXTERN_C void nnosFinalizeInterruptEvent(nnosInterruptEventType* event)
{
    nn::os::FinalizeInterruptEvent(reinterpret_cast<nn::os::InterruptEventType*>(event));
}

NN_OS_EXTERN_C void nnosWaitInterruptEvent(nnosInterruptEventType* event)
{
    nn::os::WaitInterruptEvent(reinterpret_cast<nn::os::InterruptEventType*>(event));
}

NN_OS_EXTERN_C bool nnosTimedWaitInterruptEvent(nnosInterruptEventType* event, int64_t timeout)
{
    return nn::os::TimedWaitInterruptEvent(
                        reinterpret_cast<nn::os::InterruptEventType*>(event),
                        nn::TimeSpan::FromNanoSeconds(timeout) );
}

NN_OS_EXTERN_C bool nnosTryWaitInterruptEvent(nnosInterruptEventType* event)
{
    return nn::os::TryWaitInterruptEvent(reinterpret_cast<nn::os::InterruptEventType*>(event));
}

NN_OS_EXTERN_C void nnosClearInterruptEvent(nnosInterruptEventType* event)
{
    nn::os::ClearInterruptEvent(reinterpret_cast<nn::os::InterruptEventType*>(event));
}

NN_OS_EXTERN_C void nnosInitializeMultiWaitHolderForInterruptEvent(nnosMultiWaitHolderType* multiWaitHolder, nnosInterruptEventType* interruptEvent)
{
    nn::os::InitializeMultiWaitHolder(reinterpret_cast<nn::os::MultiWaitHolderType*>(multiWaitHolder), reinterpret_cast<nn::os::InterruptEventType*>(interruptEvent));
}
