﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <new>
#include <nn/os/os_Config.h>
#include <nn/os/os_ReaderWriterLock.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>


namespace nn { namespace os {
namespace detail {

class AddressRegionManager;

//--------------------------------------------------------------------------
// 仮想アドレスメモリ (reserved) 領域管理用クラス
//
class VammManager
{
public:
    //-----------------------------------------------------------------
    // コンストラクタ
    VammManager() NN_NOEXCEPT;

    void        InitializeIfEnabled() NN_NOEXCEPT;

    //-----------------------------------------------------------------
    // アドレス空間を獲得する
    nn::Result  AllocateAddressRegion(uintptr_t* pOutAddress, size_t size) NN_NOEXCEPT;

    //-----------------------------------------------------------------
    // アドレス空間を獲得し、物理メモリを割り当てる
    nn::Result  AllocateMemory(uintptr_t* pOutAddress, size_t size) NN_NOEXCEPT;

    //-----------------------------------------------------------------
    // 指定のアドレスに物理メモリを割り当てる
    nn::Result  AllocateMemoryPages(uintptr_t address, size_t size)    NN_NOEXCEPT;

    //-----------------------------------------------------------------
    // Reserved 領域にアドレス空間を返却する。物理メモリが割り当て済みなら解放する
    nn::Result  FreeAddressRegion(uintptr_t address) NN_NOEXCEPT;

    //-----------------------------------------------------------------
    // 物理メモリを解放する
    nn::Result  FreeMemoryPages(uintptr_t address, size_t size) NN_NOEXCEPT;

    VirtualAddressMemoryResourceUsage GetVirtualAddressMemoryResourceUsage() NN_NOEXCEPT;

    bool IsVirtualAddressMemoryEnabled() const NN_NOEXCEPT;

private:
    uintptr_t               m_ReservedRegionStart;
    uintptr_t               m_ReservedRegionSize;
    ReaderWriterLock        m_Lock;
    AddressRegionManager*   m_pRegionManager;
};

//--------------------------------------------------------------------------

}   // namespace detail
}}  // namespace nn::os

