﻿/*---------------------------------------------------------------------------*
  Copyright (C)2014 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Base.h>
#include <nn/svc/svc_BaseId.autogen.h>
#include "os_AssemblyOffset.h"

    .section ".text", "ax"
    .align   2
    .global  _ZN2nn2os6detail20UserExceptionHandlerEv
    .type    _ZN2nn2os6detail20UserExceptionHandlerEv, %function
_ZN2nn2os6detail20UserExceptionHandlerEv:

    //-------------------------------------------------------------------------
    // [この時点でのレジスタの状態]
    //  w0 = 例外要因
    //  w1 = プロセス固有領域上の nn::svc::ExceptionInfo へのポインタ
    //  sp = プロセス固有領域上のスタックの底（スタックサイズは僅か）
    //-------------------------------------------------------------------------
    // まず、デマンドロードが必要かどうかをチェック
    // <未実装>

    // ユーザ例外ハンドラが未設定ならばデフォルト処理へ
    adrp    x7, :got:_ZN2nn2os6detail22g_UserExceptionHandlerE
    ldr     w7, [x7, #:got_lo12:_ZN2nn2os6detail22g_UserExceptionHandlerE]
    ldr     w7, [x7]
    cbz     w7, .Lnot_handled

    // svc 呼出しで x9～x18 が破壊されるため push しておく
    // ついでにワーク用に x19～x22 も保存しておく
    stp     x9,  x10, [sp, #-0x10]!
    stp     x11, x12, [sp, #-0x10]!
    stp     x13, x14, [sp, #-0x10]!
    stp     x15, x16, [sp, #-0x10]!
    stp     x17, x18, [sp, #-0x10]!
    stp     x19, x20, [sp, #-0x10]!
    stp     x21, x22, [sp, #-0x10]!

    mov     w19, w0     // x0 = 例外要因
    mov     w20, w1     // x1 = nn::svc::ExceptionInfo へのポインタ

    // デバッガが未接続ならユーザ例外ハンドラを呼出す
    bl      2f
1:  .word   __pout_64 - 1b
2:  ldr     w0, [x30]
    sxtw    x0, w0
    add     x0, x0, x30
    mov     x21, x0
    mov     x1, #NN_SVC_INFOTYPE_DEBUGGER_PRESENCE  // InfoType_DebuggerPresence
    mov     x2, xzr                                 // handle
    mov     x3, xzr                                 // param
    adrp    x4, :got:_ZN2nn3svc7aarch645ilp327GetInfoEPyNS0_8InfoTypeENS0_6HandleEy
    ldr     w4, [x4, #:got_lo12:_ZN2nn3svc7aarch645ilp327GetInfoEPyNS0_8InfoTypeENS0_6HandleEy]
    blr     x4
    ldr     x1, [x21]
    cbnz    w0, .Lnot_handled_with_restore_register         // result
    cbz     x1, _prepare_to_invoke_user_exception_handler   // pOut, 0=NotAttached

    // デバッガ接続中でもユーザ例外ハンドラを起動すべきか
    adrp    x7, :got:_ZN2nn2os6detail41g_UserExceptionHandlerValidityOnDebuggingE
    ldr     w7, [x7, #:got_lo12:_ZN2nn2os6detail41g_UserExceptionHandlerValidityOnDebuggingE]
    ldrb    w7, [x7]
    cbz     w7, .Lnot_handled_with_restore_register // false ならデフォルト処理へ

_prepare_to_invoke_user_exception_handler:
    //-------------------------------------------------------------------------
    // nn::os::detail::PrepareToCopyUserExceptionInfo() を呼ぶ。
    //  w0= 例外要因
    //  w1= nn::svc::ExceptionInfo へのポインタ
    //
    // nn::os::UserExceptioinInfoDetail のアドレスを w0 で返す。
    // w0 == NULL の場合は、メモリアクセス不可等を検出したため、
    // デフォルト処理へ移行する
    //

    // スタック消費を避けるため、
    // nn::os::detail::PrepareToCopyUserExceptionInfo の等価ルーチンを呼ぶ
    mov     w0, w19
    mov     w1, w20
    b       _prepare_to_copy_user_exception_info

    // OUPUT:   x0:  nn::os::UserExceptionInfoDetail へのポインタ
    //          x20: nn::svc::ExceptionInfo へのポインタ
    //          x21: nn::svc::ExceptionInfo.r[0] に代入すべき値
    //          x22: nn::svc::ExceptionInfo.sp   に代入すべき値

_prepare_to_copy_user_exception_info_return:
    cbz     w0, .Lnot_handled_with_restore_register

    mov     w4, w0      // x4 = os::UserExceptionInfoDetail へのポインタ
    mov     w5, w20     // x5 = svc::ExceptionInfo へのポインタ

    // nn::os::UserExceptionInfoDetail 構造体の構築
    //  w4 = nn::os::UserExceptionInfoDetail の先頭アドレス
    //  w5 = nn::svc::ExceptionInfo の先頭アドレス
    //
    // コードの最適化は度外視

#define NN_LDST64_EXCEPTION_INFO(to, from)                  \
        ldr     x0, [x5, #NN_SVC_EXCEPTION_INFO_##from];    \
        str     x0, [x4, #NN_OS_EXCEPTION_INFO_##to]

#define NN_LDST32_EXCEPTION_INFO(to, from)                  \
        ldr     w0, [x5, #NN_SVC_EXCEPTION_INFO_##from];    \
        str     w0, [x4, #NN_OS_EXCEPTION_INFO_##to]

    // CPU 汎用レジスタ r0～r30（各 64 bit）,sp , pc をコピー
    NN_LDST64_EXCEPTION_INFO( AA64_OFFSET_R0, AA64_OFFSET_R0 )
    NN_LDST64_EXCEPTION_INFO( AA64_OFFSET_R1, AA64_OFFSET_R1 )
    NN_LDST64_EXCEPTION_INFO( AA64_OFFSET_R2, AA64_OFFSET_R2 )
    NN_LDST64_EXCEPTION_INFO( AA64_OFFSET_R3, AA64_OFFSET_R3 )
    NN_LDST64_EXCEPTION_INFO( AA64_OFFSET_R4, AA64_OFFSET_R4 )
    NN_LDST64_EXCEPTION_INFO( AA64_OFFSET_R5, AA64_OFFSET_R5 )
    NN_LDST64_EXCEPTION_INFO( AA64_OFFSET_R6, AA64_OFFSET_R6 )
    NN_LDST64_EXCEPTION_INFO( AA64_OFFSET_R7, AA64_OFFSET_R7 )
    NN_LDST64_EXCEPTION_INFO( AA64_OFFSET_R8, AA64_OFFSET_R8 )

    NN_LDST64_EXCEPTION_INFO( AA64_OFFSET_R30, AA64_OFFSET_LR )
    NN_LDST64_EXCEPTION_INFO( AA64_OFFSET_SP,  AA64_OFFSET_SP )
    NN_LDST64_EXCEPTION_INFO( AA64_OFFSET_PC,  AA64_OFFSET_PC )

    str     x21, [x5, #NN_SVC_EXCEPTION_INFO_AA64_OFFSET_R0]
    str     x22, [x5, #NN_SVC_EXCEPTION_INFO_AA64_OFFSET_SP]

    ldp     x21, x22, [sp], #0x10
    ldp     x19, x20, [sp], #0x10
    ldp     x17, x18, [sp], #0x10
    ldp     x15, x16, [sp], #0x10
    ldp     x13, x14, [sp], #0x10
    ldp     x11, x12, [sp], #0x10
    ldp     x9,  x10, [sp], #0x10

    str     x9,  [x4, #NN_OS_EXCEPTION_INFO_AA64_OFFSET_R9 ]
    str     x10, [x4, #NN_OS_EXCEPTION_INFO_AA64_OFFSET_R10]
    str     x11, [x4, #NN_OS_EXCEPTION_INFO_AA64_OFFSET_R11]
    str     x12, [x4, #NN_OS_EXCEPTION_INFO_AA64_OFFSET_R12]
    str     x13, [x4, #NN_OS_EXCEPTION_INFO_AA64_OFFSET_R13]
    str     x14, [x4, #NN_OS_EXCEPTION_INFO_AA64_OFFSET_R14]
    str     x15, [x4, #NN_OS_EXCEPTION_INFO_AA64_OFFSET_R15]
    str     x16, [x4, #NN_OS_EXCEPTION_INFO_AA64_OFFSET_R16]
    str     x17, [x4, #NN_OS_EXCEPTION_INFO_AA64_OFFSET_R17]
    str     x18, [x4, #NN_OS_EXCEPTION_INFO_AA64_OFFSET_R18]
    str     x19, [x4, #NN_OS_EXCEPTION_INFO_AA64_OFFSET_R19]
    str     x20, [x4, #NN_OS_EXCEPTION_INFO_AA64_OFFSET_R20]
    str     x21, [x4, #NN_OS_EXCEPTION_INFO_AA64_OFFSET_R21]
    str     x22, [x4, #NN_OS_EXCEPTION_INFO_AA64_OFFSET_R22]

    str     x23, [x4, #NN_OS_EXCEPTION_INFO_AA64_OFFSET_R23]
    str     x24, [x4, #NN_OS_EXCEPTION_INFO_AA64_OFFSET_R24]
    str     x25, [x4, #NN_OS_EXCEPTION_INFO_AA64_OFFSET_R25]
    str     x26, [x4, #NN_OS_EXCEPTION_INFO_AA64_OFFSET_R26]
    str     x27, [x4, #NN_OS_EXCEPTION_INFO_AA64_OFFSET_R27]
    str     x28, [x4, #NN_OS_EXCEPTION_INFO_AA64_OFFSET_R28]
    str     x29, [x4, #NN_OS_EXCEPTION_INFO_AA64_OFFSET_R29]

    // VFP ベクタレジスタ V0～V31（各 128 bit）をセット
    add     x0,  x4, #NN_OS_EXCEPTION_INFO_AA64_OFFSET_V0
    stp     q0,  q1,  [x0], #0x20
    stp     q2,  q3,  [x0], #0x20
    stp     q4,  q5,  [x0], #0x20
    stp     q6,  q7,  [x0], #0x20
    stp     q8,  q9,  [x0], #0x20
    stp     q10, q11, [x0], #0x20
    stp     q12, q13, [x0], #0x20
    stp     q14, q15, [x0], #0x20
    stp     q16, q17, [x0], #0x20
    stp     q18, q19, [x0], #0x20
    stp     q20, q21, [x0], #0x20
    stp     q22, q23, [x0], #0x20
    stp     q24, q25, [x0], #0x20
    stp     q26, q27, [x0], #0x20
    stp     q28, q29, [x0], #0x20
    stp     q30, q31, [x0], #0x20

    // 例外情報をコピー
    NN_LDST32_EXCEPTION_INFO( AA64_OFFSET_PSTATE, AA64_OFFSET_PSTATE )
    NN_LDST32_EXCEPTION_INFO( AA64_OFFSET_AFSR0,  AA64_OFFSET_AFSR0  )
    NN_LDST32_EXCEPTION_INFO( AA64_OFFSET_AFSR1,  AA64_OFFSET_AFSR1  )
    NN_LDST32_EXCEPTION_INFO( AA64_OFFSET_ESR,    AA64_OFFSET_ESR    )
    NN_LDST64_EXCEPTION_INFO( AA64_OFFSET_FAR,    AA64_OFFSET_FAR    )

    // svc::ExceptionInfo の pc を変更
    adr     x0, _entry_of_user_exception_handler
    str     x0, [x5, #NN_SVC_EXCEPTION_INFO_AA64_OFFSET_PC]

    // 一旦カーネルに戻る
    mov     x0, #RESULT_SUCCESS
    adrp    x1, :got:_ZN2nn3svc7aarch645ilp3219ReturnFromExceptionENS_6ResultE
    ldr     w1, [x1, #:got_lo12:_ZN2nn3svc7aarch645ilp3219ReturnFromExceptionENS_6ResultE]
    blr     x1

_entry_of_user_exception_handler:
    //------------------------------------------------------------
    // svc::ReturnFromException() からの復帰位置。
    //  w0 = nn::os::UserExceptionInfo* のポインタ
    //  sp = ユーザ例外ハンドラ用のスタック
    //
    adrp    x1, :got:_ZN2nn2os6detail22g_UserExceptionHandlerE
    ldr     w1, [x1, #:got_lo12:_ZN2nn2os6detail22g_UserExceptionHandlerE]
    ldr     w1, [x1]
    cbz     w1, .Lpanic

    // ユーザ例外ハンドラの呼出し
    blr     x1

.Lpanic:
    // panic へ移行
    ldr     x0, =NN_SVC_BREAKREASON_PANIC
    mov     x1, xzr
    mov     x2, xzr
    adrp    x3, :got:_ZN2nn3svc7aarch645ilp325BreakENS0_11BreakReasonEmm
    ldr     w3, [x3, #:got_lo12:_ZN2nn3svc7aarch645ilp325BreakENS0_11BreakReasonEmm]
    blr     x3
0:  b       0b

.Lnot_handled_with_restore_register:
    ldp     x21, x22, [sp], #0x10
    ldp     x19, x20, [sp], #0x10
    ldp     x17, x18, [sp], #0x10
    ldp     x15, x16, [sp], #0x10
    ldp     x13, x14, [sp], #0x10
    ldp     x11, x12, [sp], #0x10
    ldp     x9,  x10, [sp], #0x10

.Lnot_handled:
    ldr     x0, =RESULT_NOT_HANDLED
    adrp    x1, :got:_ZN2nn3svc7aarch645ilp3219ReturnFromExceptionENS_6ResultE
    ldr     w1, [x1, #:got_lo12:_ZN2nn3svc7aarch645ilp3219ReturnFromExceptionENS_6ResultE]
    blr     x1
0:  b       0b

    //------------------------------------------------------------
    // os::detail::PrepareToCopyUserExceptionInfo() と等価コード。
    // ただし、こちらに配置することで、関数呼出時のシンボル解決が
    // 不要となり、スタックを消費せずに同様の処理を行なう。
    //
    // INPUT:   x0, x19: 例外要因
    //          x1, x20: nn::svc::ExceptionInfo へのポインタ
    // OUPUT:   x0: nn::os::UserExceptionInfoDetail へのポインタ
    //          x21: nn::svc::ExceptionInfo.r[0] に代入すべき値
    //          x22: nn::svc::ExceptionInfo.sp   に代入すべき値
    // ABI:     x23-x30 は破壊禁止
    //
_prepare_to_copy_user_exception_info:
    adrp    x8, :got:_ZN2nn2os6detail19g_UserExceptionInfoE
    ldr     w8, [x8, #:got_lo12:_ZN2nn2os6detail19g_UserExceptionInfoE]
    ldr     x10, [x1, #NN_SVC_EXCEPTION_INFO_AA64_OFFSET_SP]
    sub     x11, x10, #NN_OS_SIZEOF_USER_EXCEPTION_INFO
    ldr     w9, [x8]
    adrp    x8, :got:_ZN2nn2os6detail26g_UserExceptionStackBottomE
    ldr     w8, [x8, #:got_lo12:_ZN2nn2os6detail26g_UserExceptionStackBottomE]
    ldr     w8, [x8]
    mov     x7, x8

    // この時点で x7:  g_UserExceptionStackBottom の値
    //            x8:  handlerStackBottom の値
    //            x9:  info の値
    //            x10: 例外発生時の threadStack
    //            x11: 例外発生時の threadStack - sizeof(UserExceptionInfo)

    cmp     x9, #NN_OS_USER_EXCEPTION_INFO_USES_THREAD_STACK
    csel    x10, x11, x10, eq
    csel    x9,  x11, x9,  eq

    cmp     x8, #NN_OS_HANLDER_STACK_USES_THREAD_STACK
    csel    x8,  x10, x8,  eq

    cmp     x9, #NN_OS_USER_EXCEPTION_INFO_USES_HANDLER_STACK
    b.ne    .Lprepare_to_copy_user_exception_info_memory_check
    sub     x8, x8, #NN_OS_SIZEOF_USER_EXCEPTION_INFO
    mov     x9, x8
    cmp     x7, #NN_OS_HANLDER_STACK_USES_THREAD_STACK
    b.eq    .Lprepare_to_copy_user_exception_info_memory_check
    adrp    x7, :got:_ZN2nn2os6detail23g_UserExceptionStackTopE
    ldr     w7, [x7, #:got_lo12:_ZN2nn2os6detail23g_UserExceptionStackTopE]
    ldr     w7, [x7]
    cmp     x8, x7
    b.ls    .Lprepare_to_copy_user_exception_info_return_null

.Lprepare_to_copy_user_exception_info_memory_check:
    mov     x21, x9
    mov     x22, x8

    //  x19: 例外要因
    //  x20: nn::svc::ExceptionInfo へのポインタ
    //  x21: info の値
    //  x22: handlerStackBottom の値

    // info へのメモリアクセス可否チェック
    bl      2f
1:  .word   __memory_info - 1b
2:  ldr     w0, [x30]
    sxtw    x0, w0
    add     x0, x0, x30
    bl      2f
1:  .word   __pout_64 - 1b
2:  ldr     w1, [x30]
    sxtw    x1, w1
    add     x1, x1, x30
    mov     x2, x21
    stp     x0, x1, [sp, #-0x10]!
    adrp    x3, :got:_ZN2nn3svc7aarch645ilp3211QueryMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoEm
    ldr     w3, [x3, #:got_lo12:_ZN2nn3svc7aarch645ilp3211QueryMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoEm]
    blr     x3
    ldp     x1, x2, [sp], #0x10
    cbnz    w0, .Lprepare_to_copy_user_exception_info_return_null

    ldr     w0, [x1, #NN_SVC_MEMORY_INFO_OFFSET_PERMISSION]
    cmp     w0, #NN_SVC_MEMORY_PERMISSION_READWRITE
    b.ne    .Lprepare_to_copy_user_exception_info_return_null

    // handlerStackBottom へのメモリアクセス可否チェック
    mov     x0, x1
    mov     x1, x2
    mov     x2, x22
    str     x0, [sp, #-0x8]!
    adrp    x3, :got:_ZN2nn3svc7aarch645ilp3211QueryMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoEm
    ldr     w3, [x3, #:got_lo12:_ZN2nn3svc7aarch645ilp3211QueryMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoEm]
    blr     x3
    ldr     x1, [sp], #0x8
    cbnz    w0, .Lprepare_to_copy_user_exception_info_return_null

    ldr     w0, [x1, #NN_SVC_MEMORY_INFO_OFFSET_PERMISSION]
    cmp     w0, #NN_SVC_MEMORY_PERMISSION_READWRITE
    b.ne    .Lprepare_to_copy_user_exception_info_return_null

.Lprepare_to_copy_user_exception_success:
    str     w19, [x21, #NN_OS_EXCEPTION_INFO_OFFSET_EXCEPTION_TYPE]
    add     x0, x21, #NN_OS_EXCEPTION_INFO_OFFSET_DETAIL
    b       _prepare_to_copy_user_exception_info_return

.Lprepare_to_copy_user_exception_info_return_null:
    mov     x0, xzr
    b       _prepare_to_copy_user_exception_info_return


    .size   _ZN2nn2os6detail20UserExceptionHandlerEv, [. - _ZN2nn2os6detail20UserExceptionHandlerEv]

    .bss
    .balign 8
__pout_64:
    .space  8
    .size   __pout_64, [. - __pout_64]

    .bss
    .balign 8
__memory_info:
    .space  NN_SVC_SIZEOF_MEMORY_INFO
    .size   __memory_info, [. - __memory_info]
