﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

#include "os_TlsManagerTypes.h"
#include "os_OsResourceManager.h"

namespace nn { namespace os {
namespace detail {

//---------------------------------------------------------------------------
// TlsManager のインスタンスを取得する
//
inline TlsManager* GetTlsManagerInstance() NN_NOEXCEPT
{
    return &GetOsResourceManagerStorage()->tlsManager;
}


//---------------------------------------------------------------------------

}   // namespace detail
}}  // namespace nn::os

