﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>
#include <nn/svc/svc_Base.h>

#include "os_ThreadManager.h"
#include "os_TimeoutHelper-os.horizon.h"

namespace nn { namespace os { namespace detail {

void TimeoutHelperImplByHorizon::Sleep(TimeSpan time) NN_NOEXCEPT
{
    if (time == TimeSpan(0))
    {
        detail::GetThreadManagerInstance()->YieldThread();
    }
    else
    {
        nn::svc::SleepThread( time.GetNanoSeconds() );
    }
}

}}}  // namespace nn::os::detail

