﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/util/util_TypedStorage.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/os/os_ThreadCommon.h>
#include <nn/os/os_ThreadTypes.h>
#include <nn/os/os_ThreadTypes.private.h>

#include "os_ThreadManagerTypes.h"
#include "os_OsResourceManager.h"

namespace nn { namespace os {
namespace detail {

// 指定可能なコア番号の論理的な最大値（実際のコア数ではない）
const int CoreAffinityMaskBitWidth = sizeof(nn::Bit64) * 8;

//---------------------------------------------------------------------------
// ThreadManager のインスタンスを取得する
inline ThreadManager* GetThreadManagerInstance() NN_NOEXCEPT
{
    return &GetOsResourceManagerStorage()->threadManager;
}

//---------------------------------------------------------------------------
// 現在動作中の ThreadType オブジェクトを返す
inline ThreadType* GetCurrentThread() NN_NOEXCEPT
{
    return GetThreadManagerInstance()->GetCurrentThread();
}

//---------------------------------------------------------------------------

extern void  SetupThreadObjectUnsafe(ThreadType* thread, ThreadFunction function, void* argument, void* stack, size_t stackSize, int priority)  NN_NOEXCEPT;

//---------------------------------------------------------------------------

}  // namespace detail
}} // namespace nn::os

