﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/svc/svc_Base.h>
#include <nn/svc/svc_Types.common.h>
#include <nn/result/result_HandlingUtility.h>

#include "os_RuntimeSupportImpl.h"

namespace nn { namespace os { namespace detail {

//-----------------------------------------------------------------------------

void NotifyDebuggerImpl(nnosNotificationReason reason, uintptr_t data, size_t size) NN_NOEXCEPT
{
    switch (reason)
    {
    case nnosNotificationReason_CppException:
        {
            auto result = static_cast<svc::BreakReason>( svc::BreakReason_CppException | svc::BreakReason_NotificationOnlyFlag );
            svc::Break(result, data, size);
        }
        break;

    default:
        {
            // 何もしない
        }
        break;
    }
}

//-----------------------------------------------------------------------------

void BreakImpl(nnosBreakReason reason, uintptr_t data, size_t size) NN_NOEXCEPT
{
    switch (reason)
    {
    case nnosBreakReason_Panic:
        {
            svc::Break(svc::BreakReason_Panic, data, size);
        }
        break;

    case nnosBreakReason_Assert:
        {
            svc::Break(svc::BreakReason_Assert, data, size);
        }
        break;

    default:
        NN_UNEXPECTED_DEFAULT;
    }
}

//-----------------------------------------------------------------------------

}}} // namespace nn::os::detail

