﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/util/util_TypedStorage.h>

#include "os_Common.h"
#include "os_ThreadManagerTypes.h"
#include "os_TlsManagerTypes.h"
#include "os_TickManagerTypes.h"
#include "os_MemoryHeapManagerTypes.h"
#include "os_StackGuardManagerTypes.h"
#include "os_AslrSpaceManagerTypes.h"
#include "os_RngManagerTypes.h"
#include "os_GiantLockTypes.h"
#include "os_VammManagerTypes.h"

namespace nn { namespace os {
namespace detail {

//---------------------------------------------------------------------------
// 通常の静的オブジェクトとは異なり、OS ライブラリ内のグローバルな
// 静的オブジェクトは全て nnosInitialize() の中からプレースメント new を
// 使って明示的にコンストラクタが呼ばれる。
//
// 呼び出されるコンストラクタは、以下の構造体メンバの配置順である。
//
struct OsResourceManager
{
    // 初期化すべき順で並べる
    RngManager              rngManager;
    AslrSpaceManager        aslrSpaceManager;
    StackGuardManager       stackGuardManager;
    ThreadManager           threadManager;
    TlsManager              tlsManager;
    TickManager             tickManager;
    MemoryHeapManager       memoryHeapManager;
    VammManager             vammManager;
    GiantLock               giantLock;
};

//---------------------------------------------------------------------------

extern util::TypedStorage<OsResourceManager,sizeof(OsResourceManager),NN_ALIGNOF(OsResourceManager)>    g_OsResourceManagerStorage;

inline OsResourceManager* GetOsResourceManagerStorage() NN_NOEXCEPT
{
    return &Get( g_OsResourceManagerStorage );
}

//---------------------------------------------------------------------------

}  // namespace detail
}} // namespace nn::os

