﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/os/os_NativeHandleTypes.h>

#include "os_Common.h"
#include "os_MultipleWaitHolderBase.h"


namespace nn { namespace os {
namespace detail {

//-----------------------------------------------------------------------------
//  NativeHandle 用の MultiWaitHolderBase 派生クラス
//
class MultiWaitHolderOfNativeHandle : public MultiWaitHolderOfNativeWaitObject
{
public:
    explicit MultiWaitHolderOfNativeHandle(NativeHandle handle) NN_NOEXCEPT : m_Handle(NativeHandle(handle)) {}

    virtual TriBool IsSignaled() const NN_NOEXCEPT NN_OVERRIDE;
    virtual bool GetNativeHandle(NativeHandle* pOut) const NN_NOEXCEPT NN_OVERRIDE;

private:
    NativeHandle    m_Handle;
};

//-----------------------------------------------------------------------------

}   // namespace detail
}}  // namespace nn::os

