﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Config.h>
#include <nn/nn_Macro.h>
#include <nn/os/os_NativeHandleTypes.h>
#include <nn/os/os_EventCommon.h>
#include <nn/os/os_InterruptEventCommon.h>
#include <nn/os/os_InterruptEventTypes.h>

#include "os_Common.h"

#if defined(NN_BUILD_CONFIG_OS_WIN32)
    #include "os_InterruptEventImpl-os.win32.h"
#elif defined(NN_BUILD_CONFIG_OS_HORIZON)
    #include "os_InterruptEventImpl-os.horizon.h"
#else
    #error   "未サポートの OS 種別が指定されています。"
#endif

namespace nn { namespace os {
namespace detail {

//--------------------------------------------------------------------------
//  InterruptEventImpl クラス
//

class   InterruptEventImpl
{
public:
    explicit InterruptEventImpl(InterruptName name, EventClearMode clearMode) NN_NOEXCEPT : m_TargetImpl(name, clearMode)  {}

    void Clear() NN_NOEXCEPT
    {
        m_TargetImpl.Clear();
    }

    void Wait() NN_NOEXCEPT
    {
        m_TargetImpl.Wait();
    }

    bool TryWait() NN_NOEXCEPT
    {
        return m_TargetImpl.TryWait();
    }

    bool TimedWait(TimeSpan timeout) NN_NOEXCEPT
    {
        return m_TargetImpl.TimedWait(timeout);
    }

    TriBool IsSignaled() NN_NOEXCEPT
    {
        return m_TargetImpl.IsSignaled();
    }

    NativeHandle GetHandle() const NN_NOEXCEPT
    {
        return m_TargetImpl.GetHandle();
    }

private:
    InterruptEventImplByTarget  m_TargetImpl;
};

}   // namespace detail
}}  // namespace nn::os


