﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "os_Common.h"

#include <nn/nn_Windows.h>
#include <nn/diag/text/diag_SdkTextOs.h>
#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>

#include "os_Diag.h"
#include "os_GiantLock-os.win32.h"

namespace nn { namespace os { namespace detail {

//---------------------------------------------------------------------------

#define NN_OS_GIANT_LOCK_NAME   "NN_OS_SIGLO_GIANT_LOCK"

//--------------------------------------------------------------------------
// コンストラクタ（Win32 Mutex の生成）
GiantLockForWin32::GiantLockForWin32() NN_NOEXCEPT
{
    static_assert(MAX_PATH > sizeof(NN_OS_GIANT_LOCK_NAME), "");

    // Win32 Mutex の生成
    HANDLE mutexHandle = ::CreateMutexA(NULL, FALSE, NN_OS_GIANT_LOCK_NAME);
    NN_SDK_ASSERT( mutexHandle != NULL, NN_TEXT_OS("内部エラー：Win32 Mutex の生成に失敗しました。\n") );

    m_MutexHandle = mutexHandle;
}

//--------------------------------------------------------------------------
// デストラクタ（Win32 Mutex のクローズ）
GiantLockForWin32::~GiantLockForWin32() NN_NOEXCEPT
{
    BOOL ret = ::CloseHandle( m_MutexHandle );
    NN_SDK_ASSERT( ret != 0, NN_TEXT_OS("内部エラー：Win32 Mutex のクローズに失敗しました。"));
    NN_UNUSED(ret);
}

//---------------------------------------------------------------------------

}}} // namespace nn::os::detail

