﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_Macro.h>
#include <nn/svc/svc_Thread.h>
#include <nn/svc/svc_MemoryMapSelect.h>
#include <nn/os/os_Config.h>

#include <nn/svc/svc_Base.h>
#include <nn/svc/svc_Dd.h>
#include <nn/svc/svc_Result.h>
#include <nn/svc/svc_Types.common.h>


namespace nn { namespace os {
namespace detail {

//--------------------------------------------------------------------------

inline bool CheckFreeSpace(uintptr_t address, size_t size)
{
    nn::svc::MemoryInfo memoryInfo;
    nn::svc::PageInfo   pageInfo;

    auto result = nn::svc::QueryMemory(&memoryInfo, &pageInfo, address);
    NN_SDK_ASSERT(result.IsSuccess());
    NN_UNUSED(result);

    if (memoryInfo.state == svc::MemoryState_Free &&
        address + size <= memoryInfo.baseAddress + memoryInfo.size)
    {
        return true;
    }

    return false;
}

//--------------------------------------------------------------------------

}  // namespace detail
}} // namespace nn::os

